/*
 * $Id: conn_at.c,v 1.2 2009-01-28 12:59:19 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "glue-shm.h"

#include "conn_at.h"

#define COMP	"conn_at"

struct cpssp {
	struct sig_boolean_merge *forward__plus_5V;
	struct sig_boolean_merge *forward__minus_5V;
	struct sig_boolean_merge *forward__plus_12V;
	struct sig_boolean_merge *forward__minus_12V;
	struct sig_boolean_merge *forward_gnd;
};

void
conn_at_init(
	unsigned int nr,

	struct sig_power_board_at *port_ext,

	struct sig_boolean *port__plus_5V,
	struct sig_boolean *port__minus_5V,
	struct sig_boolean *port__plus_12V,
	struct sig_boolean *port__minus_12V,
	struct sig_boolean *port_gnd
)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->forward__plus_5V = sig_boolean_merge(
			port_ext->_plus_5V, port__plus_5V);
	cpssp->forward__minus_5V = sig_boolean_merge(
			port_ext->_minus_5V, port__minus_5V);
	cpssp->forward__plus_12V = sig_boolean_merge(
			port_ext->_plus_12V, port__plus_12V);
	cpssp->forward__minus_12V = sig_boolean_merge(
			port_ext->_minus_12V, port__minus_12V);
	cpssp->forward_gnd = sig_boolean_merge(
			port_ext->gnd, port_gnd);
}

unsigned int
conn_at_create(void)
{
	static unsigned int nr = 0;

	shm_create(COMP, nr, sizeof(struct cpssp));

	return nr++;
}

void
conn_at_destroy(unsigned int nr)
{
	shm_destroy(COMP, nr);
}
