/* $Id: isa_gen_vga.c,v 1.57 2009-01-28 12:59:20 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include "fixme.h"
#include <stdio.h>
#include <string.h>

#include "glue-shm.h"

#include "chip_gen_vga.h"
#include "chip_st_M27C512.h"

#include "isa_gen_vga.h"

#define COMP "isa_gen_vga"

struct cpssp {
	unsigned int rom;
	unsigned int chip;
};

void
isa_gen_vga_init(
	unsigned int nr,
	struct sig_isa_bus *port_isa,
	struct sig_vga *port_vga
)
{
	struct cpssp * cpssp;
	struct sig_cs * rom_bus_cs;
	struct sig_isa_bus_main * rom_bus_isa;

	rom_bus_cs = sig_cs_init(COMP "-rom_bus_cs", nr);
	rom_bus_isa = sig_isa_bus_main_init(COMP "-rom_bus_isa", nr);

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	chip_st_M27C512_init(cpssp->rom,
			port_isa->p5V,
			rom_bus_cs,
			rom_bus_isa
	);
	chip_gen_vga_init(cpssp->chip,
			port_isa->p5V,
			port_isa->n_reset,
			port_isa->main,
			port_vga->video,
			rom_bus_cs
	);
}

void
isa_gen_vga_create(unsigned int nr, const char *name)
{
	struct cpssp * cpssp;

	sig_cs_create(COMP "-rom_bus_cs", nr);
	sig_isa_bus_main_create(COMP "-rom_bus_isa", nr);

	shm_create(COMP, nr, sizeof(*cpssp));
	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->rom = chip_st_M27C512_create("vgabios.rom");
	cpssp->chip = chip_gen_vga_create();

	shm_unmap(cpssp, sizeof(*cpssp));
}

void
isa_gen_vga_destroy(unsigned int nr)
{
	struct cpssp * cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	chip_gen_vga_destroy(cpssp->chip);
	chip_st_M27C512_destroy(cpssp->rom);

	shm_unmap(cpssp, sizeof(*cpssp));
	shm_destroy(COMP, nr);

	sig_isa_bus_main_destroy(COMP "-rom_bus_isa", nr);
	sig_cs_destroy(COMP "-rom_bus_cs", nr);
}
