/*
 * $Id: pull_up.c,v 1.5 2009-01-28 12:59:21 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "pull_up.h"

#define CHIP_(x) pull_up_ ## x
#define CHIP "pull_up"

struct cpssp {
	int dummy;
};

void
CHIP_(init)(
	unsigned int nr,
	struct sig_std_logic *port_sig
)
{
	struct cpssp *cpssp;

	cpssp = shm_map(CHIP, nr, sizeof(*cpssp), 0);

	/* Out */
	sig_std_logic_connect_out(port_sig, cpssp, SIG_STD_LOGIC_H);

	/* Call */
	/* In */
}

unsigned int
CHIP_(create)(void)
{
	static unsigned int nr = 0;
	struct cpssp *cpssp;

	shm_create(CHIP, nr, sizeof(*cpssp));
	cpssp = shm_map(CHIP, nr, sizeof(*cpssp), 0);

	shm_unmap(cpssp, sizeof(*cpssp));

	return nr++;
}

void
CHIP_(destroy)(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = shm_map(CHIP, nr, sizeof(*cpssp), 0);

	shm_unmap(cpssp, sizeof(*cpssp));
	shm_destroy(CHIP, nr);
}
