//*@@@+++@@@@******************************************************************
//
// Microsoft Windows Media
// Copyright (C) Microsoft Corporation. All rights reserved.
//
//*@@@---@@@@******************************************************************
/*
 ***********************************************************************
 * Copyright 2005-2010 by Freescale Semiconductor, Inc.
 * All modifications are confidential and proprietary information
 * of Freescale Semiconductor, Inc.
 ***********************************************************************
 */
/* wma_dec_test.c */
/**************************************************************************
 *  CHANGE HISTORY
 *   dd/mm/yy        Code Ver     Description             Author
 *   --------        -------      -----------             ------
 *
 *  05/02/07           0.1	       TLSbo87089             Sukruth
 *								Raw Decoding Support
 **************************************************************************/

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <time.h>


#include <math.h>
#include "wmatypes.h"
#include "wma10_dec_interface.h"

#if defined (__GNUC__)
#include <pthread.h>
#endif

#ifdef TIME_PROFILE
#include <sys/time.h>
#endif

#ifdef MEASURE_STACK_USAGE //TLSbo88602
#include "mm_codec_common.h"
#endif


#if !defined(ARM) &&  !defined(__arm) && !defined(__GNUC__)
#include <io.h>
#include <direct.h>
#include <windows.h>
#include <tchar.h>
#pragma warning ( disable : 4103 )
#endif

//for arm12*************************************
///////////////////////////////////////////////////////////////////////////// //
// Constants
#ifdef _ARM12
#ifndef __WINCE
#ifndef TGT_OS_ELINUX

#define STRING_NUMBER    500
#define N                1000
#define LOG10_N          6
#define N_FORMAT         "%06d"

#define TIMER_BASE	 0x0A800000U
#define TIMER_LOAD	 (TIMER_BASE + 0x000U)
#define TIMER_CONTROL    (TIMER_BASE + 0x008U)
#define TIMER_CLEAR      (TIMER_BASE + 0x00CU)
#define TIMER_VALUE	 (0xFFF/2)

#define IRQCT_BASE	 0x0A801000U
#define IRQCT_ENABLESET	 (IRQCT_BASE + 0x008U)
#define IRQCT_ENABLECLR	 (IRQCT_BASE + 0x00CU)

///////////////////////////////////////////////////////////////////////////// //
// File Global Data



// Registers in the peripherals.
static volatile unsigned int * const irq_enable_set = (volatile unsigned int *)IRQCT_ENABLESET;
static volatile unsigned int * const irq_enable_clr = (volatile unsigned int *)IRQCT_ENABLECLR;
static volatile unsigned int * const timer_load     = (volatile unsigned int *)TIMER_LOAD;
static volatile unsigned int * const timer_control  = (volatile unsigned int *)TIMER_CONTROL;
static volatile unsigned int * const timer_clear    = (volatile unsigned int *)TIMER_CLEAR;

#endif //#ifndef TGT_OS_ELINUX
#endif //#ifndef __WINCE
#endif //#ifndef _ARM12
/////////////////////////////////////////////////////////////////////////////

// for arm12 **************************************

//comment out DUMP_WAV define below to output a raw .pcm file rather than a .wav file.
#define DUMP_WAV
#ifdef DUMP_WAV
#include "wavfileexio.h"
#endif  /* DUMP_WAV */
#ifdef ALSA
#include <errno.h>
#include <poll.h>
#include <alsa/asoundlib.h>
#endif
#ifdef ALSA
#define WAKE_UP_LEN 2048
#endif

#ifdef TEST_PERFORMANCE
//Callbacks
 #ifdef ARRAY_INPUT
  #ifdef WMA44K_192KBPS
 #include "wma_array_44k_192kbps.h"
 #define WMA_ARRAY_LEN   431999
  #endif
  #ifdef  WMA48K_128KBPS
 #include "wma_array_48k_128kbps.h"  //288045
 #define WMA_ARRAY_LEN   288045
  #endif
  #ifdef  WMA44K_320KBPS
 #include "wma_array_44k_320kbps.h" //213463
 #define WMA_ARRAY_LEN  213463
  #endif
  #ifdef WMA44K_32KBPS
  #include "wma_array_44k_32kbps.h" //mid rate
  #define WMA_ARRAY_LEN	385957
  #endif
  #ifdef WMA22K_22KBPS
  #include "wma_array_22k_22kbps.h" // low rate
  #define WMA_ARRAY_LEN	269282
  #endif
 #endif
size_t my_fread(void *, size_t, size_t, void *);
int my_fseek(void *, WMAD_INT64, int);
int my_fclose(void *);
long my_ftell(void *);

//For input buffer
typedef struct
{
	int file_size;
	int bytes_read;
	char *buff;
	char *buff_head;
}struct_input_data;
#endif

typedef struct
{
	unsigned char *pBuffer;//[WMA_MAX_DATA_REQUESTED];
	WMAD_UINT32 cbBufferlen;
	WMAD_UINT64 qwBufferOffset;
}callback_buffer;

typedef struct
{
#ifdef TEST_PERFORMANCE
	struct_input_data *input_data;
#else
	FILE *fp;
#endif
	callback_buffer cb_buffer;
}struct_callback;

#define ALIGN			   	4
#define MAX_FILE_SIZE		150000000
/* Functions used in the API */
void CallDecode(WMADDecoderParams *);

#ifdef TEST_PERFORMANCE
char test_case[60*1024*1024] ; //lyon for test
#endif
/***************************************************************************
 *
 *   FUNCTION NAME - alloc_align
 *
 *   DESCRIPTION
 *          This function simulates to allocate memory in the internal
 *          memory. This function when used by the application should
 *          ensure that the memory address returned in always aligned
 *          to long boundry.
 *
 *   ARGUMENTS
 *       size              - Size of the memory requested.
 *
 *   RETURN VALUE
 *       base address of the memory chunck allocated.
 *
 ***************************************************************************/
void* alloc_align (int size)
{
    void* ptr = NULL;
    ptr = malloc (size + ALIGN);
    ptr = (void *)(((long)ptr + (long)(ALIGN-1)) & (long)(~(ALIGN-1)));
    return ptr;
}

#ifdef TEST_SPEED // Not tested defining this
unsigned char *g_pBuffer = NULL;
#else  /* TEST_SPEED */
const unsigned int MAX_BUFSIZE = WMA_MAX_DATA_REQUESTED;
//unsigned char g_pBuffer[WMA_MAX_DATA_REQUESTED];
#endif /* TEST_SPEED */


//WMAD_UINT32 g_cbBuffer = 0;
//WMAD_UINT64 g_qwBufferOffset = 0;

// This should work either with or without TEST_INTERLEAVED_DATA
// TEST_INTERLEAVED_DATA should be more efficient for all platforms except perhaps ARM.
// but some applications want separate right and left channel data returned.
// One should check-in with TEST_INTERLEAVED_DATA defined
// but run appropriate tests both with and without TEST_INTERLEAVED_DATA

// This style is like our sample programs
// should work with any buffer size.  No point in it being larger than 2048.
//#define MAX_SAMPLES 256
//#define MAX_SAMPLES 2048
//#define MAX_SAMPLES 16384
//#define MAX_SAMPLES 4096
#define MAX_SAMPLES 8192
#define TEST_INTERLEAVED_DATA

#if !defined (TEST_INTERLEAVED_DATA)
#   pragma message (__FILE__ "(170) : Warning - Not 24-bit per sample ready!")
#endif

tWMAFileStatus WMAFileCBGetNewPayload(void *state, WMAD_UINT64 offset,
			     WMAD_UINT32 * num_bytes,
			     unsigned char **ppData,
			     void *app_context,
			     WMAD_UINT32 * compress_payload)
{
    tWMAFileStatus ret = cWMA_NoErr;
    WMAD_UINT32 iBytesRead;

    struct_callback *pCallback=(struct_callback *) app_context;
#ifdef TEST_PERFORMANCE
    struct_input_data *input_data = pCallback->input_data;
#else
    FILE *fp = pCallback->fp;
#endif
    U8 *pBuffer = pCallback->cb_buffer.pBuffer;

#ifdef TEST_PERFORMANCE
    iBytesRead = my_fread(pBuffer, 1, *num_bytes , input_data);
#else
    iBytesRead = fread(pBuffer, 1, *num_bytes , fp);
#endif
    pCallback->cb_buffer.cbBufferlen = iBytesRead;
    *ppData = pBuffer;

    if(iBytesRead != *num_bytes)
        ret = cWMA_NoMoreFrames;

    return ret;
}


WMAD_UINT32 WMAFileCBGetInput(void *state, WMAD_UINT64 offset,
			     WMAD_UINT32 * num_bytes,
			     unsigned char **ppData,
			     void *app_context,
			     WMAD_UINT32 * compress_payload)
{
    WMAD_UINT32 ret;

    struct_callback *pCallback=(struct_callback *) app_context;
#ifdef TEST_PERFORMANCE
    struct_input_data *input_data = pCallback->input_data;
#else
    FILE *fp = pCallback->fp;
#endif


#ifdef TEST_SPEED

    if(offset >= g_cbBuffer)
    {
        *ppData = g_pBuffer + g_cbBuffer;
        ret = 0;
    }
    else
    {
        *ppData = g_pBuffer + offset;

        if(offset + *num_bytes > g_cbBuffer)
        {
            ret = g_cbBuffer - offset;
        }
        else
        {
            ret = *num_bytes;
        }
    }

#else  /* TEST_SPEED */

    WMAD_UINT32 cbBufferlen		= pCallback->cb_buffer.cbBufferlen;
    WMAD_UINT64 qwBufferOffset	= pCallback->cb_buffer.qwBufferOffset;
    unsigned char *	pBuffer		= pCallback->cb_buffer.pBuffer;
    WMAD_INT64 iRelativeOffset	= (WMAD_INT64)offset - (WMAD_INT64)qwBufferOffset;
    WMAD_UINT32 iBytesRead;

    // Initialize return values
    *ppData = NULL;
    ret = 0;

    // The ANSI-C function fread seems to do fine with files which are > 4GB,
    // but fseek fails miserably. Therefore, never call fseek unless requested
    // read range is within first 0x7FFFFFFF.

    // Check if start of requested range is within our buffer
    if (iRelativeOffset >= 0 && iRelativeOffset < cbBufferlen)
    {
        if (iRelativeOffset + *num_bytes < cbBufferlen)
        {
            // Entire request is entirely within range of current buffer
            *ppData = pBuffer + iRelativeOffset;
            ret = *num_bytes;
            goto exit;
        }

        // Only the start of request range is in our buffer. Collapse memory.
        memmove(pBuffer, pBuffer + iRelativeOffset,
                (size_t)(cbBufferlen - iRelativeOffset));
        cbBufferlen -= (WMAD_UINT32)iRelativeOffset;
        qwBufferOffset = offset;
    }
    else
    {
        // Start of requested range is outside of our buffer
        if (offset + *num_bytes <= 0x7FFFFFFF)
        {
#ifdef TEST_PERFORMANCE
            if (0 != my_fseek (input_data, (WMAD_UINT32)offset, SEEK_SET))
#else
                if (0 != fseek (fp, (WMAD_UINT32)offset, SEEK_SET))
#endif
                    goto exit;
        }
        else
        {
            // If we reach this point, we can't use fseek

            if (iRelativeOffset < 0)
            {
                // Seeking backwards to > 32-bit offset is not supported
                goto exit;
            }
            // Seek forward to the desired offset.

            iRelativeOffset -= cbBufferlen;
            while (iRelativeOffset > 0)
            {
                WMAD_UINT32 iBytesToRead;


                if (iRelativeOffset > MAX_BUFSIZE)
                    iBytesToRead = MAX_BUFSIZE;
                else
                    iBytesToRead = (WMAD_UINT32)iRelativeOffset;
#ifdef TEST_PERFORMANCE
                iBytesRead = my_fread(pBuffer, 1, iBytesToRead, input_data);
#else
                iBytesRead = fread(pBuffer, 1, iBytesToRead, fp);
#endif
                if (iBytesRead < iBytesToRead)
                {
                    // Reached EOF before reaching requested offset!
                    goto exit;
                }

                iRelativeOffset -= iBytesRead;
            }
        }

        qwBufferOffset = offset;
        cbBufferlen = 0;
    }
#ifdef TEST_PERFORMANCE
    iBytesRead = my_fread(pBuffer + cbBufferlen, 1, MAX_BUFSIZE - cbBufferlen, input_data);
#else
    iBytesRead = fread(pBuffer + cbBufferlen, 1, MAX_BUFSIZE - cbBufferlen, fp);
#endif
    cbBufferlen += iBytesRead;
    *ppData = pBuffer;

    if(cbBufferlen < *num_bytes)
        ret = cbBufferlen;
    else
        ret = *num_bytes;

#endif /* TEST_SPEED */

exit:
    pCallback->cb_buffer.cbBufferlen = cbBufferlen;
    pCallback->cb_buffer.qwBufferOffset= qwBufferOffset;
    return ret;
}


// Not used for now
// need to provide a platform independent fprintf to stderr for wmaudio.c and wmaudio_parse.c
void WMADebugMessage(const char* pszFmt, ... )
{
    va_list vargs;
    va_start(vargs, pszFmt);
    vfprintf(stderr, pszFmt, vargs );
    va_end(vargs);
}

int main(int argc, char *argv[])
{
    WMARESULT hr = 1; // assume error
    WMADDecoderParams  sDecParams;

//------------------------
#ifndef UNDER_CE
#ifndef TGT_OS_ELINUX
	argc = 3;
	argv[1] = "test.wma";
	argv[2] = "test.wav";
#endif
#endif
//------------------------
    if (argc < 3)
    {
        fprintf(stderr, "** Too few arguments.\n");
        exit(1);
    }

    memset((void *)(&sDecParams), 0, sizeof(sDecParams));

    sDecParams.pus8input_file = argv[1];
    sDecParams.pus8output_file = argv[2];

    //init decoder parameters
    sDecParams.bDropPacket = 0;
    sDecParams.nDRCSetting = 0;
    sDecParams.nDecoderFlags = 0;
    sDecParams.nDstChannelMask = 0;
    sDecParams.nInterpResampRate = 0;
    sDecParams.nMBRTargetStream = 1;

    sDecParams.bIsRawDecoder = WMAD_FALSE;

    //sDecParams.bIsRawDecoder = WMAD_TRUE;
    //combined_32_16_2_24000_off_0_overlay_0_30.wma
    /*sDecParams.us16Version = 3;
    sDecParams.us16Channels = 2;
    sDecParams.us32SamplesPerSec = 0x7d00;
    sDecParams.us32AvgBytesPerSec = 0xbb8;
    sDecParams.us32ValidBitsPerSample = 0x10;
    sDecParams.us16EncodeOpt = 0x60;
    sDecParams.us16wFormatTag = 0x162;
    sDecParams.us32AdvancedEncodeOpt2 = 0x0;
    sDecParams.us32nBlockAlign = 0x480;
    sDecParams.us32ChannelMask = 0x3;
    sDecParams.us32Duration = 0x0;
    sDecParams.bHas_DRM = 0;
    */
    // init parameter for raw decoder
    //StereoMusic_44kHz_320kbps.raw
    //sDecParams.us16Version = 2;
    //sDecParams.us16Channels = 2;
    //sDecParams.us32SamplesPerSec = 0xac44;
    //sDecParams.us32AvgBytesPerSec = 0x9c41;
    //sDecParams.us32ValidBitsPerSample = 0x10;
    //sDecParams.us16EncodeOpt = 0xf;
    //sDecParams.us16wFormatTag = 0x161;
    //sDecParams.us32nBlockAlign = 0x3a0d;
    //sDecParams.us32ChannelMask = 0x0;
    //sDecParams.us32Duration = 0;
    //sDecParams.bHas_DRM = 0;

    //jazzshort_48_24_2_256000_1_29.raw
    //sDecParams.us16Version = 3;
    //sDecParams.us16Channels = 2;
    //sDecParams.us32SamplesPerSec = 0xbb80;
    //sDecParams.us32AvgBytesPerSec = 0x7d01;
    //sDecParams.us32ValidBitsPerSample = 0x18;
    //sDecParams.us16EncodeOpt = 0xe0;
    //sDecParams.us16wFormatTag = 0x162;
    //sDecParams.us32nBlockAlign = 0x2aab;
    //sDecParams.us32ChannelMask = 0x0;
    //sDecParams.us32Duration = 0;
    //sDecParams.bHas_DRM = 0;

    //game_48_16_2_96000_v3r_0_extend_1_29.raw
    //sDecParams.us16Version = 3;
    //sDecParams.us16wFormatTag = 0x162;
    //sDecParams.us16Channels = 0x2;
    //sDecParams.us32SamplesPerSec = 0xbb80;
    //sDecParams.us32AvgBytesPerSec = 0x2ee0;
    //sDecParams.us32nBlockAlign = 0x1000;
    //sDecParams.us32ValidBitsPerSample = 0x10;
    //sDecParams.us32ChannelMask = 0x3;
    //sDecParams.us32AdvancedEncodeOpt2 = 0x0;
    //sDecParams.us16EncodeOpt = 0xe0;
    //sDecParams.us16AdvancedEncodeOpt = 0x40c3;
    //sDecParams.us32Duration = 0;
    //sDecParams.bHas_DRM = 0;

    //Game_96_24_8_768000_0_1.wma
    //sDecParams.us16Version = 3;
    //sDecParams.us16wFormatTag = 0x162;
    //sDecParams.us16Channels = 0x8;
    //sDecParams.us32SamplesPerSec = 0x17700;
    //sDecParams.us32AvgBytesPerSec = 0x17700;
    //sDecParams.us32nBlockAlign = 0x8000;
    //sDecParams.us32ValidBitsPerSample = 0x18;
    //sDecParams.us32ChannelMask = 0xff;
    //sDecParams.us32AdvancedEncodeOpt2 = 0x0;
    //sDecParams.us16EncodeOpt = 0xe0;
    //sDecParams.us16AdvancedEncodeOpt = 0x40c3;
    //sDecParams.us32Duration = 0;
    //sDecParams.bHas_DRM = 0;

    {
        // Output the WMA 10 Decoder Version Information.
        printf( "%s \n", WMA10DoderVersionInfo() );
    }

    CallDecode(&sDecParams);

    return 0;
}

void CallDecode(WMADDecoderParams *sDec)
{
    int iRV = 1;    // assume error exit return value

    short int *iOutBuffer;
    int Framenum=0;

    struct_callback *pCallbackStruct=NULL;
    FILE *fp = NULL;
    FILE *fp_performance = NULL;
#ifdef TIME_PROFILE
    struct timeval StartTime, EndTime;
    unsigned long TotalDecTimeUs = 0,MinTime = 0,MaxTime = 0,Minframe = 0,Maxframe = 0,CurDecTimeUs = 0 ,total_samples=0,MaxTime_samples=0;
    int nframe = 0;
    float cur_mcps=0.0;
    unsigned char chname[] = "[PROFILE-INFO]";
#endif

#ifdef MEASURE_STACK_USAGE
    int           *ps32SP, *ps32BaseSP;
    int           s32StackCount, s32StackValue;
    int           s32PeakStack = 0;
#endif

#ifdef MEASURE_HEAP_USAGE
    int      s32TotalMallocBytes=0;
#endif

    WMADDecoderConfig  *psDecConfig;
    WMADMemAllocInfoSub *mem;
    WMAD_INT32 i, nr, j;
    tWMAFileStatus iResult;
    int uFileSize, words_read;
    WMAD_INT32 sample_rate;      /* sampling rate */

#ifdef TIME_PROFILE_RVDS		//TLSbo85204
    int                     prev_clk, curr_clk, total_samples;
    long int		    total_clk;
    int                     clk, max_sf;
    int                     Maxframe , Minframe;
    float                   cur_mcps, max_mcps, min_mcps, avg_mcps;
    int			    nframe = 0;
    unsigned char			chname[] = "[PROFILE-INFO]";   //TLSbo85204
    extern int prev_cycles(void);
    extern int curr_cycles(void);
    FILE                    *fp_mhz;
#endif
#ifdef ALSA
		snd_pcm_t *playback_handle;
		snd_pcm_hw_params_t *hw_params;
		snd_pcm_sw_params_t *sw_params;
		snd_pcm_sframes_t frames_to_deliver;
		int nfds;
		int err;
		struct pollfd *pfds;
#endif

#ifndef DISCARD_OUTPUT
#ifdef DUMP_WAV
    WavFileIO *pwfioOut = wfioNew ();
    WAVEFORMATEXTENSIBLE wfx;
#else   /* DUMP_WAV */
    FILE *pfOutPCM = NULL;
#endif /* DUMP_WAV */
#endif // !DISCARD_OUTPUT

#ifndef DISCARD_OUTPUT
#ifdef DUMP_WAV
    //Initialize the structure
    memset(&wfx,0,sizeof(wfx));
    sDec->pWfx = &wfx;
#endif
#endif

    // Init Input structures
    psDecConfig = (WMADDecoderConfig *)alloc_align(sizeof(WMADDecoderConfig));
    if (psDecConfig == NULL)
        exit(1);

    pCallbackStruct = (struct_callback *)alloc_align(sizeof(struct_callback));
    if(pCallbackStruct == NULL)
    {
        printf("Error Allocating memory for Callback Structure \n");
        return;
    }
    memset(pCallbackStruct,0,sizeof(pCallbackStruct));

    pCallbackStruct->cb_buffer.cbBufferlen=0;
    pCallbackStruct->cb_buffer.qwBufferOffset=0;

#ifndef TEST_PERFORMANCE // ARM12 TEST PERFORMANCE
    fp = fopen (sDec->pus8input_file, "rb");

    if (fp == NULL)
    {
        fprintf(stderr, "** Cannot open %s.\n", sDec->pus8input_file);
        exit(1);
    }
    pCallbackStruct->fp = fp;
#else
  #ifdef ARRAY_INPUT// arm12 test perforamance
    pCallbackStruct->input_data = (struct_input_data *)alloc_align(sizeof(struct_input_data));
    if(pCallbackStruct->input_data == NULL)
    {
        printf("Error Allocating memory for input file struct \n");
        return;
    }
	pCallbackStruct->input_data->buff = wma_array;
	pCallbackStruct->input_data->buff_head = pCallbackStruct->input_data->buff;
	pCallbackStruct->input_data->file_size =   WMA_ARRAY_LEN ;//288045;  // for 48 k  213463 for 44k;
	pCallbackStruct->input_data->bytes_read = 0;
 #else// arm12 test perforamance
     fp = fopen (sDec->pus8input_file, "rb");
    pCallbackStruct->input_data = (struct_input_data *)alloc_align(sizeof(struct_input_data));
    if(pCallbackStruct->input_data == NULL)
    {
        printf("Error Allocating memory for input file struct \n");
        return;
    }

    pCallbackStruct->input_data->file_size = 0;
    pCallbackStruct->input_data->bytes_read = 0;

    /* find the size of file which is reqired for allocation of
     * app_input_buffer */
      fseek(fp,   0,   SEEK_END);   //end of the file
      pCallbackStruct->input_data->file_size   =   ftell(fp);
#if 0//for arm12 can't alloc such large buffer
    pCallbackStruct->input_data->buff = (char *)alloc_align(sizeof(char)*pCallbackStruct->input_data->file_size);
    if(pCallbackStruct->input_data->buff == NULL)
    {
        printf("Error Allocating memory for input buffer \n");
        exit(1);
    }
#else
	pCallbackStruct->input_data->buff = test_case;
#endif//for arm12 can't alloc such large buffer
    pCallbackStruct->input_data->buff_head = pCallbackStruct->input_data->buff;
    fseek(fp,SEEK_SET,0);
    fread(pCallbackStruct->input_data->buff,sizeof(char),pCallbackStruct->input_data->file_size,fp);
    fclose(fp);
 #endif// arm12 test perforamance

#endif // ARM12 TEST PERFORMANCE

    if(sDec->bIsRawDecoder)
    pCallbackStruct->cb_buffer.pBuffer = (char *)alloc_align(sizeof(char)*sDec->us32nBlockAlign);
    else
    pCallbackStruct->cb_buffer.pBuffer = (char *)alloc_align(sizeof(char)*WMA_MAX_DATA_REQUESTED);

    if(sDec->bIsRawDecoder)
        psDecConfig->app_swap_buf = WMAFileCBGetNewPayload;
    else
    psDecConfig->app_swap_buf = WMAFileCBGetInput;

    psDecConfig->pContext = (void *)pCallbackStruct;
    psDecConfig->sDecodeParams = sDec;


    /* Query for memory */
    if ((iResult = eWMADQueryMem (psDecConfig)) != cWMA_NoErr)
        exit(1);

    /* Number of memory chunk requests by the decoder */
    nr = psDecConfig->sWMADMemInfo.s32NumReqs;
    for(i = 0; i < nr; i++)
    {
        mem = &(psDecConfig->sWMADMemInfo.sMemInfoSub[i]);

        if (mem->s32WMADType == WMAD_FAST_MEMORY)
        {
            mem->app_base_ptr = alloc_align (mem->s32WMADSize);

#ifdef MEASURE_HEAP_USAGE
            s32TotalMallocBytes +=  mem->s32WMADSize;
#endif
            if (mem->app_base_ptr == NULL)
                exit(1);
        }
        else
        {
            mem->app_base_ptr = alloc_align (mem->s32WMADSize);

#ifdef MEASURE_HEAP_USAGE
            s32TotalMallocBytes +=  mem->s32WMADSize;
#endif
            if (mem->app_base_ptr == NULL)
                exit(1);
        }
    }


    printf("\nConverting %s to %s\n",sDec->pus8input_file, sDec->pus8output_file);

    iResult = eInitWMADecoder (psDecConfig, sDec, NULL,0);// The last two parameters are not used, they are kept to maintain the existing interfaces.

    if(iResult != cWMA_NoErr)
    {
        fprintf(stderr, "** Init of WMA decoder is failed.\n");
        exit(1);
    }

    // Output buffer
    iOutBuffer = (short int *) alloc_align (sDec->us32OutputBufSize);
    if(iOutBuffer == NULL)
    {
        fprintf(stderr, "Outbuffer memory allocation failed.\n");
        exit(1);
    }

    printf("++ WMA bitstream version: %d\n", sDec->us16Version);
    printf("++         sampling rate: %ld Hz\n", sDec->us32SamplesPerSec);
    printf("++         # of channels: %d\n", sDec->us16Channels);
    printf("++              bit-rate: %ld bps\n", sDec->us32AvgBytesPerSec);
    printf("++              duration: %ld ms\n", sDec->us32Duration);
    printf("++           DRM content: %s\n", sDec->bHas_DRM ? "Yes" : "No");

    sample_rate = sDec->us32SamplesPerSec;

#ifdef TIME_PROFILE_RVDS
    {
        char file_name[100] = {0};
        char tmp[100] = {0};
        char dot = '.';
        int j = 0;

        strcat (tmp, sDec->pus8output_file);
        while (tmp[j] != '\0')
        {
            if (tmp[j] == dot)
            {
                file_name[j] = '\0';
                strcat (file_name, "_mhz_rvds.txt");
                break;
            }
            file_name[j] = tmp[j];
            j++;
        }

        fp_mhz = fopen (file_name, "a");
        total_clk = 0; total_samples = 0;
        min_mcps = 99999999.0 ; max_mcps = 0.0;
	Maxframe = 0; Minframe = 0;
    }
#endif

#ifndef DISCARD_OUTPUT
#ifdef DUMP_WAV

    if(wfioOpen (pwfioOut, sDec->pus8output_file, &wfx, sizeof(wfx), wfioModeWrite) != 0)
    {
        fprintf(stderr, "Can't create file\n");
        exit(1);
    }
#else   /* DUMP_WAV */
    pfOutPCM = fopen (sDec->pus8output_file, "wb");
    if (pfOutPCM == NULL)
    {
        fprintf(stderr, "** Cannot open output file %s.\n", sDec->pus8output_file);
        exit(1);
    }
#endif // DUMP_WAV
#endif // !DISCARD_OUTPUT
#ifdef ALSA
				if ((err = snd_pcm_open (&playback_handle, "plughw:0,0", SND_PCM_STREAM_PLAYBACK, 0)) < 0) {
					fprintf (stderr, "cannot open audio device %s (%s)\n",
						"plughw:0,0",
						snd_strerror (err));
					exit (1);
				}
				if ((err = snd_pcm_hw_params_malloc (&hw_params)) < 0) {
					fprintf (stderr, "cannot allocate hardware parameter structure (%s)\n",
						snd_strerror (err));
					exit (1);
				}
				if ((err = snd_pcm_hw_params_any (playback_handle, hw_params)) < 0) {
					fprintf (stderr, "cannot initialize hardware parameter structure (%s)\n",
						snd_strerror (err));
					exit (1);
				}
				if ((err = snd_pcm_hw_params_set_access (playback_handle, hw_params, SND_PCM_ACCESS_RW_INTERLEAVED)) < 0) {
					fprintf (stderr, "cannot set access type (%s)\n",
						snd_strerror (err));
					exit (1);
				}
				if ((err = snd_pcm_hw_params_set_format (playback_handle, hw_params, SND_PCM_FORMAT_S16_LE)) < 0) {
					fprintf (stderr, "cannot set sample format (%s)\n",
						snd_strerror (err));
					exit (1);
				}
				if ((err = snd_pcm_hw_params_set_rate_near (playback_handle, hw_params, &sDec->us32SamplesPerSec, 0)) < 0) {
					fprintf (stderr, "cannot set sample rate (%s)\n",
						snd_strerror (err));
					exit (1);
				}
				if ((err = snd_pcm_hw_params_set_channels (playback_handle, hw_params, sDec->us16Channels)) < 0) {
					fprintf (stderr, "cannot set channel count (%s)\n",
						snd_strerror (err));
					exit (1);
				}
				if ((err = snd_pcm_hw_params (playback_handle, hw_params)) < 0) {
					fprintf (stderr, "cannot set parameters (%s)\n",
						snd_strerror (err));
					exit (1);
				}
				snd_pcm_hw_params_free (hw_params);
				/* tell ALSA to wake us up whenever WAKE_UP_LEN or more frames
				of playback data can be delivered. Also, tell
				ALSA that we'll start the device ourselves.
				*/
				if ((err = snd_pcm_sw_params_malloc (&sw_params)) < 0) {
					fprintf (stderr, "cannot allocate software parameters structure (%s)\n",
						snd_strerror (err));
					exit (1);
				}
				if ((err = snd_pcm_sw_params_current (playback_handle, sw_params)) < 0) {
					fprintf (stderr, "cannot initialize software parameters structure (%s)\n",
						snd_strerror (err));
					exit (1);
				}
				if ((err = snd_pcm_sw_params_set_avail_min (playback_handle, sw_params, WAKE_UP_LEN)) < 0) {
					fprintf (stderr, "cannot set minimum available count (%s)\n",
						snd_strerror (err));
					exit (1);
				}
				if ((err = snd_pcm_sw_params_set_start_threshold (playback_handle, sw_params, 0U)) < 0) {
					fprintf (stderr, "cannot set start mode (%s)\n",
						snd_strerror (err));
					exit (1);
				}
				if ((err = snd_pcm_sw_params (playback_handle, sw_params)) < 0) {
					fprintf (stderr, "cannot set software parameters (%s)\n",
						snd_strerror (err));
					exit (1);
				}
				/* the interface will interrupt the kernel every WAKE_UP_LEN frames, and ALSA
				will wake up this program very soon after that.
				*/
				if ((err = snd_pcm_prepare (playback_handle)) < 0) {
					fprintf (stderr, "cannot prepare audio interface for use (%s)\n",
						snd_strerror (err));
					exit (1);
				}

#endif

    /******************** Decode Call -  ***********************/
    do
    {

#ifdef MEASURE_STACK_USAGE
        PAINT_STACK (ps32BaseSP, ps32SP, s32StackCount);
#endif

#ifdef TIME_PROFILE
        gettimeofday(&StartTime, NULL);
#endif
#ifdef TIME_PROFILE_RVDS			 //TLSbo85204

        prev_clk = prev_cycles();

#endif
        iResult = eWMADecodeFrame (psDecConfig, sDec,iOutBuffer,sDec->us32OutputBufSize);

        Framenum++;

	printf("Frame = %d\n", Framenum);
        if(iResult != cWMA_NoErr)
        {
            //wchen: I don't understand why failed is normal
            if ( iResult == cWMA_NoMoreFrames	||
                    iResult == cWMA_Failed			||
                    iResult == cWMA_BrokenFrame )
            {
                iRV = 0;        // normal exit
                break;
            }
            else {
                iRV = 2;        // error decoding data
                fprintf(stderr, "DECODING ERR: decoding failed");
                break;
            }
        }

#ifdef TIME_PROFILE
        gettimeofday(&EndTime, NULL);
        nframe++;
        CurDecTimeUs = (EndTime.tv_usec - StartTime.tv_usec) + (EndTime.tv_sec - StartTime.tv_sec)*1000000L;
	total_samples += sDec->us16NumSamples;
        TotalDecTimeUs += CurDecTimeUs;
        if((CurDecTimeUs > MaxTime)&&(1!=nframe))
        {
	    MaxTime_samples = sDec->us16NumSamples;
            MaxTime = CurDecTimeUs;
            Maxframe = nframe;

        }
#endif
#ifdef TIME_PROFILE_RVDS	//TLSbo85204

        curr_clk = curr_cycles();
        nframe++;
        clk = (curr_clk-prev_clk);
        total_clk = total_clk + clk;
        total_samples += sDec->us16NumSamples;

        cur_mcps = (float)(64.0*(float)clk*(float)sample_rate)/(float)((float)(sDec->us16NumSamples)*1000000.0);

	if(nframe>1)
	{
		if ( cur_mcps > max_mcps)
		{
			max_mcps = cur_mcps;
			Maxframe = nframe;
		}
		if (cur_mcps < min_mcps)
		{
			min_mcps = cur_mcps;
			Minframe = nframe;
		}
	}

#endif

#ifdef MEASURE_STACK_USAGE
        GET_STACK_USAGE (ps32BaseSP, ps32SP, s32StackCount, s32StackValue);
#endif

#ifdef MEASURE_STACK_USAGE
        if (s32PeakStack < s32StackValue)
            s32PeakStack = s32StackValue;
#endif


#ifndef DISCARD_OUTPUT
        if(sDec->us16NumSamples > 0)
        {
#ifdef ALSA

								/* find out how much space is available for playback data */
								if ((frames_to_deliver = snd_pcm_avail_update (playback_handle)) < 0) {
									if (frames_to_deliver == -EPIPE) {
										fprintf (stderr, "an xrun occured\n");
										break;
									} else {
										fprintf (stderr, "unknown ALSA avail update return value (%d)\n",
											frames_to_deliver);
										break;
									}
								}

								frames_to_deliver = frames_to_deliver > sDec->us16NumSamples ? sDec->us16NumSamples : frames_to_deliver;


								/* deliver the data */
								if (snd_pcm_writei (playback_handle, iOutBuffer, frames_to_deliver) != frames_to_deliver) {
									fprintf (stderr, "write failed (%s)\n", snd_strerror (err));
									break;
								}

								/* wait till the interface is ready for data, or 1 second has elapsed. */
								if ((err = snd_pcm_wait (playback_handle, 1000)) < 0)
								{
									fprintf (stderr, "poll failed (%s)\n", strerror (errno));
									break;
								}
#else
#ifdef DUMP_WAV
            wfioWrite (pwfioOut, (WMAD_UINT8*) iOutBuffer, sDec->us16NumSamples * wfx.Format.nChannels * wfx.Format.wBitsPerSample/8);
#else
            fwrite(iOutBuffer, sDec->us32ValidBitsPerSample/8, sDec->us16NumSamples * sDec->us16Channels, pfOutPCM);
#endif
#endif //DUMP_WAV
        }
#endif //!DISCARD_OUTPUT

    } while (1);


    printf("Total Frames : %d\n",Framenum);
#ifdef MEASURE_STACK_USAGE
#ifdef MEASURE_HEAP_USAGE
    printf("PeakStack = %d\t TotalMollocBytes = %d\t \n", s32PeakStack,s32TotalMallocBytes);
#endif
#endif

#ifdef TIME_PROFILE
    fp_performance=fopen("test_result.txt","a+");
    fprintf(fp_performance,"%s\t%d\t%ld\t%ld\t%ld\t%d\t%ld\t%ld\n",sDec->pus8input_file,sDec->us32SamplesPerSec,MaxTime,MaxTime_samples,\
		    Maxframe,Framenum,TotalDecTimeUs,total_samples);
    fclose(fp_performance);
    //printf("Total Decode Time [microseconds] for test case is : %ld uSec \n", TotalDecTimeUs);
#endif
#ifdef TIME_PROFILE_RVDS
    {

        avg_mcps = (float)(64.0*(float)total_clk*(float)sample_rate)/(float)((float)total_samples*1000000.0);

#ifdef MEASURE_STACK_USAGE
#ifdef MEASURE_HEAP_USAGE

        printf("%s\t%s\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t \n",chname,file,sDec->us32SamplesPerSec,(unsigned short)sDec->us32ValidBitsPerSample,\
                WMAD_FRAME_SIZE, max_clk,min_clk,nframe,Maxframe,Minframe,total_clk,s32PeakStack,s32TotalMallocBytes);

        fprintf(fp_mhz,"%s\t%s\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t \n",chname,file,sDec->us32SamplesPerSec,(unsigned short)sDec->us32ValidBitsPerSample,\
                WMAD_FRAME_SIZE, max_clk,min_clk,nframe,Maxframe,Minframe,total_clk,s32PeakStack,s32TotalMallocBytes);
#endif
#endif

#ifndef MEASURE_STACK_USAGE
#ifndef MEASURE_HEAP_USAGE

        printf("Avg MCPS: %f\n", avg_mcps);
        printf("Max MCPS: %f in Frame: %d\n", max_mcps, Maxframe);
        printf("Min MCPS: %f in Frame: %d\n", min_mcps, Minframe);

        fprintf(fp_mhz,"Avg MCPS: %f\n", avg_mcps);
        fprintf(fp_mhz,"Max MCPS: %f in Frame: %d\n", max_mcps, Maxframe);
        fprintf(fp_mhz,"Min MCPS: %f in Frame: %d\n", min_mcps, Minframe);

#endif
#endif



        if(fp_mhz) { fclose (fp_mhz); fp_mhz=0;}

    }

    //tlsbo85204

#endif


    printf("Done..........\n\n\n ");

    /* clean up */

#ifdef TEST_PERFORMANCE
    if(pCallbackStruct->input_data->buff_head)
    {
        free(pCallbackStruct->input_data->buff_head);
        pCallbackStruct->input_data->buff_head = NULL;
    }

    if(pCallbackStruct->input_data)
    {
        free(pCallbackStruct->input_data);
        pCallbackStruct->input_data = NULL;
    }
#else
    fclose(fp);
#endif
    if(pCallbackStruct->cb_buffer.pBuffer)
    {
        fflush (stdout);
        free(pCallbackStruct->cb_buffer.pBuffer);
        pCallbackStruct->cb_buffer.pBuffer = NULL;
    }

    if(pCallbackStruct)
    {
        free(pCallbackStruct);
    }

    if(iOutBuffer)
    {
        free(iOutBuffer);
    }

    for (i = 0; i < nr; i++)
    {
        if(psDecConfig->sWMADMemInfo.sMemInfoSub[i].app_base_ptr)
        {
            free (psDecConfig->sWMADMemInfo.sMemInfoSub[i].app_base_ptr);
        }
    }

    if(psDecConfig)
    {
        free (psDecConfig);
    }
#ifdef ALSA
		snd_pcm_close (playback_handle);
#endif

#ifndef DISCARD_OUTPUT
#ifdef DUMP_WAV
    if (pwfioOut)
    {
        wfioClose(pwfioOut);
        wfioDelete (pwfioOut);
    }
#else   /* DUMP_WAV */
    if (pfOutPCM) {
        fclose (pfOutPCM);
        pfOutPCM = NULL;
    }
#endif // DUMP_WAV
#endif // !DISCARD_OUTPUT
}

#ifdef TEST_PERFORMANCE
size_t my_fread(void *buff, size_t unit, size_t size, void *fp)
{
	int bytes_read;
	struct_input_data *input_data=(struct_input_data *)fp;

	bytes_read = unit*size;

	if(bytes_read+input_data->bytes_read<=input_data->file_size)
	{
		memcpy(buff,input_data->buff,bytes_read);
		input_data->bytes_read += bytes_read;
		input_data->buff += bytes_read;
	}
	else if(input_data->file_size-input_data->bytes_read<bytes_read)
	{
		bytes_read = input_data->file_size-input_data->bytes_read;
		memcpy(buff,input_data->buff,bytes_read);
		input_data->bytes_read += bytes_read;
		input_data->buff += bytes_read;
	}
	return bytes_read;
}

int my_fseek(void *fp, WMAD_INT64 unit, int size)
{
	int bytes_read = (int)(unit+size);
	struct_input_data *input_data=(struct_input_data *)fp;
	if(bytes_read==1)
	{
		input_data->bytes_read = 0;
		input_data->buff = input_data->buff_head;
	}
	else
	{
		input_data->bytes_read = bytes_read;
		input_data->buff = input_data->buff_head+bytes_read;
	}
	return 0;
}

int my_fclose(void *fp)
{
	struct_input_data *input_data=(struct_input_data *)fp;
	free(input_data->buff_head);
	free(fp);
	return 0;
}

long my_ftell(void *fp)
{
	struct_input_data *input_data=(struct_input_data *)fp;
	return input_data->bytes_read;
}

#endif //TEST_PERFORMANCE

#ifdef __WINCE
#define NAME_SIZE 255
int _tmain(int argc,_TCHAR *argv[])
{

    char* argv_char[NAME_SIZE];
    int argc_size,i;

    for(i=0;i < argc; i++)
    {
        argv_char[i] = (char *) malloc(sizeof(char)*NAME_SIZE);
        argc_size=wcstombs(argv_char[i],argv[i],NAME_SIZE);
    }
    main(argc,argv_char);

    for(i=0;i < argc; i++)
    {
        free(argv_char[i]);
        argv_char[i]=NULL;
    }
    return 0;
}
#endif

#ifdef _ARM12
#ifndef __WINCE
#ifndef TGT_OS_ELINUX
__irq void IRQ_Handler(void)    	//for arm12
{


   *timer_clear	= 1;
   *irq_enable_clr = 0x02;
   *irq_enable_set = 0x02;
}
#endif
#endif
#endif



// Some compile time warning messages
#ifndef PLATFORM_SPECIFIC_COMPILER_MESSAGE
#   define COMPILER_MESSAGE(x)         message(x)
#endif
#ifdef MEASURE_CLOCK
#   pragma COMPILER_MESSAGE(__FILE__ "(927) : Warning - MEASURE_CLOCK Enabled.")
#endif
#ifdef PROFILE
#   pragma COMPILER_MESSAGE(__FILE__ "(930) : Warning - PROFILE Enabled.")
#endif
#ifdef DISCARD_OUTPUT
#   pragma COMPILER_MESSAGE(__FILE__ "(933) : Warning - DISCARD_OUTPUT Enabled.")
#endif
#ifdef OBNOXIOUS
#   pragma COMPILER_MESSAGE(__FILE__ "(936) : Warning - OBNOXIOUS tests Enabled.")
#endif
#ifdef REAL_OBNOXIOUS
#   pragma COMPILER_MESSAGE(__FILE__ "(939) : Warning - REAL OBNOXIOUS tests Enabled - output will be incorrect.")
#endif

