/**
 *  Copyright (c) 2010, Freescale Semiconductors Inc.,
 *  All Rights Reserved.
 *
 *  The following programs are the sole property of Freescale Semiconductors Inc.,
 *  and contain its proprietary and confidential information.
 *
 */

/**
 *  @file AacCoreParser.h
 *  @brief AAC core parser.
 *  @ingroup AacCoreParser
 */


#ifndef AacCoreParser_h
#define AacCoreParser_h

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "AudioCoreParser.h"
#include "aacd_dec_interface.h"

typedef enum {
    FILETYPEADTS,
    FILETYPEADIF,
    FILETYPERAW
}AAC_FILETYPE;

typedef enum {
    AAC_PARSERRETURNSUCESS,
    AAC_PARSERRETURNFAIL
}AAC_PARSERRETURNTYPE;

enum {
  FLAG_SUCCESS,
  FLAG_NEEDMORE_DATA
};

AAC_FILETYPE Aac_FindFileType(uint8 *pBuffer, int32 nBufferLen);
FRAME_INFO ParserADTS(AACD_Block_Params *params, uint8 *pBuffer, uint32 nBufferLen, FRAME_INFO *in_info);
FRAME_INFO ParserADIF(AACD_Block_Params *params, uint8 *pBuffer, int32 nBufferLen);
AAC_PARSERRETURNTYPE AacDec_InitRaw(AACD_Block_Params *params, int32 nChannels, int32 nSamplingFreq);

AUDIO_PARSERRETURNTYPE AacParserFileHeader(AUDIO_FILE_INFO *pFileInfo, uint8 *pBuffer, \
 										uint32 nBufferLen);
AUDIO_PARSERRETURNTYPE AacParserFrame(AUDIO_FRAME_INFO *pFrameInfo, uint8 *pBuffer, \
										uint32 nBufferLen);
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
/* File EOF */
