-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/cfg/string_builder.ads,v $
--  Description     : Simple string builder package                          --
--  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>             --
--  Created On      : 22-Mar-2004                                            --
--  Last Modified By: $Author: merdmann $                                    --
--  Last Modified On: $Date: 2004/03/22 20:32:17 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2004 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--                                                                           --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--                                                                           --
--  References                                                               --
--  ==========                                                               --
--  None                                                                     --
--                                                                           --
-------------------------------------------------------------------------------

package String_Builder is

   type Object is private;

   ---------------------------------------------------------------------------
   -- Description:
   --    Convert buffer to string
   -- Preconditions:
   --    None
   -- Postconditions:
   --    None
   -- Exceptions:
   --    None
   -- Notes:
   --    None
   ---------------------------------------------------------------------------
   function To_String(
      This : in Object ) return String;

   ---------------------------------------------------------------------------
   -- Description:
   --
   -- Preconditions:
   --    None
   -- Postconditions:
   --    None
   -- Exceptions:
   --    None
   -- Notes:
   --    None
   ---------------------------------------------------------------------------
   procedure Clear(
      This : in out Object);

   ---------------------------------------------------------------------------
   -- Description:
   --    Convert buffer to string
   -- Preconditions:
   --    None
   -- Postconditions:
   --    None
   -- Exceptions:
   --    None
   -- Notes:
   --    None
   ---------------------------------------------------------------------------
   procedure Insert(
      This : in out Object; Char : in Character );

   ---------------------------------------------------------------------------
   -- Description:
   --    Convert buffer to string
   -- Preconditions:
   --    None
   -- Postconditions:
   --    None
   -- Exceptions:
   --    None
   -- Notes:
   --    None
   ---------------------------------------------------------------------------
   procedure Insert(
      This : in out Object; Str  : in String );

   ---------------------------------------------------------------------------
   -- Description:
   --    Convert buffer to string
   -- Preconditions:
   --    None
   -- Postconditions:
   --    None
   -- Exceptions:
   --    None
   -- Notes:
   --    None
   ---------------------------------------------------------------------------
   procedure Finalize(
      This : in out Object );

private

   type Object_Data_Type;
   type Object_Data_Access is access Object_Data_Type;

   function Initialize return Object_Data_Access;

   type Object is record
      Data : Object_Data_Access := Initialize;
   end record;

end String_Builder;
