------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: dyn_def.adb,v 1.6 2004/06/28 04:57:06 vagul Exp $

--  Example of using dynamically allocated define variables.

with OCI.Thick.Connections;
with OCI.Thick.Statements;
with OCI.Thick.Parameters;
with Ada.Text_IO;
with OCI.Thick.Strings;

procedure Dyn_Def is
   use Ada.Text_IO;
   use OCI.Thick;
   use OCI.Thick.Connections;
   use OCI.Thick.Statements;
   use OCI.Thick.Strings;

   Connect : Connection := Logon ("scott/tiger");
   Sel : Statement := Prepare (Connect,
                               "select * from emp");

begin
   Execute (Sel);

   declare
      use OCI.Thick.Parameters;
      Params : Parameter_Array := Get_Parameters (Sel);
      Result : array (Params'Range) of Variable;
   begin
      for i in Params'Range loop
         Put (Name (Params (i)) & ASCII.HT);
         Put (Type_Name (Params (i)));
         Put (SQL_Type'Image (Get_SQL_Type (Params (i))));
         Put (Natural'Image (Data_Size (Params (i))));
         Put (Integer'Image (Precision (Params (i))));
         Put (Integer'Image (Scale (Params (i))) & ASCII.HT);
         Put (Boolean'Image (Is_Null (Params (i))));
         Put_Line (Schema_Name (Params (i)));
         Define (Sel, Result (i), i);
      end loop;

      Put_Line ("Fetch");

      while Fetch (Sel) loop
         Put (Integer'Image (Rows_Processed (Sel)) & ". ");

         for i in Result'Range loop
            if Is_Null (Result (i)) then
               Put ("(null)");
            else
               Put (Value (Result (i)));
            end if;

            Put ("; ");
         end loop;

         New_Line;
      end loop;
   end;

   Put_Line ("Done.");
end Dyn_Def;
