# -*- makefile -*-
# Generated by genmk.rb, please don't edit!

GRUB_KERNEL_MACHINE_LINK_ADDR = 0x8200

COMMON_ASFLAGS = -nostdinc -fno-builtin -m32
COMMON_CFLAGS = -fno-builtin -mrtd -mregparm=3 -m32
COMMON_LDFLAGS = -m32 -nostdlib

# Used by various components.  These rules need to precede them.
script/sh/lexer.c_DEPENDENCIES = grub_script.tab.h

# Images.
pkglib_IMAGES = boot.img cdboot.img diskboot.img kernel.img lnxboot.img \
	pxeboot.img

# For boot.img.
boot_img_SOURCES = boot/i386/pc/boot.S

clean-image-boot.img.1:
	rm -f boot.img boot.exec boot_img-boot_i386_pc_boot.o

CLEAN_IMAGE_TARGETS += clean-image-boot.img.1

mostlyclean-image-boot.img.1:
	rm -f boot_img-boot_i386_pc_boot.d

MOSTLYCLEAN_IMAGE_TARGETS += mostlyclean-image-boot.img.1

ifneq ($(TARGET_APPLE_CC),1)
boot.img: boot.exec
	$(OBJCOPY) -O $(boot_img_FORMAT) --strip-unneeded -R .note -R .comment -R .note.gnu.build-id $< $@
else
ifneq (boot.exec,kernel.exec)
boot.img: boot.exec ./grub-macho2img
	./grub-macho2img $< $@
else
boot.img: boot.exec ./grub-macho2img
	./grub-macho2img --bss $< $@
endif
endif

boot.exec: boot_img-boot_i386_pc_boot.o
	$(TARGET_CC) -o $@ $^ $(TARGET_LDFLAGS) $(boot_img_LDFLAGS)

boot_img-boot_i386_pc_boot.o: boot/i386/pc/boot.S $(boot/i386/pc/boot.S_DEPENDENCIES)
	$(TARGET_CC) -Iboot/i386/pc -I$(srcdir)/boot/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(boot_img_ASFLAGS) -MD -c -o $@ $<
-include boot_img-boot_i386_pc_boot.d

boot_img_ASFLAGS = $(COMMON_ASFLAGS)
boot_img_LDFLAGS = $(COMMON_LDFLAGS) $(TARGET_IMG_LDFLAGS)7C00
boot_img_FORMAT = binary

# For pxeboot.img
pxeboot_img_SOURCES = boot/i386/pc/pxeboot.S

clean-image-pxeboot.img.1:
	rm -f pxeboot.img pxeboot.exec pxeboot_img-boot_i386_pc_pxeboot.o

CLEAN_IMAGE_TARGETS += clean-image-pxeboot.img.1

mostlyclean-image-pxeboot.img.1:
	rm -f pxeboot_img-boot_i386_pc_pxeboot.d

MOSTLYCLEAN_IMAGE_TARGETS += mostlyclean-image-pxeboot.img.1

ifneq ($(TARGET_APPLE_CC),1)
pxeboot.img: pxeboot.exec
	$(OBJCOPY) -O $(pxeboot_img_FORMAT) --strip-unneeded -R .note -R .comment -R .note.gnu.build-id $< $@
else
ifneq (pxeboot.exec,kernel.exec)
pxeboot.img: pxeboot.exec ./grub-macho2img
	./grub-macho2img $< $@
else
pxeboot.img: pxeboot.exec ./grub-macho2img
	./grub-macho2img --bss $< $@
endif
endif

pxeboot.exec: pxeboot_img-boot_i386_pc_pxeboot.o
	$(TARGET_CC) -o $@ $^ $(TARGET_LDFLAGS) $(pxeboot_img_LDFLAGS)

pxeboot_img-boot_i386_pc_pxeboot.o: boot/i386/pc/pxeboot.S $(boot/i386/pc/pxeboot.S_DEPENDENCIES)
	$(TARGET_CC) -Iboot/i386/pc -I$(srcdir)/boot/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(pxeboot_img_ASFLAGS) -MD -c -o $@ $<
-include pxeboot_img-boot_i386_pc_pxeboot.d

pxeboot_img_ASFLAGS = $(COMMON_ASFLAGS)
pxeboot_img_LDFLAGS = $(COMMON_LDFLAGS) $(TARGET_IMG_LDFLAGS)7C00
pxeboot_img_FORMAT = binary

# For diskboot.img.
diskboot_img_SOURCES = boot/i386/pc/diskboot.S

clean-image-diskboot.img.1:
	rm -f diskboot.img diskboot.exec diskboot_img-boot_i386_pc_diskboot.o

CLEAN_IMAGE_TARGETS += clean-image-diskboot.img.1

mostlyclean-image-diskboot.img.1:
	rm -f diskboot_img-boot_i386_pc_diskboot.d

MOSTLYCLEAN_IMAGE_TARGETS += mostlyclean-image-diskboot.img.1

ifneq ($(TARGET_APPLE_CC),1)
diskboot.img: diskboot.exec
	$(OBJCOPY) -O $(diskboot_img_FORMAT) --strip-unneeded -R .note -R .comment -R .note.gnu.build-id $< $@
else
ifneq (diskboot.exec,kernel.exec)
diskboot.img: diskboot.exec ./grub-macho2img
	./grub-macho2img $< $@
else
diskboot.img: diskboot.exec ./grub-macho2img
	./grub-macho2img --bss $< $@
endif
endif

diskboot.exec: diskboot_img-boot_i386_pc_diskboot.o
	$(TARGET_CC) -o $@ $^ $(TARGET_LDFLAGS) $(diskboot_img_LDFLAGS)

diskboot_img-boot_i386_pc_diskboot.o: boot/i386/pc/diskboot.S $(boot/i386/pc/diskboot.S_DEPENDENCIES)
	$(TARGET_CC) -Iboot/i386/pc -I$(srcdir)/boot/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(diskboot_img_ASFLAGS) -MD -c -o $@ $<
-include diskboot_img-boot_i386_pc_diskboot.d

diskboot_img_ASFLAGS = $(COMMON_ASFLAGS)
diskboot_img_LDFLAGS = $(COMMON_LDFLAGS) $(TARGET_IMG_LDFLAGS)8000
diskboot_img_FORMAT = binary

# For lnxboot.img.
lnxboot_img_SOURCES = boot/i386/pc/lnxboot.S

clean-image-lnxboot.img.1:
	rm -f lnxboot.img lnxboot.exec lnxboot_img-boot_i386_pc_lnxboot.o

CLEAN_IMAGE_TARGETS += clean-image-lnxboot.img.1

mostlyclean-image-lnxboot.img.1:
	rm -f lnxboot_img-boot_i386_pc_lnxboot.d

MOSTLYCLEAN_IMAGE_TARGETS += mostlyclean-image-lnxboot.img.1

ifneq ($(TARGET_APPLE_CC),1)
lnxboot.img: lnxboot.exec
	$(OBJCOPY) -O $(lnxboot_img_FORMAT) --strip-unneeded -R .note -R .comment -R .note.gnu.build-id $< $@
else
ifneq (lnxboot.exec,kernel.exec)
lnxboot.img: lnxboot.exec ./grub-macho2img
	./grub-macho2img $< $@
else
lnxboot.img: lnxboot.exec ./grub-macho2img
	./grub-macho2img --bss $< $@
endif
endif

lnxboot.exec: lnxboot_img-boot_i386_pc_lnxboot.o
	$(TARGET_CC) -o $@ $^ $(TARGET_LDFLAGS) $(lnxboot_img_LDFLAGS)

lnxboot_img-boot_i386_pc_lnxboot.o: boot/i386/pc/lnxboot.S $(boot/i386/pc/lnxboot.S_DEPENDENCIES)
	$(TARGET_CC) -Iboot/i386/pc -I$(srcdir)/boot/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(lnxboot_img_ASFLAGS) -MD -c -o $@ $<
-include lnxboot_img-boot_i386_pc_lnxboot.d

lnxboot_img_ASFLAGS = $(COMMON_ASFLAGS)
lnxboot_img_LDFLAGS = $(COMMON_LDFLAGS) $(TARGET_IMG_LDFLAGS)6000
lnxboot_img_FORMAT = binary

# For cdboot.img.
cdboot_img_SOURCES = boot/i386/pc/cdboot.S

clean-image-cdboot.img.1:
	rm -f cdboot.img cdboot.exec cdboot_img-boot_i386_pc_cdboot.o

CLEAN_IMAGE_TARGETS += clean-image-cdboot.img.1

mostlyclean-image-cdboot.img.1:
	rm -f cdboot_img-boot_i386_pc_cdboot.d

MOSTLYCLEAN_IMAGE_TARGETS += mostlyclean-image-cdboot.img.1

ifneq ($(TARGET_APPLE_CC),1)
cdboot.img: cdboot.exec
	$(OBJCOPY) -O $(cdboot_img_FORMAT) --strip-unneeded -R .note -R .comment -R .note.gnu.build-id $< $@
else
ifneq (cdboot.exec,kernel.exec)
cdboot.img: cdboot.exec ./grub-macho2img
	./grub-macho2img $< $@
else
cdboot.img: cdboot.exec ./grub-macho2img
	./grub-macho2img --bss $< $@
endif
endif

cdboot.exec: cdboot_img-boot_i386_pc_cdboot.o
	$(TARGET_CC) -o $@ $^ $(TARGET_LDFLAGS) $(cdboot_img_LDFLAGS)

cdboot_img-boot_i386_pc_cdboot.o: boot/i386/pc/cdboot.S $(boot/i386/pc/cdboot.S_DEPENDENCIES)
	$(TARGET_CC) -Iboot/i386/pc -I$(srcdir)/boot/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(cdboot_img_ASFLAGS) -MD -c -o $@ $<
-include cdboot_img-boot_i386_pc_cdboot.d

cdboot_img_ASFLAGS = $(COMMON_ASFLAGS)
cdboot_img_LDFLAGS = $(COMMON_LDFLAGS) $(TARGET_IMG_LDFLAGS)7C00
cdboot_img_FORMAT = binary

# For kernel.img.
kernel_img_SOURCES = kern/i386/pc/startup.S \
	kern/i386/misc.S \
	kern/main.c kern/device.c \
	kern/disk.c kern/dl.c kern/file.c kern/fs.c kern/err.c \
	kern/misc.c kern/mm.c kern/reader.c kern/term.c \
	kern/rescue_parser.c kern/rescue_reader.c \
	kern/time.c kern/list.c kern/handler.c kern/command.c kern/corecmd.c \
	kern/$(target_cpu)/dl.c kern/i386/pc/init.c kern/i386/pc/mmap.c \
	kern/parser.c kern/partition.c \
	kern/i386/tsc.c kern/i386/pit.c \
	kern/generic/rtc_get_time_ms.c \
	kern/generic/millisleep.c \
	kern/env.c \
	term/i386/pc/console.c term/i386/vga_common.c \
	symlist.c

clean-image-kernel.img.1:
	rm -f kernel.img kernel.exec kernel_img-kern_i386_pc_startup.o kernel_img-kern_i386_misc.o kernel_img-kern_main.o kernel_img-kern_device.o kernel_img-kern_disk.o kernel_img-kern_dl.o kernel_img-kern_file.o kernel_img-kern_fs.o kernel_img-kern_err.o kernel_img-kern_misc.o kernel_img-kern_mm.o kernel_img-kern_reader.o kernel_img-kern_term.o kernel_img-kern_rescue_parser.o kernel_img-kern_rescue_reader.o kernel_img-kern_time.o kernel_img-kern_list.o kernel_img-kern_handler.o kernel_img-kern_command.o kernel_img-kern_corecmd.o kernel_img-kern___target_cpu__dl.o kernel_img-kern_i386_pc_init.o kernel_img-kern_i386_pc_mmap.o kernel_img-kern_parser.o kernel_img-kern_partition.o kernel_img-kern_i386_tsc.o kernel_img-kern_i386_pit.o kernel_img-kern_generic_rtc_get_time_ms.o kernel_img-kern_generic_millisleep.o kernel_img-kern_env.o kernel_img-term_i386_pc_console.o kernel_img-term_i386_vga_common.o kernel_img-symlist.o

CLEAN_IMAGE_TARGETS += clean-image-kernel.img.1

mostlyclean-image-kernel.img.1:
	rm -f kernel_img-kern_i386_pc_startup.d kernel_img-kern_i386_misc.d kernel_img-kern_main.d kernel_img-kern_device.d kernel_img-kern_disk.d kernel_img-kern_dl.d kernel_img-kern_file.d kernel_img-kern_fs.d kernel_img-kern_err.d kernel_img-kern_misc.d kernel_img-kern_mm.d kernel_img-kern_reader.d kernel_img-kern_term.d kernel_img-kern_rescue_parser.d kernel_img-kern_rescue_reader.d kernel_img-kern_time.d kernel_img-kern_list.d kernel_img-kern_handler.d kernel_img-kern_command.d kernel_img-kern_corecmd.d kernel_img-kern___target_cpu__dl.d kernel_img-kern_i386_pc_init.d kernel_img-kern_i386_pc_mmap.d kernel_img-kern_parser.d kernel_img-kern_partition.d kernel_img-kern_i386_tsc.d kernel_img-kern_i386_pit.d kernel_img-kern_generic_rtc_get_time_ms.d kernel_img-kern_generic_millisleep.d kernel_img-kern_env.d kernel_img-term_i386_pc_console.d kernel_img-term_i386_vga_common.d kernel_img-symlist.d

MOSTLYCLEAN_IMAGE_TARGETS += mostlyclean-image-kernel.img.1

ifneq ($(TARGET_APPLE_CC),1)
kernel.img: kernel.exec
	$(OBJCOPY) -O $(kernel_img_FORMAT) --strip-unneeded -R .note -R .comment -R .note.gnu.build-id $< $@
else
ifneq (kernel.exec,kernel.exec)
kernel.img: kernel.exec ./grub-macho2img
	./grub-macho2img $< $@
else
kernel.img: kernel.exec ./grub-macho2img
	./grub-macho2img --bss $< $@
endif
endif

kernel.exec: kernel_img-kern_i386_pc_startup.o kernel_img-kern_i386_misc.o kernel_img-kern_main.o kernel_img-kern_device.o kernel_img-kern_disk.o kernel_img-kern_dl.o kernel_img-kern_file.o kernel_img-kern_fs.o kernel_img-kern_err.o kernel_img-kern_misc.o kernel_img-kern_mm.o kernel_img-kern_reader.o kernel_img-kern_term.o kernel_img-kern_rescue_parser.o kernel_img-kern_rescue_reader.o kernel_img-kern_time.o kernel_img-kern_list.o kernel_img-kern_handler.o kernel_img-kern_command.o kernel_img-kern_corecmd.o kernel_img-kern___target_cpu__dl.o kernel_img-kern_i386_pc_init.o kernel_img-kern_i386_pc_mmap.o kernel_img-kern_parser.o kernel_img-kern_partition.o kernel_img-kern_i386_tsc.o kernel_img-kern_i386_pit.o kernel_img-kern_generic_rtc_get_time_ms.o kernel_img-kern_generic_millisleep.o kernel_img-kern_env.o kernel_img-term_i386_pc_console.o kernel_img-term_i386_vga_common.o kernel_img-symlist.o
	$(TARGET_CC) -o $@ $^ $(TARGET_LDFLAGS) $(kernel_img_LDFLAGS)

kernel_img-kern_i386_pc_startup.o: kern/i386/pc/startup.S $(kern/i386/pc/startup.S_DEPENDENCIES)
	$(TARGET_CC) -Ikern/i386/pc -I$(srcdir)/kern/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(kernel_img_ASFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_i386_pc_startup.d

kernel_img-kern_i386_misc.o: kern/i386/misc.S $(kern/i386/misc.S_DEPENDENCIES)
	$(TARGET_CC) -Ikern/i386 -I$(srcdir)/kern/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(kernel_img_ASFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_i386_misc.d

kernel_img-kern_main.o: kern/main.c $(kern/main.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_main.d

kernel_img-kern_device.o: kern/device.c $(kern/device.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_device.d

kernel_img-kern_disk.o: kern/disk.c $(kern/disk.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_disk.d

kernel_img-kern_dl.o: kern/dl.c $(kern/dl.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_dl.d

kernel_img-kern_file.o: kern/file.c $(kern/file.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_file.d

kernel_img-kern_fs.o: kern/fs.c $(kern/fs.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_fs.d

kernel_img-kern_err.o: kern/err.c $(kern/err.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_err.d

kernel_img-kern_misc.o: kern/misc.c $(kern/misc.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_misc.d

kernel_img-kern_mm.o: kern/mm.c $(kern/mm.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_mm.d

kernel_img-kern_reader.o: kern/reader.c $(kern/reader.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_reader.d

kernel_img-kern_term.o: kern/term.c $(kern/term.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_term.d

kernel_img-kern_rescue_parser.o: kern/rescue_parser.c $(kern/rescue_parser.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_rescue_parser.d

kernel_img-kern_rescue_reader.o: kern/rescue_reader.c $(kern/rescue_reader.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_rescue_reader.d

kernel_img-kern_time.o: kern/time.c $(kern/time.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_time.d

kernel_img-kern_list.o: kern/list.c $(kern/list.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_list.d

kernel_img-kern_handler.o: kern/handler.c $(kern/handler.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_handler.d

kernel_img-kern_command.o: kern/command.c $(kern/command.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_command.d

kernel_img-kern_corecmd.o: kern/corecmd.c $(kern/corecmd.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_corecmd.d

kernel_img-kern___target_cpu__dl.o: kern/$(target_cpu)/dl.c $(kern/$(target_cpu)/dl.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern/$(target_cpu) -I$(srcdir)/kern/$(target_cpu) $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern___target_cpu__dl.d

kernel_img-kern_i386_pc_init.o: kern/i386/pc/init.c $(kern/i386/pc/init.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern/i386/pc -I$(srcdir)/kern/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_i386_pc_init.d

kernel_img-kern_i386_pc_mmap.o: kern/i386/pc/mmap.c $(kern/i386/pc/mmap.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern/i386/pc -I$(srcdir)/kern/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_i386_pc_mmap.d

kernel_img-kern_parser.o: kern/parser.c $(kern/parser.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_parser.d

kernel_img-kern_partition.o: kern/partition.c $(kern/partition.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_partition.d

kernel_img-kern_i386_tsc.o: kern/i386/tsc.c $(kern/i386/tsc.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern/i386 -I$(srcdir)/kern/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_i386_tsc.d

kernel_img-kern_i386_pit.o: kern/i386/pit.c $(kern/i386/pit.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern/i386 -I$(srcdir)/kern/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_i386_pit.d

kernel_img-kern_generic_rtc_get_time_ms.o: kern/generic/rtc_get_time_ms.c $(kern/generic/rtc_get_time_ms.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern/generic -I$(srcdir)/kern/generic $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_generic_rtc_get_time_ms.d

kernel_img-kern_generic_millisleep.o: kern/generic/millisleep.c $(kern/generic/millisleep.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern/generic -I$(srcdir)/kern/generic $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_generic_millisleep.d

kernel_img-kern_env.o: kern/env.c $(kern/env.c_DEPENDENCIES)
	$(TARGET_CC) -Ikern -I$(srcdir)/kern $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-kern_env.d

kernel_img-term_i386_pc_console.o: term/i386/pc/console.c $(term/i386/pc/console.c_DEPENDENCIES)
	$(TARGET_CC) -Iterm/i386/pc -I$(srcdir)/term/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-term_i386_pc_console.d

kernel_img-term_i386_vga_common.o: term/i386/vga_common.c $(term/i386/vga_common.c_DEPENDENCIES)
	$(TARGET_CC) -Iterm/i386 -I$(srcdir)/term/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-term_i386_vga_common.d

kernel_img-symlist.o: symlist.c $(symlist.c_DEPENDENCIES)
	$(TARGET_CC) -I. -I$(srcdir)/. $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(kernel_img_CFLAGS) -MD -c -o $@ $<
-include kernel_img-symlist.d

kernel_img_HEADERS = boot.h cache.h device.h disk.h dl.h elf.h elfload.h \
	env.h err.h file.h fs.h kernel.h loader.h misc.h mm.h net.h parser.h \
	partition.h msdos_partition.h reader.h symbol.h term.h time.h types.h \
	machine/biosdisk.h machine/boot.h machine/console.h machine/init.h \
	machine/memory.h machine/loader.h machine/vga.h machine/vbe.h \
	machine/kernel.h machine/pxe.h i386/pit.h list.h handler.h command.h
kernel_img_CFLAGS = $(COMMON_CFLAGS)  $(TARGET_IMG_CFLAGS)
kernel_img_ASFLAGS = $(COMMON_ASFLAGS)
kernel_img_LDFLAGS = $(COMMON_LDFLAGS) $(TARGET_IMG_LDFLAGS)$(GRUB_KERNEL_MACHINE_LINK_ADDR) $(COMMON_CFLAGS)
kernel_img_FORMAT = binary

MOSTLYCLEANFILES += symlist.c kernel_syms.lst
DEFSYMFILES += kernel_syms.lst

symlist.c: $(addprefix include/grub/,$(kernel_img_HEADERS)) config.h gensymlist.sh
	/bin/sh gensymlist.sh $(filter %.h,$^) > $@ || (rm -f $@; exit 1)

kernel_syms.lst: $(addprefix include/grub/,$(kernel_img_HEADERS)) config.h genkernsyms.sh
	/bin/sh genkernsyms.sh $(filter %.h,$^) > $@ || (rm -f $@; exit 1)

# Utilities.
bin_UTILITIES = grub-mkimage
sbin_UTILITIES = grub-setup grub-mkdevicemap
ifeq ($(enable_grub_emu), yes)
sbin_UTILITIES += grub-emu
endif

# For grub-mkimage.
grub_mkimage_SOURCES = util/i386/pc/grub-mkimage.c util/misc.c \
	util/resolve.c lib/LzmaEnc.c lib/LzFind.c

clean-utility-grub-mkimage.1:
	rm -f grub-mkimage$(EXEEXT) grub_mkimage-util_i386_pc_grub_mkimage.o grub_mkimage-util_misc.o grub_mkimage-util_resolve.o grub_mkimage-lib_LzmaEnc.o grub_mkimage-lib_LzFind.o

CLEAN_UTILITY_TARGETS += clean-utility-grub-mkimage.1

mostlyclean-utility-grub-mkimage.1:
	rm -f grub_mkimage-util_i386_pc_grub_mkimage.d grub_mkimage-util_misc.d grub_mkimage-util_resolve.d grub_mkimage-lib_LzmaEnc.d grub_mkimage-lib_LzFind.d

MOSTLYCLEAN_UTILITY_TARGETS += mostlyclean-utility-grub-mkimage.1

grub_mkimage_OBJECTS += grub_mkimage-util_i386_pc_grub_mkimage.o grub_mkimage-util_misc.o grub_mkimage-util_resolve.o grub_mkimage-lib_LzmaEnc.o grub_mkimage-lib_LzFind.o

grub_mkimage-util_i386_pc_grub_mkimage.o: util/i386/pc/grub-mkimage.c $(util/i386/pc/grub-mkimage.c_DEPENDENCIES)
	$(CC) -Iutil/i386/pc -I$(srcdir)/util/i386/pc $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_mkimage_CFLAGS) -MD -c -o $@ $<
-include grub_mkimage-util_i386_pc_grub_mkimage.d

grub_mkimage-util_misc.o: util/misc.c $(util/misc.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_mkimage_CFLAGS) -MD -c -o $@ $<
-include grub_mkimage-util_misc.d

grub_mkimage-util_resolve.o: util/resolve.c $(util/resolve.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_mkimage_CFLAGS) -MD -c -o $@ $<
-include grub_mkimage-util_resolve.d

grub_mkimage-lib_LzmaEnc.o: lib/LzmaEnc.c $(lib/LzmaEnc.c_DEPENDENCIES)
	$(CC) -Ilib -I$(srcdir)/lib $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_mkimage_CFLAGS) -MD -c -o $@ $<
-include grub_mkimage-lib_LzmaEnc.d

grub_mkimage-lib_LzFind.o: lib/LzFind.c $(lib/LzFind.c_DEPENDENCIES)
	$(CC) -Ilib -I$(srcdir)/lib $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_mkimage_CFLAGS) -MD -c -o $@ $<
-include grub_mkimage-lib_LzFind.d

grub_mkimage_CFLAGS = -DGRUB_KERNEL_MACHINE_LINK_ADDR=$(GRUB_KERNEL_MACHINE_LINK_ADDR)
util/i386/pc/grub-mkimage.c_DEPENDENCIES = Makefile

# For grub-setup.
util/i386/pc/grub-setup.c_DEPENDENCIES = grub_setup_init.h
grub_setup_SOURCES = util/i386/pc/grub-setup.c util/hostdisk.c	\
	util/misc.c util/getroot.c kern/device.c kern/disk.c	\
	kern/err.c kern/misc.c kern/parser.c kern/partition.c	\
	kern/file.c kern/fs.c kern/env.c fs/fshelp.c		\
	\
	fs/affs.c fs/cpio.c fs/ext2.c fs/fat.c fs/hfs.c		\
	fs/hfsplus.c fs/iso9660.c fs/udf.c fs/jfs.c fs/minix.c	\
	fs/ntfs.c fs/ntfscomp.c fs/reiserfs.c fs/sfs.c		\
	fs/ufs.c fs/ufs2.c fs/xfs.c fs/afs.c fs/afs_be.c	\
	fs/befs.c fs/befs_be.c fs/tar.c			\
	\
	partmap/msdos.c partmap/gpt.c				\
	\
	disk/raid.c disk/mdraid_linux.c disk/lvm.c		\
	util/raid.c util/lvm.c					\
	grub_setup_init.c

clean-utility-grub-setup.1:
	rm -f grub-setup$(EXEEXT) grub_setup-util_i386_pc_grub_setup.o grub_setup-util_hostdisk.o grub_setup-util_misc.o grub_setup-util_getroot.o grub_setup-kern_device.o grub_setup-kern_disk.o grub_setup-kern_err.o grub_setup-kern_misc.o grub_setup-kern_parser.o grub_setup-kern_partition.o grub_setup-kern_file.o grub_setup-kern_fs.o grub_setup-kern_env.o grub_setup-fs_fshelp.o grub_setup-fs_affs.o grub_setup-fs_cpio.o grub_setup-fs_ext2.o grub_setup-fs_fat.o grub_setup-fs_hfs.o grub_setup-fs_hfsplus.o grub_setup-fs_iso9660.o grub_setup-fs_udf.o grub_setup-fs_jfs.o grub_setup-fs_minix.o grub_setup-fs_ntfs.o grub_setup-fs_ntfscomp.o grub_setup-fs_reiserfs.o grub_setup-fs_sfs.o grub_setup-fs_ufs.o grub_setup-fs_ufs2.o grub_setup-fs_xfs.o grub_setup-fs_afs.o grub_setup-fs_afs_be.o grub_setup-fs_befs.o grub_setup-fs_befs_be.o grub_setup-fs_tar.o grub_setup-partmap_msdos.o grub_setup-partmap_gpt.o grub_setup-disk_raid.o grub_setup-disk_mdraid_linux.o grub_setup-disk_lvm.o grub_setup-util_raid.o grub_setup-util_lvm.o grub_setup-grub_setup_init.o

CLEAN_UTILITY_TARGETS += clean-utility-grub-setup.1

mostlyclean-utility-grub-setup.1:
	rm -f grub_setup-util_i386_pc_grub_setup.d grub_setup-util_hostdisk.d grub_setup-util_misc.d grub_setup-util_getroot.d grub_setup-kern_device.d grub_setup-kern_disk.d grub_setup-kern_err.d grub_setup-kern_misc.d grub_setup-kern_parser.d grub_setup-kern_partition.d grub_setup-kern_file.d grub_setup-kern_fs.d grub_setup-kern_env.d grub_setup-fs_fshelp.d grub_setup-fs_affs.d grub_setup-fs_cpio.d grub_setup-fs_ext2.d grub_setup-fs_fat.d grub_setup-fs_hfs.d grub_setup-fs_hfsplus.d grub_setup-fs_iso9660.d grub_setup-fs_udf.d grub_setup-fs_jfs.d grub_setup-fs_minix.d grub_setup-fs_ntfs.d grub_setup-fs_ntfscomp.d grub_setup-fs_reiserfs.d grub_setup-fs_sfs.d grub_setup-fs_ufs.d grub_setup-fs_ufs2.d grub_setup-fs_xfs.d grub_setup-fs_afs.d grub_setup-fs_afs_be.d grub_setup-fs_befs.d grub_setup-fs_befs_be.d grub_setup-fs_tar.d grub_setup-partmap_msdos.d grub_setup-partmap_gpt.d grub_setup-disk_raid.d grub_setup-disk_mdraid_linux.d grub_setup-disk_lvm.d grub_setup-util_raid.d grub_setup-util_lvm.d grub_setup-grub_setup_init.d

MOSTLYCLEAN_UTILITY_TARGETS += mostlyclean-utility-grub-setup.1

grub_setup_OBJECTS += grub_setup-util_i386_pc_grub_setup.o grub_setup-util_hostdisk.o grub_setup-util_misc.o grub_setup-util_getroot.o grub_setup-kern_device.o grub_setup-kern_disk.o grub_setup-kern_err.o grub_setup-kern_misc.o grub_setup-kern_parser.o grub_setup-kern_partition.o grub_setup-kern_file.o grub_setup-kern_fs.o grub_setup-kern_env.o grub_setup-fs_fshelp.o grub_setup-fs_affs.o grub_setup-fs_cpio.o grub_setup-fs_ext2.o grub_setup-fs_fat.o grub_setup-fs_hfs.o grub_setup-fs_hfsplus.o grub_setup-fs_iso9660.o grub_setup-fs_udf.o grub_setup-fs_jfs.o grub_setup-fs_minix.o grub_setup-fs_ntfs.o grub_setup-fs_ntfscomp.o grub_setup-fs_reiserfs.o grub_setup-fs_sfs.o grub_setup-fs_ufs.o grub_setup-fs_ufs2.o grub_setup-fs_xfs.o grub_setup-fs_afs.o grub_setup-fs_afs_be.o grub_setup-fs_befs.o grub_setup-fs_befs_be.o grub_setup-fs_tar.o grub_setup-partmap_msdos.o grub_setup-partmap_gpt.o grub_setup-disk_raid.o grub_setup-disk_mdraid_linux.o grub_setup-disk_lvm.o grub_setup-util_raid.o grub_setup-util_lvm.o grub_setup-grub_setup_init.o

grub_setup-util_i386_pc_grub_setup.o: util/i386/pc/grub-setup.c $(util/i386/pc/grub-setup.c_DEPENDENCIES)
	$(CC) -Iutil/i386/pc -I$(srcdir)/util/i386/pc $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-util_i386_pc_grub_setup.d

grub_setup-util_hostdisk.o: util/hostdisk.c $(util/hostdisk.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-util_hostdisk.d

grub_setup-util_misc.o: util/misc.c $(util/misc.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-util_misc.d

grub_setup-util_getroot.o: util/getroot.c $(util/getroot.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-util_getroot.d

grub_setup-kern_device.o: kern/device.c $(kern/device.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-kern_device.d

grub_setup-kern_disk.o: kern/disk.c $(kern/disk.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-kern_disk.d

grub_setup-kern_err.o: kern/err.c $(kern/err.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-kern_err.d

grub_setup-kern_misc.o: kern/misc.c $(kern/misc.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-kern_misc.d

grub_setup-kern_parser.o: kern/parser.c $(kern/parser.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-kern_parser.d

grub_setup-kern_partition.o: kern/partition.c $(kern/partition.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-kern_partition.d

grub_setup-kern_file.o: kern/file.c $(kern/file.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-kern_file.d

grub_setup-kern_fs.o: kern/fs.c $(kern/fs.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-kern_fs.d

grub_setup-kern_env.o: kern/env.c $(kern/env.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-kern_env.d

grub_setup-fs_fshelp.o: fs/fshelp.c $(fs/fshelp.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_fshelp.d

grub_setup-fs_affs.o: fs/affs.c $(fs/affs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_affs.d

grub_setup-fs_cpio.o: fs/cpio.c $(fs/cpio.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_cpio.d

grub_setup-fs_ext2.o: fs/ext2.c $(fs/ext2.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_ext2.d

grub_setup-fs_fat.o: fs/fat.c $(fs/fat.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_fat.d

grub_setup-fs_hfs.o: fs/hfs.c $(fs/hfs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_hfs.d

grub_setup-fs_hfsplus.o: fs/hfsplus.c $(fs/hfsplus.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_hfsplus.d

grub_setup-fs_iso9660.o: fs/iso9660.c $(fs/iso9660.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_iso9660.d

grub_setup-fs_udf.o: fs/udf.c $(fs/udf.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_udf.d

grub_setup-fs_jfs.o: fs/jfs.c $(fs/jfs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_jfs.d

grub_setup-fs_minix.o: fs/minix.c $(fs/minix.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_minix.d

grub_setup-fs_ntfs.o: fs/ntfs.c $(fs/ntfs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_ntfs.d

grub_setup-fs_ntfscomp.o: fs/ntfscomp.c $(fs/ntfscomp.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_ntfscomp.d

grub_setup-fs_reiserfs.o: fs/reiserfs.c $(fs/reiserfs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_reiserfs.d

grub_setup-fs_sfs.o: fs/sfs.c $(fs/sfs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_sfs.d

grub_setup-fs_ufs.o: fs/ufs.c $(fs/ufs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_ufs.d

grub_setup-fs_ufs2.o: fs/ufs2.c $(fs/ufs2.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_ufs2.d

grub_setup-fs_xfs.o: fs/xfs.c $(fs/xfs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_xfs.d

grub_setup-fs_afs.o: fs/afs.c $(fs/afs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_afs.d

grub_setup-fs_afs_be.o: fs/afs_be.c $(fs/afs_be.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_afs_be.d

grub_setup-fs_befs.o: fs/befs.c $(fs/befs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_befs.d

grub_setup-fs_befs_be.o: fs/befs_be.c $(fs/befs_be.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_befs_be.d

grub_setup-fs_tar.o: fs/tar.c $(fs/tar.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-fs_tar.d

grub_setup-partmap_msdos.o: partmap/msdos.c $(partmap/msdos.c_DEPENDENCIES)
	$(CC) -Ipartmap -I$(srcdir)/partmap $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-partmap_msdos.d

grub_setup-partmap_gpt.o: partmap/gpt.c $(partmap/gpt.c_DEPENDENCIES)
	$(CC) -Ipartmap -I$(srcdir)/partmap $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-partmap_gpt.d

grub_setup-disk_raid.o: disk/raid.c $(disk/raid.c_DEPENDENCIES)
	$(CC) -Idisk -I$(srcdir)/disk $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-disk_raid.d

grub_setup-disk_mdraid_linux.o: disk/mdraid_linux.c $(disk/mdraid_linux.c_DEPENDENCIES)
	$(CC) -Idisk -I$(srcdir)/disk $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-disk_mdraid_linux.d

grub_setup-disk_lvm.o: disk/lvm.c $(disk/lvm.c_DEPENDENCIES)
	$(CC) -Idisk -I$(srcdir)/disk $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-disk_lvm.d

grub_setup-util_raid.o: util/raid.c $(util/raid.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-util_raid.d

grub_setup-util_lvm.o: util/lvm.c $(util/lvm.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-util_lvm.d

grub_setup-grub_setup_init.o: grub_setup_init.c $(grub_setup_init.c_DEPENDENCIES)
	$(CC) -I. -I$(srcdir)/. $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_setup_CFLAGS) -MD -c -o $@ $<
-include grub_setup-grub_setup_init.d


# For grub-mkdevicemap.
grub_mkdevicemap_SOURCES = util/grub-mkdevicemap.c util/deviceiter.c \
	util/devicemap.c util/misc.c

clean-utility-grub-mkdevicemap.1:
	rm -f grub-mkdevicemap$(EXEEXT) grub_mkdevicemap-util_grub_mkdevicemap.o grub_mkdevicemap-util_deviceiter.o grub_mkdevicemap-util_devicemap.o grub_mkdevicemap-util_misc.o

CLEAN_UTILITY_TARGETS += clean-utility-grub-mkdevicemap.1

mostlyclean-utility-grub-mkdevicemap.1:
	rm -f grub_mkdevicemap-util_grub_mkdevicemap.d grub_mkdevicemap-util_deviceiter.d grub_mkdevicemap-util_devicemap.d grub_mkdevicemap-util_misc.d

MOSTLYCLEAN_UTILITY_TARGETS += mostlyclean-utility-grub-mkdevicemap.1

grub_mkdevicemap_OBJECTS += grub_mkdevicemap-util_grub_mkdevicemap.o grub_mkdevicemap-util_deviceiter.o grub_mkdevicemap-util_devicemap.o grub_mkdevicemap-util_misc.o

grub_mkdevicemap-util_grub_mkdevicemap.o: util/grub-mkdevicemap.c $(util/grub-mkdevicemap.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_mkdevicemap_CFLAGS) -MD -c -o $@ $<
-include grub_mkdevicemap-util_grub_mkdevicemap.d

grub_mkdevicemap-util_deviceiter.o: util/deviceiter.c $(util/deviceiter.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_mkdevicemap_CFLAGS) -MD -c -o $@ $<
-include grub_mkdevicemap-util_deviceiter.d

grub_mkdevicemap-util_devicemap.o: util/devicemap.c $(util/devicemap.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_mkdevicemap_CFLAGS) -MD -c -o $@ $<
-include grub_mkdevicemap-util_devicemap.d

grub_mkdevicemap-util_misc.o: util/misc.c $(util/misc.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_mkdevicemap_CFLAGS) -MD -c -o $@ $<
-include grub_mkdevicemap-util_misc.d


# For grub-emu.
util/grub-emu.c_DEPENDENCIES = grub_emu_init.h
grub_emu_SOURCES = commands/minicmd.c commands/cat.c commands/cmp.c	\
	commands/configfile.c commands/echo.c commands/help.c		\
	commands/handler.c commands/ls.c commands/test.c 		\
	commands/search.c commands/blocklist.c commands/hexdump.c	\
	lib/hexdump.c commands/i386/pc/halt.c commands/reboot.c		\
	lib/envblk.c commands/loadenv.c					\
	commands/gptsync.c commands/probe.c commands/xnu_uuid.c		\
	commands/i386/cpuid.c	\
	commands/password.c commands/keystatus.c			\
	disk/host.c disk/loopback.c disk/scsi.c				\
	fs/fshelp.c 	\
	\
	io/gzio.c							\
	kern/device.c kern/disk.c kern/dl.c kern/elf.c kern/env.c	\
	kern/err.c kern/list.c kern/handler.c				\
	kern/command.c kern/corecmd.c commands/extcmd.c	kern/file.c	\
	kern/fs.c commands/boot.c kern/main.c kern/misc.c kern/parser.c	\
	kern/partition.c kern/reader.c kern/term.c			\
	kern/rescue_reader.c kern/rescue_parser.c			\
	lib/arg.c normal/cmdline.c normal/datetime.c normal/misc.c	\
	normal/handler.c normal/auth.c normal/autofs.c				\
	normal/completion.c normal/main.c normal/color.c		\
	normal/menu.c normal/menu_entry.c normal/menu_viewer.c		\
	normal/menu_text.c						\
	script/sh/main.c script/sh/execute.c script/sh/function.c	\
	script/sh/lexer.c script/sh/script.c grub_script.tab.c		\
	partmap/amiga.c	partmap/apple.c partmap/msdos.c partmap/sun.c	\
	partmap/acorn.c partmap/gpt.c					\
	\
	fs/affs.c fs/cpio.c  fs/fat.c fs/ext2.c fs/hfs.c		\
	fs/hfsplus.c fs/iso9660.c fs/udf.c fs/jfs.c fs/minix.c		\
	fs/ntfs.c fs/ntfscomp.c fs/reiserfs.c fs/sfs.c			\
	fs/ufs.c fs/ufs2.c fs/xfs.c fs/afs.c fs/afs_be.c		\
	fs/befs.c fs/befs_be.c fs/tar.c				\
	\
	util/console.c util/hostfs.c util/grub-emu.c util/misc.c	\
	util/hostdisk.c util/getroot.c					\
	\
	disk/raid.c disk/raid5_recover.c disk/raid6_recover.c		\
	disk/mdraid_linux.c disk/dmraid_nvidia.c disk/lvm.c		\
	commands/parttool.c parttool/msdospart.c				\
	grub_emu_init.c

clean-utility-grub-emu.1:
	rm -f grub-emu$(EXEEXT) grub_emu-commands_minicmd.o grub_emu-commands_cat.o grub_emu-commands_cmp.o grub_emu-commands_configfile.o grub_emu-commands_echo.o grub_emu-commands_help.o grub_emu-commands_handler.o grub_emu-commands_ls.o grub_emu-commands_test.o grub_emu-commands_search.o grub_emu-commands_blocklist.o grub_emu-commands_hexdump.o grub_emu-lib_hexdump.o grub_emu-commands_i386_pc_halt.o grub_emu-commands_reboot.o grub_emu-lib_envblk.o grub_emu-commands_loadenv.o grub_emu-commands_gptsync.o grub_emu-commands_probe.o grub_emu-commands_xnu_uuid.o grub_emu-commands_i386_cpuid.o grub_emu-commands_password.o grub_emu-commands_keystatus.o grub_emu-disk_host.o grub_emu-disk_loopback.o grub_emu-disk_scsi.o grub_emu-fs_fshelp.o grub_emu-io_gzio.o grub_emu-kern_device.o grub_emu-kern_disk.o grub_emu-kern_dl.o grub_emu-kern_elf.o grub_emu-kern_env.o grub_emu-kern_err.o grub_emu-kern_list.o grub_emu-kern_handler.o grub_emu-kern_command.o grub_emu-kern_corecmd.o grub_emu-commands_extcmd.o grub_emu-kern_file.o grub_emu-kern_fs.o grub_emu-commands_boot.o grub_emu-kern_main.o grub_emu-kern_misc.o grub_emu-kern_parser.o grub_emu-kern_partition.o grub_emu-kern_reader.o grub_emu-kern_term.o grub_emu-kern_rescue_reader.o grub_emu-kern_rescue_parser.o grub_emu-lib_arg.o grub_emu-normal_cmdline.o grub_emu-normal_datetime.o grub_emu-normal_misc.o grub_emu-normal_handler.o grub_emu-normal_auth.o grub_emu-normal_autofs.o grub_emu-normal_completion.o grub_emu-normal_main.o grub_emu-normal_color.o grub_emu-normal_menu.o grub_emu-normal_menu_entry.o grub_emu-normal_menu_viewer.o grub_emu-normal_menu_text.o grub_emu-script_sh_main.o grub_emu-script_sh_execute.o grub_emu-script_sh_function.o grub_emu-script_sh_lexer.o grub_emu-script_sh_script.o grub_emu-grub_script_tab.o grub_emu-partmap_amiga.o grub_emu-partmap_apple.o grub_emu-partmap_msdos.o grub_emu-partmap_sun.o grub_emu-partmap_acorn.o grub_emu-partmap_gpt.o grub_emu-fs_affs.o grub_emu-fs_cpio.o grub_emu-fs_fat.o grub_emu-fs_ext2.o grub_emu-fs_hfs.o grub_emu-fs_hfsplus.o grub_emu-fs_iso9660.o grub_emu-fs_udf.o grub_emu-fs_jfs.o grub_emu-fs_minix.o grub_emu-fs_ntfs.o grub_emu-fs_ntfscomp.o grub_emu-fs_reiserfs.o grub_emu-fs_sfs.o grub_emu-fs_ufs.o grub_emu-fs_ufs2.o grub_emu-fs_xfs.o grub_emu-fs_afs.o grub_emu-fs_afs_be.o grub_emu-fs_befs.o grub_emu-fs_befs_be.o grub_emu-fs_tar.o grub_emu-util_console.o grub_emu-util_hostfs.o grub_emu-util_grub_emu.o grub_emu-util_misc.o grub_emu-util_hostdisk.o grub_emu-util_getroot.o grub_emu-disk_raid.o grub_emu-disk_raid5_recover.o grub_emu-disk_raid6_recover.o grub_emu-disk_mdraid_linux.o grub_emu-disk_dmraid_nvidia.o grub_emu-disk_lvm.o grub_emu-commands_parttool.o grub_emu-parttool_msdospart.o grub_emu-grub_emu_init.o

CLEAN_UTILITY_TARGETS += clean-utility-grub-emu.1

mostlyclean-utility-grub-emu.1:
	rm -f grub_emu-commands_minicmd.d grub_emu-commands_cat.d grub_emu-commands_cmp.d grub_emu-commands_configfile.d grub_emu-commands_echo.d grub_emu-commands_help.d grub_emu-commands_handler.d grub_emu-commands_ls.d grub_emu-commands_test.d grub_emu-commands_search.d grub_emu-commands_blocklist.d grub_emu-commands_hexdump.d grub_emu-lib_hexdump.d grub_emu-commands_i386_pc_halt.d grub_emu-commands_reboot.d grub_emu-lib_envblk.d grub_emu-commands_loadenv.d grub_emu-commands_gptsync.d grub_emu-commands_probe.d grub_emu-commands_xnu_uuid.d grub_emu-commands_i386_cpuid.d grub_emu-commands_password.d grub_emu-commands_keystatus.d grub_emu-disk_host.d grub_emu-disk_loopback.d grub_emu-disk_scsi.d grub_emu-fs_fshelp.d grub_emu-io_gzio.d grub_emu-kern_device.d grub_emu-kern_disk.d grub_emu-kern_dl.d grub_emu-kern_elf.d grub_emu-kern_env.d grub_emu-kern_err.d grub_emu-kern_list.d grub_emu-kern_handler.d grub_emu-kern_command.d grub_emu-kern_corecmd.d grub_emu-commands_extcmd.d grub_emu-kern_file.d grub_emu-kern_fs.d grub_emu-commands_boot.d grub_emu-kern_main.d grub_emu-kern_misc.d grub_emu-kern_parser.d grub_emu-kern_partition.d grub_emu-kern_reader.d grub_emu-kern_term.d grub_emu-kern_rescue_reader.d grub_emu-kern_rescue_parser.d grub_emu-lib_arg.d grub_emu-normal_cmdline.d grub_emu-normal_datetime.d grub_emu-normal_misc.d grub_emu-normal_handler.d grub_emu-normal_auth.d grub_emu-normal_autofs.d grub_emu-normal_completion.d grub_emu-normal_main.d grub_emu-normal_color.d grub_emu-normal_menu.d grub_emu-normal_menu_entry.d grub_emu-normal_menu_viewer.d grub_emu-normal_menu_text.d grub_emu-script_sh_main.d grub_emu-script_sh_execute.d grub_emu-script_sh_function.d grub_emu-script_sh_lexer.d grub_emu-script_sh_script.d grub_emu-grub_script_tab.d grub_emu-partmap_amiga.d grub_emu-partmap_apple.d grub_emu-partmap_msdos.d grub_emu-partmap_sun.d grub_emu-partmap_acorn.d grub_emu-partmap_gpt.d grub_emu-fs_affs.d grub_emu-fs_cpio.d grub_emu-fs_fat.d grub_emu-fs_ext2.d grub_emu-fs_hfs.d grub_emu-fs_hfsplus.d grub_emu-fs_iso9660.d grub_emu-fs_udf.d grub_emu-fs_jfs.d grub_emu-fs_minix.d grub_emu-fs_ntfs.d grub_emu-fs_ntfscomp.d grub_emu-fs_reiserfs.d grub_emu-fs_sfs.d grub_emu-fs_ufs.d grub_emu-fs_ufs2.d grub_emu-fs_xfs.d grub_emu-fs_afs.d grub_emu-fs_afs_be.d grub_emu-fs_befs.d grub_emu-fs_befs_be.d grub_emu-fs_tar.d grub_emu-util_console.d grub_emu-util_hostfs.d grub_emu-util_grub_emu.d grub_emu-util_misc.d grub_emu-util_hostdisk.d grub_emu-util_getroot.d grub_emu-disk_raid.d grub_emu-disk_raid5_recover.d grub_emu-disk_raid6_recover.d grub_emu-disk_mdraid_linux.d grub_emu-disk_dmraid_nvidia.d grub_emu-disk_lvm.d grub_emu-commands_parttool.d grub_emu-parttool_msdospart.d grub_emu-grub_emu_init.d

MOSTLYCLEAN_UTILITY_TARGETS += mostlyclean-utility-grub-emu.1

grub_emu_OBJECTS += grub_emu-commands_minicmd.o grub_emu-commands_cat.o grub_emu-commands_cmp.o grub_emu-commands_configfile.o grub_emu-commands_echo.o grub_emu-commands_help.o grub_emu-commands_handler.o grub_emu-commands_ls.o grub_emu-commands_test.o grub_emu-commands_search.o grub_emu-commands_blocklist.o grub_emu-commands_hexdump.o grub_emu-lib_hexdump.o grub_emu-commands_i386_pc_halt.o grub_emu-commands_reboot.o grub_emu-lib_envblk.o grub_emu-commands_loadenv.o grub_emu-commands_gptsync.o grub_emu-commands_probe.o grub_emu-commands_xnu_uuid.o grub_emu-commands_i386_cpuid.o grub_emu-commands_password.o grub_emu-commands_keystatus.o grub_emu-disk_host.o grub_emu-disk_loopback.o grub_emu-disk_scsi.o grub_emu-fs_fshelp.o grub_emu-io_gzio.o grub_emu-kern_device.o grub_emu-kern_disk.o grub_emu-kern_dl.o grub_emu-kern_elf.o grub_emu-kern_env.o grub_emu-kern_err.o grub_emu-kern_list.o grub_emu-kern_handler.o grub_emu-kern_command.o grub_emu-kern_corecmd.o grub_emu-commands_extcmd.o grub_emu-kern_file.o grub_emu-kern_fs.o grub_emu-commands_boot.o grub_emu-kern_main.o grub_emu-kern_misc.o grub_emu-kern_parser.o grub_emu-kern_partition.o grub_emu-kern_reader.o grub_emu-kern_term.o grub_emu-kern_rescue_reader.o grub_emu-kern_rescue_parser.o grub_emu-lib_arg.o grub_emu-normal_cmdline.o grub_emu-normal_datetime.o grub_emu-normal_misc.o grub_emu-normal_handler.o grub_emu-normal_auth.o grub_emu-normal_autofs.o grub_emu-normal_completion.o grub_emu-normal_main.o grub_emu-normal_color.o grub_emu-normal_menu.o grub_emu-normal_menu_entry.o grub_emu-normal_menu_viewer.o grub_emu-normal_menu_text.o grub_emu-script_sh_main.o grub_emu-script_sh_execute.o grub_emu-script_sh_function.o grub_emu-script_sh_lexer.o grub_emu-script_sh_script.o grub_emu-grub_script_tab.o grub_emu-partmap_amiga.o grub_emu-partmap_apple.o grub_emu-partmap_msdos.o grub_emu-partmap_sun.o grub_emu-partmap_acorn.o grub_emu-partmap_gpt.o grub_emu-fs_affs.o grub_emu-fs_cpio.o grub_emu-fs_fat.o grub_emu-fs_ext2.o grub_emu-fs_hfs.o grub_emu-fs_hfsplus.o grub_emu-fs_iso9660.o grub_emu-fs_udf.o grub_emu-fs_jfs.o grub_emu-fs_minix.o grub_emu-fs_ntfs.o grub_emu-fs_ntfscomp.o grub_emu-fs_reiserfs.o grub_emu-fs_sfs.o grub_emu-fs_ufs.o grub_emu-fs_ufs2.o grub_emu-fs_xfs.o grub_emu-fs_afs.o grub_emu-fs_afs_be.o grub_emu-fs_befs.o grub_emu-fs_befs_be.o grub_emu-fs_tar.o grub_emu-util_console.o grub_emu-util_hostfs.o grub_emu-util_grub_emu.o grub_emu-util_misc.o grub_emu-util_hostdisk.o grub_emu-util_getroot.o grub_emu-disk_raid.o grub_emu-disk_raid5_recover.o grub_emu-disk_raid6_recover.o grub_emu-disk_mdraid_linux.o grub_emu-disk_dmraid_nvidia.o grub_emu-disk_lvm.o grub_emu-commands_parttool.o grub_emu-parttool_msdospart.o grub_emu-grub_emu_init.o

grub_emu-commands_minicmd.o: commands/minicmd.c $(commands/minicmd.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_minicmd.d

grub_emu-commands_cat.o: commands/cat.c $(commands/cat.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_cat.d

grub_emu-commands_cmp.o: commands/cmp.c $(commands/cmp.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_cmp.d

grub_emu-commands_configfile.o: commands/configfile.c $(commands/configfile.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_configfile.d

grub_emu-commands_echo.o: commands/echo.c $(commands/echo.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_echo.d

grub_emu-commands_help.o: commands/help.c $(commands/help.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_help.d

grub_emu-commands_handler.o: commands/handler.c $(commands/handler.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_handler.d

grub_emu-commands_ls.o: commands/ls.c $(commands/ls.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_ls.d

grub_emu-commands_test.o: commands/test.c $(commands/test.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_test.d

grub_emu-commands_search.o: commands/search.c $(commands/search.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_search.d

grub_emu-commands_blocklist.o: commands/blocklist.c $(commands/blocklist.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_blocklist.d

grub_emu-commands_hexdump.o: commands/hexdump.c $(commands/hexdump.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_hexdump.d

grub_emu-lib_hexdump.o: lib/hexdump.c $(lib/hexdump.c_DEPENDENCIES)
	$(CC) -Ilib -I$(srcdir)/lib $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-lib_hexdump.d

grub_emu-commands_i386_pc_halt.o: commands/i386/pc/halt.c $(commands/i386/pc/halt.c_DEPENDENCIES)
	$(CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_i386_pc_halt.d

grub_emu-commands_reboot.o: commands/reboot.c $(commands/reboot.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_reboot.d

grub_emu-lib_envblk.o: lib/envblk.c $(lib/envblk.c_DEPENDENCIES)
	$(CC) -Ilib -I$(srcdir)/lib $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-lib_envblk.d

grub_emu-commands_loadenv.o: commands/loadenv.c $(commands/loadenv.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_loadenv.d

grub_emu-commands_gptsync.o: commands/gptsync.c $(commands/gptsync.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_gptsync.d

grub_emu-commands_probe.o: commands/probe.c $(commands/probe.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_probe.d

grub_emu-commands_xnu_uuid.o: commands/xnu_uuid.c $(commands/xnu_uuid.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_xnu_uuid.d

grub_emu-commands_i386_cpuid.o: commands/i386/cpuid.c $(commands/i386/cpuid.c_DEPENDENCIES)
	$(CC) -Icommands/i386 -I$(srcdir)/commands/i386 $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_i386_cpuid.d

grub_emu-commands_password.o: commands/password.c $(commands/password.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_password.d

grub_emu-commands_keystatus.o: commands/keystatus.c $(commands/keystatus.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_keystatus.d

grub_emu-disk_host.o: disk/host.c $(disk/host.c_DEPENDENCIES)
	$(CC) -Idisk -I$(srcdir)/disk $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-disk_host.d

grub_emu-disk_loopback.o: disk/loopback.c $(disk/loopback.c_DEPENDENCIES)
	$(CC) -Idisk -I$(srcdir)/disk $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-disk_loopback.d

grub_emu-disk_scsi.o: disk/scsi.c $(disk/scsi.c_DEPENDENCIES)
	$(CC) -Idisk -I$(srcdir)/disk $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-disk_scsi.d

grub_emu-fs_fshelp.o: fs/fshelp.c $(fs/fshelp.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_fshelp.d

grub_emu-io_gzio.o: io/gzio.c $(io/gzio.c_DEPENDENCIES)
	$(CC) -Iio -I$(srcdir)/io $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-io_gzio.d

grub_emu-kern_device.o: kern/device.c $(kern/device.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_device.d

grub_emu-kern_disk.o: kern/disk.c $(kern/disk.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_disk.d

grub_emu-kern_dl.o: kern/dl.c $(kern/dl.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_dl.d

grub_emu-kern_elf.o: kern/elf.c $(kern/elf.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_elf.d

grub_emu-kern_env.o: kern/env.c $(kern/env.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_env.d

grub_emu-kern_err.o: kern/err.c $(kern/err.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_err.d

grub_emu-kern_list.o: kern/list.c $(kern/list.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_list.d

grub_emu-kern_handler.o: kern/handler.c $(kern/handler.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_handler.d

grub_emu-kern_command.o: kern/command.c $(kern/command.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_command.d

grub_emu-kern_corecmd.o: kern/corecmd.c $(kern/corecmd.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_corecmd.d

grub_emu-commands_extcmd.o: commands/extcmd.c $(commands/extcmd.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_extcmd.d

grub_emu-kern_file.o: kern/file.c $(kern/file.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_file.d

grub_emu-kern_fs.o: kern/fs.c $(kern/fs.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_fs.d

grub_emu-commands_boot.o: commands/boot.c $(commands/boot.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_boot.d

grub_emu-kern_main.o: kern/main.c $(kern/main.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_main.d

grub_emu-kern_misc.o: kern/misc.c $(kern/misc.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_misc.d

grub_emu-kern_parser.o: kern/parser.c $(kern/parser.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_parser.d

grub_emu-kern_partition.o: kern/partition.c $(kern/partition.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_partition.d

grub_emu-kern_reader.o: kern/reader.c $(kern/reader.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_reader.d

grub_emu-kern_term.o: kern/term.c $(kern/term.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_term.d

grub_emu-kern_rescue_reader.o: kern/rescue_reader.c $(kern/rescue_reader.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_rescue_reader.d

grub_emu-kern_rescue_parser.o: kern/rescue_parser.c $(kern/rescue_parser.c_DEPENDENCIES)
	$(CC) -Ikern -I$(srcdir)/kern $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-kern_rescue_parser.d

grub_emu-lib_arg.o: lib/arg.c $(lib/arg.c_DEPENDENCIES)
	$(CC) -Ilib -I$(srcdir)/lib $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-lib_arg.d

grub_emu-normal_cmdline.o: normal/cmdline.c $(normal/cmdline.c_DEPENDENCIES)
	$(CC) -Inormal -I$(srcdir)/normal $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-normal_cmdline.d

grub_emu-normal_datetime.o: normal/datetime.c $(normal/datetime.c_DEPENDENCIES)
	$(CC) -Inormal -I$(srcdir)/normal $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-normal_datetime.d

grub_emu-normal_misc.o: normal/misc.c $(normal/misc.c_DEPENDENCIES)
	$(CC) -Inormal -I$(srcdir)/normal $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-normal_misc.d

grub_emu-normal_handler.o: normal/handler.c $(normal/handler.c_DEPENDENCIES)
	$(CC) -Inormal -I$(srcdir)/normal $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-normal_handler.d

grub_emu-normal_auth.o: normal/auth.c $(normal/auth.c_DEPENDENCIES)
	$(CC) -Inormal -I$(srcdir)/normal $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-normal_auth.d

grub_emu-normal_autofs.o: normal/autofs.c $(normal/autofs.c_DEPENDENCIES)
	$(CC) -Inormal -I$(srcdir)/normal $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-normal_autofs.d

grub_emu-normal_completion.o: normal/completion.c $(normal/completion.c_DEPENDENCIES)
	$(CC) -Inormal -I$(srcdir)/normal $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-normal_completion.d

grub_emu-normal_main.o: normal/main.c $(normal/main.c_DEPENDENCIES)
	$(CC) -Inormal -I$(srcdir)/normal $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-normal_main.d

grub_emu-normal_color.o: normal/color.c $(normal/color.c_DEPENDENCIES)
	$(CC) -Inormal -I$(srcdir)/normal $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-normal_color.d

grub_emu-normal_menu.o: normal/menu.c $(normal/menu.c_DEPENDENCIES)
	$(CC) -Inormal -I$(srcdir)/normal $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-normal_menu.d

grub_emu-normal_menu_entry.o: normal/menu_entry.c $(normal/menu_entry.c_DEPENDENCIES)
	$(CC) -Inormal -I$(srcdir)/normal $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-normal_menu_entry.d

grub_emu-normal_menu_viewer.o: normal/menu_viewer.c $(normal/menu_viewer.c_DEPENDENCIES)
	$(CC) -Inormal -I$(srcdir)/normal $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-normal_menu_viewer.d

grub_emu-normal_menu_text.o: normal/menu_text.c $(normal/menu_text.c_DEPENDENCIES)
	$(CC) -Inormal -I$(srcdir)/normal $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-normal_menu_text.d

grub_emu-script_sh_main.o: script/sh/main.c $(script/sh/main.c_DEPENDENCIES)
	$(CC) -Iscript/sh -I$(srcdir)/script/sh $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-script_sh_main.d

grub_emu-script_sh_execute.o: script/sh/execute.c $(script/sh/execute.c_DEPENDENCIES)
	$(CC) -Iscript/sh -I$(srcdir)/script/sh $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-script_sh_execute.d

grub_emu-script_sh_function.o: script/sh/function.c $(script/sh/function.c_DEPENDENCIES)
	$(CC) -Iscript/sh -I$(srcdir)/script/sh $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-script_sh_function.d

grub_emu-script_sh_lexer.o: script/sh/lexer.c $(script/sh/lexer.c_DEPENDENCIES)
	$(CC) -Iscript/sh -I$(srcdir)/script/sh $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-script_sh_lexer.d

grub_emu-script_sh_script.o: script/sh/script.c $(script/sh/script.c_DEPENDENCIES)
	$(CC) -Iscript/sh -I$(srcdir)/script/sh $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-script_sh_script.d

grub_emu-grub_script_tab.o: grub_script.tab.c $(grub_script.tab.c_DEPENDENCIES)
	$(CC) -I. -I$(srcdir)/. $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-grub_script_tab.d

grub_emu-partmap_amiga.o: partmap/amiga.c $(partmap/amiga.c_DEPENDENCIES)
	$(CC) -Ipartmap -I$(srcdir)/partmap $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-partmap_amiga.d

grub_emu-partmap_apple.o: partmap/apple.c $(partmap/apple.c_DEPENDENCIES)
	$(CC) -Ipartmap -I$(srcdir)/partmap $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-partmap_apple.d

grub_emu-partmap_msdos.o: partmap/msdos.c $(partmap/msdos.c_DEPENDENCIES)
	$(CC) -Ipartmap -I$(srcdir)/partmap $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-partmap_msdos.d

grub_emu-partmap_sun.o: partmap/sun.c $(partmap/sun.c_DEPENDENCIES)
	$(CC) -Ipartmap -I$(srcdir)/partmap $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-partmap_sun.d

grub_emu-partmap_acorn.o: partmap/acorn.c $(partmap/acorn.c_DEPENDENCIES)
	$(CC) -Ipartmap -I$(srcdir)/partmap $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-partmap_acorn.d

grub_emu-partmap_gpt.o: partmap/gpt.c $(partmap/gpt.c_DEPENDENCIES)
	$(CC) -Ipartmap -I$(srcdir)/partmap $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-partmap_gpt.d

grub_emu-fs_affs.o: fs/affs.c $(fs/affs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_affs.d

grub_emu-fs_cpio.o: fs/cpio.c $(fs/cpio.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_cpio.d

grub_emu-fs_fat.o: fs/fat.c $(fs/fat.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_fat.d

grub_emu-fs_ext2.o: fs/ext2.c $(fs/ext2.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_ext2.d

grub_emu-fs_hfs.o: fs/hfs.c $(fs/hfs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_hfs.d

grub_emu-fs_hfsplus.o: fs/hfsplus.c $(fs/hfsplus.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_hfsplus.d

grub_emu-fs_iso9660.o: fs/iso9660.c $(fs/iso9660.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_iso9660.d

grub_emu-fs_udf.o: fs/udf.c $(fs/udf.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_udf.d

grub_emu-fs_jfs.o: fs/jfs.c $(fs/jfs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_jfs.d

grub_emu-fs_minix.o: fs/minix.c $(fs/minix.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_minix.d

grub_emu-fs_ntfs.o: fs/ntfs.c $(fs/ntfs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_ntfs.d

grub_emu-fs_ntfscomp.o: fs/ntfscomp.c $(fs/ntfscomp.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_ntfscomp.d

grub_emu-fs_reiserfs.o: fs/reiserfs.c $(fs/reiserfs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_reiserfs.d

grub_emu-fs_sfs.o: fs/sfs.c $(fs/sfs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_sfs.d

grub_emu-fs_ufs.o: fs/ufs.c $(fs/ufs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_ufs.d

grub_emu-fs_ufs2.o: fs/ufs2.c $(fs/ufs2.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_ufs2.d

grub_emu-fs_xfs.o: fs/xfs.c $(fs/xfs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_xfs.d

grub_emu-fs_afs.o: fs/afs.c $(fs/afs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_afs.d

grub_emu-fs_afs_be.o: fs/afs_be.c $(fs/afs_be.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_afs_be.d

grub_emu-fs_befs.o: fs/befs.c $(fs/befs.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_befs.d

grub_emu-fs_befs_be.o: fs/befs_be.c $(fs/befs_be.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_befs_be.d

grub_emu-fs_tar.o: fs/tar.c $(fs/tar.c_DEPENDENCIES)
	$(CC) -Ifs -I$(srcdir)/fs $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-fs_tar.d

grub_emu-util_console.o: util/console.c $(util/console.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-util_console.d

grub_emu-util_hostfs.o: util/hostfs.c $(util/hostfs.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-util_hostfs.d

grub_emu-util_grub_emu.o: util/grub-emu.c $(util/grub-emu.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-util_grub_emu.d

grub_emu-util_misc.o: util/misc.c $(util/misc.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-util_misc.d

grub_emu-util_hostdisk.o: util/hostdisk.c $(util/hostdisk.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-util_hostdisk.d

grub_emu-util_getroot.o: util/getroot.c $(util/getroot.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-util_getroot.d

grub_emu-disk_raid.o: disk/raid.c $(disk/raid.c_DEPENDENCIES)
	$(CC) -Idisk -I$(srcdir)/disk $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-disk_raid.d

grub_emu-disk_raid5_recover.o: disk/raid5_recover.c $(disk/raid5_recover.c_DEPENDENCIES)
	$(CC) -Idisk -I$(srcdir)/disk $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-disk_raid5_recover.d

grub_emu-disk_raid6_recover.o: disk/raid6_recover.c $(disk/raid6_recover.c_DEPENDENCIES)
	$(CC) -Idisk -I$(srcdir)/disk $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-disk_raid6_recover.d

grub_emu-disk_mdraid_linux.o: disk/mdraid_linux.c $(disk/mdraid_linux.c_DEPENDENCIES)
	$(CC) -Idisk -I$(srcdir)/disk $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-disk_mdraid_linux.d

grub_emu-disk_dmraid_nvidia.o: disk/dmraid_nvidia.c $(disk/dmraid_nvidia.c_DEPENDENCIES)
	$(CC) -Idisk -I$(srcdir)/disk $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-disk_dmraid_nvidia.d

grub_emu-disk_lvm.o: disk/lvm.c $(disk/lvm.c_DEPENDENCIES)
	$(CC) -Idisk -I$(srcdir)/disk $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-disk_lvm.d

grub_emu-commands_parttool.o: commands/parttool.c $(commands/parttool.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_parttool.d

grub_emu-parttool_msdospart.o: parttool/msdospart.c $(parttool/msdospart.c_DEPENDENCIES)
	$(CC) -Iparttool -I$(srcdir)/parttool $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-parttool_msdospart.d

grub_emu-grub_emu_init.o: grub_emu_init.c $(grub_emu_init.c_DEPENDENCIES)
	$(CC) -I. -I$(srcdir)/. $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-grub_emu_init.d


grub_emu_LDFLAGS = $(LIBCURSES)

ifeq ($(enable_grub_emu_usb), yes)
grub_emu_SOURCES += disk/usbms.c util/usb.c bus/usb/usb.c	\
		commands/usbtest.c

clean-utility-grub-emu.2:
	rm -f grub-emu$(EXEEXT) grub_emu-disk_usbms.o grub_emu-util_usb.o grub_emu-bus_usb_usb.o grub_emu-commands_usbtest.o

CLEAN_UTILITY_TARGETS += clean-utility-grub-emu.2

mostlyclean-utility-grub-emu.2:
	rm -f grub_emu-disk_usbms.d grub_emu-util_usb.d grub_emu-bus_usb_usb.d grub_emu-commands_usbtest.d

MOSTLYCLEAN_UTILITY_TARGETS += mostlyclean-utility-grub-emu.2

grub_emu_OBJECTS += grub_emu-disk_usbms.o grub_emu-util_usb.o grub_emu-bus_usb_usb.o grub_emu-commands_usbtest.o

grub_emu-disk_usbms.o: disk/usbms.c $(disk/usbms.c_DEPENDENCIES)
	$(CC) -Idisk -I$(srcdir)/disk $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-disk_usbms.d

grub_emu-util_usb.o: util/usb.c $(util/usb.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-util_usb.d

grub_emu-bus_usb_usb.o: bus/usb/usb.c $(bus/usb/usb.c_DEPENDENCIES)
	$(CC) -Ibus/usb -I$(srcdir)/bus/usb $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-bus_usb_usb.d

grub_emu-commands_usbtest.o: commands/usbtest.c $(commands/usbtest.c_DEPENDENCIES)
	$(CC) -Icommands -I$(srcdir)/commands $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_emu_CFLAGS) -MD -c -o $@ $<
-include grub_emu-commands_usbtest.d

grub_emu_LDFLAGS += $(LIBCURSES) $(LIBUSB)
endif

# Scripts.
sbin_SCRIPTS = grub-install
bin_SCRIPTS = grub-mkrescue

# For grub-install.
grub_install_SOURCES = util/i386/pc/grub-install.in
CLEANFILES += grub-install

grub-install: util/i386/pc/grub-install.in $(util/i386/pc/grub-install.in_DEPENDENCIES) config.status
	./config.status --file=grub-install:util/i386/pc/grub-install.in
	chmod +x $@


# For grub-mkrescue.
grub_mkrescue_SOURCES = util/i386/pc/grub-mkrescue.in
CLEANFILES += grub-mkrescue

grub-mkrescue: util/i386/pc/grub-mkrescue.in $(util/i386/pc/grub-mkrescue.in_DEPENDENCIES) config.status
	./config.status --file=grub-mkrescue:util/i386/pc/grub-mkrescue.in
	chmod +x $@


pkglib_MODULES = biosdisk.mod chain.mod \
	multiboot.mod reboot.mod halt.mod	\
	vbe.mod vbetest.mod vbeinfo.mod play.mod serial.mod	\
	ata.mod vga.mod memdisk.mod pci.mod lspci.mod	\
	aout.mod bsd.mod pxe.mod pxecmd.mod datetime.mod date.mod \
	datehook.mod lsmmap.mod ata_pthru.mod hdparm.mod \
	usb.mod uhci.mod ohci.mod usbtest.mod usbms.mod usb_keyboard.mod \
	efiemu.mod mmap.mod acpi.mod drivemap.mod

# For boot.mod.
pkglib_MODULES += boot.mod 
boot_mod_SOURCES = commands/boot.c lib/i386/pc/biosnum.c

clean-module-boot.mod.1:
	rm -f boot.mod mod-boot.o mod-boot.c pre-boot.o boot_mod-commands_boot.o boot_mod-lib_i386_pc_biosnum.o und-boot.lst

CLEAN_MODULE_TARGETS += clean-module-boot.mod.1

ifneq ($(boot_mod_EXPORTS),no)
clean-module-boot.mod-symbol.1:
	rm -f def-boot.lst

CLEAN_MODULE_TARGETS += clean-module-boot.mod-symbol.1
DEFSYMFILES += def-boot.lst
endif
mostlyclean-module-boot.mod.1:
	rm -f boot_mod-commands_boot.d boot_mod-lib_i386_pc_biosnum.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-boot.mod.1
UNDSYMFILES += und-boot.lst

ifneq ($(TARGET_APPLE_CC),1)
boot.mod: pre-boot.o mod-boot.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(boot_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-boot.o mod-boot.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
boot.mod: pre-boot.o mod-boot.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(boot_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-boot.o mod-boot.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-boot.o: $(boot_mod_DEPENDENCIES) boot_mod-commands_boot.o boot_mod-lib_i386_pc_biosnum.o
	-rm -f $@
	$(TARGET_CC) $(boot_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ boot_mod-commands_boot.o boot_mod-lib_i386_pc_biosnum.o

mod-boot.o: mod-boot.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -c -o $@ $<

mod-boot.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'boot' $< > $@ || (rm -f $@; exit 1)

ifneq ($(boot_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-boot.lst: pre-boot.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 boot/' > $@
else
def-boot.lst: pre-boot.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 boot/' > $@
endif
endif

und-boot.lst: pre-boot.o
	echo 'boot' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

boot_mod-commands_boot.o: commands/boot.c $(commands/boot.c_DEPENDENCIES)
	$(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -MD -c -o $@ $<
-include boot_mod-commands_boot.d

clean-module-boot_mod-commands_boot-extra.1:
	rm -f cmd-boot_mod-commands_boot.lst fs-boot_mod-commands_boot.lst partmap-boot_mod-commands_boot.lst handler-boot_mod-commands_boot.lst parttool-boot_mod-commands_boot.lst

CLEAN_MODULE_TARGETS += clean-module-boot_mod-commands_boot-extra.1

COMMANDFILES += cmd-boot_mod-commands_boot.lst
FSFILES += fs-boot_mod-commands_boot.lst
PARTTOOLFILES += parttool-boot_mod-commands_boot.lst
PARTMAPFILES += partmap-boot_mod-commands_boot.lst
HANDLERFILES += handler-boot_mod-commands_boot.lst

cmd-boot_mod-commands_boot.lst: commands/boot.c $(commands/boot.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh boot > $@ || (rm -f $@; exit 1)

fs-boot_mod-commands_boot.lst: commands/boot.c $(commands/boot.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh boot > $@ || (rm -f $@; exit 1)

parttool-boot_mod-commands_boot.lst: commands/boot.c $(commands/boot.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh boot > $@ || (rm -f $@; exit 1)

partmap-boot_mod-commands_boot.lst: commands/boot.c $(commands/boot.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh boot > $@ || (rm -f $@; exit 1)

handler-boot_mod-commands_boot.lst: commands/boot.c $(commands/boot.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh boot > $@ || (rm -f $@; exit 1)

boot_mod-lib_i386_pc_biosnum.o: lib/i386/pc/biosnum.c $(lib/i386/pc/biosnum.c_DEPENDENCIES)
	$(TARGET_CC) -Ilib/i386/pc -I$(srcdir)/lib/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -MD -c -o $@ $<
-include boot_mod-lib_i386_pc_biosnum.d

clean-module-boot_mod-lib_i386_pc_biosnum-extra.1:
	rm -f cmd-boot_mod-lib_i386_pc_biosnum.lst fs-boot_mod-lib_i386_pc_biosnum.lst partmap-boot_mod-lib_i386_pc_biosnum.lst handler-boot_mod-lib_i386_pc_biosnum.lst parttool-boot_mod-lib_i386_pc_biosnum.lst

CLEAN_MODULE_TARGETS += clean-module-boot_mod-lib_i386_pc_biosnum-extra.1

COMMANDFILES += cmd-boot_mod-lib_i386_pc_biosnum.lst
FSFILES += fs-boot_mod-lib_i386_pc_biosnum.lst
PARTTOOLFILES += parttool-boot_mod-lib_i386_pc_biosnum.lst
PARTMAPFILES += partmap-boot_mod-lib_i386_pc_biosnum.lst
HANDLERFILES += handler-boot_mod-lib_i386_pc_biosnum.lst

cmd-boot_mod-lib_i386_pc_biosnum.lst: lib/i386/pc/biosnum.c $(lib/i386/pc/biosnum.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Ilib/i386/pc -I$(srcdir)/lib/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh boot > $@ || (rm -f $@; exit 1)

fs-boot_mod-lib_i386_pc_biosnum.lst: lib/i386/pc/biosnum.c $(lib/i386/pc/biosnum.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Ilib/i386/pc -I$(srcdir)/lib/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh boot > $@ || (rm -f $@; exit 1)

parttool-boot_mod-lib_i386_pc_biosnum.lst: lib/i386/pc/biosnum.c $(lib/i386/pc/biosnum.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Ilib/i386/pc -I$(srcdir)/lib/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh boot > $@ || (rm -f $@; exit 1)

partmap-boot_mod-lib_i386_pc_biosnum.lst: lib/i386/pc/biosnum.c $(lib/i386/pc/biosnum.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Ilib/i386/pc -I$(srcdir)/lib/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh boot > $@ || (rm -f $@; exit 1)

handler-boot_mod-lib_i386_pc_biosnum.lst: lib/i386/pc/biosnum.c $(lib/i386/pc/biosnum.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Ilib/i386/pc -I$(srcdir)/lib/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh boot > $@ || (rm -f $@; exit 1)

boot_mod_CFLAGS = $(COMMON_CFLAGS)
boot_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For drivemap.mod.
drivemap_mod_SOURCES = commands/i386/pc/drivemap.c \
                       commands/i386/pc/drivemap_int13h.S

clean-module-drivemap.mod.1:
	rm -f drivemap.mod mod-drivemap.o mod-drivemap.c pre-drivemap.o drivemap_mod-commands_i386_pc_drivemap.o drivemap_mod-commands_i386_pc_drivemap_int13h.o und-drivemap.lst

CLEAN_MODULE_TARGETS += clean-module-drivemap.mod.1

ifneq ($(drivemap_mod_EXPORTS),no)
clean-module-drivemap.mod-symbol.1:
	rm -f def-drivemap.lst

CLEAN_MODULE_TARGETS += clean-module-drivemap.mod-symbol.1
DEFSYMFILES += def-drivemap.lst
endif
mostlyclean-module-drivemap.mod.1:
	rm -f drivemap_mod-commands_i386_pc_drivemap.d drivemap_mod-commands_i386_pc_drivemap_int13h.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-drivemap.mod.1
UNDSYMFILES += und-drivemap.lst

ifneq ($(TARGET_APPLE_CC),1)
drivemap.mod: pre-drivemap.o mod-drivemap.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(drivemap_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-drivemap.o mod-drivemap.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
drivemap.mod: pre-drivemap.o mod-drivemap.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(drivemap_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-drivemap.o mod-drivemap.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-drivemap.o: $(drivemap_mod_DEPENDENCIES) drivemap_mod-commands_i386_pc_drivemap.o drivemap_mod-commands_i386_pc_drivemap_int13h.o
	-rm -f $@
	$(TARGET_CC) $(drivemap_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ drivemap_mod-commands_i386_pc_drivemap.o drivemap_mod-commands_i386_pc_drivemap_int13h.o

mod-drivemap.o: mod-drivemap.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(drivemap_mod_CFLAGS) -c -o $@ $<

mod-drivemap.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'drivemap' $< > $@ || (rm -f $@; exit 1)

ifneq ($(drivemap_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-drivemap.lst: pre-drivemap.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 drivemap/' > $@
else
def-drivemap.lst: pre-drivemap.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 drivemap/' > $@
endif
endif

und-drivemap.lst: pre-drivemap.o
	echo 'drivemap' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

drivemap_mod-commands_i386_pc_drivemap.o: commands/i386/pc/drivemap.c $(commands/i386/pc/drivemap.c_DEPENDENCIES)
	$(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(drivemap_mod_CFLAGS) -MD -c -o $@ $<
-include drivemap_mod-commands_i386_pc_drivemap.d

clean-module-drivemap_mod-commands_i386_pc_drivemap-extra.1:
	rm -f cmd-drivemap_mod-commands_i386_pc_drivemap.lst fs-drivemap_mod-commands_i386_pc_drivemap.lst partmap-drivemap_mod-commands_i386_pc_drivemap.lst handler-drivemap_mod-commands_i386_pc_drivemap.lst parttool-drivemap_mod-commands_i386_pc_drivemap.lst

CLEAN_MODULE_TARGETS += clean-module-drivemap_mod-commands_i386_pc_drivemap-extra.1

COMMANDFILES += cmd-drivemap_mod-commands_i386_pc_drivemap.lst
FSFILES += fs-drivemap_mod-commands_i386_pc_drivemap.lst
PARTTOOLFILES += parttool-drivemap_mod-commands_i386_pc_drivemap.lst
PARTMAPFILES += partmap-drivemap_mod-commands_i386_pc_drivemap.lst
HANDLERFILES += handler-drivemap_mod-commands_i386_pc_drivemap.lst

cmd-drivemap_mod-commands_i386_pc_drivemap.lst: commands/i386/pc/drivemap.c $(commands/i386/pc/drivemap.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(drivemap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh drivemap > $@ || (rm -f $@; exit 1)

fs-drivemap_mod-commands_i386_pc_drivemap.lst: commands/i386/pc/drivemap.c $(commands/i386/pc/drivemap.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(drivemap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh drivemap > $@ || (rm -f $@; exit 1)

parttool-drivemap_mod-commands_i386_pc_drivemap.lst: commands/i386/pc/drivemap.c $(commands/i386/pc/drivemap.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(drivemap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh drivemap > $@ || (rm -f $@; exit 1)

partmap-drivemap_mod-commands_i386_pc_drivemap.lst: commands/i386/pc/drivemap.c $(commands/i386/pc/drivemap.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(drivemap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh drivemap > $@ || (rm -f $@; exit 1)

handler-drivemap_mod-commands_i386_pc_drivemap.lst: commands/i386/pc/drivemap.c $(commands/i386/pc/drivemap.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(drivemap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh drivemap > $@ || (rm -f $@; exit 1)

drivemap_mod-commands_i386_pc_drivemap_int13h.o: commands/i386/pc/drivemap_int13h.S $(commands/i386/pc/drivemap_int13h.S_DEPENDENCIES)
	$(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(drivemap_mod_ASFLAGS) -MD -c -o $@ $<
-include drivemap_mod-commands_i386_pc_drivemap_int13h.d

clean-module-drivemap_mod-commands_i386_pc_drivemap_int13h-extra.1:
	rm -f cmd-drivemap_mod-commands_i386_pc_drivemap_int13h.lst fs-drivemap_mod-commands_i386_pc_drivemap_int13h.lst partmap-drivemap_mod-commands_i386_pc_drivemap_int13h.lst handler-drivemap_mod-commands_i386_pc_drivemap_int13h.lst parttool-drivemap_mod-commands_i386_pc_drivemap_int13h.lst

CLEAN_MODULE_TARGETS += clean-module-drivemap_mod-commands_i386_pc_drivemap_int13h-extra.1

COMMANDFILES += cmd-drivemap_mod-commands_i386_pc_drivemap_int13h.lst
FSFILES += fs-drivemap_mod-commands_i386_pc_drivemap_int13h.lst
PARTTOOLFILES += parttool-drivemap_mod-commands_i386_pc_drivemap_int13h.lst
PARTMAPFILES += partmap-drivemap_mod-commands_i386_pc_drivemap_int13h.lst
HANDLERFILES += handler-drivemap_mod-commands_i386_pc_drivemap_int13h.lst

cmd-drivemap_mod-commands_i386_pc_drivemap_int13h.lst: commands/i386/pc/drivemap_int13h.S $(commands/i386/pc/drivemap_int13h.S_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(drivemap_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh drivemap > $@ || (rm -f $@; exit 1)

fs-drivemap_mod-commands_i386_pc_drivemap_int13h.lst: commands/i386/pc/drivemap_int13h.S $(commands/i386/pc/drivemap_int13h.S_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(drivemap_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh drivemap > $@ || (rm -f $@; exit 1)

parttool-drivemap_mod-commands_i386_pc_drivemap_int13h.lst: commands/i386/pc/drivemap_int13h.S $(commands/i386/pc/drivemap_int13h.S_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(drivemap_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh drivemap > $@ || (rm -f $@; exit 1)

partmap-drivemap_mod-commands_i386_pc_drivemap_int13h.lst: commands/i386/pc/drivemap_int13h.S $(commands/i386/pc/drivemap_int13h.S_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(drivemap_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh drivemap > $@ || (rm -f $@; exit 1)

handler-drivemap_mod-commands_i386_pc_drivemap_int13h.lst: commands/i386/pc/drivemap_int13h.S $(commands/i386/pc/drivemap_int13h.S_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(drivemap_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh drivemap > $@ || (rm -f $@; exit 1)

drivemap_mod_ASFLAGS = $(COMMON_ASFLAGS)
drivemap_mod_CFLAGS = $(COMMON_CFLAGS)
drivemap_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For efiemu.mod.
efiemu_mod_SOURCES = efiemu/main.c efiemu/i386/loadcore32.c \
		     efiemu/i386/loadcore64.c efiemu/i386/pc/cfgtables.c \
		     efiemu/mm.c efiemu/loadcore_common.c efiemu/symbols.c \
		     efiemu/loadcore32.c efiemu/loadcore64.c \
		     efiemu/prepare32.c efiemu/prepare64.c efiemu/pnvram.c \
		     efiemu/i386/coredetect.c

clean-module-efiemu.mod.1:
	rm -f efiemu.mod mod-efiemu.o mod-efiemu.c pre-efiemu.o efiemu_mod-efiemu_main.o efiemu_mod-efiemu_i386_loadcore32.o efiemu_mod-efiemu_i386_loadcore64.o efiemu_mod-efiemu_i386_pc_cfgtables.o efiemu_mod-efiemu_mm.o efiemu_mod-efiemu_loadcore_common.o efiemu_mod-efiemu_symbols.o efiemu_mod-efiemu_loadcore32.o efiemu_mod-efiemu_loadcore64.o efiemu_mod-efiemu_prepare32.o efiemu_mod-efiemu_prepare64.o efiemu_mod-efiemu_pnvram.o efiemu_mod-efiemu_i386_coredetect.o und-efiemu.lst

CLEAN_MODULE_TARGETS += clean-module-efiemu.mod.1

ifneq ($(efiemu_mod_EXPORTS),no)
clean-module-efiemu.mod-symbol.1:
	rm -f def-efiemu.lst

CLEAN_MODULE_TARGETS += clean-module-efiemu.mod-symbol.1
DEFSYMFILES += def-efiemu.lst
endif
mostlyclean-module-efiemu.mod.1:
	rm -f efiemu_mod-efiemu_main.d efiemu_mod-efiemu_i386_loadcore32.d efiemu_mod-efiemu_i386_loadcore64.d efiemu_mod-efiemu_i386_pc_cfgtables.d efiemu_mod-efiemu_mm.d efiemu_mod-efiemu_loadcore_common.d efiemu_mod-efiemu_symbols.d efiemu_mod-efiemu_loadcore32.d efiemu_mod-efiemu_loadcore64.d efiemu_mod-efiemu_prepare32.d efiemu_mod-efiemu_prepare64.d efiemu_mod-efiemu_pnvram.d efiemu_mod-efiemu_i386_coredetect.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-efiemu.mod.1
UNDSYMFILES += und-efiemu.lst

ifneq ($(TARGET_APPLE_CC),1)
efiemu.mod: pre-efiemu.o mod-efiemu.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(efiemu_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-efiemu.o mod-efiemu.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
efiemu.mod: pre-efiemu.o mod-efiemu.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(efiemu_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-efiemu.o mod-efiemu.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-efiemu.o: $(efiemu_mod_DEPENDENCIES) efiemu_mod-efiemu_main.o efiemu_mod-efiemu_i386_loadcore32.o efiemu_mod-efiemu_i386_loadcore64.o efiemu_mod-efiemu_i386_pc_cfgtables.o efiemu_mod-efiemu_mm.o efiemu_mod-efiemu_loadcore_common.o efiemu_mod-efiemu_symbols.o efiemu_mod-efiemu_loadcore32.o efiemu_mod-efiemu_loadcore64.o efiemu_mod-efiemu_prepare32.o efiemu_mod-efiemu_prepare64.o efiemu_mod-efiemu_pnvram.o efiemu_mod-efiemu_i386_coredetect.o
	-rm -f $@
	$(TARGET_CC) $(efiemu_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ efiemu_mod-efiemu_main.o efiemu_mod-efiemu_i386_loadcore32.o efiemu_mod-efiemu_i386_loadcore64.o efiemu_mod-efiemu_i386_pc_cfgtables.o efiemu_mod-efiemu_mm.o efiemu_mod-efiemu_loadcore_common.o efiemu_mod-efiemu_symbols.o efiemu_mod-efiemu_loadcore32.o efiemu_mod-efiemu_loadcore64.o efiemu_mod-efiemu_prepare32.o efiemu_mod-efiemu_prepare64.o efiemu_mod-efiemu_pnvram.o efiemu_mod-efiemu_i386_coredetect.o

mod-efiemu.o: mod-efiemu.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -c -o $@ $<

mod-efiemu.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'efiemu' $< > $@ || (rm -f $@; exit 1)

ifneq ($(efiemu_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-efiemu.lst: pre-efiemu.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 efiemu/' > $@
else
def-efiemu.lst: pre-efiemu.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 efiemu/' > $@
endif
endif

und-efiemu.lst: pre-efiemu.o
	echo 'efiemu' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

efiemu_mod-efiemu_main.o: efiemu/main.c $(efiemu/main.c_DEPENDENCIES)
	$(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -MD -c -o $@ $<
-include efiemu_mod-efiemu_main.d

clean-module-efiemu_mod-efiemu_main-extra.1:
	rm -f cmd-efiemu_mod-efiemu_main.lst fs-efiemu_mod-efiemu_main.lst partmap-efiemu_mod-efiemu_main.lst handler-efiemu_mod-efiemu_main.lst parttool-efiemu_mod-efiemu_main.lst

CLEAN_MODULE_TARGETS += clean-module-efiemu_mod-efiemu_main-extra.1

COMMANDFILES += cmd-efiemu_mod-efiemu_main.lst
FSFILES += fs-efiemu_mod-efiemu_main.lst
PARTTOOLFILES += parttool-efiemu_mod-efiemu_main.lst
PARTMAPFILES += partmap-efiemu_mod-efiemu_main.lst
HANDLERFILES += handler-efiemu_mod-efiemu_main.lst

cmd-efiemu_mod-efiemu_main.lst: efiemu/main.c $(efiemu/main.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh efiemu > $@ || (rm -f $@; exit 1)

fs-efiemu_mod-efiemu_main.lst: efiemu/main.c $(efiemu/main.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh efiemu > $@ || (rm -f $@; exit 1)

parttool-efiemu_mod-efiemu_main.lst: efiemu/main.c $(efiemu/main.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh efiemu > $@ || (rm -f $@; exit 1)

partmap-efiemu_mod-efiemu_main.lst: efiemu/main.c $(efiemu/main.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh efiemu > $@ || (rm -f $@; exit 1)

handler-efiemu_mod-efiemu_main.lst: efiemu/main.c $(efiemu/main.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh efiemu > $@ || (rm -f $@; exit 1)

efiemu_mod-efiemu_i386_loadcore32.o: efiemu/i386/loadcore32.c $(efiemu/i386/loadcore32.c_DEPENDENCIES)
	$(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -MD -c -o $@ $<
-include efiemu_mod-efiemu_i386_loadcore32.d

clean-module-efiemu_mod-efiemu_i386_loadcore32-extra.1:
	rm -f cmd-efiemu_mod-efiemu_i386_loadcore32.lst fs-efiemu_mod-efiemu_i386_loadcore32.lst partmap-efiemu_mod-efiemu_i386_loadcore32.lst handler-efiemu_mod-efiemu_i386_loadcore32.lst parttool-efiemu_mod-efiemu_i386_loadcore32.lst

CLEAN_MODULE_TARGETS += clean-module-efiemu_mod-efiemu_i386_loadcore32-extra.1

COMMANDFILES += cmd-efiemu_mod-efiemu_i386_loadcore32.lst
FSFILES += fs-efiemu_mod-efiemu_i386_loadcore32.lst
PARTTOOLFILES += parttool-efiemu_mod-efiemu_i386_loadcore32.lst
PARTMAPFILES += partmap-efiemu_mod-efiemu_i386_loadcore32.lst
HANDLERFILES += handler-efiemu_mod-efiemu_i386_loadcore32.lst

cmd-efiemu_mod-efiemu_i386_loadcore32.lst: efiemu/i386/loadcore32.c $(efiemu/i386/loadcore32.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh efiemu > $@ || (rm -f $@; exit 1)

fs-efiemu_mod-efiemu_i386_loadcore32.lst: efiemu/i386/loadcore32.c $(efiemu/i386/loadcore32.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh efiemu > $@ || (rm -f $@; exit 1)

parttool-efiemu_mod-efiemu_i386_loadcore32.lst: efiemu/i386/loadcore32.c $(efiemu/i386/loadcore32.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh efiemu > $@ || (rm -f $@; exit 1)

partmap-efiemu_mod-efiemu_i386_loadcore32.lst: efiemu/i386/loadcore32.c $(efiemu/i386/loadcore32.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh efiemu > $@ || (rm -f $@; exit 1)

handler-efiemu_mod-efiemu_i386_loadcore32.lst: efiemu/i386/loadcore32.c $(efiemu/i386/loadcore32.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh efiemu > $@ || (rm -f $@; exit 1)

efiemu_mod-efiemu_i386_loadcore64.o: efiemu/i386/loadcore64.c $(efiemu/i386/loadcore64.c_DEPENDENCIES)
	$(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -MD -c -o $@ $<
-include efiemu_mod-efiemu_i386_loadcore64.d

clean-module-efiemu_mod-efiemu_i386_loadcore64-extra.1:
	rm -f cmd-efiemu_mod-efiemu_i386_loadcore64.lst fs-efiemu_mod-efiemu_i386_loadcore64.lst partmap-efiemu_mod-efiemu_i386_loadcore64.lst handler-efiemu_mod-efiemu_i386_loadcore64.lst parttool-efiemu_mod-efiemu_i386_loadcore64.lst

CLEAN_MODULE_TARGETS += clean-module-efiemu_mod-efiemu_i386_loadcore64-extra.1

COMMANDFILES += cmd-efiemu_mod-efiemu_i386_loadcore64.lst
FSFILES += fs-efiemu_mod-efiemu_i386_loadcore64.lst
PARTTOOLFILES += parttool-efiemu_mod-efiemu_i386_loadcore64.lst
PARTMAPFILES += partmap-efiemu_mod-efiemu_i386_loadcore64.lst
HANDLERFILES += handler-efiemu_mod-efiemu_i386_loadcore64.lst

cmd-efiemu_mod-efiemu_i386_loadcore64.lst: efiemu/i386/loadcore64.c $(efiemu/i386/loadcore64.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh efiemu > $@ || (rm -f $@; exit 1)

fs-efiemu_mod-efiemu_i386_loadcore64.lst: efiemu/i386/loadcore64.c $(efiemu/i386/loadcore64.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh efiemu > $@ || (rm -f $@; exit 1)

parttool-efiemu_mod-efiemu_i386_loadcore64.lst: efiemu/i386/loadcore64.c $(efiemu/i386/loadcore64.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh efiemu > $@ || (rm -f $@; exit 1)

partmap-efiemu_mod-efiemu_i386_loadcore64.lst: efiemu/i386/loadcore64.c $(efiemu/i386/loadcore64.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh efiemu > $@ || (rm -f $@; exit 1)

handler-efiemu_mod-efiemu_i386_loadcore64.lst: efiemu/i386/loadcore64.c $(efiemu/i386/loadcore64.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh efiemu > $@ || (rm -f $@; exit 1)

efiemu_mod-efiemu_i386_pc_cfgtables.o: efiemu/i386/pc/cfgtables.c $(efiemu/i386/pc/cfgtables.c_DEPENDENCIES)
	$(TARGET_CC) -Iefiemu/i386/pc -I$(srcdir)/efiemu/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -MD -c -o $@ $<
-include efiemu_mod-efiemu_i386_pc_cfgtables.d

clean-module-efiemu_mod-efiemu_i386_pc_cfgtables-extra.1:
	rm -f cmd-efiemu_mod-efiemu_i386_pc_cfgtables.lst fs-efiemu_mod-efiemu_i386_pc_cfgtables.lst partmap-efiemu_mod-efiemu_i386_pc_cfgtables.lst handler-efiemu_mod-efiemu_i386_pc_cfgtables.lst parttool-efiemu_mod-efiemu_i386_pc_cfgtables.lst

CLEAN_MODULE_TARGETS += clean-module-efiemu_mod-efiemu_i386_pc_cfgtables-extra.1

COMMANDFILES += cmd-efiemu_mod-efiemu_i386_pc_cfgtables.lst
FSFILES += fs-efiemu_mod-efiemu_i386_pc_cfgtables.lst
PARTTOOLFILES += parttool-efiemu_mod-efiemu_i386_pc_cfgtables.lst
PARTMAPFILES += partmap-efiemu_mod-efiemu_i386_pc_cfgtables.lst
HANDLERFILES += handler-efiemu_mod-efiemu_i386_pc_cfgtables.lst

cmd-efiemu_mod-efiemu_i386_pc_cfgtables.lst: efiemu/i386/pc/cfgtables.c $(efiemu/i386/pc/cfgtables.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386/pc -I$(srcdir)/efiemu/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh efiemu > $@ || (rm -f $@; exit 1)

fs-efiemu_mod-efiemu_i386_pc_cfgtables.lst: efiemu/i386/pc/cfgtables.c $(efiemu/i386/pc/cfgtables.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386/pc -I$(srcdir)/efiemu/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh efiemu > $@ || (rm -f $@; exit 1)

parttool-efiemu_mod-efiemu_i386_pc_cfgtables.lst: efiemu/i386/pc/cfgtables.c $(efiemu/i386/pc/cfgtables.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386/pc -I$(srcdir)/efiemu/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh efiemu > $@ || (rm -f $@; exit 1)

partmap-efiemu_mod-efiemu_i386_pc_cfgtables.lst: efiemu/i386/pc/cfgtables.c $(efiemu/i386/pc/cfgtables.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386/pc -I$(srcdir)/efiemu/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh efiemu > $@ || (rm -f $@; exit 1)

handler-efiemu_mod-efiemu_i386_pc_cfgtables.lst: efiemu/i386/pc/cfgtables.c $(efiemu/i386/pc/cfgtables.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386/pc -I$(srcdir)/efiemu/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh efiemu > $@ || (rm -f $@; exit 1)

efiemu_mod-efiemu_mm.o: efiemu/mm.c $(efiemu/mm.c_DEPENDENCIES)
	$(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -MD -c -o $@ $<
-include efiemu_mod-efiemu_mm.d

clean-module-efiemu_mod-efiemu_mm-extra.1:
	rm -f cmd-efiemu_mod-efiemu_mm.lst fs-efiemu_mod-efiemu_mm.lst partmap-efiemu_mod-efiemu_mm.lst handler-efiemu_mod-efiemu_mm.lst parttool-efiemu_mod-efiemu_mm.lst

CLEAN_MODULE_TARGETS += clean-module-efiemu_mod-efiemu_mm-extra.1

COMMANDFILES += cmd-efiemu_mod-efiemu_mm.lst
FSFILES += fs-efiemu_mod-efiemu_mm.lst
PARTTOOLFILES += parttool-efiemu_mod-efiemu_mm.lst
PARTMAPFILES += partmap-efiemu_mod-efiemu_mm.lst
HANDLERFILES += handler-efiemu_mod-efiemu_mm.lst

cmd-efiemu_mod-efiemu_mm.lst: efiemu/mm.c $(efiemu/mm.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh efiemu > $@ || (rm -f $@; exit 1)

fs-efiemu_mod-efiemu_mm.lst: efiemu/mm.c $(efiemu/mm.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh efiemu > $@ || (rm -f $@; exit 1)

parttool-efiemu_mod-efiemu_mm.lst: efiemu/mm.c $(efiemu/mm.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh efiemu > $@ || (rm -f $@; exit 1)

partmap-efiemu_mod-efiemu_mm.lst: efiemu/mm.c $(efiemu/mm.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh efiemu > $@ || (rm -f $@; exit 1)

handler-efiemu_mod-efiemu_mm.lst: efiemu/mm.c $(efiemu/mm.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh efiemu > $@ || (rm -f $@; exit 1)

efiemu_mod-efiemu_loadcore_common.o: efiemu/loadcore_common.c $(efiemu/loadcore_common.c_DEPENDENCIES)
	$(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -MD -c -o $@ $<
-include efiemu_mod-efiemu_loadcore_common.d

clean-module-efiemu_mod-efiemu_loadcore_common-extra.1:
	rm -f cmd-efiemu_mod-efiemu_loadcore_common.lst fs-efiemu_mod-efiemu_loadcore_common.lst partmap-efiemu_mod-efiemu_loadcore_common.lst handler-efiemu_mod-efiemu_loadcore_common.lst parttool-efiemu_mod-efiemu_loadcore_common.lst

CLEAN_MODULE_TARGETS += clean-module-efiemu_mod-efiemu_loadcore_common-extra.1

COMMANDFILES += cmd-efiemu_mod-efiemu_loadcore_common.lst
FSFILES += fs-efiemu_mod-efiemu_loadcore_common.lst
PARTTOOLFILES += parttool-efiemu_mod-efiemu_loadcore_common.lst
PARTMAPFILES += partmap-efiemu_mod-efiemu_loadcore_common.lst
HANDLERFILES += handler-efiemu_mod-efiemu_loadcore_common.lst

cmd-efiemu_mod-efiemu_loadcore_common.lst: efiemu/loadcore_common.c $(efiemu/loadcore_common.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh efiemu > $@ || (rm -f $@; exit 1)

fs-efiemu_mod-efiemu_loadcore_common.lst: efiemu/loadcore_common.c $(efiemu/loadcore_common.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh efiemu > $@ || (rm -f $@; exit 1)

parttool-efiemu_mod-efiemu_loadcore_common.lst: efiemu/loadcore_common.c $(efiemu/loadcore_common.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh efiemu > $@ || (rm -f $@; exit 1)

partmap-efiemu_mod-efiemu_loadcore_common.lst: efiemu/loadcore_common.c $(efiemu/loadcore_common.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh efiemu > $@ || (rm -f $@; exit 1)

handler-efiemu_mod-efiemu_loadcore_common.lst: efiemu/loadcore_common.c $(efiemu/loadcore_common.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh efiemu > $@ || (rm -f $@; exit 1)

efiemu_mod-efiemu_symbols.o: efiemu/symbols.c $(efiemu/symbols.c_DEPENDENCIES)
	$(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -MD -c -o $@ $<
-include efiemu_mod-efiemu_symbols.d

clean-module-efiemu_mod-efiemu_symbols-extra.1:
	rm -f cmd-efiemu_mod-efiemu_symbols.lst fs-efiemu_mod-efiemu_symbols.lst partmap-efiemu_mod-efiemu_symbols.lst handler-efiemu_mod-efiemu_symbols.lst parttool-efiemu_mod-efiemu_symbols.lst

CLEAN_MODULE_TARGETS += clean-module-efiemu_mod-efiemu_symbols-extra.1

COMMANDFILES += cmd-efiemu_mod-efiemu_symbols.lst
FSFILES += fs-efiemu_mod-efiemu_symbols.lst
PARTTOOLFILES += parttool-efiemu_mod-efiemu_symbols.lst
PARTMAPFILES += partmap-efiemu_mod-efiemu_symbols.lst
HANDLERFILES += handler-efiemu_mod-efiemu_symbols.lst

cmd-efiemu_mod-efiemu_symbols.lst: efiemu/symbols.c $(efiemu/symbols.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh efiemu > $@ || (rm -f $@; exit 1)

fs-efiemu_mod-efiemu_symbols.lst: efiemu/symbols.c $(efiemu/symbols.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh efiemu > $@ || (rm -f $@; exit 1)

parttool-efiemu_mod-efiemu_symbols.lst: efiemu/symbols.c $(efiemu/symbols.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh efiemu > $@ || (rm -f $@; exit 1)

partmap-efiemu_mod-efiemu_symbols.lst: efiemu/symbols.c $(efiemu/symbols.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh efiemu > $@ || (rm -f $@; exit 1)

handler-efiemu_mod-efiemu_symbols.lst: efiemu/symbols.c $(efiemu/symbols.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh efiemu > $@ || (rm -f $@; exit 1)

efiemu_mod-efiemu_loadcore32.o: efiemu/loadcore32.c $(efiemu/loadcore32.c_DEPENDENCIES)
	$(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -MD -c -o $@ $<
-include efiemu_mod-efiemu_loadcore32.d

clean-module-efiemu_mod-efiemu_loadcore32-extra.1:
	rm -f cmd-efiemu_mod-efiemu_loadcore32.lst fs-efiemu_mod-efiemu_loadcore32.lst partmap-efiemu_mod-efiemu_loadcore32.lst handler-efiemu_mod-efiemu_loadcore32.lst parttool-efiemu_mod-efiemu_loadcore32.lst

CLEAN_MODULE_TARGETS += clean-module-efiemu_mod-efiemu_loadcore32-extra.1

COMMANDFILES += cmd-efiemu_mod-efiemu_loadcore32.lst
FSFILES += fs-efiemu_mod-efiemu_loadcore32.lst
PARTTOOLFILES += parttool-efiemu_mod-efiemu_loadcore32.lst
PARTMAPFILES += partmap-efiemu_mod-efiemu_loadcore32.lst
HANDLERFILES += handler-efiemu_mod-efiemu_loadcore32.lst

cmd-efiemu_mod-efiemu_loadcore32.lst: efiemu/loadcore32.c $(efiemu/loadcore32.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh efiemu > $@ || (rm -f $@; exit 1)

fs-efiemu_mod-efiemu_loadcore32.lst: efiemu/loadcore32.c $(efiemu/loadcore32.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh efiemu > $@ || (rm -f $@; exit 1)

parttool-efiemu_mod-efiemu_loadcore32.lst: efiemu/loadcore32.c $(efiemu/loadcore32.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh efiemu > $@ || (rm -f $@; exit 1)

partmap-efiemu_mod-efiemu_loadcore32.lst: efiemu/loadcore32.c $(efiemu/loadcore32.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh efiemu > $@ || (rm -f $@; exit 1)

handler-efiemu_mod-efiemu_loadcore32.lst: efiemu/loadcore32.c $(efiemu/loadcore32.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh efiemu > $@ || (rm -f $@; exit 1)

efiemu_mod-efiemu_loadcore64.o: efiemu/loadcore64.c $(efiemu/loadcore64.c_DEPENDENCIES)
	$(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -MD -c -o $@ $<
-include efiemu_mod-efiemu_loadcore64.d

clean-module-efiemu_mod-efiemu_loadcore64-extra.1:
	rm -f cmd-efiemu_mod-efiemu_loadcore64.lst fs-efiemu_mod-efiemu_loadcore64.lst partmap-efiemu_mod-efiemu_loadcore64.lst handler-efiemu_mod-efiemu_loadcore64.lst parttool-efiemu_mod-efiemu_loadcore64.lst

CLEAN_MODULE_TARGETS += clean-module-efiemu_mod-efiemu_loadcore64-extra.1

COMMANDFILES += cmd-efiemu_mod-efiemu_loadcore64.lst
FSFILES += fs-efiemu_mod-efiemu_loadcore64.lst
PARTTOOLFILES += parttool-efiemu_mod-efiemu_loadcore64.lst
PARTMAPFILES += partmap-efiemu_mod-efiemu_loadcore64.lst
HANDLERFILES += handler-efiemu_mod-efiemu_loadcore64.lst

cmd-efiemu_mod-efiemu_loadcore64.lst: efiemu/loadcore64.c $(efiemu/loadcore64.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh efiemu > $@ || (rm -f $@; exit 1)

fs-efiemu_mod-efiemu_loadcore64.lst: efiemu/loadcore64.c $(efiemu/loadcore64.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh efiemu > $@ || (rm -f $@; exit 1)

parttool-efiemu_mod-efiemu_loadcore64.lst: efiemu/loadcore64.c $(efiemu/loadcore64.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh efiemu > $@ || (rm -f $@; exit 1)

partmap-efiemu_mod-efiemu_loadcore64.lst: efiemu/loadcore64.c $(efiemu/loadcore64.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh efiemu > $@ || (rm -f $@; exit 1)

handler-efiemu_mod-efiemu_loadcore64.lst: efiemu/loadcore64.c $(efiemu/loadcore64.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh efiemu > $@ || (rm -f $@; exit 1)

efiemu_mod-efiemu_prepare32.o: efiemu/prepare32.c $(efiemu/prepare32.c_DEPENDENCIES)
	$(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -MD -c -o $@ $<
-include efiemu_mod-efiemu_prepare32.d

clean-module-efiemu_mod-efiemu_prepare32-extra.1:
	rm -f cmd-efiemu_mod-efiemu_prepare32.lst fs-efiemu_mod-efiemu_prepare32.lst partmap-efiemu_mod-efiemu_prepare32.lst handler-efiemu_mod-efiemu_prepare32.lst parttool-efiemu_mod-efiemu_prepare32.lst

CLEAN_MODULE_TARGETS += clean-module-efiemu_mod-efiemu_prepare32-extra.1

COMMANDFILES += cmd-efiemu_mod-efiemu_prepare32.lst
FSFILES += fs-efiemu_mod-efiemu_prepare32.lst
PARTTOOLFILES += parttool-efiemu_mod-efiemu_prepare32.lst
PARTMAPFILES += partmap-efiemu_mod-efiemu_prepare32.lst
HANDLERFILES += handler-efiemu_mod-efiemu_prepare32.lst

cmd-efiemu_mod-efiemu_prepare32.lst: efiemu/prepare32.c $(efiemu/prepare32.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh efiemu > $@ || (rm -f $@; exit 1)

fs-efiemu_mod-efiemu_prepare32.lst: efiemu/prepare32.c $(efiemu/prepare32.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh efiemu > $@ || (rm -f $@; exit 1)

parttool-efiemu_mod-efiemu_prepare32.lst: efiemu/prepare32.c $(efiemu/prepare32.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh efiemu > $@ || (rm -f $@; exit 1)

partmap-efiemu_mod-efiemu_prepare32.lst: efiemu/prepare32.c $(efiemu/prepare32.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh efiemu > $@ || (rm -f $@; exit 1)

handler-efiemu_mod-efiemu_prepare32.lst: efiemu/prepare32.c $(efiemu/prepare32.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh efiemu > $@ || (rm -f $@; exit 1)

efiemu_mod-efiemu_prepare64.o: efiemu/prepare64.c $(efiemu/prepare64.c_DEPENDENCIES)
	$(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -MD -c -o $@ $<
-include efiemu_mod-efiemu_prepare64.d

clean-module-efiemu_mod-efiemu_prepare64-extra.1:
	rm -f cmd-efiemu_mod-efiemu_prepare64.lst fs-efiemu_mod-efiemu_prepare64.lst partmap-efiemu_mod-efiemu_prepare64.lst handler-efiemu_mod-efiemu_prepare64.lst parttool-efiemu_mod-efiemu_prepare64.lst

CLEAN_MODULE_TARGETS += clean-module-efiemu_mod-efiemu_prepare64-extra.1

COMMANDFILES += cmd-efiemu_mod-efiemu_prepare64.lst
FSFILES += fs-efiemu_mod-efiemu_prepare64.lst
PARTTOOLFILES += parttool-efiemu_mod-efiemu_prepare64.lst
PARTMAPFILES += partmap-efiemu_mod-efiemu_prepare64.lst
HANDLERFILES += handler-efiemu_mod-efiemu_prepare64.lst

cmd-efiemu_mod-efiemu_prepare64.lst: efiemu/prepare64.c $(efiemu/prepare64.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh efiemu > $@ || (rm -f $@; exit 1)

fs-efiemu_mod-efiemu_prepare64.lst: efiemu/prepare64.c $(efiemu/prepare64.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh efiemu > $@ || (rm -f $@; exit 1)

parttool-efiemu_mod-efiemu_prepare64.lst: efiemu/prepare64.c $(efiemu/prepare64.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh efiemu > $@ || (rm -f $@; exit 1)

partmap-efiemu_mod-efiemu_prepare64.lst: efiemu/prepare64.c $(efiemu/prepare64.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh efiemu > $@ || (rm -f $@; exit 1)

handler-efiemu_mod-efiemu_prepare64.lst: efiemu/prepare64.c $(efiemu/prepare64.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh efiemu > $@ || (rm -f $@; exit 1)

efiemu_mod-efiemu_pnvram.o: efiemu/pnvram.c $(efiemu/pnvram.c_DEPENDENCIES)
	$(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -MD -c -o $@ $<
-include efiemu_mod-efiemu_pnvram.d

clean-module-efiemu_mod-efiemu_pnvram-extra.1:
	rm -f cmd-efiemu_mod-efiemu_pnvram.lst fs-efiemu_mod-efiemu_pnvram.lst partmap-efiemu_mod-efiemu_pnvram.lst handler-efiemu_mod-efiemu_pnvram.lst parttool-efiemu_mod-efiemu_pnvram.lst

CLEAN_MODULE_TARGETS += clean-module-efiemu_mod-efiemu_pnvram-extra.1

COMMANDFILES += cmd-efiemu_mod-efiemu_pnvram.lst
FSFILES += fs-efiemu_mod-efiemu_pnvram.lst
PARTTOOLFILES += parttool-efiemu_mod-efiemu_pnvram.lst
PARTMAPFILES += partmap-efiemu_mod-efiemu_pnvram.lst
HANDLERFILES += handler-efiemu_mod-efiemu_pnvram.lst

cmd-efiemu_mod-efiemu_pnvram.lst: efiemu/pnvram.c $(efiemu/pnvram.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh efiemu > $@ || (rm -f $@; exit 1)

fs-efiemu_mod-efiemu_pnvram.lst: efiemu/pnvram.c $(efiemu/pnvram.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh efiemu > $@ || (rm -f $@; exit 1)

parttool-efiemu_mod-efiemu_pnvram.lst: efiemu/pnvram.c $(efiemu/pnvram.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh efiemu > $@ || (rm -f $@; exit 1)

partmap-efiemu_mod-efiemu_pnvram.lst: efiemu/pnvram.c $(efiemu/pnvram.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh efiemu > $@ || (rm -f $@; exit 1)

handler-efiemu_mod-efiemu_pnvram.lst: efiemu/pnvram.c $(efiemu/pnvram.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu -I$(srcdir)/efiemu $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh efiemu > $@ || (rm -f $@; exit 1)

efiemu_mod-efiemu_i386_coredetect.o: efiemu/i386/coredetect.c $(efiemu/i386/coredetect.c_DEPENDENCIES)
	$(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -MD -c -o $@ $<
-include efiemu_mod-efiemu_i386_coredetect.d

clean-module-efiemu_mod-efiemu_i386_coredetect-extra.1:
	rm -f cmd-efiemu_mod-efiemu_i386_coredetect.lst fs-efiemu_mod-efiemu_i386_coredetect.lst partmap-efiemu_mod-efiemu_i386_coredetect.lst handler-efiemu_mod-efiemu_i386_coredetect.lst parttool-efiemu_mod-efiemu_i386_coredetect.lst

CLEAN_MODULE_TARGETS += clean-module-efiemu_mod-efiemu_i386_coredetect-extra.1

COMMANDFILES += cmd-efiemu_mod-efiemu_i386_coredetect.lst
FSFILES += fs-efiemu_mod-efiemu_i386_coredetect.lst
PARTTOOLFILES += parttool-efiemu_mod-efiemu_i386_coredetect.lst
PARTMAPFILES += partmap-efiemu_mod-efiemu_i386_coredetect.lst
HANDLERFILES += handler-efiemu_mod-efiemu_i386_coredetect.lst

cmd-efiemu_mod-efiemu_i386_coredetect.lst: efiemu/i386/coredetect.c $(efiemu/i386/coredetect.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh efiemu > $@ || (rm -f $@; exit 1)

fs-efiemu_mod-efiemu_i386_coredetect.lst: efiemu/i386/coredetect.c $(efiemu/i386/coredetect.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh efiemu > $@ || (rm -f $@; exit 1)

parttool-efiemu_mod-efiemu_i386_coredetect.lst: efiemu/i386/coredetect.c $(efiemu/i386/coredetect.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh efiemu > $@ || (rm -f $@; exit 1)

partmap-efiemu_mod-efiemu_i386_coredetect.lst: efiemu/i386/coredetect.c $(efiemu/i386/coredetect.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh efiemu > $@ || (rm -f $@; exit 1)

handler-efiemu_mod-efiemu_i386_coredetect.lst: efiemu/i386/coredetect.c $(efiemu/i386/coredetect.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iefiemu/i386 -I$(srcdir)/efiemu/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(efiemu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh efiemu > $@ || (rm -f $@; exit 1)

efiemu_mod_CFLAGS = $(COMMON_CFLAGS)
efiemu_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For acpi.mod.
acpi_mod_SOURCES = commands/acpi.c commands/i386/pc/acpi.c

clean-module-acpi.mod.1:
	rm -f acpi.mod mod-acpi.o mod-acpi.c pre-acpi.o acpi_mod-commands_acpi.o acpi_mod-commands_i386_pc_acpi.o und-acpi.lst

CLEAN_MODULE_TARGETS += clean-module-acpi.mod.1

ifneq ($(acpi_mod_EXPORTS),no)
clean-module-acpi.mod-symbol.1:
	rm -f def-acpi.lst

CLEAN_MODULE_TARGETS += clean-module-acpi.mod-symbol.1
DEFSYMFILES += def-acpi.lst
endif
mostlyclean-module-acpi.mod.1:
	rm -f acpi_mod-commands_acpi.d acpi_mod-commands_i386_pc_acpi.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-acpi.mod.1
UNDSYMFILES += und-acpi.lst

ifneq ($(TARGET_APPLE_CC),1)
acpi.mod: pre-acpi.o mod-acpi.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(acpi_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-acpi.o mod-acpi.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
acpi.mod: pre-acpi.o mod-acpi.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(acpi_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-acpi.o mod-acpi.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-acpi.o: $(acpi_mod_DEPENDENCIES) acpi_mod-commands_acpi.o acpi_mod-commands_i386_pc_acpi.o
	-rm -f $@
	$(TARGET_CC) $(acpi_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ acpi_mod-commands_acpi.o acpi_mod-commands_i386_pc_acpi.o

mod-acpi.o: mod-acpi.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(acpi_mod_CFLAGS) -c -o $@ $<

mod-acpi.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'acpi' $< > $@ || (rm -f $@; exit 1)

ifneq ($(acpi_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-acpi.lst: pre-acpi.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 acpi/' > $@
else
def-acpi.lst: pre-acpi.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 acpi/' > $@
endif
endif

und-acpi.lst: pre-acpi.o
	echo 'acpi' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

acpi_mod-commands_acpi.o: commands/acpi.c $(commands/acpi.c_DEPENDENCIES)
	$(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(acpi_mod_CFLAGS) -MD -c -o $@ $<
-include acpi_mod-commands_acpi.d

clean-module-acpi_mod-commands_acpi-extra.1:
	rm -f cmd-acpi_mod-commands_acpi.lst fs-acpi_mod-commands_acpi.lst partmap-acpi_mod-commands_acpi.lst handler-acpi_mod-commands_acpi.lst parttool-acpi_mod-commands_acpi.lst

CLEAN_MODULE_TARGETS += clean-module-acpi_mod-commands_acpi-extra.1

COMMANDFILES += cmd-acpi_mod-commands_acpi.lst
FSFILES += fs-acpi_mod-commands_acpi.lst
PARTTOOLFILES += parttool-acpi_mod-commands_acpi.lst
PARTMAPFILES += partmap-acpi_mod-commands_acpi.lst
HANDLERFILES += handler-acpi_mod-commands_acpi.lst

cmd-acpi_mod-commands_acpi.lst: commands/acpi.c $(commands/acpi.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(acpi_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh acpi > $@ || (rm -f $@; exit 1)

fs-acpi_mod-commands_acpi.lst: commands/acpi.c $(commands/acpi.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(acpi_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh acpi > $@ || (rm -f $@; exit 1)

parttool-acpi_mod-commands_acpi.lst: commands/acpi.c $(commands/acpi.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(acpi_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh acpi > $@ || (rm -f $@; exit 1)

partmap-acpi_mod-commands_acpi.lst: commands/acpi.c $(commands/acpi.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(acpi_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh acpi > $@ || (rm -f $@; exit 1)

handler-acpi_mod-commands_acpi.lst: commands/acpi.c $(commands/acpi.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(acpi_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh acpi > $@ || (rm -f $@; exit 1)

acpi_mod-commands_i386_pc_acpi.o: commands/i386/pc/acpi.c $(commands/i386/pc/acpi.c_DEPENDENCIES)
	$(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(acpi_mod_CFLAGS) -MD -c -o $@ $<
-include acpi_mod-commands_i386_pc_acpi.d

clean-module-acpi_mod-commands_i386_pc_acpi-extra.1:
	rm -f cmd-acpi_mod-commands_i386_pc_acpi.lst fs-acpi_mod-commands_i386_pc_acpi.lst partmap-acpi_mod-commands_i386_pc_acpi.lst handler-acpi_mod-commands_i386_pc_acpi.lst parttool-acpi_mod-commands_i386_pc_acpi.lst

CLEAN_MODULE_TARGETS += clean-module-acpi_mod-commands_i386_pc_acpi-extra.1

COMMANDFILES += cmd-acpi_mod-commands_i386_pc_acpi.lst
FSFILES += fs-acpi_mod-commands_i386_pc_acpi.lst
PARTTOOLFILES += parttool-acpi_mod-commands_i386_pc_acpi.lst
PARTMAPFILES += partmap-acpi_mod-commands_i386_pc_acpi.lst
HANDLERFILES += handler-acpi_mod-commands_i386_pc_acpi.lst

cmd-acpi_mod-commands_i386_pc_acpi.lst: commands/i386/pc/acpi.c $(commands/i386/pc/acpi.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(acpi_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh acpi > $@ || (rm -f $@; exit 1)

fs-acpi_mod-commands_i386_pc_acpi.lst: commands/i386/pc/acpi.c $(commands/i386/pc/acpi.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(acpi_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh acpi > $@ || (rm -f $@; exit 1)

parttool-acpi_mod-commands_i386_pc_acpi.lst: commands/i386/pc/acpi.c $(commands/i386/pc/acpi.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(acpi_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh acpi > $@ || (rm -f $@; exit 1)

partmap-acpi_mod-commands_i386_pc_acpi.lst: commands/i386/pc/acpi.c $(commands/i386/pc/acpi.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(acpi_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh acpi > $@ || (rm -f $@; exit 1)

handler-acpi_mod-commands_i386_pc_acpi.lst: commands/i386/pc/acpi.c $(commands/i386/pc/acpi.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(acpi_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh acpi > $@ || (rm -f $@; exit 1)

acpi_mod_CFLAGS = $(COMMON_CFLAGS)
acpi_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For mmap.mod.
mmap_mod_SOURCES = mmap/mmap.c mmap/i386/uppermem.c mmap/i386/mmap.c \
		   mmap/i386/pc/mmap.c mmap/i386/pc/mmap_helper.S

clean-module-mmap.mod.1:
	rm -f mmap.mod mod-mmap.o mod-mmap.c pre-mmap.o mmap_mod-mmap_mmap.o mmap_mod-mmap_i386_uppermem.o mmap_mod-mmap_i386_mmap.o mmap_mod-mmap_i386_pc_mmap.o mmap_mod-mmap_i386_pc_mmap_helper.o und-mmap.lst

CLEAN_MODULE_TARGETS += clean-module-mmap.mod.1

ifneq ($(mmap_mod_EXPORTS),no)
clean-module-mmap.mod-symbol.1:
	rm -f def-mmap.lst

CLEAN_MODULE_TARGETS += clean-module-mmap.mod-symbol.1
DEFSYMFILES += def-mmap.lst
endif
mostlyclean-module-mmap.mod.1:
	rm -f mmap_mod-mmap_mmap.d mmap_mod-mmap_i386_uppermem.d mmap_mod-mmap_i386_mmap.d mmap_mod-mmap_i386_pc_mmap.d mmap_mod-mmap_i386_pc_mmap_helper.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-mmap.mod.1
UNDSYMFILES += und-mmap.lst

ifneq ($(TARGET_APPLE_CC),1)
mmap.mod: pre-mmap.o mod-mmap.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(mmap_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-mmap.o mod-mmap.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
mmap.mod: pre-mmap.o mod-mmap.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(mmap_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-mmap.o mod-mmap.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-mmap.o: $(mmap_mod_DEPENDENCIES) mmap_mod-mmap_mmap.o mmap_mod-mmap_i386_uppermem.o mmap_mod-mmap_i386_mmap.o mmap_mod-mmap_i386_pc_mmap.o mmap_mod-mmap_i386_pc_mmap_helper.o
	-rm -f $@
	$(TARGET_CC) $(mmap_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ mmap_mod-mmap_mmap.o mmap_mod-mmap_i386_uppermem.o mmap_mod-mmap_i386_mmap.o mmap_mod-mmap_i386_pc_mmap.o mmap_mod-mmap_i386_pc_mmap_helper.o

mod-mmap.o: mod-mmap.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -c -o $@ $<

mod-mmap.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'mmap' $< > $@ || (rm -f $@; exit 1)

ifneq ($(mmap_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-mmap.lst: pre-mmap.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 mmap/' > $@
else
def-mmap.lst: pre-mmap.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 mmap/' > $@
endif
endif

und-mmap.lst: pre-mmap.o
	echo 'mmap' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

mmap_mod-mmap_mmap.o: mmap/mmap.c $(mmap/mmap.c_DEPENDENCIES)
	$(TARGET_CC) -Immap -I$(srcdir)/mmap $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -MD -c -o $@ $<
-include mmap_mod-mmap_mmap.d

clean-module-mmap_mod-mmap_mmap-extra.1:
	rm -f cmd-mmap_mod-mmap_mmap.lst fs-mmap_mod-mmap_mmap.lst partmap-mmap_mod-mmap_mmap.lst handler-mmap_mod-mmap_mmap.lst parttool-mmap_mod-mmap_mmap.lst

CLEAN_MODULE_TARGETS += clean-module-mmap_mod-mmap_mmap-extra.1

COMMANDFILES += cmd-mmap_mod-mmap_mmap.lst
FSFILES += fs-mmap_mod-mmap_mmap.lst
PARTTOOLFILES += parttool-mmap_mod-mmap_mmap.lst
PARTMAPFILES += partmap-mmap_mod-mmap_mmap.lst
HANDLERFILES += handler-mmap_mod-mmap_mmap.lst

cmd-mmap_mod-mmap_mmap.lst: mmap/mmap.c $(mmap/mmap.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Immap -I$(srcdir)/mmap $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh mmap > $@ || (rm -f $@; exit 1)

fs-mmap_mod-mmap_mmap.lst: mmap/mmap.c $(mmap/mmap.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Immap -I$(srcdir)/mmap $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh mmap > $@ || (rm -f $@; exit 1)

parttool-mmap_mod-mmap_mmap.lst: mmap/mmap.c $(mmap/mmap.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Immap -I$(srcdir)/mmap $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh mmap > $@ || (rm -f $@; exit 1)

partmap-mmap_mod-mmap_mmap.lst: mmap/mmap.c $(mmap/mmap.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Immap -I$(srcdir)/mmap $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh mmap > $@ || (rm -f $@; exit 1)

handler-mmap_mod-mmap_mmap.lst: mmap/mmap.c $(mmap/mmap.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Immap -I$(srcdir)/mmap $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh mmap > $@ || (rm -f $@; exit 1)

mmap_mod-mmap_i386_uppermem.o: mmap/i386/uppermem.c $(mmap/i386/uppermem.c_DEPENDENCIES)
	$(TARGET_CC) -Immap/i386 -I$(srcdir)/mmap/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -MD -c -o $@ $<
-include mmap_mod-mmap_i386_uppermem.d

clean-module-mmap_mod-mmap_i386_uppermem-extra.1:
	rm -f cmd-mmap_mod-mmap_i386_uppermem.lst fs-mmap_mod-mmap_i386_uppermem.lst partmap-mmap_mod-mmap_i386_uppermem.lst handler-mmap_mod-mmap_i386_uppermem.lst parttool-mmap_mod-mmap_i386_uppermem.lst

CLEAN_MODULE_TARGETS += clean-module-mmap_mod-mmap_i386_uppermem-extra.1

COMMANDFILES += cmd-mmap_mod-mmap_i386_uppermem.lst
FSFILES += fs-mmap_mod-mmap_i386_uppermem.lst
PARTTOOLFILES += parttool-mmap_mod-mmap_i386_uppermem.lst
PARTMAPFILES += partmap-mmap_mod-mmap_i386_uppermem.lst
HANDLERFILES += handler-mmap_mod-mmap_i386_uppermem.lst

cmd-mmap_mod-mmap_i386_uppermem.lst: mmap/i386/uppermem.c $(mmap/i386/uppermem.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386 -I$(srcdir)/mmap/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh mmap > $@ || (rm -f $@; exit 1)

fs-mmap_mod-mmap_i386_uppermem.lst: mmap/i386/uppermem.c $(mmap/i386/uppermem.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386 -I$(srcdir)/mmap/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh mmap > $@ || (rm -f $@; exit 1)

parttool-mmap_mod-mmap_i386_uppermem.lst: mmap/i386/uppermem.c $(mmap/i386/uppermem.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386 -I$(srcdir)/mmap/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh mmap > $@ || (rm -f $@; exit 1)

partmap-mmap_mod-mmap_i386_uppermem.lst: mmap/i386/uppermem.c $(mmap/i386/uppermem.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386 -I$(srcdir)/mmap/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh mmap > $@ || (rm -f $@; exit 1)

handler-mmap_mod-mmap_i386_uppermem.lst: mmap/i386/uppermem.c $(mmap/i386/uppermem.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386 -I$(srcdir)/mmap/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh mmap > $@ || (rm -f $@; exit 1)

mmap_mod-mmap_i386_mmap.o: mmap/i386/mmap.c $(mmap/i386/mmap.c_DEPENDENCIES)
	$(TARGET_CC) -Immap/i386 -I$(srcdir)/mmap/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -MD -c -o $@ $<
-include mmap_mod-mmap_i386_mmap.d

clean-module-mmap_mod-mmap_i386_mmap-extra.1:
	rm -f cmd-mmap_mod-mmap_i386_mmap.lst fs-mmap_mod-mmap_i386_mmap.lst partmap-mmap_mod-mmap_i386_mmap.lst handler-mmap_mod-mmap_i386_mmap.lst parttool-mmap_mod-mmap_i386_mmap.lst

CLEAN_MODULE_TARGETS += clean-module-mmap_mod-mmap_i386_mmap-extra.1

COMMANDFILES += cmd-mmap_mod-mmap_i386_mmap.lst
FSFILES += fs-mmap_mod-mmap_i386_mmap.lst
PARTTOOLFILES += parttool-mmap_mod-mmap_i386_mmap.lst
PARTMAPFILES += partmap-mmap_mod-mmap_i386_mmap.lst
HANDLERFILES += handler-mmap_mod-mmap_i386_mmap.lst

cmd-mmap_mod-mmap_i386_mmap.lst: mmap/i386/mmap.c $(mmap/i386/mmap.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386 -I$(srcdir)/mmap/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh mmap > $@ || (rm -f $@; exit 1)

fs-mmap_mod-mmap_i386_mmap.lst: mmap/i386/mmap.c $(mmap/i386/mmap.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386 -I$(srcdir)/mmap/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh mmap > $@ || (rm -f $@; exit 1)

parttool-mmap_mod-mmap_i386_mmap.lst: mmap/i386/mmap.c $(mmap/i386/mmap.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386 -I$(srcdir)/mmap/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh mmap > $@ || (rm -f $@; exit 1)

partmap-mmap_mod-mmap_i386_mmap.lst: mmap/i386/mmap.c $(mmap/i386/mmap.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386 -I$(srcdir)/mmap/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh mmap > $@ || (rm -f $@; exit 1)

handler-mmap_mod-mmap_i386_mmap.lst: mmap/i386/mmap.c $(mmap/i386/mmap.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386 -I$(srcdir)/mmap/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh mmap > $@ || (rm -f $@; exit 1)

mmap_mod-mmap_i386_pc_mmap.o: mmap/i386/pc/mmap.c $(mmap/i386/pc/mmap.c_DEPENDENCIES)
	$(TARGET_CC) -Immap/i386/pc -I$(srcdir)/mmap/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -MD -c -o $@ $<
-include mmap_mod-mmap_i386_pc_mmap.d

clean-module-mmap_mod-mmap_i386_pc_mmap-extra.1:
	rm -f cmd-mmap_mod-mmap_i386_pc_mmap.lst fs-mmap_mod-mmap_i386_pc_mmap.lst partmap-mmap_mod-mmap_i386_pc_mmap.lst handler-mmap_mod-mmap_i386_pc_mmap.lst parttool-mmap_mod-mmap_i386_pc_mmap.lst

CLEAN_MODULE_TARGETS += clean-module-mmap_mod-mmap_i386_pc_mmap-extra.1

COMMANDFILES += cmd-mmap_mod-mmap_i386_pc_mmap.lst
FSFILES += fs-mmap_mod-mmap_i386_pc_mmap.lst
PARTTOOLFILES += parttool-mmap_mod-mmap_i386_pc_mmap.lst
PARTMAPFILES += partmap-mmap_mod-mmap_i386_pc_mmap.lst
HANDLERFILES += handler-mmap_mod-mmap_i386_pc_mmap.lst

cmd-mmap_mod-mmap_i386_pc_mmap.lst: mmap/i386/pc/mmap.c $(mmap/i386/pc/mmap.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386/pc -I$(srcdir)/mmap/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh mmap > $@ || (rm -f $@; exit 1)

fs-mmap_mod-mmap_i386_pc_mmap.lst: mmap/i386/pc/mmap.c $(mmap/i386/pc/mmap.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386/pc -I$(srcdir)/mmap/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh mmap > $@ || (rm -f $@; exit 1)

parttool-mmap_mod-mmap_i386_pc_mmap.lst: mmap/i386/pc/mmap.c $(mmap/i386/pc/mmap.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386/pc -I$(srcdir)/mmap/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh mmap > $@ || (rm -f $@; exit 1)

partmap-mmap_mod-mmap_i386_pc_mmap.lst: mmap/i386/pc/mmap.c $(mmap/i386/pc/mmap.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386/pc -I$(srcdir)/mmap/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh mmap > $@ || (rm -f $@; exit 1)

handler-mmap_mod-mmap_i386_pc_mmap.lst: mmap/i386/pc/mmap.c $(mmap/i386/pc/mmap.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386/pc -I$(srcdir)/mmap/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(mmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh mmap > $@ || (rm -f $@; exit 1)

mmap_mod-mmap_i386_pc_mmap_helper.o: mmap/i386/pc/mmap_helper.S $(mmap/i386/pc/mmap_helper.S_DEPENDENCIES)
	$(TARGET_CC) -Immap/i386/pc -I$(srcdir)/mmap/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(mmap_mod_ASFLAGS) -MD -c -o $@ $<
-include mmap_mod-mmap_i386_pc_mmap_helper.d

clean-module-mmap_mod-mmap_i386_pc_mmap_helper-extra.1:
	rm -f cmd-mmap_mod-mmap_i386_pc_mmap_helper.lst fs-mmap_mod-mmap_i386_pc_mmap_helper.lst partmap-mmap_mod-mmap_i386_pc_mmap_helper.lst handler-mmap_mod-mmap_i386_pc_mmap_helper.lst parttool-mmap_mod-mmap_i386_pc_mmap_helper.lst

CLEAN_MODULE_TARGETS += clean-module-mmap_mod-mmap_i386_pc_mmap_helper-extra.1

COMMANDFILES += cmd-mmap_mod-mmap_i386_pc_mmap_helper.lst
FSFILES += fs-mmap_mod-mmap_i386_pc_mmap_helper.lst
PARTTOOLFILES += parttool-mmap_mod-mmap_i386_pc_mmap_helper.lst
PARTMAPFILES += partmap-mmap_mod-mmap_i386_pc_mmap_helper.lst
HANDLERFILES += handler-mmap_mod-mmap_i386_pc_mmap_helper.lst

cmd-mmap_mod-mmap_i386_pc_mmap_helper.lst: mmap/i386/pc/mmap_helper.S $(mmap/i386/pc/mmap_helper.S_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386/pc -I$(srcdir)/mmap/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(mmap_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh mmap > $@ || (rm -f $@; exit 1)

fs-mmap_mod-mmap_i386_pc_mmap_helper.lst: mmap/i386/pc/mmap_helper.S $(mmap/i386/pc/mmap_helper.S_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386/pc -I$(srcdir)/mmap/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(mmap_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh mmap > $@ || (rm -f $@; exit 1)

parttool-mmap_mod-mmap_i386_pc_mmap_helper.lst: mmap/i386/pc/mmap_helper.S $(mmap/i386/pc/mmap_helper.S_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386/pc -I$(srcdir)/mmap/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(mmap_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh mmap > $@ || (rm -f $@; exit 1)

partmap-mmap_mod-mmap_i386_pc_mmap_helper.lst: mmap/i386/pc/mmap_helper.S $(mmap/i386/pc/mmap_helper.S_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386/pc -I$(srcdir)/mmap/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(mmap_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh mmap > $@ || (rm -f $@; exit 1)

handler-mmap_mod-mmap_i386_pc_mmap_helper.lst: mmap/i386/pc/mmap_helper.S $(mmap/i386/pc/mmap_helper.S_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Immap/i386/pc -I$(srcdir)/mmap/i386/pc $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(mmap_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh mmap > $@ || (rm -f $@; exit 1)

mmap_mod_CFLAGS = $(COMMON_CFLAGS)
mmap_mod_LDFLAGS = $(COMMON_LDFLAGS)
mmap_mod_ASFLAGS = $(COMMON_ASFLAGS)

# For biosdisk.mod.
biosdisk_mod_SOURCES = disk/i386/pc/biosdisk.c

clean-module-biosdisk.mod.1:
	rm -f biosdisk.mod mod-biosdisk.o mod-biosdisk.c pre-biosdisk.o biosdisk_mod-disk_i386_pc_biosdisk.o und-biosdisk.lst

CLEAN_MODULE_TARGETS += clean-module-biosdisk.mod.1

ifneq ($(biosdisk_mod_EXPORTS),no)
clean-module-biosdisk.mod-symbol.1:
	rm -f def-biosdisk.lst

CLEAN_MODULE_TARGETS += clean-module-biosdisk.mod-symbol.1
DEFSYMFILES += def-biosdisk.lst
endif
mostlyclean-module-biosdisk.mod.1:
	rm -f biosdisk_mod-disk_i386_pc_biosdisk.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-biosdisk.mod.1
UNDSYMFILES += und-biosdisk.lst

ifneq ($(TARGET_APPLE_CC),1)
biosdisk.mod: pre-biosdisk.o mod-biosdisk.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(biosdisk_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-biosdisk.o mod-biosdisk.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
biosdisk.mod: pre-biosdisk.o mod-biosdisk.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(biosdisk_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-biosdisk.o mod-biosdisk.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-biosdisk.o: $(biosdisk_mod_DEPENDENCIES) biosdisk_mod-disk_i386_pc_biosdisk.o
	-rm -f $@
	$(TARGET_CC) $(biosdisk_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ biosdisk_mod-disk_i386_pc_biosdisk.o

mod-biosdisk.o: mod-biosdisk.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(biosdisk_mod_CFLAGS) -c -o $@ $<

mod-biosdisk.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'biosdisk' $< > $@ || (rm -f $@; exit 1)

ifneq ($(biosdisk_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-biosdisk.lst: pre-biosdisk.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 biosdisk/' > $@
else
def-biosdisk.lst: pre-biosdisk.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 biosdisk/' > $@
endif
endif

und-biosdisk.lst: pre-biosdisk.o
	echo 'biosdisk' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

biosdisk_mod-disk_i386_pc_biosdisk.o: disk/i386/pc/biosdisk.c $(disk/i386/pc/biosdisk.c_DEPENDENCIES)
	$(TARGET_CC) -Idisk/i386/pc -I$(srcdir)/disk/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(biosdisk_mod_CFLAGS) -MD -c -o $@ $<
-include biosdisk_mod-disk_i386_pc_biosdisk.d

clean-module-biosdisk_mod-disk_i386_pc_biosdisk-extra.1:
	rm -f cmd-biosdisk_mod-disk_i386_pc_biosdisk.lst fs-biosdisk_mod-disk_i386_pc_biosdisk.lst partmap-biosdisk_mod-disk_i386_pc_biosdisk.lst handler-biosdisk_mod-disk_i386_pc_biosdisk.lst parttool-biosdisk_mod-disk_i386_pc_biosdisk.lst

CLEAN_MODULE_TARGETS += clean-module-biosdisk_mod-disk_i386_pc_biosdisk-extra.1

COMMANDFILES += cmd-biosdisk_mod-disk_i386_pc_biosdisk.lst
FSFILES += fs-biosdisk_mod-disk_i386_pc_biosdisk.lst
PARTTOOLFILES += parttool-biosdisk_mod-disk_i386_pc_biosdisk.lst
PARTMAPFILES += partmap-biosdisk_mod-disk_i386_pc_biosdisk.lst
HANDLERFILES += handler-biosdisk_mod-disk_i386_pc_biosdisk.lst

cmd-biosdisk_mod-disk_i386_pc_biosdisk.lst: disk/i386/pc/biosdisk.c $(disk/i386/pc/biosdisk.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Idisk/i386/pc -I$(srcdir)/disk/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(biosdisk_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh biosdisk > $@ || (rm -f $@; exit 1)

fs-biosdisk_mod-disk_i386_pc_biosdisk.lst: disk/i386/pc/biosdisk.c $(disk/i386/pc/biosdisk.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Idisk/i386/pc -I$(srcdir)/disk/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(biosdisk_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh biosdisk > $@ || (rm -f $@; exit 1)

parttool-biosdisk_mod-disk_i386_pc_biosdisk.lst: disk/i386/pc/biosdisk.c $(disk/i386/pc/biosdisk.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Idisk/i386/pc -I$(srcdir)/disk/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(biosdisk_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh biosdisk > $@ || (rm -f $@; exit 1)

partmap-biosdisk_mod-disk_i386_pc_biosdisk.lst: disk/i386/pc/biosdisk.c $(disk/i386/pc/biosdisk.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Idisk/i386/pc -I$(srcdir)/disk/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(biosdisk_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh biosdisk > $@ || (rm -f $@; exit 1)

handler-biosdisk_mod-disk_i386_pc_biosdisk.lst: disk/i386/pc/biosdisk.c $(disk/i386/pc/biosdisk.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Idisk/i386/pc -I$(srcdir)/disk/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(biosdisk_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh biosdisk > $@ || (rm -f $@; exit 1)

biosdisk_mod_CFLAGS = $(COMMON_CFLAGS)
biosdisk_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For chain.mod.
chain_mod_SOURCES = loader/i386/pc/chainloader.c

clean-module-chain.mod.1:
	rm -f chain.mod mod-chain.o mod-chain.c pre-chain.o chain_mod-loader_i386_pc_chainloader.o und-chain.lst

CLEAN_MODULE_TARGETS += clean-module-chain.mod.1

ifneq ($(chain_mod_EXPORTS),no)
clean-module-chain.mod-symbol.1:
	rm -f def-chain.lst

CLEAN_MODULE_TARGETS += clean-module-chain.mod-symbol.1
DEFSYMFILES += def-chain.lst
endif
mostlyclean-module-chain.mod.1:
	rm -f chain_mod-loader_i386_pc_chainloader.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-chain.mod.1
UNDSYMFILES += und-chain.lst

ifneq ($(TARGET_APPLE_CC),1)
chain.mod: pre-chain.o mod-chain.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(chain_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-chain.o mod-chain.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
chain.mod: pre-chain.o mod-chain.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(chain_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-chain.o mod-chain.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-chain.o: $(chain_mod_DEPENDENCIES) chain_mod-loader_i386_pc_chainloader.o
	-rm -f $@
	$(TARGET_CC) $(chain_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ chain_mod-loader_i386_pc_chainloader.o

mod-chain.o: mod-chain.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(chain_mod_CFLAGS) -c -o $@ $<

mod-chain.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'chain' $< > $@ || (rm -f $@; exit 1)

ifneq ($(chain_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-chain.lst: pre-chain.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 chain/' > $@
else
def-chain.lst: pre-chain.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 chain/' > $@
endif
endif

und-chain.lst: pre-chain.o
	echo 'chain' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

chain_mod-loader_i386_pc_chainloader.o: loader/i386/pc/chainloader.c $(loader/i386/pc/chainloader.c_DEPENDENCIES)
	$(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(chain_mod_CFLAGS) -MD -c -o $@ $<
-include chain_mod-loader_i386_pc_chainloader.d

clean-module-chain_mod-loader_i386_pc_chainloader-extra.1:
	rm -f cmd-chain_mod-loader_i386_pc_chainloader.lst fs-chain_mod-loader_i386_pc_chainloader.lst partmap-chain_mod-loader_i386_pc_chainloader.lst handler-chain_mod-loader_i386_pc_chainloader.lst parttool-chain_mod-loader_i386_pc_chainloader.lst

CLEAN_MODULE_TARGETS += clean-module-chain_mod-loader_i386_pc_chainloader-extra.1

COMMANDFILES += cmd-chain_mod-loader_i386_pc_chainloader.lst
FSFILES += fs-chain_mod-loader_i386_pc_chainloader.lst
PARTTOOLFILES += parttool-chain_mod-loader_i386_pc_chainloader.lst
PARTMAPFILES += partmap-chain_mod-loader_i386_pc_chainloader.lst
HANDLERFILES += handler-chain_mod-loader_i386_pc_chainloader.lst

cmd-chain_mod-loader_i386_pc_chainloader.lst: loader/i386/pc/chainloader.c $(loader/i386/pc/chainloader.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(chain_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh chain > $@ || (rm -f $@; exit 1)

fs-chain_mod-loader_i386_pc_chainloader.lst: loader/i386/pc/chainloader.c $(loader/i386/pc/chainloader.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(chain_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh chain > $@ || (rm -f $@; exit 1)

parttool-chain_mod-loader_i386_pc_chainloader.lst: loader/i386/pc/chainloader.c $(loader/i386/pc/chainloader.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(chain_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh chain > $@ || (rm -f $@; exit 1)

partmap-chain_mod-loader_i386_pc_chainloader.lst: loader/i386/pc/chainloader.c $(loader/i386/pc/chainloader.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(chain_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh chain > $@ || (rm -f $@; exit 1)

handler-chain_mod-loader_i386_pc_chainloader.lst: loader/i386/pc/chainloader.c $(loader/i386/pc/chainloader.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(chain_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh chain > $@ || (rm -f $@; exit 1)

chain_mod_CFLAGS = $(COMMON_CFLAGS)
chain_mod_LDFLAGS = $(COMMON_LDFLAGS)

pkglib_MODULES += linux16.mod
linux16_mod_SOURCES = loader/i386/pc/linux.c

clean-module-linux16.mod.1:
	rm -f linux16.mod mod-linux16.o mod-linux16.c pre-linux16.o linux16_mod-loader_i386_pc_linux.o und-linux16.lst

CLEAN_MODULE_TARGETS += clean-module-linux16.mod.1

ifneq ($(linux16_mod_EXPORTS),no)
clean-module-linux16.mod-symbol.1:
	rm -f def-linux16.lst

CLEAN_MODULE_TARGETS += clean-module-linux16.mod-symbol.1
DEFSYMFILES += def-linux16.lst
endif
mostlyclean-module-linux16.mod.1:
	rm -f linux16_mod-loader_i386_pc_linux.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-linux16.mod.1
UNDSYMFILES += und-linux16.lst

ifneq ($(TARGET_APPLE_CC),1)
linux16.mod: pre-linux16.o mod-linux16.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(linux16_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-linux16.o mod-linux16.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
linux16.mod: pre-linux16.o mod-linux16.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(linux16_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-linux16.o mod-linux16.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-linux16.o: $(linux16_mod_DEPENDENCIES) linux16_mod-loader_i386_pc_linux.o
	-rm -f $@
	$(TARGET_CC) $(linux16_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ linux16_mod-loader_i386_pc_linux.o

mod-linux16.o: mod-linux16.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(linux16_mod_CFLAGS) -c -o $@ $<

mod-linux16.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'linux16' $< > $@ || (rm -f $@; exit 1)

ifneq ($(linux16_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-linux16.lst: pre-linux16.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 linux16/' > $@
else
def-linux16.lst: pre-linux16.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 linux16/' > $@
endif
endif

und-linux16.lst: pre-linux16.o
	echo 'linux16' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

linux16_mod-loader_i386_pc_linux.o: loader/i386/pc/linux.c $(loader/i386/pc/linux.c_DEPENDENCIES)
	$(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(linux16_mod_CFLAGS) -MD -c -o $@ $<
-include linux16_mod-loader_i386_pc_linux.d

clean-module-linux16_mod-loader_i386_pc_linux-extra.1:
	rm -f cmd-linux16_mod-loader_i386_pc_linux.lst fs-linux16_mod-loader_i386_pc_linux.lst partmap-linux16_mod-loader_i386_pc_linux.lst handler-linux16_mod-loader_i386_pc_linux.lst parttool-linux16_mod-loader_i386_pc_linux.lst

CLEAN_MODULE_TARGETS += clean-module-linux16_mod-loader_i386_pc_linux-extra.1

COMMANDFILES += cmd-linux16_mod-loader_i386_pc_linux.lst
FSFILES += fs-linux16_mod-loader_i386_pc_linux.lst
PARTTOOLFILES += parttool-linux16_mod-loader_i386_pc_linux.lst
PARTMAPFILES += partmap-linux16_mod-loader_i386_pc_linux.lst
HANDLERFILES += handler-linux16_mod-loader_i386_pc_linux.lst

cmd-linux16_mod-loader_i386_pc_linux.lst: loader/i386/pc/linux.c $(loader/i386/pc/linux.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(linux16_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh linux16 > $@ || (rm -f $@; exit 1)

fs-linux16_mod-loader_i386_pc_linux.lst: loader/i386/pc/linux.c $(loader/i386/pc/linux.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(linux16_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh linux16 > $@ || (rm -f $@; exit 1)

parttool-linux16_mod-loader_i386_pc_linux.lst: loader/i386/pc/linux.c $(loader/i386/pc/linux.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(linux16_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh linux16 > $@ || (rm -f $@; exit 1)

partmap-linux16_mod-loader_i386_pc_linux.lst: loader/i386/pc/linux.c $(loader/i386/pc/linux.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(linux16_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh linux16 > $@ || (rm -f $@; exit 1)

handler-linux16_mod-loader_i386_pc_linux.lst: loader/i386/pc/linux.c $(loader/i386/pc/linux.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(linux16_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh linux16 > $@ || (rm -f $@; exit 1)

linux16_mod_CFLAGS = $(COMMON_CFLAGS)
linux16_mod_LDFLAGS = $(COMMON_LDFLAGS)

pkglib_MODULES += linux.mod
linux_mod_SOURCES = loader/i386/linux.c

clean-module-linux.mod.1:
	rm -f linux.mod mod-linux.o mod-linux.c pre-linux.o linux_mod-loader_i386_linux.o und-linux.lst

CLEAN_MODULE_TARGETS += clean-module-linux.mod.1

ifneq ($(linux_mod_EXPORTS),no)
clean-module-linux.mod-symbol.1:
	rm -f def-linux.lst

CLEAN_MODULE_TARGETS += clean-module-linux.mod-symbol.1
DEFSYMFILES += def-linux.lst
endif
mostlyclean-module-linux.mod.1:
	rm -f linux_mod-loader_i386_linux.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-linux.mod.1
UNDSYMFILES += und-linux.lst

ifneq ($(TARGET_APPLE_CC),1)
linux.mod: pre-linux.o mod-linux.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(linux_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-linux.o mod-linux.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
linux.mod: pre-linux.o mod-linux.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(linux_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-linux.o mod-linux.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-linux.o: $(linux_mod_DEPENDENCIES) linux_mod-loader_i386_linux.o
	-rm -f $@
	$(TARGET_CC) $(linux_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ linux_mod-loader_i386_linux.o

mod-linux.o: mod-linux.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(linux_mod_CFLAGS) -c -o $@ $<

mod-linux.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'linux' $< > $@ || (rm -f $@; exit 1)

ifneq ($(linux_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-linux.lst: pre-linux.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 linux/' > $@
else
def-linux.lst: pre-linux.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 linux/' > $@
endif
endif

und-linux.lst: pre-linux.o
	echo 'linux' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

linux_mod-loader_i386_linux.o: loader/i386/linux.c $(loader/i386/linux.c_DEPENDENCIES)
	$(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(linux_mod_CFLAGS) -MD -c -o $@ $<
-include linux_mod-loader_i386_linux.d

clean-module-linux_mod-loader_i386_linux-extra.1:
	rm -f cmd-linux_mod-loader_i386_linux.lst fs-linux_mod-loader_i386_linux.lst partmap-linux_mod-loader_i386_linux.lst handler-linux_mod-loader_i386_linux.lst parttool-linux_mod-loader_i386_linux.lst

CLEAN_MODULE_TARGETS += clean-module-linux_mod-loader_i386_linux-extra.1

COMMANDFILES += cmd-linux_mod-loader_i386_linux.lst
FSFILES += fs-linux_mod-loader_i386_linux.lst
PARTTOOLFILES += parttool-linux_mod-loader_i386_linux.lst
PARTMAPFILES += partmap-linux_mod-loader_i386_linux.lst
HANDLERFILES += handler-linux_mod-loader_i386_linux.lst

cmd-linux_mod-loader_i386_linux.lst: loader/i386/linux.c $(loader/i386/linux.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(linux_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh linux > $@ || (rm -f $@; exit 1)

fs-linux_mod-loader_i386_linux.lst: loader/i386/linux.c $(loader/i386/linux.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(linux_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh linux > $@ || (rm -f $@; exit 1)

parttool-linux_mod-loader_i386_linux.lst: loader/i386/linux.c $(loader/i386/linux.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(linux_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh linux > $@ || (rm -f $@; exit 1)

partmap-linux_mod-loader_i386_linux.lst: loader/i386/linux.c $(loader/i386/linux.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(linux_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh linux > $@ || (rm -f $@; exit 1)

handler-linux_mod-loader_i386_linux.lst: loader/i386/linux.c $(loader/i386/linux.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(linux_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh linux > $@ || (rm -f $@; exit 1)

linux_mod_CFLAGS = $(COMMON_CFLAGS)
linux_mod_LDFLAGS = $(COMMON_LDFLAGS)

pkglib_MODULES += xnu.mod
xnu_mod_SOURCES = loader/xnu_resume.c loader/i386/xnu.c loader/i386/pc/xnu.c\
	 loader/macho.c loader/xnu.c loader/i386/xnu_helper.S

clean-module-xnu.mod.1:
	rm -f xnu.mod mod-xnu.o mod-xnu.c pre-xnu.o xnu_mod-loader_xnu_resume.o xnu_mod-loader_i386_xnu.o xnu_mod-loader_i386_pc_xnu.o xnu_mod-loader_macho.o xnu_mod-loader_xnu.o xnu_mod-loader_i386_xnu_helper.o und-xnu.lst

CLEAN_MODULE_TARGETS += clean-module-xnu.mod.1

ifneq ($(xnu_mod_EXPORTS),no)
clean-module-xnu.mod-symbol.1:
	rm -f def-xnu.lst

CLEAN_MODULE_TARGETS += clean-module-xnu.mod-symbol.1
DEFSYMFILES += def-xnu.lst
endif
mostlyclean-module-xnu.mod.1:
	rm -f xnu_mod-loader_xnu_resume.d xnu_mod-loader_i386_xnu.d xnu_mod-loader_i386_pc_xnu.d xnu_mod-loader_macho.d xnu_mod-loader_xnu.d xnu_mod-loader_i386_xnu_helper.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-xnu.mod.1
UNDSYMFILES += und-xnu.lst

ifneq ($(TARGET_APPLE_CC),1)
xnu.mod: pre-xnu.o mod-xnu.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(xnu_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-xnu.o mod-xnu.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
xnu.mod: pre-xnu.o mod-xnu.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(xnu_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-xnu.o mod-xnu.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-xnu.o: $(xnu_mod_DEPENDENCIES) xnu_mod-loader_xnu_resume.o xnu_mod-loader_i386_xnu.o xnu_mod-loader_i386_pc_xnu.o xnu_mod-loader_macho.o xnu_mod-loader_xnu.o xnu_mod-loader_i386_xnu_helper.o
	-rm -f $@
	$(TARGET_CC) $(xnu_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ xnu_mod-loader_xnu_resume.o xnu_mod-loader_i386_xnu.o xnu_mod-loader_i386_pc_xnu.o xnu_mod-loader_macho.o xnu_mod-loader_xnu.o xnu_mod-loader_i386_xnu_helper.o

mod-xnu.o: mod-xnu.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -c -o $@ $<

mod-xnu.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'xnu' $< > $@ || (rm -f $@; exit 1)

ifneq ($(xnu_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-xnu.lst: pre-xnu.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 xnu/' > $@
else
def-xnu.lst: pre-xnu.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 xnu/' > $@
endif
endif

und-xnu.lst: pre-xnu.o
	echo 'xnu' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

xnu_mod-loader_xnu_resume.o: loader/xnu_resume.c $(loader/xnu_resume.c_DEPENDENCIES)
	$(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -MD -c -o $@ $<
-include xnu_mod-loader_xnu_resume.d

clean-module-xnu_mod-loader_xnu_resume-extra.1:
	rm -f cmd-xnu_mod-loader_xnu_resume.lst fs-xnu_mod-loader_xnu_resume.lst partmap-xnu_mod-loader_xnu_resume.lst handler-xnu_mod-loader_xnu_resume.lst parttool-xnu_mod-loader_xnu_resume.lst

CLEAN_MODULE_TARGETS += clean-module-xnu_mod-loader_xnu_resume-extra.1

COMMANDFILES += cmd-xnu_mod-loader_xnu_resume.lst
FSFILES += fs-xnu_mod-loader_xnu_resume.lst
PARTTOOLFILES += parttool-xnu_mod-loader_xnu_resume.lst
PARTMAPFILES += partmap-xnu_mod-loader_xnu_resume.lst
HANDLERFILES += handler-xnu_mod-loader_xnu_resume.lst

cmd-xnu_mod-loader_xnu_resume.lst: loader/xnu_resume.c $(loader/xnu_resume.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh xnu > $@ || (rm -f $@; exit 1)

fs-xnu_mod-loader_xnu_resume.lst: loader/xnu_resume.c $(loader/xnu_resume.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh xnu > $@ || (rm -f $@; exit 1)

parttool-xnu_mod-loader_xnu_resume.lst: loader/xnu_resume.c $(loader/xnu_resume.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh xnu > $@ || (rm -f $@; exit 1)

partmap-xnu_mod-loader_xnu_resume.lst: loader/xnu_resume.c $(loader/xnu_resume.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh xnu > $@ || (rm -f $@; exit 1)

handler-xnu_mod-loader_xnu_resume.lst: loader/xnu_resume.c $(loader/xnu_resume.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh xnu > $@ || (rm -f $@; exit 1)

xnu_mod-loader_i386_xnu.o: loader/i386/xnu.c $(loader/i386/xnu.c_DEPENDENCIES)
	$(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -MD -c -o $@ $<
-include xnu_mod-loader_i386_xnu.d

clean-module-xnu_mod-loader_i386_xnu-extra.1:
	rm -f cmd-xnu_mod-loader_i386_xnu.lst fs-xnu_mod-loader_i386_xnu.lst partmap-xnu_mod-loader_i386_xnu.lst handler-xnu_mod-loader_i386_xnu.lst parttool-xnu_mod-loader_i386_xnu.lst

CLEAN_MODULE_TARGETS += clean-module-xnu_mod-loader_i386_xnu-extra.1

COMMANDFILES += cmd-xnu_mod-loader_i386_xnu.lst
FSFILES += fs-xnu_mod-loader_i386_xnu.lst
PARTTOOLFILES += parttool-xnu_mod-loader_i386_xnu.lst
PARTMAPFILES += partmap-xnu_mod-loader_i386_xnu.lst
HANDLERFILES += handler-xnu_mod-loader_i386_xnu.lst

cmd-xnu_mod-loader_i386_xnu.lst: loader/i386/xnu.c $(loader/i386/xnu.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh xnu > $@ || (rm -f $@; exit 1)

fs-xnu_mod-loader_i386_xnu.lst: loader/i386/xnu.c $(loader/i386/xnu.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh xnu > $@ || (rm -f $@; exit 1)

parttool-xnu_mod-loader_i386_xnu.lst: loader/i386/xnu.c $(loader/i386/xnu.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh xnu > $@ || (rm -f $@; exit 1)

partmap-xnu_mod-loader_i386_xnu.lst: loader/i386/xnu.c $(loader/i386/xnu.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh xnu > $@ || (rm -f $@; exit 1)

handler-xnu_mod-loader_i386_xnu.lst: loader/i386/xnu.c $(loader/i386/xnu.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh xnu > $@ || (rm -f $@; exit 1)

xnu_mod-loader_i386_pc_xnu.o: loader/i386/pc/xnu.c $(loader/i386/pc/xnu.c_DEPENDENCIES)
	$(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -MD -c -o $@ $<
-include xnu_mod-loader_i386_pc_xnu.d

clean-module-xnu_mod-loader_i386_pc_xnu-extra.1:
	rm -f cmd-xnu_mod-loader_i386_pc_xnu.lst fs-xnu_mod-loader_i386_pc_xnu.lst partmap-xnu_mod-loader_i386_pc_xnu.lst handler-xnu_mod-loader_i386_pc_xnu.lst parttool-xnu_mod-loader_i386_pc_xnu.lst

CLEAN_MODULE_TARGETS += clean-module-xnu_mod-loader_i386_pc_xnu-extra.1

COMMANDFILES += cmd-xnu_mod-loader_i386_pc_xnu.lst
FSFILES += fs-xnu_mod-loader_i386_pc_xnu.lst
PARTTOOLFILES += parttool-xnu_mod-loader_i386_pc_xnu.lst
PARTMAPFILES += partmap-xnu_mod-loader_i386_pc_xnu.lst
HANDLERFILES += handler-xnu_mod-loader_i386_pc_xnu.lst

cmd-xnu_mod-loader_i386_pc_xnu.lst: loader/i386/pc/xnu.c $(loader/i386/pc/xnu.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh xnu > $@ || (rm -f $@; exit 1)

fs-xnu_mod-loader_i386_pc_xnu.lst: loader/i386/pc/xnu.c $(loader/i386/pc/xnu.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh xnu > $@ || (rm -f $@; exit 1)

parttool-xnu_mod-loader_i386_pc_xnu.lst: loader/i386/pc/xnu.c $(loader/i386/pc/xnu.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh xnu > $@ || (rm -f $@; exit 1)

partmap-xnu_mod-loader_i386_pc_xnu.lst: loader/i386/pc/xnu.c $(loader/i386/pc/xnu.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh xnu > $@ || (rm -f $@; exit 1)

handler-xnu_mod-loader_i386_pc_xnu.lst: loader/i386/pc/xnu.c $(loader/i386/pc/xnu.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh xnu > $@ || (rm -f $@; exit 1)

xnu_mod-loader_macho.o: loader/macho.c $(loader/macho.c_DEPENDENCIES)
	$(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -MD -c -o $@ $<
-include xnu_mod-loader_macho.d

clean-module-xnu_mod-loader_macho-extra.1:
	rm -f cmd-xnu_mod-loader_macho.lst fs-xnu_mod-loader_macho.lst partmap-xnu_mod-loader_macho.lst handler-xnu_mod-loader_macho.lst parttool-xnu_mod-loader_macho.lst

CLEAN_MODULE_TARGETS += clean-module-xnu_mod-loader_macho-extra.1

COMMANDFILES += cmd-xnu_mod-loader_macho.lst
FSFILES += fs-xnu_mod-loader_macho.lst
PARTTOOLFILES += parttool-xnu_mod-loader_macho.lst
PARTMAPFILES += partmap-xnu_mod-loader_macho.lst
HANDLERFILES += handler-xnu_mod-loader_macho.lst

cmd-xnu_mod-loader_macho.lst: loader/macho.c $(loader/macho.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh xnu > $@ || (rm -f $@; exit 1)

fs-xnu_mod-loader_macho.lst: loader/macho.c $(loader/macho.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh xnu > $@ || (rm -f $@; exit 1)

parttool-xnu_mod-loader_macho.lst: loader/macho.c $(loader/macho.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh xnu > $@ || (rm -f $@; exit 1)

partmap-xnu_mod-loader_macho.lst: loader/macho.c $(loader/macho.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh xnu > $@ || (rm -f $@; exit 1)

handler-xnu_mod-loader_macho.lst: loader/macho.c $(loader/macho.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh xnu > $@ || (rm -f $@; exit 1)

xnu_mod-loader_xnu.o: loader/xnu.c $(loader/xnu.c_DEPENDENCIES)
	$(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -MD -c -o $@ $<
-include xnu_mod-loader_xnu.d

clean-module-xnu_mod-loader_xnu-extra.1:
	rm -f cmd-xnu_mod-loader_xnu.lst fs-xnu_mod-loader_xnu.lst partmap-xnu_mod-loader_xnu.lst handler-xnu_mod-loader_xnu.lst parttool-xnu_mod-loader_xnu.lst

CLEAN_MODULE_TARGETS += clean-module-xnu_mod-loader_xnu-extra.1

COMMANDFILES += cmd-xnu_mod-loader_xnu.lst
FSFILES += fs-xnu_mod-loader_xnu.lst
PARTTOOLFILES += parttool-xnu_mod-loader_xnu.lst
PARTMAPFILES += partmap-xnu_mod-loader_xnu.lst
HANDLERFILES += handler-xnu_mod-loader_xnu.lst

cmd-xnu_mod-loader_xnu.lst: loader/xnu.c $(loader/xnu.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh xnu > $@ || (rm -f $@; exit 1)

fs-xnu_mod-loader_xnu.lst: loader/xnu.c $(loader/xnu.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh xnu > $@ || (rm -f $@; exit 1)

parttool-xnu_mod-loader_xnu.lst: loader/xnu.c $(loader/xnu.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh xnu > $@ || (rm -f $@; exit 1)

partmap-xnu_mod-loader_xnu.lst: loader/xnu.c $(loader/xnu.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh xnu > $@ || (rm -f $@; exit 1)

handler-xnu_mod-loader_xnu.lst: loader/xnu.c $(loader/xnu.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(xnu_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh xnu > $@ || (rm -f $@; exit 1)

xnu_mod-loader_i386_xnu_helper.o: loader/i386/xnu_helper.S $(loader/i386/xnu_helper.S_DEPENDENCIES)
	$(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(xnu_mod_ASFLAGS) -MD -c -o $@ $<
-include xnu_mod-loader_i386_xnu_helper.d

clean-module-xnu_mod-loader_i386_xnu_helper-extra.1:
	rm -f cmd-xnu_mod-loader_i386_xnu_helper.lst fs-xnu_mod-loader_i386_xnu_helper.lst partmap-xnu_mod-loader_i386_xnu_helper.lst handler-xnu_mod-loader_i386_xnu_helper.lst parttool-xnu_mod-loader_i386_xnu_helper.lst

CLEAN_MODULE_TARGETS += clean-module-xnu_mod-loader_i386_xnu_helper-extra.1

COMMANDFILES += cmd-xnu_mod-loader_i386_xnu_helper.lst
FSFILES += fs-xnu_mod-loader_i386_xnu_helper.lst
PARTTOOLFILES += parttool-xnu_mod-loader_i386_xnu_helper.lst
PARTMAPFILES += partmap-xnu_mod-loader_i386_xnu_helper.lst
HANDLERFILES += handler-xnu_mod-loader_i386_xnu_helper.lst

cmd-xnu_mod-loader_i386_xnu_helper.lst: loader/i386/xnu_helper.S $(loader/i386/xnu_helper.S_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(xnu_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh xnu > $@ || (rm -f $@; exit 1)

fs-xnu_mod-loader_i386_xnu_helper.lst: loader/i386/xnu_helper.S $(loader/i386/xnu_helper.S_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(xnu_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh xnu > $@ || (rm -f $@; exit 1)

parttool-xnu_mod-loader_i386_xnu_helper.lst: loader/i386/xnu_helper.S $(loader/i386/xnu_helper.S_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(xnu_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh xnu > $@ || (rm -f $@; exit 1)

partmap-xnu_mod-loader_i386_xnu_helper.lst: loader/i386/xnu_helper.S $(loader/i386/xnu_helper.S_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(xnu_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh xnu > $@ || (rm -f $@; exit 1)

handler-xnu_mod-loader_i386_xnu_helper.lst: loader/i386/xnu_helper.S $(loader/i386/xnu_helper.S_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(xnu_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh xnu > $@ || (rm -f $@; exit 1)

xnu_mod_CFLAGS = $(COMMON_CFLAGS)
xnu_mod_LDFLAGS = $(COMMON_LDFLAGS)
xnu_mod_ASFLAGS = $(COMMON_ASFLAGS)

# For reboot.mod.
reboot_mod_SOURCES = commands/reboot.c

clean-module-reboot.mod.1:
	rm -f reboot.mod mod-reboot.o mod-reboot.c pre-reboot.o reboot_mod-commands_reboot.o und-reboot.lst

CLEAN_MODULE_TARGETS += clean-module-reboot.mod.1

ifneq ($(reboot_mod_EXPORTS),no)
clean-module-reboot.mod-symbol.1:
	rm -f def-reboot.lst

CLEAN_MODULE_TARGETS += clean-module-reboot.mod-symbol.1
DEFSYMFILES += def-reboot.lst
endif
mostlyclean-module-reboot.mod.1:
	rm -f reboot_mod-commands_reboot.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-reboot.mod.1
UNDSYMFILES += und-reboot.lst

ifneq ($(TARGET_APPLE_CC),1)
reboot.mod: pre-reboot.o mod-reboot.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(reboot_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-reboot.o mod-reboot.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
reboot.mod: pre-reboot.o mod-reboot.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(reboot_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-reboot.o mod-reboot.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-reboot.o: $(reboot_mod_DEPENDENCIES) reboot_mod-commands_reboot.o
	-rm -f $@
	$(TARGET_CC) $(reboot_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ reboot_mod-commands_reboot.o

mod-reboot.o: mod-reboot.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(reboot_mod_CFLAGS) -c -o $@ $<

mod-reboot.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'reboot' $< > $@ || (rm -f $@; exit 1)

ifneq ($(reboot_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-reboot.lst: pre-reboot.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 reboot/' > $@
else
def-reboot.lst: pre-reboot.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 reboot/' > $@
endif
endif

und-reboot.lst: pre-reboot.o
	echo 'reboot' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

reboot_mod-commands_reboot.o: commands/reboot.c $(commands/reboot.c_DEPENDENCIES)
	$(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(reboot_mod_CFLAGS) -MD -c -o $@ $<
-include reboot_mod-commands_reboot.d

clean-module-reboot_mod-commands_reboot-extra.1:
	rm -f cmd-reboot_mod-commands_reboot.lst fs-reboot_mod-commands_reboot.lst partmap-reboot_mod-commands_reboot.lst handler-reboot_mod-commands_reboot.lst parttool-reboot_mod-commands_reboot.lst

CLEAN_MODULE_TARGETS += clean-module-reboot_mod-commands_reboot-extra.1

COMMANDFILES += cmd-reboot_mod-commands_reboot.lst
FSFILES += fs-reboot_mod-commands_reboot.lst
PARTTOOLFILES += parttool-reboot_mod-commands_reboot.lst
PARTMAPFILES += partmap-reboot_mod-commands_reboot.lst
HANDLERFILES += handler-reboot_mod-commands_reboot.lst

cmd-reboot_mod-commands_reboot.lst: commands/reboot.c $(commands/reboot.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(reboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh reboot > $@ || (rm -f $@; exit 1)

fs-reboot_mod-commands_reboot.lst: commands/reboot.c $(commands/reboot.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(reboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh reboot > $@ || (rm -f $@; exit 1)

parttool-reboot_mod-commands_reboot.lst: commands/reboot.c $(commands/reboot.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(reboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh reboot > $@ || (rm -f $@; exit 1)

partmap-reboot_mod-commands_reboot.lst: commands/reboot.c $(commands/reboot.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(reboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh reboot > $@ || (rm -f $@; exit 1)

handler-reboot_mod-commands_reboot.lst: commands/reboot.c $(commands/reboot.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(reboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh reboot > $@ || (rm -f $@; exit 1)

reboot_mod_CFLAGS = $(COMMON_CFLAGS)
reboot_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For halt.mod.
halt_mod_SOURCES = commands/i386/pc/halt.c

clean-module-halt.mod.1:
	rm -f halt.mod mod-halt.o mod-halt.c pre-halt.o halt_mod-commands_i386_pc_halt.o und-halt.lst

CLEAN_MODULE_TARGETS += clean-module-halt.mod.1

ifneq ($(halt_mod_EXPORTS),no)
clean-module-halt.mod-symbol.1:
	rm -f def-halt.lst

CLEAN_MODULE_TARGETS += clean-module-halt.mod-symbol.1
DEFSYMFILES += def-halt.lst
endif
mostlyclean-module-halt.mod.1:
	rm -f halt_mod-commands_i386_pc_halt.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-halt.mod.1
UNDSYMFILES += und-halt.lst

ifneq ($(TARGET_APPLE_CC),1)
halt.mod: pre-halt.o mod-halt.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(halt_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-halt.o mod-halt.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
halt.mod: pre-halt.o mod-halt.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(halt_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-halt.o mod-halt.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-halt.o: $(halt_mod_DEPENDENCIES) halt_mod-commands_i386_pc_halt.o
	-rm -f $@
	$(TARGET_CC) $(halt_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ halt_mod-commands_i386_pc_halt.o

mod-halt.o: mod-halt.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(halt_mod_CFLAGS) -c -o $@ $<

mod-halt.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'halt' $< > $@ || (rm -f $@; exit 1)

ifneq ($(halt_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-halt.lst: pre-halt.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 halt/' > $@
else
def-halt.lst: pre-halt.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 halt/' > $@
endif
endif

und-halt.lst: pre-halt.o
	echo 'halt' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

halt_mod-commands_i386_pc_halt.o: commands/i386/pc/halt.c $(commands/i386/pc/halt.c_DEPENDENCIES)
	$(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(halt_mod_CFLAGS) -MD -c -o $@ $<
-include halt_mod-commands_i386_pc_halt.d

clean-module-halt_mod-commands_i386_pc_halt-extra.1:
	rm -f cmd-halt_mod-commands_i386_pc_halt.lst fs-halt_mod-commands_i386_pc_halt.lst partmap-halt_mod-commands_i386_pc_halt.lst handler-halt_mod-commands_i386_pc_halt.lst parttool-halt_mod-commands_i386_pc_halt.lst

CLEAN_MODULE_TARGETS += clean-module-halt_mod-commands_i386_pc_halt-extra.1

COMMANDFILES += cmd-halt_mod-commands_i386_pc_halt.lst
FSFILES += fs-halt_mod-commands_i386_pc_halt.lst
PARTTOOLFILES += parttool-halt_mod-commands_i386_pc_halt.lst
PARTMAPFILES += partmap-halt_mod-commands_i386_pc_halt.lst
HANDLERFILES += handler-halt_mod-commands_i386_pc_halt.lst

cmd-halt_mod-commands_i386_pc_halt.lst: commands/i386/pc/halt.c $(commands/i386/pc/halt.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(halt_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh halt > $@ || (rm -f $@; exit 1)

fs-halt_mod-commands_i386_pc_halt.lst: commands/i386/pc/halt.c $(commands/i386/pc/halt.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(halt_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh halt > $@ || (rm -f $@; exit 1)

parttool-halt_mod-commands_i386_pc_halt.lst: commands/i386/pc/halt.c $(commands/i386/pc/halt.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(halt_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh halt > $@ || (rm -f $@; exit 1)

partmap-halt_mod-commands_i386_pc_halt.lst: commands/i386/pc/halt.c $(commands/i386/pc/halt.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(halt_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh halt > $@ || (rm -f $@; exit 1)

handler-halt_mod-commands_i386_pc_halt.lst: commands/i386/pc/halt.c $(commands/i386/pc/halt.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(halt_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh halt > $@ || (rm -f $@; exit 1)

halt_mod_CFLAGS = $(COMMON_CFLAGS)
halt_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For serial.mod.
serial_mod_SOURCES = term/i386/pc/serial.c

clean-module-serial.mod.1:
	rm -f serial.mod mod-serial.o mod-serial.c pre-serial.o serial_mod-term_i386_pc_serial.o und-serial.lst

CLEAN_MODULE_TARGETS += clean-module-serial.mod.1

ifneq ($(serial_mod_EXPORTS),no)
clean-module-serial.mod-symbol.1:
	rm -f def-serial.lst

CLEAN_MODULE_TARGETS += clean-module-serial.mod-symbol.1
DEFSYMFILES += def-serial.lst
endif
mostlyclean-module-serial.mod.1:
	rm -f serial_mod-term_i386_pc_serial.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-serial.mod.1
UNDSYMFILES += und-serial.lst

ifneq ($(TARGET_APPLE_CC),1)
serial.mod: pre-serial.o mod-serial.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(serial_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-serial.o mod-serial.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
serial.mod: pre-serial.o mod-serial.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(serial_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-serial.o mod-serial.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-serial.o: $(serial_mod_DEPENDENCIES) serial_mod-term_i386_pc_serial.o
	-rm -f $@
	$(TARGET_CC) $(serial_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ serial_mod-term_i386_pc_serial.o

mod-serial.o: mod-serial.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(serial_mod_CFLAGS) -c -o $@ $<

mod-serial.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'serial' $< > $@ || (rm -f $@; exit 1)

ifneq ($(serial_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-serial.lst: pre-serial.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 serial/' > $@
else
def-serial.lst: pre-serial.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 serial/' > $@
endif
endif

und-serial.lst: pre-serial.o
	echo 'serial' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

serial_mod-term_i386_pc_serial.o: term/i386/pc/serial.c $(term/i386/pc/serial.c_DEPENDENCIES)
	$(TARGET_CC) -Iterm/i386/pc -I$(srcdir)/term/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(serial_mod_CFLAGS) -MD -c -o $@ $<
-include serial_mod-term_i386_pc_serial.d

clean-module-serial_mod-term_i386_pc_serial-extra.1:
	rm -f cmd-serial_mod-term_i386_pc_serial.lst fs-serial_mod-term_i386_pc_serial.lst partmap-serial_mod-term_i386_pc_serial.lst handler-serial_mod-term_i386_pc_serial.lst parttool-serial_mod-term_i386_pc_serial.lst

CLEAN_MODULE_TARGETS += clean-module-serial_mod-term_i386_pc_serial-extra.1

COMMANDFILES += cmd-serial_mod-term_i386_pc_serial.lst
FSFILES += fs-serial_mod-term_i386_pc_serial.lst
PARTTOOLFILES += parttool-serial_mod-term_i386_pc_serial.lst
PARTMAPFILES += partmap-serial_mod-term_i386_pc_serial.lst
HANDLERFILES += handler-serial_mod-term_i386_pc_serial.lst

cmd-serial_mod-term_i386_pc_serial.lst: term/i386/pc/serial.c $(term/i386/pc/serial.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iterm/i386/pc -I$(srcdir)/term/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(serial_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh serial > $@ || (rm -f $@; exit 1)

fs-serial_mod-term_i386_pc_serial.lst: term/i386/pc/serial.c $(term/i386/pc/serial.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iterm/i386/pc -I$(srcdir)/term/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(serial_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh serial > $@ || (rm -f $@; exit 1)

parttool-serial_mod-term_i386_pc_serial.lst: term/i386/pc/serial.c $(term/i386/pc/serial.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iterm/i386/pc -I$(srcdir)/term/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(serial_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh serial > $@ || (rm -f $@; exit 1)

partmap-serial_mod-term_i386_pc_serial.lst: term/i386/pc/serial.c $(term/i386/pc/serial.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iterm/i386/pc -I$(srcdir)/term/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(serial_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh serial > $@ || (rm -f $@; exit 1)

handler-serial_mod-term_i386_pc_serial.lst: term/i386/pc/serial.c $(term/i386/pc/serial.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iterm/i386/pc -I$(srcdir)/term/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(serial_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh serial > $@ || (rm -f $@; exit 1)

serial_mod_CFLAGS = $(COMMON_CFLAGS)
serial_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For multiboot.mod.
multiboot_mod_SOURCES = loader/i386/multiboot.c \
			loader/i386/multiboot_helper.S \
                        loader/i386/pc/multiboot2.c \
                        loader/multiboot2.c \
                        loader/multiboot_loader.c

clean-module-multiboot.mod.1:
	rm -f multiboot.mod mod-multiboot.o mod-multiboot.c pre-multiboot.o multiboot_mod-loader_i386_multiboot.o multiboot_mod-loader_i386_multiboot_helper.o multiboot_mod-loader_i386_pc_multiboot2.o multiboot_mod-loader_multiboot2.o multiboot_mod-loader_multiboot_loader.o und-multiboot.lst

CLEAN_MODULE_TARGETS += clean-module-multiboot.mod.1

ifneq ($(multiboot_mod_EXPORTS),no)
clean-module-multiboot.mod-symbol.1:
	rm -f def-multiboot.lst

CLEAN_MODULE_TARGETS += clean-module-multiboot.mod-symbol.1
DEFSYMFILES += def-multiboot.lst
endif
mostlyclean-module-multiboot.mod.1:
	rm -f multiboot_mod-loader_i386_multiboot.d multiboot_mod-loader_i386_multiboot_helper.d multiboot_mod-loader_i386_pc_multiboot2.d multiboot_mod-loader_multiboot2.d multiboot_mod-loader_multiboot_loader.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-multiboot.mod.1
UNDSYMFILES += und-multiboot.lst

ifneq ($(TARGET_APPLE_CC),1)
multiboot.mod: pre-multiboot.o mod-multiboot.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(multiboot_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-multiboot.o mod-multiboot.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
multiboot.mod: pre-multiboot.o mod-multiboot.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(multiboot_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-multiboot.o mod-multiboot.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-multiboot.o: $(multiboot_mod_DEPENDENCIES) multiboot_mod-loader_i386_multiboot.o multiboot_mod-loader_i386_multiboot_helper.o multiboot_mod-loader_i386_pc_multiboot2.o multiboot_mod-loader_multiboot2.o multiboot_mod-loader_multiboot_loader.o
	-rm -f $@
	$(TARGET_CC) $(multiboot_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ multiboot_mod-loader_i386_multiboot.o multiboot_mod-loader_i386_multiboot_helper.o multiboot_mod-loader_i386_pc_multiboot2.o multiboot_mod-loader_multiboot2.o multiboot_mod-loader_multiboot_loader.o

mod-multiboot.o: mod-multiboot.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -c -o $@ $<

mod-multiboot.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'multiboot' $< > $@ || (rm -f $@; exit 1)

ifneq ($(multiboot_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-multiboot.lst: pre-multiboot.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 multiboot/' > $@
else
def-multiboot.lst: pre-multiboot.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 multiboot/' > $@
endif
endif

und-multiboot.lst: pre-multiboot.o
	echo 'multiboot' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

multiboot_mod-loader_i386_multiboot.o: loader/i386/multiboot.c $(loader/i386/multiboot.c_DEPENDENCIES)
	$(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -MD -c -o $@ $<
-include multiboot_mod-loader_i386_multiboot.d

clean-module-multiboot_mod-loader_i386_multiboot-extra.1:
	rm -f cmd-multiboot_mod-loader_i386_multiboot.lst fs-multiboot_mod-loader_i386_multiboot.lst partmap-multiboot_mod-loader_i386_multiboot.lst handler-multiboot_mod-loader_i386_multiboot.lst parttool-multiboot_mod-loader_i386_multiboot.lst

CLEAN_MODULE_TARGETS += clean-module-multiboot_mod-loader_i386_multiboot-extra.1

COMMANDFILES += cmd-multiboot_mod-loader_i386_multiboot.lst
FSFILES += fs-multiboot_mod-loader_i386_multiboot.lst
PARTTOOLFILES += parttool-multiboot_mod-loader_i386_multiboot.lst
PARTMAPFILES += partmap-multiboot_mod-loader_i386_multiboot.lst
HANDLERFILES += handler-multiboot_mod-loader_i386_multiboot.lst

cmd-multiboot_mod-loader_i386_multiboot.lst: loader/i386/multiboot.c $(loader/i386/multiboot.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh multiboot > $@ || (rm -f $@; exit 1)

fs-multiboot_mod-loader_i386_multiboot.lst: loader/i386/multiboot.c $(loader/i386/multiboot.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh multiboot > $@ || (rm -f $@; exit 1)

parttool-multiboot_mod-loader_i386_multiboot.lst: loader/i386/multiboot.c $(loader/i386/multiboot.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh multiboot > $@ || (rm -f $@; exit 1)

partmap-multiboot_mod-loader_i386_multiboot.lst: loader/i386/multiboot.c $(loader/i386/multiboot.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh multiboot > $@ || (rm -f $@; exit 1)

handler-multiboot_mod-loader_i386_multiboot.lst: loader/i386/multiboot.c $(loader/i386/multiboot.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh multiboot > $@ || (rm -f $@; exit 1)

multiboot_mod-loader_i386_multiboot_helper.o: loader/i386/multiboot_helper.S $(loader/i386/multiboot_helper.S_DEPENDENCIES)
	$(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(multiboot_mod_ASFLAGS) -MD -c -o $@ $<
-include multiboot_mod-loader_i386_multiboot_helper.d

clean-module-multiboot_mod-loader_i386_multiboot_helper-extra.1:
	rm -f cmd-multiboot_mod-loader_i386_multiboot_helper.lst fs-multiboot_mod-loader_i386_multiboot_helper.lst partmap-multiboot_mod-loader_i386_multiboot_helper.lst handler-multiboot_mod-loader_i386_multiboot_helper.lst parttool-multiboot_mod-loader_i386_multiboot_helper.lst

CLEAN_MODULE_TARGETS += clean-module-multiboot_mod-loader_i386_multiboot_helper-extra.1

COMMANDFILES += cmd-multiboot_mod-loader_i386_multiboot_helper.lst
FSFILES += fs-multiboot_mod-loader_i386_multiboot_helper.lst
PARTTOOLFILES += parttool-multiboot_mod-loader_i386_multiboot_helper.lst
PARTMAPFILES += partmap-multiboot_mod-loader_i386_multiboot_helper.lst
HANDLERFILES += handler-multiboot_mod-loader_i386_multiboot_helper.lst

cmd-multiboot_mod-loader_i386_multiboot_helper.lst: loader/i386/multiboot_helper.S $(loader/i386/multiboot_helper.S_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(multiboot_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh multiboot > $@ || (rm -f $@; exit 1)

fs-multiboot_mod-loader_i386_multiboot_helper.lst: loader/i386/multiboot_helper.S $(loader/i386/multiboot_helper.S_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(multiboot_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh multiboot > $@ || (rm -f $@; exit 1)

parttool-multiboot_mod-loader_i386_multiboot_helper.lst: loader/i386/multiboot_helper.S $(loader/i386/multiboot_helper.S_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(multiboot_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh multiboot > $@ || (rm -f $@; exit 1)

partmap-multiboot_mod-loader_i386_multiboot_helper.lst: loader/i386/multiboot_helper.S $(loader/i386/multiboot_helper.S_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(multiboot_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh multiboot > $@ || (rm -f $@; exit 1)

handler-multiboot_mod-loader_i386_multiboot_helper.lst: loader/i386/multiboot_helper.S $(loader/i386/multiboot_helper.S_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(multiboot_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh multiboot > $@ || (rm -f $@; exit 1)

multiboot_mod-loader_i386_pc_multiboot2.o: loader/i386/pc/multiboot2.c $(loader/i386/pc/multiboot2.c_DEPENDENCIES)
	$(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -MD -c -o $@ $<
-include multiboot_mod-loader_i386_pc_multiboot2.d

clean-module-multiboot_mod-loader_i386_pc_multiboot2-extra.1:
	rm -f cmd-multiboot_mod-loader_i386_pc_multiboot2.lst fs-multiboot_mod-loader_i386_pc_multiboot2.lst partmap-multiboot_mod-loader_i386_pc_multiboot2.lst handler-multiboot_mod-loader_i386_pc_multiboot2.lst parttool-multiboot_mod-loader_i386_pc_multiboot2.lst

CLEAN_MODULE_TARGETS += clean-module-multiboot_mod-loader_i386_pc_multiboot2-extra.1

COMMANDFILES += cmd-multiboot_mod-loader_i386_pc_multiboot2.lst
FSFILES += fs-multiboot_mod-loader_i386_pc_multiboot2.lst
PARTTOOLFILES += parttool-multiboot_mod-loader_i386_pc_multiboot2.lst
PARTMAPFILES += partmap-multiboot_mod-loader_i386_pc_multiboot2.lst
HANDLERFILES += handler-multiboot_mod-loader_i386_pc_multiboot2.lst

cmd-multiboot_mod-loader_i386_pc_multiboot2.lst: loader/i386/pc/multiboot2.c $(loader/i386/pc/multiboot2.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh multiboot > $@ || (rm -f $@; exit 1)

fs-multiboot_mod-loader_i386_pc_multiboot2.lst: loader/i386/pc/multiboot2.c $(loader/i386/pc/multiboot2.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh multiboot > $@ || (rm -f $@; exit 1)

parttool-multiboot_mod-loader_i386_pc_multiboot2.lst: loader/i386/pc/multiboot2.c $(loader/i386/pc/multiboot2.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh multiboot > $@ || (rm -f $@; exit 1)

partmap-multiboot_mod-loader_i386_pc_multiboot2.lst: loader/i386/pc/multiboot2.c $(loader/i386/pc/multiboot2.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh multiboot > $@ || (rm -f $@; exit 1)

handler-multiboot_mod-loader_i386_pc_multiboot2.lst: loader/i386/pc/multiboot2.c $(loader/i386/pc/multiboot2.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386/pc -I$(srcdir)/loader/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh multiboot > $@ || (rm -f $@; exit 1)

multiboot_mod-loader_multiboot2.o: loader/multiboot2.c $(loader/multiboot2.c_DEPENDENCIES)
	$(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -MD -c -o $@ $<
-include multiboot_mod-loader_multiboot2.d

clean-module-multiboot_mod-loader_multiboot2-extra.1:
	rm -f cmd-multiboot_mod-loader_multiboot2.lst fs-multiboot_mod-loader_multiboot2.lst partmap-multiboot_mod-loader_multiboot2.lst handler-multiboot_mod-loader_multiboot2.lst parttool-multiboot_mod-loader_multiboot2.lst

CLEAN_MODULE_TARGETS += clean-module-multiboot_mod-loader_multiboot2-extra.1

COMMANDFILES += cmd-multiboot_mod-loader_multiboot2.lst
FSFILES += fs-multiboot_mod-loader_multiboot2.lst
PARTTOOLFILES += parttool-multiboot_mod-loader_multiboot2.lst
PARTMAPFILES += partmap-multiboot_mod-loader_multiboot2.lst
HANDLERFILES += handler-multiboot_mod-loader_multiboot2.lst

cmd-multiboot_mod-loader_multiboot2.lst: loader/multiboot2.c $(loader/multiboot2.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh multiboot > $@ || (rm -f $@; exit 1)

fs-multiboot_mod-loader_multiboot2.lst: loader/multiboot2.c $(loader/multiboot2.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh multiboot > $@ || (rm -f $@; exit 1)

parttool-multiboot_mod-loader_multiboot2.lst: loader/multiboot2.c $(loader/multiboot2.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh multiboot > $@ || (rm -f $@; exit 1)

partmap-multiboot_mod-loader_multiboot2.lst: loader/multiboot2.c $(loader/multiboot2.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh multiboot > $@ || (rm -f $@; exit 1)

handler-multiboot_mod-loader_multiboot2.lst: loader/multiboot2.c $(loader/multiboot2.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh multiboot > $@ || (rm -f $@; exit 1)

multiboot_mod-loader_multiboot_loader.o: loader/multiboot_loader.c $(loader/multiboot_loader.c_DEPENDENCIES)
	$(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -MD -c -o $@ $<
-include multiboot_mod-loader_multiboot_loader.d

clean-module-multiboot_mod-loader_multiboot_loader-extra.1:
	rm -f cmd-multiboot_mod-loader_multiboot_loader.lst fs-multiboot_mod-loader_multiboot_loader.lst partmap-multiboot_mod-loader_multiboot_loader.lst handler-multiboot_mod-loader_multiboot_loader.lst parttool-multiboot_mod-loader_multiboot_loader.lst

CLEAN_MODULE_TARGETS += clean-module-multiboot_mod-loader_multiboot_loader-extra.1

COMMANDFILES += cmd-multiboot_mod-loader_multiboot_loader.lst
FSFILES += fs-multiboot_mod-loader_multiboot_loader.lst
PARTTOOLFILES += parttool-multiboot_mod-loader_multiboot_loader.lst
PARTMAPFILES += partmap-multiboot_mod-loader_multiboot_loader.lst
HANDLERFILES += handler-multiboot_mod-loader_multiboot_loader.lst

cmd-multiboot_mod-loader_multiboot_loader.lst: loader/multiboot_loader.c $(loader/multiboot_loader.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh multiboot > $@ || (rm -f $@; exit 1)

fs-multiboot_mod-loader_multiboot_loader.lst: loader/multiboot_loader.c $(loader/multiboot_loader.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh multiboot > $@ || (rm -f $@; exit 1)

parttool-multiboot_mod-loader_multiboot_loader.lst: loader/multiboot_loader.c $(loader/multiboot_loader.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh multiboot > $@ || (rm -f $@; exit 1)

partmap-multiboot_mod-loader_multiboot_loader.lst: loader/multiboot_loader.c $(loader/multiboot_loader.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh multiboot > $@ || (rm -f $@; exit 1)

handler-multiboot_mod-loader_multiboot_loader.lst: loader/multiboot_loader.c $(loader/multiboot_loader.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(multiboot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh multiboot > $@ || (rm -f $@; exit 1)

multiboot_mod_CFLAGS = $(COMMON_CFLAGS)
multiboot_mod_LDFLAGS = $(COMMON_LDFLAGS)
multiboot_mod_ASFLAGS = $(COMMON_ASFLAGS)

# For vbe.mod.
vbe_mod_SOURCES = video/i386/pc/vbe.c

clean-module-vbe.mod.1:
	rm -f vbe.mod mod-vbe.o mod-vbe.c pre-vbe.o vbe_mod-video_i386_pc_vbe.o und-vbe.lst

CLEAN_MODULE_TARGETS += clean-module-vbe.mod.1

ifneq ($(vbe_mod_EXPORTS),no)
clean-module-vbe.mod-symbol.1:
	rm -f def-vbe.lst

CLEAN_MODULE_TARGETS += clean-module-vbe.mod-symbol.1
DEFSYMFILES += def-vbe.lst
endif
mostlyclean-module-vbe.mod.1:
	rm -f vbe_mod-video_i386_pc_vbe.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-vbe.mod.1
UNDSYMFILES += und-vbe.lst

ifneq ($(TARGET_APPLE_CC),1)
vbe.mod: pre-vbe.o mod-vbe.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(vbe_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-vbe.o mod-vbe.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
vbe.mod: pre-vbe.o mod-vbe.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(vbe_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-vbe.o mod-vbe.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-vbe.o: $(vbe_mod_DEPENDENCIES) vbe_mod-video_i386_pc_vbe.o
	-rm -f $@
	$(TARGET_CC) $(vbe_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ vbe_mod-video_i386_pc_vbe.o

mod-vbe.o: mod-vbe.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(vbe_mod_CFLAGS) -c -o $@ $<

mod-vbe.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'vbe' $< > $@ || (rm -f $@; exit 1)

ifneq ($(vbe_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-vbe.lst: pre-vbe.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 vbe/' > $@
else
def-vbe.lst: pre-vbe.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 vbe/' > $@
endif
endif

und-vbe.lst: pre-vbe.o
	echo 'vbe' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

vbe_mod-video_i386_pc_vbe.o: video/i386/pc/vbe.c $(video/i386/pc/vbe.c_DEPENDENCIES)
	$(TARGET_CC) -Ivideo/i386/pc -I$(srcdir)/video/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbe_mod_CFLAGS) -MD -c -o $@ $<
-include vbe_mod-video_i386_pc_vbe.d

clean-module-vbe_mod-video_i386_pc_vbe-extra.1:
	rm -f cmd-vbe_mod-video_i386_pc_vbe.lst fs-vbe_mod-video_i386_pc_vbe.lst partmap-vbe_mod-video_i386_pc_vbe.lst handler-vbe_mod-video_i386_pc_vbe.lst parttool-vbe_mod-video_i386_pc_vbe.lst

CLEAN_MODULE_TARGETS += clean-module-vbe_mod-video_i386_pc_vbe-extra.1

COMMANDFILES += cmd-vbe_mod-video_i386_pc_vbe.lst
FSFILES += fs-vbe_mod-video_i386_pc_vbe.lst
PARTTOOLFILES += parttool-vbe_mod-video_i386_pc_vbe.lst
PARTMAPFILES += partmap-vbe_mod-video_i386_pc_vbe.lst
HANDLERFILES += handler-vbe_mod-video_i386_pc_vbe.lst

cmd-vbe_mod-video_i386_pc_vbe.lst: video/i386/pc/vbe.c $(video/i386/pc/vbe.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Ivideo/i386/pc -I$(srcdir)/video/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbe_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh vbe > $@ || (rm -f $@; exit 1)

fs-vbe_mod-video_i386_pc_vbe.lst: video/i386/pc/vbe.c $(video/i386/pc/vbe.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Ivideo/i386/pc -I$(srcdir)/video/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbe_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh vbe > $@ || (rm -f $@; exit 1)

parttool-vbe_mod-video_i386_pc_vbe.lst: video/i386/pc/vbe.c $(video/i386/pc/vbe.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Ivideo/i386/pc -I$(srcdir)/video/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbe_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh vbe > $@ || (rm -f $@; exit 1)

partmap-vbe_mod-video_i386_pc_vbe.lst: video/i386/pc/vbe.c $(video/i386/pc/vbe.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Ivideo/i386/pc -I$(srcdir)/video/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbe_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh vbe > $@ || (rm -f $@; exit 1)

handler-vbe_mod-video_i386_pc_vbe.lst: video/i386/pc/vbe.c $(video/i386/pc/vbe.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Ivideo/i386/pc -I$(srcdir)/video/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbe_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh vbe > $@ || (rm -f $@; exit 1)

vbe_mod_CFLAGS = $(COMMON_CFLAGS)
vbe_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For vbeinfo.mod.
vbeinfo_mod_SOURCES = commands/i386/pc/vbeinfo.c

clean-module-vbeinfo.mod.1:
	rm -f vbeinfo.mod mod-vbeinfo.o mod-vbeinfo.c pre-vbeinfo.o vbeinfo_mod-commands_i386_pc_vbeinfo.o und-vbeinfo.lst

CLEAN_MODULE_TARGETS += clean-module-vbeinfo.mod.1

ifneq ($(vbeinfo_mod_EXPORTS),no)
clean-module-vbeinfo.mod-symbol.1:
	rm -f def-vbeinfo.lst

CLEAN_MODULE_TARGETS += clean-module-vbeinfo.mod-symbol.1
DEFSYMFILES += def-vbeinfo.lst
endif
mostlyclean-module-vbeinfo.mod.1:
	rm -f vbeinfo_mod-commands_i386_pc_vbeinfo.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-vbeinfo.mod.1
UNDSYMFILES += und-vbeinfo.lst

ifneq ($(TARGET_APPLE_CC),1)
vbeinfo.mod: pre-vbeinfo.o mod-vbeinfo.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(vbeinfo_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-vbeinfo.o mod-vbeinfo.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
vbeinfo.mod: pre-vbeinfo.o mod-vbeinfo.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(vbeinfo_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-vbeinfo.o mod-vbeinfo.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-vbeinfo.o: $(vbeinfo_mod_DEPENDENCIES) vbeinfo_mod-commands_i386_pc_vbeinfo.o
	-rm -f $@
	$(TARGET_CC) $(vbeinfo_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ vbeinfo_mod-commands_i386_pc_vbeinfo.o

mod-vbeinfo.o: mod-vbeinfo.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(vbeinfo_mod_CFLAGS) -c -o $@ $<

mod-vbeinfo.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'vbeinfo' $< > $@ || (rm -f $@; exit 1)

ifneq ($(vbeinfo_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-vbeinfo.lst: pre-vbeinfo.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 vbeinfo/' > $@
else
def-vbeinfo.lst: pre-vbeinfo.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 vbeinfo/' > $@
endif
endif

und-vbeinfo.lst: pre-vbeinfo.o
	echo 'vbeinfo' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

vbeinfo_mod-commands_i386_pc_vbeinfo.o: commands/i386/pc/vbeinfo.c $(commands/i386/pc/vbeinfo.c_DEPENDENCIES)
	$(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbeinfo_mod_CFLAGS) -MD -c -o $@ $<
-include vbeinfo_mod-commands_i386_pc_vbeinfo.d

clean-module-vbeinfo_mod-commands_i386_pc_vbeinfo-extra.1:
	rm -f cmd-vbeinfo_mod-commands_i386_pc_vbeinfo.lst fs-vbeinfo_mod-commands_i386_pc_vbeinfo.lst partmap-vbeinfo_mod-commands_i386_pc_vbeinfo.lst handler-vbeinfo_mod-commands_i386_pc_vbeinfo.lst parttool-vbeinfo_mod-commands_i386_pc_vbeinfo.lst

CLEAN_MODULE_TARGETS += clean-module-vbeinfo_mod-commands_i386_pc_vbeinfo-extra.1

COMMANDFILES += cmd-vbeinfo_mod-commands_i386_pc_vbeinfo.lst
FSFILES += fs-vbeinfo_mod-commands_i386_pc_vbeinfo.lst
PARTTOOLFILES += parttool-vbeinfo_mod-commands_i386_pc_vbeinfo.lst
PARTMAPFILES += partmap-vbeinfo_mod-commands_i386_pc_vbeinfo.lst
HANDLERFILES += handler-vbeinfo_mod-commands_i386_pc_vbeinfo.lst

cmd-vbeinfo_mod-commands_i386_pc_vbeinfo.lst: commands/i386/pc/vbeinfo.c $(commands/i386/pc/vbeinfo.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbeinfo_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh vbeinfo > $@ || (rm -f $@; exit 1)

fs-vbeinfo_mod-commands_i386_pc_vbeinfo.lst: commands/i386/pc/vbeinfo.c $(commands/i386/pc/vbeinfo.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbeinfo_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh vbeinfo > $@ || (rm -f $@; exit 1)

parttool-vbeinfo_mod-commands_i386_pc_vbeinfo.lst: commands/i386/pc/vbeinfo.c $(commands/i386/pc/vbeinfo.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbeinfo_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh vbeinfo > $@ || (rm -f $@; exit 1)

partmap-vbeinfo_mod-commands_i386_pc_vbeinfo.lst: commands/i386/pc/vbeinfo.c $(commands/i386/pc/vbeinfo.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbeinfo_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh vbeinfo > $@ || (rm -f $@; exit 1)

handler-vbeinfo_mod-commands_i386_pc_vbeinfo.lst: commands/i386/pc/vbeinfo.c $(commands/i386/pc/vbeinfo.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbeinfo_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh vbeinfo > $@ || (rm -f $@; exit 1)

vbeinfo_mod_CFLAGS = $(COMMON_CFLAGS)
vbeinfo_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For vbetest.mod.
vbetest_mod_SOURCES = commands/i386/pc/vbetest.c

clean-module-vbetest.mod.1:
	rm -f vbetest.mod mod-vbetest.o mod-vbetest.c pre-vbetest.o vbetest_mod-commands_i386_pc_vbetest.o und-vbetest.lst

CLEAN_MODULE_TARGETS += clean-module-vbetest.mod.1

ifneq ($(vbetest_mod_EXPORTS),no)
clean-module-vbetest.mod-symbol.1:
	rm -f def-vbetest.lst

CLEAN_MODULE_TARGETS += clean-module-vbetest.mod-symbol.1
DEFSYMFILES += def-vbetest.lst
endif
mostlyclean-module-vbetest.mod.1:
	rm -f vbetest_mod-commands_i386_pc_vbetest.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-vbetest.mod.1
UNDSYMFILES += und-vbetest.lst

ifneq ($(TARGET_APPLE_CC),1)
vbetest.mod: pre-vbetest.o mod-vbetest.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(vbetest_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-vbetest.o mod-vbetest.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
vbetest.mod: pre-vbetest.o mod-vbetest.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(vbetest_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-vbetest.o mod-vbetest.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-vbetest.o: $(vbetest_mod_DEPENDENCIES) vbetest_mod-commands_i386_pc_vbetest.o
	-rm -f $@
	$(TARGET_CC) $(vbetest_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ vbetest_mod-commands_i386_pc_vbetest.o

mod-vbetest.o: mod-vbetest.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(vbetest_mod_CFLAGS) -c -o $@ $<

mod-vbetest.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'vbetest' $< > $@ || (rm -f $@; exit 1)

ifneq ($(vbetest_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-vbetest.lst: pre-vbetest.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 vbetest/' > $@
else
def-vbetest.lst: pre-vbetest.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 vbetest/' > $@
endif
endif

und-vbetest.lst: pre-vbetest.o
	echo 'vbetest' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

vbetest_mod-commands_i386_pc_vbetest.o: commands/i386/pc/vbetest.c $(commands/i386/pc/vbetest.c_DEPENDENCIES)
	$(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbetest_mod_CFLAGS) -MD -c -o $@ $<
-include vbetest_mod-commands_i386_pc_vbetest.d

clean-module-vbetest_mod-commands_i386_pc_vbetest-extra.1:
	rm -f cmd-vbetest_mod-commands_i386_pc_vbetest.lst fs-vbetest_mod-commands_i386_pc_vbetest.lst partmap-vbetest_mod-commands_i386_pc_vbetest.lst handler-vbetest_mod-commands_i386_pc_vbetest.lst parttool-vbetest_mod-commands_i386_pc_vbetest.lst

CLEAN_MODULE_TARGETS += clean-module-vbetest_mod-commands_i386_pc_vbetest-extra.1

COMMANDFILES += cmd-vbetest_mod-commands_i386_pc_vbetest.lst
FSFILES += fs-vbetest_mod-commands_i386_pc_vbetest.lst
PARTTOOLFILES += parttool-vbetest_mod-commands_i386_pc_vbetest.lst
PARTMAPFILES += partmap-vbetest_mod-commands_i386_pc_vbetest.lst
HANDLERFILES += handler-vbetest_mod-commands_i386_pc_vbetest.lst

cmd-vbetest_mod-commands_i386_pc_vbetest.lst: commands/i386/pc/vbetest.c $(commands/i386/pc/vbetest.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbetest_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh vbetest > $@ || (rm -f $@; exit 1)

fs-vbetest_mod-commands_i386_pc_vbetest.lst: commands/i386/pc/vbetest.c $(commands/i386/pc/vbetest.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbetest_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh vbetest > $@ || (rm -f $@; exit 1)

parttool-vbetest_mod-commands_i386_pc_vbetest.lst: commands/i386/pc/vbetest.c $(commands/i386/pc/vbetest.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbetest_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh vbetest > $@ || (rm -f $@; exit 1)

partmap-vbetest_mod-commands_i386_pc_vbetest.lst: commands/i386/pc/vbetest.c $(commands/i386/pc/vbetest.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbetest_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh vbetest > $@ || (rm -f $@; exit 1)

handler-vbetest_mod-commands_i386_pc_vbetest.lst: commands/i386/pc/vbetest.c $(commands/i386/pc/vbetest.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vbetest_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh vbetest > $@ || (rm -f $@; exit 1)

vbetest_mod_CFLAGS = $(COMMON_CFLAGS)
vbetest_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For play.mod.
play_mod_SOURCES = commands/i386/pc/play.c

clean-module-play.mod.1:
	rm -f play.mod mod-play.o mod-play.c pre-play.o play_mod-commands_i386_pc_play.o und-play.lst

CLEAN_MODULE_TARGETS += clean-module-play.mod.1

ifneq ($(play_mod_EXPORTS),no)
clean-module-play.mod-symbol.1:
	rm -f def-play.lst

CLEAN_MODULE_TARGETS += clean-module-play.mod-symbol.1
DEFSYMFILES += def-play.lst
endif
mostlyclean-module-play.mod.1:
	rm -f play_mod-commands_i386_pc_play.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-play.mod.1
UNDSYMFILES += und-play.lst

ifneq ($(TARGET_APPLE_CC),1)
play.mod: pre-play.o mod-play.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(play_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-play.o mod-play.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
play.mod: pre-play.o mod-play.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(play_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-play.o mod-play.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-play.o: $(play_mod_DEPENDENCIES) play_mod-commands_i386_pc_play.o
	-rm -f $@
	$(TARGET_CC) $(play_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ play_mod-commands_i386_pc_play.o

mod-play.o: mod-play.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(play_mod_CFLAGS) -c -o $@ $<

mod-play.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'play' $< > $@ || (rm -f $@; exit 1)

ifneq ($(play_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-play.lst: pre-play.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 play/' > $@
else
def-play.lst: pre-play.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 play/' > $@
endif
endif

und-play.lst: pre-play.o
	echo 'play' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

play_mod-commands_i386_pc_play.o: commands/i386/pc/play.c $(commands/i386/pc/play.c_DEPENDENCIES)
	$(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(play_mod_CFLAGS) -MD -c -o $@ $<
-include play_mod-commands_i386_pc_play.d

clean-module-play_mod-commands_i386_pc_play-extra.1:
	rm -f cmd-play_mod-commands_i386_pc_play.lst fs-play_mod-commands_i386_pc_play.lst partmap-play_mod-commands_i386_pc_play.lst handler-play_mod-commands_i386_pc_play.lst parttool-play_mod-commands_i386_pc_play.lst

CLEAN_MODULE_TARGETS += clean-module-play_mod-commands_i386_pc_play-extra.1

COMMANDFILES += cmd-play_mod-commands_i386_pc_play.lst
FSFILES += fs-play_mod-commands_i386_pc_play.lst
PARTTOOLFILES += parttool-play_mod-commands_i386_pc_play.lst
PARTMAPFILES += partmap-play_mod-commands_i386_pc_play.lst
HANDLERFILES += handler-play_mod-commands_i386_pc_play.lst

cmd-play_mod-commands_i386_pc_play.lst: commands/i386/pc/play.c $(commands/i386/pc/play.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(play_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh play > $@ || (rm -f $@; exit 1)

fs-play_mod-commands_i386_pc_play.lst: commands/i386/pc/play.c $(commands/i386/pc/play.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(play_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh play > $@ || (rm -f $@; exit 1)

parttool-play_mod-commands_i386_pc_play.lst: commands/i386/pc/play.c $(commands/i386/pc/play.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(play_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh play > $@ || (rm -f $@; exit 1)

partmap-play_mod-commands_i386_pc_play.lst: commands/i386/pc/play.c $(commands/i386/pc/play.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(play_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh play > $@ || (rm -f $@; exit 1)

handler-play_mod-commands_i386_pc_play.lst: commands/i386/pc/play.c $(commands/i386/pc/play.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(play_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh play > $@ || (rm -f $@; exit 1)

play_mod_CFLAGS = $(COMMON_CFLAGS)
play_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For ata.mod.
ata_mod_SOURCES = disk/ata.c

clean-module-ata.mod.1:
	rm -f ata.mod mod-ata.o mod-ata.c pre-ata.o ata_mod-disk_ata.o und-ata.lst

CLEAN_MODULE_TARGETS += clean-module-ata.mod.1

ifneq ($(ata_mod_EXPORTS),no)
clean-module-ata.mod-symbol.1:
	rm -f def-ata.lst

CLEAN_MODULE_TARGETS += clean-module-ata.mod-symbol.1
DEFSYMFILES += def-ata.lst
endif
mostlyclean-module-ata.mod.1:
	rm -f ata_mod-disk_ata.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-ata.mod.1
UNDSYMFILES += und-ata.lst

ifneq ($(TARGET_APPLE_CC),1)
ata.mod: pre-ata.o mod-ata.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(ata_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-ata.o mod-ata.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
ata.mod: pre-ata.o mod-ata.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(ata_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-ata.o mod-ata.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-ata.o: $(ata_mod_DEPENDENCIES) ata_mod-disk_ata.o
	-rm -f $@
	$(TARGET_CC) $(ata_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ ata_mod-disk_ata.o

mod-ata.o: mod-ata.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(ata_mod_CFLAGS) -c -o $@ $<

mod-ata.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'ata' $< > $@ || (rm -f $@; exit 1)

ifneq ($(ata_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-ata.lst: pre-ata.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 ata/' > $@
else
def-ata.lst: pre-ata.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 ata/' > $@
endif
endif

und-ata.lst: pre-ata.o
	echo 'ata' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

ata_mod-disk_ata.o: disk/ata.c $(disk/ata.c_DEPENDENCIES)
	$(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ata_mod_CFLAGS) -MD -c -o $@ $<
-include ata_mod-disk_ata.d

clean-module-ata_mod-disk_ata-extra.1:
	rm -f cmd-ata_mod-disk_ata.lst fs-ata_mod-disk_ata.lst partmap-ata_mod-disk_ata.lst handler-ata_mod-disk_ata.lst parttool-ata_mod-disk_ata.lst

CLEAN_MODULE_TARGETS += clean-module-ata_mod-disk_ata-extra.1

COMMANDFILES += cmd-ata_mod-disk_ata.lst
FSFILES += fs-ata_mod-disk_ata.lst
PARTTOOLFILES += parttool-ata_mod-disk_ata.lst
PARTMAPFILES += partmap-ata_mod-disk_ata.lst
HANDLERFILES += handler-ata_mod-disk_ata.lst

cmd-ata_mod-disk_ata.lst: disk/ata.c $(disk/ata.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ata_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh ata > $@ || (rm -f $@; exit 1)

fs-ata_mod-disk_ata.lst: disk/ata.c $(disk/ata.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ata_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh ata > $@ || (rm -f $@; exit 1)

parttool-ata_mod-disk_ata.lst: disk/ata.c $(disk/ata.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ata_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh ata > $@ || (rm -f $@; exit 1)

partmap-ata_mod-disk_ata.lst: disk/ata.c $(disk/ata.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ata_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh ata > $@ || (rm -f $@; exit 1)

handler-ata_mod-disk_ata.lst: disk/ata.c $(disk/ata.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ata_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh ata > $@ || (rm -f $@; exit 1)

ata_mod_CFLAGS = $(COMMON_CFLAGS)
ata_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For vga.mod.
vga_mod_SOURCES = term/i386/pc/vga.c

clean-module-vga.mod.1:
	rm -f vga.mod mod-vga.o mod-vga.c pre-vga.o vga_mod-term_i386_pc_vga.o und-vga.lst

CLEAN_MODULE_TARGETS += clean-module-vga.mod.1

ifneq ($(vga_mod_EXPORTS),no)
clean-module-vga.mod-symbol.1:
	rm -f def-vga.lst

CLEAN_MODULE_TARGETS += clean-module-vga.mod-symbol.1
DEFSYMFILES += def-vga.lst
endif
mostlyclean-module-vga.mod.1:
	rm -f vga_mod-term_i386_pc_vga.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-vga.mod.1
UNDSYMFILES += und-vga.lst

ifneq ($(TARGET_APPLE_CC),1)
vga.mod: pre-vga.o mod-vga.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(vga_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-vga.o mod-vga.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
vga.mod: pre-vga.o mod-vga.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(vga_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-vga.o mod-vga.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-vga.o: $(vga_mod_DEPENDENCIES) vga_mod-term_i386_pc_vga.o
	-rm -f $@
	$(TARGET_CC) $(vga_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ vga_mod-term_i386_pc_vga.o

mod-vga.o: mod-vga.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(vga_mod_CFLAGS) -c -o $@ $<

mod-vga.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'vga' $< > $@ || (rm -f $@; exit 1)

ifneq ($(vga_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-vga.lst: pre-vga.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 vga/' > $@
else
def-vga.lst: pre-vga.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 vga/' > $@
endif
endif

und-vga.lst: pre-vga.o
	echo 'vga' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

vga_mod-term_i386_pc_vga.o: term/i386/pc/vga.c $(term/i386/pc/vga.c_DEPENDENCIES)
	$(TARGET_CC) -Iterm/i386/pc -I$(srcdir)/term/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vga_mod_CFLAGS) -MD -c -o $@ $<
-include vga_mod-term_i386_pc_vga.d

clean-module-vga_mod-term_i386_pc_vga-extra.1:
	rm -f cmd-vga_mod-term_i386_pc_vga.lst fs-vga_mod-term_i386_pc_vga.lst partmap-vga_mod-term_i386_pc_vga.lst handler-vga_mod-term_i386_pc_vga.lst parttool-vga_mod-term_i386_pc_vga.lst

CLEAN_MODULE_TARGETS += clean-module-vga_mod-term_i386_pc_vga-extra.1

COMMANDFILES += cmd-vga_mod-term_i386_pc_vga.lst
FSFILES += fs-vga_mod-term_i386_pc_vga.lst
PARTTOOLFILES += parttool-vga_mod-term_i386_pc_vga.lst
PARTMAPFILES += partmap-vga_mod-term_i386_pc_vga.lst
HANDLERFILES += handler-vga_mod-term_i386_pc_vga.lst

cmd-vga_mod-term_i386_pc_vga.lst: term/i386/pc/vga.c $(term/i386/pc/vga.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iterm/i386/pc -I$(srcdir)/term/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vga_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh vga > $@ || (rm -f $@; exit 1)

fs-vga_mod-term_i386_pc_vga.lst: term/i386/pc/vga.c $(term/i386/pc/vga.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iterm/i386/pc -I$(srcdir)/term/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vga_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh vga > $@ || (rm -f $@; exit 1)

parttool-vga_mod-term_i386_pc_vga.lst: term/i386/pc/vga.c $(term/i386/pc/vga.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iterm/i386/pc -I$(srcdir)/term/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vga_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh vga > $@ || (rm -f $@; exit 1)

partmap-vga_mod-term_i386_pc_vga.lst: term/i386/pc/vga.c $(term/i386/pc/vga.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iterm/i386/pc -I$(srcdir)/term/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vga_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh vga > $@ || (rm -f $@; exit 1)

handler-vga_mod-term_i386_pc_vga.lst: term/i386/pc/vga.c $(term/i386/pc/vga.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iterm/i386/pc -I$(srcdir)/term/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(vga_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh vga > $@ || (rm -f $@; exit 1)

vga_mod_CFLAGS = $(COMMON_CFLAGS)
vga_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For memdisk.mod.
memdisk_mod_SOURCES = disk/memdisk.c

clean-module-memdisk.mod.1:
	rm -f memdisk.mod mod-memdisk.o mod-memdisk.c pre-memdisk.o memdisk_mod-disk_memdisk.o und-memdisk.lst

CLEAN_MODULE_TARGETS += clean-module-memdisk.mod.1

ifneq ($(memdisk_mod_EXPORTS),no)
clean-module-memdisk.mod-symbol.1:
	rm -f def-memdisk.lst

CLEAN_MODULE_TARGETS += clean-module-memdisk.mod-symbol.1
DEFSYMFILES += def-memdisk.lst
endif
mostlyclean-module-memdisk.mod.1:
	rm -f memdisk_mod-disk_memdisk.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-memdisk.mod.1
UNDSYMFILES += und-memdisk.lst

ifneq ($(TARGET_APPLE_CC),1)
memdisk.mod: pre-memdisk.o mod-memdisk.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(memdisk_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-memdisk.o mod-memdisk.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
memdisk.mod: pre-memdisk.o mod-memdisk.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(memdisk_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-memdisk.o mod-memdisk.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-memdisk.o: $(memdisk_mod_DEPENDENCIES) memdisk_mod-disk_memdisk.o
	-rm -f $@
	$(TARGET_CC) $(memdisk_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ memdisk_mod-disk_memdisk.o

mod-memdisk.o: mod-memdisk.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(memdisk_mod_CFLAGS) -c -o $@ $<

mod-memdisk.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'memdisk' $< > $@ || (rm -f $@; exit 1)

ifneq ($(memdisk_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-memdisk.lst: pre-memdisk.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 memdisk/' > $@
else
def-memdisk.lst: pre-memdisk.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 memdisk/' > $@
endif
endif

und-memdisk.lst: pre-memdisk.o
	echo 'memdisk' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

memdisk_mod-disk_memdisk.o: disk/memdisk.c $(disk/memdisk.c_DEPENDENCIES)
	$(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(memdisk_mod_CFLAGS) -MD -c -o $@ $<
-include memdisk_mod-disk_memdisk.d

clean-module-memdisk_mod-disk_memdisk-extra.1:
	rm -f cmd-memdisk_mod-disk_memdisk.lst fs-memdisk_mod-disk_memdisk.lst partmap-memdisk_mod-disk_memdisk.lst handler-memdisk_mod-disk_memdisk.lst parttool-memdisk_mod-disk_memdisk.lst

CLEAN_MODULE_TARGETS += clean-module-memdisk_mod-disk_memdisk-extra.1

COMMANDFILES += cmd-memdisk_mod-disk_memdisk.lst
FSFILES += fs-memdisk_mod-disk_memdisk.lst
PARTTOOLFILES += parttool-memdisk_mod-disk_memdisk.lst
PARTMAPFILES += partmap-memdisk_mod-disk_memdisk.lst
HANDLERFILES += handler-memdisk_mod-disk_memdisk.lst

cmd-memdisk_mod-disk_memdisk.lst: disk/memdisk.c $(disk/memdisk.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(memdisk_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh memdisk > $@ || (rm -f $@; exit 1)

fs-memdisk_mod-disk_memdisk.lst: disk/memdisk.c $(disk/memdisk.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(memdisk_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh memdisk > $@ || (rm -f $@; exit 1)

parttool-memdisk_mod-disk_memdisk.lst: disk/memdisk.c $(disk/memdisk.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(memdisk_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh memdisk > $@ || (rm -f $@; exit 1)

partmap-memdisk_mod-disk_memdisk.lst: disk/memdisk.c $(disk/memdisk.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(memdisk_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh memdisk > $@ || (rm -f $@; exit 1)

handler-memdisk_mod-disk_memdisk.lst: disk/memdisk.c $(disk/memdisk.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(memdisk_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh memdisk > $@ || (rm -f $@; exit 1)

memdisk_mod_CFLAGS = $(COMMON_CFLAGS)
memdisk_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For pci.mod
pci_mod_SOURCES = bus/pci.c

clean-module-pci.mod.1:
	rm -f pci.mod mod-pci.o mod-pci.c pre-pci.o pci_mod-bus_pci.o und-pci.lst

CLEAN_MODULE_TARGETS += clean-module-pci.mod.1

ifneq ($(pci_mod_EXPORTS),no)
clean-module-pci.mod-symbol.1:
	rm -f def-pci.lst

CLEAN_MODULE_TARGETS += clean-module-pci.mod-symbol.1
DEFSYMFILES += def-pci.lst
endif
mostlyclean-module-pci.mod.1:
	rm -f pci_mod-bus_pci.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-pci.mod.1
UNDSYMFILES += und-pci.lst

ifneq ($(TARGET_APPLE_CC),1)
pci.mod: pre-pci.o mod-pci.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(pci_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-pci.o mod-pci.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
pci.mod: pre-pci.o mod-pci.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(pci_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-pci.o mod-pci.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-pci.o: $(pci_mod_DEPENDENCIES) pci_mod-bus_pci.o
	-rm -f $@
	$(TARGET_CC) $(pci_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pci_mod-bus_pci.o

mod-pci.o: mod-pci.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(pci_mod_CFLAGS) -c -o $@ $<

mod-pci.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'pci' $< > $@ || (rm -f $@; exit 1)

ifneq ($(pci_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-pci.lst: pre-pci.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 pci/' > $@
else
def-pci.lst: pre-pci.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 pci/' > $@
endif
endif

und-pci.lst: pre-pci.o
	echo 'pci' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

pci_mod-bus_pci.o: bus/pci.c $(bus/pci.c_DEPENDENCIES)
	$(TARGET_CC) -Ibus -I$(srcdir)/bus $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pci_mod_CFLAGS) -MD -c -o $@ $<
-include pci_mod-bus_pci.d

clean-module-pci_mod-bus_pci-extra.1:
	rm -f cmd-pci_mod-bus_pci.lst fs-pci_mod-bus_pci.lst partmap-pci_mod-bus_pci.lst handler-pci_mod-bus_pci.lst parttool-pci_mod-bus_pci.lst

CLEAN_MODULE_TARGETS += clean-module-pci_mod-bus_pci-extra.1

COMMANDFILES += cmd-pci_mod-bus_pci.lst
FSFILES += fs-pci_mod-bus_pci.lst
PARTTOOLFILES += parttool-pci_mod-bus_pci.lst
PARTMAPFILES += partmap-pci_mod-bus_pci.lst
HANDLERFILES += handler-pci_mod-bus_pci.lst

cmd-pci_mod-bus_pci.lst: bus/pci.c $(bus/pci.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Ibus -I$(srcdir)/bus $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh pci > $@ || (rm -f $@; exit 1)

fs-pci_mod-bus_pci.lst: bus/pci.c $(bus/pci.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Ibus -I$(srcdir)/bus $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh pci > $@ || (rm -f $@; exit 1)

parttool-pci_mod-bus_pci.lst: bus/pci.c $(bus/pci.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Ibus -I$(srcdir)/bus $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh pci > $@ || (rm -f $@; exit 1)

partmap-pci_mod-bus_pci.lst: bus/pci.c $(bus/pci.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Ibus -I$(srcdir)/bus $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh pci > $@ || (rm -f $@; exit 1)

handler-pci_mod-bus_pci.lst: bus/pci.c $(bus/pci.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Ibus -I$(srcdir)/bus $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh pci > $@ || (rm -f $@; exit 1)

pci_mod_CFLAGS = $(COMMON_CFLAGS)
pci_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For lspci.mod
lspci_mod_SOURCES = commands/lspci.c

clean-module-lspci.mod.1:
	rm -f lspci.mod mod-lspci.o mod-lspci.c pre-lspci.o lspci_mod-commands_lspci.o und-lspci.lst

CLEAN_MODULE_TARGETS += clean-module-lspci.mod.1

ifneq ($(lspci_mod_EXPORTS),no)
clean-module-lspci.mod-symbol.1:
	rm -f def-lspci.lst

CLEAN_MODULE_TARGETS += clean-module-lspci.mod-symbol.1
DEFSYMFILES += def-lspci.lst
endif
mostlyclean-module-lspci.mod.1:
	rm -f lspci_mod-commands_lspci.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-lspci.mod.1
UNDSYMFILES += und-lspci.lst

ifneq ($(TARGET_APPLE_CC),1)
lspci.mod: pre-lspci.o mod-lspci.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(lspci_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-lspci.o mod-lspci.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
lspci.mod: pre-lspci.o mod-lspci.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(lspci_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-lspci.o mod-lspci.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-lspci.o: $(lspci_mod_DEPENDENCIES) lspci_mod-commands_lspci.o
	-rm -f $@
	$(TARGET_CC) $(lspci_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ lspci_mod-commands_lspci.o

mod-lspci.o: mod-lspci.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(lspci_mod_CFLAGS) -c -o $@ $<

mod-lspci.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'lspci' $< > $@ || (rm -f $@; exit 1)

ifneq ($(lspci_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-lspci.lst: pre-lspci.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 lspci/' > $@
else
def-lspci.lst: pre-lspci.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 lspci/' > $@
endif
endif

und-lspci.lst: pre-lspci.o
	echo 'lspci' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

lspci_mod-commands_lspci.o: commands/lspci.c $(commands/lspci.c_DEPENDENCIES)
	$(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lspci_mod_CFLAGS) -MD -c -o $@ $<
-include lspci_mod-commands_lspci.d

clean-module-lspci_mod-commands_lspci-extra.1:
	rm -f cmd-lspci_mod-commands_lspci.lst fs-lspci_mod-commands_lspci.lst partmap-lspci_mod-commands_lspci.lst handler-lspci_mod-commands_lspci.lst parttool-lspci_mod-commands_lspci.lst

CLEAN_MODULE_TARGETS += clean-module-lspci_mod-commands_lspci-extra.1

COMMANDFILES += cmd-lspci_mod-commands_lspci.lst
FSFILES += fs-lspci_mod-commands_lspci.lst
PARTTOOLFILES += parttool-lspci_mod-commands_lspci.lst
PARTMAPFILES += partmap-lspci_mod-commands_lspci.lst
HANDLERFILES += handler-lspci_mod-commands_lspci.lst

cmd-lspci_mod-commands_lspci.lst: commands/lspci.c $(commands/lspci.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lspci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh lspci > $@ || (rm -f $@; exit 1)

fs-lspci_mod-commands_lspci.lst: commands/lspci.c $(commands/lspci.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lspci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh lspci > $@ || (rm -f $@; exit 1)

parttool-lspci_mod-commands_lspci.lst: commands/lspci.c $(commands/lspci.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lspci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh lspci > $@ || (rm -f $@; exit 1)

partmap-lspci_mod-commands_lspci.lst: commands/lspci.c $(commands/lspci.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lspci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh lspci > $@ || (rm -f $@; exit 1)

handler-lspci_mod-commands_lspci.lst: commands/lspci.c $(commands/lspci.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lspci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh lspci > $@ || (rm -f $@; exit 1)

lspci_mod_CFLAGS = $(COMMON_CFLAGS)
lspci_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For aout.mod
aout_mod_SOURCES = loader/aout.c

clean-module-aout.mod.1:
	rm -f aout.mod mod-aout.o mod-aout.c pre-aout.o aout_mod-loader_aout.o und-aout.lst

CLEAN_MODULE_TARGETS += clean-module-aout.mod.1

ifneq ($(aout_mod_EXPORTS),no)
clean-module-aout.mod-symbol.1:
	rm -f def-aout.lst

CLEAN_MODULE_TARGETS += clean-module-aout.mod-symbol.1
DEFSYMFILES += def-aout.lst
endif
mostlyclean-module-aout.mod.1:
	rm -f aout_mod-loader_aout.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-aout.mod.1
UNDSYMFILES += und-aout.lst

ifneq ($(TARGET_APPLE_CC),1)
aout.mod: pre-aout.o mod-aout.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(aout_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-aout.o mod-aout.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
aout.mod: pre-aout.o mod-aout.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(aout_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-aout.o mod-aout.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-aout.o: $(aout_mod_DEPENDENCIES) aout_mod-loader_aout.o
	-rm -f $@
	$(TARGET_CC) $(aout_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ aout_mod-loader_aout.o

mod-aout.o: mod-aout.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(aout_mod_CFLAGS) -c -o $@ $<

mod-aout.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'aout' $< > $@ || (rm -f $@; exit 1)

ifneq ($(aout_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-aout.lst: pre-aout.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 aout/' > $@
else
def-aout.lst: pre-aout.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 aout/' > $@
endif
endif

und-aout.lst: pre-aout.o
	echo 'aout' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

aout_mod-loader_aout.o: loader/aout.c $(loader/aout.c_DEPENDENCIES)
	$(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(aout_mod_CFLAGS) -MD -c -o $@ $<
-include aout_mod-loader_aout.d

clean-module-aout_mod-loader_aout-extra.1:
	rm -f cmd-aout_mod-loader_aout.lst fs-aout_mod-loader_aout.lst partmap-aout_mod-loader_aout.lst handler-aout_mod-loader_aout.lst parttool-aout_mod-loader_aout.lst

CLEAN_MODULE_TARGETS += clean-module-aout_mod-loader_aout-extra.1

COMMANDFILES += cmd-aout_mod-loader_aout.lst
FSFILES += fs-aout_mod-loader_aout.lst
PARTTOOLFILES += parttool-aout_mod-loader_aout.lst
PARTMAPFILES += partmap-aout_mod-loader_aout.lst
HANDLERFILES += handler-aout_mod-loader_aout.lst

cmd-aout_mod-loader_aout.lst: loader/aout.c $(loader/aout.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(aout_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh aout > $@ || (rm -f $@; exit 1)

fs-aout_mod-loader_aout.lst: loader/aout.c $(loader/aout.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(aout_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh aout > $@ || (rm -f $@; exit 1)

parttool-aout_mod-loader_aout.lst: loader/aout.c $(loader/aout.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(aout_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh aout > $@ || (rm -f $@; exit 1)

partmap-aout_mod-loader_aout.lst: loader/aout.c $(loader/aout.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(aout_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh aout > $@ || (rm -f $@; exit 1)

handler-aout_mod-loader_aout.lst: loader/aout.c $(loader/aout.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader -I$(srcdir)/loader $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(aout_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh aout > $@ || (rm -f $@; exit 1)

aout_mod_CFLAGS = $(COMMON_CFLAGS)
aout_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For bsd.mod
bsd_mod_SOURCES = loader/i386/bsd.c loader/i386/bsd32.c loader/i386/bsd64.c loader/i386/bsd_helper.S loader/i386/bsd_trampoline.S

clean-module-bsd.mod.1:
	rm -f bsd.mod mod-bsd.o mod-bsd.c pre-bsd.o bsd_mod-loader_i386_bsd.o bsd_mod-loader_i386_bsd32.o bsd_mod-loader_i386_bsd64.o bsd_mod-loader_i386_bsd_helper.o bsd_mod-loader_i386_bsd_trampoline.o und-bsd.lst

CLEAN_MODULE_TARGETS += clean-module-bsd.mod.1

ifneq ($(bsd_mod_EXPORTS),no)
clean-module-bsd.mod-symbol.1:
	rm -f def-bsd.lst

CLEAN_MODULE_TARGETS += clean-module-bsd.mod-symbol.1
DEFSYMFILES += def-bsd.lst
endif
mostlyclean-module-bsd.mod.1:
	rm -f bsd_mod-loader_i386_bsd.d bsd_mod-loader_i386_bsd32.d bsd_mod-loader_i386_bsd64.d bsd_mod-loader_i386_bsd_helper.d bsd_mod-loader_i386_bsd_trampoline.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-bsd.mod.1
UNDSYMFILES += und-bsd.lst

ifneq ($(TARGET_APPLE_CC),1)
bsd.mod: pre-bsd.o mod-bsd.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(bsd_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-bsd.o mod-bsd.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
bsd.mod: pre-bsd.o mod-bsd.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(bsd_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-bsd.o mod-bsd.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-bsd.o: $(bsd_mod_DEPENDENCIES) bsd_mod-loader_i386_bsd.o bsd_mod-loader_i386_bsd32.o bsd_mod-loader_i386_bsd64.o bsd_mod-loader_i386_bsd_helper.o bsd_mod-loader_i386_bsd_trampoline.o
	-rm -f $@
	$(TARGET_CC) $(bsd_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ bsd_mod-loader_i386_bsd.o bsd_mod-loader_i386_bsd32.o bsd_mod-loader_i386_bsd64.o bsd_mod-loader_i386_bsd_helper.o bsd_mod-loader_i386_bsd_trampoline.o

mod-bsd.o: mod-bsd.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -c -o $@ $<

mod-bsd.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'bsd' $< > $@ || (rm -f $@; exit 1)

ifneq ($(bsd_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-bsd.lst: pre-bsd.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 bsd/' > $@
else
def-bsd.lst: pre-bsd.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 bsd/' > $@
endif
endif

und-bsd.lst: pre-bsd.o
	echo 'bsd' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

bsd_mod-loader_i386_bsd.o: loader/i386/bsd.c $(loader/i386/bsd.c_DEPENDENCIES)
	$(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -MD -c -o $@ $<
-include bsd_mod-loader_i386_bsd.d

clean-module-bsd_mod-loader_i386_bsd-extra.1:
	rm -f cmd-bsd_mod-loader_i386_bsd.lst fs-bsd_mod-loader_i386_bsd.lst partmap-bsd_mod-loader_i386_bsd.lst handler-bsd_mod-loader_i386_bsd.lst parttool-bsd_mod-loader_i386_bsd.lst

CLEAN_MODULE_TARGETS += clean-module-bsd_mod-loader_i386_bsd-extra.1

COMMANDFILES += cmd-bsd_mod-loader_i386_bsd.lst
FSFILES += fs-bsd_mod-loader_i386_bsd.lst
PARTTOOLFILES += parttool-bsd_mod-loader_i386_bsd.lst
PARTMAPFILES += partmap-bsd_mod-loader_i386_bsd.lst
HANDLERFILES += handler-bsd_mod-loader_i386_bsd.lst

cmd-bsd_mod-loader_i386_bsd.lst: loader/i386/bsd.c $(loader/i386/bsd.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh bsd > $@ || (rm -f $@; exit 1)

fs-bsd_mod-loader_i386_bsd.lst: loader/i386/bsd.c $(loader/i386/bsd.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh bsd > $@ || (rm -f $@; exit 1)

parttool-bsd_mod-loader_i386_bsd.lst: loader/i386/bsd.c $(loader/i386/bsd.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh bsd > $@ || (rm -f $@; exit 1)

partmap-bsd_mod-loader_i386_bsd.lst: loader/i386/bsd.c $(loader/i386/bsd.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh bsd > $@ || (rm -f $@; exit 1)

handler-bsd_mod-loader_i386_bsd.lst: loader/i386/bsd.c $(loader/i386/bsd.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh bsd > $@ || (rm -f $@; exit 1)

bsd_mod-loader_i386_bsd32.o: loader/i386/bsd32.c $(loader/i386/bsd32.c_DEPENDENCIES)
	$(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -MD -c -o $@ $<
-include bsd_mod-loader_i386_bsd32.d

clean-module-bsd_mod-loader_i386_bsd32-extra.1:
	rm -f cmd-bsd_mod-loader_i386_bsd32.lst fs-bsd_mod-loader_i386_bsd32.lst partmap-bsd_mod-loader_i386_bsd32.lst handler-bsd_mod-loader_i386_bsd32.lst parttool-bsd_mod-loader_i386_bsd32.lst

CLEAN_MODULE_TARGETS += clean-module-bsd_mod-loader_i386_bsd32-extra.1

COMMANDFILES += cmd-bsd_mod-loader_i386_bsd32.lst
FSFILES += fs-bsd_mod-loader_i386_bsd32.lst
PARTTOOLFILES += parttool-bsd_mod-loader_i386_bsd32.lst
PARTMAPFILES += partmap-bsd_mod-loader_i386_bsd32.lst
HANDLERFILES += handler-bsd_mod-loader_i386_bsd32.lst

cmd-bsd_mod-loader_i386_bsd32.lst: loader/i386/bsd32.c $(loader/i386/bsd32.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh bsd > $@ || (rm -f $@; exit 1)

fs-bsd_mod-loader_i386_bsd32.lst: loader/i386/bsd32.c $(loader/i386/bsd32.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh bsd > $@ || (rm -f $@; exit 1)

parttool-bsd_mod-loader_i386_bsd32.lst: loader/i386/bsd32.c $(loader/i386/bsd32.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh bsd > $@ || (rm -f $@; exit 1)

partmap-bsd_mod-loader_i386_bsd32.lst: loader/i386/bsd32.c $(loader/i386/bsd32.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh bsd > $@ || (rm -f $@; exit 1)

handler-bsd_mod-loader_i386_bsd32.lst: loader/i386/bsd32.c $(loader/i386/bsd32.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh bsd > $@ || (rm -f $@; exit 1)

bsd_mod-loader_i386_bsd64.o: loader/i386/bsd64.c $(loader/i386/bsd64.c_DEPENDENCIES)
	$(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -MD -c -o $@ $<
-include bsd_mod-loader_i386_bsd64.d

clean-module-bsd_mod-loader_i386_bsd64-extra.1:
	rm -f cmd-bsd_mod-loader_i386_bsd64.lst fs-bsd_mod-loader_i386_bsd64.lst partmap-bsd_mod-loader_i386_bsd64.lst handler-bsd_mod-loader_i386_bsd64.lst parttool-bsd_mod-loader_i386_bsd64.lst

CLEAN_MODULE_TARGETS += clean-module-bsd_mod-loader_i386_bsd64-extra.1

COMMANDFILES += cmd-bsd_mod-loader_i386_bsd64.lst
FSFILES += fs-bsd_mod-loader_i386_bsd64.lst
PARTTOOLFILES += parttool-bsd_mod-loader_i386_bsd64.lst
PARTMAPFILES += partmap-bsd_mod-loader_i386_bsd64.lst
HANDLERFILES += handler-bsd_mod-loader_i386_bsd64.lst

cmd-bsd_mod-loader_i386_bsd64.lst: loader/i386/bsd64.c $(loader/i386/bsd64.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh bsd > $@ || (rm -f $@; exit 1)

fs-bsd_mod-loader_i386_bsd64.lst: loader/i386/bsd64.c $(loader/i386/bsd64.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh bsd > $@ || (rm -f $@; exit 1)

parttool-bsd_mod-loader_i386_bsd64.lst: loader/i386/bsd64.c $(loader/i386/bsd64.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh bsd > $@ || (rm -f $@; exit 1)

partmap-bsd_mod-loader_i386_bsd64.lst: loader/i386/bsd64.c $(loader/i386/bsd64.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh bsd > $@ || (rm -f $@; exit 1)

handler-bsd_mod-loader_i386_bsd64.lst: loader/i386/bsd64.c $(loader/i386/bsd64.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(bsd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh bsd > $@ || (rm -f $@; exit 1)

bsd_mod-loader_i386_bsd_helper.o: loader/i386/bsd_helper.S $(loader/i386/bsd_helper.S_DEPENDENCIES)
	$(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(bsd_mod_ASFLAGS) -MD -c -o $@ $<
-include bsd_mod-loader_i386_bsd_helper.d

clean-module-bsd_mod-loader_i386_bsd_helper-extra.1:
	rm -f cmd-bsd_mod-loader_i386_bsd_helper.lst fs-bsd_mod-loader_i386_bsd_helper.lst partmap-bsd_mod-loader_i386_bsd_helper.lst handler-bsd_mod-loader_i386_bsd_helper.lst parttool-bsd_mod-loader_i386_bsd_helper.lst

CLEAN_MODULE_TARGETS += clean-module-bsd_mod-loader_i386_bsd_helper-extra.1

COMMANDFILES += cmd-bsd_mod-loader_i386_bsd_helper.lst
FSFILES += fs-bsd_mod-loader_i386_bsd_helper.lst
PARTTOOLFILES += parttool-bsd_mod-loader_i386_bsd_helper.lst
PARTMAPFILES += partmap-bsd_mod-loader_i386_bsd_helper.lst
HANDLERFILES += handler-bsd_mod-loader_i386_bsd_helper.lst

cmd-bsd_mod-loader_i386_bsd_helper.lst: loader/i386/bsd_helper.S $(loader/i386/bsd_helper.S_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(bsd_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh bsd > $@ || (rm -f $@; exit 1)

fs-bsd_mod-loader_i386_bsd_helper.lst: loader/i386/bsd_helper.S $(loader/i386/bsd_helper.S_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(bsd_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh bsd > $@ || (rm -f $@; exit 1)

parttool-bsd_mod-loader_i386_bsd_helper.lst: loader/i386/bsd_helper.S $(loader/i386/bsd_helper.S_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(bsd_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh bsd > $@ || (rm -f $@; exit 1)

partmap-bsd_mod-loader_i386_bsd_helper.lst: loader/i386/bsd_helper.S $(loader/i386/bsd_helper.S_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(bsd_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh bsd > $@ || (rm -f $@; exit 1)

handler-bsd_mod-loader_i386_bsd_helper.lst: loader/i386/bsd_helper.S $(loader/i386/bsd_helper.S_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(bsd_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh bsd > $@ || (rm -f $@; exit 1)

bsd_mod-loader_i386_bsd_trampoline.o: loader/i386/bsd_trampoline.S $(loader/i386/bsd_trampoline.S_DEPENDENCIES)
	$(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(bsd_mod_ASFLAGS) -MD -c -o $@ $<
-include bsd_mod-loader_i386_bsd_trampoline.d

clean-module-bsd_mod-loader_i386_bsd_trampoline-extra.1:
	rm -f cmd-bsd_mod-loader_i386_bsd_trampoline.lst fs-bsd_mod-loader_i386_bsd_trampoline.lst partmap-bsd_mod-loader_i386_bsd_trampoline.lst handler-bsd_mod-loader_i386_bsd_trampoline.lst parttool-bsd_mod-loader_i386_bsd_trampoline.lst

CLEAN_MODULE_TARGETS += clean-module-bsd_mod-loader_i386_bsd_trampoline-extra.1

COMMANDFILES += cmd-bsd_mod-loader_i386_bsd_trampoline.lst
FSFILES += fs-bsd_mod-loader_i386_bsd_trampoline.lst
PARTTOOLFILES += parttool-bsd_mod-loader_i386_bsd_trampoline.lst
PARTMAPFILES += partmap-bsd_mod-loader_i386_bsd_trampoline.lst
HANDLERFILES += handler-bsd_mod-loader_i386_bsd_trampoline.lst

cmd-bsd_mod-loader_i386_bsd_trampoline.lst: loader/i386/bsd_trampoline.S $(loader/i386/bsd_trampoline.S_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(bsd_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh bsd > $@ || (rm -f $@; exit 1)

fs-bsd_mod-loader_i386_bsd_trampoline.lst: loader/i386/bsd_trampoline.S $(loader/i386/bsd_trampoline.S_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(bsd_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh bsd > $@ || (rm -f $@; exit 1)

parttool-bsd_mod-loader_i386_bsd_trampoline.lst: loader/i386/bsd_trampoline.S $(loader/i386/bsd_trampoline.S_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(bsd_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh bsd > $@ || (rm -f $@; exit 1)

partmap-bsd_mod-loader_i386_bsd_trampoline.lst: loader/i386/bsd_trampoline.S $(loader/i386/bsd_trampoline.S_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(bsd_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh bsd > $@ || (rm -f $@; exit 1)

handler-bsd_mod-loader_i386_bsd_trampoline.lst: loader/i386/bsd_trampoline.S $(loader/i386/bsd_trampoline.S_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iloader/i386 -I$(srcdir)/loader/i386 $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(bsd_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh bsd > $@ || (rm -f $@; exit 1)

bsd_mod_CFLAGS = $(COMMON_CFLAGS)
bsd_mod_LDFLAGS = $(COMMON_LDFLAGS)
bsd_mod_ASFLAGS = $(COMMON_ASFLAGS)

# For usb.mod
usb_mod_SOURCES = bus/usb/usb.c bus/usb/usbtrans.c bus/usb/usbhub.c

clean-module-usb.mod.1:
	rm -f usb.mod mod-usb.o mod-usb.c pre-usb.o usb_mod-bus_usb_usb.o usb_mod-bus_usb_usbtrans.o usb_mod-bus_usb_usbhub.o und-usb.lst

CLEAN_MODULE_TARGETS += clean-module-usb.mod.1

ifneq ($(usb_mod_EXPORTS),no)
clean-module-usb.mod-symbol.1:
	rm -f def-usb.lst

CLEAN_MODULE_TARGETS += clean-module-usb.mod-symbol.1
DEFSYMFILES += def-usb.lst
endif
mostlyclean-module-usb.mod.1:
	rm -f usb_mod-bus_usb_usb.d usb_mod-bus_usb_usbtrans.d usb_mod-bus_usb_usbhub.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-usb.mod.1
UNDSYMFILES += und-usb.lst

ifneq ($(TARGET_APPLE_CC),1)
usb.mod: pre-usb.o mod-usb.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(usb_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-usb.o mod-usb.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
usb.mod: pre-usb.o mod-usb.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(usb_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-usb.o mod-usb.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-usb.o: $(usb_mod_DEPENDENCIES) usb_mod-bus_usb_usb.o usb_mod-bus_usb_usbtrans.o usb_mod-bus_usb_usbhub.o
	-rm -f $@
	$(TARGET_CC) $(usb_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ usb_mod-bus_usb_usb.o usb_mod-bus_usb_usbtrans.o usb_mod-bus_usb_usbhub.o

mod-usb.o: mod-usb.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -c -o $@ $<

mod-usb.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'usb' $< > $@ || (rm -f $@; exit 1)

ifneq ($(usb_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-usb.lst: pre-usb.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 usb/' > $@
else
def-usb.lst: pre-usb.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 usb/' > $@
endif
endif

und-usb.lst: pre-usb.o
	echo 'usb' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

usb_mod-bus_usb_usb.o: bus/usb/usb.c $(bus/usb/usb.c_DEPENDENCIES)
	$(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -MD -c -o $@ $<
-include usb_mod-bus_usb_usb.d

clean-module-usb_mod-bus_usb_usb-extra.1:
	rm -f cmd-usb_mod-bus_usb_usb.lst fs-usb_mod-bus_usb_usb.lst partmap-usb_mod-bus_usb_usb.lst handler-usb_mod-bus_usb_usb.lst parttool-usb_mod-bus_usb_usb.lst

CLEAN_MODULE_TARGETS += clean-module-usb_mod-bus_usb_usb-extra.1

COMMANDFILES += cmd-usb_mod-bus_usb_usb.lst
FSFILES += fs-usb_mod-bus_usb_usb.lst
PARTTOOLFILES += parttool-usb_mod-bus_usb_usb.lst
PARTMAPFILES += partmap-usb_mod-bus_usb_usb.lst
HANDLERFILES += handler-usb_mod-bus_usb_usb.lst

cmd-usb_mod-bus_usb_usb.lst: bus/usb/usb.c $(bus/usb/usb.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh usb > $@ || (rm -f $@; exit 1)

fs-usb_mod-bus_usb_usb.lst: bus/usb/usb.c $(bus/usb/usb.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh usb > $@ || (rm -f $@; exit 1)

parttool-usb_mod-bus_usb_usb.lst: bus/usb/usb.c $(bus/usb/usb.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh usb > $@ || (rm -f $@; exit 1)

partmap-usb_mod-bus_usb_usb.lst: bus/usb/usb.c $(bus/usb/usb.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh usb > $@ || (rm -f $@; exit 1)

handler-usb_mod-bus_usb_usb.lst: bus/usb/usb.c $(bus/usb/usb.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh usb > $@ || (rm -f $@; exit 1)

usb_mod-bus_usb_usbtrans.o: bus/usb/usbtrans.c $(bus/usb/usbtrans.c_DEPENDENCIES)
	$(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -MD -c -o $@ $<
-include usb_mod-bus_usb_usbtrans.d

clean-module-usb_mod-bus_usb_usbtrans-extra.1:
	rm -f cmd-usb_mod-bus_usb_usbtrans.lst fs-usb_mod-bus_usb_usbtrans.lst partmap-usb_mod-bus_usb_usbtrans.lst handler-usb_mod-bus_usb_usbtrans.lst parttool-usb_mod-bus_usb_usbtrans.lst

CLEAN_MODULE_TARGETS += clean-module-usb_mod-bus_usb_usbtrans-extra.1

COMMANDFILES += cmd-usb_mod-bus_usb_usbtrans.lst
FSFILES += fs-usb_mod-bus_usb_usbtrans.lst
PARTTOOLFILES += parttool-usb_mod-bus_usb_usbtrans.lst
PARTMAPFILES += partmap-usb_mod-bus_usb_usbtrans.lst
HANDLERFILES += handler-usb_mod-bus_usb_usbtrans.lst

cmd-usb_mod-bus_usb_usbtrans.lst: bus/usb/usbtrans.c $(bus/usb/usbtrans.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh usb > $@ || (rm -f $@; exit 1)

fs-usb_mod-bus_usb_usbtrans.lst: bus/usb/usbtrans.c $(bus/usb/usbtrans.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh usb > $@ || (rm -f $@; exit 1)

parttool-usb_mod-bus_usb_usbtrans.lst: bus/usb/usbtrans.c $(bus/usb/usbtrans.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh usb > $@ || (rm -f $@; exit 1)

partmap-usb_mod-bus_usb_usbtrans.lst: bus/usb/usbtrans.c $(bus/usb/usbtrans.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh usb > $@ || (rm -f $@; exit 1)

handler-usb_mod-bus_usb_usbtrans.lst: bus/usb/usbtrans.c $(bus/usb/usbtrans.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh usb > $@ || (rm -f $@; exit 1)

usb_mod-bus_usb_usbhub.o: bus/usb/usbhub.c $(bus/usb/usbhub.c_DEPENDENCIES)
	$(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -MD -c -o $@ $<
-include usb_mod-bus_usb_usbhub.d

clean-module-usb_mod-bus_usb_usbhub-extra.1:
	rm -f cmd-usb_mod-bus_usb_usbhub.lst fs-usb_mod-bus_usb_usbhub.lst partmap-usb_mod-bus_usb_usbhub.lst handler-usb_mod-bus_usb_usbhub.lst parttool-usb_mod-bus_usb_usbhub.lst

CLEAN_MODULE_TARGETS += clean-module-usb_mod-bus_usb_usbhub-extra.1

COMMANDFILES += cmd-usb_mod-bus_usb_usbhub.lst
FSFILES += fs-usb_mod-bus_usb_usbhub.lst
PARTTOOLFILES += parttool-usb_mod-bus_usb_usbhub.lst
PARTMAPFILES += partmap-usb_mod-bus_usb_usbhub.lst
HANDLERFILES += handler-usb_mod-bus_usb_usbhub.lst

cmd-usb_mod-bus_usb_usbhub.lst: bus/usb/usbhub.c $(bus/usb/usbhub.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh usb > $@ || (rm -f $@; exit 1)

fs-usb_mod-bus_usb_usbhub.lst: bus/usb/usbhub.c $(bus/usb/usbhub.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh usb > $@ || (rm -f $@; exit 1)

parttool-usb_mod-bus_usb_usbhub.lst: bus/usb/usbhub.c $(bus/usb/usbhub.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh usb > $@ || (rm -f $@; exit 1)

partmap-usb_mod-bus_usb_usbhub.lst: bus/usb/usbhub.c $(bus/usb/usbhub.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh usb > $@ || (rm -f $@; exit 1)

handler-usb_mod-bus_usb_usbhub.lst: bus/usb/usbhub.c $(bus/usb/usbhub.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh usb > $@ || (rm -f $@; exit 1)

usb_mod_CFLAGS = $(COMMON_CFLAGS)
usb_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For usbtest.mod
usbtest_mod_SOURCES = commands/usbtest.c

clean-module-usbtest.mod.1:
	rm -f usbtest.mod mod-usbtest.o mod-usbtest.c pre-usbtest.o usbtest_mod-commands_usbtest.o und-usbtest.lst

CLEAN_MODULE_TARGETS += clean-module-usbtest.mod.1

ifneq ($(usbtest_mod_EXPORTS),no)
clean-module-usbtest.mod-symbol.1:
	rm -f def-usbtest.lst

CLEAN_MODULE_TARGETS += clean-module-usbtest.mod-symbol.1
DEFSYMFILES += def-usbtest.lst
endif
mostlyclean-module-usbtest.mod.1:
	rm -f usbtest_mod-commands_usbtest.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-usbtest.mod.1
UNDSYMFILES += und-usbtest.lst

ifneq ($(TARGET_APPLE_CC),1)
usbtest.mod: pre-usbtest.o mod-usbtest.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(usbtest_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-usbtest.o mod-usbtest.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
usbtest.mod: pre-usbtest.o mod-usbtest.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(usbtest_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-usbtest.o mod-usbtest.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-usbtest.o: $(usbtest_mod_DEPENDENCIES) usbtest_mod-commands_usbtest.o
	-rm -f $@
	$(TARGET_CC) $(usbtest_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ usbtest_mod-commands_usbtest.o

mod-usbtest.o: mod-usbtest.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(usbtest_mod_CFLAGS) -c -o $@ $<

mod-usbtest.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'usbtest' $< > $@ || (rm -f $@; exit 1)

ifneq ($(usbtest_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-usbtest.lst: pre-usbtest.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 usbtest/' > $@
else
def-usbtest.lst: pre-usbtest.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 usbtest/' > $@
endif
endif

und-usbtest.lst: pre-usbtest.o
	echo 'usbtest' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

usbtest_mod-commands_usbtest.o: commands/usbtest.c $(commands/usbtest.c_DEPENDENCIES)
	$(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usbtest_mod_CFLAGS) -MD -c -o $@ $<
-include usbtest_mod-commands_usbtest.d

clean-module-usbtest_mod-commands_usbtest-extra.1:
	rm -f cmd-usbtest_mod-commands_usbtest.lst fs-usbtest_mod-commands_usbtest.lst partmap-usbtest_mod-commands_usbtest.lst handler-usbtest_mod-commands_usbtest.lst parttool-usbtest_mod-commands_usbtest.lst

CLEAN_MODULE_TARGETS += clean-module-usbtest_mod-commands_usbtest-extra.1

COMMANDFILES += cmd-usbtest_mod-commands_usbtest.lst
FSFILES += fs-usbtest_mod-commands_usbtest.lst
PARTTOOLFILES += parttool-usbtest_mod-commands_usbtest.lst
PARTMAPFILES += partmap-usbtest_mod-commands_usbtest.lst
HANDLERFILES += handler-usbtest_mod-commands_usbtest.lst

cmd-usbtest_mod-commands_usbtest.lst: commands/usbtest.c $(commands/usbtest.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usbtest_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh usbtest > $@ || (rm -f $@; exit 1)

fs-usbtest_mod-commands_usbtest.lst: commands/usbtest.c $(commands/usbtest.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usbtest_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh usbtest > $@ || (rm -f $@; exit 1)

parttool-usbtest_mod-commands_usbtest.lst: commands/usbtest.c $(commands/usbtest.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usbtest_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh usbtest > $@ || (rm -f $@; exit 1)

partmap-usbtest_mod-commands_usbtest.lst: commands/usbtest.c $(commands/usbtest.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usbtest_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh usbtest > $@ || (rm -f $@; exit 1)

handler-usbtest_mod-commands_usbtest.lst: commands/usbtest.c $(commands/usbtest.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usbtest_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh usbtest > $@ || (rm -f $@; exit 1)

usbtest_mod_CFLAGS = $(COMMON_CFLAGS)
usbtest_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For uhci.mod
uhci_mod_SOURCES = bus/usb/uhci.c

clean-module-uhci.mod.1:
	rm -f uhci.mod mod-uhci.o mod-uhci.c pre-uhci.o uhci_mod-bus_usb_uhci.o und-uhci.lst

CLEAN_MODULE_TARGETS += clean-module-uhci.mod.1

ifneq ($(uhci_mod_EXPORTS),no)
clean-module-uhci.mod-symbol.1:
	rm -f def-uhci.lst

CLEAN_MODULE_TARGETS += clean-module-uhci.mod-symbol.1
DEFSYMFILES += def-uhci.lst
endif
mostlyclean-module-uhci.mod.1:
	rm -f uhci_mod-bus_usb_uhci.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-uhci.mod.1
UNDSYMFILES += und-uhci.lst

ifneq ($(TARGET_APPLE_CC),1)
uhci.mod: pre-uhci.o mod-uhci.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(uhci_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-uhci.o mod-uhci.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
uhci.mod: pre-uhci.o mod-uhci.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(uhci_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-uhci.o mod-uhci.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-uhci.o: $(uhci_mod_DEPENDENCIES) uhci_mod-bus_usb_uhci.o
	-rm -f $@
	$(TARGET_CC) $(uhci_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ uhci_mod-bus_usb_uhci.o

mod-uhci.o: mod-uhci.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(uhci_mod_CFLAGS) -c -o $@ $<

mod-uhci.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'uhci' $< > $@ || (rm -f $@; exit 1)

ifneq ($(uhci_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-uhci.lst: pre-uhci.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 uhci/' > $@
else
def-uhci.lst: pre-uhci.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 uhci/' > $@
endif
endif

und-uhci.lst: pre-uhci.o
	echo 'uhci' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

uhci_mod-bus_usb_uhci.o: bus/usb/uhci.c $(bus/usb/uhci.c_DEPENDENCIES)
	$(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(uhci_mod_CFLAGS) -MD -c -o $@ $<
-include uhci_mod-bus_usb_uhci.d

clean-module-uhci_mod-bus_usb_uhci-extra.1:
	rm -f cmd-uhci_mod-bus_usb_uhci.lst fs-uhci_mod-bus_usb_uhci.lst partmap-uhci_mod-bus_usb_uhci.lst handler-uhci_mod-bus_usb_uhci.lst parttool-uhci_mod-bus_usb_uhci.lst

CLEAN_MODULE_TARGETS += clean-module-uhci_mod-bus_usb_uhci-extra.1

COMMANDFILES += cmd-uhci_mod-bus_usb_uhci.lst
FSFILES += fs-uhci_mod-bus_usb_uhci.lst
PARTTOOLFILES += parttool-uhci_mod-bus_usb_uhci.lst
PARTMAPFILES += partmap-uhci_mod-bus_usb_uhci.lst
HANDLERFILES += handler-uhci_mod-bus_usb_uhci.lst

cmd-uhci_mod-bus_usb_uhci.lst: bus/usb/uhci.c $(bus/usb/uhci.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(uhci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh uhci > $@ || (rm -f $@; exit 1)

fs-uhci_mod-bus_usb_uhci.lst: bus/usb/uhci.c $(bus/usb/uhci.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(uhci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh uhci > $@ || (rm -f $@; exit 1)

parttool-uhci_mod-bus_usb_uhci.lst: bus/usb/uhci.c $(bus/usb/uhci.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(uhci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh uhci > $@ || (rm -f $@; exit 1)

partmap-uhci_mod-bus_usb_uhci.lst: bus/usb/uhci.c $(bus/usb/uhci.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(uhci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh uhci > $@ || (rm -f $@; exit 1)

handler-uhci_mod-bus_usb_uhci.lst: bus/usb/uhci.c $(bus/usb/uhci.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(uhci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh uhci > $@ || (rm -f $@; exit 1)

uhci_mod_CFLAGS = $(COMMON_CFLAGS)
uhci_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For ohci.mod
ohci_mod_SOURCES = bus/usb/ohci.c

clean-module-ohci.mod.1:
	rm -f ohci.mod mod-ohci.o mod-ohci.c pre-ohci.o ohci_mod-bus_usb_ohci.o und-ohci.lst

CLEAN_MODULE_TARGETS += clean-module-ohci.mod.1

ifneq ($(ohci_mod_EXPORTS),no)
clean-module-ohci.mod-symbol.1:
	rm -f def-ohci.lst

CLEAN_MODULE_TARGETS += clean-module-ohci.mod-symbol.1
DEFSYMFILES += def-ohci.lst
endif
mostlyclean-module-ohci.mod.1:
	rm -f ohci_mod-bus_usb_ohci.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-ohci.mod.1
UNDSYMFILES += und-ohci.lst

ifneq ($(TARGET_APPLE_CC),1)
ohci.mod: pre-ohci.o mod-ohci.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(ohci_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-ohci.o mod-ohci.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
ohci.mod: pre-ohci.o mod-ohci.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(ohci_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-ohci.o mod-ohci.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-ohci.o: $(ohci_mod_DEPENDENCIES) ohci_mod-bus_usb_ohci.o
	-rm -f $@
	$(TARGET_CC) $(ohci_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ ohci_mod-bus_usb_ohci.o

mod-ohci.o: mod-ohci.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(ohci_mod_CFLAGS) -c -o $@ $<

mod-ohci.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'ohci' $< > $@ || (rm -f $@; exit 1)

ifneq ($(ohci_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-ohci.lst: pre-ohci.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 ohci/' > $@
else
def-ohci.lst: pre-ohci.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 ohci/' > $@
endif
endif

und-ohci.lst: pre-ohci.o
	echo 'ohci' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

ohci_mod-bus_usb_ohci.o: bus/usb/ohci.c $(bus/usb/ohci.c_DEPENDENCIES)
	$(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ohci_mod_CFLAGS) -MD -c -o $@ $<
-include ohci_mod-bus_usb_ohci.d

clean-module-ohci_mod-bus_usb_ohci-extra.1:
	rm -f cmd-ohci_mod-bus_usb_ohci.lst fs-ohci_mod-bus_usb_ohci.lst partmap-ohci_mod-bus_usb_ohci.lst handler-ohci_mod-bus_usb_ohci.lst parttool-ohci_mod-bus_usb_ohci.lst

CLEAN_MODULE_TARGETS += clean-module-ohci_mod-bus_usb_ohci-extra.1

COMMANDFILES += cmd-ohci_mod-bus_usb_ohci.lst
FSFILES += fs-ohci_mod-bus_usb_ohci.lst
PARTTOOLFILES += parttool-ohci_mod-bus_usb_ohci.lst
PARTMAPFILES += partmap-ohci_mod-bus_usb_ohci.lst
HANDLERFILES += handler-ohci_mod-bus_usb_ohci.lst

cmd-ohci_mod-bus_usb_ohci.lst: bus/usb/ohci.c $(bus/usb/ohci.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ohci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh ohci > $@ || (rm -f $@; exit 1)

fs-ohci_mod-bus_usb_ohci.lst: bus/usb/ohci.c $(bus/usb/ohci.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ohci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh ohci > $@ || (rm -f $@; exit 1)

parttool-ohci_mod-bus_usb_ohci.lst: bus/usb/ohci.c $(bus/usb/ohci.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ohci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh ohci > $@ || (rm -f $@; exit 1)

partmap-ohci_mod-bus_usb_ohci.lst: bus/usb/ohci.c $(bus/usb/ohci.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ohci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh ohci > $@ || (rm -f $@; exit 1)

handler-ohci_mod-bus_usb_ohci.lst: bus/usb/ohci.c $(bus/usb/ohci.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Ibus/usb -I$(srcdir)/bus/usb $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ohci_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh ohci > $@ || (rm -f $@; exit 1)

ohci_mod_CFLAGS = $(COMMON_CFLAGS)
ohci_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For usbms.mod
usbms_mod_SOURCES = disk/usbms.c

clean-module-usbms.mod.1:
	rm -f usbms.mod mod-usbms.o mod-usbms.c pre-usbms.o usbms_mod-disk_usbms.o und-usbms.lst

CLEAN_MODULE_TARGETS += clean-module-usbms.mod.1

ifneq ($(usbms_mod_EXPORTS),no)
clean-module-usbms.mod-symbol.1:
	rm -f def-usbms.lst

CLEAN_MODULE_TARGETS += clean-module-usbms.mod-symbol.1
DEFSYMFILES += def-usbms.lst
endif
mostlyclean-module-usbms.mod.1:
	rm -f usbms_mod-disk_usbms.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-usbms.mod.1
UNDSYMFILES += und-usbms.lst

ifneq ($(TARGET_APPLE_CC),1)
usbms.mod: pre-usbms.o mod-usbms.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(usbms_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-usbms.o mod-usbms.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
usbms.mod: pre-usbms.o mod-usbms.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(usbms_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-usbms.o mod-usbms.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-usbms.o: $(usbms_mod_DEPENDENCIES) usbms_mod-disk_usbms.o
	-rm -f $@
	$(TARGET_CC) $(usbms_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ usbms_mod-disk_usbms.o

mod-usbms.o: mod-usbms.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(usbms_mod_CFLAGS) -c -o $@ $<

mod-usbms.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'usbms' $< > $@ || (rm -f $@; exit 1)

ifneq ($(usbms_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-usbms.lst: pre-usbms.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 usbms/' > $@
else
def-usbms.lst: pre-usbms.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 usbms/' > $@
endif
endif

und-usbms.lst: pre-usbms.o
	echo 'usbms' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

usbms_mod-disk_usbms.o: disk/usbms.c $(disk/usbms.c_DEPENDENCIES)
	$(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usbms_mod_CFLAGS) -MD -c -o $@ $<
-include usbms_mod-disk_usbms.d

clean-module-usbms_mod-disk_usbms-extra.1:
	rm -f cmd-usbms_mod-disk_usbms.lst fs-usbms_mod-disk_usbms.lst partmap-usbms_mod-disk_usbms.lst handler-usbms_mod-disk_usbms.lst parttool-usbms_mod-disk_usbms.lst

CLEAN_MODULE_TARGETS += clean-module-usbms_mod-disk_usbms-extra.1

COMMANDFILES += cmd-usbms_mod-disk_usbms.lst
FSFILES += fs-usbms_mod-disk_usbms.lst
PARTTOOLFILES += parttool-usbms_mod-disk_usbms.lst
PARTMAPFILES += partmap-usbms_mod-disk_usbms.lst
HANDLERFILES += handler-usbms_mod-disk_usbms.lst

cmd-usbms_mod-disk_usbms.lst: disk/usbms.c $(disk/usbms.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usbms_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh usbms > $@ || (rm -f $@; exit 1)

fs-usbms_mod-disk_usbms.lst: disk/usbms.c $(disk/usbms.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usbms_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh usbms > $@ || (rm -f $@; exit 1)

parttool-usbms_mod-disk_usbms.lst: disk/usbms.c $(disk/usbms.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usbms_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh usbms > $@ || (rm -f $@; exit 1)

partmap-usbms_mod-disk_usbms.lst: disk/usbms.c $(disk/usbms.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usbms_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh usbms > $@ || (rm -f $@; exit 1)

handler-usbms_mod-disk_usbms.lst: disk/usbms.c $(disk/usbms.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usbms_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh usbms > $@ || (rm -f $@; exit 1)

usbms_mod_CFLAGS = $(COMMON_CFLAGS)
usbms_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For usb_keyboard.mod
usb_keyboard_mod_SOURCES = term/usb_keyboard.c

clean-module-usb_keyboard.mod.1:
	rm -f usb_keyboard.mod mod-usb_keyboard.o mod-usb_keyboard.c pre-usb_keyboard.o usb_keyboard_mod-term_usb_keyboard.o und-usb_keyboard.lst

CLEAN_MODULE_TARGETS += clean-module-usb_keyboard.mod.1

ifneq ($(usb_keyboard_mod_EXPORTS),no)
clean-module-usb_keyboard.mod-symbol.1:
	rm -f def-usb_keyboard.lst

CLEAN_MODULE_TARGETS += clean-module-usb_keyboard.mod-symbol.1
DEFSYMFILES += def-usb_keyboard.lst
endif
mostlyclean-module-usb_keyboard.mod.1:
	rm -f usb_keyboard_mod-term_usb_keyboard.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-usb_keyboard.mod.1
UNDSYMFILES += und-usb_keyboard.lst

ifneq ($(TARGET_APPLE_CC),1)
usb_keyboard.mod: pre-usb_keyboard.o mod-usb_keyboard.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(usb_keyboard_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-usb_keyboard.o mod-usb_keyboard.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
usb_keyboard.mod: pre-usb_keyboard.o mod-usb_keyboard.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(usb_keyboard_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-usb_keyboard.o mod-usb_keyboard.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-usb_keyboard.o: $(usb_keyboard_mod_DEPENDENCIES) usb_keyboard_mod-term_usb_keyboard.o
	-rm -f $@
	$(TARGET_CC) $(usb_keyboard_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ usb_keyboard_mod-term_usb_keyboard.o

mod-usb_keyboard.o: mod-usb_keyboard.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(usb_keyboard_mod_CFLAGS) -c -o $@ $<

mod-usb_keyboard.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'usb_keyboard' $< > $@ || (rm -f $@; exit 1)

ifneq ($(usb_keyboard_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-usb_keyboard.lst: pre-usb_keyboard.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 usb_keyboard/' > $@
else
def-usb_keyboard.lst: pre-usb_keyboard.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 usb_keyboard/' > $@
endif
endif

und-usb_keyboard.lst: pre-usb_keyboard.o
	echo 'usb_keyboard' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

usb_keyboard_mod-term_usb_keyboard.o: term/usb_keyboard.c $(term/usb_keyboard.c_DEPENDENCIES)
	$(TARGET_CC) -Iterm -I$(srcdir)/term $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_keyboard_mod_CFLAGS) -MD -c -o $@ $<
-include usb_keyboard_mod-term_usb_keyboard.d

clean-module-usb_keyboard_mod-term_usb_keyboard-extra.1:
	rm -f cmd-usb_keyboard_mod-term_usb_keyboard.lst fs-usb_keyboard_mod-term_usb_keyboard.lst partmap-usb_keyboard_mod-term_usb_keyboard.lst handler-usb_keyboard_mod-term_usb_keyboard.lst parttool-usb_keyboard_mod-term_usb_keyboard.lst

CLEAN_MODULE_TARGETS += clean-module-usb_keyboard_mod-term_usb_keyboard-extra.1

COMMANDFILES += cmd-usb_keyboard_mod-term_usb_keyboard.lst
FSFILES += fs-usb_keyboard_mod-term_usb_keyboard.lst
PARTTOOLFILES += parttool-usb_keyboard_mod-term_usb_keyboard.lst
PARTMAPFILES += partmap-usb_keyboard_mod-term_usb_keyboard.lst
HANDLERFILES += handler-usb_keyboard_mod-term_usb_keyboard.lst

cmd-usb_keyboard_mod-term_usb_keyboard.lst: term/usb_keyboard.c $(term/usb_keyboard.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iterm -I$(srcdir)/term $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_keyboard_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh usb_keyboard > $@ || (rm -f $@; exit 1)

fs-usb_keyboard_mod-term_usb_keyboard.lst: term/usb_keyboard.c $(term/usb_keyboard.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iterm -I$(srcdir)/term $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_keyboard_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh usb_keyboard > $@ || (rm -f $@; exit 1)

parttool-usb_keyboard_mod-term_usb_keyboard.lst: term/usb_keyboard.c $(term/usb_keyboard.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iterm -I$(srcdir)/term $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_keyboard_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh usb_keyboard > $@ || (rm -f $@; exit 1)

partmap-usb_keyboard_mod-term_usb_keyboard.lst: term/usb_keyboard.c $(term/usb_keyboard.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iterm -I$(srcdir)/term $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_keyboard_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh usb_keyboard > $@ || (rm -f $@; exit 1)

handler-usb_keyboard_mod-term_usb_keyboard.lst: term/usb_keyboard.c $(term/usb_keyboard.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iterm -I$(srcdir)/term $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(usb_keyboard_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh usb_keyboard > $@ || (rm -f $@; exit 1)

usb_keyboard_mod_CFLAGS = $(COMMON_CFLAGS)
usb_keyboard_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For pxe.mod
pxe_mod_SOURCES = fs/i386/pc/pxe.c

clean-module-pxe.mod.1:
	rm -f pxe.mod mod-pxe.o mod-pxe.c pre-pxe.o pxe_mod-fs_i386_pc_pxe.o und-pxe.lst

CLEAN_MODULE_TARGETS += clean-module-pxe.mod.1

ifneq ($(pxe_mod_EXPORTS),no)
clean-module-pxe.mod-symbol.1:
	rm -f def-pxe.lst

CLEAN_MODULE_TARGETS += clean-module-pxe.mod-symbol.1
DEFSYMFILES += def-pxe.lst
endif
mostlyclean-module-pxe.mod.1:
	rm -f pxe_mod-fs_i386_pc_pxe.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-pxe.mod.1
UNDSYMFILES += und-pxe.lst

ifneq ($(TARGET_APPLE_CC),1)
pxe.mod: pre-pxe.o mod-pxe.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(pxe_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-pxe.o mod-pxe.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
pxe.mod: pre-pxe.o mod-pxe.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(pxe_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-pxe.o mod-pxe.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-pxe.o: $(pxe_mod_DEPENDENCIES) pxe_mod-fs_i386_pc_pxe.o
	-rm -f $@
	$(TARGET_CC) $(pxe_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pxe_mod-fs_i386_pc_pxe.o

mod-pxe.o: mod-pxe.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(pxe_mod_CFLAGS) -c -o $@ $<

mod-pxe.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'pxe' $< > $@ || (rm -f $@; exit 1)

ifneq ($(pxe_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-pxe.lst: pre-pxe.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 pxe/' > $@
else
def-pxe.lst: pre-pxe.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 pxe/' > $@
endif
endif

und-pxe.lst: pre-pxe.o
	echo 'pxe' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

pxe_mod-fs_i386_pc_pxe.o: fs/i386/pc/pxe.c $(fs/i386/pc/pxe.c_DEPENDENCIES)
	$(TARGET_CC) -Ifs/i386/pc -I$(srcdir)/fs/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pxe_mod_CFLAGS) -MD -c -o $@ $<
-include pxe_mod-fs_i386_pc_pxe.d

clean-module-pxe_mod-fs_i386_pc_pxe-extra.1:
	rm -f cmd-pxe_mod-fs_i386_pc_pxe.lst fs-pxe_mod-fs_i386_pc_pxe.lst partmap-pxe_mod-fs_i386_pc_pxe.lst handler-pxe_mod-fs_i386_pc_pxe.lst parttool-pxe_mod-fs_i386_pc_pxe.lst

CLEAN_MODULE_TARGETS += clean-module-pxe_mod-fs_i386_pc_pxe-extra.1

COMMANDFILES += cmd-pxe_mod-fs_i386_pc_pxe.lst
FSFILES += fs-pxe_mod-fs_i386_pc_pxe.lst
PARTTOOLFILES += parttool-pxe_mod-fs_i386_pc_pxe.lst
PARTMAPFILES += partmap-pxe_mod-fs_i386_pc_pxe.lst
HANDLERFILES += handler-pxe_mod-fs_i386_pc_pxe.lst

cmd-pxe_mod-fs_i386_pc_pxe.lst: fs/i386/pc/pxe.c $(fs/i386/pc/pxe.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Ifs/i386/pc -I$(srcdir)/fs/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pxe_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh pxe > $@ || (rm -f $@; exit 1)

fs-pxe_mod-fs_i386_pc_pxe.lst: fs/i386/pc/pxe.c $(fs/i386/pc/pxe.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Ifs/i386/pc -I$(srcdir)/fs/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pxe_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh pxe > $@ || (rm -f $@; exit 1)

parttool-pxe_mod-fs_i386_pc_pxe.lst: fs/i386/pc/pxe.c $(fs/i386/pc/pxe.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Ifs/i386/pc -I$(srcdir)/fs/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pxe_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh pxe > $@ || (rm -f $@; exit 1)

partmap-pxe_mod-fs_i386_pc_pxe.lst: fs/i386/pc/pxe.c $(fs/i386/pc/pxe.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Ifs/i386/pc -I$(srcdir)/fs/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pxe_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh pxe > $@ || (rm -f $@; exit 1)

handler-pxe_mod-fs_i386_pc_pxe.lst: fs/i386/pc/pxe.c $(fs/i386/pc/pxe.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Ifs/i386/pc -I$(srcdir)/fs/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pxe_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh pxe > $@ || (rm -f $@; exit 1)

pxe_mod_CFLAGS = $(COMMON_CFLAGS)
pxe_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For pxecmd.mod
pxecmd_mod_SOURCES = commands/i386/pc/pxecmd.c

clean-module-pxecmd.mod.1:
	rm -f pxecmd.mod mod-pxecmd.o mod-pxecmd.c pre-pxecmd.o pxecmd_mod-commands_i386_pc_pxecmd.o und-pxecmd.lst

CLEAN_MODULE_TARGETS += clean-module-pxecmd.mod.1

ifneq ($(pxecmd_mod_EXPORTS),no)
clean-module-pxecmd.mod-symbol.1:
	rm -f def-pxecmd.lst

CLEAN_MODULE_TARGETS += clean-module-pxecmd.mod-symbol.1
DEFSYMFILES += def-pxecmd.lst
endif
mostlyclean-module-pxecmd.mod.1:
	rm -f pxecmd_mod-commands_i386_pc_pxecmd.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-pxecmd.mod.1
UNDSYMFILES += und-pxecmd.lst

ifneq ($(TARGET_APPLE_CC),1)
pxecmd.mod: pre-pxecmd.o mod-pxecmd.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(pxecmd_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-pxecmd.o mod-pxecmd.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
pxecmd.mod: pre-pxecmd.o mod-pxecmd.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(pxecmd_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-pxecmd.o mod-pxecmd.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-pxecmd.o: $(pxecmd_mod_DEPENDENCIES) pxecmd_mod-commands_i386_pc_pxecmd.o
	-rm -f $@
	$(TARGET_CC) $(pxecmd_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pxecmd_mod-commands_i386_pc_pxecmd.o

mod-pxecmd.o: mod-pxecmd.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(pxecmd_mod_CFLAGS) -c -o $@ $<

mod-pxecmd.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'pxecmd' $< > $@ || (rm -f $@; exit 1)

ifneq ($(pxecmd_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-pxecmd.lst: pre-pxecmd.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 pxecmd/' > $@
else
def-pxecmd.lst: pre-pxecmd.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 pxecmd/' > $@
endif
endif

und-pxecmd.lst: pre-pxecmd.o
	echo 'pxecmd' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

pxecmd_mod-commands_i386_pc_pxecmd.o: commands/i386/pc/pxecmd.c $(commands/i386/pc/pxecmd.c_DEPENDENCIES)
	$(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pxecmd_mod_CFLAGS) -MD -c -o $@ $<
-include pxecmd_mod-commands_i386_pc_pxecmd.d

clean-module-pxecmd_mod-commands_i386_pc_pxecmd-extra.1:
	rm -f cmd-pxecmd_mod-commands_i386_pc_pxecmd.lst fs-pxecmd_mod-commands_i386_pc_pxecmd.lst partmap-pxecmd_mod-commands_i386_pc_pxecmd.lst handler-pxecmd_mod-commands_i386_pc_pxecmd.lst parttool-pxecmd_mod-commands_i386_pc_pxecmd.lst

CLEAN_MODULE_TARGETS += clean-module-pxecmd_mod-commands_i386_pc_pxecmd-extra.1

COMMANDFILES += cmd-pxecmd_mod-commands_i386_pc_pxecmd.lst
FSFILES += fs-pxecmd_mod-commands_i386_pc_pxecmd.lst
PARTTOOLFILES += parttool-pxecmd_mod-commands_i386_pc_pxecmd.lst
PARTMAPFILES += partmap-pxecmd_mod-commands_i386_pc_pxecmd.lst
HANDLERFILES += handler-pxecmd_mod-commands_i386_pc_pxecmd.lst

cmd-pxecmd_mod-commands_i386_pc_pxecmd.lst: commands/i386/pc/pxecmd.c $(commands/i386/pc/pxecmd.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pxecmd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh pxecmd > $@ || (rm -f $@; exit 1)

fs-pxecmd_mod-commands_i386_pc_pxecmd.lst: commands/i386/pc/pxecmd.c $(commands/i386/pc/pxecmd.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pxecmd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh pxecmd > $@ || (rm -f $@; exit 1)

parttool-pxecmd_mod-commands_i386_pc_pxecmd.lst: commands/i386/pc/pxecmd.c $(commands/i386/pc/pxecmd.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pxecmd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh pxecmd > $@ || (rm -f $@; exit 1)

partmap-pxecmd_mod-commands_i386_pc_pxecmd.lst: commands/i386/pc/pxecmd.c $(commands/i386/pc/pxecmd.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pxecmd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh pxecmd > $@ || (rm -f $@; exit 1)

handler-pxecmd_mod-commands_i386_pc_pxecmd.lst: commands/i386/pc/pxecmd.c $(commands/i386/pc/pxecmd.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands/i386/pc -I$(srcdir)/commands/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(pxecmd_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh pxecmd > $@ || (rm -f $@; exit 1)

pxecmd_mod_CFLAGS = $(COMMON_CFLAGS)
pxecmd_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For datetime.mod
datetime_mod_SOURCES = lib/i386/datetime.c

clean-module-datetime.mod.1:
	rm -f datetime.mod mod-datetime.o mod-datetime.c pre-datetime.o datetime_mod-lib_i386_datetime.o und-datetime.lst

CLEAN_MODULE_TARGETS += clean-module-datetime.mod.1

ifneq ($(datetime_mod_EXPORTS),no)
clean-module-datetime.mod-symbol.1:
	rm -f def-datetime.lst

CLEAN_MODULE_TARGETS += clean-module-datetime.mod-symbol.1
DEFSYMFILES += def-datetime.lst
endif
mostlyclean-module-datetime.mod.1:
	rm -f datetime_mod-lib_i386_datetime.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-datetime.mod.1
UNDSYMFILES += und-datetime.lst

ifneq ($(TARGET_APPLE_CC),1)
datetime.mod: pre-datetime.o mod-datetime.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(datetime_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-datetime.o mod-datetime.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
datetime.mod: pre-datetime.o mod-datetime.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(datetime_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-datetime.o mod-datetime.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-datetime.o: $(datetime_mod_DEPENDENCIES) datetime_mod-lib_i386_datetime.o
	-rm -f $@
	$(TARGET_CC) $(datetime_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ datetime_mod-lib_i386_datetime.o

mod-datetime.o: mod-datetime.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(datetime_mod_CFLAGS) -c -o $@ $<

mod-datetime.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'datetime' $< > $@ || (rm -f $@; exit 1)

ifneq ($(datetime_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-datetime.lst: pre-datetime.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 datetime/' > $@
else
def-datetime.lst: pre-datetime.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 datetime/' > $@
endif
endif

und-datetime.lst: pre-datetime.o
	echo 'datetime' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

datetime_mod-lib_i386_datetime.o: lib/i386/datetime.c $(lib/i386/datetime.c_DEPENDENCIES)
	$(TARGET_CC) -Ilib/i386 -I$(srcdir)/lib/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(datetime_mod_CFLAGS) -MD -c -o $@ $<
-include datetime_mod-lib_i386_datetime.d

clean-module-datetime_mod-lib_i386_datetime-extra.1:
	rm -f cmd-datetime_mod-lib_i386_datetime.lst fs-datetime_mod-lib_i386_datetime.lst partmap-datetime_mod-lib_i386_datetime.lst handler-datetime_mod-lib_i386_datetime.lst parttool-datetime_mod-lib_i386_datetime.lst

CLEAN_MODULE_TARGETS += clean-module-datetime_mod-lib_i386_datetime-extra.1

COMMANDFILES += cmd-datetime_mod-lib_i386_datetime.lst
FSFILES += fs-datetime_mod-lib_i386_datetime.lst
PARTTOOLFILES += parttool-datetime_mod-lib_i386_datetime.lst
PARTMAPFILES += partmap-datetime_mod-lib_i386_datetime.lst
HANDLERFILES += handler-datetime_mod-lib_i386_datetime.lst

cmd-datetime_mod-lib_i386_datetime.lst: lib/i386/datetime.c $(lib/i386/datetime.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Ilib/i386 -I$(srcdir)/lib/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(datetime_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh datetime > $@ || (rm -f $@; exit 1)

fs-datetime_mod-lib_i386_datetime.lst: lib/i386/datetime.c $(lib/i386/datetime.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Ilib/i386 -I$(srcdir)/lib/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(datetime_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh datetime > $@ || (rm -f $@; exit 1)

parttool-datetime_mod-lib_i386_datetime.lst: lib/i386/datetime.c $(lib/i386/datetime.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Ilib/i386 -I$(srcdir)/lib/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(datetime_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh datetime > $@ || (rm -f $@; exit 1)

partmap-datetime_mod-lib_i386_datetime.lst: lib/i386/datetime.c $(lib/i386/datetime.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Ilib/i386 -I$(srcdir)/lib/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(datetime_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh datetime > $@ || (rm -f $@; exit 1)

handler-datetime_mod-lib_i386_datetime.lst: lib/i386/datetime.c $(lib/i386/datetime.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Ilib/i386 -I$(srcdir)/lib/i386 $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(datetime_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh datetime > $@ || (rm -f $@; exit 1)

datetime_mod_CFLAGS = $(COMMON_CFLAGS)
datetime_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For date.mod
date_mod_SOURCES = commands/date.c

clean-module-date.mod.1:
	rm -f date.mod mod-date.o mod-date.c pre-date.o date_mod-commands_date.o und-date.lst

CLEAN_MODULE_TARGETS += clean-module-date.mod.1

ifneq ($(date_mod_EXPORTS),no)
clean-module-date.mod-symbol.1:
	rm -f def-date.lst

CLEAN_MODULE_TARGETS += clean-module-date.mod-symbol.1
DEFSYMFILES += def-date.lst
endif
mostlyclean-module-date.mod.1:
	rm -f date_mod-commands_date.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-date.mod.1
UNDSYMFILES += und-date.lst

ifneq ($(TARGET_APPLE_CC),1)
date.mod: pre-date.o mod-date.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(date_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-date.o mod-date.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
date.mod: pre-date.o mod-date.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(date_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-date.o mod-date.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-date.o: $(date_mod_DEPENDENCIES) date_mod-commands_date.o
	-rm -f $@
	$(TARGET_CC) $(date_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ date_mod-commands_date.o

mod-date.o: mod-date.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(date_mod_CFLAGS) -c -o $@ $<

mod-date.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'date' $< > $@ || (rm -f $@; exit 1)

ifneq ($(date_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-date.lst: pre-date.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 date/' > $@
else
def-date.lst: pre-date.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 date/' > $@
endif
endif

und-date.lst: pre-date.o
	echo 'date' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

date_mod-commands_date.o: commands/date.c $(commands/date.c_DEPENDENCIES)
	$(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(date_mod_CFLAGS) -MD -c -o $@ $<
-include date_mod-commands_date.d

clean-module-date_mod-commands_date-extra.1:
	rm -f cmd-date_mod-commands_date.lst fs-date_mod-commands_date.lst partmap-date_mod-commands_date.lst handler-date_mod-commands_date.lst parttool-date_mod-commands_date.lst

CLEAN_MODULE_TARGETS += clean-module-date_mod-commands_date-extra.1

COMMANDFILES += cmd-date_mod-commands_date.lst
FSFILES += fs-date_mod-commands_date.lst
PARTTOOLFILES += parttool-date_mod-commands_date.lst
PARTMAPFILES += partmap-date_mod-commands_date.lst
HANDLERFILES += handler-date_mod-commands_date.lst

cmd-date_mod-commands_date.lst: commands/date.c $(commands/date.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(date_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh date > $@ || (rm -f $@; exit 1)

fs-date_mod-commands_date.lst: commands/date.c $(commands/date.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(date_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh date > $@ || (rm -f $@; exit 1)

parttool-date_mod-commands_date.lst: commands/date.c $(commands/date.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(date_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh date > $@ || (rm -f $@; exit 1)

partmap-date_mod-commands_date.lst: commands/date.c $(commands/date.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(date_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh date > $@ || (rm -f $@; exit 1)

handler-date_mod-commands_date.lst: commands/date.c $(commands/date.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(date_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh date > $@ || (rm -f $@; exit 1)

date_mod_CFLAGS = $(COMMON_CFLAGS)
date_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For datehook.mod
datehook_mod_SOURCES = hook/datehook.c

clean-module-datehook.mod.1:
	rm -f datehook.mod mod-datehook.o mod-datehook.c pre-datehook.o datehook_mod-hook_datehook.o und-datehook.lst

CLEAN_MODULE_TARGETS += clean-module-datehook.mod.1

ifneq ($(datehook_mod_EXPORTS),no)
clean-module-datehook.mod-symbol.1:
	rm -f def-datehook.lst

CLEAN_MODULE_TARGETS += clean-module-datehook.mod-symbol.1
DEFSYMFILES += def-datehook.lst
endif
mostlyclean-module-datehook.mod.1:
	rm -f datehook_mod-hook_datehook.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-datehook.mod.1
UNDSYMFILES += und-datehook.lst

ifneq ($(TARGET_APPLE_CC),1)
datehook.mod: pre-datehook.o mod-datehook.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(datehook_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-datehook.o mod-datehook.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
datehook.mod: pre-datehook.o mod-datehook.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(datehook_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-datehook.o mod-datehook.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-datehook.o: $(datehook_mod_DEPENDENCIES) datehook_mod-hook_datehook.o
	-rm -f $@
	$(TARGET_CC) $(datehook_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ datehook_mod-hook_datehook.o

mod-datehook.o: mod-datehook.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(datehook_mod_CFLAGS) -c -o $@ $<

mod-datehook.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'datehook' $< > $@ || (rm -f $@; exit 1)

ifneq ($(datehook_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-datehook.lst: pre-datehook.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 datehook/' > $@
else
def-datehook.lst: pre-datehook.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 datehook/' > $@
endif
endif

und-datehook.lst: pre-datehook.o
	echo 'datehook' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

datehook_mod-hook_datehook.o: hook/datehook.c $(hook/datehook.c_DEPENDENCIES)
	$(TARGET_CC) -Ihook -I$(srcdir)/hook $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(datehook_mod_CFLAGS) -MD -c -o $@ $<
-include datehook_mod-hook_datehook.d

clean-module-datehook_mod-hook_datehook-extra.1:
	rm -f cmd-datehook_mod-hook_datehook.lst fs-datehook_mod-hook_datehook.lst partmap-datehook_mod-hook_datehook.lst handler-datehook_mod-hook_datehook.lst parttool-datehook_mod-hook_datehook.lst

CLEAN_MODULE_TARGETS += clean-module-datehook_mod-hook_datehook-extra.1

COMMANDFILES += cmd-datehook_mod-hook_datehook.lst
FSFILES += fs-datehook_mod-hook_datehook.lst
PARTTOOLFILES += parttool-datehook_mod-hook_datehook.lst
PARTMAPFILES += partmap-datehook_mod-hook_datehook.lst
HANDLERFILES += handler-datehook_mod-hook_datehook.lst

cmd-datehook_mod-hook_datehook.lst: hook/datehook.c $(hook/datehook.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Ihook -I$(srcdir)/hook $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(datehook_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh datehook > $@ || (rm -f $@; exit 1)

fs-datehook_mod-hook_datehook.lst: hook/datehook.c $(hook/datehook.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Ihook -I$(srcdir)/hook $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(datehook_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh datehook > $@ || (rm -f $@; exit 1)

parttool-datehook_mod-hook_datehook.lst: hook/datehook.c $(hook/datehook.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Ihook -I$(srcdir)/hook $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(datehook_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh datehook > $@ || (rm -f $@; exit 1)

partmap-datehook_mod-hook_datehook.lst: hook/datehook.c $(hook/datehook.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Ihook -I$(srcdir)/hook $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(datehook_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh datehook > $@ || (rm -f $@; exit 1)

handler-datehook_mod-hook_datehook.lst: hook/datehook.c $(hook/datehook.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Ihook -I$(srcdir)/hook $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(datehook_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh datehook > $@ || (rm -f $@; exit 1)

datehook_mod_CFLAGS = $(COMMON_CFLAGS)
datehook_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For lsmmap.mod
lsmmap_mod_SOURCES = commands/lsmmap.c

clean-module-lsmmap.mod.1:
	rm -f lsmmap.mod mod-lsmmap.o mod-lsmmap.c pre-lsmmap.o lsmmap_mod-commands_lsmmap.o und-lsmmap.lst

CLEAN_MODULE_TARGETS += clean-module-lsmmap.mod.1

ifneq ($(lsmmap_mod_EXPORTS),no)
clean-module-lsmmap.mod-symbol.1:
	rm -f def-lsmmap.lst

CLEAN_MODULE_TARGETS += clean-module-lsmmap.mod-symbol.1
DEFSYMFILES += def-lsmmap.lst
endif
mostlyclean-module-lsmmap.mod.1:
	rm -f lsmmap_mod-commands_lsmmap.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-lsmmap.mod.1
UNDSYMFILES += und-lsmmap.lst

ifneq ($(TARGET_APPLE_CC),1)
lsmmap.mod: pre-lsmmap.o mod-lsmmap.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(lsmmap_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-lsmmap.o mod-lsmmap.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
lsmmap.mod: pre-lsmmap.o mod-lsmmap.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(lsmmap_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-lsmmap.o mod-lsmmap.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-lsmmap.o: $(lsmmap_mod_DEPENDENCIES) lsmmap_mod-commands_lsmmap.o
	-rm -f $@
	$(TARGET_CC) $(lsmmap_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ lsmmap_mod-commands_lsmmap.o

mod-lsmmap.o: mod-lsmmap.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(lsmmap_mod_CFLAGS) -c -o $@ $<

mod-lsmmap.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'lsmmap' $< > $@ || (rm -f $@; exit 1)

ifneq ($(lsmmap_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-lsmmap.lst: pre-lsmmap.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 lsmmap/' > $@
else
def-lsmmap.lst: pre-lsmmap.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 lsmmap/' > $@
endif
endif

und-lsmmap.lst: pre-lsmmap.o
	echo 'lsmmap' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

lsmmap_mod-commands_lsmmap.o: commands/lsmmap.c $(commands/lsmmap.c_DEPENDENCIES)
	$(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lsmmap_mod_CFLAGS) -MD -c -o $@ $<
-include lsmmap_mod-commands_lsmmap.d

clean-module-lsmmap_mod-commands_lsmmap-extra.1:
	rm -f cmd-lsmmap_mod-commands_lsmmap.lst fs-lsmmap_mod-commands_lsmmap.lst partmap-lsmmap_mod-commands_lsmmap.lst handler-lsmmap_mod-commands_lsmmap.lst parttool-lsmmap_mod-commands_lsmmap.lst

CLEAN_MODULE_TARGETS += clean-module-lsmmap_mod-commands_lsmmap-extra.1

COMMANDFILES += cmd-lsmmap_mod-commands_lsmmap.lst
FSFILES += fs-lsmmap_mod-commands_lsmmap.lst
PARTTOOLFILES += parttool-lsmmap_mod-commands_lsmmap.lst
PARTMAPFILES += partmap-lsmmap_mod-commands_lsmmap.lst
HANDLERFILES += handler-lsmmap_mod-commands_lsmmap.lst

cmd-lsmmap_mod-commands_lsmmap.lst: commands/lsmmap.c $(commands/lsmmap.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lsmmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh lsmmap > $@ || (rm -f $@; exit 1)

fs-lsmmap_mod-commands_lsmmap.lst: commands/lsmmap.c $(commands/lsmmap.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lsmmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh lsmmap > $@ || (rm -f $@; exit 1)

parttool-lsmmap_mod-commands_lsmmap.lst: commands/lsmmap.c $(commands/lsmmap.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lsmmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh lsmmap > $@ || (rm -f $@; exit 1)

partmap-lsmmap_mod-commands_lsmmap.lst: commands/lsmmap.c $(commands/lsmmap.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lsmmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh lsmmap > $@ || (rm -f $@; exit 1)

handler-lsmmap_mod-commands_lsmmap.lst: commands/lsmmap.c $(commands/lsmmap.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lsmmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh lsmmap > $@ || (rm -f $@; exit 1)

lsmmap_mod_CFLAGS = $(COMMON_CFLAGS)
lsmmap_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For ata_pthru.mod.
ata_pthru_mod_SOURCES = disk/ata_pthru.c

clean-module-ata_pthru.mod.1:
	rm -f ata_pthru.mod mod-ata_pthru.o mod-ata_pthru.c pre-ata_pthru.o ata_pthru_mod-disk_ata_pthru.o und-ata_pthru.lst

CLEAN_MODULE_TARGETS += clean-module-ata_pthru.mod.1

ifneq ($(ata_pthru_mod_EXPORTS),no)
clean-module-ata_pthru.mod-symbol.1:
	rm -f def-ata_pthru.lst

CLEAN_MODULE_TARGETS += clean-module-ata_pthru.mod-symbol.1
DEFSYMFILES += def-ata_pthru.lst
endif
mostlyclean-module-ata_pthru.mod.1:
	rm -f ata_pthru_mod-disk_ata_pthru.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-ata_pthru.mod.1
UNDSYMFILES += und-ata_pthru.lst

ifneq ($(TARGET_APPLE_CC),1)
ata_pthru.mod: pre-ata_pthru.o mod-ata_pthru.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(ata_pthru_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-ata_pthru.o mod-ata_pthru.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
ata_pthru.mod: pre-ata_pthru.o mod-ata_pthru.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(ata_pthru_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-ata_pthru.o mod-ata_pthru.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-ata_pthru.o: $(ata_pthru_mod_DEPENDENCIES) ata_pthru_mod-disk_ata_pthru.o
	-rm -f $@
	$(TARGET_CC) $(ata_pthru_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ ata_pthru_mod-disk_ata_pthru.o

mod-ata_pthru.o: mod-ata_pthru.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(ata_pthru_mod_CFLAGS) -c -o $@ $<

mod-ata_pthru.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'ata_pthru' $< > $@ || (rm -f $@; exit 1)

ifneq ($(ata_pthru_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-ata_pthru.lst: pre-ata_pthru.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 ata_pthru/' > $@
else
def-ata_pthru.lst: pre-ata_pthru.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 ata_pthru/' > $@
endif
endif

und-ata_pthru.lst: pre-ata_pthru.o
	echo 'ata_pthru' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

ata_pthru_mod-disk_ata_pthru.o: disk/ata_pthru.c $(disk/ata_pthru.c_DEPENDENCIES)
	$(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ata_pthru_mod_CFLAGS) -MD -c -o $@ $<
-include ata_pthru_mod-disk_ata_pthru.d

clean-module-ata_pthru_mod-disk_ata_pthru-extra.1:
	rm -f cmd-ata_pthru_mod-disk_ata_pthru.lst fs-ata_pthru_mod-disk_ata_pthru.lst partmap-ata_pthru_mod-disk_ata_pthru.lst handler-ata_pthru_mod-disk_ata_pthru.lst parttool-ata_pthru_mod-disk_ata_pthru.lst

CLEAN_MODULE_TARGETS += clean-module-ata_pthru_mod-disk_ata_pthru-extra.1

COMMANDFILES += cmd-ata_pthru_mod-disk_ata_pthru.lst
FSFILES += fs-ata_pthru_mod-disk_ata_pthru.lst
PARTTOOLFILES += parttool-ata_pthru_mod-disk_ata_pthru.lst
PARTMAPFILES += partmap-ata_pthru_mod-disk_ata_pthru.lst
HANDLERFILES += handler-ata_pthru_mod-disk_ata_pthru.lst

cmd-ata_pthru_mod-disk_ata_pthru.lst: disk/ata_pthru.c $(disk/ata_pthru.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ata_pthru_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh ata_pthru > $@ || (rm -f $@; exit 1)

fs-ata_pthru_mod-disk_ata_pthru.lst: disk/ata_pthru.c $(disk/ata_pthru.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ata_pthru_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh ata_pthru > $@ || (rm -f $@; exit 1)

parttool-ata_pthru_mod-disk_ata_pthru.lst: disk/ata_pthru.c $(disk/ata_pthru.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ata_pthru_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh ata_pthru > $@ || (rm -f $@; exit 1)

partmap-ata_pthru_mod-disk_ata_pthru.lst: disk/ata_pthru.c $(disk/ata_pthru.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ata_pthru_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh ata_pthru > $@ || (rm -f $@; exit 1)

handler-ata_pthru_mod-disk_ata_pthru.lst: disk/ata_pthru.c $(disk/ata_pthru.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(ata_pthru_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh ata_pthru > $@ || (rm -f $@; exit 1)

ata_pthru_mod_CFLAGS = $(COMMON_CFLAGS)
ata_pthru_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For hdparm.mod.
hdparm_mod_SOURCES = commands/hdparm.c lib/hexdump.c

clean-module-hdparm.mod.1:
	rm -f hdparm.mod mod-hdparm.o mod-hdparm.c pre-hdparm.o hdparm_mod-commands_hdparm.o hdparm_mod-lib_hexdump.o und-hdparm.lst

CLEAN_MODULE_TARGETS += clean-module-hdparm.mod.1

ifneq ($(hdparm_mod_EXPORTS),no)
clean-module-hdparm.mod-symbol.1:
	rm -f def-hdparm.lst

CLEAN_MODULE_TARGETS += clean-module-hdparm.mod-symbol.1
DEFSYMFILES += def-hdparm.lst
endif
mostlyclean-module-hdparm.mod.1:
	rm -f hdparm_mod-commands_hdparm.d hdparm_mod-lib_hexdump.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-hdparm.mod.1
UNDSYMFILES += und-hdparm.lst

ifneq ($(TARGET_APPLE_CC),1)
hdparm.mod: pre-hdparm.o mod-hdparm.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(hdparm_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-hdparm.o mod-hdparm.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
hdparm.mod: pre-hdparm.o mod-hdparm.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(hdparm_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-hdparm.o mod-hdparm.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-hdparm.o: $(hdparm_mod_DEPENDENCIES) hdparm_mod-commands_hdparm.o hdparm_mod-lib_hexdump.o
	-rm -f $@
	$(TARGET_CC) $(hdparm_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ hdparm_mod-commands_hdparm.o hdparm_mod-lib_hexdump.o

mod-hdparm.o: mod-hdparm.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(hdparm_mod_CFLAGS) -c -o $@ $<

mod-hdparm.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'hdparm' $< > $@ || (rm -f $@; exit 1)

ifneq ($(hdparm_mod_EXPORTS),no)
ifneq ($(TARGET_APPLE_CC),1)
def-hdparm.lst: pre-hdparm.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 hdparm/' > $@
else
def-hdparm.lst: pre-hdparm.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 hdparm/' > $@
endif
endif

und-hdparm.lst: pre-hdparm.o
	echo 'hdparm' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

hdparm_mod-commands_hdparm.o: commands/hdparm.c $(commands/hdparm.c_DEPENDENCIES)
	$(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(hdparm_mod_CFLAGS) -MD -c -o $@ $<
-include hdparm_mod-commands_hdparm.d

clean-module-hdparm_mod-commands_hdparm-extra.1:
	rm -f cmd-hdparm_mod-commands_hdparm.lst fs-hdparm_mod-commands_hdparm.lst partmap-hdparm_mod-commands_hdparm.lst handler-hdparm_mod-commands_hdparm.lst parttool-hdparm_mod-commands_hdparm.lst

CLEAN_MODULE_TARGETS += clean-module-hdparm_mod-commands_hdparm-extra.1

COMMANDFILES += cmd-hdparm_mod-commands_hdparm.lst
FSFILES += fs-hdparm_mod-commands_hdparm.lst
PARTTOOLFILES += parttool-hdparm_mod-commands_hdparm.lst
PARTMAPFILES += partmap-hdparm_mod-commands_hdparm.lst
HANDLERFILES += handler-hdparm_mod-commands_hdparm.lst

cmd-hdparm_mod-commands_hdparm.lst: commands/hdparm.c $(commands/hdparm.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(hdparm_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh hdparm > $@ || (rm -f $@; exit 1)

fs-hdparm_mod-commands_hdparm.lst: commands/hdparm.c $(commands/hdparm.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(hdparm_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh hdparm > $@ || (rm -f $@; exit 1)

parttool-hdparm_mod-commands_hdparm.lst: commands/hdparm.c $(commands/hdparm.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(hdparm_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh hdparm > $@ || (rm -f $@; exit 1)

partmap-hdparm_mod-commands_hdparm.lst: commands/hdparm.c $(commands/hdparm.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(hdparm_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh hdparm > $@ || (rm -f $@; exit 1)

handler-hdparm_mod-commands_hdparm.lst: commands/hdparm.c $(commands/hdparm.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(hdparm_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh hdparm > $@ || (rm -f $@; exit 1)

hdparm_mod-lib_hexdump.o: lib/hexdump.c $(lib/hexdump.c_DEPENDENCIES)
	$(TARGET_CC) -Ilib -I$(srcdir)/lib $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(hdparm_mod_CFLAGS) -MD -c -o $@ $<
-include hdparm_mod-lib_hexdump.d

clean-module-hdparm_mod-lib_hexdump-extra.1:
	rm -f cmd-hdparm_mod-lib_hexdump.lst fs-hdparm_mod-lib_hexdump.lst partmap-hdparm_mod-lib_hexdump.lst handler-hdparm_mod-lib_hexdump.lst parttool-hdparm_mod-lib_hexdump.lst

CLEAN_MODULE_TARGETS += clean-module-hdparm_mod-lib_hexdump-extra.1

COMMANDFILES += cmd-hdparm_mod-lib_hexdump.lst
FSFILES += fs-hdparm_mod-lib_hexdump.lst
PARTTOOLFILES += parttool-hdparm_mod-lib_hexdump.lst
PARTMAPFILES += partmap-hdparm_mod-lib_hexdump.lst
HANDLERFILES += handler-hdparm_mod-lib_hexdump.lst

cmd-hdparm_mod-lib_hexdump.lst: lib/hexdump.c $(lib/hexdump.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Ilib -I$(srcdir)/lib $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(hdparm_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh hdparm > $@ || (rm -f $@; exit 1)

fs-hdparm_mod-lib_hexdump.lst: lib/hexdump.c $(lib/hexdump.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Ilib -I$(srcdir)/lib $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(hdparm_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh hdparm > $@ || (rm -f $@; exit 1)

parttool-hdparm_mod-lib_hexdump.lst: lib/hexdump.c $(lib/hexdump.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Ilib -I$(srcdir)/lib $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(hdparm_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh hdparm > $@ || (rm -f $@; exit 1)

partmap-hdparm_mod-lib_hexdump.lst: lib/hexdump.c $(lib/hexdump.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Ilib -I$(srcdir)/lib $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(hdparm_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh hdparm > $@ || (rm -f $@; exit 1)

handler-hdparm_mod-lib_hexdump.lst: lib/hexdump.c $(lib/hexdump.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Ilib -I$(srcdir)/lib $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(hdparm_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh hdparm > $@ || (rm -f $@; exit 1)

hdparm_mod_CFLAGS = $(COMMON_CFLAGS)
hdparm_mod_LDFLAGS = $(COMMON_LDFLAGS)

ifeq ($(enable_efiemu), yes)

efiemu32.o: efiemu/runtime/efiemu.c $(TARGET_OBJ2ELF)
	-rm -f $@
ifeq ($(TARGET_APPLE_CC), 1)
	-rm -f $@.bin
	$(TARGET_CC) -c -m32 -DELF32 -DAPPLE_CC -o $@.bin -Wall -Werror $< -nostdlib -O2 -I$(srcdir)/efiemu/runtime -I$(srcdir)/include -Iinclude
	$(OBJCONV) -felf32 -nu -nd $@.bin $@
	-rm -f $@.bin
else
	$(TARGET_CC) -c -m32 -DELF32 -o $@ -Wall -Werror $< -nostdlib -O2 -I$(srcdir)/efiemu/runtime -I$(srcdir)/include -Iinclude
	if test ! -z $(TARGET_OBJ2ELF); then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
endif

efiemu64_c.o: efiemu/runtime/efiemu.c
ifeq ($(TARGET_APPLE_CC), 1)
	$(TARGET_CC) -c -m64 -DAPPLE_CC=1 -DELF64 -o $@ -Wall -Werror $< -nostdlib -mno-red-zone -O2 -I$(srcdir)/efiemu/runtime -I$(srcdir)/include -Iinclude
else
	$(TARGET_CC) -c -m64 -DELF64 -o $@ -Wall -Werror $< -nostdlib  -mcmodel=large -mno-red-zone -O2 -I$(srcdir)/efiemu/runtime -I$(srcdir)/include -Iinclude
endif

efiemu64_s.o: efiemu/runtime/efiemu.S
	-rm -f $@
ifeq ($(TARGET_APPLE_CC), 1)
	$(TARGET_CC) -c -m64 -DAPPLE_CC=1 -DELF64 -o $@ -Wall -Werror $< -nostdlib -mno-red-zone -O2 -I$(srcdir)/efiemu/runtime -I$(srcdir)/include -Iinclude
else
	$(TARGET_CC) -c -m64 -DELF64 -o $@ -Wall -Werror $< -nostdlib  -mcmodel=large -mno-red-zone -O2 -I$(srcdir)/efiemu/runtime -I$(srcdir)/include -Iinclude
endif

efiemu64.o: efiemu64_c.o efiemu64_s.o  $(TARGET_OBJ2ELF)
	-rm -f $@
ifeq ($(TARGET_APPLE_CC), 1)
	-rm -f $@.bin
	$(TARGET_CC) -m64 -o $@.bin -Wl,-r $^ -nostdlib
	$(OBJCONV) -felf64 -nu -nd $@.bin $@
	-rm -f $@.bin
else
	$(TARGET_CC) -m64 -o $@ -Wl,-r $^ -nostdlib
	if test ! -z $(TARGET_OBJ2ELF); then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
endif

CLEANFILES += efiemu32.o efiemu64.o efiemu64_c.o efiemu64_s.o
pkglib_DATA += efiemu32.o efiemu64.o

endif

include $(srcdir)/conf/i386.mk
include $(srcdir)/conf/common.mk
grub-mkimage: $(grub_mkimage_DEPENDENCIES) $(grub_mkimage_OBJECTS)
	$(CC) -o $@ $(grub_mkimage_OBJECTS) $(LDFLAGS) $(grub_mkimage_LDFLAGS)

grub-setup: $(grub_setup_DEPENDENCIES) $(grub_setup_OBJECTS)
	$(CC) -o $@ $(grub_setup_OBJECTS) $(LDFLAGS) $(grub_setup_LDFLAGS)

grub-mkdevicemap: $(grub_mkdevicemap_DEPENDENCIES) $(grub_mkdevicemap_OBJECTS)
	$(CC) -o $@ $(grub_mkdevicemap_OBJECTS) $(LDFLAGS) $(grub_mkdevicemap_LDFLAGS)

grub-emu: $(grub_emu_DEPENDENCIES) $(grub_emu_OBJECTS)
	$(CC) -o $@ $(grub_emu_OBJECTS) $(LDFLAGS) $(grub_emu_LDFLAGS)

