/*
 * Copyright (C) 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <njpatel@gmail.com>
 */

using GwibberGtk;

public abstract class TabBarStreamItem : TabBarItem
{
  public StreamView? view = null;

  public TabBarStreamItem (string stream, string icon_name, string tooltip = "", Gee.HashMap streams_map)
  {
    Object (stream:stream, tooltip:tooltip, icon_name:icon_name, streams_map:streams_map);
  }

  construct
  {
    view = new StreamView ();
    view.set_no_show_all (true);
    view.notify["prepared"].connect (() => {
      view.set_no_show_all (false);
      view.show_all ();
    });

    view.model = streams_map[stream];
    view.stream = stream;
    view.send.connect ((mid, account, sender, action) => {
        entry.text_view.mid = mid;
        if (action == "private" || stream == "private")
        {
          entry.text_view.action = "private";
          entry.private.show ();
        }
        else
          entry.text_view.action = "reply";
        entry.target_bar.selected = account;
        entry.showing = true;
        if (entry.text_view.action != "private")
          entry.text_view.buffer.text = sender + " ";
        entry.text_view.grab_focus ();
        });

    notify["active"].connect(() => {
      view.showing = active;
      });
  }
}

public abstract class TabBarItem : Gtk.Button
{
  public string stream  { get; construct set; }
  public string tooltip { get; construct set; }
  public string icon_name { get; construct set; }
  public Gee.HashMap<string, Dee.Model> streams_map { get; construct set; }
  public StreamEntry? entry = null;

  public bool active {
    get { return _active; }
    set
    {
      _active = value;
      Idle.add (() => {
        queue_draw ();
        return false;
      });
    }
  } 

  private Gtk.Image _image;
  private bool _active = false;

  public TabBarItem (string stream, string icon_name, string tooltip = "", Gee.HashMap streams_map)
  {
    Object (stream:stream, tooltip:tooltip, icon_name:icon_name, streams_map:streams_map);
  }

  construct
  {
    entry = get_entry ();
    set_size_request (40, 32);

    _image = new Gtk.Image.from_icon_name (icon_name, Gtk.IconSize.BUTTON);
    _image.tooltip_text = tooltip;
    add (_image);
  }

  public override bool draw (Cairo.Context cr)
  {
    propagate_draw (_image, cr);
    return true;
  }

  public StreamEntry? get_entry ()
  {
    return entry;
  }

  // Should be implemented by sub-classes
  public abstract Gtk.Widget? get_toolbar ();
  public abstract Gtk.Widget? get_view ();
}
