import Qt 4.7
import gconf 1.0

Popup {
    id: popup

    property QLauncherApplication connection
    property string connection_id

    text: connection ? qsTr("Delete %1?").arg(connection.name) : ""

    GConfItem {
        id: gconf_modal
        key: "/apps/hedley_launcher/modal"
        /* while visible, the popup is modal system-wide */
        value: true
    }

    FocusScope {
        id: buttons

        anchors.bottom: parent.bottom
        anchors.bottomMargin: padding-5
        anchors.left: parent.left
        anchors.right: parent.right

        focus: true

        ButtonFrameAndText {
            id: cancel

            anchors.left: parent.left
            anchors.leftMargin: padding
            anchors.bottom: parent.bottom

            focus: true

            text: qsTr("Cancel")
            onClicked: {
                popup.exited()
                gconf_modal.value = false
            }

            KeyNavigation.right: ok
        }

        ButtonFrameAndText {
            id: ok

            anchors.right: parent.right
            anchors.rightMargin: padding
            anchors.bottom: parent.bottom

            text: qsTr("OK")
            onClicked: {
                if(connection_id)
                    connection.removeFromConnectionsList(connection_id)
                else
                    connection.removeDesktopFile()

                popup.exited()
                gconf_modal.value = false
            }

            KeyNavigation.left: cancel
        }
    }
}
