#include <glib/gi18n.h>
#include <bickley/bkl-item-audio.h>

#include "hrn.h"
#include "hrn-iface-player.h"
#include "hrn-audio-viewer.h"

enum {
    PROP_0,
};

struct _HrnAudioViewerPrivate {
    NbtkWidget *title;
    NbtkWidget *artist;
    NbtkWidget *composer;
    NbtkWidget *album;
    ClutterActor *element;
};

static void hrn_player_init (HrnIfacePlayerClass *iface);
#define GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), HRN_TYPE_AUDIO_VIEWER, HrnAudioViewerPrivate))
G_DEFINE_TYPE_WITH_CODE (HrnAudioViewer, hrn_audio_viewer, NBTK_TYPE_TABLE,
                         G_IMPLEMENT_INTERFACE (HRN_TYPE_IFACE_PLAYER,
                                                hrn_player_init));

static void
hrn_audio_viewer_finalize (GObject *object)
{
    G_OBJECT_CLASS (hrn_audio_viewer_parent_class)->finalize (object);
}

static void
hrn_audio_viewer_dispose (GObject *object)
{
    G_OBJECT_CLASS (hrn_audio_viewer_parent_class)->dispose (object);
}

static void
hrn_audio_viewer_set_property (GObject      *object,
                          guint         prop_id,
                          const GValue *value,
                          GParamSpec   *pspec)
{
    switch (prop_id) {

    default:
        break;
    }
}

static void
hrn_audio_viewer_get_property (GObject    *object,
                          guint       prop_id,
                          GValue     *value,
                          GParamSpec *pspec)
{
    switch (prop_id) {

    default:
        break;
    }
}

static void
hrn_audio_viewer_class_init (HrnAudioViewerClass *klass)
{
    GObjectClass *o_class = (GObjectClass *)klass;

    o_class->dispose = hrn_audio_viewer_dispose;
    o_class->finalize = hrn_audio_viewer_finalize;
    o_class->set_property = hrn_audio_viewer_set_property;
    o_class->get_property = hrn_audio_viewer_get_property;

    g_type_class_add_private (klass, sizeof (HrnAudioViewerPrivate));
}

static void
player_set_playing (HrnIfacePlayer *player,
                    gboolean        playing)
{
    /* This function left blank */
}

static void
set_thumbnail (HrnAudioViewer *viewer,
               BklItem        *item)
{
    HrnAudioViewerPrivate *priv = viewer->priv;
    const char *thumb_uri;

    if (priv->element) {
        clutter_actor_destroy (priv->element);
        priv->element = NULL;
    }

    thumb_uri = bkl_item_extended_get_thumbnail ((BklItemExtended *) item);

    if (thumb_uri) {
        priv->element = hrn_texture_cache_get_sq_texture (NULL,
                                                          thumb_uri, TRUE);
    } else {
        priv->element = hrn_texture_cache_get_sq_texture
            (NULL, PKGDATADIR "hrn-generic-album.png", TRUE);
    }

    clutter_actor_set_size (priv->element, 100, 100);
    nbtk_table_add_actor_with_properties ((NbtkTable *) viewer,
                                          priv->element, 0, 0,
                                          "row-span", 5,
                                          "x-expand", FALSE,
                                          "y-expand", FALSE,
                                          "x-fill", FALSE,
                                          "y-fill", FALSE,
                                          "x-align", 0.0,
                                          "y-align", 0.0,
                                          NULL);
}

static void
player_set_uri (HrnIfacePlayer *player,
                const char     *uri)
{
    HrnAudioViewer *viewer = (HrnAudioViewer *) player;
    HrnAudioViewerPrivate *priv = viewer->priv;
    BklItem *item;
    BklItemAudio *audio;
    GPtrArray *artists;
    const char *artist;

    if (uri == NULL) {
        return;
    }

    item = hrn_get_item_for_uri (uri);
    if (item == NULL) {
        return;
    }

    audio = (BklItemAudio *) item;
    nbtk_label_set_text ((NbtkLabel *) priv->title,
                         bkl_item_audio_get_title (audio));

    /* FIXME: Don't just pick the first artist */
    artists = bkl_item_audio_get_artists (audio);
    if (artists) {
        artist = artists->pdata[0];
    } else {
        artist = _("Unknown Artist");
    }
    nbtk_label_set_text ((NbtkLabel *) priv->artist, artist);

    if (bkl_item_audio_get_composer (audio)) {
        nbtk_label_set_text ((NbtkLabel *) priv->composer,
                             bkl_item_audio_get_composer (audio));
    } else {
        nbtk_label_set_text ((NbtkLabel *) priv->composer, "");
    }

    nbtk_label_set_text ((NbtkLabel *) priv->album,
                         bkl_item_audio_get_album (audio));

    set_thumbnail (viewer, item);
}

static void
player_set_position (HrnIfacePlayer *player,
                     double          position)
{
    /* This function left blank */
}

static void
hrn_player_init (HrnIfacePlayerClass *iface)
{
    iface->set_playing = player_set_playing;
    iface->set_uri = player_set_uri;
    iface->set_position = player_set_position;
}

static void
hrn_audio_viewer_init (HrnAudioViewer *self)
{
    HrnAudioViewerPrivate *priv = GET_PRIVATE (self);

    self->priv = priv;

    priv->title = nbtk_label_new ("");
    nbtk_widget_set_style_class_name (priv->title, "HrnTheatreTitle");
    nbtk_table_add_actor_with_properties ((NbtkTable *) self,
                                          (ClutterActor *) priv->title, 0, 1,
                                          "y-fill", FALSE,
                                          "y-expand", FALSE,
                                          "x-align", 0.0,
                                          "y-align", 0.0,
                                          NULL);

    priv->artist = nbtk_label_new ("");
    nbtk_widget_set_style_class_name (priv->artist, "HrnTheatreArtist");
    nbtk_table_add_actor_with_properties ((NbtkTable *) self,
                                          (ClutterActor *) priv->artist, 1, 1,
                                          "y-fill", FALSE,
                                          "y-expand", FALSE,
                                          "x-align", 0.0,
                                          "y-align", 0.0,
                                          NULL);

    priv->album = nbtk_label_new ("");
    nbtk_widget_set_style_class_name (priv->album, "HrnTheatreAlbum");
    nbtk_table_add_actor_with_properties ((NbtkTable *) self,
                                          (ClutterActor *) priv->album, 2, 1,
                                          "y-fill", FALSE,
                                          "y-expand", FALSE,
                                          "x-align", 0.0,
                                          "y-align", 0.0,
                                          NULL);

    priv->composer = nbtk_label_new ("");
    nbtk_widget_set_style_class_name (priv->composer, "HrnTheatreComposer");
    nbtk_table_add_actor_with_properties ((NbtkTable *) self,
                                          (ClutterActor *) priv->composer, 3, 1,
                                          "y-fill", FALSE,
                                          "y-expand", FALSE,
                                          "x-align", 0.0,
                                          "y-align", 0.0,
                                          NULL);

    priv->element = NULL;
}
