#include <glib.h>

#include "hrn-iface-player.h"

enum
{
  POSITION_CHANGED,
  EOS,
  LAST_SIGNAL
};

static guint32 signals[LAST_SIGNAL] = { 0, };

static void
hrn_iface_player_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (initialized)
    {
      return;
    }
  initialized = TRUE;

  signals[POSITION_CHANGED] = g_signal_new ("position-changed",
                                            G_OBJECT_CLASS_TYPE (klass),
                                            G_SIGNAL_RUN_LAST, 0, NULL, NULL,
                                            g_cclosure_marshal_VOID__DOUBLE,
                                            G_TYPE_NONE, 1, G_TYPE_DOUBLE);
  signals[EOS] = g_signal_new ("eos",
                               G_OBJECT_CLASS_TYPE (klass),
                               G_SIGNAL_RUN_LAST, 0, NULL, NULL,
                               g_cclosure_marshal_VOID__VOID,
                               G_TYPE_NONE, 0);
}

GType
hrn_iface_player_get_type (void)
{
  static GType type = 0;

  if (!type)
    {
      const GTypeInfo info = {
        sizeof (HrnIfacePlayerClass),
        hrn_iface_player_base_init,
        NULL,
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
                                     "HrnIfacePlayer", &info, 0);
    }

  return type;
}

void
hrn_iface_player_emit_position_changed (HrnIfacePlayer *player, double position)
{
  g_signal_emit (player, signals[POSITION_CHANGED], 0, position);
}

void
hrn_iface_player_emit_eos (HrnIfacePlayer *player)
{
  g_signal_emit (player, signals[EOS], 0);
}

void
hrn_iface_player_set_uri (HrnIfacePlayer *player, const char     *uri)
{
  HRN_IFACE_PLAYER_GET_CLASS (player)->set_uri (player, uri);
}

void
hrn_iface_player_set_playing (HrnIfacePlayer *player, gboolean playing)
{
  HRN_IFACE_PLAYER_GET_CLASS (player)->set_playing (player, playing);
}

void
hrn_iface_player_set_position (HrnIfacePlayer *player, double position)
{
  HRN_IFACE_PLAYER_GET_CLASS (player)->set_position (player, position);
}
