/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HRN_CONTROLS_H
#define _HRN_CONTROLS_H

#include <clutter/clutter.h>
#include <bickley/bkl-item.h>
#include <bognor/br-queue.h>

G_BEGIN_DECLS

#define HRN_TYPE_CONTROLS    hrn_controls_get_type ()

#define HRN_CONTROLS(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_CONTROLS, HrnControls))

#define HRN_CONTROLS_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), HRN_TYPE_CONTROLS, HrnControlsClass))

#define HRN_IS_CONTROLS(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_CONTROLS))

#define HRN_IS_CONTROLS_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), HRN_TYPE_CONTROLS))

#define HRN_CONTROLS_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), HRN_TYPE_CONTROLS, HrnControlsClass))

typedef struct _HrnControls HrnControls;
typedef struct _HrnControlsClass HrnControlsClass;
typedef struct _HrnControlsPrivate HrnControlsPrivate;

struct _HrnControls
{
  NbtkWidget       parent_instance;
  HrnControlsPrivate *priv;
};

struct _HrnControlsClass
{
  /*< private >*/
  NbtkWidgetClass parent_class;
};

GType     hrn_controls_get_type (void) G_GNUC_CONST;

HrnControls *hrn_controls_new (BrQueue *br_queue);
void      hrn_controls_populate (HrnControls *controls);



/* In a hornsey queue the 0th element is the currently playing
 * element
 */

/* A queue can have a random emitter enabled on the bottom, the
 * random emitter generates a playqueue on the go*/

void         hrn_controls_set_name            (HrnControls *queue,
                                               const gchar *name);
const gchar *hrn_controls_get_name            (HrnControls *controls);
void         hrn_controls_append              (HrnControls *controls,
                                               BklItem     *item);
void         hrn_controls_prepend_list        (HrnControls *controls,
                                               GList       *items);
gint         hrn_controls_get_length          (HrnControls *controls);
void         hrn_controls_set_active_visual   (HrnControls *controls,
                                               BklItem     *item,
                                               const gchar *uri);
BklItem *    hrn_controls_get_active_visual   (HrnControls *controls);
void         hrn_controls_set_active_audio    (HrnControls *controls,
                                               BklItem     *item,
                                               const gchar *uri);
BklItem *    hrn_controls_get_active_audio    (HrnControls *controls);
BklItem *    hrn_controls_proceed             (HrnControls *controls,
                                               gint         item_type_mask);
gboolean     hrn_controls_get_playing         (HrnControls *controls);
void         hrn_controls_set_playing         (HrnControls *controls,
                                               gboolean     playing);
void         hrn_controls_audio_finished      (HrnControls *controls);
void         hrn_controls_video_finished      (HrnControls *controls);
void         hrn_controls_image_finished      (HrnControls *controls);
void         hrn_controls_hide_video_progress (HrnControls *controls);
void         hrn_controls_show_video_progress (HrnControls *controls);
void         hrn_controls_hide_audio_progress (HrnControls *controls);
void         hrn_controls_show_audio_progress (HrnControls *controls);
void         hrn_controls_audio_peek          (HrnControls *controls);
void         hrn_controls_visual_peek         (HrnControls *controls);

void         hrn_controls_play_now         (HrnControls *controls,
                                            BklItem  *item);
void         hrn_controls_play_uri_now     (HrnControls *controls,
                                            const gchar *uri);


G_END_DECLS

#endif
