#include <glib.h>

#include "hrn-tileable.h"
#include "hrn-marshal.h"

enum {
    ACTIVATED,
    COUNT_CHANGED,
    VISIBILITY_CHANGED,
    LAST_SIGNAL
};

static guint32 signals[LAST_SIGNAL] = {0, };

static void
hrn_tileable_base_init (gpointer klass)
{
    static gboolean initialized = FALSE;

    if (initialized) {
        return;
    }
    initialized = TRUE;

    signals[ACTIVATED] = g_signal_new ("activated",
                                       G_OBJECT_CLASS_TYPE (klass),
                                       G_SIGNAL_RUN_LAST, 0, NULL, NULL,
                                       hrn_marshal_VOID__INT_POINTER,
                                       G_TYPE_NONE, 2, G_TYPE_INT,
                                       G_TYPE_POINTER);
    signals[COUNT_CHANGED] = g_signal_new ("count-changed",
                                           G_TYPE_FROM_CLASS (klass),
                                           G_SIGNAL_RUN_FIRST |
                                           G_SIGNAL_NO_RECURSE, 0, NULL, NULL,
                                           hrn_marshal_VOID__INT_INT,
                                           G_TYPE_NONE, 2, G_TYPE_INT,
                                           G_TYPE_INT);
    signals[VISIBILITY_CHANGED] = g_signal_new ("visibility-changed",
                                                G_TYPE_FROM_CLASS (klass),
                                                G_SIGNAL_RUN_FIRST |
                                                G_SIGNAL_NO_RECURSE,
                                                0, NULL, NULL,
                                                g_cclosure_marshal_VOID__BOOLEAN,
                                                G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

GType
hrn_tileable_get_type (void)
{
    static GType type = 0;

    if (!type) {
        const GTypeInfo info = {
            sizeof (HrnTileableInterface),
            hrn_tileable_base_init, NULL,
        };

        type = g_type_register_static (G_TYPE_INTERFACE,
                                       "HrnTileable", &info, 0);
    }

    return type;
}

guint
hrn_tileable_get_count (HrnTileable *tileable)
{
    return HRN_TILEABLE_GET_CLASS (tileable)->get_count (tileable);
}

ClutterActor *
hrn_tileable_get_thumbnail (HrnTileable *tileable)
{
    return HRN_TILEABLE_GET_CLASS (tileable)->get_thumbnail (tileable);
}

void
hrn_tileable_set_position (HrnTileable *tileable,
                           guint        x,
                           guint        y)
{
    HRN_TILEABLE_GET_CLASS (tileable)->set_position (tileable, x, y);
}

void
hrn_tileable_activated (HrnTileable      *tileable,
                        HrnTileableAction action,
                        gpointer          payload)
{
    g_signal_emit (tileable, signals[ACTIVATED], 0, action, payload);
}

void
hrn_tileable_item_count_changed (HrnTileable *tileable,
                                 int          old_count,
                                 int          new_count)
{
    g_signal_emit (tileable, signals[COUNT_CHANGED], 0, old_count, new_count);
}

HrnClusterNode *
hrn_tileable_get_node (HrnTileable *tileable)
{
    return HRN_TILEABLE_GET_CLASS (tileable)->get_node (tileable);
}

void
hrn_tileable_visibility_changed (HrnTileable *tileable,
                                 gboolean     hidden)
{
    g_signal_emit (tileable, signals[VISIBILITY_CHANGED], 0, hidden);
}
