/*
 * indicator-network
 * Copyright 22012 Canonical Ltd.
 *
 * Authors:
 * Antti Kaijanmäki <antti.kaijanmaki@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _ANDROID_TELEPHONY_SERVICE_
#define _ANDROID_TELEPHONY_SERVICE_

#include <glib-object.h>

G_BEGIN_DECLS

#define ANDROID_TELEPHONY_SERVICE_TYPE (android_telephony_service_get_type ())
#define ANDROID_TELEPHONY_SERVICE(o) (G_TYPE_CHECK_INSTANCE_CAST ((o),                                     \
                                                                  ANDROID_TELEPHONY_SERVICE_TYPE,          \
                                                                  AndroidTelephonyService))                
#define ANDROID_TELEPHONY_SERVICE_CLASS(k) G_TYPE_CHECK_CLASS_CAST ((k),                                   \
								    ANDROID_TELEPHONY_SERVICE_TYPE,        \
								    AndroidTelephonyServiceClass))
#define IS_ANDROID_TELEPHONY_SERVICE(o) (G_TYPE_CHECK_INSTANCE_TYPE ((o),                                  \
								     ANDROID_TELEPHONY_SERVICE_TYPE))
#define IS_ANDROID_TELEPHONY_SERVICE_CLASS(k) (G_TYPE_CHECK_CLASS_TYPE ((k),                               \
									ANDROID_TELEPHONY_SERVICE_TYPE))
#define ANDROID_TELEPHONY_SERVICE_GET_CLASS(o) (G_TYPE_INTANCE_GET_CLASS ((o),                             \
									  ANDROID_TELEPHONY_SERVICE_TYPE,  \
									  AndroidTelephonyServiceClass))

typedef struct _AndroidTelephonyService      AndroidTelephonyService;
typedef struct _AndroidTelephonyServiceClass AndroidTelephonyServiceClass;

struct _AndroidTelephonyService
{
  GObject parent;
};

struct _AndroidTelephonyServiceClass
{
  GObjectClass parent_class;
};

typedef enum {
  TELEPHONY_SIGNAL_LEVEL_UNKNOWN  = 0x0,
  TELEPHONY_SIGNAL_LEVEL_POOR     = 0x1,
  TELEPHONY_SIGNAL_LEVEL_MODERATE = 0x2,
  TELEPHONY_SIGNAL_LEVEL_GOOD     = 0x3,
  TELEPHONY_SIGNAL_LEVEL_GREAT    = 0x4
} TelephonySignalLevel;

typedef enum {
  TELEPHONY_STATE_IN_SERVICE     = 0x0,
  TELEPHONY_STATE_OUT_OF_SERVICE = 0x1,
  TELEPHONY_STATE_EMERGENCY_ONLY = 0x2,
  TELEPHONY_STATE_POWER_OFF      = 0x3
} TelephonyState;

typedef enum {
  TELEPHONY_RADIO_TECHNOLOGY_UNKNOWN = 0x0,
  TELEPHONY_RADIO_TECHNOLOGY_GPRS    = 0x1,
  TELEPHONY_RADIO_TECHNOLOGY_EDGE    = 0x2,
  TELEPHONY_RADIO_TECHNOLOGY_UMTS    = 0x3,
  TELEPHONY_RADIO_TECHNOLOGY_IS95A   = 0x4,
  TELEPHONY_RADIO_TECHNOLOGY_IS95B   = 0x5,
  TELEPHONY_RADIO_TECHNOLOGY_1xRTT   = 0x6,
  TELEPHONY_RADIO_TECHNOLOGY_EVDO_0  = 0x7,
  TELEPHONY_RADIO_TECHNOLOGY_EVDO_A  = 0x8,
  TELEPHONY_RADIO_TECHNOLOGY_HSDPA   = 0x9,
  TELEPHONY_RADIO_TECHNOLOGY_HSUPA   = 0xa,
  TELEPHONY_RADIO_TECHNOLOGY_HSPA    = 0xb,
  TELEPHONY_RADIO_TECHNOLOGY_EVDO_B  = 0xc,
  TELEPHONY_RADIO_TECHNOLOGY_EHRPD   = 0xd,
  TELEPHONY_RADIO_TECHNOLOGY_LTE     = 0xe,
  TELEPHONY_RADIO_TECHNOLOGY_HSPAP   = 0xf 
} TelephonyRadioTechnology;

GType android_telephony_service_get_type();

AndroidTelephonyService *android_telephony_service_new();

gboolean
android_telephony_service_get_is_gsm(AndroidTelephonyService *service);

const gchar *
android_telephony_service_get_operator_name(AndroidTelephonyService *self);

const gchar *
android_telephony_service_get_operator_numeric(AndroidTelephonyService *self);

TelephonyRadioTechnology
android_telephony_service_get_radio_technology(AndroidTelephonyService *self);

gboolean
android_telephony_service_get_roaming(AndroidTelephonyService *self);

TelephonySignalLevel
android_telephony_service_get_signal_level(AndroidTelephonyService *self);

TelephonyState
android_telephony_service_get_state(AndroidTelephonyService *self);

G_END_DECLS

#endif
