/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2009 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_DBUS_EMBED_AGENT_H__
#define __KZ_DBUS_EMBED_AGENT_H__

#include <gtk/gtk.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

#define KZ_DBUS_EMBED_AGENT_NAME "org.kazehakase.Embed"
#define KZ_DBUS_EMBED_AGENT_PATH "/org/kazehakase/Embed"
#define KZ_DBUS_EMBED_AGENT_INTERFACE "org.kazehakase.Embed"

#define KZ_TYPE_DBUS_EMBED_AGENT		     (kz_dbus_embed_agent_get_type ())
#define KZ_DBUS_EMBED_AGENT(obj)		     (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_DBUS_EMBED_AGENT, KzDBusEmbedAgent))
#define KZ_DBUS_EMBED_AGENT_CLASS(klass)	 (G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_DBUS_EMBED_AGENT, KzDBusEmbedAgentClass))
#define KZ_IS_EMBED_DBUS(obj)	             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_DBUS_EMBED_AGENT))
#define KZ_IS_EMBED_DBUS_CLASS(klass)        (G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_DBUS_EMBED_AGENT))
#define KZ_DBUS_EMBED_AGENT_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_DBUS_EMBED_AGENT, KzDBusEmbedAgentClass))

typedef struct _KzDBusEmbedAgent KzDBusEmbedAgent;
typedef struct _KzDBusEmbedAgentClass KzDBusEmbedAgentClass;

struct _KzDBusEmbedAgent
{
    GtkSocket parent;
};

struct _KzDBusEmbedAgentClass
{
    GtkSocketClass parent;
};

GType        kz_dbus_embed_agent_get_type (void) G_GNUC_CONST;

GtkWidget   *kz_dbus_embed_agent_new       (const gchar *socket_address);
void         kz_dbus_embed_agent_set_connection
                                           (KzDBusEmbedAgent *agent,
                                            DBusGConnection  *connection);

G_END_DECLS

#endif /* __KZ_DBUS_EMBED_AGENT_H__ */
/* 
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
