//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  The KAction class (and derived and super classes) extends QAction,
    ///  which provides a way to easily encapsulate a "real" user-selected
    ///  action or event in your program.
    ///  For instance, a user may want to <code>paste</code> the contents of
    ///  the clipboard, <code>scroll</code> <code>down</code> a document, or <code>quit</code> the
    ///  application.  These are all <b></b>ctions -- events that the
    ///  user causes to happen.  The KAction class allows the developer to
    ///  deal with these actions in an easy and intuitive manner, and conforms
    ///  to KDE's extended functionality requirements - including supporting
    ///  multiple user-configurable shortcuts, and KDE named icons.  Actions
    ///  also improve accessibility.
    ///  Specifically, QAction (and thus KAction) encapsulates the various attributes
    ///  of an event/action.  For instance, an action might have an icon()
    ///  that provides a visual representation (a clipboard for a "paste" action or
    ///  scissors for a "cut" action).  The action should also be described by some text().
    ///  It will certainly be connected to a method that actually <code>executes</code> the action!
    ///  All these attributes are contained within the action object.
    ///  The advantage of dealing with actions is that you can manipulate
    ///  the Action without regard to the GUI representation of it.  For
    ///  instance, in the "normal" way of dealing with actions like "cut",
    ///  you would manually insert a item for Cut into a menu and a button
    ///  into a toolbar.  If you want to disable the cut action for a moment
    ///  (maybe nothing is selected), you would have to hunt down the pointer
    ///  to the menu item and the toolbar button and disable both
    ///  individually.  Setting the menu item and toolbar item up uses very
    ///  similar code - but has to be done twice!
    ///  With the action concept, you simply add the action to whatever
    ///  GUI element you want.  The KAction class will then take care of
    ///  correctly defining the menu item (with icons, accelerators, text,
    ///  etc), toolbar button, or other.  From then on, if you
    ///  manipulate the action at all, the effect will propagate through all
    ///  GUI representations of it.  Back to the "cut" example: if you want
    ///  to disable the Cut Action, you would simply call
    ///  'cutAction.SetEnabled(false)' and both the menuitem and button would
    ///  instantly be disabled!
    ///  This is the biggest advantage to the action concept -- there is a
    ///  one-to-one relationship between the "real" action and <code>all</code>
    ///  GUI representations of it.
    ///  KAction emits the hovered() signal on mouseover, and the triggered(bool checked)
    ///  signal on activation of a corresponding GUI element ( menu item, toolbar button, etc. )
    ///  If you are in the situation of wanting to map the triggered()
    ///  signal of multiple action objects to one slot, with a special
    ///  argument bound to each action, you have several options:
    ///  Using QActionGroup:
    ///  <li>Create</li> a QActionGroup and assign it to each of the actions with setActionGroup(), then
    ///  <li>Connect</li> the QActionGroup.Triggered(QAction) signal to your slot.
    ///  Using QSignalMapper:
    ///  <pre>
    ///  QSignalMapper desktopNumberMapper = new QSignalMapper( this );
    ///  connect( desktopNumberMapper, SIGNAL("mapped( int )"),
    ///           this, SLOT("moveWindowToDesktop( int )") );
    ///  for ( uint i = 0; i < numberOfDesktops; ++i ) {
    ///      KAction desktopAction = new KAction( i18n( "Move Window to Desktop %i" ).arg( i ), ... );
    ///      connect( desktopAction, SIGNAL("triggered(bool)"), desktopNumberMapper, SLOT("map()") );
    ///      desktopNumberMapper.SetMapping( desktopAction, i );
    ///  }
    ///  </pre>
    ///  \section kaction_general General Usage
    ///  The steps to using actions are roughly as follows:
    /// 
    /// <li>
    /// Decide which attributes you want to associate with a given
    ///      action (icons, text, keyboard shortcut, etc)
    /// </li>
    /// 
    /// <li>
    /// Create the action using KAction (or derived or super class).
    /// </li>
    /// 
    /// <li>
    /// Add the action into whatever GUI element you want.  Typically,
    ///       this will be a menu or toolbar.
    /// </li>
    ///  \section kaction_general The kinds of shortcuts
    ///  Local shortcuts are active
    ///  in their context, global shortcus are active everywhere, usually even if
    ///  another program has focus.
    /// 
    /// <li>
    /// Active shortcuts trigger a KAction if activated.
    /// </li>
    /// 
    /// <li>
    /// Default shortcuts are what the active shortcuts revert to if the user chooses
    ///  to reset shortcuts to default.
    /// </li>
    ///  \section kaction_example Detailed Example
    ///  Here is an example of enabling a "New [document]" action
    ///  <pre>
    ///  KAction newAct = actionCollection().AddAction(
    ///               KStandardAction.New,   //< see KStandardAction
    ///               this,                   //< Receiver
    ///               SLOT("fileNew()")  );     //< SLOT
    ///  </pre>
    ///  This section creates our action. Text, Icon and Shortcut will be set from
    ///  KStandardAction. KStandardAction ensures your application complies to the
    ///  platform standards. When triggered the <code>fileNew</code>() slot will be called.
    ///  If you want to create your own non standard action use
    ///  <pre>
    ///  KAction newAct = actionCollection().AddAction("quick-connect");
    ///  newAct.SetText(i18n("Quick Connect"))
    ///  newAct.SetIcon(KIcon("quick-connect"));
    ///  newAct.SetShortcut(Qt.Key_F6);
    ///  connect(newAct, SIGNAL("triggered()"), this, SLOT("quickConnect()"));
    ///  </pre>
    ///  This section creates our action. It will display the text "Quick Connect"
    ///  and use the Icon "quick-connect". <code>F6</code> will trigger the action. It further
    ///  says that whenever this action is invoked, it will use the quickConnect()
    ///  slot to execute it.
    ///  <pre>
    ///  QMenu file = new QMenu;
    ///  file.AddAction(newAct);
    ///  </pre>
    ///  That just inserted the action into the File menu.  The point is, it's not
    ///  important in which menu it is: all manipulation of the item is
    ///  done through the newAct object.
    ///  <pre>
    ///  toolBar().AddAction(newAct);
    ///  </pre>
    ///  And this added the action into the main toolbar as a button.
    ///  That's it!
    ///  If you want to disable that action sometime later, you can do so
    ///  with
    ///  <pre>
    ///  newAct.SetEnabled(false)
    ///  </pre>
    ///  and both the menuitem in File and the toolbar button will instantly
    ///  be disabled.
    ///  Unlike with previous versions of KDE, the action can simply be deleted
    ///  when you have finished with it - the destructor takes care of all
    ///  of the cleanup.
    ///  <b>Note:<> calling QAction.SetShortcut() on a KAction may lead to unexpected
    ///  behavior. There is nothing we can do about it because QAction.SetShortcut()
    ///   is not virtual.
    ///  <b>Note:<> if you are using a "standard" action like "new", "paste",
    ///  "quit", or any other action described in the KDE UI Standards,
    ///  please use the methods in the KStandardAction class rather than
    ///  defining your own.
    ///  \section kaction_xmlgui Usage Within the XML Framework
    ///  If you are using KAction within the context of the XML menu and
    ///  toolbar building framework, you do not ever
    ///  have to add your actions to containers manually.  The framework
    ///  does that for you.
    ///  See <see cref="IKActionSignals"></see> for signals emitted by KAction
    /// </remarks>        <short> Class to encapsulate user-driven action or event.</short>
    ///         <see> KStandardAction</see>
    ///         <see> for</see>
    ///         <see> more</see>
    ///         <see> information.</see>
    ///         <see> KStandardAction</see>
    [SmokeClass("KAction")]
    public class KAction : QWidgetAction, IDisposable {
        protected KAction(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KAction), this);
        }
        /// <remarks>
        ///  An enumeration about the two types of shortcuts in a KAction
        ///      </remarks>        <short>    An enumeration about the two types of shortcuts in a KAction      </short>
        public enum ShortcutType {
            ActiveShortcut = 0x1,
            DefaultShortcut = 0x2,
        }
        /// <remarks>
        ///  An enum about global shortcut setter semantics
        ///      </remarks>        <short>    An enum about global shortcut setter semantics      </short>
        public enum GlobalShortcutLoading {
            Autoloading = 0x0,
            NoAutoloading = 0x4,
        }
        [Q_PROPERTY("KShortcut", "shortcut")]
        public new KShortcut Shortcut {
            get { return (KShortcut) interceptor.Invoke("shortcut", "shortcut()", typeof(KShortcut)); }
            set { interceptor.Invoke("setShortcut#", "setShortcut(KShortcut)", typeof(void), typeof(KShortcut), value); }
        }
        [Q_PROPERTY("bool", "shortcutConfigurable")]
        public bool ShortcutConfigurable {
            get { return (bool) interceptor.Invoke("isShortcutConfigurable", "isShortcutConfigurable()", typeof(bool)); }
            set { interceptor.Invoke("setShortcutConfigurable$", "setShortcutConfigurable(bool)", typeof(void), typeof(bool), value); }
        }
        [Q_PROPERTY("KShortcut", "globalShortcut")]
        public KShortcut GlobalShortcut {
            get { return (KShortcut) interceptor.Invoke("globalShortcut", "globalShortcut()", typeof(KShortcut)); }
            set { interceptor.Invoke("setGlobalShortcut#", "setGlobalShortcut(KShortcut)", typeof(void), typeof(KShortcut), value); }
        }
        [Q_PROPERTY("bool", "globalShortcutAllowed")]
        public bool GlobalShortcutAllowed {
            get { return (bool) interceptor.Invoke("globalShortcutAllowed", "globalShortcutAllowed()", typeof(bool)); }
            set { interceptor.Invoke("setGlobalShortcutAllowed$", "setGlobalShortcutAllowed(bool)", typeof(void), typeof(bool), value); }
        }
        [Q_PROPERTY("bool", "globalShortcutEnabled")]
        public bool GlobalShortcutEnabled {
            get { return (bool) interceptor.Invoke("isGlobalShortcutEnabled", "isGlobalShortcutEnabled()", typeof(bool)); }
        }
        /// <remarks>
        ///  Constructs an action.
        ///      </remarks>        <short>    Constructs an action.</short>
        public KAction(QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KAction#", "KAction(QObject*)", typeof(void), typeof(QObject), parent);
        }
        /// <remarks>
        ///  Constructs an action with the specified parent and visible text.
        /// <param> name="text" The visible text for this action.
        /// </param><param> name="parent" The parent for this action.
        ///      </param></remarks>        <short>    Constructs an action with the specified parent and visible text.</short>
        public KAction(string text, QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KAction$#", "KAction(const QString&, QObject*)", typeof(void), typeof(string), text, typeof(QObject), parent);
        }
        /// <remarks>
        ///  Constructs an action with text and icon; a shortcut may be specified by
        ///  the ampersand character (e.g. \"&amp;Option\" creates a shortcut with key \e O )
        ///  This is the other common KAction constructor used.  Use it when you
        ///  \e do have a corresponding icon.
        /// <param> name="icon" The icon to display.
        /// </param><param> name="text" The text that will be displayed.
        /// </param><param> name="parent" The parent for this action.
        ///      </param></remarks>        <short>    Constructs an action with text and icon; a shortcut may be specified by  the ampersand character (e.</short>
        public KAction(KIcon icon, string text, QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KAction#$#", "KAction(const KIcon&, const QString&, QObject*)", typeof(void), typeof(KIcon), icon, typeof(string), text, typeof(QObject), parent);
        }
        /// <remarks>
        ///  Get the shortcut for this action.
        ///  This is preferred over QAction.Shortcut(), as it allows for multiple shortcuts
        ///  per action. The first and second shortcut as reported by shortcuts() will be the
        ///  primary and alternate shortcut of the shortcut returned.
        ///  \param types the type of shortcut to return. Should both be specified, only the
        ///              active shortcut will be returned. Defaults to the active shortcut, if one exists.
        ///  \sa shortcuts()
        ///      </remarks>        <short>    Get the shortcut for this action.</short>
        public KShortcut shortcut(uint types) {
            return (KShortcut) interceptor.Invoke("shortcut$", "shortcut(KAction::ShortcutTypes) const", typeof(KShortcut), typeof(uint), types);
        }
        public KShortcut shortcut() {
            return (KShortcut) interceptor.Invoke("shortcut", "shortcut() const", typeof(KShortcut));
        }
        /// <remarks>
        ///  Set the shortcut for this action.
        ///  This is preferred over QAction.SetShortcut(), as it allows for multiple shortcuts
        ///  per action.
        ///  \param shortcut shortcut(s) to use for this action in its specified shortcutContext()
        ///  \param type type of shortcut to be set: active shortcut,
        ///   default shortcut, or both (the default).
        ///      </remarks>        <short>    Set the shortcut for this action.</short>
        public void SetShortcut(KShortcut shortcut, uint type) {
            interceptor.Invoke("setShortcut#$", "setShortcut(const KShortcut&, KAction::ShortcutTypes)", typeof(void), typeof(KShortcut), shortcut, typeof(uint), type);
        }
        public void SetShortcut(KShortcut shortcut) {
            interceptor.Invoke("setShortcut#", "setShortcut(const KShortcut&)", typeof(void), typeof(KShortcut), shortcut);
        }
        /// <remarks>
        ///  \overload void setShortcut(KShortcut shortcut)
        ///  Set the primary shortcut only for this action.
        ///  This function is there to explicitly override QAction.SetShortcut(QKeySequence).
        ///  QAction.SetShortcut() will bypass everything in KAction and may lead to unexpected behavior.
        ///  \param shortcut shortcut(s) to use for this action in its specified shortcutContext()
        ///  \param type type of shortcut to be set: active shortcut,
        ///   default shortcut, or both (default argument value).
        ///      </remarks>        <short>    \overload void setShortcut(KShortcut shortcut) </short>
        public void SetShortcut(QKeySequence shortcut, uint type) {
            interceptor.Invoke("setShortcut#$", "setShortcut(const QKeySequence&, KAction::ShortcutTypes)", typeof(void), typeof(QKeySequence), shortcut, typeof(uint), type);
        }
        public void SetShortcut(QKeySequence shortcut) {
            interceptor.Invoke("setShortcut#", "setShortcut(const QKeySequence&)", typeof(void), typeof(QKeySequence), shortcut);
        }
        /// <remarks>
        ///  \overload void setShortcuts(const QList\<QKeySequence\>& shortcuts).
        ///  Set the shortcuts for this action.
        ///  This function is there to explicitly override QAction.SetShortcut(const QList\<QKeySequence\>&).
        ///  QAction.SetShortcuts() will bypass everything in KAction and may lead to unexpected behavior.
        ///  \param shortcut shortcut(s) to use for this action in its specified shortcutContext()
        ///  \param type type of shortcut to be set: active shortcut,
        ///   default shortcut, or both (default argument value).
        ///      </remarks>        <short>    \overload void setShortcuts(const QList\<QKeySequence\>& shortcuts).</short>
        public void SetShortcuts(List<QKeySequence> shortcuts, uint type) {
            interceptor.Invoke("setShortcuts?$", "setShortcuts(const QList<QKeySequence>&, KAction::ShortcutTypes)", typeof(void), typeof(List<QKeySequence>), shortcuts, typeof(uint), type);
        }
        public new void SetShortcuts(List<QKeySequence> shortcuts) {
            interceptor.Invoke("setShortcuts?", "setShortcuts(const QList<QKeySequence>&)", typeof(void), typeof(List<QKeySequence>), shortcuts);
        }
        /// <remarks>
        ///  Get the global shortcut for this action, if one exists. Global shortcuts
        ///  allow your actions to respond to accellerators independently of the focused window.
        ///  Unlike regular shortcuts, the application's window does not need focus
        ///  for them to be activated.
        ///  \param type the type of shortcut to be returned. Should both be specified, only the
        ///              active shortcut will be returned.  Defaults to the active shortcut,
        ///              if one exists.
        ///  \sa KGlobalAccel
        ///  \sa setGlobalShortcut()
        ///      </remarks>        <short>    Get the global shortcut for this action, if one exists.</short>
        public KShortcut globalShortcut(uint type) {
            return (KShortcut) interceptor.Invoke("globalShortcut$", "globalShortcut(KAction::ShortcutTypes) const", typeof(KShortcut), typeof(uint), type);
        }
        public KShortcut globalShortcut() {
            return (KShortcut) interceptor.Invoke("globalShortcut", "globalShortcut() const", typeof(KShortcut));
        }
        /// <remarks>
        ///  Assign a global shortcut for this action. Global shortcuts
        ///  allow an action to respond to key shortcuts independently of the focused window,
        ///  i.e. the action will trigger if the keys were pressed no matter where in the X session.
        ///  The action must have a per main component unique
        ///  objectName() to enable cross-application bookeeping. If the objectName() is empty this method will
        ///  do nothing, otherwise the isGlobalShortcutEnabled() property will be set to true and the 
        ///  shortcut will be enabled.
        ///  It is mandatory that the objectName() doesn't change once isGlobalshortcutEnabled()
        ///  has become true.
        ///  <b>Note:<> KActionCollection.Insert(name, action) will set action's objectName to name so you often
        ///  don't have to set an objectName explicitly.
        ///  When an action, identified by main component name and objectName(), is assigned
        ///  a global shortcut for the first time on a KDE installation the assignment will
        ///  be saved. The shortcut will then be restored every time setGlobalShortcut() is
        ///  called with <code>loading</code> == Autoloading.
        ///  If you actually want to change the global shortcut you have to set
        ///  <code>loading</code> to NoAutoloading. The new shortcut will be automatically saved again.
        ///  \param shortcut global shortcut(s) to assign. Will be ignored unless <pre>loading</pre> is set to NoAutoloading or this is the first time ever you call this method (see above).
        ///  \param type the type of shortcut to be set, whether the active shortcut, the default shortcut,
        ///              or both (the default).
        ///  \param loading if Autoloading, assign the global shortcut this action has previously had if any.
        ///                    That way user preferences and changes made to avoid clashes will be conserved.
        ///                 if NoAutoloading the given shortcut will be assigned without looking up old values.
        ///                    You should only do this if the user wants to change the shortcut or if you have
        ///                    another very good reason. Key combinations that clash with other shortcuts will be
        ///                    dropped.
        ///  <b>Note:<> the default shortcut will never be influenced by autoloading - it will be set as given.
        ///  \sa globalShortcut()
        ///      </remarks>        <short>    Assign a global shortcut for this action.</short>
        public void SetGlobalShortcut(KShortcut shortcut, uint type, KAction.GlobalShortcutLoading loading) {
            interceptor.Invoke("setGlobalShortcut#$$", "setGlobalShortcut(const KShortcut&, KAction::ShortcutTypes, KAction::GlobalShortcutLoading)", typeof(void), typeof(KShortcut), shortcut, typeof(uint), type, typeof(KAction.GlobalShortcutLoading), loading);
        }
        public void SetGlobalShortcut(KShortcut shortcut, uint type) {
            interceptor.Invoke("setGlobalShortcut#$", "setGlobalShortcut(const KShortcut&, KAction::ShortcutTypes)", typeof(void), typeof(KShortcut), shortcut, typeof(uint), type);
        }
        public void SetGlobalShortcut(KShortcut shortcut) {
            interceptor.Invoke("setGlobalShortcut#", "setGlobalShortcut(const KShortcut&)", typeof(void), typeof(KShortcut), shortcut);
        }
        /// <remarks>
        ///  Sets the globalShortcutEnabled property to false and sets the global shortcut to an
        ///  empty shortcut.
        ///  This will also wipe out knowlegde about the existence of this action's global shorctut
        ///  so it will not be considered anymore for shortcut conflict resolution. It will also not be
        ///  visible anymore in the shortcuts KControl module.
        ///  This method should not be used unless these effects are explicitly desired.
        /// </remarks>        <short>    Sets the globalShortcutEnabled property to false and sets the global shortcut to an  empty shortcut.</short>
        public void ForgetGlobalShortcut() {
            interceptor.Invoke("forgetGlobalShortcut", "forgetGlobalShortcut()", typeof(void));
        }
        public KShapeGesture ShapeGesture(uint type) {
            return (KShapeGesture) interceptor.Invoke("shapeGesture$", "shapeGesture(KAction::ShortcutTypes) const", typeof(KShapeGesture), typeof(uint), type);
        }
        public KShapeGesture ShapeGesture() {
            return (KShapeGesture) interceptor.Invoke("shapeGesture", "shapeGesture() const", typeof(KShapeGesture));
        }
        public KRockerGesture RockerGesture(uint type) {
            return (KRockerGesture) interceptor.Invoke("rockerGesture$", "rockerGesture(KAction::ShortcutTypes) const", typeof(KRockerGesture), typeof(uint), type);
        }
        public KRockerGesture RockerGesture() {
            return (KRockerGesture) interceptor.Invoke("rockerGesture", "rockerGesture() const", typeof(KRockerGesture));
        }
        public void SetShapeGesture(KShapeGesture gest, uint type) {
            interceptor.Invoke("setShapeGesture#$", "setShapeGesture(const KShapeGesture&, KAction::ShortcutTypes)", typeof(void), typeof(KShapeGesture), gest, typeof(uint), type);
        }
        public void SetShapeGesture(KShapeGesture gest) {
            interceptor.Invoke("setShapeGesture#", "setShapeGesture(const KShapeGesture&)", typeof(void), typeof(KShapeGesture), gest);
        }
        public void SetRockerGesture(KRockerGesture gest, uint type) {
            interceptor.Invoke("setRockerGesture#$", "setRockerGesture(const KRockerGesture&, KAction::ShortcutTypes)", typeof(void), typeof(KRockerGesture), gest, typeof(uint), type);
        }
        public void SetRockerGesture(KRockerGesture gest) {
            interceptor.Invoke("setRockerGesture#", "setRockerGesture(const KRockerGesture&)", typeof(void), typeof(KRockerGesture), gest);
        }
        ~KAction() {
            interceptor.Invoke("~KAction", "~KAction()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~KAction", "~KAction()", typeof(void));
        }
        protected new IKActionSignals Emit {
            get { return (IKActionSignals) Q_EMIT; }
        }
    }

    public interface IKActionSignals : IQWidgetActionSignals {
        /// <remarks>
        ///  Emitted when the action is triggered. Also provides the state of the
        ///  keyboard modifiers and mouse buttons at the time.
        ///      </remarks>        <short>    Emitted when the action is triggered.</short>
        [Q_SIGNAL("void triggered(Qt::MouseButtons, Qt::KeyboardModifiers)")]
        void Triggered(uint buttons, uint modifiers);
    }
}
