//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    /// <remarks>
    ///  \brief Utility class that draws a row of stars for a rating value.
    ///  The KRatingPainter also allows to determine a rating value from
    ///  a position in the draw area. it supports all different alignments
    ///  and custom icons.
    ///  For showing a rating in a widget see KRatingWidget.
    ///  \author Sebastian Trueg <trueg@kde.org>
    ///  \since 4.1
    ///  </remarks>        <short>    \brief Utility class that draws a row of stars for a rating value.</short>
    [SmokeClass("KRatingPainter")]
    public class KRatingPainter : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected KRatingPainter(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KRatingPainter), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static KRatingPainter() {
            staticInterceptor = new SmokeInvocation(typeof(KRatingPainter), null);
        }
        /// <remarks>
        ///  Create a new KRatingPainter.
        ///  For most cases the static methods paintRating and getRatingFromPosition
        ///  should be sufficient.
        ///      </remarks>        <short>    Create a new KRatingPainter.</short>
        public KRatingPainter() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KRatingPainter", "KRatingPainter()", typeof(void));
        }
        /// <remarks>
        ///  The maximum rating, i.e. how many stars are drawn
        ///  in total.
        ///  \sa setMaxRating
        ///      </remarks>        <short>    The maximum rating, i.</short>
        public int MaxRating() {
            return (int) interceptor.Invoke("maxRating", "maxRating() const", typeof(int));
        }
        /// <remarks>
        ///  If half steps are enabled one star equals to 2 rating
        ///  points and uneven rating values result in half-stars being
        ///  drawn.
        ///  \sa setHalfStepsEnabled
        ///      </remarks>        <short>    If half steps are enabled one star equals to 2 rating  points and uneven rating values result in half-stars being  drawn.</short>
        public bool HalfStepsEnabled() {
            return (bool) interceptor.Invoke("halfStepsEnabled", "halfStepsEnabled() const", typeof(bool));
        }
        /// <remarks>
        ///  The alignment of the stars.
        ///  \sa setAlignment
        ///      </remarks>        <short>    The alignment of the stars.</short>
        public uint Alignment() {
            return (uint) interceptor.Invoke("alignment", "alignment() const", typeof(uint));
        }
        /// <remarks>
        ///  The layout direction. If RTL the stars
        ///  representing the rating value will be drawn from the 
        ///  right.
        ///  \sa setLayoutDirection
        ///      </remarks>        <short>    The layout direction.</short>
        public Qt.LayoutDirection LayoutDirection() {
            return (Qt.LayoutDirection) interceptor.Invoke("layoutDirection", "layoutDirection() const", typeof(Qt.LayoutDirection));
        }
        /// <remarks>
        ///  The icon used to draw a star. In case a custom pixmap has been set
        ///  this value is ignored.
        ///  \sa setIcon, setCustomPixmap
        ///      </remarks>        <short>    The icon used to draw a star.</short>
        public QIcon Icon() {
            return (QIcon) interceptor.Invoke("icon", "icon() const", typeof(QIcon));
        }
        /// <remarks>
        ///  The rating can be painted in a disabled state where no color
        ///  is used and hover ratings are ignored.
        ///  \sa setEnabled
        ///      </remarks>        <short>    The rating can be painted in a disabled state where no color  is used and hover ratings are ignored.</short>
        public bool IsEnabled() {
            return (bool) interceptor.Invoke("isEnabled", "isEnabled() const", typeof(bool));
        }
        /// <remarks>
        ///  The custom pixmap set to draw a star. If no custom
        ///  pixmap has been set, an invalid pixmap is returned.
        ///  \sa setCustomPixmap
        ///      </remarks>        <short>    The custom pixmap set to draw a star.</short>
        public QPixmap CustomPixmap() {
            return (QPixmap) interceptor.Invoke("customPixmap", "customPixmap() const", typeof(QPixmap));
        }
        /// <remarks>
        ///  The spacing between rating pixmaps.
        ///  \sa setSpacing
        ///      </remarks>        <short>    The spacing between rating pixmaps.</short>
        public int Spacing() {
            return (int) interceptor.Invoke("spacing", "spacing() const", typeof(int));
        }
        /// <remarks>
        ///  The maximum rating. Defaults to 10.
        ///      </remarks>        <short>    The maximum rating.</short>
        public void SetMaxRating(int max) {
            interceptor.Invoke("setMaxRating$", "setMaxRating(int)", typeof(void), typeof(int), max);
        }
        /// <remarks>
        ///  If half steps are enabled (the default) then
        ///  one rating step corresponds to half a star.
        ///      </remarks>        <short>    If half steps are enabled (the default) then  one rating step corresponds to half a star.</short>
        public void SetHalfStepsEnabled(bool enabled) {
            interceptor.Invoke("setHalfStepsEnabled$", "setHalfStepsEnabled(bool)", typeof(void), typeof(bool), enabled);
        }
        /// <remarks>
        ///  The alignment of the stars in the drawing rect.
        ///  All alignment flags are supported.
        ///      </remarks>        <short>    The alignment of the stars in the drawing rect.</short>
        public void SetAlignment(uint align) {
            interceptor.Invoke("setAlignment$", "setAlignment(Qt::Alignment)", typeof(void), typeof(uint), align);
        }
        /// <remarks>
        ///  LTR or RTL
        ///      </remarks>        <short>    LTR or RTL      </short>
        public void SetLayoutDirection(Qt.LayoutDirection direction) {
            interceptor.Invoke("setLayoutDirection$", "setLayoutDirection(Qt::LayoutDirection)", typeof(void), typeof(Qt.LayoutDirection), direction);
        }
        /// <remarks>
        ///  Set a custom icon. Defaults to "rating".
        ///      </remarks>        <short>    Set a custom icon.</short>
        public void SetIcon(QIcon icon) {
            interceptor.Invoke("setIcon#", "setIcon(const QIcon&)", typeof(void), typeof(QIcon), icon);
        }
        /// <remarks>
        ///  Enable or disable the rating. Default is enabled.
        ///      </remarks>        <short>    Enable or disable the rating.</short>
        public void SetEnabled(bool enabled) {
            interceptor.Invoke("setEnabled$", "setEnabled(bool)", typeof(void), typeof(bool), enabled);
        }
        /// <remarks>
        ///  Set a custom pixmap.
        ///      </remarks>        <short>    Set a custom pixmap.</short>
        public void SetCustomPixmap(QPixmap pixmap) {
            interceptor.Invoke("setCustomPixmap#", "setCustomPixmap(const QPixmap&)", typeof(void), typeof(QPixmap), pixmap);
        }
        /// <remarks>
        ///  Set the spacing between rating pixmaps. Be aware that
        ///  for justified horizontal alignment this values may be
        ///  ignored.
        ///      </remarks>        <short>    Set the spacing between rating pixmaps.</short>
        public void SetSpacing(int spacing) {
            interceptor.Invoke("setSpacing$", "setSpacing(int)", typeof(void), typeof(int), spacing);
        }
        /// <remarks>
        ///  Draw the rating.
        ///  \param painter The painter to draw the rating to.
        ///  \param rect The geometry of the rating. The alignment of the rating is used relative
        ///              to this value.
        ///  \param rating The actual rating value to draw.
        ///  \param hoverRating The hover rating indicates the position the user hovers the mouse
        ///                     pointer at. This will provide visual feedback about the new rating
        ///                     if the user would actually click as well as the difference to the
        ///                     current rating.
        ///      </remarks>        <short>    Draw the rating.</short>
        public void Paint(QPainter painter, QRect rect, int rating, int hoverRating) {
            interceptor.Invoke("paint##$$", "paint(QPainter*, const QRect&, int, int) const", typeof(void), typeof(QPainter), painter, typeof(QRect), rect, typeof(int), rating, typeof(int), hoverRating);
        }
        public void Paint(QPainter painter, QRect rect, int rating) {
            interceptor.Invoke("paint##$", "paint(QPainter*, const QRect&, int) const", typeof(void), typeof(QPainter), painter, typeof(QRect), rect, typeof(int), rating);
        }
        /// <remarks>
        ///  Calculate the rating value from mouse position pos.
        ///  \return The rating corresponding to pos or -1 if pos is
        ///  outside of the configured rect.
        ///      </remarks>        <short>    Calculate the rating value from mouse position pos.</short>
        public int RatingFromPosition(QRect rect, QPoint pos) {
            return (int) interceptor.Invoke("ratingFromPosition##", "ratingFromPosition(const QRect&, const QPoint&) const", typeof(int), typeof(QRect), rect, typeof(QPoint), pos);
        }
        ~KRatingPainter() {
            interceptor.Invoke("~KRatingPainter", "~KRatingPainter()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~KRatingPainter", "~KRatingPainter()", typeof(void));
        }
        /// <remarks>
        ///  Convenience method that paints a rating into the given rect.
        ///  LayoutDirection is read from QPainter.
        ///  \param align can be aligned vertically and horizontally. Using Qt.AlignJustify will insert spacing
        ///  between the stars.
        ///      </remarks>        <short>    Convenience method that paints a rating into the given rect.</short>
        public static void PaintRating(QPainter p, QRect rect, uint align, int rating, int hoverRating) {
            staticInterceptor.Invoke("paintRating##$$$", "paintRating(QPainter*, const QRect&, Qt::Alignment, int, int)", typeof(void), typeof(QPainter), p, typeof(QRect), rect, typeof(uint), align, typeof(int), rating, typeof(int), hoverRating);
        }
        public static void PaintRating(QPainter p, QRect rect, uint align, int rating) {
            staticInterceptor.Invoke("paintRating##$$", "paintRating(QPainter*, const QRect&, Qt::Alignment, int)", typeof(void), typeof(QPainter), p, typeof(QRect), rect, typeof(uint), align, typeof(int), rating);
        }
        /// <remarks>
        ///  Get the rating that would be selected if the user clicked position pos
        ///  within rect if the rating has been drawn with paintRating() using the same
        ///  rect and align values.
        ///  \return The new rating or -1 if pos is outside of the rating area.
        ///      </remarks>        <short>    Get the rating that would be selected if the user clicked position pos  within rect if the rating has been drawn with paintRating() using the same  rect and align values.</short>
        public static int GetRatingFromPosition(QRect rect, uint align, Qt.LayoutDirection direction, QPoint pos) {
            return (int) staticInterceptor.Invoke("getRatingFromPosition#$$#", "getRatingFromPosition(const QRect&, Qt::Alignment, Qt::LayoutDirection, const QPoint&)", typeof(int), typeof(QRect), rect, typeof(uint), align, typeof(Qt.LayoutDirection), direction, typeof(QPoint), pos);
        }
    }
}
