#ifndef __SMBDEFS_H__
#define __SMBDEFS_H__

#include <inttypes.h>

typedef uint32_t uint32;
typedef uint8_t uint8;

/* Security Access Masks Rights */

#define SPECIFIC_RIGHTS_MASK	0x0000FFFF
#define STANDARD_RIGHTS_MASK	0x00FF0000
#define GENERIC_RIGHTS_MASK	0xF0000000

#define SEC_RIGHT_SYSTEM_SECURITY	0x01000000
#define SEC_RIGHT_MAXIMUM_ALLOWED	0x02000000

/* Generic access rights */

#define GENERIC_RIGHT_ALL_ACCESS	0x10000000
#define GENERIC_RIGHT_EXECUTE_ACCESS	0x20000000
#define GENERIC_RIGHT_WRITE_ACCESS	0x40000000
#define GENERIC_RIGHT_READ_ACCESS	0x80000000

/* Standard access rights. */

#define STD_RIGHT_DELETE_ACCESS		0x00010000
#define STD_RIGHT_READ_CONTROL_ACCESS	0x00020000
#define STD_RIGHT_WRITE_DAC_ACCESS	0x00040000
#define STD_RIGHT_WRITE_OWNER_ACCESS	0x00080000
#define STD_RIGHT_SYNCHRONIZE_ACCESS	0x00100000

#define STD_RIGHT_ALL_ACCESS		0x001F0000

/* Combinations of standard masks. */
#define STANDARD_RIGHTS_ALL_ACCESS	STD_RIGHT_ALL_ACCESS /* 0x001f0000 */
#define STANDARD_RIGHTS_MODIFY_ACCESS	STD_RIGHT_READ_CONTROL_ACCESS /* 0x00020000 */
#define STANDARD_RIGHTS_EXECUTE_ACCESS	STD_RIGHT_READ_CONTROL_ACCESS /* 0x00020000 */
#define STANDARD_RIGHTS_READ_ACCESS	STD_RIGHT_READ_CONTROL_ACCESS /* 0x00020000 */
#define STANDARD_RIGHTS_WRITE_ACCESS \
		(STD_RIGHT_WRITE_OWNER_ACCESS	| \
		 STD_RIGHT_WRITE_DAC_ACCESS	| \
		 STD_RIGHT_DELETE_ACCESS)	/* 0x000d0000 */
#define STANDARD_RIGHTS_REQUIRED_ACCESS \
		(STD_RIGHT_DELETE_ACCESS	| \
		STD_RIGHT_READ_CONTROL_ACCESS	| \
		STD_RIGHT_WRITE_DAC_ACCESS	| \
		STD_RIGHT_WRITE_OWNER_ACCESS)	/* 0x000f0000 */

/* File Object specific access rights */

#define SA_RIGHT_FILE_READ_DATA		0x00000001
#define SA_RIGHT_FILE_WRITE_DATA	0x00000002
#define SA_RIGHT_FILE_APPEND_DATA	0x00000004
#define SA_RIGHT_FILE_READ_EA		0x00000008
#define SA_RIGHT_FILE_WRITE_EA		0x00000010
#define SA_RIGHT_FILE_EXECUTE		0x00000020
#define SA_RIGHT_FILE_DELETE_CHILD	0x00000040
#define SA_RIGHT_FILE_READ_ATTRIBUTES	0x00000080
#define SA_RIGHT_FILE_WRITE_ATTRIBUTES	0x00000100

#define SA_RIGHT_FILE_ALL_ACCESS	0x000001FF

#define GENERIC_RIGHTS_FILE_ALL_ACCESS \
		(STANDARD_RIGHTS_REQUIRED_ACCESS| \
		STD_RIGHT_SYNCHRONIZE_ACCESS	| \
		SA_RIGHT_FILE_ALL_ACCESS)

#define GENERIC_RIGHTS_FILE_READ	\
		(STANDARD_RIGHTS_READ_ACCESS	| \
		STD_RIGHT_SYNCHRONIZE_ACCESS	| \
		SA_RIGHT_FILE_READ_DATA		| \
		SA_RIGHT_FILE_READ_ATTRIBUTES	| \
		SA_RIGHT_FILE_READ_EA)

#define GENERIC_RIGHTS_FILE_WRITE \
		(STANDARD_RIGHTS_WRITE_ACCESS	| \
		STD_RIGHT_SYNCHRONIZE_ACCESS	| \
		SA_RIGHT_FILE_WRITE_DATA	| \
		SA_RIGHT_FILE_WRITE_ATTRIBUTES	| \
		SA_RIGHT_FILE_WRITE_EA		| \
		SA_RIGHT_FILE_APPEND_DATA)

#define GENERIC_RIGHTS_FILE_EXECUTE \
		(STANDARD_RIGHTS_EXECUTE_ACCESS	| \
		STD_RIGHT_SYNCHRONIZE_ACCESS	| \
		SA_RIGHT_FILE_READ_ATTRIBUTES	| \
		SA_RIGHT_FILE_EXECUTE)            

#define GENERIC_RIGHTS_FILE_MODIFY \
		(STANDARD_RIGHTS_MODIFY_ACCESS	| \
		STD_RIGHT_SYNCHRONIZE_ACCESS	| \
		STD_RIGHT_DELETE_ACCESS		| \
		SA_RIGHT_FILE_WRITE_ATTRIBUTES	| \
		SA_RIGHT_FILE_READ_ATTRIBUTES	| \
		SA_RIGHT_FILE_EXECUTE		| \
		SA_RIGHT_FILE_WRITE_EA		| \
		SA_RIGHT_FILE_READ_EA		| \
		SA_RIGHT_FILE_APPEND_DATA	| \
		SA_RIGHT_FILE_WRITE_DATA	| \
		SA_RIGHT_FILE_READ_DATA)

/* SAM server specific access rights */

#define SA_RIGHT_SAM_CONNECT_SERVER	0x00000001
#define SA_RIGHT_SAM_SHUTDOWN_SERVER	0x00000002
#define SA_RIGHT_SAM_INITIALISE_SERVER	0x00000004
#define SA_RIGHT_SAM_CREATE_DOMAIN	0x00000008
#define SA_RIGHT_SAM_ENUM_DOMAINS	0x00000010
#define SA_RIGHT_SAM_OPEN_DOMAIN	0x00000020

#define SA_RIGHT_SAM_ALL_ACCESS		0x0000003F

#define GENERIC_RIGHTS_SAM_ALL_ACCESS \
		(STANDARD_RIGHTS_REQUIRED_ACCESS| \
		SA_RIGHT_SAM_ALL_ACCESS)

#define GENERIC_RIGHTS_SAM_READ	\
		(STANDARD_RIGHTS_READ_ACCESS	| \
		SA_RIGHT_SAM_ENUM_DOMAINS)

#define GENERIC_RIGHTS_SAM_WRITE \
		(STANDARD_RIGHTS_WRITE_ACCESS	| \
		SA_RIGHT_SAM_CREATE_DOMAIN	| \
		SA_RIGHT_SAM_INITIALISE_SERVER	| \
		SA_RIGHT_SAM_SHUTDOWN_SERVER)

#define GENERIC_RIGHTS_SAM_EXECUTE \
		(STANDARD_RIGHTS_EXECUTE_ACCESS	| \
		SA_RIGHT_SAM_OPEN_DOMAIN	| \
		SA_RIGHT_SAM_CONNECT_SERVER)            


/* Domain Object specific access rights */

#define SA_RIGHT_DOMAIN_LOOKUP_INFO_1		0x00000001
#define SA_RIGHT_DOMAIN_SET_INFO_1		0x00000002
#define SA_RIGHT_DOMAIN_LOOKUP_INFO_2		0x00000004
#define SA_RIGHT_DOMAIN_SET_INFO_2		0x00000008
#define SA_RIGHT_DOMAIN_CREATE_USER		0x00000010
#define SA_RIGHT_DOMAIN_CREATE_GROUP		0x00000020
#define SA_RIGHT_DOMAIN_CREATE_ALIAS		0x00000040
#define SA_RIGHT_DOMAIN_LOOKUP_ALIAS_BY_MEM	0x00000080
#define SA_RIGHT_DOMAIN_ENUM_ACCOUNTS		0x00000100
#define SA_RIGHT_DOMAIN_OPEN_ACCOUNT		0x00000200
#define SA_RIGHT_DOMAIN_SET_INFO_3		0x00000400

#define SA_RIGHT_DOMAIN_ALL_ACCESS		0x000007FF

#define GENERIC_RIGHTS_DOMAIN_ALL_ACCESS \
		(STANDARD_RIGHTS_REQUIRED_ACCESS| \
		SA_RIGHT_DOMAIN_ALL_ACCESS)

#define GENERIC_RIGHTS_DOMAIN_READ \
		(STANDARD_RIGHTS_READ_ACCESS		| \
		SA_RIGHT_DOMAIN_LOOKUP_ALIAS_BY_MEM	| \
		SA_RIGHT_DOMAIN_LOOKUP_INFO_2)

#define GENERIC_RIGHTS_DOMAIN_WRITE \
		(STANDARD_RIGHTS_WRITE_ACCESS	| \
		SA_RIGHT_DOMAIN_SET_INFO_3	| \
		SA_RIGHT_DOMAIN_CREATE_ALIAS	| \
		SA_RIGHT_DOMAIN_CREATE_GROUP	| \
		SA_RIGHT_DOMAIN_CREATE_USER	| \
		SA_RIGHT_DOMAIN_SET_INFO_2	| \
		SA_RIGHT_DOMAIN_SET_INFO_1)

#define GENERIC_RIGHTS_DOMAIN_EXECUTE \
		(STANDARD_RIGHTS_EXECUTE_ACCESS	| \
		SA_RIGHT_DOMAIN_OPEN_ACCOUNT	| \
		SA_RIGHT_DOMAIN_ENUM_ACCOUNTS	| \
		SA_RIGHT_DOMAIN_LOOKUP_INFO_1)            


/* User Object specific access rights */

#define SA_RIGHT_USER_GET_NAME_ETC	0x00000001
#define SA_RIGHT_USER_GET_LOCALE	0x00000002
#define SA_RIGHT_USER_SET_LOC_COM	0x00000004
#define SA_RIGHT_USER_GET_LOGONINFO	0x00000008
#define SA_RIGHT_USER_ACCT_FLAGS_EXPIRY	0x00000010
#define SA_RIGHT_USER_SET_ATTRIBUTES	0x00000020
#define SA_RIGHT_USER_CHANGE_PASSWORD	0x00000040
#define SA_RIGHT_USER_SET_PASSWORD	0x00000080
#define SA_RIGHT_USER_GET_GROUPS	0x00000100
#define SA_RIGHT_USER_READ_GROUP_MEM	0x00000200
#define SA_RIGHT_USER_CHANGE_GROUP_MEM	0x00000400

#define SA_RIGHT_USER_ALL_ACCESS	0x000007FF

#define GENERIC_RIGHTS_USER_ALL_ACCESS \
		(STANDARD_RIGHTS_REQUIRED_ACCESS| \
		SA_RIGHT_USER_ALL_ACCESS)	/* 0x000f07ff */

#define GENERIC_RIGHTS_USER_READ \
		(STANDARD_RIGHTS_READ_ACCESS	| \
		SA_RIGHT_USER_READ_GROUP_MEM	| \
		SA_RIGHT_USER_GET_GROUPS	| \
		SA_RIGHT_USER_ACCT_FLAGS_EXPIRY	| \
		SA_RIGHT_USER_GET_LOGONINFO	| \
		SA_RIGHT_USER_GET_LOCALE)	/* 0x0002031a */

#define GENERIC_RIGHTS_USER_WRITE \
		(STANDARD_RIGHTS_WRITE_ACCESS	| \
		SA_RIGHT_USER_CHANGE_PASSWORD	| \
		SA_RIGHT_USER_SET_LOC_COM	| \
		SA_RIGHT_USER_SET_ATTRIBUTES	| \
		SA_RIGHT_USER_SET_PASSWORD	| \
		SA_RIGHT_USER_CHANGE_GROUP_MEM)	/* 0x000204e4 */

#define GENERIC_RIGHTS_USER_EXECUTE \
		(STANDARD_RIGHTS_EXECUTE_ACCESS	| \
		SA_RIGHT_USER_CHANGE_PASSWORD	| \
		SA_RIGHT_USER_GET_NAME_ETC )	/* 0x00020041 */


/* Group Object specific access rights */

#define SA_RIGHT_GROUP_LOOKUP_INFO	0x00000001
#define SA_RIGHT_GROUP_SET_INFO		0x00000002
#define SA_RIGHT_GROUP_ADD_MEMBER	0x00000004
#define SA_RIGHT_GROUP_REMOVE_MEMBER	0x00000008
#define SA_RIGHT_GROUP_GET_MEMBERS	0x00000010

#define SA_RIGHT_GROUP_ALL_ACCESS	0x0000001F

#define GENERIC_RIGHTS_GROUP_ALL_ACCESS \
		(STANDARD_RIGHTS_REQUIRED_ACCESS| \
		SA_RIGHT_GROUP_ALL_ACCESS)	/* 0x000f001f */

#define GENERIC_RIGHTS_GROUP_READ \
		(STANDARD_RIGHTS_READ_ACCESS	| \
		SA_RIGHT_GROUP_GET_MEMBERS)	/* 0x00020010 */

#define GENERIC_RIGHTS_GROUP_WRITE \
		(STANDARD_RIGHTS_WRITE_ACCESS	| \
		SA_RIGHT_GROUP_REMOVE_MEMBER	| \
		SA_RIGHT_GROUP_ADD_MEMBER	| \
		SA_RIGHT_GROUP_SET_INFO )	/* 0x0002000e */

#define GENERIC_RIGHTS_GROUP_EXECUTE \
		(STANDARD_RIGHTS_EXECUTE_ACCESS	| \
		SA_RIGHT_GROUP_LOOKUP_INFO)	/* 0x00020001 */


/* Alias Object specific access rights */

#define SA_RIGHT_ALIAS_ADD_MEMBER	0x00000001
#define SA_RIGHT_ALIAS_REMOVE_MEMBER	0x00000002
#define SA_RIGHT_ALIAS_GET_MEMBERS	0x00000004
#define SA_RIGHT_ALIAS_LOOKUP_INFO	0x00000008
#define SA_RIGHT_ALIAS_SET_INFO		0x00000010

#define SA_RIGHT_ALIAS_ALL_ACCESS 	0x0000001F

#define GENERIC_RIGHTS_ALIAS_ALL_ACCESS \
		(STANDARD_RIGHTS_REQUIRED_ACCESS| \
		SA_RIGHT_ALIAS_ALL_ACCESS)	/* 0x000f001f */

#define GENERIC_RIGHTS_ALIAS_READ \
		(STANDARD_RIGHTS_READ_ACCESS	| \
		SA_RIGHT_ALIAS_GET_MEMBERS )	/* 0x00020004 */

#define GENERIC_RIGHTS_ALIAS_WRITE \
		(STANDARD_RIGHTS_WRITE_ACCESS	| \
		SA_RIGHT_ALIAS_REMOVE_MEMBER	| \
		SA_RIGHT_ALIAS_ADD_MEMBER	| \
		SA_RIGHT_ALIAS_SET_INFO )	/* 0x00020013 */

#define GENERIC_RIGHTS_ALIAS_EXECUTE \
		(STANDARD_RIGHTS_EXECUTE_ACCESS	| \
		SA_RIGHT_ALIAS_LOOKUP_INFO )	/* 0x00020008 */

/*
 * Acces bits for the svcctl objects
 */

/* Service Control Manager Bits */ 

#define SC_RIGHT_MGR_CONNECT			0x0001
#define SC_RIGHT_MGR_CREATE_SERVICE		0x0002
#define SC_RIGHT_MGR_ENUMERATE_SERVICE		0x0004
#define SC_RIGHT_MGR_LOCK			0x0008
#define SC_RIGHT_MGR_QUERY_LOCK_STATUS		0x0010
#define SC_RIGHT_MGR_MODIFY_BOOT_CONFIG		0x0020

#define SC_MANAGER_READ_ACCESS \
	( STANDARD_RIGHTS_READ_ACCESS		| \
	  SC_RIGHT_MGR_CONNECT			| \
	  SC_RIGHT_MGR_ENUMERATE_SERVICE	| \
	  SC_RIGHT_MGR_QUERY_LOCK_STATUS )

#define SC_MANAGER_EXECUTE_ACCESS SC_MANAGER_READ_ACCESS

#define SC_MANAGER_WRITE_ACCESS \
	( STANDARD_RIGHTS_REQUIRED_ACCESS	| \
	  SC_MANAGER_READ_ACCESS		| \
	  SC_RIGHT_MGR_CREATE_SERVICE		| \
	  SC_RIGHT_MGR_LOCK			| \
	  SC_RIGHT_MGR_MODIFY_BOOT_CONFIG )

#define SC_MANAGER_ALL_ACCESS SC_MANAGER_WRITE_ACCESS

/* Service Object Bits */ 

#define SC_RIGHT_SVC_QUERY_CONFIG		0x0001
#define SC_RIGHT_SVC_CHANGE_CONFIG		0x0002
#define SC_RIGHT_SVC_QUERY_STATUS		0x0004
#define SC_RIGHT_SVC_ENUMERATE_DEPENDENTS	0x0008
#define SC_RIGHT_SVC_START			0x0010
#define SC_RIGHT_SVC_STOP			0x0020
#define SC_RIGHT_SVC_PAUSE_CONTINUE		0x0040
#define SC_RIGHT_SVC_INTERROGATE		0x0080
#define SC_RIGHT_SVC_USER_DEFINED_CONTROL	0x0100

#define SERVICE_READ_ACCESS \
	( STANDARD_RIGHTS_READ_ACCESS		| \
	  SC_RIGHT_SVC_ENUMERATE_DEPENDENTS	| \
	  SC_RIGHT_SVC_INTERROGATE		| \
	  SC_RIGHT_SVC_QUERY_CONFIG		| \
	  SC_RIGHT_SVC_QUERY_STATUS		| \
	  SC_RIGHT_SVC_USER_DEFINED_CONTROL )

#define SERVICE_EXECUTE_ACCESS \
	( SERVICE_READ_ACCESS 			| \
	  SC_RIGHT_SVC_START			| \
	  SC_RIGHT_SVC_STOP			| \
	  SC_RIGHT_SVC_PAUSE_CONTINUE )

#define SERVICE_WRITE_ACCESS \
	( STANDARD_RIGHTS_REQUIRED_ACCESS	| \
	  SERVICE_READ_ACCESS			| \
	  SERVICE_EXECUTE_ACCESS		| \
	  SC_RIGHT_SVC_CHANGE_CONFIG )

#define SERVICE_ALL_ACCESS SERVICE_WRITE_ACCESS

	   

/*
 * Access Bits for registry ACLS
 */

/* used by registry ACLs */

#define SEC_RIGHTS_QUERY_VALUE		0x00000001
#define SEC_RIGHTS_SET_VALUE		0x00000002
#define SEC_RIGHTS_CREATE_SUBKEY	0x00000004
#define SEC_RIGHTS_ENUM_SUBKEYS		0x00000008
#define SEC_RIGHTS_NOTIFY		0x00000010
#define SEC_RIGHTS_CREATE_LINK		0x00000020
#define SEC_RIGHTS_MAXIMUM_ALLOWED	0x02000000


#define REG_KEY_READ \
	( STANDARD_RIGHTS_READ_ACCESS 		|\
	  SEC_RIGHTS_QUERY_VALUE 		|\
	  SEC_RIGHTS_ENUM_SUBKEYS 		|\
	  SEC_RIGHTS_NOTIFY )
	  
#define REG_KEY_EXECUTE	REG_KEY_READ

#define REG_KEY_WRITE \
	( STANDARD_RIGHTS_WRITE_ACCESS		|\
	  SEC_RIGHTS_SET_VALUE 			|\
	  SEC_RIGHTS_CREATE_SUBKEY )

#define REG_KEY_ALL \
	( STANDARD_RIGHTS_REQUIRED_ACCESS 	|\
	  REG_KEY_READ 				|\
	  REG_KEY_WRITE 			|\
	  SEC_RIGHTS_CREATE_LINK )

/* this defines the error codes that receive_smb can put in smb_read_error */
#define READ_TIMEOUT 1
#define READ_EOF 2
#define READ_ERROR 3
#define WRITE_ERROR 4 /* This error code can go into the client smb_rw_error. */
#define READ_BAD_SIG 5
#define DO_NOT_DO_TDIS 6 /* cli_close_connection() check for this when smbfs wants to keep tree connected */

#define DIR_STRUCT_SIZE 43

/* these define the attribute byte as seen by DOS */
#define aRONLY (1L<<0)		/* 0x01 */
#define aHIDDEN (1L<<1)		/* 0x02 */
#define aSYSTEM (1L<<2)		/* 0x04 */
#define aVOLID (1L<<3)		/* 0x08 */
#define aDIR (1L<<4)		/* 0x10 */
#define aARCH (1L<<5)		/* 0x20 */

/* deny modes */
#define DENY_DOS 0
#define DENY_ALL 1
#define DENY_WRITE 2
#define DENY_READ 3
#define DENY_NONE 4
#define DENY_FCB 7

/* open modes */
#define DOS_OPEN_RDONLY 0
#define DOS_OPEN_WRONLY 1
#define DOS_OPEN_RDWR 2
#define DOS_OPEN_EXEC 3
#define DOS_OPEN_FCB 0xF

/* define shifts and masks for share and open modes. */
#define OPENX_MODE_MASK 0xF
#define DENY_MODE_SHIFT 4
#define DENY_MODE_MASK 0x7
#define GET_OPENX_MODE(x) ((x) & OPENX_MODE_MASK)
#define SET_OPENX_MODE(x) ((x) & OPENX_MODE_MASK)
#define GET_DENY_MODE(x) (((x)>>DENY_MODE_SHIFT) & DENY_MODE_MASK)
#define SET_DENY_MODE(x) (((x) & DENY_MODE_MASK) <<DENY_MODE_SHIFT)

/* Sync on open file (not sure if used anymore... ?) */
#define FILE_SYNC_OPENMODE (1<<14)
#define GET_FILE_SYNC_OPENMODE(x) (((x) & FILE_SYNC_OPENMODE) ? True : False)

/* open disposition values */
#define OPENX_FILE_EXISTS_FAIL 0
#define OPENX_FILE_EXISTS_OPEN 1
#define OPENX_FILE_EXISTS_TRUNCATE 2

/* mask for open disposition. */
#define OPENX_FILE_OPEN_MASK 0x3

#define GET_FILE_OPENX_DISPOSITION(x) ((x) & FILE_OPEN_MASK)
#define SET_FILE_OPENX_DISPOSITION(x) ((x) & FILE_OPEN_MASK)

/* The above can be OR'ed with... */
#define OPENX_FILE_CREATE_IF_NOT_EXIST 0x10
#define OPENX_FILE_FAIL_IF_NOT_EXIST 0

/* File Specific access rights */
#define FILE_READ_DATA        0x00000001
#define FILE_WRITE_DATA       0x00000002
#define FILE_APPEND_DATA      0x00000004
#define FILE_READ_EA          0x00000008 /* File and directory */
#define FILE_WRITE_EA         0x00000010 /* File and directory */
#define FILE_EXECUTE          0x00000020
#define FILE_DELETE_CHILD     0x00000040
#define FILE_READ_ATTRIBUTES  0x00000080
#define FILE_WRITE_ATTRIBUTES 0x00000100

#define FILE_ALL_ACCESS       0x000001FF

/* Directory specific access rights */
#define FILE_LIST_DIRECTORY   0x00000001
#define FILE_ADD_FILE         0x00000002
#define FILE_ADD_SUBDIRECTORY 0x00000004
#define FILE_TRAVERSE         0x00000020
#define FILE_DELETE_CHILD     0x00000040

/* the desired access to use when opening a pipe */
#define DESIRED_ACCESS_PIPE 0x2019f
 
/* Generic access masks & rights. */
#define DELETE_ACCESS        0x00010000 /* (1L<<16) */
#define READ_CONTROL_ACCESS  0x00020000 /* (1L<<17) */
#define WRITE_DAC_ACCESS     0x00040000 /* (1L<<18) */
#define WRITE_OWNER_ACCESS   0x00080000 /* (1L<<19) */
#define SYNCHRONIZE_ACCESS   0x00100000 /* (1L<<20) */

#define SYSTEM_SECURITY_ACCESS 0x01000000 /* (1L<<24) */
#define MAXIMUM_ALLOWED_ACCESS 0x02000000 /* (1L<<25) */
#define GENERIC_ALL_ACCESS     0x10000000 /* (1<<28) */
#define GENERIC_EXECUTE_ACCESS 0x20000000 /* (1<<29) */
#define GENERIC_WRITE_ACCESS   0x40000000 /* (1<<30) */
#define GENERIC_READ_ACCESS    ((unsigned)0x80000000) /* (((unsigned)1)<<31) */

/* Mapping of generic access rights for files to specific rights. */

/* This maps to 0x1F01FF */
#define FILE_GENERIC_ALL (STANDARD_RIGHTS_REQUIRED_ACCESS| SYNCHRONIZE_ACCESS|FILE_ALL_ACCESS)

/* This maps to 0x120089 */
#define FILE_GENERIC_READ (STANDARD_RIGHTS_READ_ACCESS|FILE_READ_DATA|FILE_READ_ATTRIBUTES|\
							FILE_READ_EA|SYNCHRONIZE_ACCESS)

/* This maps to 0x120116 */
#define FILE_GENERIC_WRITE (STD_RIGHT_READ_CONTROL_ACCESS|FILE_WRITE_DATA|FILE_WRITE_ATTRIBUTES|\
							FILE_WRITE_EA|FILE_APPEND_DATA|SYNCHRONIZE_ACCESS)

#define FILE_GENERIC_EXECUTE (STANDARD_RIGHTS_EXECUTE_ACCESS|\
								FILE_EXECUTE|SYNCHRONIZE_ACCESS)

/* Share specific rights. */
#define SHARE_ALL_ACCESS      FILE_GENERIC_ALL
#define SHARE_READ_ONLY       (FILE_GENERIC_READ|FILE_EXECUTE)

/* Mapping of access rights to UNIX perms. */
#define UNIX_ACCESS_RWX		FILE_GENERIC_ALL
#define UNIX_ACCESS_R 		FILE_GENERIC_READ
#define UNIX_ACCESS_W		FILE_GENERIC_WRITE
#define UNIX_ACCESS_X		FILE_GENERIC_EXECUTE

/* Mapping of access rights to UNIX perms. for a UNIX directory. */
#define UNIX_DIRECTORY_ACCESS_RWX		FILE_GENERIC_ALL
#define UNIX_DIRECTORY_ACCESS_R 		FILE_GENERIC_READ
#define UNIX_DIRECTORY_ACCESS_W			FILE_GENERIC_WRITE
#define UNIX_DIRECTORY_ACCESS_X			FILE_GENERIC_EXECUTE

/* Flags field. */
#define REQUEST_OPLOCK 2
#define REQUEST_BATCH_OPLOCK 4
#define OPEN_DIRECTORY 8
#define EXTENDED_RESPONSE_REQUIRED 0x10

/* ShareAccess field. */
#define FILE_SHARE_NONE 0 /* Cannot be used in bitmask. */
#define FILE_SHARE_READ 1
#define FILE_SHARE_WRITE 2
#define FILE_SHARE_DELETE 4

/* FileAttributesField */
#define FILE_ATTRIBUTE_READONLY		0x001L
#define FILE_ATTRIBUTE_HIDDEN		0x002L
#define FILE_ATTRIBUTE_SYSTEM		0x004L
#define FILE_ATTRIBUTE_DIRECTORY	0x010L
#define FILE_ATTRIBUTE_ARCHIVE		0x020L
#define FILE_ATTRIBUTE_NORMAL		0x080L
#define FILE_ATTRIBUTE_TEMPORARY	0x100L
#define FILE_ATTRIBUTE_SPARSE		0x200L
#define FILE_ATTRIBUTE_REPARSE_POINT    0x400L
#define FILE_ATTRIBUTE_COMPRESSED	0x800L
#define FILE_ATTRIBUTE_OFFLINE          0x1000L
#define FILE_ATTRIBUTE_NONINDEXED	0x2000L
#define FILE_ATTRIBUTE_ENCRYPTED        0x4000L
#define SAMBA_ATTRIBUTES_MASK		0x7F

/* Flags - combined with attributes. */
#define FILE_FLAG_WRITE_THROUGH    0x80000000L
#define FILE_FLAG_NO_BUFFERING     0x20000000L
#define FILE_FLAG_RANDOM_ACCESS    0x10000000L
#define FILE_FLAG_SEQUENTIAL_SCAN  0x08000000L
#define FILE_FLAG_DELETE_ON_CLOSE  0x04000000L
#define FILE_FLAG_BACKUP_SEMANTICS 0x02000000L
#define FILE_FLAG_POSIX_SEMANTICS  0x01000000L

/* CreateDisposition field. */
#define FILE_SUPERSEDE 0		/* File exists overwrite/supersede. File not exist create. */
#define FILE_OPEN 1			/* File exists open. File not exist fail. */
#define FILE_CREATE 2			/* File exists fail. File not exist create. */
#define FILE_OPEN_IF 3			/* File exists open. File not exist create. */
#define FILE_OVERWRITE 4		/* File exists overwrite. File not exist fail. */
#define FILE_OVERWRITE_IF 5		/* File exists overwrite. File not exist create. */

/* CreateOptions field. */
#define FILE_DIRECTORY_FILE       0x0001
#define FILE_WRITE_THROUGH        0x0002
#define FILE_SEQUENTIAL_ONLY      0x0004
#define FILE_NON_DIRECTORY_FILE   0x0040
#define FILE_NO_EA_KNOWLEDGE      0x0200
#define FILE_EIGHT_DOT_THREE_ONLY 0x0400
#define FILE_RANDOM_ACCESS        0x0800
#define FILE_DELETE_ON_CLOSE      0x1000
#define FILE_OPEN_BY_FILE_ID	  0x2000

#endif
