/* Editor Settings: expandtabs and use 4 spaces for indentation
 * ex: set softtabstop=4 tabstop=8 expandtab shiftwidth=4: *
 */

/*
 * Copyright Likewise Software    2004-2009
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the license, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.  You should have received a copy
 * of the GNU Lesser General Public License along with this program.  If
 * not, see <http://www.gnu.org/licenses/>.
 *
 * LIKEWISE SOFTWARE MAKES THIS SOFTWARE AVAILABLE UNDER OTHER LICENSING
 * TERMS AS WELL.  IF YOU HAVE ENTERED INTO A SEPARATE LICENSE AGREEMENT
 * WITH LIKEWISE SOFTWARE, THEN YOU MAY ELECT TO USE THE SOFTWARE UNDER THE
 * TERMS OF THAT SOFTWARE LICENSE AGREEMENT INSTEAD OF THE TERMS OF THE GNU
 * LESSER GENERAL PUBLIC LICENSE, NOTWITHSTANDING THE ABOVE NOTICE.  IF YOU
 * HAVE QUESTIONS, OR WISH TO REQUEST A COPY OF THE ALTERNATE LICENSING
 * TERMS OFFERED BY LIKEWISE SOFTWARE, PLEASE CONTACT LIKEWISE SOFTWARE AT
 * license@likewisesoftware.com
 */

#ifndef _LDAPERROR_TABLE_H_
#define _LDAPERROR_TABLE_H_

#include <ldap.h>
#include <lw/winerror.h>


struct lderr_winerr {
    int lderr;
    DWORD winerr;
    PCSTR pszLderrStr;
};

#define LDERR(lderr, winerr) { lderr, winerr, #lderr }

/* New define in OpenLDAP 2.4 */
#ifndef LDAP_PROXY_AUTHZ_FAILURE
#  define LDAP_PROXY_AUTHZ_FAILURE LDAP_X_PROXY_AUTHZ_FAILURE
#endif

static const struct lderr_winerr ldaperr_winerr_map[] = {
    LDERR(LDAP_SUCCESS, ERROR_SUCCESS),
    LDERR(LDAP_NO_MEMORY, ERROR_OUTOFMEMORY),
    LDERR(LDAP_NOT_SUPPORTED, ERROR_INVALID_FUNCTION),
    LDERR(LDAP_UNWILLING_TO_PERFORM, ERROR_DS_UNWILLING_TO_PERFORM),
    LDERR(LDAP_REFERRAL, ERROR_DS_REFERRAL),

    /* Autogenerated from windows test utility using
       LdapMapErrToWin32 function */
    LDERR(LDAP_OPERATIONS_ERROR, 0x0000006e),
    LDERR(LDAP_PROTOCOL_ERROR, 0x0000007c),
    LDERR(LDAP_TIMELIMIT_EXCEEDED, 0x000005b4),
    LDERR(LDAP_SIZELIMIT_EXCEEDED, ERROR_MORE_DATA),
    LDERR(LDAP_COMPARE_FALSE, 0x00002095),
    LDERR(LDAP_COMPARE_TRUE, 0x00002095),
    LDERR(LDAP_AUTH_METHOD_NOT_SUPPORTED, ERROR_ACCESS_DENIED),
    LDERR(LDAP_STRONG_AUTH_NOT_SUPPORTED, ERROR_ACCESS_DENIED),
    LDERR(LDAP_STRONG_AUTH_REQUIRED, ERROR_ACCESS_DENIED),
    LDERR(LDAP_STRONGER_AUTH_REQUIRED, ERROR_ACCESS_DENIED),
    LDERR(LDAP_PARTIAL_RESULTS, ERROR_MORE_DATA),
    LDERR(LDAP_REFERRAL, ERROR_MORE_DATA),
    LDERR(LDAP_ADMINLIMIT_EXCEEDED, 0x00000718),
    LDERR(LDAP_UNAVAILABLE_CRITICAL_EXTENSION, 0x000003eb),
    LDERR(LDAP_PARAM_ERROR, ERROR_INVALID_PARAMETER),
    LDERR(LDAP_CONFIDENTIALITY_REQUIRED, 0x00002095),
    LDERR(LDAP_SASL_BIND_IN_PROGRESS, 0x00002095),
    LDERR(LDAP_NO_SUCH_ATTRIBUTE, ERROR_INVALID_PARAMETER),
    LDERR(LDAP_UNDEFINED_TYPE, 0x00002095),
    LDERR(LDAP_INAPPROPRIATE_MATCHING, ERROR_INVALID_PARAMETER),
    LDERR(LDAP_CONSTRAINT_VIOLATION, ERROR_INVALID_PARAMETER),
    LDERR(LDAP_TYPE_OR_VALUE_EXISTS, 0x000000b7),
    LDERR(LDAP_INVALID_SYNTAX, 0x0000007b),
    LDERR(LDAP_NO_SUCH_OBJECT, 0x00000002),
    LDERR(LDAP_ALIAS_PROBLEM, 0x00002095),
    LDERR(LDAP_INVALID_DN_SYNTAX, ERROR_INVALID_PARAMETER),
    LDERR(LDAP_IS_LEAF, 0x00002095),
    LDERR(LDAP_ALIAS_DEREF_PROBLEM, 0x00002095),
    LDERR(LDAP_PROXY_AUTHZ_FAILURE, 0x00002095),
    LDERR(LDAP_INAPPROPRIATE_AUTH, ERROR_ACCESS_DENIED),
    LDERR(LDAP_INVALID_CREDENTIALS, 0x0000052b),
    LDERR(LDAP_INSUFFICIENT_ACCESS, ERROR_ACCESS_DENIED),
    LDERR(LDAP_BUSY, 0x000000aa),
    LDERR(LDAP_UNAVAILABLE, 0x00000037),
    LDERR(LDAP_UNWILLING_TO_PERFORM, 0x000003eb),
    LDERR(LDAP_LOOP_DETECT, 0x00002095),
    LDERR(LDAP_NAMING_VIOLATION, ERROR_INVALID_PARAMETER),
    LDERR(LDAP_OBJECT_CLASS_VIOLATION, ERROR_INVALID_PARAMETER),
    LDERR(LDAP_NOT_ALLOWED_ON_NONLEAF, 0x000003eb),
    LDERR(LDAP_NOT_ALLOWED_ON_RDN, 0x00000005),
    LDERR(LDAP_ALREADY_EXISTS, 0x000000b7),
    LDERR(LDAP_NO_OBJECT_CLASS_MODS, 0x00000005),
    LDERR(LDAP_RESULTS_TOO_LARGE, 0x0000007a),
    LDERR(LDAP_AFFECTS_MULTIPLE_DSAS, 0x000003eb),

    LDERR(LDAP_CANCELLED, 0x00002095),
    LDERR(LDAP_NO_SUCH_OPERATION, 0x00002095),
    LDERR(LDAP_TOO_LATE, 0x00002095),
    LDERR(LDAP_CANNOT_CANCEL, 0x00002095),

    /* termination  */
    { 0, 0, NULL }
};

#undef LDERR

#endif /* _LDAPERROR_TABLE_H_ */

/*
local variables:
mode: c
c-basic-offset: 4
indent-tabs-mode: nil
tab-width: 4
end:
*/
