/*  TI BQ20Z75 Gauge Driver Header File
 *
 * Copyright (C) 20011 Quanta Computer Inc.
 * Author: Wayne Lin <wayne.lin@quantatw.com>
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */
#ifndef BQ20Z75_GAUGE_DRV_H
#define BQ20Z75_GAUGE_DRV_H

/*-----------------------------------------------------------------------------
 * MARCO and DEFINE
 *---------------------------------------------------------------------------*/
#define BQ20Z75_REG_STATUS								0x16
#define BQ20Z75_REG_STATUS_FULL_DISCHARGED						0x10
#define BQ20Z75_REG_STATUS_FULL								0x20
#define BQ20Z75_REG_STATUS_DISCHARGING							0x40
#define BQ20Z75_REG_STATUS_MAX								0xffff

#define BQ20Z75_REG_MANUFACTURE_ACCESS							0x00
#define BQ20Z75_REG_MANUFACTURE_ACCESS_STATUS						0x6
#define BQ20Z75_REG_MANUFACTURE_ACCESS_STATUS_OVER_CUR					0xa00
#define BQ20Z75_REG_MANUFACTURE_ACCESS_STATUS_OVER_TEMP					0xb00
#define BQ20Z75_REG_MANUFACTURE_ACCESS_STATUS_FAILURE					0xc00
#define BQ20Z75_REG_MANUFACTURE_ACCESS_STATUS_BAT_REMOVE				0xf00
#define BQ20Z75_REG_MANUFACTURE_ACCESS_STATUS_MASK					0xf00
#define BQ20Z75_REG_MANUFACTURE_ACCESS_MAX						0xffff

#define BQ20Z75_REG_VOLTAGE								0x09
#define BQ20Z75_REG_VOLTAGE_MAX								20000

#define BQ20Z75_REG_CHARGING_VOLTAGE							0x15
#define BQ20Z75_REG_CHARGING_VOLTAGE_MAX						65535

#define BQ20Z75_REG_CURRENT								0x0a
#define BQ20Z75_REG_CURRENT_MAX								0xFFFF	//32767 ~ -32768

#define BQ20Z75_REG_REL_CHARGE								0x0d
#define BQ20Z75_REG_REL_CHARGE_MAX							100

#define BQ20Z75_REG_TEMP								0x08
#define BQ20Z75_REG_TEMP_MAX								65535

#define BQ20Z75_REG_AVG_TIME_TO_EMPTY							0x12
#define BQ20Z75_REG_AVG_TIME_TO_EMPTY_MAX						65535

#define BQ20Z75_REG_AVG_TIME_TO_FULL							0x13
#define BQ20Z75_REG_AVG_TIME_TO_FULL_MAX						65535

#define BQ20Z75_REG_SERIAL_NUM								0x1c
#define BQ20Z75_REG_SERIAL_NUM_MAX							0xffff

#define BQ20Z75_REG_REMAIN_CAPACITY							0x0f
#define BQ20Z75_REG_REMAIN_CAPACITY_MAX							65535

#define BQ20Z75_REG_FULL_CAPACITY							0x10
#define BQ20Z75_REG_FULL_CAPACITY_MAX							65535

#define BQ20Z75_REG_DESIGN_CAPACITY							0x18
#define BQ20Z75_REG_DESIGN_CAPACITY_MAX							65535

#define BQ20Z75_REG_MANUFACTURE								0x20
#define BQ20Z75_REG_MANUFACTURE_MAX							11

#define BQ20Z75_REG_DEVICE_NAME								0x21
/*-----------------------------------------------------------------------------
 * Data structure declare
 *---------------------------------------------------------------------------*/
struct bq20z75_drv_info {
	struct i2c_client       *client;
	struct power_supply     power_supply_bat;
	struct power_supply     power_supply_ac;
	unsigned int            gpio_chg_pg;
	int                     irq_chg_pg;
	bool			stat_chg;
	unsigned int            gpio_batin;
	int                     irq_batin;
	bool			stat_batin;
	struct delayed_work     workqueue;
	struct mutex            lock;
};

/*-----------------------------------------------------------------------------
 * export symbol functions
 *---------------------------------------------------------------------------*/

#endif
