/*
 * Freescale DRAM Register Definitions
 *
 * Copyright 2008-2010 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * This file is created by xml file. Don't Edit it.
 *
 * Xml Revision: 1.50
 * Template revision: 26195
 */

#ifndef __ARCH_ARM___DRAM_H
#define __ARCH_ARM___DRAM_H


#define HW_DRAM_CTL00	(0x00000000)

#define BP_DRAM_CTL00_USER_DEF_REG_0_1	3
#define BM_DRAM_CTL00_USER_DEF_REG_0_1	0xFFFFFFF8
#define BF_DRAM_CTL00_USER_DEF_REG_0_1(v) \
		(((v) << 3) & BM_DRAM_CTL00_USER_DEF_REG_0_1)
#define BM_DRAM_CTL00_CKE_SELECT	0x00000004
#define BV_DRAM_CTL00_CKE_SELECT__DDR2  0x0
#define BV_DRAM_CTL00_CKE_SELECT__LPDDR 0x1
#define BM_DRAM_CTL00_SREFRESH_ENTER	0x00000002
#define BM_DRAM_CTL00_BRESP_TIMING	0x00000001
#define BV_DRAM_CTL00_BRESP_TIMING__BUFFERABLE      0x0
#define BV_DRAM_CTL00_BRESP_TIMING__SEMI_BUFFERABLE 0x1

#define HW_DRAM_CTL01	(0x00000004)

#define BP_DRAM_CTL01_USER_DEF_REG_1	9
#define BM_DRAM_CTL01_USER_DEF_REG_1	0xFFFFFE00
#define BF_DRAM_CTL01_USER_DEF_REG_1(v) \
		(((v) << 9) & BM_DRAM_CTL01_USER_DEF_REG_1)
#define BM_DRAM_CTL01_MON_DBG_STB	0x00000100
#define BP_DRAM_CTL01_SLVERR	4
#define BM_DRAM_CTL01_SLVERR	0x000000F0
#define BF_DRAM_CTL01_SLVERR(v)  \
		(((v) << 4) & BM_DRAM_CTL01_SLVERR)
#define BP_DRAM_CTL01_MON_DISABLE	0
#define BM_DRAM_CTL01_MON_DISABLE	0x0000000F
#define BF_DRAM_CTL01_MON_DISABLE(v)  \
		(((v) << 0) & BM_DRAM_CTL01_MON_DISABLE)

#define HW_DRAM_CTL02	(0x00000008)

#define BP_DRAM_CTL02_USER_DEF_REG_2	0
#define BM_DRAM_CTL02_USER_DEF_REG_2	0xFFFFFFFF
#define BF_DRAM_CTL02_USER_DEF_REG_2(v)	(v)

#define HW_DRAM_CTL03	(0x0000000c)

#define BP_DRAM_CTL03_USER_DEF_REG_3	0
#define BM_DRAM_CTL03_USER_DEF_REG_3	0xFFFFFFFF
#define BF_DRAM_CTL03_USER_DEF_REG_3(v)	(v)

#define HW_DRAM_CTL04	(0x00000010)

#define BP_DRAM_CTL04_USER_DEF_REG_4	0
#define BM_DRAM_CTL04_USER_DEF_REG_4	0xFFFFFFFF
#define BF_DRAM_CTL04_USER_DEF_REG_4(v)	(v)

#define HW_DRAM_CTL05	(0x00000014)

#define BP_DRAM_CTL05_USER_DEF_REG_5	0
#define BM_DRAM_CTL05_USER_DEF_REG_5	0xFFFFFFFF
#define BF_DRAM_CTL05_USER_DEF_REG_5(v)	(v)

#define HW_DRAM_CTL06	(0x00000018)

#define BP_DRAM_CTL06_USER_DEF_REG_6	0
#define BM_DRAM_CTL06_USER_DEF_REG_6	0xFFFFFFFF
#define BF_DRAM_CTL06_USER_DEF_REG_6(v)	(v)

#define HW_DRAM_CTL07	(0x0000001c)

#define BP_DRAM_CTL07_USER_DEF_REG_7	0
#define BM_DRAM_CTL07_USER_DEF_REG_7	0xFFFFFFFF
#define BF_DRAM_CTL07_USER_DEF_REG_7(v)	(v)

#define HW_DRAM_CTL08	(0x00000020)

#define BP_DRAM_CTL08_USER_DEF_REG_RO_0	9
#define BM_DRAM_CTL08_USER_DEF_REG_RO_0	0xFFFFFE00
#define BF_DRAM_CTL08_USER_DEF_REG_RO_0(v) \
		(((v) << 9) & BM_DRAM_CTL08_USER_DEF_REG_RO_0)
#define BM_DRAM_CTL08_CONTROLLER_BUSY	0x00000100
#define BM_DRAM_CTL08_REFRESH_IN_PROCESS	0x00000080
#define BM_DRAM_CTL08_Q_ALMOST_FULL	0x00000040
#define BM_DRAM_CTL08_SREFRESH_ACK	0x00000020
#define BM_DRAM_CTL08_CKE_STATUS	0x00000010
#define BP_DRAM_CTL08_COMMAND_ACCEPTED	0
#define BM_DRAM_CTL08_COMMAND_ACCEPTED	0x0000000F
#define BF_DRAM_CTL08_COMMAND_ACCEPTED(v)  \
		(((v) << 0) & BM_DRAM_CTL08_COMMAND_ACCEPTED)

#define HW_DRAM_CTL09	(0x00000024)

#define BP_DRAM_CTL09_USER_DEF_REG_RO_1	0
#define BM_DRAM_CTL09_USER_DEF_REG_RO_1	0xFFFFFFFF
#define BF_DRAM_CTL09_USER_DEF_REG_RO_1(v)	(v)

#define HW_DRAM_CTL10	(0x00000028)

#define BP_DRAM_CTL10_RSVD	24
#define BM_DRAM_CTL10_RSVD	0xFF000000
#define BF_DRAM_CTL10_RSVD(v) \
		(((v) << 24) & BM_DRAM_CTL10_RSVD)
#define BP_DRAM_CTL10_READ_CNT	16
#define BM_DRAM_CTL10_READ_CNT	0x00FF0000
#define BF_DRAM_CTL10_READ_CNT(v)  \
		(((v) << 16) & BM_DRAM_CTL10_READ_CNT)
#define BP_DRAM_CTL10_WRESP_CNT	8
#define BM_DRAM_CTL10_WRESP_CNT	0x0000FF00
#define BF_DRAM_CTL10_WRESP_CNT(v)  \
		(((v) << 8) & BM_DRAM_CTL10_WRESP_CNT)
#define BP_DRAM_CTL10_WDATA_CNT	0
#define BM_DRAM_CTL10_WDATA_CNT	0x000000FF
#define BF_DRAM_CTL10_WDATA_CNT(v)  \
		(((v) << 0) & BM_DRAM_CTL10_WDATA_CNT)

#define HW_DRAM_CTL11	(0x0000002c)

#define BP_DRAM_CTL11_WSTATE	24
#define BM_DRAM_CTL11_WSTATE	0xFF000000
#define BF_DRAM_CTL11_WSTATE(v) \
		(((v) << 24) & BM_DRAM_CTL11_WSTATE)
#define BP_DRAM_CTL11_RSTATE	16
#define BM_DRAM_CTL11_RSTATE	0x00FF0000
#define BF_DRAM_CTL11_RSTATE(v)  \
		(((v) << 16) & BM_DRAM_CTL11_RSTATE)
#define BP_DRAM_CTL11_RLEN	8
#define BM_DRAM_CTL11_RLEN	0x0000FF00
#define BF_DRAM_CTL11_RLEN(v)  \
		(((v) << 8) & BM_DRAM_CTL11_RLEN)
#define BP_DRAM_CTL11_WLEN	0
#define BM_DRAM_CTL11_WLEN	0x000000FF
#define BF_DRAM_CTL11_WLEN(v)  \
		(((v) << 0) & BM_DRAM_CTL11_WLEN)

#define HW_DRAM_CTL12	(0x00000030)

#define BP_DRAM_CTL12_RSVD	24
#define BM_DRAM_CTL12_RSVD	0xFF000000
#define BF_DRAM_CTL12_RSVD(v) \
		(((v) << 24) & BM_DRAM_CTL12_RSVD)
#define BP_DRAM_CTL12_READ_CNT	16
#define BM_DRAM_CTL12_READ_CNT	0x00FF0000
#define BF_DRAM_CTL12_READ_CNT(v)  \
		(((v) << 16) & BM_DRAM_CTL12_READ_CNT)
#define BP_DRAM_CTL12_WRESP_CNT	8
#define BM_DRAM_CTL12_WRESP_CNT	0x0000FF00
#define BF_DRAM_CTL12_WRESP_CNT(v)  \
		(((v) << 8) & BM_DRAM_CTL12_WRESP_CNT)
#define BP_DRAM_CTL12_WDATA_CNT	0
#define BM_DRAM_CTL12_WDATA_CNT	0x000000FF
#define BF_DRAM_CTL12_WDATA_CNT(v)  \
		(((v) << 0) & BM_DRAM_CTL12_WDATA_CNT)

#define HW_DRAM_CTL13	(0x00000034)

#define BP_DRAM_CTL13_WSTATE	24
#define BM_DRAM_CTL13_WSTATE	0xFF000000
#define BF_DRAM_CTL13_WSTATE(v) \
		(((v) << 24) & BM_DRAM_CTL13_WSTATE)
#define BP_DRAM_CTL13_RSTATE	16
#define BM_DRAM_CTL13_RSTATE	0x00FF0000
#define BF_DRAM_CTL13_RSTATE(v)  \
		(((v) << 16) & BM_DRAM_CTL13_RSTATE)
#define BP_DRAM_CTL13_RLEN	8
#define BM_DRAM_CTL13_RLEN	0x0000FF00
#define BF_DRAM_CTL13_RLEN(v)  \
		(((v) << 8) & BM_DRAM_CTL13_RLEN)
#define BP_DRAM_CTL13_WLEN	0
#define BM_DRAM_CTL13_WLEN	0x000000FF
#define BF_DRAM_CTL13_WLEN(v)  \
		(((v) << 0) & BM_DRAM_CTL13_WLEN)

#define HW_DRAM_CTL14	(0x00000038)

#define BP_DRAM_CTL14_RSVD	24
#define BM_DRAM_CTL14_RSVD	0xFF000000
#define BF_DRAM_CTL14_RSVD(v) \
		(((v) << 24) & BM_DRAM_CTL14_RSVD)
#define BP_DRAM_CTL14_READ_CNT	16
#define BM_DRAM_CTL14_READ_CNT	0x00FF0000
#define BF_DRAM_CTL14_READ_CNT(v)  \
		(((v) << 16) & BM_DRAM_CTL14_READ_CNT)
#define BP_DRAM_CTL14_WRESP_CNT	8
#define BM_DRAM_CTL14_WRESP_CNT	0x0000FF00
#define BF_DRAM_CTL14_WRESP_CNT(v)  \
		(((v) << 8) & BM_DRAM_CTL14_WRESP_CNT)
#define BP_DRAM_CTL14_WDATA_CNT	0
#define BM_DRAM_CTL14_WDATA_CNT	0x000000FF
#define BF_DRAM_CTL14_WDATA_CNT(v)  \
		(((v) << 0) & BM_DRAM_CTL14_WDATA_CNT)

#define HW_DRAM_CTL15	(0x0000003c)

#define BP_DRAM_CTL15_WSTATE	24
#define BM_DRAM_CTL15_WSTATE	0xFF000000
#define BF_DRAM_CTL15_WSTATE(v) \
		(((v) << 24) & BM_DRAM_CTL15_WSTATE)
#define BP_DRAM_CTL15_RSTATE	16
#define BM_DRAM_CTL15_RSTATE	0x00FF0000
#define BF_DRAM_CTL15_RSTATE(v)  \
		(((v) << 16) & BM_DRAM_CTL15_RSTATE)
#define BP_DRAM_CTL15_RLEN	8
#define BM_DRAM_CTL15_RLEN	0x0000FF00
#define BF_DRAM_CTL15_RLEN(v)  \
		(((v) << 8) & BM_DRAM_CTL15_RLEN)
#define BP_DRAM_CTL15_WLEN	0
#define BM_DRAM_CTL15_WLEN	0x000000FF
#define BF_DRAM_CTL15_WLEN(v)  \
		(((v) << 0) & BM_DRAM_CTL15_WLEN)

#define HW_DRAM_CTL16	(0x00000040)

#define BP_DRAM_CTL16_RSVD3	25
#define BM_DRAM_CTL16_RSVD3	0xFE000000
#define BF_DRAM_CTL16_RSVD3(v) \
		(((v) << 25) & BM_DRAM_CTL16_RSVD3)
#define BM_DRAM_CTL16_WRITE_MODEREG	0x01000000
#define BP_DRAM_CTL16_RSVD2	17
#define BM_DRAM_CTL16_RSVD2	0x00FE0000
#define BF_DRAM_CTL16_RSVD2(v)  \
		(((v) << 17) & BM_DRAM_CTL16_RSVD2)
#define BM_DRAM_CTL16_POWER_DOWN	0x00010000
#define BP_DRAM_CTL16_OBSOLETE	8
#define BM_DRAM_CTL16_OBSOLETE	0x0000FF00
#define BF_DRAM_CTL16_OBSOLETE(v)  \
		(((v) << 8) & BM_DRAM_CTL16_OBSOLETE)
#define BP_DRAM_CTL16_RSVD1	1
#define BM_DRAM_CTL16_RSVD1	0x000000FE
#define BF_DRAM_CTL16_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL16_RSVD1)
#define BM_DRAM_CTL16_START	0x00000001

#define HW_DRAM_CTL17	(0x00000044)

#define BP_DRAM_CTL17_RSVD4	25
#define BM_DRAM_CTL17_RSVD4	0xFE000000
#define BF_DRAM_CTL17_RSVD4(v) \
		(((v) << 25) & BM_DRAM_CTL17_RSVD4)
#define BM_DRAM_CTL17_AUTO_REFRESH_MODE	0x01000000
#define BP_DRAM_CTL17_RSVD3	17
#define BM_DRAM_CTL17_RSVD3	0x00FE0000
#define BF_DRAM_CTL17_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL17_RSVD3)
#define BM_DRAM_CTL17_AREFRESH	0x00010000
#define BP_DRAM_CTL17_RSVD2	9
#define BM_DRAM_CTL17_RSVD2	0x0000FE00
#define BF_DRAM_CTL17_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL17_RSVD2)
#define BM_DRAM_CTL17_ENABLE_QUICK_SREFRESH	0x00000100
#define BP_DRAM_CTL17_RSVD1	1
#define BM_DRAM_CTL17_RSVD1	0x000000FE
#define BF_DRAM_CTL17_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL17_RSVD1)
#define BM_DRAM_CTL17_SREFRESH	0x00000001

#define HW_DRAM_CTL21	(0x00000054)

#define BP_DRAM_CTL21_RSVD3	27
#define BM_DRAM_CTL21_RSVD3	0xF8000000
#define BF_DRAM_CTL21_RSVD3(v) \
		(((v) << 27) & BM_DRAM_CTL21_RSVD3)
#define BP_DRAM_CTL21_CKE_DELAY	24
#define BM_DRAM_CTL21_CKE_DELAY	0x07000000
#define BF_DRAM_CTL21_CKE_DELAY(v)  \
		(((v) << 24) & BM_DRAM_CTL21_CKE_DELAY)
#define BP_DRAM_CTL21_DLL_LOCK	16
#define BM_DRAM_CTL21_DLL_LOCK	0x00FF0000
#define BF_DRAM_CTL21_DLL_LOCK(v)  \
		(((v) << 16) & BM_DRAM_CTL21_DLL_LOCK)
#define BP_DRAM_CTL21_RSVD2	9
#define BM_DRAM_CTL21_RSVD2	0x0000FE00
#define BF_DRAM_CTL21_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL21_RSVD2)
#define BM_DRAM_CTL21_DLLLOCKREG	0x00000100
#define BP_DRAM_CTL21_RSVD1	1
#define BM_DRAM_CTL21_RSVD1	0x000000FE
#define BF_DRAM_CTL21_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL21_RSVD1)
#define BM_DRAM_CTL21_DLL_BYPASS_MODE	0x00000001

#define HW_DRAM_CTL22	(0x00000058)

#define BP_DRAM_CTL22_OBSOLETE	24
#define BM_DRAM_CTL22_OBSOLETE	0xFF000000
#define BF_DRAM_CTL22_OBSOLETE(v) \
		(((v) << 24) & BM_DRAM_CTL22_OBSOLETE)
#define BP_DRAM_CTL22_RSVD3	20
#define BM_DRAM_CTL22_RSVD3	0x00F00000
#define BF_DRAM_CTL22_RSVD3(v)  \
		(((v) << 20) & BM_DRAM_CTL22_RSVD3)
#define BP_DRAM_CTL22_LOWPOWER_REFRESH_ENABLE	16
#define BM_DRAM_CTL22_LOWPOWER_REFRESH_ENABLE	0x000F0000
#define BF_DRAM_CTL22_LOWPOWER_REFRESH_ENABLE(v)  \
		(((v) << 16) & BM_DRAM_CTL22_LOWPOWER_REFRESH_ENABLE)
#define BP_DRAM_CTL22_RSVD2	13
#define BM_DRAM_CTL22_RSVD2	0x0000E000
#define BF_DRAM_CTL22_RSVD2(v)  \
		(((v) << 13) & BM_DRAM_CTL22_RSVD2)
#define BP_DRAM_CTL22_LOWPOWER_CONTROL	8
#define BM_DRAM_CTL22_LOWPOWER_CONTROL	0x00001F00
#define BF_DRAM_CTL22_LOWPOWER_CONTROL(v)  \
		(((v) << 8) & BM_DRAM_CTL22_LOWPOWER_CONTROL)
#define BP_DRAM_CTL22_RSVD1	5
#define BM_DRAM_CTL22_RSVD1	0x000000E0
#define BF_DRAM_CTL22_RSVD1(v)  \
		(((v) << 5) & BM_DRAM_CTL22_RSVD1)
#define BP_DRAM_CTL22_LOWPOWER_AUTO_ENABLE	0
#define BM_DRAM_CTL22_LOWPOWER_AUTO_ENABLE	0x0000001F
#define BF_DRAM_CTL22_LOWPOWER_AUTO_ENABLE(v)  \
		(((v) << 0) & BM_DRAM_CTL22_LOWPOWER_AUTO_ENABLE)

#define HW_DRAM_CTL23	(0x0000005c)

#define BP_DRAM_CTL23_LOWPOWER_INTERNAL_CNT	16
#define BM_DRAM_CTL23_LOWPOWER_INTERNAL_CNT	0xFFFF0000
#define BF_DRAM_CTL23_LOWPOWER_INTERNAL_CNT(v) \
		(((v) << 16) & BM_DRAM_CTL23_LOWPOWER_INTERNAL_CNT)
#define BP_DRAM_CTL23_LOWPOWER_EXTERNAL_CNT	0
#define BM_DRAM_CTL23_LOWPOWER_EXTERNAL_CNT	0x0000FFFF
#define BF_DRAM_CTL23_LOWPOWER_EXTERNAL_CNT(v)  \
		(((v) << 0) & BM_DRAM_CTL23_LOWPOWER_EXTERNAL_CNT)

#define HW_DRAM_CTL24	(0x00000060)

#define BP_DRAM_CTL24_LOWPOWER_SELF_REFRESH_CNT	16
#define BM_DRAM_CTL24_LOWPOWER_SELF_REFRESH_CNT	0xFFFF0000
#define BF_DRAM_CTL24_LOWPOWER_SELF_REFRESH_CNT(v) \
		(((v) << 16) & BM_DRAM_CTL24_LOWPOWER_SELF_REFRESH_CNT)
#define BP_DRAM_CTL24_LOWPOWER_REFRESH_HOLD	0
#define BM_DRAM_CTL24_LOWPOWER_REFRESH_HOLD	0x0000FFFF
#define BF_DRAM_CTL24_LOWPOWER_REFRESH_HOLD(v)  \
		(((v) << 0) & BM_DRAM_CTL24_LOWPOWER_REFRESH_HOLD)

#define HW_DRAM_CTL25	(0x00000064)

#define BP_DRAM_CTL25_OBSOLETE	16
#define BM_DRAM_CTL25_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL25_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL25_OBSOLETE)
#define BP_DRAM_CTL25_LOWPOWER_POWER_DOWN_CNT	0
#define BM_DRAM_CTL25_LOWPOWER_POWER_DOWN_CNT	0x0000FFFF
#define BF_DRAM_CTL25_LOWPOWER_POWER_DOWN_CNT(v)  \
		(((v) << 0) & BM_DRAM_CTL25_LOWPOWER_POWER_DOWN_CNT)

#define HW_DRAM_CTL26	(0x00000068)

#define BP_DRAM_CTL26_OBSOLETE	24
#define BM_DRAM_CTL26_OBSOLETE	0xFF000000
#define BF_DRAM_CTL26_OBSOLETE(v) \
		(((v) << 24) & BM_DRAM_CTL26_OBSOLETE)
#define BP_DRAM_CTL26_RSVD3	17
#define BM_DRAM_CTL26_RSVD3	0x00FE0000
#define BF_DRAM_CTL26_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL26_RSVD3)
#define BM_DRAM_CTL26_PRIORITY_EN	0x00010000
#define BP_DRAM_CTL26_RSVD2	9
#define BM_DRAM_CTL26_RSVD2	0x0000FE00
#define BF_DRAM_CTL26_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL26_RSVD2)
#define BM_DRAM_CTL26_ADDR_CMP_EN	0x00000100
#define BP_DRAM_CTL26_RSVD1	1
#define BM_DRAM_CTL26_RSVD1	0x000000FE
#define BF_DRAM_CTL26_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL26_RSVD1)
#define BM_DRAM_CTL26_PLACEMENT_EN	0x00000001

#define HW_DRAM_CTL27	(0x0000006c)

#define BP_DRAM_CTL27_RSVD4	25
#define BM_DRAM_CTL27_RSVD4	0xFE000000
#define BF_DRAM_CTL27_RSVD4(v) \
		(((v) << 25) & BM_DRAM_CTL27_RSVD4)
#define BM_DRAM_CTL27_SWAP_PORT_RW_SAME_EN	0x01000000
#define BP_DRAM_CTL27_RSVD3	17
#define BM_DRAM_CTL27_RSVD3	0x00FE0000
#define BF_DRAM_CTL27_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL27_RSVD3)
#define BM_DRAM_CTL27_SWAP_EN	0x00010000
#define BP_DRAM_CTL27_RSVD2	9
#define BM_DRAM_CTL27_RSVD2	0x0000FE00
#define BF_DRAM_CTL27_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL27_RSVD2)
#define BM_DRAM_CTL27_BANK_SPLIT_EN	0x00000100
#define BP_DRAM_CTL27_RSVD1	1
#define BM_DRAM_CTL27_RSVD1	0x000000FE
#define BF_DRAM_CTL27_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL27_RSVD1)
#define BM_DRAM_CTL27_RW_SAME_EN	0x00000001

#define HW_DRAM_CTL28	(0x00000070)

#define BP_DRAM_CTL28_RSVD4	27
#define BM_DRAM_CTL28_RSVD4	0xF8000000
#define BF_DRAM_CTL28_RSVD4(v) \
		(((v) << 27) & BM_DRAM_CTL28_RSVD4)
#define BP_DRAM_CTL28_Q_FULLNESS	24
#define BM_DRAM_CTL28_Q_FULLNESS	0x07000000
#define BF_DRAM_CTL28_Q_FULLNESS(v)  \
		(((v) << 24) & BM_DRAM_CTL28_Q_FULLNESS)
#define BP_DRAM_CTL28_RSVD3	20
#define BM_DRAM_CTL28_RSVD3	0x00F00000
#define BF_DRAM_CTL28_RSVD3(v)  \
		(((v) << 20) & BM_DRAM_CTL28_RSVD3)
#define BP_DRAM_CTL28_AGE_COUNT	16
#define BM_DRAM_CTL28_AGE_COUNT	0x000F0000
#define BF_DRAM_CTL28_AGE_COUNT(v)  \
		(((v) << 16) & BM_DRAM_CTL28_AGE_COUNT)
#define BP_DRAM_CTL28_RSVD2	12
#define BM_DRAM_CTL28_RSVD2	0x0000F000
#define BF_DRAM_CTL28_RSVD2(v)  \
		(((v) << 12) & BM_DRAM_CTL28_RSVD2)
#define BP_DRAM_CTL28_COMMAND_AGE_COUNT	8
#define BM_DRAM_CTL28_COMMAND_AGE_COUNT	0x00000F00
#define BF_DRAM_CTL28_COMMAND_AGE_COUNT(v)  \
		(((v) << 8) & BM_DRAM_CTL28_COMMAND_AGE_COUNT)
#define BP_DRAM_CTL28_RSVD1	1
#define BM_DRAM_CTL28_RSVD1	0x000000FE
#define BF_DRAM_CTL28_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL28_RSVD1)
#define BM_DRAM_CTL28_ACTIVE_AGING	0x00000001

#define HW_DRAM_CTL29	(0x00000074)

#define BP_DRAM_CTL29_RSVD4	28
#define BM_DRAM_CTL29_RSVD4	0xF0000000
#define BF_DRAM_CTL29_RSVD4(v) \
		(((v) << 28) & BM_DRAM_CTL29_RSVD4)
#define BP_DRAM_CTL29_CS_MAP	24
#define BM_DRAM_CTL29_CS_MAP	0x0F000000
#define BF_DRAM_CTL29_CS_MAP(v)  \
		(((v) << 24) & BM_DRAM_CTL29_CS_MAP)
#define BP_DRAM_CTL29_RSVD3	19
#define BM_DRAM_CTL29_RSVD3	0x00F80000
#define BF_DRAM_CTL29_RSVD3(v)  \
		(((v) << 19) & BM_DRAM_CTL29_RSVD3)
#define BP_DRAM_CTL29_COLUMN_SIZE	16
#define BM_DRAM_CTL29_COLUMN_SIZE	0x00070000
#define BF_DRAM_CTL29_COLUMN_SIZE(v)  \
		(((v) << 16) & BM_DRAM_CTL29_COLUMN_SIZE)
#define BP_DRAM_CTL29_RSVD2	11
#define BM_DRAM_CTL29_RSVD2	0x0000F800
#define BF_DRAM_CTL29_RSVD2(v)  \
		(((v) << 11) & BM_DRAM_CTL29_RSVD2)
#define BP_DRAM_CTL29_ADDR_PINS	8
#define BM_DRAM_CTL29_ADDR_PINS	0x00000700
#define BF_DRAM_CTL29_ADDR_PINS(v)  \
		(((v) << 8) & BM_DRAM_CTL29_ADDR_PINS)
#define BP_DRAM_CTL29_RSVD1	4
#define BM_DRAM_CTL29_RSVD1	0x000000F0
#define BF_DRAM_CTL29_RSVD1(v)  \
		(((v) << 4) & BM_DRAM_CTL29_RSVD1)
#define BP_DRAM_CTL29_APREBIT	0
#define BM_DRAM_CTL29_APREBIT	0x0000000F
#define BF_DRAM_CTL29_APREBIT(v)  \
		(((v) << 0) & BM_DRAM_CTL29_APREBIT)

#define HW_DRAM_CTL30	(0x00000078)

#define BP_DRAM_CTL30_OBSOLETE	24
#define BM_DRAM_CTL30_OBSOLETE	0xFF000000
#define BF_DRAM_CTL30_OBSOLETE(v) \
		(((v) << 24) & BM_DRAM_CTL30_OBSOLETE)
#define BP_DRAM_CTL30_RSVD3	19
#define BM_DRAM_CTL30_RSVD3	0x00F80000
#define BF_DRAM_CTL30_RSVD3(v)  \
		(((v) << 19) & BM_DRAM_CTL30_RSVD3)
#define BP_DRAM_CTL30_MAX_CS_REG	16
#define BM_DRAM_CTL30_MAX_CS_REG	0x00070000
#define BF_DRAM_CTL30_MAX_CS_REG(v)  \
		(((v) << 16) & BM_DRAM_CTL30_MAX_CS_REG)
#define BP_DRAM_CTL30_RSVD2	12
#define BM_DRAM_CTL30_RSVD2	0x0000F000
#define BF_DRAM_CTL30_RSVD2(v)  \
		(((v) << 12) & BM_DRAM_CTL30_RSVD2)
#define BP_DRAM_CTL30_MAX_ROW_REG	8
#define BM_DRAM_CTL30_MAX_ROW_REG	0x00000F00
#define BF_DRAM_CTL30_MAX_ROW_REG(v)  \
		(((v) << 8) & BM_DRAM_CTL30_MAX_ROW_REG)
#define BP_DRAM_CTL30_RSVD1	4
#define BM_DRAM_CTL30_RSVD1	0x000000F0
#define BF_DRAM_CTL30_RSVD1(v)  \
		(((v) << 4) & BM_DRAM_CTL30_RSVD1)
#define BP_DRAM_CTL30_MAX_COL_REG	0
#define BM_DRAM_CTL30_MAX_COL_REG	0x0000000F
#define BF_DRAM_CTL30_MAX_COL_REG(v)  \
		(((v) << 0) & BM_DRAM_CTL30_MAX_COL_REG)

#define HW_DRAM_CTL31	(0x0000007c)

#define BP_DRAM_CTL31_OBSOLETE	24
#define BM_DRAM_CTL31_OBSOLETE	0xFF000000
#define BF_DRAM_CTL31_OBSOLETE(v) \
		(((v) << 24) & BM_DRAM_CTL31_OBSOLETE)
#define BP_DRAM_CTL31_RSVD3	17
#define BM_DRAM_CTL31_RSVD3	0x00FE0000
#define BF_DRAM_CTL31_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL31_RSVD3)
#define BM_DRAM_CTL31_EIGHT_BANK_MODE	0x00010000
#define BP_DRAM_CTL31_RSVD2	9
#define BM_DRAM_CTL31_RSVD2	0x0000FE00
#define BF_DRAM_CTL31_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL31_RSVD2)
#define BM_DRAM_CTL31_DRIVE_DQ_DQS	0x00000100
#define BP_DRAM_CTL31_RSVD1	1
#define BM_DRAM_CTL31_RSVD1	0x000000FE
#define BF_DRAM_CTL31_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL31_RSVD1)
#define BM_DRAM_CTL31_DQS_N_EN	0x00000001

#define HW_DRAM_CTL32	(0x00000080)

#define BP_DRAM_CTL32_OBSOLETE	16
#define BM_DRAM_CTL32_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL32_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL32_OBSOLETE)
#define BP_DRAM_CTL32_RSVD2	9
#define BM_DRAM_CTL32_RSVD2	0x0000FE00
#define BF_DRAM_CTL32_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL32_RSVD2)
#define BM_DRAM_CTL32_REDUC	0x00000100
#define BP_DRAM_CTL32_RSVD1	1
#define BM_DRAM_CTL32_RSVD1	0x000000FE
#define BF_DRAM_CTL32_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL32_RSVD1)
#define BM_DRAM_CTL32_REG_DIMM_ENABLE	0x00000001

#define HW_DRAM_CTL33	(0x00000084)

#define BP_DRAM_CTL33_OBSOLETE	16
#define BM_DRAM_CTL33_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL33_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL33_OBSOLETE)
#define BP_DRAM_CTL33_RSVD2	9
#define BM_DRAM_CTL33_RSVD2	0x0000FE00
#define BF_DRAM_CTL33_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL33_RSVD2)
#define BM_DRAM_CTL33_CONCURRENTAP	0x00000100
#define BP_DRAM_CTL33_RSVD1	1
#define BM_DRAM_CTL33_RSVD1	0x000000FE
#define BF_DRAM_CTL33_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL33_RSVD1)
#define BM_DRAM_CTL33_AP	0x00000001

#define HW_DRAM_CTL34	(0x00000088)

#define BP_DRAM_CTL34_RSVD4	25
#define BM_DRAM_CTL34_RSVD4	0xFE000000
#define BF_DRAM_CTL34_RSVD4(v) \
		(((v) << 25) & BM_DRAM_CTL34_RSVD4)
#define BM_DRAM_CTL34_WRITEINTERP	0x01000000
#define BP_DRAM_CTL34_RSVD3	17
#define BM_DRAM_CTL34_RSVD3	0x00FE0000
#define BF_DRAM_CTL34_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL34_RSVD3)
#define BM_DRAM_CTL34_INTRPTWRITEA	0x00010000
#define BP_DRAM_CTL34_RSVD2	9
#define BM_DRAM_CTL34_RSVD2	0x0000FE00
#define BF_DRAM_CTL34_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL34_RSVD2)
#define BM_DRAM_CTL34_INTRPTREADA	0x00000100
#define BP_DRAM_CTL34_RSVD1	1
#define BM_DRAM_CTL34_RSVD1	0x000000FE
#define BF_DRAM_CTL34_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL34_RSVD1)
#define BM_DRAM_CTL34_INTRPTAPBURST	0x00000001

#define HW_DRAM_CTL35	(0x0000008c)

#define BP_DRAM_CTL35_OBSOLETE	24
#define BM_DRAM_CTL35_OBSOLETE	0xFF000000
#define BF_DRAM_CTL35_OBSOLETE(v) \
		(((v) << 24) & BM_DRAM_CTL35_OBSOLETE)
#define BP_DRAM_CTL35_RSVD3	17
#define BM_DRAM_CTL35_RSVD3	0x00FE0000
#define BF_DRAM_CTL35_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL35_RSVD3)
#define BM_DRAM_CTL35_PWRUP_SREFRESH_EXIT	0x00010000
#define BP_DRAM_CTL35_RSVD2	9
#define BM_DRAM_CTL35_RSVD2	0x0000FE00
#define BF_DRAM_CTL35_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL35_RSVD2)
#define BM_DRAM_CTL35_NO_CMD_INIT	0x00000100
#define BP_DRAM_CTL35_RSVD1	4
#define BM_DRAM_CTL35_RSVD1	0x000000F0
#define BF_DRAM_CTL35_RSVD1(v)  \
		(((v) << 4) & BM_DRAM_CTL35_RSVD1)
#define BP_DRAM_CTL35_INITAREF	0
#define BM_DRAM_CTL35_INITAREF	0x0000000F
#define BF_DRAM_CTL35_INITAREF(v)  \
		(((v) << 0) & BM_DRAM_CTL35_INITAREF)

#define HW_DRAM_CTL36	(0x00000090)

#define BP_DRAM_CTL36_RSVD3	25
#define BM_DRAM_CTL36_RSVD3	0xFE000000
#define BF_DRAM_CTL36_RSVD3(v) \
		(((v) << 25) & BM_DRAM_CTL36_RSVD3)
#define BM_DRAM_CTL36_TREF_ENABLE	0x01000000
#define BP_DRAM_CTL36_RSVD2	17
#define BM_DRAM_CTL36_RSVD2	0x00FE0000
#define BF_DRAM_CTL36_RSVD2(v)  \
		(((v) << 17) & BM_DRAM_CTL36_RSVD2)
#define BM_DRAM_CTL36_TRAS_LOCKOUT	0x00010000
#define BP_DRAM_CTL36_OBSOLETE	8
#define BM_DRAM_CTL36_OBSOLETE	0x0000FF00
#define BF_DRAM_CTL36_OBSOLETE(v)  \
		(((v) << 8) & BM_DRAM_CTL36_OBSOLETE)
#define BP_DRAM_CTL36_RSVD1	1
#define BM_DRAM_CTL36_RSVD1	0x000000FE
#define BF_DRAM_CTL36_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL36_RSVD1)
#define BM_DRAM_CTL36_FAST_WRITE	0x00000001

#define HW_DRAM_CTL37	(0x00000094)

#define BP_DRAM_CTL37_RSVD4	28
#define BM_DRAM_CTL37_RSVD4	0xF0000000
#define BF_DRAM_CTL37_RSVD4(v) \
		(((v) << 28) & BM_DRAM_CTL37_RSVD4)
#define BP_DRAM_CTL37_CASLAT_LIN_GATE	24
#define BM_DRAM_CTL37_CASLAT_LIN_GATE	0x0F000000
#define BF_DRAM_CTL37_CASLAT_LIN_GATE(v)  \
		(((v) << 24) & BM_DRAM_CTL37_CASLAT_LIN_GATE)
#define BP_DRAM_CTL37_RSVD3	20
#define BM_DRAM_CTL37_RSVD3	0x00F00000
#define BF_DRAM_CTL37_RSVD3(v)  \
		(((v) << 20) & BM_DRAM_CTL37_RSVD3)
#define BP_DRAM_CTL37_CASLAT_LIN	16
#define BM_DRAM_CTL37_CASLAT_LIN	0x000F0000
#define BF_DRAM_CTL37_CASLAT_LIN(v)  \
		(((v) << 16) & BM_DRAM_CTL37_CASLAT_LIN)
#define BP_DRAM_CTL37_RSVD2	11
#define BM_DRAM_CTL37_RSVD2	0x0000F800
#define BF_DRAM_CTL37_RSVD2(v)  \
		(((v) << 11) & BM_DRAM_CTL37_RSVD2)
#define BP_DRAM_CTL37_CASLAT	8
#define BM_DRAM_CTL37_CASLAT	0x00000700
#define BF_DRAM_CTL37_CASLAT(v)  \
		(((v) << 8) & BM_DRAM_CTL37_CASLAT)
#define BP_DRAM_CTL37_RSVD1	4
#define BM_DRAM_CTL37_RSVD1	0x000000F0
#define BF_DRAM_CTL37_RSVD1(v)  \
		(((v) << 4) & BM_DRAM_CTL37_RSVD1)
#define BP_DRAM_CTL37_WRLAT	0
#define BM_DRAM_CTL37_WRLAT	0x0000000F
#define BF_DRAM_CTL37_WRLAT(v)  \
		(((v) << 0) & BM_DRAM_CTL37_WRLAT)

#define HW_DRAM_CTL38	(0x00000098)

#define BP_DRAM_CTL38_RSVD2	29
#define BM_DRAM_CTL38_RSVD2	0xE0000000
#define BF_DRAM_CTL38_RSVD2(v) \
		(((v) << 29) & BM_DRAM_CTL38_RSVD2)
#define BP_DRAM_CTL38_TDAL	24
#define BM_DRAM_CTL38_TDAL	0x1F000000
#define BF_DRAM_CTL38_TDAL(v)  \
		(((v) << 24) & BM_DRAM_CTL38_TDAL)
#define BP_DRAM_CTL38_TCPD	8
#define BM_DRAM_CTL38_TCPD	0x00FFFF00
#define BF_DRAM_CTL38_TCPD(v)  \
		(((v) << 8) & BM_DRAM_CTL38_TCPD)
#define BP_DRAM_CTL38_RSVD1	3
#define BM_DRAM_CTL38_RSVD1	0x000000F8
#define BF_DRAM_CTL38_RSVD1(v)  \
		(((v) << 3) & BM_DRAM_CTL38_RSVD1)
#define BP_DRAM_CTL38_TCKE	0
#define BM_DRAM_CTL38_TCKE	0x00000007
#define BF_DRAM_CTL38_TCKE(v)  \
		(((v) << 0) & BM_DRAM_CTL38_TCKE)

#define HW_DRAM_CTL39	(0x0000009c)

#define BP_DRAM_CTL39_RSVD1	30
#define BM_DRAM_CTL39_RSVD1	0xC0000000
#define BF_DRAM_CTL39_RSVD1(v) \
		(((v) << 30) & BM_DRAM_CTL39_RSVD1)
#define BP_DRAM_CTL39_TFAW	24
#define BM_DRAM_CTL39_TFAW	0x3F000000
#define BF_DRAM_CTL39_TFAW(v)  \
		(((v) << 24) & BM_DRAM_CTL39_TFAW)
#define BP_DRAM_CTL39_OBSOLETE	16
#define BM_DRAM_CTL39_OBSOLETE	0x00FF0000
#define BF_DRAM_CTL39_OBSOLETE(v)  \
		(((v) << 16) & BM_DRAM_CTL39_OBSOLETE)
#define BP_DRAM_CTL39_TDLL	0
#define BM_DRAM_CTL39_TDLL	0x0000FFFF
#define BF_DRAM_CTL39_TDLL(v)  \
		(((v) << 0) & BM_DRAM_CTL39_TDLL)

#define HW_DRAM_CTL40	(0x000000a0)

#define BP_DRAM_CTL40_RSVD1	29
#define BM_DRAM_CTL40_RSVD1	0xE0000000
#define BF_DRAM_CTL40_RSVD1(v) \
		(((v) << 29) & BM_DRAM_CTL40_RSVD1)
#define BP_DRAM_CTL40_TMRD	24
#define BM_DRAM_CTL40_TMRD	0x1F000000
#define BF_DRAM_CTL40_TMRD(v)  \
		(((v) << 24) & BM_DRAM_CTL40_TMRD)
#define BP_DRAM_CTL40_TINIT	0
#define BM_DRAM_CTL40_TINIT	0x00FFFFFF
#define BF_DRAM_CTL40_TINIT(v)  \
		(((v) << 0) & BM_DRAM_CTL40_TINIT)

#define HW_DRAM_CTL41	(0x000000a4)

#define BP_DRAM_CTL41_TPDEX	16
#define BM_DRAM_CTL41_TPDEX	0xFFFF0000
#define BF_DRAM_CTL41_TPDEX(v) \
		(((v) << 16) & BM_DRAM_CTL41_TPDEX)
#define BP_DRAM_CTL41_TRCD_INT	8
#define BM_DRAM_CTL41_TRCD_INT	0x0000FF00
#define BF_DRAM_CTL41_TRCD_INT(v)  \
		(((v) << 8) & BM_DRAM_CTL41_TRCD_INT)
#define BP_DRAM_CTL41_RSVD1	6
#define BM_DRAM_CTL41_RSVD1	0x000000C0
#define BF_DRAM_CTL41_RSVD1(v)  \
		(((v) << 6) & BM_DRAM_CTL41_RSVD1)
#define BP_DRAM_CTL41_TRC	0
#define BM_DRAM_CTL41_TRC	0x0000003F
#define BF_DRAM_CTL41_TRC(v)  \
		(((v) << 0) & BM_DRAM_CTL41_TRC)

#define HW_DRAM_CTL42	(0x000000a8)

#define BP_DRAM_CTL42_OBSOLETE	24
#define BM_DRAM_CTL42_OBSOLETE	0xFF000000
#define BF_DRAM_CTL42_OBSOLETE(v) \
		(((v) << 24) & BM_DRAM_CTL42_OBSOLETE)
#define BP_DRAM_CTL42_TRAS_MAX	8
#define BM_DRAM_CTL42_TRAS_MAX	0x00FFFF00
#define BF_DRAM_CTL42_TRAS_MAX(v)  \
		(((v) << 8) & BM_DRAM_CTL42_TRAS_MAX)
#define BP_DRAM_CTL42_TRAS_MIN	0
#define BM_DRAM_CTL42_TRAS_MIN	0x000000FF
#define BF_DRAM_CTL42_TRAS_MIN(v)  \
		(((v) << 0) & BM_DRAM_CTL42_TRAS_MIN)

#define HW_DRAM_CTL43	(0x000000ac)

#define BP_DRAM_CTL43_RSVD2	28
#define BM_DRAM_CTL43_RSVD2	0xF0000000
#define BF_DRAM_CTL43_RSVD2(v) \
		(((v) << 28) & BM_DRAM_CTL43_RSVD2)
#define BP_DRAM_CTL43_TRP	24
#define BM_DRAM_CTL43_TRP	0x0F000000
#define BF_DRAM_CTL43_TRP(v)  \
		(((v) << 24) & BM_DRAM_CTL43_TRP)
#define BP_DRAM_CTL43_TRFC	16
#define BM_DRAM_CTL43_TRFC	0x00FF0000
#define BF_DRAM_CTL43_TRFC(v)  \
		(((v) << 16) & BM_DRAM_CTL43_TRFC)
#define BP_DRAM_CTL43_RSVD1	14
#define BM_DRAM_CTL43_RSVD1	0x0000C000
#define BF_DRAM_CTL43_RSVD1(v)  \
		(((v) << 14) & BM_DRAM_CTL43_RSVD1)
#define BP_DRAM_CTL43_TREF	0
#define BM_DRAM_CTL43_TREF	0x00003FFF
#define BF_DRAM_CTL43_TREF(v)  \
		(((v) << 0) & BM_DRAM_CTL43_TREF)

#define HW_DRAM_CTL44	(0x000000b0)

#define BP_DRAM_CTL44_RSVD4	28
#define BM_DRAM_CTL44_RSVD4	0xF0000000
#define BF_DRAM_CTL44_RSVD4(v) \
		(((v) << 28) & BM_DRAM_CTL44_RSVD4)
#define BP_DRAM_CTL44_TWTR	24
#define BM_DRAM_CTL44_TWTR	0x0F000000
#define BF_DRAM_CTL44_TWTR(v)  \
		(((v) << 24) & BM_DRAM_CTL44_TWTR)
#define BP_DRAM_CTL44_RSVD3	21
#define BM_DRAM_CTL44_RSVD3	0x00E00000
#define BF_DRAM_CTL44_RSVD3(v)  \
		(((v) << 21) & BM_DRAM_CTL44_RSVD3)
#define BP_DRAM_CTL44_TWR_INT	16
#define BM_DRAM_CTL44_TWR_INT	0x001F0000
#define BF_DRAM_CTL44_TWR_INT(v)  \
		(((v) << 16) & BM_DRAM_CTL44_TWR_INT)
#define BP_DRAM_CTL44_RSVD2	11
#define BM_DRAM_CTL44_RSVD2	0x0000F800
#define BF_DRAM_CTL44_RSVD2(v)  \
		(((v) << 11) & BM_DRAM_CTL44_RSVD2)
#define BP_DRAM_CTL44_TRTP	8
#define BM_DRAM_CTL44_TRTP	0x00000700
#define BF_DRAM_CTL44_TRTP(v)  \
		(((v) << 8) & BM_DRAM_CTL44_TRTP)
#define BP_DRAM_CTL44_RSVD1	3
#define BM_DRAM_CTL44_RSVD1	0x000000F8
#define BF_DRAM_CTL44_RSVD1(v)  \
		(((v) << 3) & BM_DRAM_CTL44_RSVD1)
#define BP_DRAM_CTL44_TRRD	0
#define BM_DRAM_CTL44_TRRD	0x00000007
#define BF_DRAM_CTL44_TRRD(v)  \
		(((v) << 0) & BM_DRAM_CTL44_TRRD)

#define HW_DRAM_CTL45	(0x000000b4)

#define BP_DRAM_CTL45_TXSR	16
#define BM_DRAM_CTL45_TXSR	0xFFFF0000
#define BF_DRAM_CTL45_TXSR(v) \
		(((v) << 16) & BM_DRAM_CTL45_TXSR)
#define BP_DRAM_CTL45_TXSNR	0
#define BM_DRAM_CTL45_TXSNR	0x0000FFFF
#define BF_DRAM_CTL45_TXSNR(v)  \
		(((v) << 0) & BM_DRAM_CTL45_TXSNR)

#define HW_DRAM_CTL48	(0x000000c0)

#define BM_DRAM_CTL48_RSVD4	0x80000000
#define BP_DRAM_CTL48_AXI0_CURRENT_BDW	24
#define BM_DRAM_CTL48_AXI0_CURRENT_BDW	0x7F000000
#define BF_DRAM_CTL48_AXI0_CURRENT_BDW(v)  \
		(((v) << 24) & BM_DRAM_CTL48_AXI0_CURRENT_BDW)
#define BP_DRAM_CTL48_RSVD3	17
#define BM_DRAM_CTL48_RSVD3	0x00FE0000
#define BF_DRAM_CTL48_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL48_RSVD3)
#define BM_DRAM_CTL48_AXI0_BDW_OVFLOW	0x00010000
#define BM_DRAM_CTL48_RSVD2	0x00008000
#define BP_DRAM_CTL48_AXI0_BDW	8
#define BM_DRAM_CTL48_AXI0_BDW	0x00007F00
#define BF_DRAM_CTL48_AXI0_BDW(v)  \
		(((v) << 8) & BM_DRAM_CTL48_AXI0_BDW)
#define BP_DRAM_CTL48_RSVD1	2
#define BM_DRAM_CTL48_RSVD1	0x000000FC
#define BF_DRAM_CTL48_RSVD1(v)  \
		(((v) << 2) & BM_DRAM_CTL48_RSVD1)
#define BP_DRAM_CTL48_AXI0_FIFO_TYPE_REG	0
#define BM_DRAM_CTL48_AXI0_FIFO_TYPE_REG	0x00000003
#define BF_DRAM_CTL48_AXI0_FIFO_TYPE_REG(v)  \
		(((v) << 0) & BM_DRAM_CTL48_AXI0_FIFO_TYPE_REG)

#define HW_DRAM_CTL49	(0x000000c4)

#define BP_DRAM_CTL49_AXI0_EN_SIZE_LT_WIDTH_INSTR	16
#define BM_DRAM_CTL49_AXI0_EN_SIZE_LT_WIDTH_INSTR	0xFFFF0000
#define BF_DRAM_CTL49_AXI0_EN_SIZE_LT_WIDTH_INSTR(v) \
		(((v) << 16) & BM_DRAM_CTL49_AXI0_EN_SIZE_LT_WIDTH_INSTR)
#define BP_DRAM_CTL49_RSVD2	11
#define BM_DRAM_CTL49_RSVD2	0x0000F800
#define BF_DRAM_CTL49_RSVD2(v)  \
		(((v) << 11) & BM_DRAM_CTL49_RSVD2)
#define BP_DRAM_CTL49_AXI0_W_PRIORITY	8
#define BM_DRAM_CTL49_AXI0_W_PRIORITY	0x00000700
#define BF_DRAM_CTL49_AXI0_W_PRIORITY(v)  \
		(((v) << 8) & BM_DRAM_CTL49_AXI0_W_PRIORITY)
#define BP_DRAM_CTL49_RSVD1	3
#define BM_DRAM_CTL49_RSVD1	0x000000F8
#define BF_DRAM_CTL49_RSVD1(v)  \
		(((v) << 3) & BM_DRAM_CTL49_RSVD1)
#define BP_DRAM_CTL49_AXI0_R_PRIORITY	0
#define BM_DRAM_CTL49_AXI0_R_PRIORITY	0x00000007
#define BF_DRAM_CTL49_AXI0_R_PRIORITY(v)  \
		(((v) << 0) & BM_DRAM_CTL49_AXI0_R_PRIORITY)

#define HW_DRAM_CTL50	(0x000000c8)

#define BM_DRAM_CTL50_RSVD4	0x80000000
#define BP_DRAM_CTL50_AXI1_CURRENT_BDW	24
#define BM_DRAM_CTL50_AXI1_CURRENT_BDW	0x7F000000
#define BF_DRAM_CTL50_AXI1_CURRENT_BDW(v)  \
		(((v) << 24) & BM_DRAM_CTL50_AXI1_CURRENT_BDW)
#define BP_DRAM_CTL50_RSVD3	17
#define BM_DRAM_CTL50_RSVD3	0x00FE0000
#define BF_DRAM_CTL50_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL50_RSVD3)
#define BM_DRAM_CTL50_AXI1_BDW_OVFLOW	0x00010000
#define BM_DRAM_CTL50_RSVD2	0x00008000
#define BP_DRAM_CTL50_AXI1_BDW	8
#define BM_DRAM_CTL50_AXI1_BDW	0x00007F00
#define BF_DRAM_CTL50_AXI1_BDW(v)  \
		(((v) << 8) & BM_DRAM_CTL50_AXI1_BDW)
#define BP_DRAM_CTL50_RSVD1	2
#define BM_DRAM_CTL50_RSVD1	0x000000FC
#define BF_DRAM_CTL50_RSVD1(v)  \
		(((v) << 2) & BM_DRAM_CTL50_RSVD1)
#define BP_DRAM_CTL50_AXI1_FIFO_TYPE_REG	0
#define BM_DRAM_CTL50_AXI1_FIFO_TYPE_REG	0x00000003
#define BF_DRAM_CTL50_AXI1_FIFO_TYPE_REG(v)  \
		(((v) << 0) & BM_DRAM_CTL50_AXI1_FIFO_TYPE_REG)

#define HW_DRAM_CTL51	(0x000000cc)

#define BP_DRAM_CTL51_AXI1_EN_SIZE_LT_WIDTH_INSTR	16
#define BM_DRAM_CTL51_AXI1_EN_SIZE_LT_WIDTH_INSTR	0xFFFF0000
#define BF_DRAM_CTL51_AXI1_EN_SIZE_LT_WIDTH_INSTR(v) \
		(((v) << 16) & BM_DRAM_CTL51_AXI1_EN_SIZE_LT_WIDTH_INSTR)
#define BP_DRAM_CTL51_RSVD2	11
#define BM_DRAM_CTL51_RSVD2	0x0000F800
#define BF_DRAM_CTL51_RSVD2(v)  \
		(((v) << 11) & BM_DRAM_CTL51_RSVD2)
#define BP_DRAM_CTL51_AXI1_W_PRIORITY	8
#define BM_DRAM_CTL51_AXI1_W_PRIORITY	0x00000700
#define BF_DRAM_CTL51_AXI1_W_PRIORITY(v)  \
		(((v) << 8) & BM_DRAM_CTL51_AXI1_W_PRIORITY)
#define BP_DRAM_CTL51_RSVD1	3
#define BM_DRAM_CTL51_RSVD1	0x000000F8
#define BF_DRAM_CTL51_RSVD1(v)  \
		(((v) << 3) & BM_DRAM_CTL51_RSVD1)
#define BP_DRAM_CTL51_AXI1_R_PRIORITY	0
#define BM_DRAM_CTL51_AXI1_R_PRIORITY	0x00000007
#define BF_DRAM_CTL51_AXI1_R_PRIORITY(v)  \
		(((v) << 0) & BM_DRAM_CTL51_AXI1_R_PRIORITY)

#define HW_DRAM_CTL52	(0x000000d0)

#define BM_DRAM_CTL52_RSVD4	0x80000000
#define BP_DRAM_CTL52_AXI2_CURRENT_BDW	24
#define BM_DRAM_CTL52_AXI2_CURRENT_BDW	0x7F000000
#define BF_DRAM_CTL52_AXI2_CURRENT_BDW(v)  \
		(((v) << 24) & BM_DRAM_CTL52_AXI2_CURRENT_BDW)
#define BP_DRAM_CTL52_RSVD3	17
#define BM_DRAM_CTL52_RSVD3	0x00FE0000
#define BF_DRAM_CTL52_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL52_RSVD3)
#define BM_DRAM_CTL52_AXI2_BDW_OVFLOW	0x00010000
#define BM_DRAM_CTL52_RSVD2	0x00008000
#define BP_DRAM_CTL52_AXI2_BDW	8
#define BM_DRAM_CTL52_AXI2_BDW	0x00007F00
#define BF_DRAM_CTL52_AXI2_BDW(v)  \
		(((v) << 8) & BM_DRAM_CTL52_AXI2_BDW)
#define BP_DRAM_CTL52_RSVD1	2
#define BM_DRAM_CTL52_RSVD1	0x000000FC
#define BF_DRAM_CTL52_RSVD1(v)  \
		(((v) << 2) & BM_DRAM_CTL52_RSVD1)
#define BP_DRAM_CTL52_AXI2_FIFO_TYPE_REG	0
#define BM_DRAM_CTL52_AXI2_FIFO_TYPE_REG	0x00000003
#define BF_DRAM_CTL52_AXI2_FIFO_TYPE_REG(v)  \
		(((v) << 0) & BM_DRAM_CTL52_AXI2_FIFO_TYPE_REG)

#define HW_DRAM_CTL53	(0x000000d4)

#define BP_DRAM_CTL53_AXI2_EN_SIZE_LT_WIDTH_INSTR	16
#define BM_DRAM_CTL53_AXI2_EN_SIZE_LT_WIDTH_INSTR	0xFFFF0000
#define BF_DRAM_CTL53_AXI2_EN_SIZE_LT_WIDTH_INSTR(v) \
		(((v) << 16) & BM_DRAM_CTL53_AXI2_EN_SIZE_LT_WIDTH_INSTR)
#define BP_DRAM_CTL53_RSVD2	11
#define BM_DRAM_CTL53_RSVD2	0x0000F800
#define BF_DRAM_CTL53_RSVD2(v)  \
		(((v) << 11) & BM_DRAM_CTL53_RSVD2)
#define BP_DRAM_CTL53_AXI2_W_PRIORITY	8
#define BM_DRAM_CTL53_AXI2_W_PRIORITY	0x00000700
#define BF_DRAM_CTL53_AXI2_W_PRIORITY(v)  \
		(((v) << 8) & BM_DRAM_CTL53_AXI2_W_PRIORITY)
#define BP_DRAM_CTL53_RSVD1	3
#define BM_DRAM_CTL53_RSVD1	0x000000F8
#define BF_DRAM_CTL53_RSVD1(v)  \
		(((v) << 3) & BM_DRAM_CTL53_RSVD1)
#define BP_DRAM_CTL53_AXI2_R_PRIORITY	0
#define BM_DRAM_CTL53_AXI2_R_PRIORITY	0x00000007
#define BF_DRAM_CTL53_AXI2_R_PRIORITY(v)  \
		(((v) << 0) & BM_DRAM_CTL53_AXI2_R_PRIORITY)

#define HW_DRAM_CTL54	(0x000000d8)

#define BM_DRAM_CTL54_RSVD4	0x80000000
#define BP_DRAM_CTL54_AXI3_CURRENT_BDW	24
#define BM_DRAM_CTL54_AXI3_CURRENT_BDW	0x7F000000
#define BF_DRAM_CTL54_AXI3_CURRENT_BDW(v)  \
		(((v) << 24) & BM_DRAM_CTL54_AXI3_CURRENT_BDW)
#define BP_DRAM_CTL54_RSVD3	17
#define BM_DRAM_CTL54_RSVD3	0x00FE0000
#define BF_DRAM_CTL54_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL54_RSVD3)
#define BM_DRAM_CTL54_AXI3_BDW_OVFLOW	0x00010000
#define BM_DRAM_CTL54_RSVD2	0x00008000
#define BP_DRAM_CTL54_AXI3_BDW	8
#define BM_DRAM_CTL54_AXI3_BDW	0x00007F00
#define BF_DRAM_CTL54_AXI3_BDW(v)  \
		(((v) << 8) & BM_DRAM_CTL54_AXI3_BDW)
#define BP_DRAM_CTL54_RSVD1	2
#define BM_DRAM_CTL54_RSVD1	0x000000FC
#define BF_DRAM_CTL54_RSVD1(v)  \
		(((v) << 2) & BM_DRAM_CTL54_RSVD1)
#define BP_DRAM_CTL54_AXI3_FIFO_TYPE_REG	0
#define BM_DRAM_CTL54_AXI3_FIFO_TYPE_REG	0x00000003
#define BF_DRAM_CTL54_AXI3_FIFO_TYPE_REG(v)  \
		(((v) << 0) & BM_DRAM_CTL54_AXI3_FIFO_TYPE_REG)

#define HW_DRAM_CTL55	(0x000000dc)

#define BP_DRAM_CTL55_AXI3_EN_SIZE_LT_WIDTH_INSTR	16
#define BM_DRAM_CTL55_AXI3_EN_SIZE_LT_WIDTH_INSTR	0xFFFF0000
#define BF_DRAM_CTL55_AXI3_EN_SIZE_LT_WIDTH_INSTR(v) \
		(((v) << 16) & BM_DRAM_CTL55_AXI3_EN_SIZE_LT_WIDTH_INSTR)
#define BP_DRAM_CTL55_RSVD2	11
#define BM_DRAM_CTL55_RSVD2	0x0000F800
#define BF_DRAM_CTL55_RSVD2(v)  \
		(((v) << 11) & BM_DRAM_CTL55_RSVD2)
#define BP_DRAM_CTL55_AXI3_W_PRIORITY	8
#define BM_DRAM_CTL55_AXI3_W_PRIORITY	0x00000700
#define BF_DRAM_CTL55_AXI3_W_PRIORITY(v)  \
		(((v) << 8) & BM_DRAM_CTL55_AXI3_W_PRIORITY)
#define BP_DRAM_CTL55_RSVD1	3
#define BM_DRAM_CTL55_RSVD1	0x000000F8
#define BF_DRAM_CTL55_RSVD1(v)  \
		(((v) << 3) & BM_DRAM_CTL55_RSVD1)
#define BP_DRAM_CTL55_AXI3_R_PRIORITY	0
#define BM_DRAM_CTL55_AXI3_R_PRIORITY	0x00000007
#define BF_DRAM_CTL55_AXI3_R_PRIORITY(v)  \
		(((v) << 0) & BM_DRAM_CTL55_AXI3_R_PRIORITY)

#define HW_DRAM_CTL56	(0x000000e0)

#define BP_DRAM_CTL56_OBSOLETE	8
#define BM_DRAM_CTL56_OBSOLETE	0xFFFFFF00
#define BF_DRAM_CTL56_OBSOLETE(v) \
		(((v) << 8) & BM_DRAM_CTL56_OBSOLETE)
#define BP_DRAM_CTL56_RSVD1	3
#define BM_DRAM_CTL56_RSVD1	0x000000F8
#define BF_DRAM_CTL56_RSVD1(v)  \
		(((v) << 3) & BM_DRAM_CTL56_RSVD1)
#define BP_DRAM_CTL56_ARB_CMD_Q_THRESHOLD	0
#define BM_DRAM_CTL56_ARB_CMD_Q_THRESHOLD	0x00000007
#define BF_DRAM_CTL56_ARB_CMD_Q_THRESHOLD(v)  \
		(((v) << 0) & BM_DRAM_CTL56_ARB_CMD_Q_THRESHOLD)

#define HW_DRAM_CTL58	(0x000000e8)

#define BP_DRAM_CTL58_RSVD2	27
#define BM_DRAM_CTL58_RSVD2	0xF8000000
#define BF_DRAM_CTL58_RSVD2(v) \
		(((v) << 27) & BM_DRAM_CTL58_RSVD2)
#define BP_DRAM_CTL58_INT_STATUS	16
#define BM_DRAM_CTL58_INT_STATUS	0x07FF0000
#define BF_DRAM_CTL58_INT_STATUS(v)  \
		(((v) << 16) & BM_DRAM_CTL58_INT_STATUS)
#define BP_DRAM_CTL58_RSVD1	11
#define BM_DRAM_CTL58_RSVD1	0x0000F800
#define BF_DRAM_CTL58_RSVD1(v)  \
		(((v) << 11) & BM_DRAM_CTL58_RSVD1)
#define BP_DRAM_CTL58_INT_MASK	0
#define BM_DRAM_CTL58_INT_MASK	0x000007FF
#define BF_DRAM_CTL58_INT_MASK(v)  \
		(((v) << 0) & BM_DRAM_CTL58_INT_MASK)

#define HW_DRAM_CTL59	(0x000000ec)

#define BP_DRAM_CTL59_OUT_OF_RANGE_ADDR	0
#define BM_DRAM_CTL59_OUT_OF_RANGE_ADDR	0xFFFFFFFF
#define BF_DRAM_CTL59_OUT_OF_RANGE_ADDR(v)	(v)

#define HW_DRAM_CTL60	(0x000000f0)

#define BP_DRAM_CTL60_OBSOLETE	8
#define BM_DRAM_CTL60_OBSOLETE	0xFFFFFF00
#define BF_DRAM_CTL60_OBSOLETE(v) \
		(((v) << 8) & BM_DRAM_CTL60_OBSOLETE)
#define BP_DRAM_CTL60_RSVD1	2
#define BM_DRAM_CTL60_RSVD1	0x000000FC
#define BF_DRAM_CTL60_RSVD1(v)  \
		(((v) << 2) & BM_DRAM_CTL60_RSVD1)
#define BP_DRAM_CTL60_OUT_OF_RANGE_ADDR	0
#define BM_DRAM_CTL60_OUT_OF_RANGE_ADDR	0x00000003
#define BF_DRAM_CTL60_OUT_OF_RANGE_ADDR(v)  \
		(((v) << 0) & BM_DRAM_CTL60_OUT_OF_RANGE_ADDR)

#define HW_DRAM_CTL61	(0x000000f4)

#define BP_DRAM_CTL61_RSVD3	30
#define BM_DRAM_CTL61_RSVD3	0xC0000000
#define BF_DRAM_CTL61_RSVD3(v) \
		(((v) << 30) & BM_DRAM_CTL61_RSVD3)
#define BP_DRAM_CTL61_OUT_OF_RANGE_TYPE	24
#define BM_DRAM_CTL61_OUT_OF_RANGE_TYPE	0x3F000000
#define BF_DRAM_CTL61_OUT_OF_RANGE_TYPE(v)  \
		(((v) << 24) & BM_DRAM_CTL61_OUT_OF_RANGE_TYPE)
#define BM_DRAM_CTL61_RSVD2	0x00800000
#define BP_DRAM_CTL61_OUT_OF_RANGE_LENGTH	16
#define BM_DRAM_CTL61_OUT_OF_RANGE_LENGTH	0x007F0000
#define BF_DRAM_CTL61_OUT_OF_RANGE_LENGTH(v)  \
		(((v) << 16) & BM_DRAM_CTL61_OUT_OF_RANGE_LENGTH)
#define BP_DRAM_CTL61_RSVD1	13
#define BM_DRAM_CTL61_RSVD1	0x0000E000
#define BF_DRAM_CTL61_RSVD1(v)  \
		(((v) << 13) & BM_DRAM_CTL61_RSVD1)
#define BP_DRAM_CTL61_OUT_OF_RANGE_SOURCE_ID	0
#define BM_DRAM_CTL61_OUT_OF_RANGE_SOURCE_ID	0x00001FFF
#define BF_DRAM_CTL61_OUT_OF_RANGE_SOURCE_ID(v)  \
		(((v) << 0) & BM_DRAM_CTL61_OUT_OF_RANGE_SOURCE_ID)

#define HW_DRAM_CTL62	(0x000000f8)

#define BP_DRAM_CTL62_PORT_CMD_ERROR_ADDR	0
#define BM_DRAM_CTL62_PORT_CMD_ERROR_ADDR	0xFFFFFFFF
#define BF_DRAM_CTL62_PORT_CMD_ERROR_ADDR(v)	(v)

#define HW_DRAM_CTL63	(0x000000fc)

#define BP_DRAM_CTL63_OBSOLETE	8
#define BM_DRAM_CTL63_OBSOLETE	0xFFFFFF00
#define BF_DRAM_CTL63_OBSOLETE(v) \
		(((v) << 8) & BM_DRAM_CTL63_OBSOLETE)
#define BP_DRAM_CTL63_RSVD1	2
#define BM_DRAM_CTL63_RSVD1	0x000000FC
#define BF_DRAM_CTL63_RSVD1(v)  \
		(((v) << 2) & BM_DRAM_CTL63_RSVD1)
#define BP_DRAM_CTL63_PORT_CMD_ERROR_ADDR	0
#define BM_DRAM_CTL63_PORT_CMD_ERROR_ADDR	0x00000003
#define BF_DRAM_CTL63_PORT_CMD_ERROR_ADDR(v)  \
		(((v) << 0) & BM_DRAM_CTL63_PORT_CMD_ERROR_ADDR)

#define HW_DRAM_CTL64	(0x00000100)

#define BP_DRAM_CTL64_OBSOLETE	24
#define BM_DRAM_CTL64_OBSOLETE	0xFF000000
#define BF_DRAM_CTL64_OBSOLETE(v) \
		(((v) << 24) & BM_DRAM_CTL64_OBSOLETE)
#define BP_DRAM_CTL64_RSVD2	21
#define BM_DRAM_CTL64_RSVD2	0x00E00000
#define BF_DRAM_CTL64_RSVD2(v)  \
		(((v) << 21) & BM_DRAM_CTL64_RSVD2)
#define BP_DRAM_CTL64_PORT_CMD_ERROR_ID	8
#define BM_DRAM_CTL64_PORT_CMD_ERROR_ID	0x001FFF00
#define BF_DRAM_CTL64_PORT_CMD_ERROR_ID(v)  \
		(((v) << 8) & BM_DRAM_CTL64_PORT_CMD_ERROR_ID)
#define BP_DRAM_CTL64_RSVD1	4
#define BM_DRAM_CTL64_RSVD1	0x000000F0
#define BF_DRAM_CTL64_RSVD1(v)  \
		(((v) << 4) & BM_DRAM_CTL64_RSVD1)
#define BP_DRAM_CTL64_PORT_CMD_ERROR_TYPE	0
#define BM_DRAM_CTL64_PORT_CMD_ERROR_TYPE	0x0000000F
#define BF_DRAM_CTL64_PORT_CMD_ERROR_TYPE(v)  \
		(((v) << 0) & BM_DRAM_CTL64_PORT_CMD_ERROR_TYPE)

#define HW_DRAM_CTL65	(0x00000104)

#define BP_DRAM_CTL65_OBSOLETE	24
#define BM_DRAM_CTL65_OBSOLETE	0xFF000000
#define BF_DRAM_CTL65_OBSOLETE(v) \
		(((v) << 24) & BM_DRAM_CTL65_OBSOLETE)
#define BP_DRAM_CTL65_RSVD2	21
#define BM_DRAM_CTL65_RSVD2	0x00E00000
#define BF_DRAM_CTL65_RSVD2(v)  \
		(((v) << 21) & BM_DRAM_CTL65_RSVD2)
#define BP_DRAM_CTL65_PORT_DATA_ERROR_ID	8
#define BM_DRAM_CTL65_PORT_DATA_ERROR_ID	0x001FFF00
#define BF_DRAM_CTL65_PORT_DATA_ERROR_ID(v)  \
		(((v) << 8) & BM_DRAM_CTL65_PORT_DATA_ERROR_ID)
#define BP_DRAM_CTL65_RSVD1	3
#define BM_DRAM_CTL65_RSVD1	0x000000F8
#define BF_DRAM_CTL65_RSVD1(v)  \
		(((v) << 3) & BM_DRAM_CTL65_RSVD1)
#define BP_DRAM_CTL65_PORT_DATA_ERROR_TYPE	0
#define BM_DRAM_CTL65_PORT_DATA_ERROR_TYPE	0x00000007
#define BF_DRAM_CTL65_PORT_DATA_ERROR_TYPE(v)  \
		(((v) << 0) & BM_DRAM_CTL65_PORT_DATA_ERROR_TYPE)

#define HW_DRAM_CTL66	(0x00000108)

#define BP_DRAM_CTL66_OBSOLETE	24
#define BM_DRAM_CTL66_OBSOLETE	0xFF000000
#define BF_DRAM_CTL66_OBSOLETE(v) \
		(((v) << 24) & BM_DRAM_CTL66_OBSOLETE)
#define BP_DRAM_CTL66_RSVD2	20
#define BM_DRAM_CTL66_RSVD2	0x00F00000
#define BF_DRAM_CTL66_RSVD2(v)  \
		(((v) << 20) & BM_DRAM_CTL66_RSVD2)
#define BP_DRAM_CTL66_TDFI_CTRLUPD_MIN	16
#define BM_DRAM_CTL66_TDFI_CTRLUPD_MIN	0x000F0000
#define BF_DRAM_CTL66_TDFI_CTRLUPD_MIN(v)  \
		(((v) << 16) & BM_DRAM_CTL66_TDFI_CTRLUPD_MIN)
#define BP_DRAM_CTL66_RSVD1	14
#define BM_DRAM_CTL66_RSVD1	0x0000C000
#define BF_DRAM_CTL66_RSVD1(v)  \
		(((v) << 14) & BM_DRAM_CTL66_RSVD1)
#define BP_DRAM_CTL66_TDFI_CTRLUPD_MAX	0
#define BM_DRAM_CTL66_TDFI_CTRLUPD_MAX	0x00003FFF
#define BF_DRAM_CTL66_TDFI_CTRLUPD_MAX(v)  \
		(((v) << 0) & BM_DRAM_CTL66_TDFI_CTRLUPD_MAX)

#define HW_DRAM_CTL67	(0x0000010c)

#define BP_DRAM_CTL67_RSVD4	28
#define BM_DRAM_CTL67_RSVD4	0xF0000000
#define BF_DRAM_CTL67_RSVD4(v) \
		(((v) << 28) & BM_DRAM_CTL67_RSVD4)
#define BP_DRAM_CTL67_TDFI_DRAM_CLK_ENABLE	24
#define BM_DRAM_CTL67_TDFI_DRAM_CLK_ENABLE	0x0F000000
#define BF_DRAM_CTL67_TDFI_DRAM_CLK_ENABLE(v)  \
		(((v) << 24) & BM_DRAM_CTL67_TDFI_DRAM_CLK_ENABLE)
#define BP_DRAM_CTL67_RSVD3	19
#define BM_DRAM_CTL67_RSVD3	0x00F80000
#define BF_DRAM_CTL67_RSVD3(v)  \
		(((v) << 19) & BM_DRAM_CTL67_RSVD3)
#define BP_DRAM_CTL67_TDFI_DRAM_CLK_DISABLE	16
#define BM_DRAM_CTL67_TDFI_DRAM_CLK_DISABLE	0x00070000
#define BF_DRAM_CTL67_TDFI_DRAM_CLK_DISABLE(v)  \
		(((v) << 16) & BM_DRAM_CTL67_TDFI_DRAM_CLK_DISABLE)
#define BP_DRAM_CTL67_RSVD2	12
#define BM_DRAM_CTL67_RSVD2	0x0000F000
#define BF_DRAM_CTL67_RSVD2(v)  \
		(((v) << 12) & BM_DRAM_CTL67_RSVD2)
#define BP_DRAM_CTL67_DRAM_CLK_ENABLE	8
#define BM_DRAM_CTL67_DRAM_CLK_ENABLE	0x00000F00
#define BF_DRAM_CTL67_DRAM_CLK_ENABLE(v)  \
		(((v) << 8) & BM_DRAM_CTL67_DRAM_CLK_ENABLE)
#define BP_DRAM_CTL67_RSVD1	4
#define BM_DRAM_CTL67_RSVD1	0x000000F0
#define BF_DRAM_CTL67_RSVD1(v)  \
		(((v) << 4) & BM_DRAM_CTL67_RSVD1)
#define BP_DRAM_CTL67_TDFI_CTRL_DELAY	0
#define BM_DRAM_CTL67_TDFI_CTRL_DELAY	0x0000000F
#define BF_DRAM_CTL67_TDFI_CTRL_DELAY(v)  \
		(((v) << 0) & BM_DRAM_CTL67_TDFI_CTRL_DELAY)

#define HW_DRAM_CTL68	(0x00000110)

#define BP_DRAM_CTL68_RSVD2	30
#define BM_DRAM_CTL68_RSVD2	0xC0000000
#define BF_DRAM_CTL68_RSVD2(v) \
		(((v) << 30) & BM_DRAM_CTL68_RSVD2)
#define BP_DRAM_CTL68_TDFI_PHYUPD_TYPE0	16
#define BM_DRAM_CTL68_TDFI_PHYUPD_TYPE0	0x3FFF0000
#define BF_DRAM_CTL68_TDFI_PHYUPD_TYPE0(v)  \
		(((v) << 16) & BM_DRAM_CTL68_TDFI_PHYUPD_TYPE0)
#define BP_DRAM_CTL68_RSVD1	14
#define BM_DRAM_CTL68_RSVD1	0x0000C000
#define BF_DRAM_CTL68_RSVD1(v)  \
		(((v) << 14) & BM_DRAM_CTL68_RSVD1)
#define BP_DRAM_CTL68_TDFI_PHYUPD_RESP	0
#define BM_DRAM_CTL68_TDFI_PHYUPD_RESP	0x00003FFF
#define BF_DRAM_CTL68_TDFI_PHYUPD_RESP(v)  \
		(((v) << 0) & BM_DRAM_CTL68_TDFI_PHYUPD_RESP)

#define HW_DRAM_CTL69	(0x00000114)

#define BP_DRAM_CTL69_OBSOLETE	16
#define BM_DRAM_CTL69_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL69_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL69_OBSOLETE)
#define BP_DRAM_CTL69_RSVD2	12
#define BM_DRAM_CTL69_RSVD2	0x0000F000
#define BF_DRAM_CTL69_RSVD2(v)  \
		(((v) << 12) & BM_DRAM_CTL69_RSVD2)
#define BP_DRAM_CTL69_TDFI_PHY_WRLAT_BASE	8
#define BM_DRAM_CTL69_TDFI_PHY_WRLAT_BASE	0x00000F00
#define BF_DRAM_CTL69_TDFI_PHY_WRLAT_BASE(v)  \
		(((v) << 8) & BM_DRAM_CTL69_TDFI_PHY_WRLAT_BASE)
#define BP_DRAM_CTL69_RSVD1	4
#define BM_DRAM_CTL69_RSVD1	0x000000F0
#define BF_DRAM_CTL69_RSVD1(v)  \
		(((v) << 4) & BM_DRAM_CTL69_RSVD1)
#define BP_DRAM_CTL69_TDFI_PHY_WRLAT	0
#define BM_DRAM_CTL69_TDFI_PHY_WRLAT	0x0000000F
#define BF_DRAM_CTL69_TDFI_PHY_WRLAT(v)  \
		(((v) << 0) & BM_DRAM_CTL69_TDFI_PHY_WRLAT)

#define HW_DRAM_CTL70	(0x00000118)

#define BP_DRAM_CTL70_OBSOLETE	24
#define BM_DRAM_CTL70_OBSOLETE	0xFF000000
#define BF_DRAM_CTL70_OBSOLETE(v) \
		(((v) << 24) & BM_DRAM_CTL70_OBSOLETE)
#define BP_DRAM_CTL70_RSVD3	20
#define BM_DRAM_CTL70_RSVD3	0x00F00000
#define BF_DRAM_CTL70_RSVD3(v)  \
		(((v) << 20) & BM_DRAM_CTL70_RSVD3)
#define BP_DRAM_CTL70_TDFI_RDDATA_EN_BASE	16
#define BM_DRAM_CTL70_TDFI_RDDATA_EN_BASE	0x000F0000
#define BF_DRAM_CTL70_TDFI_RDDATA_EN_BASE(v)  \
		(((v) << 16) & BM_DRAM_CTL70_TDFI_RDDATA_EN_BASE)
#define BP_DRAM_CTL70_RSVD2	12
#define BM_DRAM_CTL70_RSVD2	0x0000F000
#define BF_DRAM_CTL70_RSVD2(v)  \
		(((v) << 12) & BM_DRAM_CTL70_RSVD2)
#define BP_DRAM_CTL70_TDFI_RDDATA_EN	8
#define BM_DRAM_CTL70_TDFI_RDDATA_EN	0x00000F00
#define BF_DRAM_CTL70_TDFI_RDDATA_EN(v)  \
		(((v) << 8) & BM_DRAM_CTL70_TDFI_RDDATA_EN)
#define BP_DRAM_CTL70_RSVD1	4
#define BM_DRAM_CTL70_RSVD1	0x000000F0
#define BF_DRAM_CTL70_RSVD1(v)  \
		(((v) << 4) & BM_DRAM_CTL70_RSVD1)
#define BP_DRAM_CTL70_TDFI_PHY_RDLAT	0
#define BM_DRAM_CTL70_TDFI_PHY_RDLAT	0x0000000F
#define BF_DRAM_CTL70_TDFI_PHY_RDLAT(v)  \
		(((v) << 0) & BM_DRAM_CTL70_TDFI_PHY_RDLAT)

#define HW_DRAM_CTL71	(0x0000011c)

#define BP_DRAM_CTL71_PHY_CTRL_REG_0_0	0
#define BM_DRAM_CTL71_PHY_CTRL_REG_0_0	0xFFFFFFFF
#define BF_DRAM_CTL71_PHY_CTRL_REG_0_0(v)	(v)

#define HW_DRAM_CTL72	(0x00000120)

#define BP_DRAM_CTL72_PHY_CTRL_REG_0_1	0
#define BM_DRAM_CTL72_PHY_CTRL_REG_0_1	0xFFFFFFFF
#define BF_DRAM_CTL72_PHY_CTRL_REG_0_1(v)	(v)

#define HW_DRAM_CTL73	(0x00000124)

#define BP_DRAM_CTL73_PHY_CTRL_REG_0_2	0
#define BM_DRAM_CTL73_PHY_CTRL_REG_0_2	0xFFFFFFFF
#define BF_DRAM_CTL73_PHY_CTRL_REG_0_2(v)	(v)

#define HW_DRAM_CTL74	(0x00000128)

#define BP_DRAM_CTL74_PHY_CTRL_REG_0_3	0
#define BM_DRAM_CTL74_PHY_CTRL_REG_0_3	0xFFFFFFFF
#define BF_DRAM_CTL74_PHY_CTRL_REG_0_3(v)	(v)

#define HW_DRAM_CTL75	(0x0000012c)

#define BP_DRAM_CTL75_PHY_CTRL_REG_1_0	0
#define BM_DRAM_CTL75_PHY_CTRL_REG_1_0	0xFFFFFFFF
#define BF_DRAM_CTL75_PHY_CTRL_REG_1_0(v)	(v)

#define HW_DRAM_CTL76	(0x00000130)

#define BP_DRAM_CTL76_PHY_CTRL_REG_1_1	0
#define BM_DRAM_CTL76_PHY_CTRL_REG_1_1	0xFFFFFFFF
#define BF_DRAM_CTL76_PHY_CTRL_REG_1_1(v)	(v)

#define HW_DRAM_CTL77	(0x00000134)

#define BP_DRAM_CTL77_PHY_CTRL_REG_1_2	0
#define BM_DRAM_CTL77_PHY_CTRL_REG_1_2	0xFFFFFFFF
#define BF_DRAM_CTL77_PHY_CTRL_REG_1_2(v)	(v)

#define HW_DRAM_CTL78	(0x00000138)

#define BP_DRAM_CTL78_PHY_CTRL_REG_1_3	0
#define BM_DRAM_CTL78_PHY_CTRL_REG_1_3	0xFFFFFFFF
#define BF_DRAM_CTL78_PHY_CTRL_REG_1_3(v)	(v)

#define HW_DRAM_CTL79	(0x0000013c)

#define BP_DRAM_CTL79_PHY_CTRL_REG_2	0
#define BM_DRAM_CTL79_PHY_CTRL_REG_2	0xFFFFFFFF
#define BF_DRAM_CTL79_PHY_CTRL_REG_2(v)	(v)

#define HW_DRAM_CTL80	(0x00000140)

#define BP_DRAM_CTL80_DFT_CTRL_REG	0
#define BM_DRAM_CTL80_DFT_CTRL_REG	0xFFFFFFFF
#define BF_DRAM_CTL80_DFT_CTRL_REG(v)	(v)

#define HW_DRAM_CTL81	(0x00000144)

#define BP_DRAM_CTL81_OBSOLETE	16
#define BM_DRAM_CTL81_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL81_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL81_OBSOLETE)
#define BP_DRAM_CTL81_RSVD2	13
#define BM_DRAM_CTL81_RSVD2	0x0000E000
#define BF_DRAM_CTL81_RSVD2(v)  \
		(((v) << 13) & BM_DRAM_CTL81_RSVD2)
#define BP_DRAM_CTL81_OCD_ADJUST_PUP_CS_0	8
#define BM_DRAM_CTL81_OCD_ADJUST_PUP_CS_0	0x00001F00
#define BF_DRAM_CTL81_OCD_ADJUST_PUP_CS_0(v)  \
		(((v) << 8) & BM_DRAM_CTL81_OCD_ADJUST_PUP_CS_0)
#define BP_DRAM_CTL81_RSVD1	5
#define BM_DRAM_CTL81_RSVD1	0x000000E0
#define BF_DRAM_CTL81_RSVD1(v)  \
		(((v) << 5) & BM_DRAM_CTL81_RSVD1)
#define BP_DRAM_CTL81_OCD_ADJUST_PDN_CS_0	0
#define BM_DRAM_CTL81_OCD_ADJUST_PDN_CS_0	0x0000001F
#define BF_DRAM_CTL81_OCD_ADJUST_PDN_CS_0(v)  \
		(((v) << 0) & BM_DRAM_CTL81_OCD_ADJUST_PDN_CS_0)

#define HW_DRAM_CTL82	(0x00000148)

#define BP_DRAM_CTL82_RSVD1	25
#define BM_DRAM_CTL82_RSVD1	0xFE000000
#define BF_DRAM_CTL82_RSVD1(v) \
		(((v) << 25) & BM_DRAM_CTL82_RSVD1)
#define BM_DRAM_CTL82_ODT_ALT_EN	0x01000000
#define BP_DRAM_CTL82_OBSOLETE	0
#define BM_DRAM_CTL82_OBSOLETE	0x00FFFFFF
#define BF_DRAM_CTL82_OBSOLETE(v)  \
		(((v) << 0) & BM_DRAM_CTL82_OBSOLETE)

#define HW_DRAM_CTL83	(0x0000014c)

#define BP_DRAM_CTL83_RSVD4	28
#define BM_DRAM_CTL83_RSVD4	0xF0000000
#define BF_DRAM_CTL83_RSVD4(v) \
		(((v) << 28) & BM_DRAM_CTL83_RSVD4)
#define BP_DRAM_CTL83_ODT_RD_MAP_CS3	24
#define BM_DRAM_CTL83_ODT_RD_MAP_CS3	0x0F000000
#define BF_DRAM_CTL83_ODT_RD_MAP_CS3(v)  \
		(((v) << 24) & BM_DRAM_CTL83_ODT_RD_MAP_CS3)
#define BP_DRAM_CTL83_RSVD3	20
#define BM_DRAM_CTL83_RSVD3	0x00F00000
#define BF_DRAM_CTL83_RSVD3(v)  \
		(((v) << 20) & BM_DRAM_CTL83_RSVD3)
#define BP_DRAM_CTL83_ODT_RD_MAP_CS2	16
#define BM_DRAM_CTL83_ODT_RD_MAP_CS2	0x000F0000
#define BF_DRAM_CTL83_ODT_RD_MAP_CS2(v)  \
		(((v) << 16) & BM_DRAM_CTL83_ODT_RD_MAP_CS2)
#define BP_DRAM_CTL83_RSVD2	12
#define BM_DRAM_CTL83_RSVD2	0x0000F000
#define BF_DRAM_CTL83_RSVD2(v)  \
		(((v) << 12) & BM_DRAM_CTL83_RSVD2)
#define BP_DRAM_CTL83_ODT_RD_MAP_CS1	8
#define BM_DRAM_CTL83_ODT_RD_MAP_CS1	0x00000F00
#define BF_DRAM_CTL83_ODT_RD_MAP_CS1(v)  \
		(((v) << 8) & BM_DRAM_CTL83_ODT_RD_MAP_CS1)
#define BP_DRAM_CTL83_RSVD1	4
#define BM_DRAM_CTL83_RSVD1	0x000000F0
#define BF_DRAM_CTL83_RSVD1(v)  \
		(((v) << 4) & BM_DRAM_CTL83_RSVD1)
#define BP_DRAM_CTL83_ODT_RD_MAP_CS0	0
#define BM_DRAM_CTL83_ODT_RD_MAP_CS0	0x0000000F
#define BF_DRAM_CTL83_ODT_RD_MAP_CS0(v)  \
		(((v) << 0) & BM_DRAM_CTL83_ODT_RD_MAP_CS0)

#define HW_DRAM_CTL84	(0x00000150)

#define BP_DRAM_CTL84_RSVD4	28
#define BM_DRAM_CTL84_RSVD4	0xF0000000
#define BF_DRAM_CTL84_RSVD4(v) \
		(((v) << 28) & BM_DRAM_CTL84_RSVD4)
#define BP_DRAM_CTL84_ODT_WR_MAP_CS3	24
#define BM_DRAM_CTL84_ODT_WR_MAP_CS3	0x0F000000
#define BF_DRAM_CTL84_ODT_WR_MAP_CS3(v)  \
		(((v) << 24) & BM_DRAM_CTL84_ODT_WR_MAP_CS3)
#define BP_DRAM_CTL84_RSVD3	20
#define BM_DRAM_CTL84_RSVD3	0x00F00000
#define BF_DRAM_CTL84_RSVD3(v)  \
		(((v) << 20) & BM_DRAM_CTL84_RSVD3)
#define BP_DRAM_CTL84_ODT_WR_MAP_CS2	16
#define BM_DRAM_CTL84_ODT_WR_MAP_CS2	0x000F0000
#define BF_DRAM_CTL84_ODT_WR_MAP_CS2(v)  \
		(((v) << 16) & BM_DRAM_CTL84_ODT_WR_MAP_CS2)
#define BP_DRAM_CTL84_RSVD2	12
#define BM_DRAM_CTL84_RSVD2	0x0000F000
#define BF_DRAM_CTL84_RSVD2(v)  \
		(((v) << 12) & BM_DRAM_CTL84_RSVD2)
#define BP_DRAM_CTL84_ODT_WR_MAP_CS1	8
#define BM_DRAM_CTL84_ODT_WR_MAP_CS1	0x00000F00
#define BF_DRAM_CTL84_ODT_WR_MAP_CS1(v)  \
		(((v) << 8) & BM_DRAM_CTL84_ODT_WR_MAP_CS1)
#define BP_DRAM_CTL84_RSVD1	4
#define BM_DRAM_CTL84_RSVD1	0x000000F0
#define BF_DRAM_CTL84_RSVD1(v)  \
		(((v) << 4) & BM_DRAM_CTL84_RSVD1)
#define BP_DRAM_CTL84_ODT_WR_MAP_CS0	0
#define BM_DRAM_CTL84_ODT_WR_MAP_CS0	0x0000000F
#define BF_DRAM_CTL84_ODT_WR_MAP_CS0(v)  \
		(((v) << 0) & BM_DRAM_CTL84_ODT_WR_MAP_CS0)

#define HW_DRAM_CTL85	(0x00000154)

#define BP_DRAM_CTL85_PAD_CTRL_REG_0	0
#define BM_DRAM_CTL85_PAD_CTRL_REG_0	0xFFFFFFFF
#define BF_DRAM_CTL85_PAD_CTRL_REG_0(v)	(v)

#define HW_DRAM_CTL86	(0x00000158)

#define BP_DRAM_CTL86_OBSOLETE	16
#define BM_DRAM_CTL86_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL86_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL86_OBSOLETE)
#define BP_DRAM_CTL86_VERSION	0
#define BM_DRAM_CTL86_VERSION	0x0000FFFF
#define BF_DRAM_CTL86_VERSION(v)  \
		(((v) << 0) & BM_DRAM_CTL86_VERSION)

#define HW_DRAM_CTL87	(0x0000015c)

#define BP_DRAM_CTL87_DLL_CTRL_REG_0_0	0
#define BM_DRAM_CTL87_DLL_CTRL_REG_0_0	0xFFFFFFFF
#define BF_DRAM_CTL87_DLL_CTRL_REG_0_0(v)	(v)

#define HW_DRAM_CTL88	(0x00000160)

#define BP_DRAM_CTL88_DLL_CTRL_REG_0_1	0
#define BM_DRAM_CTL88_DLL_CTRL_REG_0_1	0xFFFFFFFF
#define BF_DRAM_CTL88_DLL_CTRL_REG_0_1(v)	(v)

#define HW_DRAM_CTL89	(0x00000164)

#define BP_DRAM_CTL89_DLL_CTRL_REG_0_2	0
#define BM_DRAM_CTL89_DLL_CTRL_REG_0_2	0xFFFFFFFF
#define BF_DRAM_CTL89_DLL_CTRL_REG_0_2(v)	(v)

#define HW_DRAM_CTL90	(0x00000168)

#define BP_DRAM_CTL90_DLL_CTRL_REG_0_3	0
#define BM_DRAM_CTL90_DLL_CTRL_REG_0_3	0xFFFFFFFF
#define BF_DRAM_CTL90_DLL_CTRL_REG_0_3(v)	(v)

#define HW_DRAM_CTL91	(0x0000016c)

#define BP_DRAM_CTL91_DLL_CTRL_REG_1_0	0
#define BM_DRAM_CTL91_DLL_CTRL_REG_1_0	0xFFFFFFFF
#define BF_DRAM_CTL91_DLL_CTRL_REG_1_0(v)	(v)

#define HW_DRAM_CTL92	(0x00000170)

#define BP_DRAM_CTL92_DLL_CTRL_REG_1_1	0
#define BM_DRAM_CTL92_DLL_CTRL_REG_1_1	0xFFFFFFFF
#define BF_DRAM_CTL92_DLL_CTRL_REG_1_1(v)	(v)

#define HW_DRAM_CTL93	(0x00000174)

#define BP_DRAM_CTL93_DLL_CTRL_REG_1_2	0
#define BM_DRAM_CTL93_DLL_CTRL_REG_1_2	0xFFFFFFFF
#define BF_DRAM_CTL93_DLL_CTRL_REG_1_2(v)	(v)

#define HW_DRAM_CTL94	(0x00000178)

#define BP_DRAM_CTL94_DLL_CTRL_REG_1_3	0
#define BM_DRAM_CTL94_DLL_CTRL_REG_1_3	0xFFFFFFFF
#define BF_DRAM_CTL94_DLL_CTRL_REG_1_3(v)	(v)

#define HW_DRAM_CTL95	(0x0000017c)

#define BP_DRAM_CTL95_DLL_OBS_REG_0_0	0
#define BM_DRAM_CTL95_DLL_OBS_REG_0_0	0xFFFFFFFF
#define BF_DRAM_CTL95_DLL_OBS_REG_0_0(v)	(v)

#define HW_DRAM_CTL96	(0x00000180)

#define BP_DRAM_CTL96_DLL_OBS_REG_0_1	0
#define BM_DRAM_CTL96_DLL_OBS_REG_0_1	0xFFFFFFFF
#define BF_DRAM_CTL96_DLL_OBS_REG_0_1(v)	(v)

#define HW_DRAM_CTL97	(0x00000184)

#define BP_DRAM_CTL97_DLL_OBS_REG_0_2	0
#define BM_DRAM_CTL97_DLL_OBS_REG_0_2	0xFFFFFFFF
#define BF_DRAM_CTL97_DLL_OBS_REG_0_2(v)	(v)

#define HW_DRAM_CTL98	(0x00000188)

#define BP_DRAM_CTL98_DLL_OBS_REG_0_3	0
#define BM_DRAM_CTL98_DLL_OBS_REG_0_3	0xFFFFFFFF
#define BF_DRAM_CTL98_DLL_OBS_REG_0_3(v)	(v)

#define HW_DRAM_CTL99	(0x0000018c)

#define BP_DRAM_CTL99_PHY_OBS_REG_0_0	0
#define BM_DRAM_CTL99_PHY_OBS_REG_0_0	0xFFFFFFFF
#define BF_DRAM_CTL99_PHY_OBS_REG_0_0(v)	(v)

#define HW_DRAM_CTL100	(0x00000190)

#define BP_DRAM_CTL100_PHY_OBS_REG_0_1	0
#define BM_DRAM_CTL100_PHY_OBS_REG_0_1	0xFFFFFFFF
#define BF_DRAM_CTL100_PHY_OBS_REG_0_1(v)	(v)

#define HW_DRAM_CTL101	(0x00000194)

#define BP_DRAM_CTL101_PHY_OBS_REG_0_2	0
#define BM_DRAM_CTL101_PHY_OBS_REG_0_2	0xFFFFFFFF
#define BF_DRAM_CTL101_PHY_OBS_REG_0_2(v)	(v)

#define HW_DRAM_CTL102	(0x00000198)

#define BP_DRAM_CTL102_PHY_OBS_REG_0_3	0
#define BM_DRAM_CTL102_PHY_OBS_REG_0_3	0xFFFFFFFF
#define BF_DRAM_CTL102_PHY_OBS_REG_0_3(v)	(v)

#define HW_DRAM_CTL103	(0x0000019c)

#define BP_DRAM_CTL103_DLL_OBS_REG_1_0	0
#define BM_DRAM_CTL103_DLL_OBS_REG_1_0	0xFFFFFFFF
#define BF_DRAM_CTL103_DLL_OBS_REG_1_0(v)	(v)

#define HW_DRAM_CTL104	(0x000001a0)

#define BP_DRAM_CTL104_DLL_OBS_REG_1_0	0
#define BM_DRAM_CTL104_DLL_OBS_REG_1_0	0xFFFFFFFF
#define BF_DRAM_CTL104_DLL_OBS_REG_1_0(v)	(v)

#define HW_DRAM_CTL105	(0x000001a4)

#define BP_DRAM_CTL105_DLL_OBS_REG_1_0	0
#define BM_DRAM_CTL105_DLL_OBS_REG_1_0	0xFFFFFFFF
#define BF_DRAM_CTL105_DLL_OBS_REG_1_0(v)	(v)

#define HW_DRAM_CTL106	(0x000001a8)

#define BP_DRAM_CTL106_DLL_OBS_REG_1_0	0
#define BM_DRAM_CTL106_DLL_OBS_REG_1_0	0xFFFFFFFF
#define BF_DRAM_CTL106_DLL_OBS_REG_1_0(v)	(v)

#define HW_DRAM_CTL107	(0x000001ac)

#define BP_DRAM_CTL107_OBSOLETE	16
#define BM_DRAM_CTL107_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL107_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL107_OBSOLETE)
#define BP_DRAM_CTL107_RSVD1	9
#define BM_DRAM_CTL107_RSVD1	0x0000FE00
#define BF_DRAM_CTL107_RSVD1(v)  \
		(((v) << 9) & BM_DRAM_CTL107_RSVD1)
#define BP_DRAM_CTL107_DLL_OBS_REG_1_0	0
#define BM_DRAM_CTL107_DLL_OBS_REG_1_0	0x000001FF
#define BF_DRAM_CTL107_DLL_OBS_REG_1_0(v)  \
		(((v) << 0) & BM_DRAM_CTL107_DLL_OBS_REG_1_0)

#define HW_DRAM_CTL108	(0x000001b0)

#define BP_DRAM_CTL108_DLL_OBS_REG_1_1	0
#define BM_DRAM_CTL108_DLL_OBS_REG_1_1	0xFFFFFFFF
#define BF_DRAM_CTL108_DLL_OBS_REG_1_1(v)	(v)

#define HW_DRAM_CTL109	(0x000001b4)

#define BP_DRAM_CTL109_DLL_OBS_REG_1_1	0
#define BM_DRAM_CTL109_DLL_OBS_REG_1_1	0xFFFFFFFF
#define BF_DRAM_CTL109_DLL_OBS_REG_1_1(v)	(v)

#define HW_DRAM_CTL110	(0x000001b8)

#define BP_DRAM_CTL110_DLL_OBS_REG_1_1	0
#define BM_DRAM_CTL110_DLL_OBS_REG_1_1	0xFFFFFFFF
#define BF_DRAM_CTL110_DLL_OBS_REG_1_1(v)	(v)

#define HW_DRAM_CTL111	(0x000001bc)

#define BP_DRAM_CTL111_DLL_OBS_REG_1_1	0
#define BM_DRAM_CTL111_DLL_OBS_REG_1_1	0xFFFFFFFF
#define BF_DRAM_CTL111_DLL_OBS_REG_1_1(v)	(v)

#define HW_DRAM_CTL112	(0x000001c0)

#define BP_DRAM_CTL112_OBSOLETE	16
#define BM_DRAM_CTL112_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL112_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL112_OBSOLETE)
#define BP_DRAM_CTL112_RSVD1	9
#define BM_DRAM_CTL112_RSVD1	0x0000FE00
#define BF_DRAM_CTL112_RSVD1(v)  \
		(((v) << 9) & BM_DRAM_CTL112_RSVD1)
#define BP_DRAM_CTL112_DLL_OBS_REG_1_1	0
#define BM_DRAM_CTL112_DLL_OBS_REG_1_1	0x000001FF
#define BF_DRAM_CTL112_DLL_OBS_REG_1_1(v)  \
		(((v) << 0) & BM_DRAM_CTL112_DLL_OBS_REG_1_1)

#define HW_DRAM_CTL113	(0x000001c4)

#define BP_DRAM_CTL113_DLL_OBS_REG_1_2	0
#define BM_DRAM_CTL113_DLL_OBS_REG_1_2	0xFFFFFFFF
#define BF_DRAM_CTL113_DLL_OBS_REG_1_2(v)	(v)

#define HW_DRAM_CTL114	(0x000001c8)

#define BP_DRAM_CTL114_DLL_OBS_REG_1_2	0
#define BM_DRAM_CTL114_DLL_OBS_REG_1_2	0xFFFFFFFF
#define BF_DRAM_CTL114_DLL_OBS_REG_1_2(v)	(v)

#define HW_DRAM_CTL115	(0x000001cc)

#define BP_DRAM_CTL115_DLL_OBS_REG_1_2	0
#define BM_DRAM_CTL115_DLL_OBS_REG_1_2	0xFFFFFFFF
#define BF_DRAM_CTL115_DLL_OBS_REG_1_2(v)	(v)

#define HW_DRAM_CTL116	(0x000001d0)

#define BP_DRAM_CTL116_DLL_OBS_REG_1_2	0
#define BM_DRAM_CTL116_DLL_OBS_REG_1_2	0xFFFFFFFF
#define BF_DRAM_CTL116_DLL_OBS_REG_1_2(v)	(v)

#define HW_DRAM_CTL117	(0x000001d4)

#define BP_DRAM_CTL117_OBSOLETE	16
#define BM_DRAM_CTL117_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL117_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL117_OBSOLETE)
#define BP_DRAM_CTL117_RSVD1	9
#define BM_DRAM_CTL117_RSVD1	0x0000FE00
#define BF_DRAM_CTL117_RSVD1(v)  \
		(((v) << 9) & BM_DRAM_CTL117_RSVD1)
#define BP_DRAM_CTL117_DLL_OBS_REG_1_2	0
#define BM_DRAM_CTL117_DLL_OBS_REG_1_2	0x000001FF
#define BF_DRAM_CTL117_DLL_OBS_REG_1_2(v)  \
		(((v) << 0) & BM_DRAM_CTL117_DLL_OBS_REG_1_2)

#define HW_DRAM_CTL118	(0x000001d8)

#define BP_DRAM_CTL118_DLL_OBS_REG_1_3	0
#define BM_DRAM_CTL118_DLL_OBS_REG_1_3	0xFFFFFFFF
#define BF_DRAM_CTL118_DLL_OBS_REG_1_3(v)	(v)

#define HW_DRAM_CTL119	(0x000001dc)

#define BP_DRAM_CTL119_DLL_OBS_REG_1_3	0
#define BM_DRAM_CTL119_DLL_OBS_REG_1_3	0xFFFFFFFF
#define BF_DRAM_CTL119_DLL_OBS_REG_1_3(v)	(v)

#define HW_DRAM_CTL120	(0x000001e0)

#define BP_DRAM_CTL120_DLL_OBS_REG_1_3	0
#define BM_DRAM_CTL120_DLL_OBS_REG_1_3	0xFFFFFFFF
#define BF_DRAM_CTL120_DLL_OBS_REG_1_3(v)	(v)

#define HW_DRAM_CTL121	(0x000001e4)

#define BP_DRAM_CTL121_DLL_OBS_REG_1_3	0
#define BM_DRAM_CTL121_DLL_OBS_REG_1_3	0xFFFFFFFF
#define BF_DRAM_CTL121_DLL_OBS_REG_1_3(v)	(v)

#define HW_DRAM_CTL122	(0x000001e8)

#define BP_DRAM_CTL122_OBSOLETE	16
#define BM_DRAM_CTL122_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL122_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL122_OBSOLETE)
#define BP_DRAM_CTL122_RSVD1	9
#define BM_DRAM_CTL122_RSVD1	0x0000FE00
#define BF_DRAM_CTL122_RSVD1(v)  \
		(((v) << 9) & BM_DRAM_CTL122_RSVD1)
#define BP_DRAM_CTL122_DLL_OBS_REG_1_3	0
#define BM_DRAM_CTL122_DLL_OBS_REG_1_3	0x000001FF
#define BF_DRAM_CTL122_DLL_OBS_REG_1_3(v)  \
		(((v) << 0) & BM_DRAM_CTL122_DLL_OBS_REG_1_3)

#define HW_DRAM_CTL123	(0x000001ec)

#define BP_DRAM_CTL123_DLL_OBS_REG_2_0	0
#define BM_DRAM_CTL123_DLL_OBS_REG_2_0	0xFFFFFFFF
#define BF_DRAM_CTL123_DLL_OBS_REG_2_0(v)	(v)

#define HW_DRAM_CTL124	(0x000001f0)

#define BP_DRAM_CTL124_DLL_OBS_REG_2_0	0
#define BM_DRAM_CTL124_DLL_OBS_REG_2_0	0xFFFFFFFF
#define BF_DRAM_CTL124_DLL_OBS_REG_2_0(v)	(v)

#define HW_DRAM_CTL125	(0x000001f4)

#define BP_DRAM_CTL125_DLL_OBS_REG_2_0	0
#define BM_DRAM_CTL125_DLL_OBS_REG_2_0	0xFFFFFFFF
#define BF_DRAM_CTL125_DLL_OBS_REG_2_0(v)	(v)

#define HW_DRAM_CTL126	(0x000001f8)

#define BP_DRAM_CTL126_DLL_OBS_REG_2_0	0
#define BM_DRAM_CTL126_DLL_OBS_REG_2_0	0xFFFFFFFF
#define BF_DRAM_CTL126_DLL_OBS_REG_2_0(v)	(v)

#define HW_DRAM_CTL127	(0x000001fc)

#define BP_DRAM_CTL127_OBSOLETE	16
#define BM_DRAM_CTL127_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL127_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL127_OBSOLETE)
#define BP_DRAM_CTL127_RSVD1	9
#define BM_DRAM_CTL127_RSVD1	0x0000FE00
#define BF_DRAM_CTL127_RSVD1(v)  \
		(((v) << 9) & BM_DRAM_CTL127_RSVD1)
#define BP_DRAM_CTL127_DLL_OBS_REG_2_0	0
#define BM_DRAM_CTL127_DLL_OBS_REG_2_0	0x000001FF
#define BF_DRAM_CTL127_DLL_OBS_REG_2_0(v)  \
		(((v) << 0) & BM_DRAM_CTL127_DLL_OBS_REG_2_0)

#define HW_DRAM_CTL128	(0x00000200)

#define BP_DRAM_CTL128_DLL_OBS_REG_2_1	0
#define BM_DRAM_CTL128_DLL_OBS_REG_2_1	0xFFFFFFFF
#define BF_DRAM_CTL128_DLL_OBS_REG_2_1(v)	(v)

#define HW_DRAM_CTL129	(0x00000204)

#define BP_DRAM_CTL129_DLL_OBS_REG_2_1	0
#define BM_DRAM_CTL129_DLL_OBS_REG_2_1	0xFFFFFFFF
#define BF_DRAM_CTL129_DLL_OBS_REG_2_1(v)	(v)

#define HW_DRAM_CTL130	(0x00000208)

#define BP_DRAM_CTL130_DLL_OBS_REG_2_1	0
#define BM_DRAM_CTL130_DLL_OBS_REG_2_1	0xFFFFFFFF
#define BF_DRAM_CTL130_DLL_OBS_REG_2_1(v)	(v)

#define HW_DRAM_CTL131	(0x0000020c)

#define BP_DRAM_CTL131_DLL_OBS_REG_2_1	0
#define BM_DRAM_CTL131_DLL_OBS_REG_2_1	0xFFFFFFFF
#define BF_DRAM_CTL131_DLL_OBS_REG_2_1(v)	(v)

#define HW_DRAM_CTL132	(0x00000210)

#define BP_DRAM_CTL132_OBSOLETE	16
#define BM_DRAM_CTL132_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL132_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL132_OBSOLETE)
#define BP_DRAM_CTL132_RSVD1	9
#define BM_DRAM_CTL132_RSVD1	0x0000FE00
#define BF_DRAM_CTL132_RSVD1(v)  \
		(((v) << 9) & BM_DRAM_CTL132_RSVD1)
#define BP_DRAM_CTL132_DLL_OBS_REG_2_1	0
#define BM_DRAM_CTL132_DLL_OBS_REG_2_1	0x000001FF
#define BF_DRAM_CTL132_DLL_OBS_REG_2_1(v)  \
		(((v) << 0) & BM_DRAM_CTL132_DLL_OBS_REG_2_1)

#define HW_DRAM_CTL133	(0x00000214)

#define BP_DRAM_CTL133_DLL_OBS_REG_2_2	0
#define BM_DRAM_CTL133_DLL_OBS_REG_2_2	0xFFFFFFFF
#define BF_DRAM_CTL133_DLL_OBS_REG_2_2(v)	(v)

#define HW_DRAM_CTL134	(0x00000218)

#define BP_DRAM_CTL134_DLL_OBS_REG_2_2	0
#define BM_DRAM_CTL134_DLL_OBS_REG_2_2	0xFFFFFFFF
#define BF_DRAM_CTL134_DLL_OBS_REG_2_2(v)	(v)

#define HW_DRAM_CTL135	(0x0000021c)

#define BP_DRAM_CTL135_DLL_OBS_REG_2_2	0
#define BM_DRAM_CTL135_DLL_OBS_REG_2_2	0xFFFFFFFF
#define BF_DRAM_CTL135_DLL_OBS_REG_2_2(v)	(v)

#define HW_DRAM_CTL136	(0x00000220)

#define BP_DRAM_CTL136_DLL_OBS_REG_2_2	0
#define BM_DRAM_CTL136_DLL_OBS_REG_2_2	0xFFFFFFFF
#define BF_DRAM_CTL136_DLL_OBS_REG_2_2(v)	(v)

#define HW_DRAM_CTL137	(0x00000224)

#define BP_DRAM_CTL137_OBSOLETE	16
#define BM_DRAM_CTL137_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL137_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL137_OBSOLETE)
#define BP_DRAM_CTL137_RSVD1	9
#define BM_DRAM_CTL137_RSVD1	0x0000FE00
#define BF_DRAM_CTL137_RSVD1(v)  \
		(((v) << 9) & BM_DRAM_CTL137_RSVD1)
#define BP_DRAM_CTL137_DLL_OBS_REG_2_2	0
#define BM_DRAM_CTL137_DLL_OBS_REG_2_2	0x000001FF
#define BF_DRAM_CTL137_DLL_OBS_REG_2_2(v)  \
		(((v) << 0) & BM_DRAM_CTL137_DLL_OBS_REG_2_2)

#define HW_DRAM_CTL138	(0x00000228)

#define BP_DRAM_CTL138_DLL_OBS_REG_2_3	0
#define BM_DRAM_CTL138_DLL_OBS_REG_2_3	0xFFFFFFFF
#define BF_DRAM_CTL138_DLL_OBS_REG_2_3(v)	(v)

#define HW_DRAM_CTL139	(0x0000022c)

#define BP_DRAM_CTL139_DLL_OBS_REG_2_3	0
#define BM_DRAM_CTL139_DLL_OBS_REG_2_3	0xFFFFFFFF
#define BF_DRAM_CTL139_DLL_OBS_REG_2_3(v)	(v)

#define HW_DRAM_CTL140	(0x00000230)

#define BP_DRAM_CTL140_DLL_OBS_REG_2_3	0
#define BM_DRAM_CTL140_DLL_OBS_REG_2_3	0xFFFFFFFF
#define BF_DRAM_CTL140_DLL_OBS_REG_2_3(v)	(v)

#define HW_DRAM_CTL141	(0x00000234)

#define BP_DRAM_CTL141_DLL_OBS_REG_2_3	0
#define BM_DRAM_CTL141_DLL_OBS_REG_2_3	0xFFFFFFFF
#define BF_DRAM_CTL141_DLL_OBS_REG_2_3(v)	(v)

#define HW_DRAM_CTL142	(0x00000238)

#define BP_DRAM_CTL142_OBSOLETE	16
#define BM_DRAM_CTL142_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL142_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL142_OBSOLETE)
#define BP_DRAM_CTL142_RSVD1	9
#define BM_DRAM_CTL142_RSVD1	0x0000FE00
#define BF_DRAM_CTL142_RSVD1(v)  \
		(((v) << 9) & BM_DRAM_CTL142_RSVD1)
#define BP_DRAM_CTL142_DLL_OBS_REG_2_3	0
#define BM_DRAM_CTL142_DLL_OBS_REG_2_3	0x000001FF
#define BF_DRAM_CTL142_DLL_OBS_REG_2_3(v)  \
		(((v) << 0) & BM_DRAM_CTL142_DLL_OBS_REG_2_3)

#define HW_DRAM_CTL143	(0x0000023c)

#define BP_DRAM_CTL143_DLL_OBS_REG_3_0	0
#define BM_DRAM_CTL143_DLL_OBS_REG_3_0	0xFFFFFFFF
#define BF_DRAM_CTL143_DLL_OBS_REG_3_0(v)	(v)

#define HW_DRAM_CTL144	(0x00000240)

#define BP_DRAM_CTL144_DLL_OBS_REG_3_0	0
#define BM_DRAM_CTL144_DLL_OBS_REG_3_0	0xFFFFFFFF
#define BF_DRAM_CTL144_DLL_OBS_REG_3_0(v)	(v)

#define HW_DRAM_CTL145	(0x00000244)

#define BP_DRAM_CTL145_DLL_OBS_REG_3_0	0
#define BM_DRAM_CTL145_DLL_OBS_REG_3_0	0xFFFFFFFF
#define BF_DRAM_CTL145_DLL_OBS_REG_3_0(v)	(v)

#define HW_DRAM_CTL146	(0x00000248)

#define BP_DRAM_CTL146_DLL_OBS_REG_3_0	0
#define BM_DRAM_CTL146_DLL_OBS_REG_3_0	0xFFFFFFFF
#define BF_DRAM_CTL146_DLL_OBS_REG_3_0(v)	(v)

#define HW_DRAM_CTL147	(0x0000024c)

#define BP_DRAM_CTL147_OBSOLETE	16
#define BM_DRAM_CTL147_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL147_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL147_OBSOLETE)
#define BP_DRAM_CTL147_RSVD1	9
#define BM_DRAM_CTL147_RSVD1	0x0000FE00
#define BF_DRAM_CTL147_RSVD1(v)  \
		(((v) << 9) & BM_DRAM_CTL147_RSVD1)
#define BP_DRAM_CTL147_DLL_OBS_REG_3_0	0
#define BM_DRAM_CTL147_DLL_OBS_REG_3_0	0x000001FF
#define BF_DRAM_CTL147_DLL_OBS_REG_3_0(v)  \
		(((v) << 0) & BM_DRAM_CTL147_DLL_OBS_REG_3_0)

#define HW_DRAM_CTL148	(0x00000250)

#define BP_DRAM_CTL148_DLL_OBS_REG_3_1	0
#define BM_DRAM_CTL148_DLL_OBS_REG_3_1	0xFFFFFFFF
#define BF_DRAM_CTL148_DLL_OBS_REG_3_1(v)	(v)

#define HW_DRAM_CTL149	(0x00000254)

#define BP_DRAM_CTL149_DLL_OBS_REG_3_1	0
#define BM_DRAM_CTL149_DLL_OBS_REG_3_1	0xFFFFFFFF
#define BF_DRAM_CTL149_DLL_OBS_REG_3_1(v)	(v)

#define HW_DRAM_CTL150	(0x00000258)

#define BP_DRAM_CTL150_DLL_OBS_REG_3_1	0
#define BM_DRAM_CTL150_DLL_OBS_REG_3_1	0xFFFFFFFF
#define BF_DRAM_CTL150_DLL_OBS_REG_3_1(v)	(v)

#define HW_DRAM_CTL151	(0x0000025c)

#define BP_DRAM_CTL151_DLL_OBS_REG_3_1	0
#define BM_DRAM_CTL151_DLL_OBS_REG_3_1	0xFFFFFFFF
#define BF_DRAM_CTL151_DLL_OBS_REG_3_1(v)	(v)

#define HW_DRAM_CTL152	(0x00000260)

#define BP_DRAM_CTL152_OBSOLETE	16
#define BM_DRAM_CTL152_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL152_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL152_OBSOLETE)
#define BP_DRAM_CTL152_RSVD1	9
#define BM_DRAM_CTL152_RSVD1	0x0000FE00
#define BF_DRAM_CTL152_RSVD1(v)  \
		(((v) << 9) & BM_DRAM_CTL152_RSVD1)
#define BP_DRAM_CTL152_DLL_OBS_REG_3_1	0
#define BM_DRAM_CTL152_DLL_OBS_REG_3_1	0x000001FF
#define BF_DRAM_CTL152_DLL_OBS_REG_3_1(v)  \
		(((v) << 0) & BM_DRAM_CTL152_DLL_OBS_REG_3_1)

#define HW_DRAM_CTL153	(0x00000264)

#define BP_DRAM_CTL153_DLL_OBS_REG_3_2	0
#define BM_DRAM_CTL153_DLL_OBS_REG_3_2	0xFFFFFFFF
#define BF_DRAM_CTL153_DLL_OBS_REG_3_2(v)	(v)

#define HW_DRAM_CTL154	(0x00000268)

#define BP_DRAM_CTL154_DLL_OBS_REG_3_2	0
#define BM_DRAM_CTL154_DLL_OBS_REG_3_2	0xFFFFFFFF
#define BF_DRAM_CTL154_DLL_OBS_REG_3_2(v)	(v)

#define HW_DRAM_CTL155	(0x0000026c)

#define BP_DRAM_CTL155_DLL_OBS_REG_3_2	0
#define BM_DRAM_CTL155_DLL_OBS_REG_3_2	0xFFFFFFFF
#define BF_DRAM_CTL155_DLL_OBS_REG_3_2(v)	(v)

#define HW_DRAM_CTL156	(0x00000270)

#define BP_DRAM_CTL156_DLL_OBS_REG_3_2	0
#define BM_DRAM_CTL156_DLL_OBS_REG_3_2	0xFFFFFFFF
#define BF_DRAM_CTL156_DLL_OBS_REG_3_2(v)	(v)

#define HW_DRAM_CTL157	(0x00000274)

#define BP_DRAM_CTL157_OBSOLETE	16
#define BM_DRAM_CTL157_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL157_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL157_OBSOLETE)
#define BP_DRAM_CTL157_RSVD1	9
#define BM_DRAM_CTL157_RSVD1	0x0000FE00
#define BF_DRAM_CTL157_RSVD1(v)  \
		(((v) << 9) & BM_DRAM_CTL157_RSVD1)
#define BP_DRAM_CTL157_DLL_OBS_REG_3_2	0
#define BM_DRAM_CTL157_DLL_OBS_REG_3_2	0x000001FF
#define BF_DRAM_CTL157_DLL_OBS_REG_3_2(v)  \
		(((v) << 0) & BM_DRAM_CTL157_DLL_OBS_REG_3_2)

#define HW_DRAM_CTL158	(0x00000278)

#define BP_DRAM_CTL158_DLL_OBS_REG_3_3	0
#define BM_DRAM_CTL158_DLL_OBS_REG_3_3	0xFFFFFFFF
#define BF_DRAM_CTL158_DLL_OBS_REG_3_3(v)	(v)

#define HW_DRAM_CTL159	(0x0000027c)

#define BP_DRAM_CTL159_DLL_OBS_REG_3_3	0
#define BM_DRAM_CTL159_DLL_OBS_REG_3_3	0xFFFFFFFF
#define BF_DRAM_CTL159_DLL_OBS_REG_3_3(v)	(v)

#define HW_DRAM_CTL160	(0x00000280)

#define BP_DRAM_CTL160_DLL_OBS_REG_3_3	0
#define BM_DRAM_CTL160_DLL_OBS_REG_3_3	0xFFFFFFFF
#define BF_DRAM_CTL160_DLL_OBS_REG_3_3(v)	(v)

#define HW_DRAM_CTL161	(0x00000284)

#define BP_DRAM_CTL161_DLL_OBS_REG_3_3	0
#define BM_DRAM_CTL161_DLL_OBS_REG_3_3	0xFFFFFFFF
#define BF_DRAM_CTL161_DLL_OBS_REG_3_3(v)	(v)

#define HW_DRAM_CTL162	(0x00000288)

#define BP_DRAM_CTL162_RSVD3	27
#define BM_DRAM_CTL162_RSVD3	0xF8000000
#define BF_DRAM_CTL162_RSVD3(v) \
		(((v) << 27) & BM_DRAM_CTL162_RSVD3)
#define BP_DRAM_CTL162_W2R_SAMECS_DLY	24
#define BM_DRAM_CTL162_W2R_SAMECS_DLY	0x07000000
#define BF_DRAM_CTL162_W2R_SAMECS_DLY(v)  \
		(((v) << 24) & BM_DRAM_CTL162_W2R_SAMECS_DLY)
#define BP_DRAM_CTL162_RSVD2	19
#define BM_DRAM_CTL162_RSVD2	0x00F80000
#define BF_DRAM_CTL162_RSVD2(v)  \
		(((v) << 19) & BM_DRAM_CTL162_RSVD2)
#define BP_DRAM_CTL162_W2R_DIFFCS_DLY	16
#define BM_DRAM_CTL162_W2R_DIFFCS_DLY	0x00070000
#define BF_DRAM_CTL162_W2R_DIFFCS_DLY(v)  \
		(((v) << 16) & BM_DRAM_CTL162_W2R_DIFFCS_DLY)
#define BP_DRAM_CTL162_RSVD1	9
#define BM_DRAM_CTL162_RSVD1	0x0000FE00
#define BF_DRAM_CTL162_RSVD1(v)  \
		(((v) << 9) & BM_DRAM_CTL162_RSVD1)
#define BP_DRAM_CTL162_DLL_OBS_REG_3_3	0
#define BM_DRAM_CTL162_DLL_OBS_REG_3_3	0x000001FF
#define BF_DRAM_CTL162_DLL_OBS_REG_3_3(v)  \
		(((v) << 0) & BM_DRAM_CTL162_DLL_OBS_REG_3_3)

#define HW_DRAM_CTL163	(0x0000028c)

#define BP_DRAM_CTL163_DLL_RST_ADJ_DLY	24
#define BM_DRAM_CTL163_DLL_RST_ADJ_DLY	0xFF000000
#define BF_DRAM_CTL163_DLL_RST_ADJ_DLY(v) \
		(((v) << 24) & BM_DRAM_CTL163_DLL_RST_ADJ_DLY)
#define BP_DRAM_CTL163_RSVD3	20
#define BM_DRAM_CTL163_RSVD3	0x00F00000
#define BF_DRAM_CTL163_RSVD3(v)  \
		(((v) << 20) & BM_DRAM_CTL163_RSVD3)
#define BP_DRAM_CTL163_WRLAT_ADJ	16
#define BM_DRAM_CTL163_WRLAT_ADJ	0x000F0000
#define BF_DRAM_CTL163_WRLAT_ADJ(v)  \
		(((v) << 16) & BM_DRAM_CTL163_WRLAT_ADJ)
#define BP_DRAM_CTL163_RSVD2	12
#define BM_DRAM_CTL163_RSVD2	0x0000F000
#define BF_DRAM_CTL163_RSVD2(v)  \
		(((v) << 12) & BM_DRAM_CTL163_RSVD2)
#define BP_DRAM_CTL163_RDLAT_ADJ	8
#define BM_DRAM_CTL163_RDLAT_ADJ	0x00000F00
#define BF_DRAM_CTL163_RDLAT_ADJ(v)  \
		(((v) << 8) & BM_DRAM_CTL163_RDLAT_ADJ)
#define BP_DRAM_CTL163_RSVD1	4
#define BM_DRAM_CTL163_RSVD1	0x000000F0
#define BF_DRAM_CTL163_RSVD1(v)  \
		(((v) << 4) & BM_DRAM_CTL163_RSVD1)
#define BP_DRAM_CTL163_DRAM_CLASS	0
#define BM_DRAM_CTL163_DRAM_CLASS	0x0000000F
#define BF_DRAM_CTL163_DRAM_CLASS(v)  \
		(((v) << 0) & BM_DRAM_CTL163_DRAM_CLASS)

#define HW_DRAM_CTL164	(0x00000290)

#define BP_DRAM_CTL164_OBSOLETE	24
#define BM_DRAM_CTL164_OBSOLETE	0xFF000000
#define BF_DRAM_CTL164_OBSOLETE(v) \
		(((v) << 24) & BM_DRAM_CTL164_OBSOLETE)
#define BP_DRAM_CTL164_RSVD1	18
#define BM_DRAM_CTL164_RSVD1	0x00FC0000
#define BF_DRAM_CTL164_RSVD1(v)  \
		(((v) << 18) & BM_DRAM_CTL164_RSVD1)
#define BP_DRAM_CTL164_INT_ACK	8
#define BM_DRAM_CTL164_INT_ACK	0x0003FF00
#define BF_DRAM_CTL164_INT_ACK(v)  \
		(((v) << 8) & BM_DRAM_CTL164_INT_ACK)
#define BP_DRAM_CTL164_TMOD	0
#define BM_DRAM_CTL164_TMOD	0x000000FF
#define BF_DRAM_CTL164_TMOD(v)  \
		(((v) << 0) & BM_DRAM_CTL164_TMOD)

#define HW_DRAM_CTL171	(0x000002ac)

#define BP_DRAM_CTL171_RSVD2	25
#define BM_DRAM_CTL171_RSVD2	0xFE000000
#define BF_DRAM_CTL171_RSVD2(v) \
		(((v) << 25) & BM_DRAM_CTL171_RSVD2)
#define BM_DRAM_CTL171_AXI5_BDW_OVFLOW	0x01000000
#define BP_DRAM_CTL171_RSVD1	17
#define BM_DRAM_CTL171_RSVD1	0x00FE0000
#define BF_DRAM_CTL171_RSVD1(v)  \
		(((v) << 17) & BM_DRAM_CTL171_RSVD1)
#define BM_DRAM_CTL171_AXI4_BDW_OVFLOW	0x00010000
#define BP_DRAM_CTL171_DLL_RST_DELAY	0
#define BM_DRAM_CTL171_DLL_RST_DELAY	0x0000FFFF
#define BF_DRAM_CTL171_DLL_RST_DELAY(v)  \
		(((v) << 0) & BM_DRAM_CTL171_DLL_RST_DELAY)

#define HW_DRAM_CTL172	(0x000002b0)

#define BP_DRAM_CTL172_RSVD4	25
#define BM_DRAM_CTL172_RSVD4	0xFE000000
#define BF_DRAM_CTL172_RSVD4(v) \
		(((v) << 25) & BM_DRAM_CTL172_RSVD4)
#define BM_DRAM_CTL172_RESYNC_DLL_PER_AREF_EN	0x01000000
#define BP_DRAM_CTL172_RSVD3	17
#define BM_DRAM_CTL172_RSVD3	0x00FE0000
#define BF_DRAM_CTL172_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL172_RSVD3)
#define BM_DRAM_CTL172_RESYNC_DLL	0x00010000
#define BP_DRAM_CTL172_RSVD2	9
#define BM_DRAM_CTL172_RSVD2	0x0000FE00
#define BF_DRAM_CTL172_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL172_RSVD2)
#define BM_DRAM_CTL172_CONCURRENTAP_WR_ONLY	0x00000100
#define BP_DRAM_CTL172_RSVD1	1
#define BM_DRAM_CTL172_RSVD1	0x000000FE
#define BF_DRAM_CTL172_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL172_RSVD1)
#define BM_DRAM_CTL172_CKE_STATUS	0x00000001

#define HW_DRAM_CTL173	(0x000002b4)

#define BP_DRAM_CTL173_RSVD4	27
#define BM_DRAM_CTL173_RSVD4	0xF8000000
#define BF_DRAM_CTL173_RSVD4(v) \
		(((v) << 27) & BM_DRAM_CTL173_RSVD4)
#define BP_DRAM_CTL173_AXI4_W_PRIORITY	24
#define BM_DRAM_CTL173_AXI4_W_PRIORITY	0x07000000
#define BF_DRAM_CTL173_AXI4_W_PRIORITY(v)  \
		(((v) << 24) & BM_DRAM_CTL173_AXI4_W_PRIORITY)
#define BP_DRAM_CTL173_RSVD3	19
#define BM_DRAM_CTL173_RSVD3	0x00F80000
#define BF_DRAM_CTL173_RSVD3(v)  \
		(((v) << 19) & BM_DRAM_CTL173_RSVD3)
#define BP_DRAM_CTL173_AXI4_R_PRIORITY	16
#define BM_DRAM_CTL173_AXI4_R_PRIORITY	0x00070000
#define BF_DRAM_CTL173_AXI4_R_PRIORITY(v)  \
		(((v) << 16) & BM_DRAM_CTL173_AXI4_R_PRIORITY)
#define BP_DRAM_CTL173_RSVD2	10
#define BM_DRAM_CTL173_RSVD2	0x0000FC00
#define BF_DRAM_CTL173_RSVD2(v)  \
		(((v) << 10) & BM_DRAM_CTL173_RSVD2)
#define BP_DRAM_CTL173_AXI5_FIFO_TYPE_REG	8
#define BM_DRAM_CTL173_AXI5_FIFO_TYPE_REG	0x00000300
#define BF_DRAM_CTL173_AXI5_FIFO_TYPE_REG(v)  \
		(((v) << 8) & BM_DRAM_CTL173_AXI5_FIFO_TYPE_REG)
#define BP_DRAM_CTL173_RSVD1	2
#define BM_DRAM_CTL173_RSVD1	0x000000FC
#define BF_DRAM_CTL173_RSVD1(v)  \
		(((v) << 2) & BM_DRAM_CTL173_RSVD1)
#define BP_DRAM_CTL173_AXI4_FIFO_TYPE_REG	0
#define BM_DRAM_CTL173_AXI4_FIFO_TYPE_REG	0x00000003
#define BF_DRAM_CTL173_AXI4_FIFO_TYPE_REG(v)  \
		(((v) << 0) & BM_DRAM_CTL173_AXI4_FIFO_TYPE_REG)

#define HW_DRAM_CTL174	(0x000002b8)

#define BP_DRAM_CTL174_RSVD4	27
#define BM_DRAM_CTL174_RSVD4	0xF8000000
#define BF_DRAM_CTL174_RSVD4(v) \
		(((v) << 27) & BM_DRAM_CTL174_RSVD4)
#define BP_DRAM_CTL174_R2R_SAMECS_DLY	24
#define BM_DRAM_CTL174_R2R_SAMECS_DLY	0x07000000
#define BF_DRAM_CTL174_R2R_SAMECS_DLY(v)  \
		(((v) << 24) & BM_DRAM_CTL174_R2R_SAMECS_DLY)
#define BP_DRAM_CTL174_RSVD3	19
#define BM_DRAM_CTL174_RSVD3	0x00F80000
#define BF_DRAM_CTL174_RSVD3(v)  \
		(((v) << 19) & BM_DRAM_CTL174_RSVD3)
#define BP_DRAM_CTL174_R2R_DIFFCS_DLY	16
#define BM_DRAM_CTL174_R2R_DIFFCS_DLY	0x00070000
#define BF_DRAM_CTL174_R2R_DIFFCS_DLY(v)  \
		(((v) << 16) & BM_DRAM_CTL174_R2R_DIFFCS_DLY)
#define BP_DRAM_CTL174_RSVD2	11
#define BM_DRAM_CTL174_RSVD2	0x0000F800
#define BF_DRAM_CTL174_RSVD2(v)  \
		(((v) << 11) & BM_DRAM_CTL174_RSVD2)
#define BP_DRAM_CTL174_AXI5_W_PRIORITY	8
#define BM_DRAM_CTL174_AXI5_W_PRIORITY	0x00000700
#define BF_DRAM_CTL174_AXI5_W_PRIORITY(v)  \
		(((v) << 8) & BM_DRAM_CTL174_AXI5_W_PRIORITY)
#define BP_DRAM_CTL174_RSVD1	3
#define BM_DRAM_CTL174_RSVD1	0x000000F8
#define BF_DRAM_CTL174_RSVD1(v)  \
		(((v) << 3) & BM_DRAM_CTL174_RSVD1)
#define BP_DRAM_CTL174_AXI5_R_PRIORITY	0
#define BM_DRAM_CTL174_AXI5_R_PRIORITY	0x00000007
#define BF_DRAM_CTL174_AXI5_R_PRIORITY(v)  \
		(((v) << 0) & BM_DRAM_CTL174_AXI5_R_PRIORITY)

#define HW_DRAM_CTL175	(0x000002bc)

#define BP_DRAM_CTL175_RSVD4	27
#define BM_DRAM_CTL175_RSVD4	0xF8000000
#define BF_DRAM_CTL175_RSVD4(v) \
		(((v) << 27) & BM_DRAM_CTL175_RSVD4)
#define BP_DRAM_CTL175_W2W_DIFFCS_DLY	24
#define BM_DRAM_CTL175_W2W_DIFFCS_DLY	0x07000000
#define BF_DRAM_CTL175_W2W_DIFFCS_DLY(v)  \
		(((v) << 24) & BM_DRAM_CTL175_W2W_DIFFCS_DLY)
#define BP_DRAM_CTL175_RSVD3	19
#define BM_DRAM_CTL175_RSVD3	0x00F80000
#define BF_DRAM_CTL175_RSVD3(v)  \
		(((v) << 19) & BM_DRAM_CTL175_RSVD3)
#define BP_DRAM_CTL175_TBST_INT_INTERVAL	16
#define BM_DRAM_CTL175_TBST_INT_INTERVAL	0x00070000
#define BF_DRAM_CTL175_TBST_INT_INTERVAL(v)  \
		(((v) << 16) & BM_DRAM_CTL175_TBST_INT_INTERVAL)
#define BP_DRAM_CTL175_RSVD2	11
#define BM_DRAM_CTL175_RSVD2	0x0000F800
#define BF_DRAM_CTL175_RSVD2(v)  \
		(((v) << 11) & BM_DRAM_CTL175_RSVD2)
#define BP_DRAM_CTL175_R2W_SAMECS_DLY	8
#define BM_DRAM_CTL175_R2W_SAMECS_DLY	0x00000700
#define BF_DRAM_CTL175_R2W_SAMECS_DLY(v)  \
		(((v) << 8) & BM_DRAM_CTL175_R2W_SAMECS_DLY)
#define BP_DRAM_CTL175_RSVD1	3
#define BM_DRAM_CTL175_RSVD1	0x000000F8
#define BF_DRAM_CTL175_RSVD1(v)  \
		(((v) << 3) & BM_DRAM_CTL175_RSVD1)
#define BP_DRAM_CTL175_R2W_DIFFCS_DLY	0
#define BM_DRAM_CTL175_R2W_DIFFCS_DLY	0x00000007
#define BF_DRAM_CTL175_R2W_DIFFCS_DLY(v)  \
		(((v) << 0) & BM_DRAM_CTL175_R2W_DIFFCS_DLY)

#define HW_DRAM_CTL176	(0x000002c0)

#define BP_DRAM_CTL176_RSVD4	28
#define BM_DRAM_CTL176_RSVD4	0xF0000000
#define BF_DRAM_CTL176_RSVD4(v) \
		(((v) << 28) & BM_DRAM_CTL176_RSVD4)
#define BP_DRAM_CTL176_ADD_ODT_CLK_SAMETYPE_DIFFCS	24
#define BM_DRAM_CTL176_ADD_ODT_CLK_SAMETYPE_DIFFCS	0x0F000000
#define BF_DRAM_CTL176_ADD_ODT_CLK_SAMETYPE_DIFFCS(v)  \
		(((v) << 24) & BM_DRAM_CTL176_ADD_ODT_CLK_SAMETYPE_DIFFCS)
#define BP_DRAM_CTL176_RSVD3	20
#define BM_DRAM_CTL176_RSVD3	0x00F00000
#define BF_DRAM_CTL176_RSVD3(v)  \
		(((v) << 20) & BM_DRAM_CTL176_RSVD3)
#define BP_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_SAMECS	16
#define BM_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_SAMECS	0x000F0000
#define BF_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_SAMECS(v)  \
		(((v) << 16) & BM_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_SAMECS)
#define BP_DRAM_CTL176_RSVD2	12
#define BM_DRAM_CTL176_RSVD2	0x0000F000
#define BF_DRAM_CTL176_RSVD2(v)  \
		(((v) << 12) & BM_DRAM_CTL176_RSVD2)
#define BP_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_DIFFCS	8
#define BM_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_DIFFCS	0x00000F00
#define BF_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_DIFFCS(v)  \
		(((v) << 8) & BM_DRAM_CTL176_ADD_ODT_CLK_DIFFTYPE_DIFFCS)
#define BP_DRAM_CTL176_RSVD1	3
#define BM_DRAM_CTL176_RSVD1	0x000000F8
#define BF_DRAM_CTL176_RSVD1(v)  \
		(((v) << 3) & BM_DRAM_CTL176_RSVD1)
#define BP_DRAM_CTL176_W2W_SAMECS_DLY	0
#define BM_DRAM_CTL176_W2W_SAMECS_DLY	0x00000007
#define BF_DRAM_CTL176_W2W_SAMECS_DLY(v)  \
		(((v) << 0) & BM_DRAM_CTL176_W2W_SAMECS_DLY)

#define HW_DRAM_CTL177	(0x000002c4)

#define BP_DRAM_CTL177_RSVD4	29
#define BM_DRAM_CTL177_RSVD4	0xE0000000
#define BF_DRAM_CTL177_RSVD4(v) \
		(((v) << 29) & BM_DRAM_CTL177_RSVD4)
#define BP_DRAM_CTL177_TCCD	24
#define BM_DRAM_CTL177_TCCD	0x1F000000
#define BF_DRAM_CTL177_TCCD(v)  \
		(((v) << 24) & BM_DRAM_CTL177_TCCD)
#define BP_DRAM_CTL177_RSVD3	20
#define BM_DRAM_CTL177_RSVD3	0x00F00000
#define BF_DRAM_CTL177_RSVD3(v)  \
		(((v) << 20) & BM_DRAM_CTL177_RSVD3)
#define BP_DRAM_CTL177_TRP_AB	16
#define BM_DRAM_CTL177_TRP_AB	0x000F0000
#define BF_DRAM_CTL177_TRP_AB(v)  \
		(((v) << 16) & BM_DRAM_CTL177_TRP_AB)
#define BP_DRAM_CTL177_RSVD2	12
#define BM_DRAM_CTL177_RSVD2	0x0000F000
#define BF_DRAM_CTL177_RSVD2(v)  \
		(((v) << 12) & BM_DRAM_CTL177_RSVD2)
#define BP_DRAM_CTL177_CKSRX	8
#define BM_DRAM_CTL177_CKSRX	0x00000F00
#define BF_DRAM_CTL177_CKSRX(v)  \
		(((v) << 8) & BM_DRAM_CTL177_CKSRX)
#define BP_DRAM_CTL177_RSVD1	4
#define BM_DRAM_CTL177_RSVD1	0x000000F0
#define BF_DRAM_CTL177_RSVD1(v)  \
		(((v) << 4) & BM_DRAM_CTL177_RSVD1)
#define BP_DRAM_CTL177_CKSRE	0
#define BM_DRAM_CTL177_CKSRE	0x0000000F
#define BF_DRAM_CTL177_CKSRE(v)  \
		(((v) << 0) & BM_DRAM_CTL177_CKSRE)

#define HW_DRAM_CTL178	(0x000002c8)

#define BM_DRAM_CTL178_RSVD4	0x80000000
#define BP_DRAM_CTL178_AXI5_BDW	24
#define BM_DRAM_CTL178_AXI5_BDW	0x7F000000
#define BF_DRAM_CTL178_AXI5_BDW(v)  \
		(((v) << 24) & BM_DRAM_CTL178_AXI5_BDW)
#define BM_DRAM_CTL178_RSVD3	0x00800000
#define BP_DRAM_CTL178_AXI4_CURRENT_BDW	16
#define BM_DRAM_CTL178_AXI4_CURRENT_BDW	0x007F0000
#define BF_DRAM_CTL178_AXI4_CURRENT_BDW(v)  \
		(((v) << 16) & BM_DRAM_CTL178_AXI4_CURRENT_BDW)
#define BM_DRAM_CTL178_RSVD2	0x00008000
#define BP_DRAM_CTL178_AXI4_BDW	8
#define BM_DRAM_CTL178_AXI4_BDW	0x00007F00
#define BF_DRAM_CTL178_AXI4_BDW(v)  \
		(((v) << 8) & BM_DRAM_CTL178_AXI4_BDW)
#define BP_DRAM_CTL178_RSVD1	5
#define BM_DRAM_CTL178_RSVD1	0x000000E0
#define BF_DRAM_CTL178_RSVD1(v)  \
		(((v) << 5) & BM_DRAM_CTL178_RSVD1)
#define BP_DRAM_CTL178_TCKESR	0
#define BM_DRAM_CTL178_TCKESR	0x0000001F
#define BF_DRAM_CTL178_TCKESR(v)  \
		(((v) << 0) & BM_DRAM_CTL178_TCKESR)

#define HW_DRAM_CTL179	(0x000002cc)

#define BP_DRAM_CTL179_RSVD3	24
#define BM_DRAM_CTL179_RSVD3	0xFF000000
#define BF_DRAM_CTL179_RSVD3(v) \
		(((v) << 24) & BM_DRAM_CTL179_RSVD3)
#define BP_DRAM_CTL179_RSVD2	22
#define BM_DRAM_CTL179_RSVD2	0x00C00000
#define BF_DRAM_CTL179_RSVD2(v)  \
		(((v) << 22) & BM_DRAM_CTL179_RSVD2)
#define BP_DRAM_CTL179_TDFI_PHYUPD_TYPE1	8
#define BM_DRAM_CTL179_TDFI_PHYUPD_TYPE1	0x003FFF00
#define BF_DRAM_CTL179_TDFI_PHYUPD_TYPE1(v)  \
		(((v) << 8) & BM_DRAM_CTL179_TDFI_PHYUPD_TYPE1)
#define BM_DRAM_CTL179_RSVD1	0x00000080
#define BP_DRAM_CTL179_AXI5_CURRENT_BDW	0
#define BM_DRAM_CTL179_AXI5_CURRENT_BDW	0x0000007F
#define BF_DRAM_CTL179_AXI5_CURRENT_BDW(v)  \
		(((v) << 0) & BM_DRAM_CTL179_AXI5_CURRENT_BDW)

#define HW_DRAM_CTL180	(0x000002d0)

#define BP_DRAM_CTL180_RSVD2	30
#define BM_DRAM_CTL180_RSVD2	0xC0000000
#define BF_DRAM_CTL180_RSVD2(v) \
		(((v) << 30) & BM_DRAM_CTL180_RSVD2)
#define BP_DRAM_CTL180_TDFI_PHYUPD_TYPE3	16
#define BM_DRAM_CTL180_TDFI_PHYUPD_TYPE3	0x3FFF0000
#define BF_DRAM_CTL180_TDFI_PHYUPD_TYPE3(v)  \
		(((v) << 16) & BM_DRAM_CTL180_TDFI_PHYUPD_TYPE3)
#define BP_DRAM_CTL180_RSVD1	14
#define BM_DRAM_CTL180_RSVD1	0x0000C000
#define BF_DRAM_CTL180_RSVD1(v)  \
		(((v) << 14) & BM_DRAM_CTL180_RSVD1)
#define BP_DRAM_CTL180_TDFI_PHYUPD_TYPE2	0
#define BM_DRAM_CTL180_TDFI_PHYUPD_TYPE2	0x00003FFF
#define BF_DRAM_CTL180_TDFI_PHYUPD_TYPE2(v)  \
		(((v) << 0) & BM_DRAM_CTL180_TDFI_PHYUPD_TYPE2)

#define HW_DRAM_CTL181	(0x000002d4)

#define BM_DRAM_CTL181_RSVD2	0x80000000
#define BP_DRAM_CTL181_MR0_DATA_1	16
#define BM_DRAM_CTL181_MR0_DATA_1	0x7FFF0000
#define BF_DRAM_CTL181_MR0_DATA_1(v)  \
		(((v) << 16) & BM_DRAM_CTL181_MR0_DATA_1)
#define BM_DRAM_CTL181_RSVD1	0x00008000
#define BP_DRAM_CTL181_MR0_DATA_0	0
#define BM_DRAM_CTL181_MR0_DATA_0	0x00007FFF
#define BF_DRAM_CTL181_MR0_DATA_0(v)  \
		(((v) << 0) & BM_DRAM_CTL181_MR0_DATA_0)

#define HW_DRAM_CTL182	(0x000002d8)

#define BM_DRAM_CTL182_RSVD2	0x80000000
#define BP_DRAM_CTL182_MR0_DATA_3	16
#define BM_DRAM_CTL182_MR0_DATA_3	0x7FFF0000
#define BF_DRAM_CTL182_MR0_DATA_3(v)  \
		(((v) << 16) & BM_DRAM_CTL182_MR0_DATA_3)
#define BM_DRAM_CTL182_RSVD1	0x00008000
#define BP_DRAM_CTL182_MR0_DATA_2	0
#define BM_DRAM_CTL182_MR0_DATA_2	0x00007FFF
#define BF_DRAM_CTL182_MR0_DATA_2(v)  \
		(((v) << 0) & BM_DRAM_CTL182_MR0_DATA_2)

#define HW_DRAM_CTL183	(0x000002dc)

#define BM_DRAM_CTL183_RSVD2	0x80000000
#define BP_DRAM_CTL183_MR1_DATA_1	16
#define BM_DRAM_CTL183_MR1_DATA_1	0x7FFF0000
#define BF_DRAM_CTL183_MR1_DATA_1(v)  \
		(((v) << 16) & BM_DRAM_CTL183_MR1_DATA_1)
#define BM_DRAM_CTL183_RSVD1	0x00008000
#define BP_DRAM_CTL183_MR1_DATA_0	0
#define BM_DRAM_CTL183_MR1_DATA_0	0x00007FFF
#define BF_DRAM_CTL183_MR1_DATA_0(v)  \
		(((v) << 0) & BM_DRAM_CTL183_MR1_DATA_0)

#define HW_DRAM_CTL184	(0x000002e0)

#define BM_DRAM_CTL184_RSVD2	0x80000000
#define BP_DRAM_CTL184_MR1_DATA_3	16
#define BM_DRAM_CTL184_MR1_DATA_3	0x7FFF0000
#define BF_DRAM_CTL184_MR1_DATA_3(v)  \
		(((v) << 16) & BM_DRAM_CTL184_MR1_DATA_3)
#define BM_DRAM_CTL184_RSVD1	0x00008000
#define BP_DRAM_CTL184_MR1_DATA_2	0
#define BM_DRAM_CTL184_MR1_DATA_2	0x00007FFF
#define BF_DRAM_CTL184_MR1_DATA_2(v)  \
		(((v) << 0) & BM_DRAM_CTL184_MR1_DATA_2)

#define HW_DRAM_CTL185	(0x000002e4)

#define BM_DRAM_CTL185_RSVD2	0x80000000
#define BP_DRAM_CTL185_MR2_DATA_1	16
#define BM_DRAM_CTL185_MR2_DATA_1	0x7FFF0000
#define BF_DRAM_CTL185_MR2_DATA_1(v)  \
		(((v) << 16) & BM_DRAM_CTL185_MR2_DATA_1)
#define BM_DRAM_CTL185_RSVD1	0x00008000
#define BP_DRAM_CTL185_MR2_DATA_0	0
#define BM_DRAM_CTL185_MR2_DATA_0	0x00007FFF
#define BF_DRAM_CTL185_MR2_DATA_0(v)  \
		(((v) << 0) & BM_DRAM_CTL185_MR2_DATA_0)

#define HW_DRAM_CTL186	(0x000002e8)

#define BM_DRAM_CTL186_RSVD2	0x80000000
#define BP_DRAM_CTL186_MR2_DATA_3	16
#define BM_DRAM_CTL186_MR2_DATA_3	0x7FFF0000
#define BF_DRAM_CTL186_MR2_DATA_3(v)  \
		(((v) << 16) & BM_DRAM_CTL186_MR2_DATA_3)
#define BM_DRAM_CTL186_RSVD1	0x00008000
#define BP_DRAM_CTL186_MR2_DATA_2	0
#define BM_DRAM_CTL186_MR2_DATA_2	0x00007FFF
#define BF_DRAM_CTL186_MR2_DATA_2(v)  \
		(((v) << 0) & BM_DRAM_CTL186_MR2_DATA_2)

#define HW_DRAM_CTL187	(0x000002ec)

#define BM_DRAM_CTL187_RSVD2	0x80000000
#define BP_DRAM_CTL187_MR3_DATA_1	16
#define BM_DRAM_CTL187_MR3_DATA_1	0x7FFF0000
#define BF_DRAM_CTL187_MR3_DATA_1(v)  \
		(((v) << 16) & BM_DRAM_CTL187_MR3_DATA_1)
#define BM_DRAM_CTL187_RSVD1	0x00008000
#define BP_DRAM_CTL187_MR3_DATA_0	0
#define BM_DRAM_CTL187_MR3_DATA_0	0x00007FFF
#define BF_DRAM_CTL187_MR3_DATA_0(v)  \
		(((v) << 0) & BM_DRAM_CTL187_MR3_DATA_0)

#define HW_DRAM_CTL188	(0x000002f0)

#define BM_DRAM_CTL188_RSVD2	0x80000000
#define BP_DRAM_CTL188_MR3_DATA_3	16
#define BM_DRAM_CTL188_MR3_DATA_3	0x7FFF0000
#define BF_DRAM_CTL188_MR3_DATA_3(v)  \
		(((v) << 16) & BM_DRAM_CTL188_MR3_DATA_3)
#define BM_DRAM_CTL188_RSVD1	0x00008000
#define BP_DRAM_CTL188_MR3_DATA_2	0
#define BM_DRAM_CTL188_MR3_DATA_2	0x00007FFF
#define BF_DRAM_CTL188_MR3_DATA_2(v)  \
		(((v) << 0) & BM_DRAM_CTL188_MR3_DATA_2)

#define HW_DRAM_CTL189	(0x000002f4)

#define BP_DRAM_CTL189_AXI5_EN_SIZE_LT_WIDTH_INSTR	16
#define BM_DRAM_CTL189_AXI5_EN_SIZE_LT_WIDTH_INSTR	0xFFFF0000
#define BF_DRAM_CTL189_AXI5_EN_SIZE_LT_WIDTH_INSTR(v) \
		(((v) << 16) & BM_DRAM_CTL189_AXI5_EN_SIZE_LT_WIDTH_INSTR)
#define BP_DRAM_CTL189_AXI4_EN_SIZE_LT_WIDTH_INSTR	0
#define BM_DRAM_CTL189_AXI4_EN_SIZE_LT_WIDTH_INSTR	0x0000FFFF
#define BF_DRAM_CTL189_AXI4_EN_SIZE_LT_WIDTH_INSTR(v)  \
		(((v) << 0) & BM_DRAM_CTL189_AXI4_EN_SIZE_LT_WIDTH_INSTR)
#endif /* __ARCH_ARM___DRAM_H */
