/*
 * STMP DCP Register Definitions
 *
 * Copyright 2008-2009 Freescale Semiconductor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __ARCH_ARM___DCP_H
#define __ARCH_ARM___DCP_H  1

#include <mach/stmp3xxx_regs.h>

#define REGS_DCP_BASE (REGS_BASE + 0x28000)
#define REGS_DCP_BASE_PHYS (0x80028000)
#define REGS_DCP_SIZE 0x00002000
HW_REGISTER(HW_DCP_CTRL, REGS_DCP_BASE, 0x00000000)
#define HW_DCP_CTRL_ADDR (REGS_DCP_BASE + 0x00000000)
#define BM_DCP_CTRL_SFTRST 0x80000000
#define BM_DCP_CTRL_CLKGATE 0x40000000
#define BM_DCP_CTRL_PRESENT_CRYPTO 0x20000000
#define BV_DCP_CTRL_PRESENT_CRYPTO__Present 0x1
#define BV_DCP_CTRL_PRESENT_CRYPTO__Absent  0x0
#define BM_DCP_CTRL_PRESENT_CSC 0x10000000
#define BV_DCP_CTRL_PRESENT_CSC__Present 0x1
#define BV_DCP_CTRL_PRESENT_CSC__Absent  0x0
#define BM_DCP_CTRL_GATHER_RESIDUAL_WRITES 0x00800000
#define BM_DCP_CTRL_ENABLE_CONTEXT_CACHING 0x00400000
#define BM_DCP_CTRL_ENABLE_CONTEXT_SWITCHING 0x00200000
#define BM_DCP_CTRL_CSC_INTERRUPT_ENABLE 0x00000100
#define BP_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE      0
#define BM_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE 0x000000FF
#define BF_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE(v)  \
	(((v) << 0) & BM_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE)
#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH0 0x01
#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH1 0x02
#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH2 0x04
#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH3 0x08
HW_REGISTER(HW_DCP_STAT, REGS_DCP_BASE, 0x00000010)
#define HW_DCP_STAT_ADDR (REGS_DCP_BASE + 0x00000010)
#define BM_DCP_STAT_OTP_KEY_READY 0x10000000
#define BP_DCP_STAT_CUR_CHANNEL      24
#define BM_DCP_STAT_CUR_CHANNEL 0x0F000000
#define BF_DCP_STAT_CUR_CHANNEL(v)  \
	(((v) << 24) & BM_DCP_STAT_CUR_CHANNEL)
#define BV_DCP_STAT_CUR_CHANNEL__None 0x0
#define BV_DCP_STAT_CUR_CHANNEL__CH0  0x1
#define BV_DCP_STAT_CUR_CHANNEL__CH1  0x2
#define BV_DCP_STAT_CUR_CHANNEL__CH2  0x3
#define BV_DCP_STAT_CUR_CHANNEL__CH3  0x4
#define BV_DCP_STAT_CUR_CHANNEL__CSC  0x8
#define BP_DCP_STAT_READY_CHANNELS      16
#define BM_DCP_STAT_READY_CHANNELS 0x00FF0000
#define BF_DCP_STAT_READY_CHANNELS(v)  \
	(((v) << 16) & BM_DCP_STAT_READY_CHANNELS)
#define BV_DCP_STAT_READY_CHANNELS__CH0 0x01
#define BV_DCP_STAT_READY_CHANNELS__CH1 0x02
#define BV_DCP_STAT_READY_CHANNELS__CH2 0x04
#define BV_DCP_STAT_READY_CHANNELS__CH3 0x08
#define BM_DCP_STAT_CSCIRQ 0x00000100
#define BP_DCP_STAT_IRQ      0
#define BM_DCP_STAT_IRQ 0x0000000F
#define BF_DCP_STAT_IRQ(v)  \
	(((v) << 0) & BM_DCP_STAT_IRQ)
HW_REGISTER(HW_DCP_CHANNELCTRL, REGS_DCP_BASE, 0x00000020)
#define HW_DCP_CHANNELCTRL_ADDR (REGS_DCP_BASE + 0x00000020)
#define BP_DCP_CHANNELCTRL_CSC_PRIORITY      17
#define BM_DCP_CHANNELCTRL_CSC_PRIORITY 0x00060000
#define BF_DCP_CHANNELCTRL_CSC_PRIORITY(v)  \
	(((v) << 17) & BM_DCP_CHANNELCTRL_CSC_PRIORITY)
#define BV_DCP_CHANNELCTRL_CSC_PRIORITY__HIGH       0x3
#define BV_DCP_CHANNELCTRL_CSC_PRIORITY__MED	0x2
#define BV_DCP_CHANNELCTRL_CSC_PRIORITY__LOW	0x1
#define BV_DCP_CHANNELCTRL_CSC_PRIORITY__BACKGROUND 0x0
#define BM_DCP_CHANNELCTRL_CH0_IRQ_MERGED 0x00010000
#define BP_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL      8
#define BM_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL 0x0000FF00
#define BF_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL(v)  \
	(((v) << 8) & BM_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL)
#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL__CH0 0x01
#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL__CH1 0x02
#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL__CH2 0x04
#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL__CH3 0x08
#define BP_DCP_CHANNELCTRL_ENABLE_CHANNEL      0
#define BM_DCP_CHANNELCTRL_ENABLE_CHANNEL 0x000000FF
#define BF_DCP_CHANNELCTRL_ENABLE_CHANNEL(v)  \
	(((v) << 0) & BM_DCP_CHANNELCTRL_ENABLE_CHANNEL)
#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL__CH0 0x01
#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL__CH1 0x02
#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL__CH2 0x04
#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL__CH3 0x08
HW_REGISTER_0(HW_DCP_CAPABILITY0, REGS_DCP_BASE, 0x00000030)
#define HW_DCP_CAPABILITY0_ADDR (REGS_DCP_BASE + 0x00000030)
#define BM_DCP_CAPABILITY0_DISABLE_DECRYPT 0x80000000
#define BM_DCP_CAPABILITY0_ENABLE_TZONE 0x40000000
#define BP_DCP_CAPABILITY0_NUM_CHANNELS      8
#define BM_DCP_CAPABILITY0_NUM_CHANNELS 0x00000F00
#define BF_DCP_CAPABILITY0_NUM_CHANNELS(v)  \
	(((v) << 8) & BM_DCP_CAPABILITY0_NUM_CHANNELS)
#define BP_DCP_CAPABILITY0_NUM_KEYS      0
#define BM_DCP_CAPABILITY0_NUM_KEYS 0x000000FF
#define BF_DCP_CAPABILITY0_NUM_KEYS(v)  \
	(((v) << 0) & BM_DCP_CAPABILITY0_NUM_KEYS)
HW_REGISTER_0(HW_DCP_CAPABILITY1, REGS_DCP_BASE, 0x00000040)
#define HW_DCP_CAPABILITY1_ADDR (REGS_DCP_BASE + 0x00000040)
#define BP_DCP_CAPABILITY1_HASH_ALGORITHMS      16
#define BM_DCP_CAPABILITY1_HASH_ALGORITHMS 0xFFFF0000
#define BF_DCP_CAPABILITY1_HASH_ALGORITHMS(v) \
	(((v) << 16) & BM_DCP_CAPABILITY1_HASH_ALGORITHMS)
#define BV_DCP_CAPABILITY1_HASH_ALGORITHMS__SHA1  0x0001
#define BV_DCP_CAPABILITY1_HASH_ALGORITHMS__CRC32 0x0002
#define BP_DCP_CAPABILITY1_CIPHER_ALGORITHMS      0
#define BM_DCP_CAPABILITY1_CIPHER_ALGORITHMS 0x0000FFFF
#define BF_DCP_CAPABILITY1_CIPHER_ALGORITHMS(v)  \
	(((v) << 0) & BM_DCP_CAPABILITY1_CIPHER_ALGORITHMS)
#define BV_DCP_CAPABILITY1_CIPHER_ALGORITHMS__AES128 0x0001
HW_REGISTER_0(HW_DCP_CONTEXT, REGS_DCP_BASE, 0x00000050)
#define HW_DCP_CONTEXT_ADDR (REGS_DCP_BASE + 0x00000050)
#define BP_DCP_CONTEXT_ADDR      0
#define BM_DCP_CONTEXT_ADDR 0xFFFFFFFF
#define BF_DCP_CONTEXT_ADDR(v)   (v)
HW_REGISTER_0(HW_DCP_KEY, REGS_DCP_BASE, 0x00000060)
#define HW_DCP_KEY_ADDR (REGS_DCP_BASE + 0x00000060)
#define BP_DCP_KEY_INDEX      4
#define BM_DCP_KEY_INDEX 0x00000030
#define BF_DCP_KEY_INDEX(v)  \
	(((v) << 4) & BM_DCP_KEY_INDEX)
#define BP_DCP_KEY_SUBWORD      0
#define BM_DCP_KEY_SUBWORD 0x00000003
#define BF_DCP_KEY_SUBWORD(v)  \
	(((v) << 0) & BM_DCP_KEY_SUBWORD)
HW_REGISTER_0(HW_DCP_KEYDATA, REGS_DCP_BASE, 0x00000070)
#define HW_DCP_KEYDATA_ADDR (REGS_DCP_BASE + 0x00000070)
#define BP_DCP_KEYDATA_DATA      0
#define BM_DCP_KEYDATA_DATA 0xFFFFFFFF
#define BF_DCP_KEYDATA_DATA(v)   (v)
HW_REGISTER_0(HW_DCP_PACKET0, REGS_DCP_BASE, 0x00000080)
#define HW_DCP_PACKET0_ADDR (REGS_DCP_BASE + 0x00000080)
#define BP_DCP_PACKET0_ADDR      0
#define BM_DCP_PACKET0_ADDR 0xFFFFFFFF
#define BF_DCP_PACKET0_ADDR(v)   (v)
HW_REGISTER_0(HW_DCP_PACKET1, REGS_DCP_BASE, 0x00000090)
#define HW_DCP_PACKET1_ADDR (REGS_DCP_BASE + 0x00000090)
#define BP_DCP_PACKET1_TAG      24
#define BM_DCP_PACKET1_TAG 0xFF000000
#define BF_DCP_PACKET1_TAG(v) \
	(((v) << 24) & BM_DCP_PACKET1_TAG)
#define BM_DCP_PACKET1_OUTPUT_WORDSWAP 0x00800000
#define BM_DCP_PACKET1_OUTPUT_BYTESWAP 0x00400000
#define BM_DCP_PACKET1_INPUT_WORDSWAP 0x00200000
#define BM_DCP_PACKET1_INPUT_BYTESWAP 0x00100000
#define BM_DCP_PACKET1_KEY_WORDSWAP 0x00080000
#define BM_DCP_PACKET1_KEY_BYTESWAP 0x00040000
#define BM_DCP_PACKET1_TEST_SEMA_IRQ 0x00020000
#define BM_DCP_PACKET1_CONSTANT_FILL 0x00010000
#define BM_DCP_PACKET1_HASH_OUTPUT 0x00008000
#define BV_DCP_PACKET1_HASH_OUTPUT__INPUT  0x00
#define BV_DCP_PACKET1_HASH_OUTPUT__OUTPUT 0x01
#define BM_DCP_PACKET1_CHECK_HASH 0x00004000
#define BM_DCP_PACKET1_HASH_TERM 0x00002000
#define BM_DCP_PACKET1_HASH_INIT 0x00001000
#define BM_DCP_PACKET1_PAYLOAD_KEY 0x00000800
#define BM_DCP_PACKET1_OTP_KEY 0x00000400
#define BM_DCP_PACKET1_CIPHER_INIT 0x00000200
#define BM_DCP_PACKET1_CIPHER_ENCRYPT 0x00000100
#define BV_DCP_PACKET1_CIPHER_ENCRYPT__ENCRYPT 0x01
#define BV_DCP_PACKET1_CIPHER_ENCRYPT__DECRYPT 0x00
#define BM_DCP_PACKET1_ENABLE_BLIT 0x00000080
#define BM_DCP_PACKET1_ENABLE_HASH 0x00000040
#define BM_DCP_PACKET1_ENABLE_CIPHER 0x00000020
#define BM_DCP_PACKET1_ENABLE_MEMCOPY 0x00000010
#define BM_DCP_PACKET1_CHAIN_CONTIGUOUS 0x00000008
#define BM_DCP_PACKET1_CHAIN 0x00000004
#define BM_DCP_PACKET1_DECR_SEMAPHORE 0x00000002
#define BM_DCP_PACKET1_INTERRUPT 0x00000001
HW_REGISTER_0(HW_DCP_PACKET2, REGS_DCP_BASE, 0x000000a0)
#define HW_DCP_PACKET2_ADDR (REGS_DCP_BASE + 0x000000a0)
#define BP_DCP_PACKET2_CIPHER_CFG      24
#define BM_DCP_PACKET2_CIPHER_CFG 0xFF000000
#define BF_DCP_PACKET2_CIPHER_CFG(v) \
	(((v) << 24) & BM_DCP_PACKET2_CIPHER_CFG)
#define BP_DCP_PACKET2_HASH_SELECT      16
#define BM_DCP_PACKET2_HASH_SELECT 0x000F0000
#define BF_DCP_PACKET2_HASH_SELECT(v)  \
	(((v) << 16) & BM_DCP_PACKET2_HASH_SELECT)
#define BV_DCP_PACKET2_HASH_SELECT__SHA1  0x00
#define BV_DCP_PACKET2_HASH_SELECT__CRC32 0x01
#define BP_DCP_PACKET2_KEY_SELECT      8
#define BM_DCP_PACKET2_KEY_SELECT 0x0000FF00
#define BF_DCP_PACKET2_KEY_SELECT(v)  \
	(((v) << 8) & BM_DCP_PACKET2_KEY_SELECT)
#define BP_DCP_PACKET2_CIPHER_MODE      4
#define BM_DCP_PACKET2_CIPHER_MODE 0x000000F0
#define BF_DCP_PACKET2_CIPHER_MODE(v)  \
	(((v) << 4) & BM_DCP_PACKET2_CIPHER_MODE)
#define BV_DCP_PACKET2_CIPHER_MODE__ECB 0x00
#define BV_DCP_PACKET2_CIPHER_MODE__CBC 0x01
#define BP_DCP_PACKET2_CIPHER_SELECT      0
#define BM_DCP_PACKET2_CIPHER_SELECT 0x0000000F
#define BF_DCP_PACKET2_CIPHER_SELECT(v)  \
	(((v) << 0) & BM_DCP_PACKET2_CIPHER_SELECT)
#define BV_DCP_PACKET2_CIPHER_SELECT__AES128 0x00
HW_REGISTER_0(HW_DCP_PACKET3, REGS_DCP_BASE, 0x000000b0)
#define HW_DCP_PACKET3_ADDR (REGS_DCP_BASE + 0x000000b0)
#define BP_DCP_PACKET3_ADDR      0
#define BM_DCP_PACKET3_ADDR 0xFFFFFFFF
#define BF_DCP_PACKET3_ADDR(v)   (v)
HW_REGISTER_0(HW_DCP_PACKET4, REGS_DCP_BASE, 0x000000c0)
#define HW_DCP_PACKET4_ADDR (REGS_DCP_BASE + 0x000000c0)
#define BP_DCP_PACKET4_ADDR      0
#define BM_DCP_PACKET4_ADDR 0xFFFFFFFF
#define BF_DCP_PACKET4_ADDR(v)   (v)
HW_REGISTER_0(HW_DCP_PACKET5, REGS_DCP_BASE, 0x000000d0)
#define HW_DCP_PACKET5_ADDR (REGS_DCP_BASE + 0x000000d0)
#define BP_DCP_PACKET5_COUNT      0
#define BM_DCP_PACKET5_COUNT 0xFFFFFFFF
#define BF_DCP_PACKET5_COUNT(v)   (v)
HW_REGISTER_0(HW_DCP_PACKET6, REGS_DCP_BASE, 0x000000e0)
#define HW_DCP_PACKET6_ADDR (REGS_DCP_BASE + 0x000000e0)
#define BP_DCP_PACKET6_ADDR      0
#define BM_DCP_PACKET6_ADDR 0xFFFFFFFF
#define BF_DCP_PACKET6_ADDR(v)   (v)
/*
 *  multi-register-define name HW_DCP_CHnCMDPTR
 *	      base 0x00000100
 *	      count 4
 *	      offset 0x40
 */
HW_REGISTER_0_INDEXED(HW_DCP_CHnCMDPTR, REGS_DCP_BASE, 0x00000100, 0x40)
#define BP_DCP_CHnCMDPTR_ADDR      0
#define BM_DCP_CHnCMDPTR_ADDR 0xFFFFFFFF
#define BF_DCP_CHnCMDPTR_ADDR(v)   (v)
/*
 *  multi-register-define name HW_DCP_CHnSEMA
 *	      base 0x00000110
 *	      count 4
 *	      offset 0x40
 */
HW_REGISTER_0_INDEXED(HW_DCP_CHnSEMA, REGS_DCP_BASE, 0x00000110, 0x40)
#define BP_DCP_CHnSEMA_VALUE      16
#define BM_DCP_CHnSEMA_VALUE 0x00FF0000
#define BF_DCP_CHnSEMA_VALUE(v)  \
	(((v) << 16) & BM_DCP_CHnSEMA_VALUE)
#define BP_DCP_CHnSEMA_INCREMENT      0
#define BM_DCP_CHnSEMA_INCREMENT 0x000000FF
#define BF_DCP_CHnSEMA_INCREMENT(v)  \
	(((v) << 0) & BM_DCP_CHnSEMA_INCREMENT)
/*
 *  multi-register-define name HW_DCP_CHnSTAT
 *	      base 0x00000120
 *	      count 4
 *	      offset 0x40
 */
HW_REGISTER_INDEXED(HW_DCP_CHnSTAT, REGS_DCP_BASE, 0x00000120, 0x40)
#define BP_DCP_CHnSTAT_TAG      24
#define BM_DCP_CHnSTAT_TAG 0xFF000000
#define BF_DCP_CHnSTAT_TAG(v) \
	(((v) << 24) & BM_DCP_CHnSTAT_TAG)
#define BP_DCP_CHnSTAT_ERROR_CODE      16
#define BM_DCP_CHnSTAT_ERROR_CODE 0x00FF0000
#define BF_DCP_CHnSTAT_ERROR_CODE(v)  \
	(((v) << 16) & BM_DCP_CHnSTAT_ERROR_CODE)
#define BV_DCP_CHnSTAT_ERROR_CODE__NEXT_CHAIN_IS_0 0x01
#define BV_DCP_CHnSTAT_ERROR_CODE__NO_CHAIN	0x02
#define BV_DCP_CHnSTAT_ERROR_CODE__CONTEXT_ERROR   0x03
#define BV_DCP_CHnSTAT_ERROR_CODE__PAYLOAD_ERROR   0x04
#define BV_DCP_CHnSTAT_ERROR_CODE__INVALID_MODE    0x05
#define BM_DCP_CHnSTAT_ERROR_PAGEFAULT 0x00000040
#define BM_DCP_CHnSTAT_ERROR_DST 0x00000020
#define BM_DCP_CHnSTAT_ERROR_SRC 0x00000010
#define BM_DCP_CHnSTAT_ERROR_PACKET 0x00000008
#define BM_DCP_CHnSTAT_ERROR_SETUP 0x00000004
#define BM_DCP_CHnSTAT_HASH_MISMATCH 0x00000002
/*
 *  multi-register-define name HW_DCP_CHnOPTS
 *	      base 0x00000130
 *	      count 4
 *	      offset 0x40
 */
HW_REGISTER_INDEXED(HW_DCP_CHnOPTS, REGS_DCP_BASE, 0x00000130, 0x40)
#define BP_DCP_CHnOPTS_RECOVERY_TIMER      0
#define BM_DCP_CHnOPTS_RECOVERY_TIMER 0x0000FFFF
#define BF_DCP_CHnOPTS_RECOVERY_TIMER(v)  \
	(((v) << 0) & BM_DCP_CHnOPTS_RECOVERY_TIMER)
HW_REGISTER(HW_DCP_CSCCTRL0, REGS_DCP_BASE, 0x00000300)
#define HW_DCP_CSCCTRL0_ADDR (REGS_DCP_BASE + 0x00000300)
#define BM_DCP_CSCCTRL0_CLIP 0x00008000
#define BM_DCP_CSCCTRL0_UPSAMPLE 0x00004000
#define BM_DCP_CSCCTRL0_SCALE 0x00002000
#define BM_DCP_CSCCTRL0_ROTATE 0x00001000
#define BM_DCP_CSCCTRL0_SUBSAMPLE 0x00000800
#define BM_DCP_CSCCTRL0_DELTA 0x00000400
#define BP_DCP_CSCCTRL0_RGB_FORMAT      8
#define BM_DCP_CSCCTRL0_RGB_FORMAT 0x00000300
#define BF_DCP_CSCCTRL0_RGB_FORMAT(v)  \
	(((v) << 8) & BM_DCP_CSCCTRL0_RGB_FORMAT)
#define BV_DCP_CSCCTRL0_RGB_FORMAT__RGB16_565 0x0
#define BV_DCP_CSCCTRL0_RGB_FORMAT__YCbCrI    0x1
#define BV_DCP_CSCCTRL0_RGB_FORMAT__RGB24     0x2
#define BV_DCP_CSCCTRL0_RGB_FORMAT__YUV422I   0x3
#define BP_DCP_CSCCTRL0_YUV_FORMAT      4
#define BM_DCP_CSCCTRL0_YUV_FORMAT 0x000000F0
#define BF_DCP_CSCCTRL0_YUV_FORMAT(v)  \
	(((v) << 4) & BM_DCP_CSCCTRL0_YUV_FORMAT)
#define BV_DCP_CSCCTRL0_YUV_FORMAT__YUV420 0x0
#define BV_DCP_CSCCTRL0_YUV_FORMAT__YUV422 0x2
#define BM_DCP_CSCCTRL0_ENABLE 0x00000001
HW_REGISTER(HW_DCP_CSCSTAT, REGS_DCP_BASE, 0x00000310)
#define HW_DCP_CSCSTAT_ADDR (REGS_DCP_BASE + 0x00000310)
#define BP_DCP_CSCSTAT_ERROR_CODE      16
#define BM_DCP_CSCSTAT_ERROR_CODE 0x00FF0000
#define BF_DCP_CSCSTAT_ERROR_CODE(v)  \
	(((v) << 16) & BM_DCP_CSCSTAT_ERROR_CODE)
#define BV_DCP_CSCSTAT_ERROR_CODE__LUMA0_FETCH_ERROR_Y0 0x01
#define BV_DCP_CSCSTAT_ERROR_CODE__LUMA1_FETCH_ERROR_Y1 0x02
#define BV_DCP_CSCSTAT_ERROR_CODE__CHROMA_FETCH_ERROR_U 0x03
#define BV_DCP_CSCSTAT_ERROR_CODE__CHROMA_FETCH_ERROR_V 0x04
#define BM_DCP_CSCSTAT_ERROR_PAGEFAULT 0x00000040
#define BM_DCP_CSCSTAT_ERROR_DST 0x00000020
#define BM_DCP_CSCSTAT_ERROR_SRC 0x00000010
#define BM_DCP_CSCSTAT_ERROR_SETUP 0x00000004
#define BM_DCP_CSCSTAT_COMPLETE 0x00000001
HW_REGISTER_0(HW_DCP_CSCOUTBUFPARAM, REGS_DCP_BASE, 0x00000320)
#define HW_DCP_CSCOUTBUFPARAM_ADDR (REGS_DCP_BASE + 0x00000320)
#define BP_DCP_CSCOUTBUFPARAM_FIELD_SIZE      12
#define BM_DCP_CSCOUTBUFPARAM_FIELD_SIZE 0x00FFF000
#define BF_DCP_CSCOUTBUFPARAM_FIELD_SIZE(v)  \
	(((v) << 12) & BM_DCP_CSCOUTBUFPARAM_FIELD_SIZE)
#define BP_DCP_CSCOUTBUFPARAM_LINE_SIZE      0
#define BM_DCP_CSCOUTBUFPARAM_LINE_SIZE 0x00000FFF
#define BF_DCP_CSCOUTBUFPARAM_LINE_SIZE(v)  \
	(((v) << 0) & BM_DCP_CSCOUTBUFPARAM_LINE_SIZE)
HW_REGISTER_0(HW_DCP_CSCINBUFPARAM, REGS_DCP_BASE, 0x00000330)
#define HW_DCP_CSCINBUFPARAM_ADDR (REGS_DCP_BASE + 0x00000330)
#define BP_DCP_CSCINBUFPARAM_LINE_SIZE      0
#define BM_DCP_CSCINBUFPARAM_LINE_SIZE 0x00000FFF
#define BF_DCP_CSCINBUFPARAM_LINE_SIZE(v)  \
	(((v) << 0) & BM_DCP_CSCINBUFPARAM_LINE_SIZE)
HW_REGISTER_0(HW_DCP_CSCRGB, REGS_DCP_BASE, 0x00000340)
#define HW_DCP_CSCRGB_ADDR (REGS_DCP_BASE + 0x00000340)
#define BP_DCP_CSCRGB_ADDR      0
#define BM_DCP_CSCRGB_ADDR 0xFFFFFFFF
#define BF_DCP_CSCRGB_ADDR(v)   (v)
HW_REGISTER_0(HW_DCP_CSCLUMA, REGS_DCP_BASE, 0x00000350)
#define HW_DCP_CSCLUMA_ADDR (REGS_DCP_BASE + 0x00000350)
#define BP_DCP_CSCLUMA_ADDR      0
#define BM_DCP_CSCLUMA_ADDR 0xFFFFFFFF
#define BF_DCP_CSCLUMA_ADDR(v)   (v)
HW_REGISTER_0(HW_DCP_CSCCHROMAU, REGS_DCP_BASE, 0x00000360)
#define HW_DCP_CSCCHROMAU_ADDR (REGS_DCP_BASE + 0x00000360)
#define BP_DCP_CSCCHROMAU_ADDR      0
#define BM_DCP_CSCCHROMAU_ADDR 0xFFFFFFFF
#define BF_DCP_CSCCHROMAU_ADDR(v)   (v)
HW_REGISTER_0(HW_DCP_CSCCHROMAV, REGS_DCP_BASE, 0x00000370)
#define HW_DCP_CSCCHROMAV_ADDR (REGS_DCP_BASE + 0x00000370)
#define BP_DCP_CSCCHROMAV_ADDR      0
#define BM_DCP_CSCCHROMAV_ADDR 0xFFFFFFFF
#define BF_DCP_CSCCHROMAV_ADDR(v)   (v)
HW_REGISTER_0(HW_DCP_CSCCOEFF0, REGS_DCP_BASE, 0x00000380)
#define HW_DCP_CSCCOEFF0_ADDR (REGS_DCP_BASE + 0x00000380)
#define BP_DCP_CSCCOEFF0_C0      16
#define BM_DCP_CSCCOEFF0_C0 0x03FF0000
#define BF_DCP_CSCCOEFF0_C0(v)  \
	(((v) << 16) & BM_DCP_CSCCOEFF0_C0)
#define BP_DCP_CSCCOEFF0_UV_OFFSET      8
#define BM_DCP_CSCCOEFF0_UV_OFFSET 0x0000FF00
#define BF_DCP_CSCCOEFF0_UV_OFFSET(v)  \
	(((v) << 8) & BM_DCP_CSCCOEFF0_UV_OFFSET)
#define BP_DCP_CSCCOEFF0_Y_OFFSET      0
#define BM_DCP_CSCCOEFF0_Y_OFFSET 0x000000FF
#define BF_DCP_CSCCOEFF0_Y_OFFSET(v)  \
	(((v) << 0) & BM_DCP_CSCCOEFF0_Y_OFFSET)
HW_REGISTER_0(HW_DCP_CSCCOEFF1, REGS_DCP_BASE, 0x00000390)
#define HW_DCP_CSCCOEFF1_ADDR (REGS_DCP_BASE + 0x00000390)
#define BP_DCP_CSCCOEFF1_C1      16
#define BM_DCP_CSCCOEFF1_C1 0x03FF0000
#define BF_DCP_CSCCOEFF1_C1(v)  \
	(((v) << 16) & BM_DCP_CSCCOEFF1_C1)
#define BP_DCP_CSCCOEFF1_C4      0
#define BM_DCP_CSCCOEFF1_C4 0x000003FF
#define BF_DCP_CSCCOEFF1_C4(v)  \
	(((v) << 0) & BM_DCP_CSCCOEFF1_C4)
HW_REGISTER_0(HW_DCP_CSCCOEFF2, REGS_DCP_BASE, 0x000003a0)
#define HW_DCP_CSCCOEFF2_ADDR (REGS_DCP_BASE + 0x000003a0)
#define BP_DCP_CSCCOEFF2_C2      16
#define BM_DCP_CSCCOEFF2_C2 0x03FF0000
#define BF_DCP_CSCCOEFF2_C2(v)  \
	(((v) << 16) & BM_DCP_CSCCOEFF2_C2)
#define BP_DCP_CSCCOEFF2_C3      0
#define BM_DCP_CSCCOEFF2_C3 0x000003FF
#define BF_DCP_CSCCOEFF2_C3(v)  \
	(((v) << 0) & BM_DCP_CSCCOEFF2_C3)
HW_REGISTER_0(HW_DCP_CSCCLIP, REGS_DCP_BASE, 0x000003d0)
#define HW_DCP_CSCCLIP_ADDR (REGS_DCP_BASE + 0x000003d0)
#define BP_DCP_CSCCLIP_HEIGHT      12
#define BM_DCP_CSCCLIP_HEIGHT 0x00FFF000
#define BF_DCP_CSCCLIP_HEIGHT(v)  \
	(((v) << 12) & BM_DCP_CSCCLIP_HEIGHT)
#define BP_DCP_CSCCLIP_WIDTH      0
#define BM_DCP_CSCCLIP_WIDTH 0x00000FFF
#define BF_DCP_CSCCLIP_WIDTH(v)  \
	(((v) << 0) & BM_DCP_CSCCLIP_WIDTH)
HW_REGISTER_0(HW_DCP_CSCXSCALE, REGS_DCP_BASE, 0x000003e0)
#define HW_DCP_CSCXSCALE_ADDR (REGS_DCP_BASE + 0x000003e0)
#define BP_DCP_CSCXSCALE_INT      24
#define BM_DCP_CSCXSCALE_INT 0x03000000
#define BF_DCP_CSCXSCALE_INT(v)  \
	(((v) << 24) & BM_DCP_CSCXSCALE_INT)
#define BP_DCP_CSCXSCALE_FRAC      12
#define BM_DCP_CSCXSCALE_FRAC 0x00FFF000
#define BF_DCP_CSCXSCALE_FRAC(v)  \
	(((v) << 12) & BM_DCP_CSCXSCALE_FRAC)
#define BP_DCP_CSCXSCALE_WIDTH      0
#define BM_DCP_CSCXSCALE_WIDTH 0x00000FFF
#define BF_DCP_CSCXSCALE_WIDTH(v)  \
	(((v) << 0) & BM_DCP_CSCXSCALE_WIDTH)
HW_REGISTER_0(HW_DCP_CSCYSCALE, REGS_DCP_BASE, 0x000003f0)
#define HW_DCP_CSCYSCALE_ADDR (REGS_DCP_BASE + 0x000003f0)
#define BP_DCP_CSCYSCALE_INT      24
#define BM_DCP_CSCYSCALE_INT 0x03000000
#define BF_DCP_CSCYSCALE_INT(v)  \
	(((v) << 24) & BM_DCP_CSCYSCALE_INT)
#define BP_DCP_CSCYSCALE_FRAC      12
#define BM_DCP_CSCYSCALE_FRAC 0x00FFF000
#define BF_DCP_CSCYSCALE_FRAC(v)  \
	(((v) << 12) & BM_DCP_CSCYSCALE_FRAC)
#define BP_DCP_CSCYSCALE_HEIGHT      0
#define BM_DCP_CSCYSCALE_HEIGHT 0x00000FFF
#define BF_DCP_CSCYSCALE_HEIGHT(v)  \
	(((v) << 0) & BM_DCP_CSCYSCALE_HEIGHT)
HW_REGISTER_0(HW_DCP_DBGSELECT, REGS_DCP_BASE, 0x00000400)
#define HW_DCP_DBGSELECT_ADDR (REGS_DCP_BASE + 0x00000400)
#define BP_DCP_DBGSELECT_INDEX      0
#define BM_DCP_DBGSELECT_INDEX 0x000000FF
#define BF_DCP_DBGSELECT_INDEX(v)  \
	(((v) << 0) & BM_DCP_DBGSELECT_INDEX)
#define BV_DCP_DBGSELECT_INDEX__CONTROL 0x01
#define BV_DCP_DBGSELECT_INDEX__OTPKEY0 0x10
#define BV_DCP_DBGSELECT_INDEX__OTPKEY1 0x11
#define BV_DCP_DBGSELECT_INDEX__OTPKEY2 0x12
#define BV_DCP_DBGSELECT_INDEX__OTPKEY3 0x13
HW_REGISTER_0(HW_DCP_DBGDATA, REGS_DCP_BASE, 0x00000410)
#define HW_DCP_DBGDATA_ADDR (REGS_DCP_BASE + 0x00000410)
#define BP_DCP_DBGDATA_DATA      0
#define BM_DCP_DBGDATA_DATA 0xFFFFFFFF
#define BF_DCP_DBGDATA_DATA(v)   (v)
HW_REGISTER_0(HW_DCP_PAGETABLE, REGS_DCP_BASE, 0x00000420)
#define HW_DCP_PAGETABLE_ADDR (REGS_DCP_BASE + 0x00000420)
#define BP_DCP_PAGETABLE_BASE      2
#define BM_DCP_PAGETABLE_BASE 0xFFFFFFFC
#define BF_DCP_PAGETABLE_BASE(v) \
	(((v) << 2) & BM_DCP_PAGETABLE_BASE)
#define BM_DCP_PAGETABLE_FLUSH 0x00000002
#define BM_DCP_PAGETABLE_ENABLE 0x00000001
HW_REGISTER_0(HW_DCP_VERSION, REGS_DCP_BASE, 0x00000430)
#define HW_DCP_VERSION_ADDR (REGS_DCP_BASE + 0x00000430)
#define BP_DCP_VERSION_MAJOR      24
#define BM_DCP_VERSION_MAJOR 0xFF000000
#define BF_DCP_VERSION_MAJOR(v) \
	(((v) << 24) & BM_DCP_VERSION_MAJOR)
#define BP_DCP_VERSION_MINOR      16
#define BM_DCP_VERSION_MINOR 0x00FF0000
#define BF_DCP_VERSION_MINOR(v)  \
	(((v) << 16) & BM_DCP_VERSION_MINOR)
#define BP_DCP_VERSION_STEP      0
#define BM_DCP_VERSION_STEP 0x0000FFFF
#define BF_DCP_VERSION_STEP(v)  \
	(((v) << 0) & BM_DCP_VERSION_STEP)
#endif /* __ARCH_ARM___DCP_H */
