/*
 * Copyright 2004-2008 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

#ifndef __ASM_ARCH_MXC_MX27_PINS_H__
#define __ASM_ARCH_MXC_MX27_PINS_H__

/*!
 * @file arch-mxc/mx27_pins.h
 *
 * @brief MX27 I/O Pin List
 *
 * @ingroup GPIO_MX27
 */

#ifndef __ASSEMBLY__

#define _MX27_BUILD_PIN(gp,gi) (((gp) << MUX_IO_P) | ((gi) << MUX_IO_I))

enum iomux_pins {
	MX27_PIN_USBH2_CLK = _MX27_BUILD_PIN(0, 0),
	MX27_PIN_USBH2_DIR = _MX27_BUILD_PIN(0, 1),
	MX27_PIN_USBH2_DATA7 = _MX27_BUILD_PIN(0, 2),
	MX27_PIN_USBH2_NXT = _MX27_BUILD_PIN(0, 3),
	MX27_PIN_USBH2_STP = _MX27_BUILD_PIN(0, 4),
	MX27_PIN_LSCLK = _MX27_BUILD_PIN(0, 5),
	MX27_PIN_LD0 = _MX27_BUILD_PIN(0, 6),
	MX27_PIN_LD1 = _MX27_BUILD_PIN(0, 7),
	MX27_PIN_LD2 = _MX27_BUILD_PIN(0, 8),
	MX27_PIN_LD3 = _MX27_BUILD_PIN(0, 9),
	MX27_PIN_LD4 = _MX27_BUILD_PIN(0, 10),
	MX27_PIN_LD5 = _MX27_BUILD_PIN(0, 11),
	MX27_PIN_LD6 = _MX27_BUILD_PIN(0, 12),
	MX27_PIN_LD7 = _MX27_BUILD_PIN(0, 13),
	MX27_PIN_LD8 = _MX27_BUILD_PIN(0, 14),
	MX27_PIN_LD9 = _MX27_BUILD_PIN(0, 15),
	MX27_PIN_LD10 = _MX27_BUILD_PIN(0, 16),
	MX27_PIN_LD11 = _MX27_BUILD_PIN(0, 17),
	MX27_PIN_LD12 = _MX27_BUILD_PIN(0, 18),
	MX27_PIN_LD13 = _MX27_BUILD_PIN(0, 19),
	MX27_PIN_LD14 = _MX27_BUILD_PIN(0, 20),
	MX27_PIN_LD15 = _MX27_BUILD_PIN(0, 21),
	MX27_PIN_LD16 = _MX27_BUILD_PIN(0, 22),
	MX27_PIN_LD17 = _MX27_BUILD_PIN(0, 23),
	MX27_PIN_REV = _MX27_BUILD_PIN(0, 24),
	MX27_PIN_CLS = _MX27_BUILD_PIN(0, 25),
	MX27_PIN_PS = _MX27_BUILD_PIN(0, 26),
	MX27_PIN_SPL_SPR = _MX27_BUILD_PIN(0, 27),
	MX27_PIN_HSYNC = _MX27_BUILD_PIN(0, 28),
	MX27_PIN_VSYNC = _MX27_BUILD_PIN(0, 29),
	MX27_PIN_CONTRAST = _MX27_BUILD_PIN(0, 30),
	MX27_PIN_OE_ACD = _MX27_BUILD_PIN(0, 31),

	MX27_PIN_SD2_D0 = _MX27_BUILD_PIN(1, 4),
	MX27_PIN_SD2_D1 = _MX27_BUILD_PIN(1, 5),
	MX27_PIN_SD2_D2 = _MX27_BUILD_PIN(1, 6),
	MX27_PIN_SD2_D3 = _MX27_BUILD_PIN(1, 7),
	MX27_PIN_SD2_CMD = _MX27_BUILD_PIN(1, 8),
	MX27_PIN_SD2_CLK = _MX27_BUILD_PIN(1, 9),
	MX27_PIN_CSI_D0 = _MX27_BUILD_PIN(1, 10),
	MX27_PIN_CSI_D1 = _MX27_BUILD_PIN(1, 11),
	MX27_PIN_CSI_D2 = _MX27_BUILD_PIN(1, 12),
	MX27_PIN_CSI_D3 = _MX27_BUILD_PIN(1, 13),
	MX27_PIN_CSI_D4 = _MX27_BUILD_PIN(1, 14),
	MX27_PIN_CSI_MCLK = _MX27_BUILD_PIN(1, 15),
	MX27_PIN_CSI_PIXCLK = _MX27_BUILD_PIN(1, 16),
	MX27_PIN_CSI_D5 = _MX27_BUILD_PIN(1, 17),
	MX27_PIN_CSI_D6 = _MX27_BUILD_PIN(1, 18),
	MX27_PIN_CSI_D7 = _MX27_BUILD_PIN(1, 19),
	MX27_PIN_CSI_VSYNC = _MX27_BUILD_PIN(1, 20),
	MX27_PIN_CSI_HSYNC = _MX27_BUILD_PIN(1, 21),
	MX27_PIN_USBH1_SUSP = _MX27_BUILD_PIN(1, 22),
	MX27_PIN_USB_PWR = _MX27_BUILD_PIN(1, 23),
	MX27_PIN_USB_OC_B = _MX27_BUILD_PIN(1, 24),
	MX27_PIN_USBH1_RCV = _MX27_BUILD_PIN(1, 25),
	MX27_PIN_USBH1_FS = _MX27_BUILD_PIN(1, 26),
	MX27_PIN_USBH1_OE_B = _MX27_BUILD_PIN(1, 27),
	MX27_PIN_USBH1_TXDM = _MX27_BUILD_PIN(1, 28),
	MX27_PIN_USBH1_TXDP = _MX27_BUILD_PIN(1, 29),
	MX27_PIN_USBH1_RXDM = _MX27_BUILD_PIN(1, 30),
	MX27_PIN_USBH1_RXDP = _MX27_BUILD_PIN(1, 31),

	MX27_PIN_I2C2_SDA = _MX27_BUILD_PIN(2, 5),
	MX27_PIN_I2C2_SCL = _MX27_BUILD_PIN(2, 6),
	MX27_PIN_USBOTG_DATA5 = _MX27_BUILD_PIN(2, 7),
	MX27_PIN_USBOTG_DATA6 = _MX27_BUILD_PIN(2, 8),
	MX27_PIN_USBOTG_DATA0 = _MX27_BUILD_PIN(2, 9),
	MX27_PIN_USBOTG_DATA2 = _MX27_BUILD_PIN(2, 10),
	MX27_PIN_USBOTG_DATA1 = _MX27_BUILD_PIN(2, 11),
	MX27_PIN_USBOTG_DATA4 = _MX27_BUILD_PIN(2, 12),
	MX27_PIN_USBOTG_DATA3 = _MX27_BUILD_PIN(2, 13),
	MX27_PIN_TOUT = _MX27_BUILD_PIN(2, 14),
	MX27_PIN_TIN = _MX27_BUILD_PIN(2, 15),
	MX27_PIN_SSI4_FS = _MX27_BUILD_PIN(2, 16),
	MX27_PIN_SSI4_RXDAT = _MX27_BUILD_PIN(2, 17),
	MX27_PIN_SSI4_TXDAT = _MX27_BUILD_PIN(2, 18),
	MX27_PIN_SSI4_CLK = _MX27_BUILD_PIN(2, 19),
	MX27_PIN_SSI1_FS = _MX27_BUILD_PIN(2, 20),
	MX27_PIN_SSI1_RXDAT = _MX27_BUILD_PIN(2, 21),
	MX27_PIN_SSI1_TXDAT = _MX27_BUILD_PIN(2, 22),
	MX27_PIN_SSI1_CLK = _MX27_BUILD_PIN(2, 23),
	MX27_PIN_SSI2_FS = _MX27_BUILD_PIN(2, 24),
	MX27_PIN_SSI2_RXDAT = _MX27_BUILD_PIN(2, 25),
	MX27_PIN_SSI2_TXDAT = _MX27_BUILD_PIN(2, 26),
	MX27_PIN_SSI2_CLK = _MX27_BUILD_PIN(2, 27),
	MX27_PIN_SSI3_FS = _MX27_BUILD_PIN(2, 28),
	MX27_PIN_SSI3_RXDAT = _MX27_BUILD_PIN(2, 29),
	MX27_PIN_SSI3_TXDAT = _MX27_BUILD_PIN(2, 30),
	MX27_PIN_SSI3_CLK = _MX27_BUILD_PIN(2, 31),

	MX27_PIN_SD3_CMD = _MX27_BUILD_PIN(3, 0),
	MX27_PIN_SD3_CLK = _MX27_BUILD_PIN(3, 1),
	MX27_PIN_ATA_DATA0 = _MX27_BUILD_PIN(3, 2),
	MX27_PIN_ATA_DATA1 = _MX27_BUILD_PIN(3, 3),
	MX27_PIN_ATA_DATA2 = _MX27_BUILD_PIN(3, 4),
	MX27_PIN_ATA_DATA3 = _MX27_BUILD_PIN(3, 5),
	MX27_PIN_ATA_DATA4 = _MX27_BUILD_PIN(3, 6),
	MX27_PIN_ATA_DATA5 = _MX27_BUILD_PIN(3, 7),
	MX27_PIN_ATA_DATA6 = _MX27_BUILD_PIN(3, 8),
	MX27_PIN_ATA_DATA7 = _MX27_BUILD_PIN(3, 9),
	MX27_PIN_ATA_DATA8 = _MX27_BUILD_PIN(3, 10),
	MX27_PIN_ATA_DATA9 = _MX27_BUILD_PIN(3, 11),
	MX27_PIN_ATA_DATA10 = _MX27_BUILD_PIN(3, 12),
	MX27_PIN_ATA_DATA11 = _MX27_BUILD_PIN(3, 13),
	MX27_PIN_ATA_DATA12 = _MX27_BUILD_PIN(3, 14),
	MX27_PIN_ATA_DATA13 = _MX27_BUILD_PIN(3, 15),
	MX27_PIN_ATA_DATA14 = _MX27_BUILD_PIN(3, 16),
	MX27_PIN_I2C_DATA = _MX27_BUILD_PIN(3, 17),
	MX27_PIN_I2C_CLK = _MX27_BUILD_PIN(3, 18),
	MX27_PIN_CSPI2_SS2 = _MX27_BUILD_PIN(3, 19),
	MX27_PIN_CSPI2_SS1 = _MX27_BUILD_PIN(3, 20),
	MX27_PIN_CSPI2_SS0 = _MX27_BUILD_PIN(3, 21),
	MX27_PIN_CSPI2_SCLK = _MX27_BUILD_PIN(3, 22),
	MX27_PIN_CSPI2_MISO = _MX27_BUILD_PIN(3, 23),
	MX27_PIN_CSPI2_MOSI = _MX27_BUILD_PIN(3, 24),
	MX27_PIN_CSPI1_RDY = _MX27_BUILD_PIN(3, 25),
	MX27_PIN_CSPI1_SS2 = _MX27_BUILD_PIN(3, 26),
	MX27_PIN_CSPI1_SS1 = _MX27_BUILD_PIN(3, 27),
	MX27_PIN_CSPI1_SS0 = _MX27_BUILD_PIN(3, 28),
	MX27_PIN_CSPI1_SCLK = _MX27_BUILD_PIN(3, 29),
	MX27_PIN_CSPI1_MISO = _MX27_BUILD_PIN(3, 30),
	MX27_PIN_CSPI1_MOSI = _MX27_BUILD_PIN(3, 31),

	MX27_PIN_USBOTG_NXT = _MX27_BUILD_PIN(4, 0),
	MX27_PIN_USBOTG_STP = _MX27_BUILD_PIN(4, 1),
	MX27_PIN_USBOTG_DIR = _MX27_BUILD_PIN(4, 2),
	MX27_PIN_UART2_CTS = _MX27_BUILD_PIN(4, 3),
	MX27_PIN_UART2_RTS = _MX27_BUILD_PIN(4, 4),
	MX27_PIN_PWMO = _MX27_BUILD_PIN(4, 5),
	MX27_PIN_UART2_TXD = _MX27_BUILD_PIN(4, 6),
	MX27_PIN_UART2_RXD = _MX27_BUILD_PIN(4, 7),
	MX27_PIN_UART3_TXD = _MX27_BUILD_PIN(4, 8),
	MX27_PIN_UART3_RXD = _MX27_BUILD_PIN(4, 9),
	MX27_PIN_UART3_CTS = _MX27_BUILD_PIN(4, 10),
	MX27_PIN_UART3_RTS = _MX27_BUILD_PIN(4, 11),
	MX27_PIN_UART1_TXD = _MX27_BUILD_PIN(4, 12),
	MX27_PIN_UART1_RXD = _MX27_BUILD_PIN(4, 13),
	MX27_PIN_UART1_CTS = _MX27_BUILD_PIN(4, 14),
	MX27_PIN_UART1_RTS = _MX27_BUILD_PIN(4, 15),
	MX27_PIN_RTCK = _MX27_BUILD_PIN(4, 16),
	MX27_PIN_RESET_OUT_B = _MX27_BUILD_PIN(4, 17),
	MX27_PIN_SD1_D0 = _MX27_BUILD_PIN(4, 18),
	MX27_PIN_SD1_D1 = _MX27_BUILD_PIN(4, 19),
	MX27_PIN_SD1_D2 = _MX27_BUILD_PIN(4, 20),
	MX27_PIN_SD1_D3 = _MX27_BUILD_PIN(4, 21),
	MX27_PIN_SD1_CMD = _MX27_BUILD_PIN(4, 22),
	MX27_PIN_SD1_CLK = _MX27_BUILD_PIN(4, 23),
	MX27_PIN_USBOTG_CLK = _MX27_BUILD_PIN(4, 24),
	MX27_PIN_USBOTG_DATA7 = _MX27_BUILD_PIN(4, 25),

	MX27_PIN_NFRB = _MX27_BUILD_PIN(5, 0),
	MX27_PIN_NFCLE = _MX27_BUILD_PIN(5, 1),
	MX27_PIN_NFWP_B = _MX27_BUILD_PIN(5, 2),
	MX27_PIN_NFCE_B = _MX27_BUILD_PIN(5, 3),
	MX27_PIN_NFALE = _MX27_BUILD_PIN(5, 4),
	MX27_PIN_NFRE_B = _MX27_BUILD_PIN(5, 5),
	MX27_PIN_NFWE_B = _MX27_BUILD_PIN(5, 6),
	MX27_PIN_PC_POE = _MX27_BUILD_PIN(5, 7),
	MX27_PIN_PC_RW_B = _MX27_BUILD_PIN(5, 8),
	MX27_PIN_IOIS16 = _MX27_BUILD_PIN(5, 9),
	MX27_PIN_PC_RST = _MX27_BUILD_PIN(5, 10),
	MX27_PIN_PC_BVD2 = _MX27_BUILD_PIN(5, 11),
	MX27_PIN_PC_BVD1 = _MX27_BUILD_PIN(5, 12),
	MX27_PIN_PC_VS2 = _MX27_BUILD_PIN(5, 13),
	MX27_PIN_PC_VS1 = _MX27_BUILD_PIN(5, 14),
	MX27_PIN_CLKO = _MX27_BUILD_PIN(5, 15),
	MX27_PIN_PC_PWRON = _MX27_BUILD_PIN(5, 16),
	MX27_PIN_PC_READY = _MX27_BUILD_PIN(5, 17),
	MX27_PIN_PC_WAIT_B = _MX27_BUILD_PIN(5, 18),
	MX27_PIN_PC_CD2_B = _MX27_BUILD_PIN(5, 19),
	MX27_PIN_PC_CD1_B = _MX27_BUILD_PIN(5, 20),
	MX27_PIN_CS4_B = _MX27_BUILD_PIN(5, 21),
	MX27_PIN_CS5_B = _MX27_BUILD_PIN(5, 22),
	MX27_PIN_ATA_DATA15 = _MX27_BUILD_PIN(5, 23),
};

#endif				/* __ASSEMBLY__ */
#endif				/* __ASM_ARCH_MXC_MX27_PINS_H__ */
