# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import gtk
import gobject

import stock


class ActionManagerWrapper(gobject.GObject):
    __gsignals__ = {
        "action-added" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_STRING,)),
        "action-removed" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_STRING,))
    }
    def __init__(self):
        super(ActionManagerWrapper,self).__init__()
        self.__actions = {}

    def register_action(self, id, position, types, widget, pack_end=False):
        self.__actions[id] = (position, types, widget, pack_end)
        self.emit("action-added",id)

    def unregister_action(self,id):
        del self.__actions[id]
        self.emit("action-removed",id)

    def get_action(self,id,song):
        try: action = self.__actions[id]
        except KeyError: return None
        position, types, stock, pack_end = action
        if not types or song.get_type() in types:
            return action
        return None

    def get_actions(self,song):
        match_actions = []
        actions = self.__actions.values()
        actions.sort()
        for action in actions:
            position, types, widget, pack_end = action
            if not types or (song and song.get_type() in types):
                match_actions.append(action)
        return match_actions
        
ActionManager = ActionManagerWrapper()
