# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

from helper import Dispatcher

from plugins import Manager, Plugin
from xdg_support import get_xdg_lib_dirs

class GenericPlugin(Plugin):
    pass

class GenericManager(Manager):
    activable = True
    Kinds =  [ GenericPlugin ]

    plug_instances = {}
    def __init__(self):
        super(GenericManager,self).__init__(  get_xdg_lib_dirs("plugins/generic"), "Generic plugins")
        self.scan()
        fails = self.list_failures()
        if fails: 
            print "E:Generic Plugins preload failed"
            for name,error in fails.iteritems():
                print " : ",name,":",error
            print "-:------------------------------"
    
    def enable(self,plug,enable,emit=True):
        if not enable and self.enabled(plug):
            self.plug_instances[plug].destroy()
            del self.plug_instances[plug]
        elif enable and not self.enabled(plug):
            self.plug_instances[plug] = plug()

        super(GenericManager,self).enable(plug,enable,emit)

