# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###
# Huge based from osd.py from Quodlibet (C) 2005 Ton van den Heuvel, Joe Wreshnig
#                                (C) 2004 Gustavo J. A. M. Carneiro
###
import pango
import gtk
import gtk.gdk as gdk
import gobject
import re
import utils

from config import config

from player import Player
from cover_manager import CoverManager

class Osd(object):

    BORDER = 4
    __sid = None
    __window = None
    __cover = None
    __startDragPosition = None
    __width = 0
    __id_destroy_cb = None

    def Frame(self,label=None, border=0, bold=False, child=None):
        if isinstance(label, basestring):
            format = "%s"
            if bold: format  = "<b>%s</b>" % format
            markup = utils.xmlescape(label)
            markup = format % markup
            label = gtk.Label()
            label.set_markup(markup)
            label.set_use_underline(True)

        frame = gtk.Frame()
        frame.set_border_width(border)
        align = gtk.Alignment(xalign=0.0, yalign=0.0, xscale=1.0, yscale=1.0)
        align.set_padding(3, 0, 12, 0)
        frame.add(align)
        if child: align.add(child)
        frame.set_shadow_type(gtk.SHADOW_NONE)
        frame.set_label_widget(label)
        return frame

    def PluginPreferences(self, parent=None):
        w = gtk.VBox()
        w.set_border_width(6)
        """w.set_title(_("OSD Preferences"))
        w.set_resizable(False)
        w.set_position(gtk.WIN_POS_CENTER_ON_PARENT)
        w.set_border_width(12)
        w.add(gtk.VBox(spacing=12))
        """

        def Label(t): l = gtk.Label(t); l.set_alignment(0.0, 0.5); return l

        colors = config.get("osd", "osd_colors").split()

        # Font and colour options.
        fc_box = gtk.VBox(spacing = 6)

        self.__textColorAButton = gtk.ColorButton(gtk.gdk.color_parse(colors[0]))
        self.__textColorBButton = gtk.ColorButton(gtk.gdk.color_parse(colors[1]))
        self.__panelBorderColorButton = gtk.ColorButton(gtk.gdk.color_parse(colors[2]))
        self.__panelColorButton = gtk.ColorButton(gtk.gdk.color_parse(colors[3]))
        self.__panelColorButton.set_use_alpha(True)
        self.__textColorAButton.connect('color-set', self.__color_set)
        self.__textColorBButton.connect('color-set', self.__color_set)
        self.__panelBorderColorButton.connect('color-set', self.__color_set)
        self.__panelColorButton.connect('color-set', self.__color_set)

        alpha = int(float(config.get('osd', 'osd_transparency')) / 256 * 65535)
        self.__panelColorButton.set_alpha(alpha)

        t = gtk.Table(2, 4)
        t.set_col_spacings(6)
        t.set_row_spacings(6)
        t.attach(Label(_("Text color #1:")), 0, 1, 0, 1)
        t.attach(Label(_("Text color #2:")), 0, 1, 1, 2)
        t.attach(Label(_("Panel color:")), 2, 3, 0, 1)
        t.attach(Label(_("Panel border color:")), 2, 3, 1, 2)
        t.attach(self.__textColorAButton, 1, 2, 0, 1, gtk.SHRINK)
        t.attach(self.__textColorBButton, 1, 2, 1, 2, gtk.SHRINK)
        t.attach(self.__panelColorButton, 3, 4, 0, 1, gtk.SHRINK)
        t.attach(self.__panelBorderColorButton, 3, 4, 1, 2, gtk.SHRINK)

        font = gtk.FontButton(config.get("osd", "osd_font"))
        font.set_size_request(200, -1)
        font.connect('font-set', self.__font_set)

        fc_box.pack_start(t, expand = False)
        fc_box.pack_start(font, expand = False)

        # Positioning options.
        pos_box = gtk.HBox(spacing = 6)

        __cb_center_y = gtk.CheckButton(_('Center vertically'))
        __cb_center_y.set_active(config.get("osd", "osd_center_y") == "1")
        __cb_center_y.connect('toggled', self.__centering_toggled)
        __cb_center_y.set_name("y")

        __cb_center_x = gtk.CheckButton(_('Center horizontally'))
        __cb_center_x.set_active(config.get("osd", "osd_center_x") == "1")
        __cb_center_x.connect('toggled', self.__centering_toggled)
        __cb_center_x.set_name("x")

        pos_box.pack_start(__cb_center_x, expand = False)
        pos_box.pack_start(__cb_center_y, expand = False)

        # Miscellaneous options.
        misc_box = gtk.HBox(spacing = 6)

        timeout = gtk.SpinButton(gtk.Adjustment(float(config.get('osd', 'osd_timeout')), 0, 60.0, 0.1, 1.0, 0), 0.1, 1)
        timeout.set_numeric(True)
        timeout.connect('value-changed', self.__timeout_changed);

        misc_box.pack_start(Label(_("Display delay: ")), expand = False)
        misc_box.pack_start(timeout, expand = False);
        misc_box.pack_start(Label(_("seconds")), expand = False)

        check_osd = gtk.CheckButton(_("Enable osd"))
        if config.get("osd","enable")=="true":
            check_osd.set_property("active",True)
        check_osd.connect("toggled",self.__use_trayicon)

        check_noti = gtk.CheckButton(_("Enable notification"))
        if config.get("setting","notification")=="true":
            check_noti.set_property("active",True)
        check_noti.connect("toggled",self.__use_notification)


        b = gtk.VBox()
        if parent.notify.dbus_notify:
            b.pack_start(check_noti,False,False)
        b.pack_start(check_osd,False,False)

        general_frame = self.Frame(_("General"), bold = True, child = b);

        color_frame = self.Frame(_("Font & colors"), bold = True, child = fc_box);
        positioning_frame = self.Frame(_("Positioning"), bold = True, child = pos_box);
        misc_frame = self.Frame(_("Miscellaneous"), bold = True, child = misc_box);

        """w.child.pack_start(general_frame)
        w.child.pack_start(color_frame)
        w.child.pack_start(positioning_frame)
        w.child.pack_start(misc_frame)
        w.child.show_all()"""
        w.pack_start(general_frame)
        w.pack_start(color_frame)
        w.pack_start(positioning_frame)
        w.pack_start(misc_frame)
        #w.show_all()

        #w.set_transient_for(parent)
        #w.connect('delete-event', self.__hide_preferences)
        #w.connect('show', self.__show_panel)

        return w

    def __centering_toggled(self, togglebutton):
        if togglebutton.get_active():
            status = "1"
        else:
            status = "0"

        if togglebutton.get_name() == "y":
            config.set('osd', 'osd_center_y', status)
        else:
            config.set('osd', 'osd_center_x', status)

        self.__show_panel()

    def __use_trayicon(self,togglebutton):
        if togglebutton.get_active():
            status = "true"
        else:
            status = "false"
        config.set('osd', 'enable', status)
        
    def __use_notification(self,togglebutton):
        if togglebutton.get_active():
            status = "true"
        else:
            status = "false"
        config.set('setting', 'notification', status)

    def pref_show_panel(self, widget = None):
        self.__show_panel(widget)

    def __show_panel(self, widget = None):
        if self.__sid:
            gobject.source_remove(self.__sid)
            self.__sid = None

        self.__display(self.__get_preview_msg(), True)

    def pref_hide_panel(self, widget = None):
        config.set("osd", "osd_custom_position", "%d %d" %(self.__custom_position[0], self.__custom_position[1]))
        gobject.idle_add(self.__hide_panel)
        return True

    def __hide_preferences(self, prefs, event):
        config.set("osd", "osd_custom_position", "%d %d" %(self.__custom_position[0], self.__custom_position[1]))
        prefs.hide_all()
        gobject.idle_add(self.__hide_panel)
        return True

    def __timeout_changed(self, spinbutton):
        config.set("osd", "osd_timeout", spinbutton.get_value())

    def __font_set(self, font):
        config.set("osd", "osd_font", font.get_font_name())
        self.__show_panel()

    def __get_preview_msg(self):
        otherTextColor = config.get('osd', 'osd_colors').split()[1]
        msg = "<span foreground='%s'>\xe2\x99\xaa</span> "%otherTextColor
        msg += _("Drag to position")+" <span foreground='%s'>\xe2\x99\xaa</span>" % otherTextColor
        msg = "<message id='quodlibet'>%s</message>" % msg
        return msg

    def __color_set(self, color):
        colors = []
        for colorButton in [self.__textColorAButton, self.__textColorBButton, self.__panelBorderColorButton, self.__panelColorButton]:
            color = colorButton.get_color()
            colors.append("#%02x%02x%02x" % (color.red // 256, color.green // 256, color.blue // 256))

            # Write panel border transparency.
            if colorButton.get_use_alpha():
                config.set('osd', 'osd_transparency', str(colorButton.get_alpha() // 256))

        config.set('osd', 'osd_colors', ' '.join(colors))

        # Refresh OSD panel.
        self.__show_panel()

    def __dragging(self, widget, event):
        widget.move(int(event.x_root - self.__startDragPosition[0]), int(event.y_root - self.__startDragPosition[1]))

    def __start_dragging(self, widget, event):
        self.__startDragPosition = event.x, event.y
        self.__motionHandler = self.__window.connect('motion_notify_event', self.__dragging)

    def __end_dragging(self, widget, event):
        self.__window.disconnect(self.__motionHandler)
        self.__custom_position = self.__window.get_position()

        # Refresh OSD panel.
        self.__show_panel()

    def __init__(self,tray):
        Player.connect("instant-new-song",lambda player,song: self.show_osd(song))
        tray.eventbox.connect("enter-notify-event", self.on_mouse_over)
        tray.eventbox.connect("leave-notify-event", self.on_mouse_out)
            
        self.first_time=True
        for key, value in {
            "custom_position": "-1 -1",
            "colors": "#ffbb00 #ff8800 #000000 #303030",
            "font": "Sans 22",
            "timeout": "7.5",
            "transparency": "75",
            "center_x": "1",
            "center_y": "0"}.items():
            try: config.get("osd", "osd_" + key)
            except: config.set("osd", "osd_" + key, value)

        color_str = config.get("osd", "osd_colors")
        for i in [len(config.get("osd", "osd_colors").split()),4]:
            if len(config.get("osd", "osd_colors").split()) < 4:
                color_str += " #000000"

        config.set("osd", "osd_colors", color_str)

        self.__custom_position = map(int, config.get("osd", "osd_custom_position").split())
        
        self.__id_tray = None
        
    def on_mouse_over(self,*args): 
        self.__id_tray = gobject.timeout_add(1000,self.show_mouse_over)
            
    def show_mouse_over(self):
        if config.get("osd","enable")=="false" or Player.song is None: return
        self.show_osd(Player.song)
        
    def on_mouse_out(self,*args):
        self.hide_osd()
        if self.__id_tray:
            try:gobject.source_remove(self.__id_tray)
            except:pass
            self.__id_tray==None
        
    def show_osd(self, song,top=None,left=None):
        if config.get("osd","enable")=="false" or song is None: return
        if not song.get("#duration"): return

        cover = CoverManager.get_cover(song, False)
        if cover.find("listen_cover.png")==-1:
            self.__cover = cover
        else:
            self.__cover = None

        color2 = config.get("osd", "osd_colors").split()[1]

        msg = "\xe2\x99\xaa " #musik note
        msg += "<span foreground='%s' style='italic'>%s</span>" %(color2, song.get_str("title",True))
        msg += " <span size='small'>(%s)</span> " % song.get_str("#duration",True)
        msg += "\xe2\x99\xaa\n"

        msg += "<span size='x-small'>"
        if song.get("#track"):
            msg += ("<span foreground='%s' size='xx-small' "
                        "style='italic'>")% color2
            msg += _("track")+":</span> "+song.get_str("#track",True)+"   "

        if song.get("artist"):
            msg += ("<span foreground='%s' size='xx-small' "
                    "style='italic'>%s:</span> %s   "%(
                (color2, _("artist"), song.get_str("artist",True))))

        if song.get("album"):
            msg += ("<span foreground='%s' size='xx-small' "
                    "style='italic'>%s:</span> %s   "%(
                (color2, _("album"), song.get_str("album",True))))

        msg += "</span>"
        msg = msg.strip()

        if isinstance(msg, unicode):
            msg = msg.encode("utf-8")
        msg = "<message id='listen'>%s</message>" % msg
        #print "OSD : " +msg
        #gobject.idle_add(self.__display,msg)
        self.__display(msg)


    def __panel_destroy_callback(self, msg, is_preview, bgcolor):
        self.__window = None
        self.__id_destroy_cb=None
        self.__display(msg, is_preview, bgcolor)

    def hide_osd(self, song=None, stopped=None):
        if self.__window:
            self.__window.destroy()
            self.__window = None
        if self.__sid:
            gobject.source_remove(self.__sid)
            self.__sid = None


    def __display(self, msg, is_preview = False, bgcolor = "black",top=None,left=None):
        text = msg[msg.index(">")+1:msg.rindex("<")]
        #text = msg
        #On detrui la precedente
        if self.__sid:
            gobject.source_remove(self.__sid)
            self.__sid = None

        if self.__id_destroy_cb!=None:
            gobject.source_remove(self.__id_destroy_cb)
            self.__id_destroy_cb=None

        """if self.__window:
            self.__window.destroy()
            self.__window = None"""

        if self.__window:
            self.__window.destroy()
            # We need to be sure that the panel is removed for the transparency effect to work. Therefore,
            # be sure to give the window manager enough time to remove the window.
            self.__id_destroy_cb = gobject.timeout_add(500,self.__panel_destroy_callback, msg, is_preview, bgcolor)
            return

        fgcolor = config.get('osd', 'osd_colors').split()[0]
        panelBorderColor = config.get('osd', 'osd_colors').split()[2]
        panelColor = config.get('osd', 'osd_colors').split()[3]
        center_x = config.get('osd', 'osd_center_x') == "1"
        center_y = config.get('osd', 'osd_center_y') == "1"

        try:
            fontdesc = pango.FontDescription(config.get("osd", "osd_font"))
        except: fontdesc = pango.FontDescription("Sans 22")

        win = gtk.Window(gtk.WINDOW_POPUP)
        win.add_events(gtk.gdk.POINTER_MOTION_MASK)
        win.add_events(gtk.gdk.BUTTON_PRESS_MASK)
        win.add_events(gtk.gdk.BUTTON_RELEASE_MASK)

        darea = gtk.DrawingArea()
        win.add(darea)
        darea.show()

        # Generate shadow text from colored markup text.
        p = re.compile('#[0-9a-zA-Z]{6}')
        shadow_text = p.sub('#000000', text)

        layout = win.create_pango_layout('')
        layout.set_markup(shadow_text)
        layout.set_justify(False)
        layout.set_alignment(pango.ALIGN_CENTER)
        layout.set_font_description(fontdesc)

        monitor = gdk.Screen.get_monitor_geometry(gdk.screen_get_default(), 0)
        MAX_WIDTH = monitor.width - 8
        layout.set_width(pango.SCALE*MAX_WIDTH)
        layout.set_wrap(pango.WRAP_WORD)

        # Initialize width and height with the size of the pango layout.
        self.__width, height = layout.get_pixel_size()

        # Calculate final panel height by adding a border.
        height += self.BORDER * 4

        # Calculate the cover dimensions (if one is available)
        draw_cover = not self.__cover is None and not is_preview
        if draw_cover:
            cover_dim = height - 2 * self.BORDER
        else:
            cover_dim = 0

        # Calculate text offsets.
        off_x = self.BORDER * 4 + cover_dim + self.__width / 2 - MAX_WIDTH / 2
        off_y = self.BORDER * 2

        # Calculate panel width.
        self.__width += self.BORDER * 6 + cover_dim

        darea.set_size_request(self.__width, height)
        darea.realize()

        # Draw the surrounding panel.
        pixmap = gtk.gdk.Pixmap(darea.window, self.__width, height)
        bg_gc = gdk.GC(pixmap)
        bg_gc.copy(darea.style.fg_gc[gtk.STATE_NORMAL])
        bg_gc.set_colormap(darea.window.get_colormap())

        win.width = self.__width
        win.height = height

        # Draw contents.
        panelBgColor = '#%02x%02x%02x' % (int(panelColor[1:3], 16), int(panelColor[3:5], 16),  int(panelColor[5:7], 16))

        bg_gc.set_foreground(darea.get_colormap().alloc_color(panelBgColor))
        pixmap.draw_rectangle(bg_gc, True, 1, 1, self.__width - 2, height - 2)

        #
        # Get root window contents at panel position.
        #
        if self.__custom_position[0] == -1:
            # Initially, position the OSD at the bottom
            # at_bottom = config.getboolean("osd", "osd_position")
            # position = (at_bottom and gdk.screen_height() - win.height - 48) or 5
            position = gdk.screen_height() - win.height - 48
            winX = monitor.x + monitor.width / 2 - win.width / 2
            winY = monitor.y + position
        else:
            if center_x:
                winX = monitor.x + monitor.width / 2 - win.width / 2
            else:
                winX = self.__custom_position[0]

            if center_y:
                winY = monitor.y + monitor.height / 2 - win.height / 2
            else:
                winY = self.__custom_position[1]

        #Si on la position a la main
        if top!=None:
            winY=top
        if left!=None:
            winX=left

        # Transparency is not enabled in preview mode.
        root_win = gdk.Screen.get_root_window(gdk.screen_get_default())
        root_pb = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, 0, 8, self.__width, height)
        root_pb.get_from_drawable(root_win, root_win.get_colormap(), winX, winY, 0, 0, self.__width, height)

        # Composite panel pixbuf with root pixbuf
        compositedPixBuf = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, 0, 8, self.__width, height)
        compositedPixBuf.get_from_drawable(pixmap, pixmap.get_colormap(), 0, 0, 0, 0, self.__width, height)
        alpha = int(config.get('osd', 'osd_transparency'))
        compositedPixBuf.composite(root_pb, 0, 0, self.__width, height, 0, 0, 1, 1, gtk.gdk.INTERP_BILINEAR, alpha)
        pixmap.draw_pixbuf(darea.style.fg_gc[gtk.STATE_NORMAL], root_pb, 0, 0, 0, 0, -1, -1)

        # Draw panel border.
        bg_gc.set_foreground(darea.get_colormap().alloc_color(panelBorderColor))
        pixmap.draw_rectangle(bg_gc, False, 0, 0, self.__width - 1, height - 1)

        # Draw layout.
        fg_gc = gdk.GC(pixmap)
        fg_gc.copy(darea.style.fg_gc[gtk.STATE_NORMAL])
        fg_gc.set_colormap(darea.window.get_colormap())
        fg_gc.set_foreground(darea.get_colormap().alloc_color("black"))

        # Draw shadow.
        pixmap.draw_layout(fg_gc, off_x + 1, off_y + 1, layout)

        # Draw actual text.
        fg_gc.set_foreground(darea.get_colormap().alloc_color(fgcolor))
        layout.set_markup(text)
        pixmap.draw_layout(fg_gc, off_x, off_y, layout)

        # Draw the cover image (if available).
        if not self.__cover is None and not is_preview:

                try:
                    cover = gtk.gdk.pixbuf_new_from_file_at_size(self.__cover, cover_dim, cover_dim)
                except:
                    self.__cover = None
                else:

                    #cover = self.__cover
                    left = self.BORDER + (cover_dim - cover.get_width())/2
                    top = self.BORDER + (cover_dim - cover.get_height())/2
                    pixmap.draw_pixbuf(darea.style.fg_gc[gtk.STATE_NORMAL], cover, 0, 0, left, top)
                    # Draw a border around the cover image.
                    bg_gc.set_foreground(darea.get_colormap().alloc_color("black"))
                    pixmap.draw_rectangle( bg_gc, False, left - 1, top - 1, cover.get_width() + 1, cover.get_height() + 1)

        darea.window.set_back_pixmap(pixmap, False)

        #gobject.idle_add(win.move, winX, winY)
        win.move(winX, winY)
        #gobject.idle_add(win.show_all)
        self.__window = win

        if not is_preview:
            # An active OSD window is closed after a user-specified time.
            timeout = config.get('osd', 'osd_timeout')
            if timeout > 0:
                self.__sid = gobject.timeout_add(int(float(timeout) * 1000), self.__hide_panel)
            # And it can be closed by clicking it.
            win.connect('button-press-event', self.__hide_panel)
        # A preview OSD can be dragged around.
        else:
            win.connect('button-press-event', self.__start_dragging)
            win.connect('button-release-event', self.__end_dragging)
        win.show_all()

    def __hide_panel(self, window=None, event=None):
        if self.__window:
            self.__window.destroy()
            self.__window = None
        if self.__sid:
            gobject.source_remove(self.__sid)
            self.__sid = None

