# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import os

import gtk
import gobject

from config import config
import utils

from xdg_support import get_xdg_pixmap_file
from player import Player
from widget.misc import set_tip
from helper import Dispatcher

if os.environ.get("LISTEN_NO_TRAY",0) == 0:
    try: 
        from widget.gtktrayicon import TrayIcon as Tray
    except: 
        try:
            from  egg.trayicon import TrayIcon as Tray
        except: 
            Tray = None
else:
    Tray = None

class TrayIcon(gobject.GObject):
    def __init__(self,window):
        super(TrayIcon,self).__init__()

        self.win = window
        Player.connect("played",self.on_play)
        Player.connect("paused",self.on_pause)
        Player.connect("stopped",self.on_pause)

        self.eventbox = gtk.EventBox()

        self.tray = None
        if Tray:
            self.tray = Tray("Listen")
            self.tray.add(self.eventbox)


        self.eventbox.connect("button_press_event", self.on_button_press_event )
        self.eventbox.connect("scroll-event",self.on_scroll_event)
        
        self.tray_image = gtk.Image()
        self.tray_image.set_from_file( get_xdg_pixmap_file("listen_tray.png") )
        self.eventbox.add(self.tray_image)
        
        menu_ui = """
        <ui>
            <popup name="TrayIconMenu">
              <menuitem name="play" action="play"/>
              <menuitem name="pause" action="pause"/>
              <menuitem name="next" action="next"/>
              <menuitem name="previous" action="previous"/>
              <separator/>
              <menuitem name="quit" action="quit"/>
            </popup>
        </ui>
        """
        #<menuitem name="stop" action="stop"/>
        self.uimanager = gtk.UIManager()
        self.uimanager.add_ui_from_string(menu_ui)

        actiongroup = gtk.ActionGroup('Listen')
        actiongroup.add_actions([('play', gtk.STOCK_MEDIA_PLAY, _('_Play'), None, _('Play'), self.player_control),
                                 ('pause', gtk.STOCK_MEDIA_PAUSE, _('_Pause'), None, _('Pause'), self.player_control),
                                 ('stop', gtk.STOCK_MEDIA_STOP, _('Stop'), None, _('Stop'), self.player_control),
                                 ('next', gtk.STOCK_MEDIA_NEXT, _('_Next'), None, _('Next'), self.player_control),
                                 ('previous', gtk.STOCK_MEDIA_PREVIOUS, _('_Previous'), None, _('Previous'),self.player_control),
                                 ('quit', gtk.STOCK_QUIT, _('_Quit'), None, _('Quit Listen'), lambda w:Dispatcher.quit()) 
                                ])

        self.uimanager.insert_action_group(actiongroup, 1)
        #self.add_accel_group(accelgroup)
        self.pause = self.uimanager.get_action("/TrayIconMenu/pause")
        self.pause.set_visible(False)
        self.play =  self.uimanager.get_action("/TrayIconMenu/play")
        self.menu = self.uimanager.get_widget("/TrayIconMenu")
        self.menu.connect("selection-done",self.on_selection_done)
        self.show_menu=False
        
        
        
        gtk.quit_add(0,self.cacher)
    
    def player_control(self,action):
        name = action.get_name()
        if name in [ "play", "pause" ]:
            name = "playpause"
        getattr(Player, name)()

    def on_delete(self,win,event):
        pass

    def update_tooltips(self):
        if config.get("osd","enable")=="false":
            s = Player.song
            if s:
                text = ""            
                text += s.get_str("title")
                if s.get("artist"):
                    text += " - "+s.get("artist")
                text += "\n"
                if Player.is_paused():
                    text += _("Paused")+", "
                value = Player.get_position()
                text += utils.duration_to_string(value,"00:00")+" "+_("of")+" "+utils.duration_to_string(s.get("#duration"),"00:00")
            else:
                text = _("No Playing")
        else:
            text = None
        set_tip(self.eventbox,text)
        return True

    def on_scroll_event(self,widget,event):
        self.win.menubar.vol.emit("scroll-event",event)

    def on_selection_done(self,widget):
        self.show_menu=False

    def on_pause(self,player):
        self.pause.set_visible(False)
        self.play.set_visible(True)

    def on_play(self,player):
        self.pause.set_visible(True)
        self.play.set_visible(False)
        
    def position_menu(self,menu):
        #Grab from deskbar applet
        align_to = self.eventbox
        direction = self.eventbox.get_direction()

        screen = menu.get_screen()
        monitor_num = screen.get_monitor_at_window(align_to.window)
        if monitor_num < 0:
                monitor_num = 0

        monitor = screen.get_monitor_geometry (monitor_num)
        menu.set_monitor (monitor_num)

        tx, ty = align_to.window.get_origin()
        twidth, theight = menu.get_child_requisition()

        tx += align_to.allocation.x
        ty += align_to.allocation.y
        if direction == gtk.TEXT_DIR_RTL:
                tx += align_to.allocation.width - twidth

        if (ty + align_to.allocation.height + theight) <= monitor.y + monitor.height:
                ty += align_to.allocation.height
        elif (ty - theight) >= monitor.y:
                ty -= theight
        elif monitor.y + monitor.height - (ty + align_to.allocation.height) > ty:
                ty += align_to.allocation.height
        else:
                ty -= theight

        if tx < monitor.x:
                x = monitor.x
        elif tx > max(monitor.x, monitor.x + monitor.width - twidth):
                x = max(monitor.x, monitor.x + monitor.width - twidth)
        else:
                x = tx
        y = ty

        return (x, y, False)

    def on_button_press_event(self , widget, event):
        if event.button == 1:
            if event.state == gtk.gdk.CONTROL_MASK:
                Player.previous()
            else:
                if self.win.get_property('visible'):
                    if self.win.is_active():
                        self.cacher()
                    else:
                        self.win.present()
                else:
                    self.montrer()

        elif event.button == 2:
            Player.playpause()

        elif event.button == 3:
            if event.state == gtk.gdk.CONTROL_MASK:
                Player.next()
            else:
                self.show_menu=True
                #Player.osd.hide_osd(None,None)
                self.menu.popup(None,None,self.position_menu,event.button,event.time)


    def cacher(self):
        if self.win.window:
            event = self.win.window.get_state()
            if event == gtk.gdk.WINDOW_STATE_MAXIMIZED:
                config.set("window","state","maximized")
            else:
                config.set("window","state","normal")
            self.win.hide_all()

    def montrer(self):
        self.win.move(int(config.get("window","x")),int(config.get("window","y")))
        window_state = config.get("window","state")
        if window_state == "maximized" :
            self.win.maximize()
        if window_state == "normal":
            self.win.unmaximize()
        self.win.show_all()

