
 /************************************************************************
  * Copyright 2005-2006 by Freescale Semiconductor, Inc.
  * All modifications are confidential and proprietary information
  * of Freescale Semiconductor, Inc. ALL RIGHTS RESERVED.
  ************************************************************************/

//+-------------------------------------------------------------------------
//
//  Microsoft Windows Media
//
//  Copyright (C) Microsoft Corporation, 1999 - 1999
//
//  File:       wmf.h
//
//--------------------------------------------------------------------------

#ifndef WMF_H
#define WMF_H

#ifdef __cplusplus
extern "C" {
#endif

#include "wmferr.h"
#include "wmfdecode.h"

/****************************************************************************/
#if( !defined(_MSC_VER) && !defined(__stdcall) )
#define __stdcall
#endif

#ifndef WMAAPI
#ifndef x86
#define WMAAPI  __stdcall
#else
#define WMAAPI
#endif
#endif

#define STREAMVIDEO 0x0002
#define STREAMAUDIO 0x0001
#define LARGEBUFFER 0x8000

typedef struct tPacketList
{
//	I8_WMF				cBuff[LARGEBUFFER];
	I8_WMF				*pBuff;
	I32_WMF					cbUsed;
	I32_WMF					cbFinished;
	I32_WMF					cbFrame;
	struct tPacketList	*Next;
}PacketList;

typedef struct tAudioPacketList
{
	I8_WMF					*pBuff;
	I32_WMF						cbUsed;
	I32_WMF						cbFinished;
	struct tAudioPacketList	*Next;
}AudioPacketList;


//#ifndef _HANDLEWMAV
//#define _HANDLEWMAV
//typedef void * HWMAVINFO;
//typedef void * HWMFDECODER;
//#endif

/*
 *        WMFGetHeaderSize
 *        ================
 *
 * Description
 * -----------
 * Retrieves the size of the ASF size.  The size should be passed to
 * other functions requiring cbHeader.
 *
 * Syntax
 * ------
 *   WMAERR WMAAPI WMFGetHeaderSize(const U8_WMF *pbHeader,
 *                                  U32_WMF cbHeader,
 *                                  U32_WMF *pcbHeader);
 *
 * where:
 *
 *   pbHeader       the pointer to the buffer holding the ASF header
 *   cbHeader       the valid size of the buffer that pbHeader
 *                  points to
 *   pcbHeader      the pointer to hold the actual header size
 *                  returned.
 *
 * Return Value
 * ------------
 *   WMAERR_OK                 retrieved okay
 *   WMAERR_INVALIDARG         invalid pointers
 *   WMAERR_BUFFERTOOSMALL     cbHeader is too small to determin the
 *                             header size
 *   WMAERR_INVALIDHEADER      corrupted header
 *
 */
WMAERR WMAAPI WMFGetHeaderSize (const U8_WMF *pbHeader, U32_WMF cbHeader, U32_WMF *pcbHeader);


/*
 *        WMFOpenDecoder
 *        ==============
 *
 * Description
 * -----------
 * Open the WMA decoder.
 *
 * Syntax
 * ------
 *   WMAERR WMAAPI WMFOpenDecoder(const U8_WMF *pbHeader,
 *                                U32_WMF cbHeader,
 *                                HWMFDECODER *phDecoder);
 *
 * where:
 *
 *   pbHeader       the pointer to the buffer holding the ASF header
 *   cbHeader       the size of the ASF header from WMFGetHeaderSize
 *   phDecoder      the pointer to hold the returned handle
 *
 * Return Value
 * ------------
 *   WMAERR_OK                 opened okay
 *   WMAERR_FAIL               failed to open the decoder
 *   WMAERR_INVALIDARG         invalid pointers
 *   WMAERR_BUFFERTOOSMALL     cbHeader is too small to determin the
 *                             header size
 *   WMAERR_INVALIDHEADER      corrupted header
 *   WMAERR_OUTOFMEMORY        cannot allocate internal structure
 *
 */
#ifdef _ZMDRM_
WMAERR WMAAPI WMFOpenDecoder(const U8_WMF *pbHeader, U32_WMF cbHeader, HWMFDECODER phDecoder, HDRMMGR *hDRM, U8_WMF *pAppCert, U32_WMF Rights, const U8_WMF* pbHwId, U32_WMF cbHwId);
#else
WMAERR WMAAPI WMFOpenDecoder(const U8_WMF *pbHeader, U32_WMF cbHeader, HWMFDECODER phDecoder);
#endif


/*
 *        WMFCloseDecoder
 *        ===============
 *
 * Description
 * -----------
 * Close a WMA decoder instance.
 *
 * Syntax
 * ------
 *   WMAERR WMAAPI WMFCloseDecoder(HWMFDECODER hDecoder);
 *
 * where:
 *
 *   hDecoder       the handle to the WMA instance
 *
 * Return Value
 * ------------
 *   WMAERR_OK                 closed okay
 *   WMAERR_INVALIDARG         invalid handle
 *
 */
WMAERR WMAAPI WMFCloseDecoder(HWMFDECODER hDecoder);


/*
 *        WMFDecDuration
 *        ==============
 *
 * Description
 * -----------
 * Retrieve the length of the WMA file in milliseconds.
 *
 * Syntax
 * ------
 *   WMAERR WMAAPI WMFDecDuration(HWMFDECODER hDecoder,
 *                                U32_WMF *pmsDuration);
 *
 * where:
 *
 *   hDecoder       the handle from WMFOpenDecoder
 *   pmsDuration    the pointer to retrieve the duration
 *
 * Return Value
 * ------------
 *   WMAERR_OK                 retreived okay
 *   WMAERR_INVALIDARG         invalid handle
 *
 */
WMAERR WMAAPI WMFDecDuration(HWMFDECODER hDecoder,
                             U32_WMF *pmsDuration);


/*
 *        WMFDecPacketSize
 *        ================
 *
 * Description
 * -----------
 * Retrieve the size of an ASF packet in bytes.
 *
 * Syntax
 * ------
 *   WMAERR WMAAPI WMFDecPacketSize(HWMFDECODER hDecoder,
 *                                  U32_WMF *pcbPacketSize);
 *
 * where:
 *
 *   hDecoder       the handle from WMFOpenDecoder
 *   pcbPacketSize  the pointer to retrieve the packet size
 *
 * Return Value
 * ------------
 *   WMAERR_OK                 retreived okay
 *   WMAERR_INVALIDARG         invalid handle
 *
 */
WMAERR WMAAPI WMFDecPacketSize(HWMFDECODER hDecoder,
                               U32_WMF *pcbPacketSize);


/*
 *        WMFDecAudioInfo
 *        ===============
 *
 * Description
 * -----------
 * Retrieve the information about the decoded PCM audio
 * output.
 *
 * Syntax
 * ------
 *   WMAERR WMAAPI WMFDecAudioInfo(HWMFDECODER hDecoder,
 *                                 U16_WMF *pnChannels,
 *                                 U32_WMF *pnSamplesPerSec,
 *                                 U32_WMF *pcbMaxAudioSize);
 *
 * where:
 *
 *   hDecoder        the handle from WMFOpenDecoder
 *   pnChannels      the pointer to retrieve the number of
 *                   channels (mono or stereo)
 *   pnSamplesPerSec the pointer to retrieve the sampling
 *                   rate (in Hz or samples per second)
 *   pcbMaxAudioSize the maximum size of PCM output that a
 *                   packet can generate (in bytes)
 *
 * Return Value
 * ------------
 *   WMAERR_OK                 retreived okay
 *   WMAERR_INVALIDARG         invalid handle
 *
 */
WMAERR WMAAPI WMFDecAudioInfo(HWMFDECODER hDecoder,
                              U16_WMF *pnChannels,
                              U32_WMF *pnSamplesPerSec,
                              U32_WMF *pcbMaxAudioSize);


/*
 *        WMFDecLastPacketOffset
 *        ======================
 *
 * Description
 * -----------
 * Retrieve the offset to the beginning of the last ASF
 * packet in the WMA file.
 *
 * Use the returned value to determine if the last packet
 * is being decoded.
 *
 * Syntax
 * ------
 *   WMAERR WMAAPI WMFDecLastPacketOffset(HWMFDECODER hDecoder,
 *                                        U32_WMF *pcbLastPacketOffset);
 *
 * where:
 *
 *   hDecoder             the handle from WMFOpenDecoder
 *   pcbLastPacketOffset  the offset into the beginning of
 *                        the last ASF packet
 *
 * Return Value
 * ------------
 *   WMAERR_OK                 retreived okay
 *   WMAERR_INVALIDARG         invalid handle
 *
 */
WMAERR WMAAPI WMFDecLastPacketOffset(HWMFDECODER hDecoder,
                                     U64_WMF *pcbLastPacketOffset);


/*
 *        WMFDecTimeToOffset
 *        ==================
 *
 * Description
 * -----------
 * Use the millisecond offset to locate the offset to the
 * corresponding packet.
 *
 * Syntax
 * ------
 *   WMAERR WMAAPI WMFDecTimeToOffset(HWMFDECODER hDecoder,
 *                                    U32_WMF msSeek,
 *                                    U64_WMF *pcbPacketOffset);
 *
 * where:
 *
 *   hDecoder         the handle from WMFOpenDecoder
 *   msSeek           the time offset in milliseconds
 *   pcbPacketOffset  the offset into the beginning of the
 *                    corresponding ASF packet
 *
 * Return Value
 * ------------
 *   WMAERR_OK                 retreived okay
 *   WMAERR_INVALIDARG         invalid handle
 *
 */
WMAERR WMAAPI WMFDecTimeToOffset(HWMFDECODER hDecoder,
                                 U32_WMF msSeek,
                                 U64_WMF *pcbPacketOffset);


/*
 *        WMFDecDRM
 *        =========
 *
 * Description
 * -----------
 * Is the content DRM'ed?
 *
 * Syntax
 * ------
 *   WMAERR WMAAPI WMFDecDRM(HWMFDECODER hDecoder,
 *                           U32_WMF *pfDRM);
 *
 * where:
 *
 *   hDecoder         the handle from WMFOpenDecoder
 *   pfDRM            pointer to the flag to indicate whether
 *                    the content is DRM'ed or not
 *
 * Return Value
 * ------------
 *   WMAERR_OK                 retreived okay
 *   WMAERR_INVALIDARG         invalid handle
 *
 */
WMAERR WMAAPI WMFDecDRM(HWMFDECODER hDecoder,
                        U32_WMF *pfDRM);


/*
 *        WMFDecDecodePacket
 *        ==================
 *
 * Description
 * -----------
 * Decode one ASF packet.
 *
 * Syntax
 * ------
 *   WMAERR WMAAPI WMFDecDecodePacket(HWMFDECODER hDecoder,
 *                                    const U8_WMF *pbPacket,
 *                                    U32_WMF cbPacketSize,
 *                                    U8_WMF *pbAudio,
 *                                    U32_WMF cbAudio,
 *                                    U32_WMF *pcbAudioOut,
 *                                    U32_WMF *pmsPresTime);
 *
 * where:
 *
 *   hDecoder       the handle from WMAOpenDecoder
 *   pbPacket       the pointer to the ASF packet to be
 *                  decoded
 *   cbPacketSize   the size of an ASF packet above
 *   pbAudio        the pointer to the buffer to hold PCM
 *                  output
 *   cbAudio        the size of the PCM buffer above
 *   pcbAudioOut    the size of the PCM buffer actually used
 *   pmsPresTime    the pointer to hold the presentation time
 *                  of the packet
 *
 * Return Value
 * ------------
 *   WMAERR_OK                 retreived okay
 *   WMAERR_FAIL               failed to decode
 *   WMAERR_INVALIDARG         invalid handle
 *   WMAERR_BUFFERTOOSMALL     the buffer is too small for a
 *                             packet
 *   WMAERR_CORRUPTDATA        ASF packet is corrupted
 *
 */
/*WMAERR WMAAPI WMFDecDecodePacket(HWMFDECODER hDecoder,
                                 const U8_WMF *pbPacket,
                                 U32_WMF cbPacketSize,
                                 U8_WMF *pbAudio,
                                 U32_WMF cbAudio,
                                 U32_WMF *pcbAudioOut,
                                 U32_WMF *pmsPresTime,
								 WMINITINFO* PacketInfo);

*/
/*
 *        WMFDrmGetLicFileName
 *        ====================
 *
 * Description
 * -----------
 * Get the path to the license filename.
 *
 * Syntax
 * ------
 *   WMAERR WMAAPI WMFDrmGetLicFileName(HWMFDECODER hDecoder,
 *                                      I8_WMF *pszLicFileName,
 *                                      U32_WMF *pdwLicFileName);
 *
 * where:
 *
 *   hDecoder       the handle from WMFOpenDecoder
 *   pszLicFileName the pointer to hold the filename
 *   pdwLicFileName the pointer to hold the length of the filename
 *                  when pszLicFileName is set to NULL, it holds the
 *                  size necessary to hold the filename
 *
 * Return Value
 * ------------
 *   WMAERR_OK                 the filename retreived okay
 *   WMAERR_INVALIDARG         invalid pointers
 *   WMAERR_MOREDATA           the length is retrieved, need to call again
 *                             to get the name
 *   WMAERR_DRMFAIL            the DRM lib failed
 *
 */
WMAERR WMAAPI WMFDrmGetLicFileName(HWMFDECODER hDecoder,
                                   I8_WMF *pszLicFileName,
                                   U32_WMF *pdwLicFileName);


/*
 *        WMFDrmInitLicense
 *        =================
 *
 * Description
 * -----------
 * Initialize the DRM license.
 *
 * Syntax
 * ------
 *   WMAERR WMAAPI WMFDrmInitLicense(HWMFDECODER hDecoder,
 *                                   U8_WMF *pbPMID,
 *                                   U32_WMF dwPMID,
 *                                   U8_WMF *pbLicData,
 *                                   U32_WMF *pdwOffset,
 *                                   U32_WMF *pdwLen);
 *
 * where:
 *
 *   hDecoder       the handle from WMFOpenDecoder
 *   pbPMID         the pointer to a buffer that holds the portable
 *                  media id
 *   dwPMID         the size of the pbPMID buffer
 *   pbLicData      the pointer to the license file buffer
 *   pdwOffset      the pointer to hold the offset into the license
 *                  file, from the beginning
 *   pdwLen         the pointer to hold the length of the pbLicData
 *                  buffer
 *
 * Return Value
 * ------------
 *   WMAERR_OK                 license checked okay
 *   WMAERR_INVALIDARG         invalid pointers
 *   WMAERR_MOREDATA           need to provide next bytes starting
 *                             at *pdwOffset
 *   WMAERR_DRMFAIL            the DRM lib failed
 *
 */
WMAERR WMAAPI WMFDrmInitLicense(HWMFDECODER hDecoder,
                                U8_WMF *pbPMID,
                                U32_WMF dwPMID,
                                U8_WMF *pbLicData,
                                U32_WMF *pdwOffset,
                                U32_WMF *pdwLen);


/*
 *        WMFOpenInfo
 *        ===========
 *
 * Description
 * -----------
 * Retrieve handle to get information, supposedly.  Does nothing
 * in reality.  Should be removed.
 *
 * Syntax
 * ------
 *   WMAERR WMAAPI WMFOpenInfo(const U8_WMF *pbHeader,
 *                             U32_WMF cbHeader,
 *                             HWMAVINFO *phInfo);
 *
 * where:
 *
 *   pbHeader       the pointer to the buffer holding the ASF header
 *   cbHeader       the size of the ASF header from WMAGetHeaderSize
 *   phInfo         the pointer to hold the returned handle
 *
 * Return Value
 * ------------
 *   WMAERR_OK                 always
 *
 */
WMAERR WMAAPI WMFOpenInfo (const U8_WMF *pbHeader, U32_WMF cbHeader);


/*
 *        WMFCloseInfo
 *        ============
 *
 * Description
 * -----------
 * Close the information handle, supposedly.  Does nothing in reality.
 *  Should be removed.
 *
 * Syntax
 * ------
 *   WMAERR WMAAPI WMFCloseInfo(HWMAVINFO hInfo);
 *
 * where:
 *
 *   hInfo          the information handle to be closed
 *
 * Return Value
 * ------------
 *   WMAERR_OK                 always
 *
 */
WMAERR WMAAPI WMFCloseInfo();


WMAERR WMAAPI GetFrameRate(
                    HWMFDECODER hDecoder,
                    const U8_WMF *pbPacket,
                    U32_WMF cbPacketSize,
                    U16_WMF *pFrameRate,
					U8_WMF *pDone);

WMPERR WMFDecodeInit_All (HWMFDECODER hDecoder,
                          U32_WMF u32VideoOutputPixelType,
                          U16_WMF u16VideoOutputBitCount
#ifdef _ZMDRM_
                          ,HDRMMGR *phDRM,
                          U8_WMF *pAppCert,
                          U32_WMF Rights,
                          const U8_WMF *pbHwId,
                          U32_WMF cbHwId
#endif
);

#ifdef __cplusplus
}
#endif


#endif  /* WMF_H */
