.\" Converted with mdoc2man 0.2
.\" from NiH: zip_error_get.mdoc,v 1.9 2006/04/23 12:45:10 wiz Exp 
.\" $NiH: zip_error_get.mdoc,v 1.9 2006/04/23 12:45:10 wiz Exp $
.\"
.\" zip_error_get.mdoc \-- get error codes for archive or file
.\" Copyright (C) 2004, 2005 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_ERROR_GET 3 "October 4, 2006" NiH
.SH "NAME"
zip_error_get , \- .Nm zip_file_error_get
get error codes for archive or file
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
void
zip_error_get(struct zip *archive, int *zep, int *sep);
.PP
void
zip_file_error_get(struct zip_file *file, int *zep, int *sep);
.SH "DESCRIPTION"
The
zip_error_get
function returns the error codes for the zip archive
\fBarchive.\fR
If
\fBzep\fR
is not
\fBNULL,\fR
\fB*zep\fR
will be filled in with the error code from libzip.
Similarly,
\fB*sep\fR
will contain the corresponding system error code, if
\fBsep\fR
is not
\fBNULL;\fR
use
zip_error_get_sys_type
to determine the type of system error code.
.PP
The
zip_file_error_get
function does the same for the zip file
\fBfile.\fR
.SH "SEE ALSO"
libzip(3),
zip_error_clear(3),
zip_error_get_sys_type(3),
zip_error_to_str(3)
.SH "AUTHORS"

Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at>
