<?php
/**
 * Mahara: Electronic portfolio, weblog, resume builder and social networking
 * Copyright (C) 2006-2008 Catalyst IT Ltd (http://www.catalyst.net.nz)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package    mahara
 * @subpackage artefact-blog
 * @author     Catalyst IT Ltd
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL
 * @copyright  (C) 2006-2008 Catalyst IT Ltd http://catalyst.net.nz
 *
 */

define('INTERNAL', 1);
define('JSON', 1);

require(dirname(dirname(dirname(__FILE__))) . '/init.php');
safe_require('artefact', 'blog');

$limit = param_integer('limit', null);
$offset = param_integer('offset', 0);
$id = param_integer('blogpost', 0);

if ($id) {
    $blogpost = new ArtefactTypeBlogPost($id);
    $blogpost->check_permission();
    if (!$filelist = $blogpost->get_attached_files()) {
        $filelist = array();
    }
}
else {
    $filelist = array();
}

$result = array(
    'count'       => count($filelist),
    'limit'       => $limit,
    'offset'      => $offset,
    'data'        => $filelist,
    'error'       => false,
    'message'     => false,
);

json_headers();
print json_encode($result);


?>
