/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_OCCLUSION_QUERY},
	{93, PKT3_SET_PREDICATION},
	{109, PKT3_COND_EXEC},
	{119, PKT3_PRED_EXEC},
	{129, PKT3_DRAW_INDIRECT},
	{143, PKT3_DRAW_INDEX_INDIRECT},
	{163, PKT3_INDEX_BASE},
	{174, PKT3_DRAW_INDEX_2},
	{187, PKT3_CONTEXT_CONTROL},
	{203, PKT3_INDEX_TYPE},
	{214, PKT3_DRAW_INDIRECT_MULTI},
	{234, PKT3_DRAW_INDEX_AUTO},
	{250, PKT3_DRAW_INDEX_IMMD},
	{266, PKT3_NUM_INSTANCES},
	{280, PKT3_DRAW_INDEX_MULTI_AUTO},
	{302, PKT3_INDIRECT_BUFFER_SI},
	{321, PKT3_INDIRECT_BUFFER_CONST},
	{343, PKT3_STRMOUT_BUFFER_UPDATE},
	{365, PKT3_DRAW_INDEX_OFFSET_2},
	{385, PKT3_WRITE_DATA},
	{396, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{422, PKT3_MEM_SEMAPHORE},
	{436, PKT3_MPEG_INDEX},
	{447, PKT3_WAIT_REG_MEM},
	{460, PKT3_MEM_WRITE},
	{470, PKT3_INDIRECT_BUFFER_CIK},
	{490, PKT3_COPY_DATA},
	{500, PKT3_PFP_SYNC_ME},
	{512, PKT3_SURFACE_SYNC},
	{525, PKT3_ME_INITIALIZE},
	{539, PKT3_COND_WRITE},
	{550, PKT3_EVENT_WRITE},
	{562, PKT3_EVENT_WRITE_EOP},
	{578, PKT3_EVENT_WRITE_EOS},
	{594, PKT3_ONE_REG_WRITE},
	{608, PKT3_ACQUIRE_MEM},
	{620, PKT3_SET_CONFIG_REG},
	{635, PKT3_SET_CONTEXT_REG},
	{651, PKT3_SET_SH_REG},
	{662, PKT3_SET_SH_REG_OFFSET},
	{680, PKT3_SET_UCONFIG_REG},
	{696, PKT3_LOAD_CONST_RAM},
	{711, PKT3_WRITE_CONST_RAM},
	{727, PKT3_DUMP_CONST_RAM},
	{742, PKT3_INCREMENT_CE_COUNTER},
	{763, PKT3_INCREMENT_DE_COUNTER},
	{784, PKT3_WAIT_ON_CE_COUNTER},
	{803, PKT3_IT_OPCODE_C},
	{815, PKT3_CP_DMA},
	{822, PKT3_DMA_DATA},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{831, S_2C3_COUNT_INDIRECT_ENABLE(~0u)},
	{853, S_2C3_DRAW_INDEX_ENABLE(~0u)},
	/* 2 */
	{881, S_370_ENGINE_SEL(~0u), 4, 0},
	{892, S_370_WR_CONFIRM(~0u)},
	{903, S_370_WR_ONE_ADDR(~0u)},
	{976, S_370_DST_SEL(~0u), 6, 4},
	/* 6 */
	{984, S_3F2_IB_SIZE(~0u)},
	{992, S_3F2_CHAIN(~0u)},
	{998, S_3F2_VALID(~0u)},
	/* 9 */
	{1004, S_410_SRC_ADDR_LO(~0u)},
	/* 10 */
	{1016, S_411_CP_SYNC(~0u)},
	{1048, S_411_SRC_SEL(~0u), 4, 10},
	{1056, S_411_ENGINE(~0u), 2, 0},
	{1087, S_411_DSL_SEL(~0u), 4, 14},
	{1095, S_411_SRC_ADDR_HI(~0u)},
	/* 15 */
	{1107, S_412_DST_ADDR_LO(~0u)},
	/* 16 */
	{1119, S_413_DST_ADDR_HI(~0u)},
	/* 17 */
	{1131, S_414_BYTE_COUNT(~0u)},
	{1142, S_414_DISABLE_WR_CONFIRM(~0u)},
	{1190, S_414_SRC_SWAP(~0u), 4, 18},
	{1199, S_414_DST_SWAP(~0u), 4, 18},
	{1215, S_414_SAS(~0u), 2, 22},
	{1219, S_414_DAS(~0u), 2, 22},
	{1246, S_414_SAIC(~0u), 2, 24},
	{1251, S_414_DAIC(~0u), 2, 24},
	{1256, S_414_RAW_WAIT(~0u)},
	/* 26 */
	{1016, S_500_CP_SYNC(~0u)},
	{1048, S_500_SRC_SEL(~0u), 4, 10},
	{1087, S_500_DSL_SEL(~0u), 4, 14},
	{1056, S_500_ENGINE(~0u), 2, 0},
	/* 30 */
	{1265, S_000E4C_SDMA_RQ_PENDING(~0u)},
	{1281, S_000E4C_TST_RQ_PENDING(~0u)},
	{1296, S_000E4C_SDMA1_RQ_PENDING(~0u)},
	{1313, S_000E4C_VCE0_RQ_PENDING(~0u)},
	{1329, S_000E4C_VP8_BUSY(~0u)},
	{1338, S_000E4C_SDMA_BUSY(~0u)},
	{1348, S_000E4C_SDMA1_BUSY(~0u)},
	{1359, S_000E4C_VCE0_BUSY(~0u)},
	{1369, S_000E4C_XDMA_BUSY(~0u)},
	{1379, S_000E4C_CHUB_BUSY(~0u)},
	{1389, S_000E4C_SDMA2_BUSY(~0u)},
	{1400, S_000E4C_SDMA3_BUSY(~0u)},
	{1411, S_000E4C_SAMSCP_BUSY(~0u)},
	{1423, S_000E4C_ISP_BUSY(~0u)},
	{1432, S_000E4C_VCE1_BUSY(~0u)},
	{1442, S_000E4C_ODE_BUSY(~0u)},
	{1451, S_000E4C_SDMA2_RQ_PENDING(~0u)},
	{1468, S_000E4C_SDMA3_RQ_PENDING(~0u)},
	{1485, S_000E4C_SAMSCP_RQ_PENDING(~0u)},
	{1503, S_000E4C_ISP_RQ_PENDING(~0u)},
	{1518, S_000E4C_VCE1_RQ_PENDING(~0u)},
	/* 51 */
	{1534, S_000E50_UVD_RQ_PENDING(~0u)},
	{1549, S_000E50_SAMMSP_RQ_PENDING(~0u)},
	{1567, S_000E50_ACP_RQ_PENDING(~0u)},
	{1582, S_000E50_SMU_RQ_PENDING(~0u)},
	{1597, S_000E50_GRBM_RQ_PENDING(~0u)},
	{1613, S_000E50_HI_RQ_PENDING(~0u)},
	{1627, S_000E50_VMC_BUSY(~0u)},
	{1636, S_000E50_MCB_BUSY(~0u)},
	{1645, S_000E50_MCB_NON_DISPLAY_BUSY(~0u)},
	{1666, S_000E50_MCC_BUSY(~0u)},
	{1675, S_000E50_MCD_BUSY(~0u)},
	{1684, S_000E50_VMC1_BUSY(~0u)},
	{1694, S_000E50_SEM_BUSY(~0u)},
	{1703, S_000E50_ACP_BUSY(~0u)},
	{1712, S_000E50_IH_BUSY(~0u)},
	{1720, S_000E50_UVD_BUSY(~0u)},
	{1729, S_000E50_SAMMSP_BUSY(~0u)},
	{1741, S_000E50_GCATCL2_BUSY(~0u)},
	{1754, S_000E50_OSATCL2_BUSY(~0u)},
	{1767, S_000E50_BIF_BUSY(~0u)},
	/* 71 */
	{1776, S_000E54_MCC0_BUSY(~0u)},
	{1786, S_000E54_MCC1_BUSY(~0u)},
	{1796, S_000E54_MCC2_BUSY(~0u)},
	{1806, S_000E54_MCC3_BUSY(~0u)},
	{1816, S_000E54_MCC4_BUSY(~0u)},
	{1826, S_000E54_MCC5_BUSY(~0u)},
	{1836, S_000E54_MCC6_BUSY(~0u)},
	{1846, S_000E54_MCC7_BUSY(~0u)},
	{1856, S_000E54_MCD0_BUSY(~0u)},
	{1866, S_000E54_MCD1_BUSY(~0u)},
	{1876, S_000E54_MCD2_BUSY(~0u)},
	{1886, S_000E54_MCD3_BUSY(~0u)},
	{1896, S_000E54_MCD4_BUSY(~0u)},
	{1906, S_000E54_MCD5_BUSY(~0u)},
	{1916, S_000E54_MCD6_BUSY(~0u)},
	{1926, S_000E54_MCD7_BUSY(~0u)},
	/* 87 */
	{1936, S_00D034_IDLE(~0u)},
	{1941, S_00D034_REG_IDLE(~0u)},
	{1950, S_00D034_RB_EMPTY(~0u)},
	{1959, S_00D034_RB_FULL(~0u)},
	{1967, S_00D034_RB_CMD_IDLE(~0u)},
	{1979, S_00D034_RB_CMD_FULL(~0u)},
	{1991, S_00D034_IB_CMD_IDLE(~0u)},
	{2003, S_00D034_IB_CMD_FULL(~0u)},
	{2015, S_00D034_BLOCK_IDLE(~0u)},
	{2026, S_00D034_INSIDE_IB(~0u)},
	{2036, S_00D034_EX_IDLE(~0u)},
	{2044, S_00D034_EX_IDLE_POLL_TIMER_EXPIRE(~0u)},
	{2070, S_00D034_PACKET_READY(~0u)},
	{2083, S_00D034_MC_WR_IDLE(~0u)},
	{2094, S_00D034_SRBM_IDLE(~0u)},
	{2104, S_00D034_CONTEXT_EMPTY(~0u)},
	{2118, S_00D034_DELTA_RPTR_FULL(~0u)},
	{2134, S_00D034_RB_MC_RREQ_IDLE(~0u)},
	{2150, S_00D034_IB_MC_RREQ_IDLE(~0u)},
	{2166, S_00D034_MC_RD_IDLE(~0u)},
	{2177, S_00D034_DELTA_RPTR_EMPTY(~0u)},
	{2194, S_00D034_MC_RD_RET_STALL(~0u)},
	{2210, S_00D034_MC_RD_NO_POLL_IDLE(~0u)},
	{2229, S_00D034_PREV_CMD_IDLE(~0u)},
	{2243, S_00D034_SEM_IDLE(~0u)},
	{2252, S_00D034_SEM_REQ_STALL(~0u)},
	{2266, S_00D034_SEM_RESP_STATE(~0u)},
	{2281, S_00D034_INT_IDLE(~0u)},
	{2290, S_00D034_INT_REQ_STALL(~0u)},
	/* 116 */
	{2304, S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{2327, S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{2350, S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{2373, S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{2393, S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{2413, S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{2433, S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{2453, S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{2473, S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{2493, S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{2513, S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{2533, S_008008_RLC_RQ_PENDING(~0u)},
	{2548, S_008008_RLC_BUSY(~0u)},
	{2557, S_008008_TC_BUSY(~0u)},
	{2565, S_008008_TCC_CC_RESIDENT(~0u)},
	{2581, S_008008_CPF_BUSY(~0u)},
	{2590, S_008008_CPC_BUSY(~0u)},
	{2599, S_008008_CPG_BUSY(~0u)},
	/* 134 */
	{2608, S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{2631, S_008010_SRBM_RQ_PENDING(~0u)},
	{2647, S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{2670, S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{2693, S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{2712, S_008010_DB_CLEAN(~0u)},
	{2721, S_008010_CB_CLEAN(~0u)},
	{2730, S_008010_TA_BUSY(~0u)},
	{2738, S_008010_GDS_BUSY(~0u)},
	{2747, S_008010_WD_BUSY_NO_DMA(~0u)},
	{2762, S_008010_VGT_BUSY(~0u)},
	{2771, S_008010_IA_BUSY_NO_DMA(~0u)},
	{2786, S_008010_IA_BUSY(~0u)},
	{2794, S_008010_SX_BUSY(~0u)},
	{2802, S_008010_WD_BUSY(~0u)},
	{2810, S_008010_SPI_BUSY(~0u)},
	{2819, S_008010_BCI_BUSY(~0u)},
	{2828, S_008010_SC_BUSY(~0u)},
	{2836, S_008010_PA_BUSY(~0u)},
	{2844, S_008010_DB_BUSY(~0u)},
	{2852, S_008010_CP_COHERENCY_BUSY(~0u)},
	{1415, S_008010_CP_BUSY(~0u)},
	{1637, S_008010_CB_BUSY(~0u)},
	{2870, S_008010_GUI_ACTIVE(~0u)},
	/* 158 */
	{2881, S_0084FC_OFFSET_UPDATE_DONE(~0u)},
	/* 159 */
	{2900, S_0085F0_DEST_BASE_0_ENA(~0u)},
	{2916, S_0085F0_DEST_BASE_1_ENA(~0u)},
	{2932, S_0085F0_CB0_DEST_BASE_ENA(~0u)},
	{2950, S_0085F0_CB1_DEST_BASE_ENA(~0u)},
	{2968, S_0085F0_CB2_DEST_BASE_ENA(~0u)},
	{2986, S_0085F0_CB3_DEST_BASE_ENA(~0u)},
	{3004, S_0085F0_CB4_DEST_BASE_ENA(~0u)},
	{3022, S_0085F0_CB5_DEST_BASE_ENA(~0u)},
	{3040, S_0085F0_CB6_DEST_BASE_ENA(~0u)},
	{3058, S_0085F0_CB7_DEST_BASE_ENA(~0u)},
	{3076, S_0085F0_DB_DEST_BASE_ENA(~0u)},
	{3093, S_0085F0_DEST_BASE_2_ENA(~0u)},
	{3109, S_0085F0_DEST_BASE_3_ENA(~0u)},
	{3125, S_0085F0_TCL1_ACTION_ENA(~0u)},
	{3141, S_0085F0_TC_ACTION_ENA(~0u)},
	{3155, S_0085F0_CB_ACTION_ENA(~0u)},
	{3169, S_0085F0_DB_ACTION_ENA(~0u)},
	{3183, S_0085F0_SH_KCACHE_ACTION_ENA(~0u)},
	{3204, S_0085F0_SH_ICACHE_ACTION_ENA(~0u)},
	/* 178 */
	{2712, S_008014_DB_CLEAN(~0u)},
	{2721, S_008014_CB_CLEAN(~0u)},
	{2819, S_008014_BCI_BUSY(~0u)},
	{2762, S_008014_VGT_BUSY(~0u)},
	{2836, S_008014_PA_BUSY(~0u)},
	{2730, S_008014_TA_BUSY(~0u)},
	{2794, S_008014_SX_BUSY(~0u)},
	{2810, S_008014_SPI_BUSY(~0u)},
	{2828, S_008014_SC_BUSY(~0u)},
	{2844, S_008014_DB_BUSY(~0u)},
	{1637, S_008014_CB_BUSY(~0u)},
	/* 189 */
	{2712, S_008018_DB_CLEAN(~0u)},
	{2721, S_008018_CB_CLEAN(~0u)},
	{2819, S_008018_BCI_BUSY(~0u)},
	{2762, S_008018_VGT_BUSY(~0u)},
	{2836, S_008018_PA_BUSY(~0u)},
	{2730, S_008018_TA_BUSY(~0u)},
	{2794, S_008018_SX_BUSY(~0u)},
	{2810, S_008018_SPI_BUSY(~0u)},
	{2828, S_008018_SC_BUSY(~0u)},
	{2844, S_008018_DB_BUSY(~0u)},
	{1637, S_008018_CB_BUSY(~0u)},
	/* 200 */
	{2712, S_008038_DB_CLEAN(~0u)},
	{2721, S_008038_CB_CLEAN(~0u)},
	{2819, S_008038_BCI_BUSY(~0u)},
	{2762, S_008038_VGT_BUSY(~0u)},
	{2836, S_008038_PA_BUSY(~0u)},
	{2730, S_008038_TA_BUSY(~0u)},
	{2794, S_008038_SX_BUSY(~0u)},
	{2810, S_008038_SPI_BUSY(~0u)},
	{2828, S_008038_SC_BUSY(~0u)},
	{2844, S_008038_DB_BUSY(~0u)},
	{1637, S_008038_CB_BUSY(~0u)},
	/* 211 */
	{2712, S_00803C_DB_CLEAN(~0u)},
	{2721, S_00803C_CB_CLEAN(~0u)},
	{2819, S_00803C_BCI_BUSY(~0u)},
	{2762, S_00803C_VGT_BUSY(~0u)},
	{2836, S_00803C_PA_BUSY(~0u)},
	{2730, S_00803C_TA_BUSY(~0u)},
	{2794, S_00803C_SX_BUSY(~0u)},
	{2810, S_00803C_SPI_BUSY(~0u)},
	{2828, S_00803C_SC_BUSY(~0u)},
	{2844, S_00803C_DB_BUSY(~0u)},
	{1637, S_00803C_CB_BUSY(~0u)},
	/* 222 */
	{2881, S_0300FC_OFFSET_UPDATE_DONE(~0u)},
	/* 223 */
	{3225, S_0301E4_COHER_BASE_HI_256B(~0u)},
	/* 224 */
	{3244, S_0301EC_START_DELAY_COUNT(~0u)},
	/* 225 */
	{2900, S_0301F0_DEST_BASE_0_ENA(~0u)},
	{2916, S_0301F0_DEST_BASE_1_ENA(~0u)},
	{3262, S_0301F0_TC_SD_ACTION_ENA(~0u)},
	{3279, S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{2932, S_0301F0_CB0_DEST_BASE_ENA(~0u)},
	{2950, S_0301F0_CB1_DEST_BASE_ENA(~0u)},
	{2968, S_0301F0_CB2_DEST_BASE_ENA(~0u)},
	{2986, S_0301F0_CB3_DEST_BASE_ENA(~0u)},
	{3004, S_0301F0_CB4_DEST_BASE_ENA(~0u)},
	{3022, S_0301F0_CB5_DEST_BASE_ENA(~0u)},
	{3040, S_0301F0_CB6_DEST_BASE_ENA(~0u)},
	{3058, S_0301F0_CB7_DEST_BASE_ENA(~0u)},
	{3076, S_0301F0_DB_DEST_BASE_ENA(~0u)},
	{3296, S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{3316, S_0301F0_TC_VOL_ACTION_ENA(~0u)},
	{3334, S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{3093, S_0301F0_DEST_BASE_2_ENA(~0u)},
	{3109, S_0301F0_DEST_BASE_3_ENA(~0u)},
	{3125, S_0301F0_TCL1_ACTION_ENA(~0u)},
	{3141, S_0301F0_TC_ACTION_ENA(~0u)},
	{3155, S_0301F0_CB_ACTION_ENA(~0u)},
	{3169, S_0301F0_DB_ACTION_ENA(~0u)},
	{3183, S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{3351, S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{3204, S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{3376, S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	{3400, S_0301F0_SH_SD_ACTION_ENA(~0u)},
	/* 252 */
	{3417, S_0301FC_MATCHING_GFX_CNTX(~0u)},
	{3435, S_0301FC_MEID(~0u)},
	{3440, S_0301FC_PHASE1_STATUS(~0u)},
	{3447, S_0301FC_STATUS(~0u)},
	/* 256 */
	{3454, S_008210_MEC1_BUSY(~0u)},
	{3464, S_008210_MEC2_BUSY(~0u)},
	{3474, S_008210_DC0_BUSY(~0u)},
	{3483, S_008210_DC1_BUSY(~0u)},
	{3492, S_008210_RCIU1_BUSY(~0u)},
	{3503, S_008210_RCIU2_BUSY(~0u)},
	{3514, S_008210_ROQ1_BUSY(~0u)},
	{3524, S_008210_ROQ2_BUSY(~0u)},
	{3534, S_008210_TCIU_BUSY(~0u)},
	{3544, S_008210_SCRATCH_RAM_BUSY(~0u)},
	{3561, S_008210_QU_BUSY(~0u)},
	{3569, S_008210_ATCL2IU_BUSY(~0u)},
	{3582, S_008210_CPG_CPC_BUSY(~0u)},
	{3595, S_008210_CPF_CPC_BUSY(~0u)},
	{2590, S_008210_CPC_BUSY(~0u)},
	/* 271 */
	{3608, S_008214_MEC1_LOAD_BUSY(~0u)},
	{3623, S_008214_MEC1_SEMAPOHRE_BUSY(~0u)},
	{3643, S_008214_MEC1_MUTEX_BUSY(~0u)},
	{3659, S_008214_MEC1_MESSAGE_BUSY(~0u)},
	{3677, S_008214_MEC1_EOP_QUEUE_BUSY(~0u)},
	{3697, S_008214_MEC1_IQ_QUEUE_BUSY(~0u)},
	{3716, S_008214_MEC1_IB_QUEUE_BUSY(~0u)},
	{3735, S_008214_MEC1_TC_BUSY(~0u)},
	{3748, S_008214_MEC1_DMA_BUSY(~0u)},
	{3762, S_008214_MEC1_PARTIAL_FLUSH_BUSY(~0u)},
	{3786, S_008214_MEC1_PIPE0_BUSY(~0u)},
	{3802, S_008214_MEC1_PIPE1_BUSY(~0u)},
	{3818, S_008214_MEC1_PIPE2_BUSY(~0u)},
	{3834, S_008214_MEC1_PIPE3_BUSY(~0u)},
	{3850, S_008214_MEC2_LOAD_BUSY(~0u)},
	{3865, S_008214_MEC2_SEMAPOHRE_BUSY(~0u)},
	{3885, S_008214_MEC2_MUTEX_BUSY(~0u)},
	{3901, S_008214_MEC2_MESSAGE_BUSY(~0u)},
	{3919, S_008214_MEC2_EOP_QUEUE_BUSY(~0u)},
	{3939, S_008214_MEC2_IQ_QUEUE_BUSY(~0u)},
	{3958, S_008214_MEC2_IB_QUEUE_BUSY(~0u)},
	{3977, S_008214_MEC2_TC_BUSY(~0u)},
	{3990, S_008214_MEC2_DMA_BUSY(~0u)},
	{4004, S_008214_MEC2_PARTIAL_FLUSH_BUSY(~0u)},
	{4028, S_008214_MEC2_PIPE0_BUSY(~0u)},
	{4044, S_008214_MEC2_PIPE1_BUSY(~0u)},
	{4060, S_008214_MEC2_PIPE2_BUSY(~0u)},
	{4076, S_008214_MEC2_PIPE3_BUSY(~0u)},
	/* 299 */
	{4092, S_008218_RCIU_TX_FREE_STALL(~0u)},
	{4111, S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{4131, S_008218_TCIU_TX_FREE_STALL(~0u)},
	{4150, S_008218_MEC1_DECODING_PACKET(~0u)},
	{4171, S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{4189, S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{4212, S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{4234, S_008218_MEC2_DECODING_PACKET(~0u)},
	{4255, S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{4273, S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{4296, S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{4318, S_008218_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4342, S_008218_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4366, S_008218_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 313 */
	{4389, S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{4408, S_00821C_CSF_BUSY(~0u)},
	{4417, S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{4432, S_00821C_ROQ_RING_BUSY(~0u)},
	{4446, S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{4465, S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{4484, S_00821C_ROQ_STATE_BUSY(~0u)},
	{4499, S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{4516, S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{4538, S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{4560, S_00821C_SEMAPHORE_BUSY(~0u)},
	{4575, S_00821C_INTERRUPT_BUSY(~0u)},
	{3534, S_00821C_TCIU_BUSY(~0u)},
	{4590, S_00821C_HQD_BUSY(~0u)},
	{4599, S_00821C_PRT_BUSY(~0u)},
	{3569, S_00821C_ATCL2IU_BUSY(~0u)},
	{4608, S_00821C_CPF_GFX_BUSY(~0u)},
	{4621, S_00821C_CPF_CMP_BUSY(~0u)},
	{4634, S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{4653, S_00821C_CPC_CPF_BUSY(~0u)},
	{2581, S_00821C_CPF_BUSY(~0u)},
	/* 334 */
	{4666, S_008220_REG_BUS_FIFO_BUSY(~0u)},
	{4684, S_008220_CSF_RING_BUSY(~0u)},
	{4698, S_008220_CSF_INDIRECT1_BUSY(~0u)},
	{4717, S_008220_CSF_INDIRECT2_BUSY(~0u)},
	{4736, S_008220_CSF_STATE_BUSY(~0u)},
	{4751, S_008220_CSF_CE_INDR1_BUSY(~0u)},
	{4769, S_008220_CSF_CE_INDR2_BUSY(~0u)},
	{4787, S_008220_CSF_ARBITER_BUSY(~0u)},
	{4804, S_008220_CSF_INPUT_BUSY(~0u)},
	{4819, S_008220_OUTSTANDING_READ_TAGS(~0u)},
	{4841, S_008220_HPD_PROCESSING_EOP_BUSY(~0u)},
	{4865, S_008220_HQD_DISPATCH_BUSY(~0u)},
	{4883, S_008220_HQD_IQ_TIMER_BUSY(~0u)},
	{4901, S_008220_HQD_DMA_OFFLOAD_BUSY(~0u)},
	{4922, S_008220_HQD_WAIT_SEMAPHORE_BUSY(~0u)},
	{4946, S_008220_HQD_SIGNAL_SEMAPHORE_BUSY(~0u)},
	{4972, S_008220_HQD_MESSAGE_BUSY(~0u)},
	{4989, S_008220_HQD_PQ_FETCHER_BUSY(~0u)},
	{5009, S_008220_HQD_IB_FETCHER_BUSY(~0u)},
	{5029, S_008220_HQD_IQ_FETCHER_BUSY(~0u)},
	{5049, S_008220_HQD_EOP_FETCHER_BUSY(~0u)},
	{5070, S_008220_HQD_CONSUMED_RPTR_BUSY(~0u)},
	{5093, S_008220_HQD_FETCHER_ARB_BUSY(~0u)},
	{5114, S_008220_HQD_ROQ_ALIGN_BUSY(~0u)},
	{5133, S_008220_HQD_ROQ_EOP_BUSY(~0u)},
	{5150, S_008220_HQD_ROQ_IQ_BUSY(~0u)},
	{5166, S_008220_HQD_ROQ_PQ_BUSY(~0u)},
	{5182, S_008220_HQD_ROQ_IB_BUSY(~0u)},
	{5198, S_008220_HQD_WPTR_POLL_BUSY(~0u)},
	{5217, S_008220_HQD_PQ_BUSY(~0u)},
	{5229, S_008220_HQD_IB_BUSY(~0u)},
	/* 365 */
	{5241, S_008224_RING_FETCHING_DATA(~0u)},
	{5260, S_008224_INDR1_FETCHING_DATA(~0u)},
	{5280, S_008224_INDR2_FETCHING_DATA(~0u)},
	{5300, S_008224_STATE_FETCHING_DATA(~0u)},
	{5320, S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{5341, S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{4318, S_008224_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4342, S_008224_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4366, S_008224_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 374 */
	{5362, S_030230_COHER_SIZE_HI_256B(~0u)},
	/* 375 */
	{5381, S_0088B0_PRIM_COUNT(~0u)},
	/* 376 */
	{5392, S_0088C4_VS_NO_EXTRA_BUFFER(~0u)},
	{5411, S_0088C4_STREAMOUT_FULL_FLUSH(~0u)},
	{5432, S_0088C4_ES_LIMIT(~0u)},
	/* 379 */
	{5441, S_0088D4_VERT_REUSE(~0u)},
	/* 380 */
	{5968, S_008958_PRIM_TYPE(~0u), 29, 26},
	/* 381 */
	{203, S_00895C_INDEX_TYPE(~0u), 2, 55},
	/* 382 */
	{38, S_008988_SIZE(~0u)},
	/* 383 */
	{6020, S_0089B0_OFFCHIP_BUFFERING(~0u)},
	/* 384 */
	{6038, S_008A14_CLIP_VTX_REORDER_ENA(~0u)},
	{6059, S_008A14_NUM_CLIP_SEQ(~0u)},
	{6072, S_008A14_CLIPPED_PRIM_SEQ_STALL(~0u)},
	{6095, S_008A14_VE_NAN_PROC_DISABLE(~0u)},
	/* 388 */
	{6115, S_008A60_LINE_STIPPLE_VALUE(~0u)},
	/* 389 */
	{6134, S_008B10_CURRENT_PTR(~0u)},
	{6146, S_008B10_CURRENT_COUNT(~0u)},
	/* 391 */
	{6160, S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{6185, S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{6223, S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{6264, S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{6287, S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{6310, S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{6334, S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{6364, S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{6393, S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{6419, S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{6448, S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{6473, S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{5320, S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{5341, S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{6508, S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{6536, S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{4318, S_008670_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4342, S_008670_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4366, S_008670_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 410 */
	{6566, S_008674_RBIU_TO_DMA_NOT_RDY_TO_RCV(~0u)},
	{6593, S_008674_RBIU_TO_SEM_NOT_RDY_TO_RCV(~0u)},
	{6620, S_008674_RBIU_TO_MEMWR_NOT_RDY_TO_RCV(~0u)},
	{6649, S_008674_ME_HAS_ACTIVE_CE_BUFFER_FLAG(~0u)},
	{6678, S_008674_ME_HAS_ACTIVE_DE_BUFFER_FLAG(~0u)},
	{6707, S_008674_ME_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{6735, S_008674_ME_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{6765, S_008674_ME_WAITING_ON_TC_READ_DATA(~0u)},
	{6792, S_008674_ME_WAITING_ON_REG_READ_DATA(~0u)},
	{6820, S_008674_RCIU_WAITING_ON_GDS_FREE(~0u)},
	{6845, S_008674_RCIU_WAITING_ON_GRBM_FREE(~0u)},
	{6871, S_008674_RCIU_WAITING_ON_VGT_FREE(~0u)},
	{6896, S_008674_RCIU_STALLED_ON_ME_READ(~0u)},
	{6920, S_008674_RCIU_STALLED_ON_DMA_READ(~0u)},
	{6945, S_008674_RCIU_STALLED_ON_APPEND_READ(~0u)},
	{6973, S_008674_RCIU_HALTED_BY_REG_VIOLATION(~0u)},
	/* 426 */
	{7002, S_008678_PFP_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{7028, S_008678_PFP_TO_MEQ_NOT_RDY_TO_RCV(~0u)},
	{7054, S_008678_PFP_TO_RCIU_NOT_RDY_TO_RCV(~0u)},
	{7081, S_008678_PFP_TO_VGT_WRITES_PENDING(~0u)},
	{7107, S_008678_PFP_RCIU_READ_PENDING(~0u)},
	{7129, S_008678_PFP_WAITING_ON_BUFFER_DATA(~0u)},
	{7156, S_008678_ME_WAIT_ON_CE_COUNTER(~0u)},
	{7178, S_008678_ME_WAIT_ON_AVAIL_BUFFER(~0u)},
	{7202, S_008678_GFX_CNTX_NOT_AVAIL_TO_ME(~0u)},
	{7227, S_008678_ME_RCIU_NOT_RDY_TO_RCV(~0u)},
	{7250, S_008678_ME_TO_CONST_NOT_RDY_TO_RCV(~0u)},
	{7277, S_008678_ME_WAITING_DATA_FROM_PFP(~0u)},
	{7302, S_008678_ME_WAITING_ON_PARTIAL_FLUSH(~0u)},
	{7330, S_008678_MEQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{7355, S_008678_STQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{7380, S_008678_ME_WAITING_DATA_FROM_STQ(~0u)},
	{7405, S_008678_PFP_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{7434, S_008678_PFP_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{7465, S_008678_EOPD_FIFO_NEEDS_SC_EOP_DONE(~0u)},
	{7493, S_008678_EOPD_FIFO_NEEDS_WR_CONFIRM(~0u)},
	{7520, S_008678_STRMO_WR_OF_PRIM_DATA_PENDING(~0u)},
	{7550, S_008678_PIPE_STATS_WR_DATA_PENDING(~0u)},
	{7577, S_008678_APPEND_RDY_WAIT_ON_CS_DONE(~0u)},
	{7604, S_008678_APPEND_RDY_WAIT_ON_PS_DONE(~0u)},
	{7631, S_008678_APPEND_WAIT_ON_WR_CONFIRM(~0u)},
	{7657, S_008678_APPEND_ACTIVE_PARTITION(~0u)},
	{7681, S_008678_APPEND_WAITING_TO_SEND_MEMWRITE(~0u)},
	{7713, S_008678_SURF_SYNC_NEEDS_IDLE_CNTXS(~0u)},
	{7740, S_008678_SURF_SYNC_NEEDS_ALL_CLEAN(~0u)},
	/* 455 */
	{4432, S_008680_ROQ_RING_BUSY(~0u)},
	{4446, S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{4465, S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{4484, S_008680_ROQ_STATE_BUSY(~0u)},
	{7766, S_008680_DC_BUSY(~0u)},
	{3569, S_008680_ATCL2IU_BUSY(~0u)},
	{7774, S_008680_PFP_BUSY(~0u)},
	{7783, S_008680_MEQ_BUSY(~0u)},
	{7792, S_008680_ME_BUSY(~0u)},
	{7800, S_008680_QUERY_BUSY(~0u)},
	{4560, S_008680_SEMAPHORE_BUSY(~0u)},
	{4575, S_008680_INTERRUPT_BUSY(~0u)},
	{7811, S_008680_SURFACE_SYNC_BUSY(~0u)},
	{1339, S_008680_DMA_BUSY(~0u)},
	{7829, S_008680_RCIU_BUSY(~0u)},
	{3544, S_008680_SCRATCH_RAM_BUSY(~0u)},
	{7839, S_008680_CPC_CPG_BUSY(~0u)},
	{7852, S_008680_CE_BUSY(~0u)},
	{3534, S_008680_TCIU_BUSY(~0u)},
	{4499, S_008680_ROQ_CE_RING_BUSY(~0u)},
	{4516, S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{4538, S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{1415, S_008680_CP_BUSY(~0u)},
	/* 478 */
	{7860, S_030800_INSTANCE_INDEX(~0u)},
	{7875, S_030800_SH_INDEX(~0u)},
	{7884, S_030800_SE_INDEX(~0u)},
	{7893, S_030800_SH_BROADCAST_WRITES(~0u)},
	{7913, S_030800_INSTANCE_BROADCAST_WRITES(~0u)},
	{7939, S_030800_SE_BROADCAST_WRITES(~0u)},
	/* 484 */
	{5968, S_030908_PRIM_TYPE(~0u), 29, 57},
	/* 485 */
	{203, S_03090C_INDEX_TYPE(~0u), 2, 55},
	/* 486 */
	{38, S_030938_SIZE(~0u)},
	/* 487 */
	{6020, S_03093C_OFFCHIP_BUFFERING(~0u)},
	{8007, S_03093C_OFFCHIP_GRANULARITY(~0u), 4, 86},
	/* 489 */
	{6115, S_030A00_LINE_STIPPLE_VALUE(~0u)},
	/* 490 */
	{6134, S_030A04_CURRENT_PTR(~0u)},
	{6146, S_030A04_CURRENT_COUNT(~0u)},
	/* 492 */
	{445, S_030A10_X(~0u)},
	{91, S_030A10_Y(~0u)},
	/* 494 */
	{445, S_030A14_X(~0u)},
	{91, S_030A14_Y(~0u)},
	/* 496 */
	{445, S_030A18_X(~0u)},
	{91, S_030A18_Y(~0u)},
	/* 498 */
	{445, S_030A2C_X(~0u)},
	{91, S_030A2C_Y(~0u)},
	/* 500 */
	{8027, S_008BF0_ENABLE_PA_SC_OUT_OF_ORDER(~0u)},
	{8053, S_008BF0_DISABLE_SC_DB_TILE_FIX(~0u)},
	{8076, S_008BF0_DISABLE_AA_MASK_FULL_FIX(~0u)},
	{8101, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOCATIONS(~0u)},
	{8132, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOC_CENTROID(~0u)},
	{8166, S_008BF0_DISABLE_SCISSOR_FIX(~0u)},
	{8186, S_008BF0_DISABLE_PW_BUBBLE_COLLAPSE(~0u)},
	{8213, S_008BF0_SEND_UNLIT_STILES_TO_PACKER(~0u)},
	{8241, S_008BF0_DISABLE_DUALGRAD_PERF_OPTIMIZATION(~0u)},
	/* 509 */
	{8276, S_008C08_INST_INVALIDATE(~0u)},
	{8292, S_008C08_DATA_INVALIDATE(~0u)},
	/* 511 */
	{8276, S_030D20_INST_INVALIDATE(~0u)},
	{8292, S_030D20_DATA_INVALIDATE(~0u)},
	{8308, S_030D20_INVALIDATE_VOLATILE(~0u)},
	/* 514 */
	{8328, S_008C0C_RET(~0u)},
	{8332, S_008C0C_RUI(~0u)},
	{8336, S_008C0C_RNG(~0u)},
	/* 517 */
	{8340, S_008DFC_EN(~0u)},
	{8402, S_008DFC_TGT(~0u), 33, 90},
	{8406, S_008DFC_COMPR(~0u)},
	{2895, S_008DFC_DONE(~0u)},
	{8412, S_008DFC_VM(~0u)},
	{8432, S_008DFC_ENCODING(~0u), 63, 123},
	/* 523 */
	{8441, S_030E04_ADDRESS(~0u)},
	/* 524 */
	{8449, S_030F04_COUNT_HI(~0u)},
	/* 525 */
	{8458, S_008F04_BASE_ADDRESS_HI(~0u)},
	{8474, S_008F04_STRIDE(~0u)},
	{8481, S_008F04_CACHE_SWIZZLE(~0u)},
	{8495, S_008F04_SWIZZLE_ENABLE(~0u)},
	/* 529 */
	{8449, S_030F0C_COUNT_HI(~0u)},
	/* 530 */
	{8600, S_008F0C_DST_SEL_X(~0u), 8, 186},
	{8610, S_008F0C_DST_SEL_Y(~0u), 8, 186},
	{8620, S_008F0C_DST_SEL_Z(~0u), 8, 186},
	{8630, S_008F0C_DST_SEL_W(~0u), 8, 186},
	{8814, S_008F0C_NUM_FORMAT(~0u), 8, 194},
	{9206, S_008F0C_DATA_FORMAT(~0u), 16, 202},
	{9218, S_008F0C_ELEMENT_SIZE(~0u)},
	{9231, S_008F0C_INDEX_STRIDE(~0u)},
	{9244, S_008F0C_ADD_TID_ENABLE(~0u)},
	{9259, S_008F0C_ATC(~0u)},
	{9263, S_008F0C_HASH_ENABLE(~0u)},
	{9275, S_008F0C_HEAP(~0u)},
	{9280, S_008F0C_MTYPE(~0u)},
	{209, S_008F0C_TYPE(~0u), 4, 218},
	/* 544 */
	{8449, S_030F14_COUNT_HI(~0u)},
	/* 545 */
	{8458, S_008F14_BASE_ADDRESS_HI(~0u)},
	{9355, S_008F14_MIN_LOD(~0u)},
	{9206, S_008F14_DATA_FORMAT(~0u), 64, 222},
	{8814, S_008F14_NUM_FORMAT(~0u), 16, 286},
	{9280, S_008F14_MTYPE(~0u)},
	/* 550 */
	{11345, S_008F18_WIDTH(~0u)},
	{11351, S_008F18_HEIGHT(~0u)},
	{11358, S_008F18_PERF_MOD(~0u)},
	{11367, S_008F18_INTERLACED(~0u)},
	/* 554 */
	{8449, S_030F1C_COUNT_HI(~0u)},
	/* 555 */
	{8600, S_008F1C_DST_SEL_X(~0u), 8, 186},
	{8610, S_008F1C_DST_SEL_Y(~0u), 8, 186},
	{8620, S_008F1C_DST_SEL_Z(~0u), 8, 186},
	{8630, S_008F1C_DST_SEL_W(~0u), 8, 186},
	{11378, S_008F1C_BASE_LEVEL(~0u)},
	{11389, S_008F1C_LAST_LEVEL(~0u)},
	{11400, S_008F1C_TILING_INDEX(~0u)},
	{11413, S_008F1C_POW2_PAD(~0u)},
	{9280, S_008F1C_MTYPE(~0u)},
	{9259, S_008F1C_ATC(~0u)},
	{209, S_008F1C_TYPE(~0u), 16, 302},
	/* 566 */
	{11724, S_008F20_DEPTH(~0u)},
	{11730, S_008F20_PITCH(~0u)},
	/* 568 */
	{11736, S_008F24_BASE_ARRAY(~0u)},
	{11747, S_008F24_LAST_ARRAY(~0u)},
	/* 570 */
	{11758, S_008F28_MIN_LOD_WARN(~0u)},
	{11771, S_008F28_COUNTER_BANK_ID(~0u)},
	{11787, S_008F28_LOD_HDW_CNT_EN(~0u)},
	{11802, S_008F28_COMPRESSION_EN(~0u)},
	{11817, S_008F28_ALPHA_IS_ON_MSB(~0u)},
	{11833, S_008F28_COLOR_TRANSFORM(~0u)},
	{11849, S_008F28_LOST_ALPHA_BITS(~0u)},
	{11865, S_008F28_LOST_COLOR_BITS(~0u)},
	/* 578 */
	{12063, S_008F30_CLAMP_X(~0u), 8, 318},
	{12071, S_008F30_CLAMP_Y(~0u), 8, 318},
	{12079, S_008F30_CLAMP_Z(~0u), 8, 318},
	{12087, S_008F30_MAX_ANISO_RATIO(~0u)},
	{12335, S_008F30_DEPTH_COMPARE_FUNC(~0u), 8, 326},
	{12354, S_008F30_FORCE_UNNORMALIZED(~0u)},
	{12373, S_008F30_ANISO_THRESHOLD(~0u)},
	{12389, S_008F30_MC_COORD_TRUNC(~0u)},
	{12404, S_008F30_FORCE_DEGAMMA(~0u)},
	{12418, S_008F30_ANISO_BIAS(~0u)},
	{12429, S_008F30_TRUNC_COORD(~0u)},
	{12441, S_008F30_DISABLE_CUBE_WRAP(~0u)},
	{12459, S_008F30_FILTER_MODE(~0u)},
	{12471, S_008F30_COMPAT_MODE(~0u)},
	/* 592 */
	{9355, S_008F34_MIN_LOD(~0u)},
	{12483, S_008F34_MAX_LOD(~0u)},
	{12491, S_008F34_PERF_MIP(~0u)},
	{12500, S_008F34_PERF_Z(~0u)},
	/* 596 */
	{12507, S_008F38_LOD_BIAS(~0u)},
	{12516, S_008F38_LOD_BIAS_SEC(~0u)},
	{12578, S_008F38_XY_MAG_FILTER(~0u), 2, 334},
	{12653, S_008F38_XY_MIN_FILTER(~0u), 4, 336},
	{12733, S_008F38_Z_FILTER(~0u), 3, 340},
	{12742, S_008F38_MIP_FILTER(~0u), 3, 340},
	{12753, S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{12772, S_008F38_DISABLE_LSB_CEIL(~0u)},
	{12789, S_008F38_FILTER_PREC_FIX(~0u)},
	{12805, S_008F38_ANISO_OVERRIDE(~0u)},
	/* 606 */
	{12820, S_008F3C_BORDER_COLOR_PTR(~0u)},
	{12964, S_008F3C_BORDER_COLOR_TYPE(~0u), 4, 343},
	/* 608 */
	{12982, S_0090DC_VS_LOW_THRESHOLD(~0u)},
	{12999, S_0090DC_GS_LOW_THRESHOLD(~0u)},
	{13016, S_0090DC_ES_LOW_THRESHOLD(~0u)},
	{13033, S_0090DC_HS_LOW_THRESHOLD(~0u)},
	{13050, S_0090DC_LS_LOW_THRESHOLD(~0u)},
	/* 613 */
	{13067, S_0090E0_PS_CU_EN(~0u)},
	{13076, S_0090E0_VS_CU_EN(~0u)},
	/* 615 */
	{13085, S_0090E4_GS_CU_EN(~0u)},
	{13094, S_0090E4_ES_CU_EN(~0u)},
	/* 617 */
	{13103, S_0090E8_LSHS_CU_EN(~0u)},
	/* 618 */
	{13114, S_0090EC_MAX_WAVE_ID(~0u)},
	/* 619 */
	{13114, S_0090E8_MAX_WAVE_ID(~0u)},
	/* 620 */
	{13131, S_0090F0_RING_ORDER_TS0(~0u), 1, 347},
	{13146, S_0090F0_RING_ORDER_TS1(~0u)},
	{13161, S_0090F0_RING_ORDER_TS2(~0u)},
	/* 623 */
	{13176, S_00C700_PIPE_ORDER_TS0(~0u)},
	{13191, S_00C700_PIPE_ORDER_TS1(~0u)},
	{13206, S_00C700_PIPE_ORDER_TS2(~0u)},
	{13221, S_00C700_PIPE_ORDER_TS3(~0u)},
	{13236, S_00C700_TS0_DUR_MULT(~0u)},
	{13249, S_00C700_TS1_DUR_MULT(~0u)},
	{13262, S_00C700_TS2_DUR_MULT(~0u)},
	{13275, S_00C700_TS3_DUR_MULT(~0u)},
	/* 631 */
	{13288, S_0090F4_TS0_DURATION(~0u)},
	{13301, S_0090F4_TS1_DURATION(~0u)},
	/* 633 */
	{13314, S_0090F8_TS2_DURATION(~0u)},
	/* 634 */
	{38, S_008F40_SIZE(~0u)},
	/* 635 */
	{673, S_008F44_OFFSET(~0u)},
	/* 636 */
	{8449, S_030FFC_COUNT_HI(~0u)},
	/* 637 */
	{13327, S_009100_GPR_WRITE_PRIORITY(~0u)},
	{13346, S_009100_EXP_PRIORITY_ORDER(~0u)},
	{13365, S_009100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{13387, S_009100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{13409, S_009100_RSRC_MGMT_RESET(~0u)},
	/* 642 */
	{13678, S_00913C_VTX_DONE_DELAY(~0u), 16, 348},
	{13693, S_00913C_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{13717, S_00913C_PC_LIMIT_ENABLE(~0u)},
	{13733, S_00913C_PC_LIMIT_STRICT(~0u)},
	{13749, S_00913C_PC_LIMIT_SIZE(~0u)},
	/* 647 */
	{13763, S_00936C_TYPE_A(~0u)},
	{13770, S_00936C_VGPR_A(~0u)},
	{13777, S_00936C_SGPR_A(~0u)},
	{13784, S_00936C_LDS_A(~0u)},
	{13790, S_00936C_WAVES_A(~0u)},
	{13798, S_00936C_EN_A(~0u)},
	{13803, S_00936C_TYPE_B(~0u)},
	{13810, S_00936C_VGPR_B(~0u)},
	{13817, S_00936C_SGPR_B(~0u)},
	{13824, S_00936C_LDS_B(~0u)},
	{13830, S_00936C_WAVES_B(~0u)},
	{13838, S_00936C_EN_B(~0u)},
	/* 659 */
	{13843, S_009858_MSAA1_X(~0u)},
	{13851, S_009858_MSAA1_Y(~0u)},
	{13859, S_009858_MSAA2_X(~0u)},
	{13867, S_009858_MSAA2_Y(~0u)},
	{13875, S_009858_MSAA4_X(~0u)},
	{13883, S_009858_MSAA4_Y(~0u)},
	{13891, S_009858_MSAA8_X(~0u)},
	{13899, S_009858_MSAA8_Y(~0u)},
	{13907, S_009858_MSAA16_X(~0u)},
	{13916, S_009858_MSAA16_Y(~0u)},
	/* 669 */
	{13925, S_0098F8_NUM_PIPES(~0u)},
	{13935, S_0098F8_PIPE_INTERLEAVE_SIZE(~0u)},
	{13956, S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{13977, S_0098F8_NUM_SHADER_ENGINES(~0u)},
	{13996, S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{14020, S_0098F8_NUM_GPUS(~0u)},
	{14029, S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{14049, S_0098F8_ROW_SIZE(~0u)},
	{14058, S_0098F8_NUM_LOWER_PIPES(~0u)},
	/* 678 */
	{14191, S_009910_MICRO_TILE_MODE(~0u), 4, 364},
	{14436, S_009910_ARRAY_MODE(~0u), 16, 368},
	{14798, S_009910_PIPE_CONFIG(~0u), 15, 384},
	{14988, S_009910_TILE_SPLIT(~0u), 7, 399},
	{15091, S_009910_BANK_WIDTH(~0u), 4, 406},
	{15198, S_009910_BANK_HEIGHT(~0u), 4, 410},
	{15310, S_009910_MACRO_TILE_ASPECT(~0u), 4, 414},
	{15397, S_009910_NUM_BANKS(~0u), 4, 418},
	{15438, S_009910_MICRO_TILE_MODE_NEW(~0u), 4, 422},
	{15458, S_009910_SAMPLE_SPLIT(~0u)},
	/* 688 */
	{15091, S_009990_BANK_WIDTH(~0u)},
	{15198, S_009990_BANK_HEIGHT(~0u)},
	{15310, S_009990_MACRO_TILE_ASPECT(~0u)},
	{15397, S_009990_NUM_BANKS(~0u)},
	/* 692 */
	{15471, S_00B004_MEM_BASE(~0u)},
	/* 693 */
	{15471, S_00B00C_MEM_BASE(~0u)},
	/* 694 */
	{13070, S_00B01C_CU_EN(~0u)},
	{15480, S_00B01C_WAVE_LIMIT(~0u)},
	{15491, S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
	/* 697 */
	{15471, S_00B024_MEM_BASE(~0u)},
	/* 698 */
	{15510, S_00B028_VGPRS(~0u)},
	{15516, S_00B028_SGPRS(~0u)},
	{13337, S_00B028_PRIORITY(~0u)},
	{15565, S_00B028_FLOAT_MODE(~0u), 241, 426},
	{15576, S_00B028_PRIV(~0u)},
	{15581, S_00B028_DX10_CLAMP(~0u)},
	{15592, S_00B028_DEBUG_MODE(~0u)},
	{15603, S_00B028_IEEE_MODE(~0u)},
	{15613, S_00B028_CU_GROUP_DISABLE(~0u)},
	{15630, S_00B028_CACHE_CTL(~0u)},
	{15640, S_00B028_CDBG_USER(~0u)},
	/* 709 */
	{15650, S_00B02C_SCRATCH_EN(~0u)},
	{15661, S_00B02C_USER_SGPR(~0u)},
	{15671, S_00B02C_TRAP_PRESENT(~0u)},
	{15684, S_00B02C_WAVE_CNT_EN(~0u)},
	{15696, S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{15711, S_00B02C_EXCP_EN(~0u)},
	{15719, S_00B02C_EXCP_EN_CIK(~0u)},
	/* 716 */
	{15471, S_00B104_MEM_BASE(~0u)},
	/* 717 */
	{15471, S_00B10C_MEM_BASE(~0u)},
	/* 718 */
	{13070, S_00B118_CU_EN(~0u)},
	{15480, S_00B118_WAVE_LIMIT(~0u)},
	{15491, S_00B118_LOCK_LOW_THRESHOLD(~0u)},
	/* 721 */
	{5435, S_00B11C_LIMIT(~0u)},
	/* 722 */
	{15471, S_00B124_MEM_BASE(~0u)},
	/* 723 */
	{15510, S_00B128_VGPRS(~0u)},
	{15516, S_00B128_SGPRS(~0u)},
	{13337, S_00B128_PRIORITY(~0u)},
	{15565, S_00B128_FLOAT_MODE(~0u)},
	{15576, S_00B128_PRIV(~0u)},
	{15581, S_00B128_DX10_CLAMP(~0u)},
	{15592, S_00B128_DEBUG_MODE(~0u)},
	{15603, S_00B128_IEEE_MODE(~0u)},
	{15731, S_00B128_VGPR_COMP_CNT(~0u)},
	{15745, S_00B128_CU_GROUP_ENABLE(~0u)},
	{15630, S_00B128_CACHE_CTL(~0u)},
	{15640, S_00B128_CDBG_USER(~0u)},
	/* 735 */
	{15650, S_00B12C_SCRATCH_EN(~0u)},
	{15661, S_00B12C_USER_SGPR(~0u)},
	{15671, S_00B12C_TRAP_PRESENT(~0u)},
	{15761, S_00B12C_OC_LDS_EN(~0u)},
	{15771, S_00B12C_SO_BASE0_EN(~0u)},
	{15783, S_00B12C_SO_BASE1_EN(~0u)},
	{15795, S_00B12C_SO_BASE2_EN(~0u)},
	{15807, S_00B12C_SO_BASE3_EN(~0u)},
	{15819, S_00B12C_SO_EN(~0u)},
	{15711, S_00B12C_EXCP_EN(~0u)},
	{15719, S_00B12C_EXCP_EN_CIK(~0u)},
	{15825, S_00B12C_DISPATCH_DRAW_EN(~0u)},
	/* 747 */
	{15471, S_00B204_MEM_BASE(~0u)},
	/* 748 */
	{15471, S_00B20C_MEM_BASE(~0u)},
	/* 749 */
	{13070, S_00B21C_CU_EN(~0u)},
	{15480, S_00B21C_WAVE_LIMIT(~0u)},
	{15491, S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{15842, S_00B21C_GROUP_FIFO_DEPTH(~0u)},
	/* 753 */
	{15471, S_00B224_MEM_BASE(~0u)},
	/* 754 */
	{15510, S_00B228_VGPRS(~0u)},
	{15516, S_00B228_SGPRS(~0u)},
	{13337, S_00B228_PRIORITY(~0u)},
	{15565, S_00B228_FLOAT_MODE(~0u)},
	{15576, S_00B228_PRIV(~0u)},
	{15581, S_00B228_DX10_CLAMP(~0u)},
	{15592, S_00B228_DEBUG_MODE(~0u)},
	{15603, S_00B228_IEEE_MODE(~0u)},
	{15745, S_00B228_CU_GROUP_ENABLE(~0u)},
	{15630, S_00B228_CACHE_CTL(~0u)},
	{15640, S_00B228_CDBG_USER(~0u)},
	/* 765 */
	{15650, S_00B22C_SCRATCH_EN(~0u)},
	{15661, S_00B22C_USER_SGPR(~0u)},
	{15671, S_00B22C_TRAP_PRESENT(~0u)},
	{15711, S_00B22C_EXCP_EN(~0u)},
	{15719, S_00B22C_EXCP_EN_CIK(~0u)},
	/* 770 */
	{15471, S_00B304_MEM_BASE(~0u)},
	/* 771 */
	{15471, S_00B30C_MEM_BASE(~0u)},
	/* 772 */
	{13070, S_00B31C_CU_EN(~0u)},
	{15480, S_00B31C_WAVE_LIMIT(~0u)},
	{15491, S_00B31C_LOCK_LOW_THRESHOLD(~0u)},
	{15842, S_00B31C_GROUP_FIFO_DEPTH(~0u)},
	/* 776 */
	{15471, S_00B324_MEM_BASE(~0u)},
	/* 777 */
	{15510, S_00B328_VGPRS(~0u)},
	{15516, S_00B328_SGPRS(~0u)},
	{13337, S_00B328_PRIORITY(~0u)},
	{15565, S_00B328_FLOAT_MODE(~0u)},
	{15576, S_00B328_PRIV(~0u)},
	{15581, S_00B328_DX10_CLAMP(~0u)},
	{15592, S_00B328_DEBUG_MODE(~0u)},
	{15603, S_00B328_IEEE_MODE(~0u)},
	{15731, S_00B328_VGPR_COMP_CNT(~0u)},
	{15745, S_00B328_CU_GROUP_ENABLE(~0u)},
	{15630, S_00B328_CACHE_CTL(~0u)},
	{15640, S_00B328_CDBG_USER(~0u)},
	/* 789 */
	{15650, S_00B32C_SCRATCH_EN(~0u)},
	{15661, S_00B32C_USER_SGPR(~0u)},
	{15671, S_00B32C_TRAP_PRESENT(~0u)},
	{15761, S_00B32C_OC_LDS_EN(~0u)},
	{15711, S_00B32C_EXCP_EN(~0u)},
	{15702, S_00B32C_LDS_SIZE(~0u)},
	/* 795 */
	{15471, S_00B404_MEM_BASE(~0u)},
	/* 796 */
	{15471, S_00B40C_MEM_BASE(~0u)},
	/* 797 */
	{15480, S_00B41C_WAVE_LIMIT(~0u)},
	{15491, S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{15842, S_00B41C_GROUP_FIFO_DEPTH(~0u)},
	/* 800 */
	{15471, S_00B424_MEM_BASE(~0u)},
	/* 801 */
	{15510, S_00B428_VGPRS(~0u)},
	{15516, S_00B428_SGPRS(~0u)},
	{13337, S_00B428_PRIORITY(~0u)},
	{15565, S_00B428_FLOAT_MODE(~0u)},
	{15576, S_00B428_PRIV(~0u)},
	{15581, S_00B428_DX10_CLAMP(~0u)},
	{15592, S_00B428_DEBUG_MODE(~0u)},
	{15603, S_00B428_IEEE_MODE(~0u)},
	{15630, S_00B428_CACHE_CTL(~0u)},
	{15640, S_00B428_CDBG_USER(~0u)},
	/* 811 */
	{15650, S_00B42C_SCRATCH_EN(~0u)},
	{15661, S_00B42C_USER_SGPR(~0u)},
	{15671, S_00B42C_TRAP_PRESENT(~0u)},
	{15761, S_00B42C_OC_LDS_EN(~0u)},
	{15859, S_00B42C_TG_SIZE_EN(~0u)},
	{15711, S_00B42C_EXCP_EN(~0u)},
	/* 817 */
	{15471, S_00B504_MEM_BASE(~0u)},
	/* 818 */
	{15471, S_00B50C_MEM_BASE(~0u)},
	/* 819 */
	{13070, S_00B51C_CU_EN(~0u)},
	{15480, S_00B51C_WAVE_LIMIT(~0u)},
	{15491, S_00B51C_LOCK_LOW_THRESHOLD(~0u)},
	{15842, S_00B51C_GROUP_FIFO_DEPTH(~0u)},
	/* 823 */
	{15471, S_00B524_MEM_BASE(~0u)},
	/* 824 */
	{15510, S_00B528_VGPRS(~0u)},
	{15516, S_00B528_SGPRS(~0u)},
	{13337, S_00B528_PRIORITY(~0u)},
	{15565, S_00B528_FLOAT_MODE(~0u)},
	{15576, S_00B528_PRIV(~0u)},
	{15581, S_00B528_DX10_CLAMP(~0u)},
	{15592, S_00B528_DEBUG_MODE(~0u)},
	{15603, S_00B528_IEEE_MODE(~0u)},
	{15731, S_00B528_VGPR_COMP_CNT(~0u)},
	{15630, S_00B528_CACHE_CTL(~0u)},
	{15640, S_00B528_CDBG_USER(~0u)},
	/* 835 */
	{15650, S_00B52C_SCRATCH_EN(~0u)},
	{15661, S_00B52C_USER_SGPR(~0u)},
	{15671, S_00B52C_TRAP_PRESENT(~0u)},
	{15702, S_00B52C_LDS_SIZE(~0u)},
	{15711, S_00B52C_EXCP_EN(~0u)},
	/* 840 */
	{15870, S_00B800_COMPUTE_SHADER_EN(~0u)},
	{15888, S_00B800_PARTIAL_TG_EN(~0u)},
	{15902, S_00B800_FORCE_START_AT_000(~0u)},
	{15921, S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{15941, S_00B800_ORDERED_APPEND_MODE(~0u)},
	{15961, S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{15983, S_00B800_ORDER_MODE(~0u)},
	{15994, S_00B800_DISPATCH_CACHE_CNTL(~0u)},
	{16014, S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{16032, S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{16050, S_00B800_DATA_ATC(~0u)},
	{16059, S_00B800_RESTORE(~0u)},
	/* 852 */
	{16067, S_00B81C_NUM_THREAD_FULL(~0u)},
	{16083, S_00B81C_NUM_THREAD_PARTIAL(~0u)},
	/* 854 */
	{16067, S_00B820_NUM_THREAD_FULL(~0u)},
	{16083, S_00B820_NUM_THREAD_PARTIAL(~0u)},
	/* 856 */
	{16067, S_00B824_NUM_THREAD_FULL(~0u)},
	{16083, S_00B824_NUM_THREAD_PARTIAL(~0u)},
	/* 858 */
	{13114, S_00B82C_MAX_WAVE_ID(~0u)},
	/* 859 */
	{16102, S_00B828_PIPELINESTAT_ENABLE(~0u)},
	/* 860 */
	{16122, S_00B82C_PERFCOUNT_ENABLE(~0u)},
	/* 861 */
	{391, S_00B834_DATA(~0u)},
	{16139, S_00B834_INST_ATC(~0u)},
	/* 863 */
	{391, S_00B83C_DATA(~0u)},
	/* 864 */
	{391, S_00B844_DATA(~0u)},
	/* 865 */
	{15510, S_00B848_VGPRS(~0u)},
	{15516, S_00B848_SGPRS(~0u)},
	{13337, S_00B848_PRIORITY(~0u)},
	{15565, S_00B848_FLOAT_MODE(~0u)},
	{15576, S_00B848_PRIV(~0u)},
	{15581, S_00B848_DX10_CLAMP(~0u)},
	{15592, S_00B848_DEBUG_MODE(~0u)},
	{15603, S_00B848_IEEE_MODE(~0u)},
	{16148, S_00B848_BULKY(~0u)},
	{15640, S_00B848_CDBG_USER(~0u)},
	/* 875 */
	{15650, S_00B84C_SCRATCH_EN(~0u)},
	{15661, S_00B84C_USER_SGPR(~0u)},
	{15671, S_00B84C_TRAP_PRESENT(~0u)},
	{16154, S_00B84C_TGID_X_EN(~0u)},
	{16164, S_00B84C_TGID_Y_EN(~0u)},
	{16174, S_00B84C_TGID_Z_EN(~0u)},
	{15859, S_00B84C_TG_SIZE_EN(~0u)},
	{16184, S_00B84C_TIDIG_COMP_CNT(~0u)},
	{16199, S_00B84C_EXCP_EN_MSB(~0u)},
	{15702, S_00B84C_LDS_SIZE(~0u)},
	{15711, S_00B84C_EXCP_EN(~0u)},
	/* 886 */
	{391, S_00B850_DATA(~0u)},
	/* 887 */
	{16211, S_00B854_WAVES_PER_SH(~0u)},
	{16224, S_00B854_WAVES_PER_SH_CIK(~0u)},
	{16241, S_00B854_TG_PER_CU(~0u)},
	{16251, S_00B854_LOCK_THRESHOLD(~0u)},
	{16266, S_00B854_SIMD_DEST_CNTL(~0u)},
	{16281, S_00B854_FORCE_SIMD_DIST(~0u)},
	{16297, S_00B854_CU_GROUP_COUNT(~0u)},
	/* 894 */
	{16312, S_00B858_SH0_CU_EN(~0u)},
	{16322, S_00B858_SH1_CU_EN(~0u)},
	/* 896 */
	{16312, S_00B85C_SH0_CU_EN(~0u)},
	{16322, S_00B85C_SH1_CU_EN(~0u)},
	/* 898 */
	{16332, S_00B860_WAVES(~0u)},
	{16338, S_00B860_WAVESIZE(~0u)},
	/* 900 */
	{16312, S_00B864_SH0_CU_EN(~0u)},
	{16322, S_00B864_SH1_CU_EN(~0u)},
	/* 902 */
	{16312, S_00B868_SH0_CU_EN(~0u)},
	{16322, S_00B868_SH1_CU_EN(~0u)},
	/* 904 */
	{16347, S_00B87C_SEND_SEID(~0u)},
	{14519, S_00B87C_RESERVED2(~0u)},
	{16357, S_00B87C_RESERVED3(~0u)},
	{16367, S_00B87C_RESERVED4(~0u)},
	{16377, S_00B87C_WAVE_ID_BASE(~0u)},
	/* 909 */
	{16390, S_00B888_PAYLOAD(~0u)},
	{16398, S_00B888_IS_EVENT(~0u)},
	{16407, S_00B888_IS_STATE(~0u)},
	/* 912 */
	{910, S_00B890_ADDR(~0u)},
	/* 913 */
	{9259, S_00B894_ATC(~0u)},
	{9280, S_00B894_MTYPE(~0u)},
	/* 915 */
	{16416, S_034404_PERFCOUNTER_HI(~0u)},
	/* 916 */
	{16431, S_036004_PERF_SEL2(~0u)},
	{16441, S_036004_PERF_SEL3(~0u)},
	/* 918 */
	{16451, S_036008_PERF_SEL(~0u)},
	{16460, S_036008_PERF_SEL1(~0u)},
	{16470, S_036008_CNTR_MODE(~0u)},
	/* 921 */
	{16431, S_036010_PERF_SEL2(~0u)},
	{16441, S_036010_PERF_SEL3(~0u)},
	/* 923 */
	{16431, S_036018_PERF_SEL2(~0u)},
	{16441, S_036018_PERF_SEL3(~0u)},
	/* 925 */
	{16451, S_03601C_PERF_SEL(~0u)},
	{16460, S_03601C_PERF_SEL1(~0u)},
	{16470, S_03601C_CNTR_MODE(~0u)},
	/* 928 */
	{16527, S_036020_PERFMON_STATE(~0u), 3, 667},
	{16541, S_036020_SPM_PERFMON_STATE(~0u)},
	{16559, S_036020_PERFMON_ENABLE_MODE(~0u)},
	{16579, S_036020_PERFMON_SAMPLE_ENABLE(~0u)},
	/* 932 */
	{16451, S_036024_PERF_SEL(~0u)},
	{16460, S_036024_PERF_SEL1(~0u)},
	{16470, S_036024_CNTR_MODE(~0u)},
	/* 935 */
	{16451, S_036100_PERF_SEL(~0u)},
	{16601, S_036100_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16628, S_036100_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16655, S_036100_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16682, S_036100_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16708, S_036100_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16734, S_036100_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16761, S_036100_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16787, S_036100_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16813, S_036100_GRBM_BUSY_USER_DEFINED_MASK(~0u)},
	{16841, S_036100_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16867, S_036100_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16893, S_036100_CP_BUSY_USER_DEFINED_MASK(~0u)},
	{16919, S_036100_IA_BUSY_USER_DEFINED_MASK(~0u)},
	{16945, S_036100_GDS_BUSY_USER_DEFINED_MASK(~0u)},
	{16972, S_036100_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{16999, S_036100_RLC_BUSY_USER_DEFINED_MASK(~0u)},
	{17026, S_036100_TC_BUSY_USER_DEFINED_MASK(~0u)},
	{17052, S_036100_WD_BUSY_USER_DEFINED_MASK(~0u)},
	/* 954 */
	{16451, S_036108_PERF_SEL(~0u)},
	{16601, S_036108_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16628, S_036108_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16682, S_036108_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16708, S_036108_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16734, S_036108_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16761, S_036108_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16841, S_036108_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16867, S_036108_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16655, S_036108_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16787, S_036108_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16972, S_036108_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 966 */
	{16451, S_03610C_PERF_SEL(~0u)},
	{16601, S_03610C_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16628, S_03610C_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16682, S_03610C_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16708, S_03610C_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16734, S_03610C_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16761, S_03610C_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16841, S_03610C_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16867, S_03610C_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16655, S_03610C_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16787, S_03610C_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16972, S_03610C_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 978 */
	{16451, S_036110_PERF_SEL(~0u)},
	{16601, S_036110_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16628, S_036110_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16682, S_036110_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16708, S_036110_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16734, S_036110_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16761, S_036110_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16841, S_036110_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16867, S_036110_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16655, S_036110_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16787, S_036110_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16972, S_036110_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 990 */
	{16451, S_036114_PERF_SEL(~0u)},
	{16601, S_036114_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16628, S_036114_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16682, S_036114_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16708, S_036114_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16734, S_036114_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16761, S_036114_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16841, S_036114_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16867, S_036114_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16655, S_036114_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16787, S_036114_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16972, S_036114_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1002 */
	{16451, S_036200_PERF_SEL(~0u)},
	{17078, S_036200_PERF_MODE(~0u)},
	/* 1004 */
	{16451, S_036210_PERF_SEL(~0u)},
	{16460, S_036210_PERF_SEL1(~0u)},
	{16470, S_036210_CNTR_MODE(~0u)},
	{17088, S_036210_PERF_MODE1(~0u)},
	{17078, S_036210_PERF_MODE(~0u)},
	/* 1009 */
	{16431, S_036220_PERF_SEL2(~0u)},
	{16441, S_036220_PERF_SEL3(~0u)},
	{17099, S_036220_PERF_MODE3(~0u)},
	{17110, S_036220_PERF_MODE2(~0u)},
	/* 1013 */
	{16451, S_036230_PERF_SEL(~0u)},
	{16460, S_036230_PERF_SEL1(~0u)},
	{16470, S_036230_CNTR_MODE(~0u)},
	{17088, S_036230_PERF_MODE1(~0u)},
	{17078, S_036230_PERF_MODE(~0u)},
	/* 1018 */
	{16431, S_036240_PERF_SEL2(~0u)},
	{16441, S_036240_PERF_SEL3(~0u)},
	{17099, S_036240_PERF_MODE3(~0u)},
	{17110, S_036240_PERF_MODE2(~0u)},
	/* 1022 */
	{17121, S_036250_PERF_SEID_IGNORE_MASK(~0u)},
	/* 1023 */
	{16451, S_036400_PERF_SEL(~0u)},
	{16460, S_036400_PERF_SEL1(~0u)},
	{16470, S_036400_CNTR_MODE(~0u)},
	/* 1026 */
	{16431, S_036404_PERF_SEL2(~0u)},
	{16441, S_036404_PERF_SEL3(~0u)},
	/* 1028 */
	{16451, S_036500_PERF_SEL(~0u)},
	{16460, S_036500_PERF_SEL1(~0u)},
	{16470, S_036500_CNTR_MODE(~0u)},
	/* 1031 */
	{16431, S_036504_PERF_SEL2(~0u)},
	{16441, S_036504_PERF_SEL3(~0u)},
	/* 1033 */
	{16451, S_036600_PERF_SEL(~0u)},
	{16460, S_036600_PERF_SEL1(~0u)},
	{16470, S_036600_CNTR_MODE(~0u)},
	/* 1036 */
	{16431, S_036610_PERF_SEL2(~0u)},
	{16441, S_036610_PERF_SEL3(~0u)},
	/* 1038 */
	{17143, S_036628_BIN0_MIN(~0u)},
	{17152, S_036628_BIN0_MAX(~0u)},
	{17161, S_036628_BIN1_MIN(~0u)},
	{17170, S_036628_BIN1_MAX(~0u)},
	{17179, S_036628_BIN2_MIN(~0u)},
	{17188, S_036628_BIN2_MAX(~0u)},
	{17197, S_036628_BIN3_MIN(~0u)},
	{17206, S_036628_BIN3_MAX(~0u)},
	/* 1046 */
	{16451, S_036700_PERF_SEL(~0u)},
	{17215, S_036700_SQC_BANK_MASK(~0u)},
	{17229, S_036700_SQC_CLIENT_MASK(~0u)},
	{17245, S_036700_SPM_MODE(~0u)},
	{17254, S_036700_SIMD_MASK(~0u)},
	{17078, S_036700_PERF_MODE(~0u)},
	/* 1052 */
	{17264, S_036780_PS_EN(~0u)},
	{17270, S_036780_VS_EN(~0u)},
	{17276, S_036780_GS_EN(~0u)},
	{17282, S_036780_ES_EN(~0u)},
	{17288, S_036780_HS_EN(~0u)},
	{17294, S_036780_LS_EN(~0u)},
	{17300, S_036780_CS_EN(~0u)},
	{17306, S_036780_CNTR_RATE(~0u)},
	{17316, S_036780_DISABLE_FLUSH(~0u)},
	/* 1061 */
	{17330, S_036784_SH0_MASK(~0u)},
	{17339, S_036784_SH1_MASK(~0u)},
	/* 1063 */
	{17348, S_036788_FORCE_EN(~0u)},
	/* 1064 */
	{17357, S_036900_PERFCOUNTER_SELECT(~0u)},
	{17376, S_036900_PERFCOUNTER_SELECT1(~0u)},
	{16470, S_036900_CNTR_MODE(~0u)},
	/* 1067 */
	{17396, S_036910_PERFCOUNTER_SELECT2(~0u)},
	{17416, S_036910_PERFCOUNTER_SELECT3(~0u)},
	/* 1069 */
	{17357, S_036A00_PERFCOUNTER_SELECT(~0u)},
	{17376, S_036A00_PERFCOUNTER_SELECT1(~0u)},
	{16470, S_036A00_CNTR_MODE(~0u)},
	/* 1072 */
	{17396, S_036A10_PERFCOUNTER_SELECT2(~0u)},
	{17416, S_036A10_PERFCOUNTER_SELECT3(~0u)},
	/* 1074 */
	{16451, S_036B00_PERF_SEL(~0u)},
	{16460, S_036B00_PERF_SEL1(~0u)},
	{16470, S_036B00_CNTR_MODE(~0u)},
	{17088, S_036B00_PERF_MODE1(~0u)},
	{17078, S_036B00_PERF_MODE(~0u)},
	/* 1079 */
	{16431, S_036B04_PERF_SEL2(~0u)},
	{16441, S_036B04_PERF_SEL3(~0u)},
	{17099, S_036B04_PERF_MODE3(~0u)},
	{17110, S_036B04_PERF_MODE2(~0u)},
	/* 1083 */
	{16451, S_036C00_PERF_SEL(~0u)},
	{16460, S_036C00_PERF_SEL1(~0u)},
	{16470, S_036C00_CNTR_MODE(~0u)},
	{17088, S_036C00_PERF_MODE1(~0u)},
	{17078, S_036C00_PERF_MODE(~0u)},
	/* 1088 */
	{16431, S_036C04_PERF_SEL2(~0u)},
	{16441, S_036C04_PERF_SEL3(~0u)},
	{17099, S_036C04_PERF_MODE3(~0u)},
	{17110, S_036C04_PERF_MODE2(~0u)},
	/* 1092 */
	{16451, S_036D00_PERF_SEL(~0u)},
	{16460, S_036D00_PERF_SEL1(~0u)},
	{16470, S_036D00_CNTR_MODE(~0u)},
	{17088, S_036D00_PERF_MODE1(~0u)},
	{17078, S_036D00_PERF_MODE(~0u)},
	/* 1097 */
	{16431, S_036D04_PERF_SEL2(~0u)},
	{16441, S_036D04_PERF_SEL3(~0u)},
	{17099, S_036D04_PERF_MODE3(~0u)},
	{17110, S_036D04_PERF_MODE2(~0u)},
	/* 1101 */
	{16451, S_036E00_PERF_SEL(~0u)},
	{16460, S_036E00_PERF_SEL1(~0u)},
	{16470, S_036E00_CNTR_MODE(~0u)},
	{17088, S_036E00_PERF_MODE1(~0u)},
	{17078, S_036E00_PERF_MODE(~0u)},
	/* 1106 */
	{16431, S_036E04_PERF_SEL2(~0u)},
	{16441, S_036E04_PERF_SEL3(~0u)},
	{17110, S_036E04_PERF_MODE2(~0u)},
	{17099, S_036E04_PERF_MODE3(~0u)},
	/* 1110 */
	{16451, S_036E40_PERF_SEL(~0u)},
	{16460, S_036E40_PERF_SEL1(~0u)},
	{16470, S_036E40_CNTR_MODE(~0u)},
	{17088, S_036E40_PERF_MODE1(~0u)},
	{17078, S_036E40_PERF_MODE(~0u)},
	/* 1115 */
	{16431, S_036E44_PERF_SEL2(~0u)},
	{16441, S_036E44_PERF_SEL3(~0u)},
	{17110, S_036E44_PERF_MODE2(~0u)},
	{17099, S_036E44_PERF_MODE3(~0u)},
	/* 1119 */
	{17436, S_037000_OP_FILTER_ENABLE(~0u)},
	{17453, S_037000_OP_FILTER_SEL(~0u)},
	{17467, S_037000_FORMAT_FILTER_ENABLE(~0u)},
	{17488, S_037000_FORMAT_FILTER_SEL(~0u)},
	{17506, S_037000_CLEAR_FILTER_ENABLE(~0u)},
	{17526, S_037000_CLEAR_FILTER_SEL(~0u)},
	{17543, S_037000_MRT_FILTER_ENABLE(~0u)},
	{17561, S_037000_MRT_FILTER_SEL(~0u)},
	{17576, S_037000_NUM_SAMPLES_FILTER_ENABLE(~0u)},
	{17602, S_037000_NUM_SAMPLES_FILTER_SEL(~0u)},
	{17625, S_037000_NUM_FRAGMENTS_FILTER_ENABLE(~0u)},
	{17653, S_037000_NUM_FRAGMENTS_FILTER_SEL(~0u)},
	/* 1131 */
	{16451, S_037004_PERF_SEL(~0u)},
	{16460, S_037004_PERF_SEL1(~0u)},
	{16470, S_037004_CNTR_MODE(~0u)},
	{17088, S_037004_PERF_MODE1(~0u)},
	{17078, S_037004_PERF_MODE(~0u)},
	/* 1136 */
	{16431, S_037008_PERF_SEL2(~0u)},
	{16441, S_037008_PERF_SEL3(~0u)},
	{17099, S_037008_PERF_MODE3(~0u)},
	{17110, S_037008_PERF_MODE2(~0u)},
	/* 1140 */
	{16451, S_037100_PERF_SEL(~0u)},
	{16460, S_037100_PERF_SEL1(~0u)},
	{16470, S_037100_CNTR_MODE(~0u)},
	{17088, S_037100_PERF_MODE1(~0u)},
	{17078, S_037100_PERF_MODE(~0u)},
	/* 1145 */
	{16431, S_037104_PERF_SEL2(~0u)},
	{16441, S_037104_PERF_SEL3(~0u)},
	{17099, S_037104_PERF_MODE3(~0u)},
	{17110, S_037104_PERF_MODE2(~0u)},
	/* 1149 */
	{17678, S_028000_DEPTH_CLEAR_ENABLE(~0u)},
	{17697, S_028000_STENCIL_CLEAR_ENABLE(~0u)},
	{17718, S_028000_DEPTH_COPY(~0u)},
	{17729, S_028000_STENCIL_COPY(~0u)},
	{17742, S_028000_RESUMMARIZE_ENABLE(~0u)},
	{17761, S_028000_STENCIL_COMPRESS_DISABLE(~0u)},
	{17786, S_028000_DEPTH_COMPRESS_DISABLE(~0u)},
	{17809, S_028000_COPY_CENTROID(~0u)},
	{17823, S_028000_COPY_SAMPLE(~0u)},
	{17835, S_028000_DECOMPRESS_ENABLE(~0u)},
	/* 1159 */
	{17853, S_028004_ZPASS_INCREMENT_DISABLE(~0u)},
	{17877, S_028004_PERFECT_ZPASS_COUNTS(~0u)},
	{17898, S_028004_SAMPLE_RATE(~0u)},
	{17910, S_028004_ZPASS_ENABLE(~0u)},
	{17923, S_028004_ZFAIL_ENABLE(~0u)},
	{17936, S_028004_SFAIL_ENABLE(~0u)},
	{17949, S_028004_DBFAIL_ENABLE(~0u)},
	{17963, S_028004_SLICE_EVEN_ENABLE(~0u)},
	{17981, S_028004_SLICE_ODD_ENABLE(~0u)},
	/* 1168 */
	{17998, S_028008_SLICE_START(~0u)},
	{18010, S_028008_SLICE_MAX(~0u)},
	{18020, S_028008_Z_READ_ONLY(~0u)},
	{18032, S_028008_STENCIL_READ_ONLY(~0u)},
	/* 1172 */
	{18102, S_02800C_FORCE_HIZ_ENABLE(~0u), 4, 670},
	{18119, S_02800C_FORCE_HIS_ENABLE0(~0u), 4, 670},
	{18137, S_02800C_FORCE_HIS_ENABLE1(~0u), 4, 670},
	{18155, S_02800C_FORCE_SHADER_Z_ORDER(~0u)},
	{18176, S_02800C_FAST_Z_DISABLE(~0u)},
	{18191, S_02800C_FAST_STENCIL_DISABLE(~0u)},
	{18212, S_02800C_NOOP_CULL_DISABLE(~0u)},
	{18230, S_02800C_FORCE_COLOR_KILL(~0u)},
	{18247, S_02800C_FORCE_Z_READ(~0u)},
	{18260, S_02800C_FORCE_STENCIL_READ(~0u)},
	{18279, S_02800C_FORCE_FULL_Z_RANGE(~0u), 4, 670},
	{18298, S_02800C_FORCE_QC_SMASK_CONFLICT(~0u)},
	{18322, S_02800C_DISABLE_VIEWPORT_CLAMP(~0u)},
	{18345, S_02800C_IGNORE_SC_ZRANGE(~0u)},
	{18362, S_02800C_DISABLE_FULLY_COVERED(~0u)},
	{18447, S_02800C_FORCE_Z_LIMIT_SUMM(~0u), 4, 674},
	{18466, S_02800C_MAX_TILES_IN_DTT(~0u)},
	{18483, S_02800C_DISABLE_TILE_RATE_TILES(~0u)},
	{18507, S_02800C_FORCE_Z_DIRTY(~0u)},
	{18521, S_02800C_FORCE_STENCIL_DIRTY(~0u)},
	{18541, S_02800C_FORCE_Z_VALID(~0u)},
	{18555, S_02800C_FORCE_STENCIL_VALID(~0u)},
	{18575, S_02800C_PRESERVE_COMPRESSION(~0u)},
	/* 1195 */
	{18649, S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), 4, 678},
	{18678, S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{18709, S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{18745, S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{18780, S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{18808, S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{18830, S_028010_DISABLE_REG_SNOOP(~0u)},
	{18848, S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{18880, S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{18906, S_028010_HIZ_ZFUNC(~0u)},
	{18916, S_028010_HIS_SFUNC_FF(~0u)},
	{18929, S_028010_HIS_SFUNC_BF(~0u)},
	{18942, S_028010_PRESERVE_ZRANGE(~0u)},
	{18958, S_028010_PRESERVE_SRESULTS(~0u)},
	{18976, S_028010_DISABLE_FAST_PASS(~0u)},
	/* 1210 */
	{18994, S_028028_CLEAR(~0u)},
	/* 1211 */
	{19000, S_028030_TL_X(~0u)},
	{19005, S_028030_TL_Y(~0u)},
	/* 1213 */
	{19010, S_028034_BR_X(~0u)},
	{19015, S_028034_BR_Y(~0u)},
	/* 1215 */
	{19020, S_02803C_ADDR5_SWIZZLE_MASK(~0u)},
	{14436, S_02803C_ARRAY_MODE(~0u), 7, 682},
	{14798, S_02803C_PIPE_CONFIG(~0u), 18, 689},
	{15091, S_02803C_BANK_WIDTH(~0u), 4, 406},
	{15198, S_02803C_BANK_HEIGHT(~0u), 4, 410},
	{15310, S_02803C_MACRO_TILE_ASPECT(~0u), 4, 414},
	{15397, S_02803C_NUM_BANKS(~0u), 4, 418},
	/* 1222 */
	{8818, S_028040_FORMAT(~0u), 4, 707},
	{19172, S_028040_NUM_SAMPLES(~0u)},
	{14988, S_028040_TILE_SPLIT(~0u), 7, 399},
	{19184, S_028040_TILE_MODE_INDEX(~0u)},
	{19200, S_028040_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{19224, S_028040_ALLOW_EXPCLEAR(~0u)},
	{19239, S_028040_READ_SIZE(~0u)},
	{19249, S_028040_TILE_SURFACE_ENABLE(~0u)},
	{19269, S_028040_CLEAR_DISALLOWED(~0u)},
	{19286, S_028040_ZRANGE_PRECISION(~0u)},
	/* 1232 */
	{8818, S_028044_FORMAT(~0u), 2, 711},
	{14988, S_028044_TILE_SPLIT(~0u), 7, 399},
	{19184, S_028044_TILE_MODE_INDEX(~0u)},
	{19224, S_028044_ALLOW_EXPCLEAR(~0u)},
	{19329, S_028044_TILE_STENCIL_DISABLE(~0u)},
	{19269, S_028044_CLEAR_DISALLOWED(~0u)},
	/* 1238 */
	{19350, S_028058_PITCH_TILE_MAX(~0u)},
	{19365, S_028058_HEIGHT_TILE_MAX(~0u)},
	/* 1240 */
	{19381, S_02805C_SLICE_TILE_MAX(~0u)},
	/* 1241 */
	{8441, S_028084_ADDRESS(~0u)},
	/* 1242 */
	{19396, S_028200_WINDOW_X_OFFSET(~0u)},
	{19412, S_028200_WINDOW_Y_OFFSET(~0u)},
	/* 1244 */
	{19000, S_028204_TL_X(~0u)},
	{19005, S_028204_TL_Y(~0u)},
	{19428, S_028204_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1247 */
	{19010, S_028208_BR_X(~0u)},
	{19015, S_028208_BR_Y(~0u)},
	/* 1249 */
	{19450, S_02820C_CLIP_RULE(~0u)},
	/* 1250 */
	{19000, S_028210_TL_X(~0u)},
	{19005, S_028210_TL_Y(~0u)},
	/* 1252 */
	{19010, S_028214_BR_X(~0u)},
	{19015, S_028214_BR_Y(~0u)},
	/* 1254 */
	{19460, S_028230_ER_TRI(~0u)},
	{12543, S_028230_ER_POINT(~0u)},
	{19467, S_028230_ER_RECT(~0u)},
	{19475, S_028230_ER_LINE_LR(~0u)},
	{19486, S_028230_ER_LINE_RL(~0u)},
	{19497, S_028230_ER_LINE_TB(~0u)},
	{19508, S_028230_ER_LINE_BT(~0u)},
	/* 1261 */
	{19519, S_028234_HW_SCREEN_OFFSET_X(~0u)},
	{19538, S_028234_HW_SCREEN_OFFSET_Y(~0u)},
	/* 1263 */
	{19557, S_028238_TARGET0_ENABLE(~0u)},
	{19572, S_028238_TARGET1_ENABLE(~0u)},
	{19587, S_028238_TARGET2_ENABLE(~0u)},
	{19602, S_028238_TARGET3_ENABLE(~0u)},
	{19617, S_028238_TARGET4_ENABLE(~0u)},
	{19632, S_028238_TARGET5_ENABLE(~0u)},
	{19647, S_028238_TARGET6_ENABLE(~0u)},
	{19662, S_028238_TARGET7_ENABLE(~0u)},
	/* 1271 */
	{19677, S_02823C_OUTPUT0_ENABLE(~0u)},
	{19692, S_02823C_OUTPUT1_ENABLE(~0u)},
	{19707, S_02823C_OUTPUT2_ENABLE(~0u)},
	{19722, S_02823C_OUTPUT3_ENABLE(~0u)},
	{19737, S_02823C_OUTPUT4_ENABLE(~0u)},
	{19752, S_02823C_OUTPUT5_ENABLE(~0u)},
	{19767, S_02823C_OUTPUT6_ENABLE(~0u)},
	{19782, S_02823C_OUTPUT7_ENABLE(~0u)},
	/* 1279 */
	{19000, S_028240_TL_X(~0u)},
	{19005, S_028240_TL_Y(~0u)},
	{19428, S_028240_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1282 */
	{19010, S_028244_BR_X(~0u)},
	{19015, S_028244_BR_Y(~0u)},
	/* 1284 */
	{19000, S_028250_TL_X(~0u)},
	{19005, S_028250_TL_Y(~0u)},
	{19428, S_028250_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1287 */
	{19010, S_028254_BR_X(~0u)},
	{19015, S_028254_BR_Y(~0u)},
	/* 1289 */
	{19889, S_028350_RB_MAP_PKR0(~0u), 4, 713},
	{19901, S_028350_RB_MAP_PKR1(~0u), 4, 713},
	{20013, S_028350_RB_XSEL2(~0u), 4, 717},
	{20022, S_028350_RB_XSEL(~0u)},
	{20030, S_028350_RB_YSEL(~0u)},
	{20134, S_028350_PKR_MAP(~0u), 4, 721},
	{20242, S_028350_PKR_XSEL(~0u), 4, 725},
	{20351, S_028350_PKR_YSEL(~0u), 4, 729},
	{20464, S_028350_PKR_XSEL2(~0u), 4, 733},
	{20566, S_028350_SC_MAP(~0u), 4, 737},
	{20712, S_028350_SC_XSEL(~0u), 4, 741},
	{20859, S_028350_SC_YSEL(~0u), 4, 745},
	{20959, S_028350_SE_MAP(~0u), 4, 749},
	{21105, S_028350_SE_XSEL(~0u), 4, 753},
	{21252, S_028350_SE_YSEL(~0u), 4, 757},
	/* 1304 */
	{21372, S_028354_SE_PAIR_MAP(~0u), 4, 761},
	{21543, S_028354_SE_PAIR_XSEL(~0u), 4, 765},
	{21715, S_028354_SE_PAIR_YSEL(~0u), 4, 769},
	/* 1307 */
	{17963, S_028358_SLICE_EVEN_ENABLE(~0u)},
	{17981, S_028358_SLICE_ODD_ENABLE(~0u)},
	/* 1309 */
	{21728, S_028424_OVERWRITE_COMBINER_DISABLE(~0u)},
	{21755, S_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(~0u)},
	{21794, S_028424_OVERWRITE_COMBINER_WATERMARK(~0u)},
	/* 1312 */
	{22060, S_02842C_STENCILFAIL(~0u), 16, 773},
	{22072, S_02842C_STENCILZPASS(~0u), 16, 773},
	{22085, S_02842C_STENCILZFAIL(~0u), 16, 773},
	{22098, S_02842C_STENCILFAIL_BF(~0u), 16, 773},
	{22113, S_02842C_STENCILZPASS_BF(~0u), 16, 773},
	{22129, S_02842C_STENCILZFAIL_BF(~0u), 16, 773},
	/* 1318 */
	{22145, S_028430_STENCILTESTVAL(~0u)},
	{22160, S_028430_STENCILMASK(~0u)},
	{22172, S_028430_STENCILWRITEMASK(~0u)},
	{22189, S_028430_STENCILOPVAL(~0u)},
	/* 1322 */
	{22202, S_028434_STENCILTESTVAL_BF(~0u)},
	{22220, S_028434_STENCILMASK_BF(~0u)},
	{22235, S_028434_STENCILWRITEMASK_BF(~0u)},
	{22255, S_028434_STENCILOPVAL_BF(~0u)},
	/* 1326 */
	{673, S_028644_OFFSET(~0u)},
	{22278, S_028644_DEFAULT_VAL(~0u), 1, 789},
	{22290, S_028644_FLAT_SHADE(~0u)},
	{22301, S_028644_CYL_WRAP(~0u)},
	{22310, S_028644_PT_SPRITE_TEX(~0u)},
	{22324, S_028644_DUP(~0u)},
	{22328, S_028644_FP16_INTERP_MODE(~0u)},
	{22345, S_028644_USE_DEFAULT_ATTR1(~0u)},
	{22363, S_028644_DEFAULT_VAL_ATTR1(~0u)},
	{22381, S_028644_PT_SPRITE_TEX_ATTR1(~0u)},
	{22401, S_028644_ATTR0_VALID(~0u)},
	{22413, S_028644_ATTR1_VALID(~0u)},
	/* 1338 */
	{22425, S_0286C4_VS_EXPORT_COUNT(~0u)},
	{22441, S_0286C4_VS_HALF_PACK(~0u)},
	{22454, S_0286C4_VS_EXPORTS_FOG(~0u)},
	{22469, S_0286C4_VS_OUT_FOG_VEC_ADDR(~0u)},
	/* 1342 */
	{22489, S_0286CC_PERSP_SAMPLE_ENA(~0u)},
	{22506, S_0286CC_PERSP_CENTER_ENA(~0u)},
	{22523, S_0286CC_PERSP_CENTROID_ENA(~0u)},
	{22542, S_0286CC_PERSP_PULL_MODEL_ENA(~0u)},
	{22563, S_0286CC_LINEAR_SAMPLE_ENA(~0u)},
	{22581, S_0286CC_LINEAR_CENTER_ENA(~0u)},
	{22599, S_0286CC_LINEAR_CENTROID_ENA(~0u)},
	{22619, S_0286CC_LINE_STIPPLE_TEX_ENA(~0u)},
	{22640, S_0286CC_POS_X_FLOAT_ENA(~0u)},
	{22656, S_0286CC_POS_Y_FLOAT_ENA(~0u)},
	{22672, S_0286CC_POS_Z_FLOAT_ENA(~0u)},
	{22688, S_0286CC_POS_W_FLOAT_ENA(~0u)},
	{22704, S_0286CC_FRONT_FACE_ENA(~0u)},
	{22719, S_0286CC_ANCILLARY_ENA(~0u)},
	{22733, S_0286CC_SAMPLE_COVERAGE_ENA(~0u)},
	{22753, S_0286CC_POS_FIXED_PT_ENA(~0u)},
	/* 1358 */
	{22489, S_0286D0_PERSP_SAMPLE_ENA(~0u)},
	{22506, S_0286D0_PERSP_CENTER_ENA(~0u)},
	{22523, S_0286D0_PERSP_CENTROID_ENA(~0u)},
	{22542, S_0286D0_PERSP_PULL_MODEL_ENA(~0u)},
	{22563, S_0286D0_LINEAR_SAMPLE_ENA(~0u)},
	{22581, S_0286D0_LINEAR_CENTER_ENA(~0u)},
	{22599, S_0286D0_LINEAR_CENTROID_ENA(~0u)},
	{22619, S_0286D0_LINE_STIPPLE_TEX_ENA(~0u)},
	{22640, S_0286D0_POS_X_FLOAT_ENA(~0u)},
	{22656, S_0286D0_POS_Y_FLOAT_ENA(~0u)},
	{22672, S_0286D0_POS_Z_FLOAT_ENA(~0u)},
	{22688, S_0286D0_POS_W_FLOAT_ENA(~0u)},
	{22704, S_0286D0_FRONT_FACE_ENA(~0u)},
	{22719, S_0286D0_ANCILLARY_ENA(~0u)},
	{22733, S_0286D0_SAMPLE_COVERAGE_ENA(~0u)},
	{22753, S_0286D0_POS_FIXED_PT_ENA(~0u)},
	/* 1374 */
	{22770, S_0286D4_FLAT_SHADE_ENA(~0u)},
	{22785, S_0286D4_PNT_SPRITE_ENA(~0u)},
	{22908, S_0286D4_PNT_SPRITE_OVRD_X(~0u), 5, 790},
	{22926, S_0286D4_PNT_SPRITE_OVRD_Y(~0u), 5, 790},
	{22944, S_0286D4_PNT_SPRITE_OVRD_Z(~0u), 5, 790},
	{22962, S_0286D4_PNT_SPRITE_OVRD_W(~0u), 5, 790},
	{22980, S_0286D4_PNT_SPRITE_TOP_1(~0u)},
	/* 1381 */
	{22997, S_0286D8_NUM_INTERP(~0u)},
	{23008, S_0286D8_PARAM_GEN(~0u)},
	{23018, S_0286D8_FOG_ADDR(~0u)},
	{23027, S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	{23047, S_0286D8_PASS_FOG_THROUGH_PS(~0u)},
	/* 1386 */
	{23067, S_0286E0_PERSP_CENTER_CNTL(~0u)},
	{23085, S_0286E0_PERSP_CENTROID_CNTL(~0u)},
	{23105, S_0286E0_LINEAR_CENTER_CNTL(~0u)},
	{23124, S_0286E0_LINEAR_CENTROID_CNTL(~0u)},
	{23194, S_0286E0_POS_FLOAT_LOCATION(~0u), 1, 795},
	{23213, S_0286E0_POS_FLOAT_ULC(~0u)},
	{23227, S_0286E0_FRONT_FACE_ALL_BITS(~0u)},
	/* 1393 */
	{16332, S_0286E8_WAVES(~0u)},
	{16338, S_0286E8_WAVESIZE(~0u)},
	/* 1395 */
	{23247, S_028704_NUM_PS_WAVES(~0u)},
	{23260, S_028704_NUM_VS_WAVES(~0u)},
	{23273, S_028704_NUM_GS_WAVES(~0u)},
	{23286, S_028704_NUM_ES_WAVES(~0u)},
	{23299, S_028704_NUM_HS_WAVES(~0u)},
	/* 1400 */
	{23312, S_028708_NUM_LS_WAVES(~0u)},
	/* 1401 */
	{23413, S_02870C_POS0_EXPORT_FORMAT(~0u), 5, 796},
	{23432, S_02870C_POS1_EXPORT_FORMAT(~0u), 5, 796},
	{23451, S_02870C_POS2_EXPORT_FORMAT(~0u), 5, 796},
	{23470, S_02870C_POS3_EXPORT_FORMAT(~0u), 5, 796},
	/* 1405 */
	{23689, S_028710_Z_EXPORT_FORMAT(~0u), 10, 801},
	/* 1406 */
	{23705, S_028714_COL0_EXPORT_FORMAT(~0u), 10, 801},
	{23724, S_028714_COL1_EXPORT_FORMAT(~0u), 10, 801},
	{23743, S_028714_COL2_EXPORT_FORMAT(~0u), 10, 801},
	{23762, S_028714_COL3_EXPORT_FORMAT(~0u), 10, 801},
	{23781, S_028714_COL4_EXPORT_FORMAT(~0u), 10, 801},
	{23800, S_028714_COL5_EXPORT_FORMAT(~0u), 10, 801},
	{23819, S_028714_COL6_EXPORT_FORMAT(~0u), 10, 801},
	{23838, S_028714_COL7_EXPORT_FORMAT(~0u), 10, 801},
	/* 1414 */
	{24092, S_028754_MRT0(~0u), 11, 811},
	{24097, S_028754_MRT1(~0u)},
	{24102, S_028754_MRT2(~0u)},
	{24107, S_028754_MRT3(~0u)},
	{24112, S_028754_MRT4(~0u)},
	{24117, S_028754_MRT5(~0u)},
	{24122, S_028754_MRT6(~0u)},
	{24127, S_028754_MRT7(~0u)},
	/* 1422 */
	{24212, S_028758_MRT0_EPSILON(~0u), 16, 822},
	{24225, S_028758_MRT1_EPSILON(~0u)},
	{24238, S_028758_MRT2_EPSILON(~0u)},
	{24251, S_028758_MRT3_EPSILON(~0u)},
	{24264, S_028758_MRT4_EPSILON(~0u)},
	{24277, S_028758_MRT5_EPSILON(~0u)},
	{24290, S_028758_MRT6_EPSILON(~0u)},
	{24303, S_028758_MRT7_EPSILON(~0u)},
	/* 1430 */
	{24316, S_02875C_MRT0_COLOR_OPT_DISABLE(~0u)},
	{24339, S_02875C_MRT0_ALPHA_OPT_DISABLE(~0u)},
	{24362, S_02875C_MRT1_COLOR_OPT_DISABLE(~0u)},
	{24385, S_02875C_MRT1_ALPHA_OPT_DISABLE(~0u)},
	{24408, S_02875C_MRT2_COLOR_OPT_DISABLE(~0u)},
	{24431, S_02875C_MRT2_ALPHA_OPT_DISABLE(~0u)},
	{24454, S_02875C_MRT3_COLOR_OPT_DISABLE(~0u)},
	{24477, S_02875C_MRT3_ALPHA_OPT_DISABLE(~0u)},
	{24500, S_02875C_MRT4_COLOR_OPT_DISABLE(~0u)},
	{24523, S_02875C_MRT4_ALPHA_OPT_DISABLE(~0u)},
	{24546, S_02875C_MRT5_COLOR_OPT_DISABLE(~0u)},
	{24569, S_02875C_MRT5_ALPHA_OPT_DISABLE(~0u)},
	{24592, S_02875C_MRT6_COLOR_OPT_DISABLE(~0u)},
	{24615, S_02875C_MRT6_ALPHA_OPT_DISABLE(~0u)},
	{24638, S_02875C_MRT7_COLOR_OPT_DISABLE(~0u)},
	{24661, S_02875C_MRT7_ALPHA_OPT_DISABLE(~0u)},
	{24684, S_02875C_PIXEN_ZERO_OPT_DISABLE(~0u)},
	/* 1447 */
	{24975, S_028760_COLOR_SRC_OPT(~0u), 8, 838},
	{24989, S_028760_COLOR_DST_OPT(~0u)},
	{25137, S_028760_COLOR_COMB_FCN(~0u), 8, 846},
	{25152, S_028760_ALPHA_SRC_OPT(~0u)},
	{25166, S_028760_ALPHA_DST_OPT(~0u)},
	{25180, S_028760_ALPHA_COMB_FCN(~0u)},
	/* 1453 */
	{24975, S_028764_COLOR_SRC_OPT(~0u)},
	{24989, S_028764_COLOR_DST_OPT(~0u)},
	{25137, S_028764_COLOR_COMB_FCN(~0u)},
	{25152, S_028764_ALPHA_SRC_OPT(~0u)},
	{25166, S_028764_ALPHA_DST_OPT(~0u)},
	{25180, S_028764_ALPHA_COMB_FCN(~0u)},
	/* 1459 */
	{24975, S_028768_COLOR_SRC_OPT(~0u)},
	{24989, S_028768_COLOR_DST_OPT(~0u)},
	{25137, S_028768_COLOR_COMB_FCN(~0u)},
	{25152, S_028768_ALPHA_SRC_OPT(~0u)},
	{25166, S_028768_ALPHA_DST_OPT(~0u)},
	{25180, S_028768_ALPHA_COMB_FCN(~0u)},
	/* 1465 */
	{24975, S_02876C_COLOR_SRC_OPT(~0u)},
	{24989, S_02876C_COLOR_DST_OPT(~0u)},
	{25137, S_02876C_COLOR_COMB_FCN(~0u)},
	{25152, S_02876C_ALPHA_SRC_OPT(~0u)},
	{25166, S_02876C_ALPHA_DST_OPT(~0u)},
	{25180, S_02876C_ALPHA_COMB_FCN(~0u)},
	/* 1471 */
	{24975, S_028770_COLOR_SRC_OPT(~0u)},
	{24989, S_028770_COLOR_DST_OPT(~0u)},
	{25137, S_028770_COLOR_COMB_FCN(~0u)},
	{25152, S_028770_ALPHA_SRC_OPT(~0u)},
	{25166, S_028770_ALPHA_DST_OPT(~0u)},
	{25180, S_028770_ALPHA_COMB_FCN(~0u)},
	/* 1477 */
	{24975, S_028774_COLOR_SRC_OPT(~0u)},
	{24989, S_028774_COLOR_DST_OPT(~0u)},
	{25137, S_028774_COLOR_COMB_FCN(~0u)},
	{25152, S_028774_ALPHA_SRC_OPT(~0u)},
	{25166, S_028774_ALPHA_DST_OPT(~0u)},
	{25180, S_028774_ALPHA_COMB_FCN(~0u)},
	/* 1483 */
	{24975, S_028778_COLOR_SRC_OPT(~0u)},
	{24989, S_028778_COLOR_DST_OPT(~0u)},
	{25137, S_028778_COLOR_COMB_FCN(~0u)},
	{25152, S_028778_ALPHA_SRC_OPT(~0u)},
	{25166, S_028778_ALPHA_DST_OPT(~0u)},
	{25180, S_028778_ALPHA_COMB_FCN(~0u)},
	/* 1489 */
	{24975, S_02877C_COLOR_SRC_OPT(~0u)},
	{24989, S_02877C_COLOR_DST_OPT(~0u)},
	{25137, S_02877C_COLOR_COMB_FCN(~0u)},
	{25152, S_02877C_ALPHA_SRC_OPT(~0u)},
	{25166, S_02877C_ALPHA_DST_OPT(~0u)},
	{25180, S_02877C_ALPHA_COMB_FCN(~0u)},
	/* 1495 */
	{25589, S_028780_COLOR_SRCBLEND(~0u), 21, 854},
	{25137, S_028780_COLOR_COMB_FCN(~0u), 5, 875},
	{25694, S_028780_COLOR_DESTBLEND(~0u), 21, 854},
	{25710, S_028780_ALPHA_SRCBLEND(~0u), 21, 854},
	{25180, S_028780_ALPHA_COMB_FCN(~0u), 5, 875},
	{25725, S_028780_ALPHA_DESTBLEND(~0u), 21, 854},
	{25741, S_028780_SEPARATE_ALPHA_BLEND(~0u)},
	{846, S_028780_ENABLE(~0u)},
	{25762, S_028780_DISABLE_ROP3(~0u)},
	/* 1504 */
	{25775, S_0287CC_SRC_STATE_ID(~0u)},
	/* 1505 */
	{25788, S_0287E4_BASE_ADDR(~0u)},
	/* 1506 */
	{25876, S_0287F0_SOURCE_SELECT(~0u), 4, 880},
	{25922, S_0287F0_MAJOR_MODE(~0u), 2, 884},
	{25933, S_0287F0_NOT_EOP(~0u)},
	{25941, S_0287F0_USE_OPAQUE(~0u)},
	/* 1510 */
	{25952, S_0287F8_ADDRESS_LOW(~0u)},
	/* 1511 */
	{25964, S_028800_STENCIL_ENABLE(~0u)},
	{18110, S_028800_Z_ENABLE(~0u)},
	{25979, S_028800_Z_WRITE_ENABLE(~0u)},
	{25994, S_028800_DEPTH_BOUNDS_ENABLE(~0u)},
	{18910, S_028800_ZFUNC(~0u), 8, 886},
	{26109, S_028800_BACKFACE_ENABLE(~0u)},
	{26212, S_028800_STENCILFUNC(~0u), 8, 894},
	{26224, S_028800_STENCILFUNC_BF(~0u), 8, 894},
	{26239, S_028800_ENABLE_COLOR_WRITES_ON_DEPTH_FAIL(~0u)},
	{26273, S_028800_DISABLE_COLOR_WRITES_ON_DEPTH_PASS(~0u)},
	/* 1521 */
	{26308, S_028804_MAX_ANCHOR_SAMPLES(~0u)},
	{26327, S_028804_PS_ITER_SAMPLES(~0u)},
	{26343, S_028804_MASK_EXPORT_NUM_SAMPLES(~0u)},
	{26367, S_028804_ALPHA_TO_MASK_NUM_SAMPLES(~0u)},
	{26393, S_028804_HIGH_QUALITY_INTERSECTIONS(~0u)},
	{26420, S_028804_INCOHERENT_EQAA_READS(~0u)},
	{26442, S_028804_INTERPOLATE_COMP_Z(~0u)},
	{26461, S_028804_INTERPOLATE_SRC_Z(~0u)},
	{26479, S_028804_STATIC_ANCHOR_ASSOCIATIONS(~0u)},
	{26506, S_028804_ALPHA_TO_MASK_EQAA_DISABLE(~0u)},
	{26533, S_028804_OVERRASTERIZATION_AMOUNT(~0u)},
	{26558, S_028804_ENABLE_POSTZ_OVERRASTERIZATION(~0u)},
	/* 1533 */
	{26589, S_028808_DISABLE_DUAL_QUAD(~0u)},
	{26607, S_028808_DEGAMMA_ENABLE(~0u)},
	{12466, S_028808_MODE(~0u), 7, 902},
	{25770, S_028808_ROP3(~0u), 256, 909},
	/* 1537 */
	{26912, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{26928, S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{26959, S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{18168, S_02880C_Z_ORDER(~0u), 4, 1165},
	{27038, S_02880C_KILL_ENABLE(~0u)},
	{27050, S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{27074, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{27093, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{27111, S_02880C_EXEC_ON_NOOP(~0u)},
	{27124, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{27146, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{27236, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 1169},
	{27258, S_02880C_DUAL_QUAD_DISABLE(~0u)},
	/* 1550 */
	{27276, S_028810_UCP_ENA_0(~0u)},
	{27286, S_028810_UCP_ENA_1(~0u)},
	{27296, S_028810_UCP_ENA_2(~0u)},
	{27306, S_028810_UCP_ENA_3(~0u)},
	{27316, S_028810_UCP_ENA_4(~0u)},
	{27326, S_028810_UCP_ENA_5(~0u)},
	{27336, S_028810_PS_UCP_Y_SCALE_NEG(~0u)},
	{27355, S_028810_PS_UCP_MODE(~0u)},
	{27367, S_028810_CLIP_DISABLE(~0u)},
	{27380, S_028810_UCP_CULL_ONLY_ENA(~0u)},
	{27398, S_028810_BOUNDARY_EDGE_FLAG_ENA(~0u)},
	{27421, S_028810_DX_CLIP_SPACE_DEF(~0u)},
	{27439, S_028810_DIS_CLIP_ERR_DETECT(~0u)},
	{27459, S_028810_VTX_KILL_OR(~0u)},
	{27471, S_028810_DX_RASTERIZATION_KILL(~0u)},
	{27493, S_028810_DX_LINEAR_ATTR_CLIP_ENA(~0u)},
	{27517, S_028810_VTE_VPORT_PROVOKE_DISABLE(~0u)},
	{27543, S_028810_ZCLIP_NEAR_DISABLE(~0u)},
	{27562, S_028810_ZCLIP_FAR_DISABLE(~0u)},
	/* 1569 */
	{27580, S_028814_CULL_FRONT(~0u)},
	{27591, S_028814_CULL_BACK(~0u)},
	{27601, S_028814_FACE(~0u)},
	{27616, S_028814_POLY_MODE(~0u), 2, 1173},
	{27682, S_028814_POLYMODE_FRONT_PTYPE(~0u), 3, 1175},
	{27703, S_028814_POLYMODE_BACK_PTYPE(~0u), 3, 1175},
	{27723, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{27748, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{27772, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{27796, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{27821, S_028814_PROVOKING_VTX_LAST(~0u)},
	{27840, S_028814_PERSP_CORR_DIS(~0u)},
	{27855, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	/* 1582 */
	{27873, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{27891, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{27910, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{27928, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{27947, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{27965, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{27984, S_028818_VTX_XY_FMT(~0u)},
	{27995, S_028818_VTX_Z_FMT(~0u)},
	{28005, S_028818_VTX_W0_FMT(~0u)},
	/* 1591 */
	{28016, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{28032, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{28048, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{28064, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{28080, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{28096, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{28112, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{28128, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{28144, S_02881C_CULL_DIST_ENA_0(~0u)},
	{28160, S_02881C_CULL_DIST_ENA_1(~0u)},
	{28176, S_02881C_CULL_DIST_ENA_2(~0u)},
	{28192, S_02881C_CULL_DIST_ENA_3(~0u)},
	{28208, S_02881C_CULL_DIST_ENA_4(~0u)},
	{28224, S_02881C_CULL_DIST_ENA_5(~0u)},
	{28240, S_02881C_CULL_DIST_ENA_6(~0u)},
	{28256, S_02881C_CULL_DIST_ENA_7(~0u)},
	{28272, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{28291, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{28309, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{28336, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{28358, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{28376, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{28396, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{28419, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{28442, S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{28467, S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{28487, S_02881C_USE_VTX_LINE_WIDTH(~0u)},
	/* 1618 */
	{28506, S_028820_VTE_XY_INF_DISCARD(~0u)},
	{28525, S_028820_VTE_Z_INF_DISCARD(~0u)},
	{28543, S_028820_VTE_W_INF_DISCARD(~0u)},
	{28561, S_028820_VTE_0XNANINF_IS_0(~0u)},
	{28579, S_028820_VTE_XY_NAN_RETAIN(~0u)},
	{28597, S_028820_VTE_Z_NAN_RETAIN(~0u)},
	{28614, S_028820_VTE_W_NAN_RETAIN(~0u)},
	{28631, S_028820_VTE_W_RECIP_NAN_IS_0(~0u)},
	{28652, S_028820_VS_XY_NAN_TO_INF(~0u)},
	{28669, S_028820_VS_XY_INF_RETAIN(~0u)},
	{28686, S_028820_VS_Z_NAN_TO_INF(~0u)},
	{28702, S_028820_VS_Z_INF_RETAIN(~0u)},
	{28718, S_028820_VS_W_NAN_TO_INF(~0u)},
	{28734, S_028820_VS_W_INF_RETAIN(~0u)},
	{28750, S_028820_VS_CLIP_DIST_INF_DISCARD(~0u)},
	{28775, S_028820_VTE_NO_OUTPUT_NEG_0(~0u)},
	/* 1634 */
	{28795, S_028824_LINE_STIPPLE_RESET(~0u)},
	{28814, S_028824_EXPAND_FULL_LENGTH(~0u)},
	{28833, S_028824_FRACTIONAL_ACCUM(~0u)},
	{28850, S_028824_DIAMOND_ADJUST(~0u)},
	/* 1638 */
	{28865, S_02882C_TRIANGLE_FILTER_DISABLE(~0u)},
	{28889, S_02882C_LINE_FILTER_DISABLE(~0u)},
	{28909, S_02882C_POINT_FILTER_DISABLE(~0u)},
	{28930, S_02882C_RECTANGLE_FILTER_DISABLE(~0u)},
	{28955, S_02882C_TRIANGLE_EXPAND_ENA(~0u)},
	{28975, S_02882C_LINE_EXPAND_ENA(~0u)},
	{28991, S_02882C_POINT_EXPAND_ENA(~0u)},
	{29008, S_02882C_RECTANGLE_EXPAND_ENA(~0u)},
	{29029, S_02882C_PRIM_EXPAND_CONSTANT(~0u)},
	{29050, S_02882C_XMAX_RIGHT_EXCLUSION(~0u)},
	{29071, S_02882C_YMAX_BOTTOM_EXCLUSION(~0u)},
	/* 1649 */
	{29093, S_028830_SMALL_PRIM_FILTER_ENABLE(~0u)},
	{28865, S_028830_TRIANGLE_FILTER_DISABLE(~0u)},
	{28889, S_028830_LINE_FILTER_DISABLE(~0u)},
	{28909, S_028830_POINT_FILTER_DISABLE(~0u)},
	{28930, S_028830_RECTANGLE_FILTER_DISABLE(~0u)},
	/* 1654 */
	{11351, S_028A00_HEIGHT(~0u)},
	{11345, S_028A00_WIDTH(~0u)},
	/* 1656 */
	{29118, S_028A04_MIN_SIZE(~0u)},
	{29127, S_028A04_MAX_SIZE(~0u)},
	/* 1658 */
	{11345, S_028A08_WIDTH(~0u)},
	/* 1659 */
	{29136, S_028A0C_LINE_PATTERN(~0u)},
	{29149, S_028A0C_REPEAT_COUNT(~0u)},
	{29162, S_028A0C_PATTERN_BIT_ORDER(~0u)},
	{29180, S_028A0C_AUTO_RESET_CNTL(~0u)},
	/* 1663 */
	{29301, S_028A10_PATH_SELECT(~0u), 5, 1178},
	/* 1664 */
	{29313, S_028A14_TESS_MODE(~0u)},
	/* 1665 */
	{29323, S_028A20_REUSE_DEPTH(~0u)},
	/* 1666 */
	{5968, S_028A24_PRIM_TYPE(~0u), 18, 1183},
	{29690, S_028A24_RETAIN_ORDER(~0u)},
	{29703, S_028A24_RETAIN_QUADS(~0u)},
	{29784, S_028A24_PRIM_ORDER(~0u), 5, 1201},
	/* 1670 */
	{29795, S_028A28_FIRST_DECR(~0u)},
	/* 1671 */
	{29801, S_028A2C_DECR(~0u)},
	/* 1672 */
	{29806, S_028A30_COMP_X_EN(~0u)},
	{29816, S_028A30_COMP_Y_EN(~0u)},
	{29826, S_028A30_COMP_Z_EN(~0u)},
	{29836, S_028A30_COMP_W_EN(~0u)},
	{8474, S_028A30_STRIDE(~0u)},
	{29846, S_028A30_SHIFT(~0u)},
	/* 1678 */
	{29806, S_028A34_COMP_X_EN(~0u)},
	{29816, S_028A34_COMP_Y_EN(~0u)},
	{29826, S_028A34_COMP_Z_EN(~0u)},
	{29836, S_028A34_COMP_W_EN(~0u)},
	{8474, S_028A34_STRIDE(~0u)},
	{29846, S_028A34_SHIFT(~0u)},
	/* 1684 */
	{30011, S_028A38_X_CONV(~0u), 9, 1206},
	{19403, S_028A38_X_OFFSET(~0u)},
	{30018, S_028A38_Y_CONV(~0u), 9, 1206},
	{19419, S_028A38_Y_OFFSET(~0u)},
	{30025, S_028A38_Z_CONV(~0u), 9, 1206},
	{30032, S_028A38_Z_OFFSET(~0u)},
	{30041, S_028A38_W_CONV(~0u), 9, 1206},
	{30048, S_028A38_W_OFFSET(~0u)},
	/* 1692 */
	{30011, S_028A3C_X_CONV(~0u), 9, 1206},
	{19403, S_028A3C_X_OFFSET(~0u)},
	{30018, S_028A3C_Y_CONV(~0u), 9, 1206},
	{19419, S_028A3C_Y_OFFSET(~0u)},
	{30025, S_028A3C_Z_CONV(~0u), 9, 1206},
	{30032, S_028A3C_Z_OFFSET(~0u)},
	{30041, S_028A3C_W_CONV(~0u), 9, 1206},
	{30048, S_028A3C_W_OFFSET(~0u)},
	/* 1700 */
	{12466, S_028A40_MODE(~0u), 6, 1215},
	{8535, S_028A40_RESERVED_0(~0u)},
	{30175, S_028A40_CUT_MODE(~0u), 4, 1221},
	{8553, S_028A40_RESERVED_1(~0u)},
	{30184, S_028A40_GS_C_PACK_EN(~0u)},
	{30197, S_028A40_RESERVED_2(~0u)},
	{30208, S_028A40_ES_PASSTHRU(~0u)},
	{30220, S_028A40_COMPUTE_MODE(~0u)},
	{30233, S_028A40_FAST_COMPUTE_MODE(~0u)},
	{30251, S_028A40_ELEMENT_INFO_EN(~0u)},
	{30267, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{30286, S_028A40_SUPPRESS_CUTS(~0u)},
	{30300, S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{30318, S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{30369, S_028A40_ONCHIP(~0u), 4, 1225},
	/* 1715 */
	{30376, S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{30396, S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
	/* 1717 */
	{30416, S_028A48_MSAA_ENABLE(~0u)},
	{30428, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{30449, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{30469, S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
	/* 1721 */
	{30494, S_028A4C_WALK_SIZE(~0u)},
	{30504, S_028A4C_WALK_ALIGNMENT(~0u)},
	{30519, S_028A4C_WALK_ALIGN8_PRIM_FITS_ST(~0u)},
	{30544, S_028A4C_WALK_FENCE_ENABLE(~0u)},
	{30562, S_028A4C_WALK_FENCE_SIZE(~0u)},
	{30578, S_028A4C_SUPERTILE_WALK_ORDER_ENABLE(~0u)},
	{30583, S_028A4C_TILE_WALK_ORDER_ENABLE(~0u)},
	{30606, S_028A4C_TILE_COVER_DISABLE(~0u)},
	{30625, S_028A4C_TILE_COVER_NO_SCISSOR(~0u)},
	{30647, S_028A4C_ZMM_LINE_EXTENT(~0u)},
	{30663, S_028A4C_ZMM_LINE_OFFSET(~0u)},
	{30679, S_028A4C_ZMM_RECT_EXTENT(~0u)},
	{30695, S_028A4C_KILL_PIX_POST_HI_Z(~0u)},
	{30714, S_028A4C_KILL_PIX_POST_DETAIL_MASK(~0u)},
	{30740, S_028A4C_PS_ITER_SAMPLE(~0u)},
	{30755, S_028A4C_MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE(~0u)},
	{30795, S_028A4C_MULTI_GPU_SUPERTILE_ENABLE(~0u)},
	{30822, S_028A4C_GPU_ID_OVERRIDE_ENABLE(~0u)},
	{30845, S_028A4C_GPU_ID_OVERRIDE(~0u)},
	{30861, S_028A4C_MULTI_GPU_PRIM_DISCARD_ENABLE(~0u)},
	{30891, S_028A4C_FORCE_EOV_CNTDWN_ENABLE(~0u)},
	{30915, S_028A4C_FORCE_EOV_REZ_ENABLE(~0u)},
	{30936, S_028A4C_OUT_OF_ORDER_PRIMITIVE_ENABLE(~0u)},
	{30966, S_028A4C_OUT_OF_ORDER_WATER_MARK(~0u)},
	/* 1745 */
	{30990, S_028A54_GS_PER_ES(~0u)},
	/* 1746 */
	{31000, S_028A58_ES_PER_GS(~0u)},
	/* 1747 */
	{31010, S_028A5C_GS_PER_VS(~0u)},
	/* 1748 */
	{673, S_028A60_OFFSET(~0u)},
	/* 1749 */
	{673, S_028A64_OFFSET(~0u)},
	/* 1750 */
	{673, S_028A68_OFFSET(~0u)},
	/* 1751 */
	{31088, S_028A6C_OUTPRIM_TYPE(~0u), 3, 1229},
	{31101, S_028A6C_OUTPRIM_TYPE_1(~0u)},
	{31116, S_028A6C_OUTPRIM_TYPE_2(~0u)},
	{31131, S_028A6C_OUTPRIM_TYPE_3(~0u)},
	{31146, S_028A6C_UNIQUE_TYPE_PER_STREAM(~0u)},
	/* 1756 */
	{203, S_028A7C_INDEX_TYPE(~0u), 3, 1232},
	{31283, S_028A7C_SWAP_MODE(~0u), 4, 1235},
	{31344, S_028A7C_BUF_TYPE(~0u), 3, 1239},
	{31386, S_028A7C_RDREQ_POLICY(~0u), 2, 1242},
	{31399, S_028A7C_RDREQ_POLICY_VI(~0u)},
	{9259, S_028A7C_ATC(~0u)},
	{25933, S_028A7C_NOT_EOP(~0u)},
	{31415, S_028A7C_REQ_PATH(~0u)},
	{9280, S_028A7C_MTYPE(~0u)},
	/* 1765 */
	{31424, S_028A84_PRIMITIVEID_EN(~0u)},
	{31439, S_028A84_DISABLE_RESET_ON_EOI(~0u)},
	/* 1767 */
	{32395, S_028A90_EVENT_TYPE(~0u), 65, 1244},
	{8463, S_028A90_ADDRESS_HI(~0u)},
	{32406, S_028A90_EXTENDED_EVENT(~0u)},
	/* 1770 */
	{32421, S_028A94_RESET_EN(~0u)},
	/* 1771 */
	{32430, S_028AA8_PRIMGROUP_SIZE(~0u)},
	{32445, S_028AA8_PARTIAL_VS_WAVE_ON(~0u)},
	{32464, S_028AA8_SWITCH_ON_EOP(~0u)},
	{32478, S_028AA8_PARTIAL_ES_WAVE_ON(~0u)},
	{32497, S_028AA8_SWITCH_ON_EOI(~0u)},
	{32511, S_028AA8_WD_SWITCH_ON_EOP(~0u)},
	{32528, S_028AA8_MAX_PRIMGRP_IN_WAVE(~0u)},
	/* 1778 */
	{32548, S_028AAC_ITEMSIZE(~0u)},
	/* 1779 */
	{32548, S_028AB0_ITEMSIZE(~0u)},
	/* 1780 */
	{32557, S_028AB4_REUSE_OFF(~0u)},
	/* 1781 */
	{32567, S_028AB8_VTX_CNT_EN(~0u)},
	/* 1782 */
	{12571, S_028ABC_LINEAR(~0u)},
	{32578, S_028ABC_FULL_CACHE(~0u)},
	{32589, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{32612, S_028ABC_PRELOAD(~0u)},
	{32620, S_028ABC_PREFETCH_WIDTH(~0u)},
	{32635, S_028ABC_PREFETCH_HEIGHT(~0u)},
	{32651, S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{32675, S_028ABC_TC_COMPATIBLE(~0u)},
	/* 1790 */
	{32689, S_028AC0_COMPAREFUNC0(~0u), 8, 894},
	{32702, S_028AC0_COMPAREVALUE0(~0u)},
	{32716, S_028AC0_COMPAREMASK0(~0u)},
	{18129, S_028AC0_ENABLE0(~0u)},
	/* 1794 */
	{32729, S_028AC4_COMPAREFUNC1(~0u), 8, 894},
	{32742, S_028AC4_COMPAREVALUE1(~0u)},
	{32756, S_028AC4_COMPAREMASK1(~0u)},
	{18147, S_028AC4_ENABLE1(~0u)},
	/* 1798 */
	{32769, S_028AC8_START_X(~0u)},
	{32777, S_028AC8_START_Y(~0u)},
	{32785, S_028AC8_MAX_X(~0u)},
	{32791, S_028AC8_MAX_Y(~0u)},
	/* 1802 */
	{8474, S_028AD4_STRIDE(~0u)},
	/* 1803 */
	{8474, S_028AE4_STRIDE(~0u)},
	/* 1804 */
	{8474, S_028AF4_STRIDE(~0u)},
	/* 1805 */
	{8474, S_028B04_STRIDE(~0u)},
	/* 1806 */
	{32797, S_028B30_VERTEX_STRIDE(~0u)},
	/* 1807 */
	{32811, S_028B38_MAX_VERT_OUT(~0u)},
	/* 1808 */
	{32824, S_028B50_ACCUM_ISOLINE(~0u)},
	{32838, S_028B50_ACCUM_TRI(~0u)},
	{32848, S_028B50_ACCUM_QUAD(~0u)},
	{32859, S_028B50_DONUT_SPLIT(~0u)},
	{32871, S_028B50_TRAP_SPLIT(~0u)},
	/* 1813 */
	{17294, S_028B54_LS_EN(~0u), 3, 1309},
	{17288, S_028B54_HS_EN(~0u)},
	{17282, S_028B54_ES_EN(~0u), 3, 1312},
	{17276, S_028B54_GS_EN(~0u)},
	{17270, S_028B54_VS_EN(~0u), 3, 1315},
	{33005, S_028B54_DYNAMIC_HS(~0u)},
	{15825, S_028B54_DISPATCH_DRAW_EN(~0u)},
	{33016, S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{33036, S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{33056, S_028B54_VS_WAVE_ID_EN(~0u)},
	/* 1823 */
	{33070, S_028B58_NUM_PATCHES(~0u)},
	{33082, S_028B58_HS_NUM_INPUT_CP(~0u)},
	{33098, S_028B58_HS_NUM_OUTPUT_CP(~0u)},
	/* 1826 */
	{32548, S_028B5C_ITEMSIZE(~0u)},
	/* 1827 */
	{32548, S_028B60_ITEMSIZE(~0u)},
	/* 1828 */
	{32548, S_028B64_ITEMSIZE(~0u)},
	/* 1829 */
	{32548, S_028B68_ITEMSIZE(~0u)},
	/* 1830 */
	{209, S_028B6C_TYPE(~0u), 3, 1318},
	{33204, S_028B6C_PARTITIONING(~0u), 4, 1321},
	{33281, S_028B6C_TOPOLOGY(~0u), 4, 1325},
	{33290, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{33310, S_028B6C_DEPRECATED(~0u)},
	{33321, S_028B6C_NUM_DS_WAVES_PER_SIMD(~0u)},
	{33343, S_028B6C_DISABLE_DONUTS(~0u)},
	{31386, S_028B6C_RDREQ_POLICY(~0u), 3, 1329},
	{31399, S_028B6C_RDREQ_POLICY_VI(~0u)},
	{33482, S_028B6C_DISTRIBUTION_MODE(~0u), 4, 1332},
	{9280, S_028B6C_MTYPE(~0u)},
	/* 1841 */
	{33500, S_028B70_ALPHA_TO_MASK_ENABLE(~0u)},
	{33521, S_028B70_ALPHA_TO_MASK_OFFSET0(~0u)},
	{33543, S_028B70_ALPHA_TO_MASK_OFFSET1(~0u)},
	{33565, S_028B70_ALPHA_TO_MASK_OFFSET2(~0u)},
	{33587, S_028B70_ALPHA_TO_MASK_OFFSET3(~0u)},
	{33609, S_028B70_OFFSET_ROUND(~0u)},
	/* 1847 */
	{33622, S_028B78_POLY_OFFSET_NEG_NUM_DB_BITS(~0u)},
	{33650, S_028B78_POLY_OFFSET_DB_IS_FLOAT_FMT(~0u)},
	/* 1849 */
	{846, S_028B90_ENABLE(~0u)},
	{15741, S_028B90_CNT(~0u)},
	/* 1851 */
	{33678, S_028B94_STREAMOUT_0_EN(~0u)},
	{33693, S_028B94_STREAMOUT_1_EN(~0u)},
	{33708, S_028B94_STREAMOUT_2_EN(~0u)},
	{33723, S_028B94_STREAMOUT_3_EN(~0u)},
	{33738, S_028B94_RAST_STREAM(~0u)},
	{33750, S_028B94_RAST_STREAM_MASK(~0u)},
	{33767, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	/* 1858 */
	{33788, S_028B98_STREAM_0_BUFFER_EN(~0u)},
	{33807, S_028B98_STREAM_1_BUFFER_EN(~0u)},
	{33826, S_028B98_STREAM_2_BUFFER_EN(~0u)},
	{33845, S_028B98_STREAM_3_BUFFER_EN(~0u)},
	/* 1862 */
	{33864, S_028BD4_DISTANCE_0(~0u)},
	{33875, S_028BD4_DISTANCE_1(~0u)},
	{33886, S_028BD4_DISTANCE_2(~0u)},
	{33897, S_028BD4_DISTANCE_3(~0u)},
	{33908, S_028BD4_DISTANCE_4(~0u)},
	{33919, S_028BD4_DISTANCE_5(~0u)},
	{33930, S_028BD4_DISTANCE_6(~0u)},
	{33941, S_028BD4_DISTANCE_7(~0u)},
	/* 1870 */
	{33952, S_028BD8_DISTANCE_8(~0u)},
	{33963, S_028BD8_DISTANCE_9(~0u)},
	{33974, S_028BD8_DISTANCE_10(~0u)},
	{33986, S_028BD8_DISTANCE_11(~0u)},
	{33998, S_028BD8_DISTANCE_12(~0u)},
	{34010, S_028BD8_DISTANCE_13(~0u)},
	{34022, S_028BD8_DISTANCE_14(~0u)},
	{34034, S_028BD8_DISTANCE_15(~0u)},
	/* 1878 */
	{34046, S_028BDC_EXPAND_LINE_WIDTH(~0u)},
	{34064, S_028BDC_LAST_PIXEL(~0u)},
	{34075, S_028BDC_PERPENDICULAR_ENDCAP_ENA(~0u)},
	{34100, S_028BDC_DX10_DIAMOND_TEST_ENA(~0u)},
	/* 1882 */
	{34122, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{34139, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{34161, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{34177, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{34198, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	/* 1887 */
	{34221, S_028BE4_PIX_CENTER(~0u)},
	{34282, S_028BE4_ROUND_MODE(~0u), 4, 1336},
	{34498, S_028BE4_QUANT_MODE(~0u), 8, 1340},
	/* 1890 */
	{34509, S_028BF8_S0_X(~0u)},
	{34514, S_028BF8_S0_Y(~0u)},
	{34519, S_028BF8_S1_X(~0u)},
	{34524, S_028BF8_S1_Y(~0u)},
	{34529, S_028BF8_S2_X(~0u)},
	{34534, S_028BF8_S2_Y(~0u)},
	{34539, S_028BF8_S3_X(~0u)},
	{34544, S_028BF8_S3_Y(~0u)},
	/* 1898 */
	{34549, S_028BFC_S4_X(~0u)},
	{34554, S_028BFC_S4_Y(~0u)},
	{34559, S_028BFC_S5_X(~0u)},
	{34564, S_028BFC_S5_Y(~0u)},
	{34569, S_028BFC_S6_X(~0u)},
	{34574, S_028BFC_S6_Y(~0u)},
	{34579, S_028BFC_S7_X(~0u)},
	{34584, S_028BFC_S7_Y(~0u)},
	/* 1906 */
	{34589, S_028C00_S8_X(~0u)},
	{34594, S_028C00_S8_Y(~0u)},
	{34599, S_028C00_S9_X(~0u)},
	{34604, S_028C00_S9_Y(~0u)},
	{34609, S_028C00_S10_X(~0u)},
	{34615, S_028C00_S10_Y(~0u)},
	{34621, S_028C00_S11_X(~0u)},
	{34627, S_028C00_S11_Y(~0u)},
	/* 1914 */
	{34633, S_028C04_S12_X(~0u)},
	{34639, S_028C04_S12_Y(~0u)},
	{34645, S_028C04_S13_X(~0u)},
	{34651, S_028C04_S13_Y(~0u)},
	{34657, S_028C04_S14_X(~0u)},
	{34663, S_028C04_S14_Y(~0u)},
	{34669, S_028C04_S15_X(~0u)},
	{34675, S_028C04_S15_Y(~0u)},
	/* 1922 */
	{34509, S_028C08_S0_X(~0u)},
	{34514, S_028C08_S0_Y(~0u)},
	{34519, S_028C08_S1_X(~0u)},
	{34524, S_028C08_S1_Y(~0u)},
	{34529, S_028C08_S2_X(~0u)},
	{34534, S_028C08_S2_Y(~0u)},
	{34539, S_028C08_S3_X(~0u)},
	{34544, S_028C08_S3_Y(~0u)},
	/* 1930 */
	{34549, S_028C0C_S4_X(~0u)},
	{34554, S_028C0C_S4_Y(~0u)},
	{34559, S_028C0C_S5_X(~0u)},
	{34564, S_028C0C_S5_Y(~0u)},
	{34569, S_028C0C_S6_X(~0u)},
	{34574, S_028C0C_S6_Y(~0u)},
	{34579, S_028C0C_S7_X(~0u)},
	{34584, S_028C0C_S7_Y(~0u)},
	/* 1938 */
	{34589, S_028C10_S8_X(~0u)},
	{34594, S_028C10_S8_Y(~0u)},
	{34599, S_028C10_S9_X(~0u)},
	{34604, S_028C10_S9_Y(~0u)},
	{34609, S_028C10_S10_X(~0u)},
	{34615, S_028C10_S10_Y(~0u)},
	{34621, S_028C10_S11_X(~0u)},
	{34627, S_028C10_S11_Y(~0u)},
	/* 1946 */
	{34633, S_028C14_S12_X(~0u)},
	{34639, S_028C14_S12_Y(~0u)},
	{34645, S_028C14_S13_X(~0u)},
	{34651, S_028C14_S13_Y(~0u)},
	{34657, S_028C14_S14_X(~0u)},
	{34663, S_028C14_S14_Y(~0u)},
	{34669, S_028C14_S15_X(~0u)},
	{34675, S_028C14_S15_Y(~0u)},
	/* 1954 */
	{34509, S_028C18_S0_X(~0u)},
	{34514, S_028C18_S0_Y(~0u)},
	{34519, S_028C18_S1_X(~0u)},
	{34524, S_028C18_S1_Y(~0u)},
	{34529, S_028C18_S2_X(~0u)},
	{34534, S_028C18_S2_Y(~0u)},
	{34539, S_028C18_S3_X(~0u)},
	{34544, S_028C18_S3_Y(~0u)},
	/* 1962 */
	{34549, S_028C1C_S4_X(~0u)},
	{34554, S_028C1C_S4_Y(~0u)},
	{34559, S_028C1C_S5_X(~0u)},
	{34564, S_028C1C_S5_Y(~0u)},
	{34569, S_028C1C_S6_X(~0u)},
	{34574, S_028C1C_S6_Y(~0u)},
	{34579, S_028C1C_S7_X(~0u)},
	{34584, S_028C1C_S7_Y(~0u)},
	/* 1970 */
	{34589, S_028C20_S8_X(~0u)},
	{34594, S_028C20_S8_Y(~0u)},
	{34599, S_028C20_S9_X(~0u)},
	{34604, S_028C20_S9_Y(~0u)},
	{34609, S_028C20_S10_X(~0u)},
	{34615, S_028C20_S10_Y(~0u)},
	{34621, S_028C20_S11_X(~0u)},
	{34627, S_028C20_S11_Y(~0u)},
	/* 1978 */
	{34633, S_028C24_S12_X(~0u)},
	{34639, S_028C24_S12_Y(~0u)},
	{34645, S_028C24_S13_X(~0u)},
	{34651, S_028C24_S13_Y(~0u)},
	{34657, S_028C24_S14_X(~0u)},
	{34663, S_028C24_S14_Y(~0u)},
	{34669, S_028C24_S15_X(~0u)},
	{34675, S_028C24_S15_Y(~0u)},
	/* 1986 */
	{34509, S_028C28_S0_X(~0u)},
	{34514, S_028C28_S0_Y(~0u)},
	{34519, S_028C28_S1_X(~0u)},
	{34524, S_028C28_S1_Y(~0u)},
	{34529, S_028C28_S2_X(~0u)},
	{34534, S_028C28_S2_Y(~0u)},
	{34539, S_028C28_S3_X(~0u)},
	{34544, S_028C28_S3_Y(~0u)},
	/* 1994 */
	{34549, S_028C2C_S4_X(~0u)},
	{34554, S_028C2C_S4_Y(~0u)},
	{34559, S_028C2C_S5_X(~0u)},
	{34564, S_028C2C_S5_Y(~0u)},
	{34569, S_028C2C_S6_X(~0u)},
	{34574, S_028C2C_S6_Y(~0u)},
	{34579, S_028C2C_S7_X(~0u)},
	{34584, S_028C2C_S7_Y(~0u)},
	/* 2002 */
	{34589, S_028C30_S8_X(~0u)},
	{34594, S_028C30_S8_Y(~0u)},
	{34599, S_028C30_S9_X(~0u)},
	{34604, S_028C30_S9_Y(~0u)},
	{34609, S_028C30_S10_X(~0u)},
	{34615, S_028C30_S10_Y(~0u)},
	{34621, S_028C30_S11_X(~0u)},
	{34627, S_028C30_S11_Y(~0u)},
	/* 2010 */
	{34633, S_028C34_S12_X(~0u)},
	{34639, S_028C34_S12_Y(~0u)},
	{34645, S_028C34_S13_X(~0u)},
	{34651, S_028C34_S13_Y(~0u)},
	{34657, S_028C34_S14_X(~0u)},
	{34663, S_028C34_S14_Y(~0u)},
	{34669, S_028C34_S15_X(~0u)},
	{34675, S_028C34_S15_Y(~0u)},
	/* 2018 */
	{34681, S_028C38_AA_MASK_X0Y0(~0u)},
	{34694, S_028C38_AA_MASK_X1Y0(~0u)},
	/* 2020 */
	{34707, S_028C3C_AA_MASK_X0Y1(~0u)},
	{34720, S_028C3C_AA_MASK_X1Y1(~0u)},
	/* 2022 */
	{34733, S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
	/* 2023 */
	{34762, S_028C58_VTX_REUSE_DEPTH(~0u)},
	/* 2024 */
	{34778, S_028C5C_DEALLOC_DIST(~0u)},
	/* 2025 */
	{19356, S_028C64_TILE_MAX(~0u)},
	{34791, S_028C64_FMASK_TILE_MAX(~0u)},
	/* 2027 */
	{19356, S_028C68_TILE_MAX(~0u)},
	/* 2028 */
	{17998, S_028C6C_SLICE_START(~0u)},
	{18010, S_028C6C_SLICE_MAX(~0u)},
	/* 2030 */
	{34857, S_028C70_ENDIAN(~0u), 4, 1348},
	{8818, S_028C70_FORMAT(~0u), 23, 1352},
	{14213, S_028C70_LINEAR_GENERAL(~0u)},
	{35224, S_028C70_NUMBER_TYPE(~0u), 8, 1375},
	{35280, S_028C70_COMP_SWAP(~0u), 4, 1383},
	{26656, S_028C70_FAST_CLEAR(~0u)},
	{18584, S_028C70_COMPRESSION(~0u)},
	{35290, S_028C70_BLEND_CLAMP(~0u)},
	{35302, S_028C70_BLEND_BYPASS(~0u)},
	{35315, S_028C70_SIMPLE_FLOAT(~0u)},
	{34282, S_028C70_ROUND_MODE(~0u)},
	{35328, S_028C70_CMASK_IS_LINEAR(~0u)},
	{35555, S_028C70_BLEND_OPT_DONT_RD_DST(~0u), 8, 1387},
	{35577, S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), 8, 1387},
	{35601, S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{35627, S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{35653, S_028C70_DCC_ENABLE(~0u)},
	{35664, S_028C70_CMASK_ADDR_TYPE(~0u)},
	/* 2048 */
	{19184, S_028C74_TILE_MODE_INDEX(~0u)},
	{35680, S_028C74_FMASK_TILE_MODE_INDEX(~0u)},
	{35702, S_028C74_FMASK_BANK_HEIGHT(~0u)},
	{19172, S_028C74_NUM_SAMPLES(~0u)},
	{35720, S_028C74_NUM_FRAGMENTS(~0u)},
	{35734, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	/* 2054 */
	{21728, S_028C78_OVERWRITE_COMBINER_DISABLE(~0u)},
	{35752, S_028C78_KEY_CLEAR_ENABLE(~0u)},
	{35769, S_028C78_MAX_UNCOMPRESSED_BLOCK_SIZE(~0u)},
	{35797, S_028C78_MIN_COMPRESSED_BLOCK_SIZE(~0u)},
	{35823, S_028C78_MAX_COMPRESSED_BLOCK_SIZE(~0u)},
	{11833, S_028C78_COLOR_TRANSFORM(~0u)},
	{35849, S_028C78_INDEPENDENT_64B_BLOCKS(~0u)},
	{35872, S_028C78_LOSSY_RGB_PRECISION(~0u)},
	{35892, S_028C78_LOSSY_ALPHA_PRECISION(~0u)},
	/* 2063 */
	{19356, S_028C80_TILE_MAX(~0u)},
	/* 2064 */
	{19356, S_028C88_TILE_MAX(~0u)},
};

static const struct si_reg sid_reg_table[] = {
	{35914, R_2C3_DRAW_INDEX_LOC, 2, 0},
	{195, R_370_CONTROL, 4, 2},
	{1107, R_371_DST_ADDR_LO},
	{1119, R_372_DST_ADDR_HI},
	{35929, R_3F0_IB_BASE_LO},
	{35940, R_3F1_IB_BASE_HI},
	{195, R_3F2_CONTROL, 3, 6},
	{35951, R_410_CP_DMA_WORD0, 1, 9},
	{35964, R_411_CP_DMA_WORD1, 5, 10},
	{35977, R_412_CP_DMA_WORD2, 1, 15},
	{35990, R_413_CP_DMA_WORD3, 1, 16},
	{36003, R_414_COMMAND, 9, 17},
	{36011, R_500_DMA_DATA_WORD0, 4, 26},
	{1004, R_501_SRC_ADDR_LO},
	{1095, R_502_SRC_ADDR_HI},
	{1107, R_503_DST_ADDR_LO},
	{1119, R_504_DST_ADDR_HI},
	{36026, R_000E4C_SRBM_STATUS2, 21, 30},
	{36039, R_000E50_SRBM_STATUS, 20, 51},
	{36051, R_000E54_SRBM_STATUS3, 16, 71},
	{36064, R_00D034_SDMA0_STATUS_REG, 29, 87},
	{36081, R_00D834_SDMA1_STATUS_REG, 29, 87},
	{36098, R_008008_GRBM_STATUS2, 18, 116},
	{36111, R_008010_GRBM_STATUS, 24, 134},
	{36123, R_0084FC_CP_STRMOUT_CNTL, 1, 158},
	{36139, R_0085F0_CP_COHER_CNTL, 19, 159},
	{36153, R_0085F4_CP_COHER_SIZE},
	{36167, R_0085F8_CP_COHER_BASE},
	{36181, R_008014_GRBM_STATUS_SE0, 11, 178},
	{36197, R_008018_GRBM_STATUS_SE1, 11, 189},
	{36213, R_008038_GRBM_STATUS_SE2, 11, 200},
	{36229, R_00803C_GRBM_STATUS_SE3, 11, 211},
	{36123, R_0300FC_CP_STRMOUT_CNTL, 1, 222},
	{36245, R_0301E4_CP_COHER_BASE_HI, 1, 223},
	{36262, R_0301EC_CP_COHER_START_DELAY, 1, 224},
	{36139, R_0301F0_CP_COHER_CNTL, 27, 225},
	{36153, R_0301F4_CP_COHER_SIZE},
	{36167, R_0301F8_CP_COHER_BASE},
	{36283, R_0301FC_CP_COHER_STATUS, 4, 252},
	{36299, R_008210_CP_CPC_STATUS, 15, 256},
	{36313, R_008214_CP_CPC_BUSY_STAT, 28, 271},
	{36330, R_008218_CP_CPC_STALLED_STAT1, 14, 299},
	{36351, R_00821C_CP_CPF_STATUS, 21, 313},
	{36365, R_008220_CP_CPF_BUSY_STAT, 31, 334},
	{36382, R_008224_CP_CPF_STALLED_STAT1, 9, 365},
	{36403, R_030230_CP_COHER_SIZE_HI, 1, 374},
	{36420, R_0088B0_VGT_VTX_VECT_EJECT_REG, 1, 375},
	{36443, R_0088C4_VGT_CACHE_INVALIDATION, 3, 376},
	{36466, R_0088C8_VGT_ESGS_RING_SIZE},
	{36485, R_0088CC_VGT_GSVS_RING_SIZE},
	{36504, R_0088D4_VGT_GS_VERTEX_REUSE, 1, 379},
	{36524, R_008958_VGT_PRIMITIVE_TYPE, 1, 380},
	{36543, R_00895C_VGT_INDEX_TYPE, 1, 381},
	{36558, R_008960_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{36591, R_008964_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{36624, R_008968_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{36657, R_00896C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{36690, R_008970_VGT_NUM_INDICES},
	{36706, R_008974_VGT_NUM_INSTANCES},
	{36724, R_008988_VGT_TF_RING_SIZE, 1, 382},
	{36741, R_0089B0_VGT_HS_OFFCHIP_PARAM, 1, 383},
	{36762, R_0089B8_VGT_TF_MEMORY_BASE},
	{36781, R_008A14_PA_CL_ENHANCE, 4, 384},
	{36795, R_008A60_PA_SU_LINE_STIPPLE_VALUE, 1, 388},
	{36820, R_008B10_PA_SC_LINE_STIPPLE_STATE, 2, 389},
	{36845, R_008670_CP_STALLED_STAT3, 19, 391},
	{36862, R_008674_CP_STALLED_STAT1, 16, 410},
	{36879, R_008678_CP_STALLED_STAT2, 29, 426},
	{36896, R_008680_CP_STAT, 23, 455},
	{36904, R_030800_GRBM_GFX_INDEX, 6, 478},
	{36466, R_030900_VGT_ESGS_RING_SIZE},
	{36485, R_030904_VGT_GSVS_RING_SIZE},
	{36524, R_030908_VGT_PRIMITIVE_TYPE, 1, 484},
	{36543, R_03090C_VGT_INDEX_TYPE, 1, 485},
	{36558, R_030910_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{36591, R_030914_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{36624, R_030918_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{36657, R_03091C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{36690, R_030930_VGT_NUM_INDICES},
	{36706, R_030934_VGT_NUM_INSTANCES},
	{36724, R_030938_VGT_TF_RING_SIZE, 1, 486},
	{36741, R_03093C_VGT_HS_OFFCHIP_PARAM, 2, 487},
	{36762, R_030940_VGT_TF_MEMORY_BASE},
	{36795, R_030A00_PA_SU_LINE_STIPPLE_VALUE, 1, 489},
	{36820, R_030A04_PA_SC_LINE_STIPPLE_STATE, 2, 490},
	{36919, R_030A10_PA_SC_SCREEN_EXTENT_MIN_0, 2, 492},
	{36945, R_030A14_PA_SC_SCREEN_EXTENT_MAX_0, 2, 494},
	{36971, R_030A18_PA_SC_SCREEN_EXTENT_MIN_1, 2, 496},
	{36997, R_030A2C_PA_SC_SCREEN_EXTENT_MAX_1, 2, 498},
	{37023, R_008BF0_PA_SC_ENHANCE, 9, 500},
	{37037, R_008C08_SQC_CACHES, 2, 509},
	{37037, R_030D20_SQC_CACHES, 3, 511},
	{37048, R_008C0C_SQ_RANDOM_WAVE_PRI, 3, 514},
	{37067, R_008DFC_SQ_EXP_0, 6, 517},
	{37076, R_030E00_TA_CS_BC_BASE_ADDR},
	{37095, R_030E04_TA_CS_BC_BASE_ADDR_HI, 1, 523},
	{37117, R_030F00_DB_OCCLUSION_COUNT0_LOW},
	{37141, R_008F00_SQ_BUF_RSRC_WORD0},
	{37159, R_030F04_DB_OCCLUSION_COUNT0_HI, 1, 524},
	{37182, R_008F04_SQ_BUF_RSRC_WORD1, 4, 525},
	{37200, R_030F08_DB_OCCLUSION_COUNT1_LOW},
	{37224, R_008F08_SQ_BUF_RSRC_WORD2},
	{37242, R_030F0C_DB_OCCLUSION_COUNT1_HI, 1, 529},
	{37265, R_008F0C_SQ_BUF_RSRC_WORD3, 14, 530},
	{37283, R_030F10_DB_OCCLUSION_COUNT2_LOW},
	{37307, R_008F10_SQ_IMG_RSRC_WORD0},
	{37325, R_030F14_DB_OCCLUSION_COUNT2_HI, 1, 544},
	{37348, R_008F14_SQ_IMG_RSRC_WORD1, 5, 545},
	{37366, R_030F18_DB_OCCLUSION_COUNT3_LOW},
	{37390, R_008F18_SQ_IMG_RSRC_WORD2, 4, 550},
	{37408, R_030F1C_DB_OCCLUSION_COUNT3_HI, 1, 554},
	{37431, R_008F1C_SQ_IMG_RSRC_WORD3, 11, 555},
	{37449, R_008F20_SQ_IMG_RSRC_WORD4, 2, 566},
	{37467, R_008F24_SQ_IMG_RSRC_WORD5, 2, 568},
	{37485, R_008F28_SQ_IMG_RSRC_WORD6, 8, 570},
	{37503, R_008F2C_SQ_IMG_RSRC_WORD7},
	{37521, R_008F30_SQ_IMG_SAMP_WORD0, 14, 578},
	{37539, R_008F34_SQ_IMG_SAMP_WORD1, 4, 592},
	{37557, R_008F38_SQ_IMG_SAMP_WORD2, 10, 596},
	{37575, R_008F3C_SQ_IMG_SAMP_WORD3, 2, 606},
	{37593, R_0090DC_SPI_DYN_GPR_LOCK_EN, 5, 608},
	{37613, R_0090E0_SPI_STATIC_THREAD_MGMT_1, 2, 613},
	{37638, R_0090E4_SPI_STATIC_THREAD_MGMT_2, 2, 615},
	{37663, R_0090E8_SPI_STATIC_THREAD_MGMT_3, 1, 617},
	{37688, R_0090EC_SPI_PS_MAX_WAVE_ID, 1, 618},
	{37688, R_0090E8_SPI_PS_MAX_WAVE_ID, 1, 619},
	{37707, R_0090F0_SPI_ARB_PRIORITY, 3, 620},
	{37707, R_00C700_SPI_ARB_PRIORITY, 8, 623},
	{37724, R_0090F4_SPI_ARB_CYCLES_0, 2, 631},
	{37741, R_0090F8_SPI_ARB_CYCLES_1, 1, 633},
	{37758, R_008F40_SQ_FLAT_SCRATCH_WORD0, 1, 634},
	{37780, R_008F44_SQ_FLAT_SCRATCH_WORD1, 1, 635},
	{37802, R_030FF8_DB_ZPASS_COUNT_LOW},
	{37821, R_030FFC_DB_ZPASS_COUNT_HI, 1, 636},
	{37839, R_009100_SPI_CONFIG_CNTL, 5, 637},
	{37855, R_00913C_SPI_CONFIG_CNTL_1, 5, 642},
	{37873, R_00936C_SPI_RESOURCE_RESERVE_CU_AB_0, 12, 647},
	{37076, R_00950C_TA_CS_BC_BASE_ADDR},
	{37902, R_009858_DB_SUBTILE_CONTROL, 10, 659},
	{37921, R_0098F8_GB_ADDR_CONFIG, 9, 669},
	{37936, R_009910_GB_TILE_MODE0, 10, 678},
	{37950, R_009914_GB_TILE_MODE1, 10, 678},
	{37964, R_009918_GB_TILE_MODE2, 10, 678},
	{37978, R_00991C_GB_TILE_MODE3, 10, 678},
	{37992, R_009920_GB_TILE_MODE4, 10, 678},
	{38006, R_009924_GB_TILE_MODE5, 10, 678},
	{38020, R_009928_GB_TILE_MODE6, 10, 678},
	{38034, R_00992C_GB_TILE_MODE7, 10, 678},
	{38048, R_009930_GB_TILE_MODE8, 10, 678},
	{38062, R_009934_GB_TILE_MODE9, 10, 678},
	{38076, R_009938_GB_TILE_MODE10, 10, 678},
	{38091, R_00993C_GB_TILE_MODE11, 10, 678},
	{38106, R_009940_GB_TILE_MODE12, 10, 678},
	{38121, R_009944_GB_TILE_MODE13, 10, 678},
	{38136, R_009948_GB_TILE_MODE14, 10, 678},
	{38151, R_00994C_GB_TILE_MODE15, 10, 678},
	{38166, R_009950_GB_TILE_MODE16, 10, 678},
	{38181, R_009954_GB_TILE_MODE17, 10, 678},
	{38196, R_009958_GB_TILE_MODE18, 10, 678},
	{38211, R_00995C_GB_TILE_MODE19, 10, 678},
	{38226, R_009960_GB_TILE_MODE20, 10, 678},
	{38241, R_009964_GB_TILE_MODE21, 10, 678},
	{38256, R_009968_GB_TILE_MODE22, 10, 678},
	{38271, R_00996C_GB_TILE_MODE23, 10, 678},
	{38286, R_009970_GB_TILE_MODE24, 10, 678},
	{38301, R_009974_GB_TILE_MODE25, 10, 678},
	{38316, R_009978_GB_TILE_MODE26, 10, 678},
	{38331, R_00997C_GB_TILE_MODE27, 10, 678},
	{38346, R_009980_GB_TILE_MODE28, 10, 678},
	{38361, R_009984_GB_TILE_MODE29, 10, 678},
	{38376, R_009988_GB_TILE_MODE30, 10, 678},
	{38391, R_00998C_GB_TILE_MODE31, 10, 678},
	{38406, R_009990_GB_MACROTILE_MODE0, 4, 688},
	{38425, R_009994_GB_MACROTILE_MODE1, 4, 688},
	{38444, R_009998_GB_MACROTILE_MODE2, 4, 688},
	{38463, R_00999C_GB_MACROTILE_MODE3, 4, 688},
	{38482, R_0099A0_GB_MACROTILE_MODE4, 4, 688},
	{38501, R_0099A4_GB_MACROTILE_MODE5, 4, 688},
	{38520, R_0099A8_GB_MACROTILE_MODE6, 4, 688},
	{38539, R_0099AC_GB_MACROTILE_MODE7, 4, 688},
	{38558, R_0099B0_GB_MACROTILE_MODE8, 4, 688},
	{38577, R_0099B4_GB_MACROTILE_MODE9, 4, 688},
	{38596, R_0099B8_GB_MACROTILE_MODE10, 4, 688},
	{38616, R_0099BC_GB_MACROTILE_MODE11, 4, 688},
	{38636, R_0099C0_GB_MACROTILE_MODE12, 4, 688},
	{38656, R_0099C4_GB_MACROTILE_MODE13, 4, 688},
	{38676, R_0099C8_GB_MACROTILE_MODE14, 4, 688},
	{38696, R_0099CC_GB_MACROTILE_MODE15, 4, 688},
	{38716, R_00B000_SPI_SHADER_TBA_LO_PS},
	{38737, R_00B004_SPI_SHADER_TBA_HI_PS, 1, 692},
	{38758, R_00B008_SPI_SHADER_TMA_LO_PS},
	{38779, R_00B00C_SPI_SHADER_TMA_HI_PS, 1, 693},
	{38800, R_00B01C_SPI_SHADER_PGM_RSRC3_PS, 3, 694},
	{38824, R_00B020_SPI_SHADER_PGM_LO_PS},
	{38845, R_00B024_SPI_SHADER_PGM_HI_PS, 1, 697},
	{38866, R_00B028_SPI_SHADER_PGM_RSRC1_PS, 11, 698},
	{38890, R_00B02C_SPI_SHADER_PGM_RSRC2_PS, 7, 709},
	{38914, R_00B030_SPI_SHADER_USER_DATA_PS_0},
	{38940, R_00B034_SPI_SHADER_USER_DATA_PS_1},
	{38966, R_00B038_SPI_SHADER_USER_DATA_PS_2},
	{38992, R_00B03C_SPI_SHADER_USER_DATA_PS_3},
	{39018, R_00B040_SPI_SHADER_USER_DATA_PS_4},
	{39044, R_00B044_SPI_SHADER_USER_DATA_PS_5},
	{39070, R_00B048_SPI_SHADER_USER_DATA_PS_6},
	{39096, R_00B04C_SPI_SHADER_USER_DATA_PS_7},
	{39122, R_00B050_SPI_SHADER_USER_DATA_PS_8},
	{39148, R_00B054_SPI_SHADER_USER_DATA_PS_9},
	{39174, R_00B058_SPI_SHADER_USER_DATA_PS_10},
	{39201, R_00B05C_SPI_SHADER_USER_DATA_PS_11},
	{39228, R_00B060_SPI_SHADER_USER_DATA_PS_12},
	{39255, R_00B064_SPI_SHADER_USER_DATA_PS_13},
	{39282, R_00B068_SPI_SHADER_USER_DATA_PS_14},
	{39309, R_00B06C_SPI_SHADER_USER_DATA_PS_15},
	{39336, R_00B100_SPI_SHADER_TBA_LO_VS},
	{39357, R_00B104_SPI_SHADER_TBA_HI_VS, 1, 716},
	{39378, R_00B108_SPI_SHADER_TMA_LO_VS},
	{39399, R_00B10C_SPI_SHADER_TMA_HI_VS, 1, 717},
	{39420, R_00B118_SPI_SHADER_PGM_RSRC3_VS, 3, 718},
	{39444, R_00B11C_SPI_SHADER_LATE_ALLOC_VS, 1, 721},
	{39469, R_00B120_SPI_SHADER_PGM_LO_VS},
	{39490, R_00B124_SPI_SHADER_PGM_HI_VS, 1, 722},
	{39511, R_00B128_SPI_SHADER_PGM_RSRC1_VS, 12, 723},
	{39535, R_00B12C_SPI_SHADER_PGM_RSRC2_VS, 12, 735},
	{39559, R_00B130_SPI_SHADER_USER_DATA_VS_0},
	{39585, R_00B134_SPI_SHADER_USER_DATA_VS_1},
	{39611, R_00B138_SPI_SHADER_USER_DATA_VS_2},
	{39637, R_00B13C_SPI_SHADER_USER_DATA_VS_3},
	{39663, R_00B140_SPI_SHADER_USER_DATA_VS_4},
	{39689, R_00B144_SPI_SHADER_USER_DATA_VS_5},
	{39715, R_00B148_SPI_SHADER_USER_DATA_VS_6},
	{39741, R_00B14C_SPI_SHADER_USER_DATA_VS_7},
	{39767, R_00B150_SPI_SHADER_USER_DATA_VS_8},
	{39793, R_00B154_SPI_SHADER_USER_DATA_VS_9},
	{39819, R_00B158_SPI_SHADER_USER_DATA_VS_10},
	{39846, R_00B15C_SPI_SHADER_USER_DATA_VS_11},
	{39873, R_00B160_SPI_SHADER_USER_DATA_VS_12},
	{39900, R_00B164_SPI_SHADER_USER_DATA_VS_13},
	{39927, R_00B168_SPI_SHADER_USER_DATA_VS_14},
	{39954, R_00B16C_SPI_SHADER_USER_DATA_VS_15},
	{39981, R_00B200_SPI_SHADER_TBA_LO_GS},
	{40002, R_00B204_SPI_SHADER_TBA_HI_GS, 1, 747},
	{40023, R_00B208_SPI_SHADER_TMA_LO_GS},
	{40044, R_00B20C_SPI_SHADER_TMA_HI_GS, 1, 748},
	{40065, R_00B21C_SPI_SHADER_PGM_RSRC3_GS, 4, 749},
	{40089, R_00B220_SPI_SHADER_PGM_LO_GS},
	{40110, R_00B224_SPI_SHADER_PGM_HI_GS, 1, 753},
	{40131, R_00B228_SPI_SHADER_PGM_RSRC1_GS, 11, 754},
	{40155, R_00B22C_SPI_SHADER_PGM_RSRC2_GS, 5, 765},
	{40179, R_00B230_SPI_SHADER_USER_DATA_GS_0},
	{40205, R_00B234_SPI_SHADER_USER_DATA_GS_1},
	{40231, R_00B238_SPI_SHADER_USER_DATA_GS_2},
	{40257, R_00B23C_SPI_SHADER_USER_DATA_GS_3},
	{40283, R_00B240_SPI_SHADER_USER_DATA_GS_4},
	{40309, R_00B244_SPI_SHADER_USER_DATA_GS_5},
	{40335, R_00B248_SPI_SHADER_USER_DATA_GS_6},
	{40361, R_00B24C_SPI_SHADER_USER_DATA_GS_7},
	{40387, R_00B250_SPI_SHADER_USER_DATA_GS_8},
	{40413, R_00B254_SPI_SHADER_USER_DATA_GS_9},
	{40439, R_00B258_SPI_SHADER_USER_DATA_GS_10},
	{40466, R_00B25C_SPI_SHADER_USER_DATA_GS_11},
	{40493, R_00B260_SPI_SHADER_USER_DATA_GS_12},
	{40520, R_00B264_SPI_SHADER_USER_DATA_GS_13},
	{40547, R_00B268_SPI_SHADER_USER_DATA_GS_14},
	{40574, R_00B26C_SPI_SHADER_USER_DATA_GS_15},
	{40601, R_00B300_SPI_SHADER_TBA_LO_ES},
	{40622, R_00B304_SPI_SHADER_TBA_HI_ES, 1, 770},
	{40643, R_00B308_SPI_SHADER_TMA_LO_ES},
	{40664, R_00B30C_SPI_SHADER_TMA_HI_ES, 1, 771},
	{40685, R_00B31C_SPI_SHADER_PGM_RSRC3_ES, 4, 772},
	{40709, R_00B320_SPI_SHADER_PGM_LO_ES},
	{40730, R_00B324_SPI_SHADER_PGM_HI_ES, 1, 776},
	{40751, R_00B328_SPI_SHADER_PGM_RSRC1_ES, 12, 777},
	{40775, R_00B32C_SPI_SHADER_PGM_RSRC2_ES, 6, 789},
	{40799, R_00B330_SPI_SHADER_USER_DATA_ES_0},
	{40825, R_00B334_SPI_SHADER_USER_DATA_ES_1},
	{40851, R_00B338_SPI_SHADER_USER_DATA_ES_2},
	{40877, R_00B33C_SPI_SHADER_USER_DATA_ES_3},
	{40903, R_00B340_SPI_SHADER_USER_DATA_ES_4},
	{40929, R_00B344_SPI_SHADER_USER_DATA_ES_5},
	{40955, R_00B348_SPI_SHADER_USER_DATA_ES_6},
	{40981, R_00B34C_SPI_SHADER_USER_DATA_ES_7},
	{41007, R_00B350_SPI_SHADER_USER_DATA_ES_8},
	{41033, R_00B354_SPI_SHADER_USER_DATA_ES_9},
	{41059, R_00B358_SPI_SHADER_USER_DATA_ES_10},
	{41086, R_00B35C_SPI_SHADER_USER_DATA_ES_11},
	{41113, R_00B360_SPI_SHADER_USER_DATA_ES_12},
	{41140, R_00B364_SPI_SHADER_USER_DATA_ES_13},
	{41167, R_00B368_SPI_SHADER_USER_DATA_ES_14},
	{41194, R_00B36C_SPI_SHADER_USER_DATA_ES_15},
	{41221, R_00B400_SPI_SHADER_TBA_LO_HS},
	{41242, R_00B404_SPI_SHADER_TBA_HI_HS, 1, 795},
	{41263, R_00B408_SPI_SHADER_TMA_LO_HS},
	{41284, R_00B40C_SPI_SHADER_TMA_HI_HS, 1, 796},
	{41305, R_00B41C_SPI_SHADER_PGM_RSRC3_HS, 3, 797},
	{41329, R_00B420_SPI_SHADER_PGM_LO_HS},
	{41350, R_00B424_SPI_SHADER_PGM_HI_HS, 1, 800},
	{41371, R_00B428_SPI_SHADER_PGM_RSRC1_HS, 10, 801},
	{41395, R_00B42C_SPI_SHADER_PGM_RSRC2_HS, 6, 811},
	{41419, R_00B430_SPI_SHADER_USER_DATA_HS_0},
	{41445, R_00B434_SPI_SHADER_USER_DATA_HS_1},
	{41471, R_00B438_SPI_SHADER_USER_DATA_HS_2},
	{41497, R_00B43C_SPI_SHADER_USER_DATA_HS_3},
	{41523, R_00B440_SPI_SHADER_USER_DATA_HS_4},
	{41549, R_00B444_SPI_SHADER_USER_DATA_HS_5},
	{41575, R_00B448_SPI_SHADER_USER_DATA_HS_6},
	{41601, R_00B44C_SPI_SHADER_USER_DATA_HS_7},
	{41627, R_00B450_SPI_SHADER_USER_DATA_HS_8},
	{41653, R_00B454_SPI_SHADER_USER_DATA_HS_9},
	{41679, R_00B458_SPI_SHADER_USER_DATA_HS_10},
	{41706, R_00B45C_SPI_SHADER_USER_DATA_HS_11},
	{41733, R_00B460_SPI_SHADER_USER_DATA_HS_12},
	{41760, R_00B464_SPI_SHADER_USER_DATA_HS_13},
	{41787, R_00B468_SPI_SHADER_USER_DATA_HS_14},
	{41814, R_00B46C_SPI_SHADER_USER_DATA_HS_15},
	{41841, R_00B500_SPI_SHADER_TBA_LO_LS},
	{41862, R_00B504_SPI_SHADER_TBA_HI_LS, 1, 817},
	{41883, R_00B508_SPI_SHADER_TMA_LO_LS},
	{41904, R_00B50C_SPI_SHADER_TMA_HI_LS, 1, 818},
	{41925, R_00B51C_SPI_SHADER_PGM_RSRC3_LS, 4, 819},
	{41949, R_00B520_SPI_SHADER_PGM_LO_LS},
	{41970, R_00B524_SPI_SHADER_PGM_HI_LS, 1, 823},
	{41991, R_00B528_SPI_SHADER_PGM_RSRC1_LS, 11, 824},
	{42015, R_00B52C_SPI_SHADER_PGM_RSRC2_LS, 5, 835},
	{42039, R_00B530_SPI_SHADER_USER_DATA_LS_0},
	{42065, R_00B534_SPI_SHADER_USER_DATA_LS_1},
	{42091, R_00B538_SPI_SHADER_USER_DATA_LS_2},
	{42117, R_00B53C_SPI_SHADER_USER_DATA_LS_3},
	{42143, R_00B540_SPI_SHADER_USER_DATA_LS_4},
	{42169, R_00B544_SPI_SHADER_USER_DATA_LS_5},
	{42195, R_00B548_SPI_SHADER_USER_DATA_LS_6},
	{42221, R_00B54C_SPI_SHADER_USER_DATA_LS_7},
	{42247, R_00B550_SPI_SHADER_USER_DATA_LS_8},
	{42273, R_00B554_SPI_SHADER_USER_DATA_LS_9},
	{42299, R_00B558_SPI_SHADER_USER_DATA_LS_10},
	{42326, R_00B55C_SPI_SHADER_USER_DATA_LS_11},
	{42353, R_00B560_SPI_SHADER_USER_DATA_LS_12},
	{42380, R_00B564_SPI_SHADER_USER_DATA_LS_13},
	{42407, R_00B568_SPI_SHADER_USER_DATA_LS_14},
	{42434, R_00B56C_SPI_SHADER_USER_DATA_LS_15},
	{42461, R_00B800_COMPUTE_DISPATCH_INITIATOR, 12, 840},
	{42488, R_00B804_COMPUTE_DIM_X},
	{42502, R_00B808_COMPUTE_DIM_Y},
	{42516, R_00B80C_COMPUTE_DIM_Z},
	{42530, R_00B810_COMPUTE_START_X},
	{42546, R_00B814_COMPUTE_START_Y},
	{42562, R_00B818_COMPUTE_START_Z},
	{42578, R_00B81C_COMPUTE_NUM_THREAD_X, 2, 852},
	{42599, R_00B820_COMPUTE_NUM_THREAD_Y, 2, 854},
	{42620, R_00B824_COMPUTE_NUM_THREAD_Z, 2, 856},
	{42641, R_00B82C_COMPUTE_MAX_WAVE_ID, 1, 858},
	{42661, R_00B828_COMPUTE_PIPELINESTAT_ENABLE, 1, 859},
	{42689, R_00B82C_COMPUTE_PERFCOUNT_ENABLE, 1, 860},
	{42714, R_00B830_COMPUTE_PGM_LO},
	{42729, R_00B834_COMPUTE_PGM_HI, 2, 861},
	{42744, R_00B838_COMPUTE_TBA_LO},
	{42759, R_00B83C_COMPUTE_TBA_HI, 1, 863},
	{42774, R_00B840_COMPUTE_TMA_LO},
	{42789, R_00B844_COMPUTE_TMA_HI, 1, 864},
	{42804, R_00B848_COMPUTE_PGM_RSRC1, 10, 865},
	{42822, R_00B84C_COMPUTE_PGM_RSRC2, 11, 875},
	{42840, R_00B850_COMPUTE_VMID, 1, 886},
	{42853, R_00B854_COMPUTE_RESOURCE_LIMITS, 7, 887},
	{42877, R_00B858_COMPUTE_STATIC_THREAD_MGMT_SE0, 2, 894},
	{42908, R_00B85C_COMPUTE_STATIC_THREAD_MGMT_SE1, 2, 896},
	{42939, R_00B860_COMPUTE_TMPRING_SIZE, 2, 898},
	{42960, R_00B864_COMPUTE_STATIC_THREAD_MGMT_SE2, 2, 900},
	{42991, R_00B868_COMPUTE_STATIC_THREAD_MGMT_SE3, 2, 902},
	{43022, R_00B86C_COMPUTE_RESTART_X},
	{43040, R_00B870_COMPUTE_RESTART_Y},
	{43058, R_00B874_COMPUTE_RESTART_Z},
	{43076, R_00B87C_COMPUTE_MISC_RESERVED, 5, 904},
	{43098, R_00B880_COMPUTE_DISPATCH_ID},
	{43118, R_00B884_COMPUTE_THREADGROUP_ID},
	{43141, R_00B888_COMPUTE_RELAUNCH, 3, 909},
	{43158, R_00B88C_COMPUTE_WAVE_RESTORE_ADDR_LO},
	{43187, R_00B890_COMPUTE_WAVE_RESTORE_ADDR_HI, 1, 912},
	{43216, R_00B894_COMPUTE_WAVE_RESTORE_CONTROL, 2, 913},
	{43245, R_00B900_COMPUTE_USER_DATA_0},
	{43265, R_00B904_COMPUTE_USER_DATA_1},
	{43285, R_00B908_COMPUTE_USER_DATA_2},
	{43305, R_00B90C_COMPUTE_USER_DATA_3},
	{43325, R_00B910_COMPUTE_USER_DATA_4},
	{43345, R_00B914_COMPUTE_USER_DATA_5},
	{43365, R_00B918_COMPUTE_USER_DATA_6},
	{43385, R_00B91C_COMPUTE_USER_DATA_7},
	{43405, R_00B920_COMPUTE_USER_DATA_8},
	{43425, R_00B924_COMPUTE_USER_DATA_9},
	{43445, R_00B928_COMPUTE_USER_DATA_10},
	{43466, R_00B92C_COMPUTE_USER_DATA_11},
	{43487, R_00B930_COMPUTE_USER_DATA_12},
	{43508, R_00B934_COMPUTE_USER_DATA_13},
	{43529, R_00B938_COMPUTE_USER_DATA_14},
	{43550, R_00B93C_COMPUTE_USER_DATA_15},
	{43571, R_00B9FC_COMPUTE_NOWHERE},
	{43587, R_034000_CPG_PERFCOUNTER1_LO},
	{43607, R_034004_CPG_PERFCOUNTER1_HI},
	{43627, R_034008_CPG_PERFCOUNTER0_LO},
	{43647, R_03400C_CPG_PERFCOUNTER0_HI},
	{43667, R_034010_CPC_PERFCOUNTER1_LO},
	{43687, R_034014_CPC_PERFCOUNTER1_HI},
	{43707, R_034018_CPC_PERFCOUNTER0_LO},
	{43727, R_03401C_CPC_PERFCOUNTER0_HI},
	{43747, R_034020_CPF_PERFCOUNTER1_LO},
	{43767, R_034024_CPF_PERFCOUNTER1_HI},
	{43787, R_034028_CPF_PERFCOUNTER0_LO},
	{43807, R_03402C_CPF_PERFCOUNTER0_HI},
	{43827, R_034100_GRBM_PERFCOUNTER0_LO},
	{43848, R_034104_GRBM_PERFCOUNTER0_HI},
	{43869, R_03410C_GRBM_PERFCOUNTER1_LO},
	{43890, R_034110_GRBM_PERFCOUNTER1_HI},
	{43911, R_034114_GRBM_SE0_PERFCOUNTER_LO},
	{43935, R_034118_GRBM_SE0_PERFCOUNTER_HI},
	{43959, R_03411C_GRBM_SE1_PERFCOUNTER_LO},
	{43983, R_034120_GRBM_SE1_PERFCOUNTER_HI},
	{44007, R_034124_GRBM_SE2_PERFCOUNTER_LO},
	{44031, R_034128_GRBM_SE2_PERFCOUNTER_HI},
	{44055, R_03412C_GRBM_SE3_PERFCOUNTER_LO},
	{44079, R_034130_GRBM_SE3_PERFCOUNTER_HI},
	{44103, R_034200_WD_PERFCOUNTER0_LO},
	{44122, R_034204_WD_PERFCOUNTER0_HI},
	{44141, R_034208_WD_PERFCOUNTER1_LO},
	{44160, R_03420C_WD_PERFCOUNTER1_HI},
	{44179, R_034210_WD_PERFCOUNTER2_LO},
	{44198, R_034214_WD_PERFCOUNTER2_HI},
	{44217, R_034218_WD_PERFCOUNTER3_LO},
	{44236, R_03421C_WD_PERFCOUNTER3_HI},
	{44255, R_034220_IA_PERFCOUNTER0_LO},
	{44274, R_034224_IA_PERFCOUNTER0_HI},
	{44293, R_034228_IA_PERFCOUNTER1_LO},
	{44312, R_03422C_IA_PERFCOUNTER1_HI},
	{44331, R_034230_IA_PERFCOUNTER2_LO},
	{44350, R_034234_IA_PERFCOUNTER2_HI},
	{44369, R_034238_IA_PERFCOUNTER3_LO},
	{44388, R_03423C_IA_PERFCOUNTER3_HI},
	{44407, R_034240_VGT_PERFCOUNTER0_LO},
	{44427, R_034244_VGT_PERFCOUNTER0_HI},
	{44447, R_034248_VGT_PERFCOUNTER1_LO},
	{44467, R_03424C_VGT_PERFCOUNTER1_HI},
	{44487, R_034250_VGT_PERFCOUNTER2_LO},
	{44507, R_034254_VGT_PERFCOUNTER2_HI},
	{44527, R_034258_VGT_PERFCOUNTER3_LO},
	{44547, R_03425C_VGT_PERFCOUNTER3_HI},
	{44567, R_034400_PA_SU_PERFCOUNTER0_LO},
	{44589, R_034404_PA_SU_PERFCOUNTER0_HI, 1, 915},
	{44611, R_034408_PA_SU_PERFCOUNTER1_LO},
	{44633, R_03440C_PA_SU_PERFCOUNTER1_HI, 1, 915},
	{44655, R_034410_PA_SU_PERFCOUNTER2_LO},
	{44677, R_034414_PA_SU_PERFCOUNTER2_HI, 1, 915},
	{44699, R_034418_PA_SU_PERFCOUNTER3_LO},
	{44721, R_03441C_PA_SU_PERFCOUNTER3_HI, 1, 915},
	{44743, R_034500_PA_SC_PERFCOUNTER0_LO},
	{44765, R_034504_PA_SC_PERFCOUNTER0_HI},
	{44787, R_034508_PA_SC_PERFCOUNTER1_LO},
	{44809, R_03450C_PA_SC_PERFCOUNTER1_HI},
	{44831, R_034510_PA_SC_PERFCOUNTER2_LO},
	{44853, R_034514_PA_SC_PERFCOUNTER2_HI},
	{44875, R_034518_PA_SC_PERFCOUNTER3_LO},
	{44897, R_03451C_PA_SC_PERFCOUNTER3_HI},
	{44919, R_034520_PA_SC_PERFCOUNTER4_LO},
	{44941, R_034524_PA_SC_PERFCOUNTER4_HI},
	{44963, R_034528_PA_SC_PERFCOUNTER5_LO},
	{44985, R_03452C_PA_SC_PERFCOUNTER5_HI},
	{45007, R_034530_PA_SC_PERFCOUNTER6_LO},
	{45029, R_034534_PA_SC_PERFCOUNTER6_HI},
	{45051, R_034538_PA_SC_PERFCOUNTER7_LO},
	{45073, R_03453C_PA_SC_PERFCOUNTER7_HI},
	{45095, R_034600_SPI_PERFCOUNTER0_HI},
	{45115, R_034604_SPI_PERFCOUNTER0_LO},
	{45135, R_034608_SPI_PERFCOUNTER1_HI},
	{45155, R_03460C_SPI_PERFCOUNTER1_LO},
	{45175, R_034610_SPI_PERFCOUNTER2_HI},
	{45195, R_034614_SPI_PERFCOUNTER2_LO},
	{45215, R_034618_SPI_PERFCOUNTER3_HI},
	{45235, R_03461C_SPI_PERFCOUNTER3_LO},
	{45255, R_034620_SPI_PERFCOUNTER4_HI},
	{45275, R_034624_SPI_PERFCOUNTER4_LO},
	{45295, R_034628_SPI_PERFCOUNTER5_HI},
	{45315, R_03462C_SPI_PERFCOUNTER5_LO},
	{45335, R_034700_SQ_PERFCOUNTER0_LO},
	{45354, R_034704_SQ_PERFCOUNTER0_HI},
	{45373, R_034708_SQ_PERFCOUNTER1_LO},
	{45392, R_03470C_SQ_PERFCOUNTER1_HI},
	{45411, R_034710_SQ_PERFCOUNTER2_LO},
	{45430, R_034714_SQ_PERFCOUNTER2_HI},
	{45449, R_034718_SQ_PERFCOUNTER3_LO},
	{45468, R_03471C_SQ_PERFCOUNTER3_HI},
	{45487, R_034720_SQ_PERFCOUNTER4_LO},
	{45506, R_034724_SQ_PERFCOUNTER4_HI},
	{45525, R_034728_SQ_PERFCOUNTER5_LO},
	{45544, R_03472C_SQ_PERFCOUNTER5_HI},
	{45563, R_034730_SQ_PERFCOUNTER6_LO},
	{45582, R_034734_SQ_PERFCOUNTER6_HI},
	{45601, R_034738_SQ_PERFCOUNTER7_LO},
	{45620, R_03473C_SQ_PERFCOUNTER7_HI},
	{45639, R_034740_SQ_PERFCOUNTER8_LO},
	{45658, R_034744_SQ_PERFCOUNTER8_HI},
	{45677, R_034748_SQ_PERFCOUNTER9_LO},
	{45696, R_03474C_SQ_PERFCOUNTER9_HI},
	{45715, R_034750_SQ_PERFCOUNTER10_LO},
	{45735, R_034754_SQ_PERFCOUNTER10_HI},
	{45755, R_034758_SQ_PERFCOUNTER11_LO},
	{45775, R_03475C_SQ_PERFCOUNTER11_HI},
	{45795, R_034760_SQ_PERFCOUNTER12_LO},
	{45815, R_034764_SQ_PERFCOUNTER12_HI},
	{45835, R_034768_SQ_PERFCOUNTER13_LO},
	{45855, R_03476C_SQ_PERFCOUNTER13_HI},
	{45875, R_034770_SQ_PERFCOUNTER14_LO},
	{45895, R_034774_SQ_PERFCOUNTER14_HI},
	{45915, R_034778_SQ_PERFCOUNTER15_LO},
	{45935, R_03477C_SQ_PERFCOUNTER15_HI},
	{45955, R_034900_SX_PERFCOUNTER0_LO},
	{45974, R_034904_SX_PERFCOUNTER0_HI},
	{45993, R_034908_SX_PERFCOUNTER1_LO},
	{46012, R_03490C_SX_PERFCOUNTER1_HI},
	{46031, R_034910_SX_PERFCOUNTER2_LO},
	{46050, R_034914_SX_PERFCOUNTER2_HI},
	{46069, R_034918_SX_PERFCOUNTER3_LO},
	{46088, R_03491C_SX_PERFCOUNTER3_HI},
	{46107, R_034A00_GDS_PERFCOUNTER0_LO},
	{46127, R_034A04_GDS_PERFCOUNTER0_HI},
	{46147, R_034A08_GDS_PERFCOUNTER1_LO},
	{46167, R_034A0C_GDS_PERFCOUNTER1_HI},
	{46187, R_034A10_GDS_PERFCOUNTER2_LO},
	{46207, R_034A14_GDS_PERFCOUNTER2_HI},
	{46227, R_034A18_GDS_PERFCOUNTER3_LO},
	{46247, R_034A1C_GDS_PERFCOUNTER3_HI},
	{46267, R_034B00_TA_PERFCOUNTER0_LO},
	{46286, R_034B04_TA_PERFCOUNTER0_HI},
	{46305, R_034B08_TA_PERFCOUNTER1_LO},
	{46324, R_034B0C_TA_PERFCOUNTER1_HI},
	{46343, R_034C00_TD_PERFCOUNTER0_LO},
	{46362, R_034C04_TD_PERFCOUNTER0_HI},
	{46381, R_034C08_TD_PERFCOUNTER1_LO},
	{46400, R_034C0C_TD_PERFCOUNTER1_HI},
	{46419, R_034D00_TCP_PERFCOUNTER0_LO},
	{46439, R_034D04_TCP_PERFCOUNTER0_HI},
	{46459, R_034D08_TCP_PERFCOUNTER1_LO},
	{46479, R_034D0C_TCP_PERFCOUNTER1_HI},
	{46499, R_034D10_TCP_PERFCOUNTER2_LO},
	{46519, R_034D14_TCP_PERFCOUNTER2_HI},
	{46539, R_034D18_TCP_PERFCOUNTER3_LO},
	{46559, R_034D1C_TCP_PERFCOUNTER3_HI},
	{46579, R_034E00_TCC_PERFCOUNTER0_LO},
	{46599, R_034E04_TCC_PERFCOUNTER0_HI},
	{46619, R_034E08_TCC_PERFCOUNTER1_LO},
	{46639, R_034E0C_TCC_PERFCOUNTER1_HI},
	{46659, R_034E10_TCC_PERFCOUNTER2_LO},
	{46679, R_034E14_TCC_PERFCOUNTER2_HI},
	{46699, R_034E18_TCC_PERFCOUNTER3_LO},
	{46719, R_034E1C_TCC_PERFCOUNTER3_HI},
	{46739, R_034E40_TCA_PERFCOUNTER0_LO},
	{46759, R_034E44_TCA_PERFCOUNTER0_HI},
	{46779, R_034E48_TCA_PERFCOUNTER1_LO},
	{46799, R_034E4C_TCA_PERFCOUNTER1_HI},
	{46819, R_034E50_TCA_PERFCOUNTER2_LO},
	{46839, R_034E54_TCA_PERFCOUNTER2_HI},
	{46859, R_034E58_TCA_PERFCOUNTER3_LO},
	{46879, R_034E5C_TCA_PERFCOUNTER3_HI},
	{46899, R_035018_CB_PERFCOUNTER0_LO},
	{46918, R_03501C_CB_PERFCOUNTER0_HI},
	{46937, R_035020_CB_PERFCOUNTER1_LO},
	{46956, R_035024_CB_PERFCOUNTER1_HI},
	{46975, R_035028_CB_PERFCOUNTER2_LO},
	{46994, R_03502C_CB_PERFCOUNTER2_HI},
	{47013, R_035030_CB_PERFCOUNTER3_LO},
	{47032, R_035034_CB_PERFCOUNTER3_HI},
	{47051, R_035100_DB_PERFCOUNTER0_LO},
	{47070, R_035104_DB_PERFCOUNTER0_HI},
	{47089, R_035108_DB_PERFCOUNTER1_LO},
	{47108, R_03510C_DB_PERFCOUNTER1_HI},
	{47127, R_035110_DB_PERFCOUNTER2_LO},
	{47146, R_035114_DB_PERFCOUNTER2_HI},
	{47165, R_035118_DB_PERFCOUNTER3_LO},
	{47184, R_03511C_DB_PERFCOUNTER3_HI},
	{47203, R_035200_RLC_PERFCOUNTER0_LO},
	{47223, R_035204_RLC_PERFCOUNTER0_HI},
	{47243, R_035208_RLC_PERFCOUNTER1_LO},
	{47263, R_03520C_RLC_PERFCOUNTER1_HI},
	{47283, R_036000_CPG_PERFCOUNTER1_SELECT, 3, 918},
	{47307, R_036004_CPG_PERFCOUNTER0_SELECT1, 2, 916},
	{47332, R_036008_CPG_PERFCOUNTER0_SELECT, 3, 918},
	{47356, R_03600C_CPC_PERFCOUNTER1_SELECT, 3, 932},
	{47380, R_036010_CPC_PERFCOUNTER0_SELECT1, 2, 921},
	{47405, R_036014_CPF_PERFCOUNTER1_SELECT, 3, 925},
	{47429, R_036018_CPF_PERFCOUNTER0_SELECT1, 2, 923},
	{47454, R_03601C_CPF_PERFCOUNTER0_SELECT, 3, 925},
	{47478, R_036020_CP_PERFMON_CNTL, 4, 928},
	{47494, R_036024_CPC_PERFCOUNTER0_SELECT, 3, 932},
	{47518, R_036100_GRBM_PERFCOUNTER0_SELECT, 19, 935},
	{47543, R_036104_GRBM_PERFCOUNTER1_SELECT, 19, 935},
	{47568, R_036108_GRBM_SE0_PERFCOUNTER_SELECT, 12, 954},
	{47596, R_03610C_GRBM_SE1_PERFCOUNTER_SELECT, 12, 966},
	{47624, R_036110_GRBM_SE2_PERFCOUNTER_SELECT, 12, 978},
	{47652, R_036114_GRBM_SE3_PERFCOUNTER_SELECT, 12, 990},
	{47680, R_036200_WD_PERFCOUNTER0_SELECT, 2, 1002},
	{47703, R_036204_WD_PERFCOUNTER1_SELECT, 2, 1002},
	{47726, R_036208_WD_PERFCOUNTER2_SELECT, 2, 1002},
	{47749, R_03620C_WD_PERFCOUNTER3_SELECT, 2, 1002},
	{47772, R_036210_IA_PERFCOUNTER0_SELECT, 5, 1004},
	{47795, R_036214_IA_PERFCOUNTER1_SELECT, 5, 1004},
	{47818, R_036218_IA_PERFCOUNTER2_SELECT, 5, 1004},
	{47841, R_03621C_IA_PERFCOUNTER3_SELECT, 5, 1004},
	{47864, R_036220_IA_PERFCOUNTER0_SELECT1, 4, 1009},
	{47888, R_036230_VGT_PERFCOUNTER0_SELECT, 5, 1013},
	{47912, R_036234_VGT_PERFCOUNTER1_SELECT, 5, 1013},
	{47936, R_036238_VGT_PERFCOUNTER2_SELECT, 5, 1013},
	{47960, R_03623C_VGT_PERFCOUNTER3_SELECT, 5, 1013},
	{47984, R_036240_VGT_PERFCOUNTER0_SELECT1, 4, 1018},
	{48009, R_036244_VGT_PERFCOUNTER1_SELECT1},
	{48034, R_036250_VGT_PERFCOUNTER_SEID_MASK, 1, 1022},
	{48060, R_036400_PA_SU_PERFCOUNTER0_SELECT, 3, 1023},
	{48086, R_036404_PA_SU_PERFCOUNTER0_SELECT1, 2, 1026},
	{48113, R_036408_PA_SU_PERFCOUNTER1_SELECT, 3, 1023},
	{48139, R_03640C_PA_SU_PERFCOUNTER1_SELECT1},
	{48166, R_036410_PA_SU_PERFCOUNTER2_SELECT, 3, 1023},
	{48192, R_036414_PA_SU_PERFCOUNTER3_SELECT, 3, 1023},
	{48218, R_036500_PA_SC_PERFCOUNTER0_SELECT, 3, 1028},
	{48244, R_036504_PA_SC_PERFCOUNTER0_SELECT1, 2, 1031},
	{48271, R_036508_PA_SC_PERFCOUNTER1_SELECT, 3, 1028},
	{48297, R_03650C_PA_SC_PERFCOUNTER2_SELECT, 3, 1028},
	{48323, R_036510_PA_SC_PERFCOUNTER3_SELECT, 3, 1028},
	{48349, R_036514_PA_SC_PERFCOUNTER4_SELECT, 3, 1028},
	{48375, R_036518_PA_SC_PERFCOUNTER5_SELECT, 3, 1028},
	{48401, R_03651C_PA_SC_PERFCOUNTER6_SELECT, 3, 1028},
	{48427, R_036520_PA_SC_PERFCOUNTER7_SELECT, 3, 1028},
	{48453, R_036600_SPI_PERFCOUNTER0_SELECT, 3, 1033},
	{48477, R_036604_SPI_PERFCOUNTER1_SELECT, 3, 1033},
	{48501, R_036608_SPI_PERFCOUNTER2_SELECT, 3, 1033},
	{48525, R_03660C_SPI_PERFCOUNTER3_SELECT, 3, 1033},
	{48549, R_036610_SPI_PERFCOUNTER0_SELECT1, 2, 1036},
	{48574, R_036614_SPI_PERFCOUNTER1_SELECT1},
	{48599, R_036618_SPI_PERFCOUNTER2_SELECT1},
	{48624, R_03661C_SPI_PERFCOUNTER3_SELECT1},
	{48649, R_036620_SPI_PERFCOUNTER4_SELECT, 3, 1033},
	{48673, R_036624_SPI_PERFCOUNTER5_SELECT, 3, 1033},
	{48697, R_036628_SPI_PERFCOUNTER_BINS, 8, 1038},
	{48718, R_036700_SQ_PERFCOUNTER0_SELECT, 6, 1046},
	{48741, R_036704_SQ_PERFCOUNTER1_SELECT, 6, 1046},
	{48764, R_036708_SQ_PERFCOUNTER2_SELECT, 6, 1046},
	{48787, R_03670C_SQ_PERFCOUNTER3_SELECT, 6, 1046},
	{48810, R_036710_SQ_PERFCOUNTER4_SELECT, 6, 1046},
	{48833, R_036714_SQ_PERFCOUNTER5_SELECT, 6, 1046},
	{48856, R_036718_SQ_PERFCOUNTER6_SELECT, 6, 1046},
	{48879, R_03671C_SQ_PERFCOUNTER7_SELECT, 6, 1046},
	{48902, R_036720_SQ_PERFCOUNTER8_SELECT, 6, 1046},
	{48925, R_036724_SQ_PERFCOUNTER9_SELECT, 6, 1046},
	{48948, R_036728_SQ_PERFCOUNTER10_SELECT, 6, 1046},
	{48972, R_03672C_SQ_PERFCOUNTER11_SELECT, 6, 1046},
	{48996, R_036730_SQ_PERFCOUNTER12_SELECT, 6, 1046},
	{49020, R_036734_SQ_PERFCOUNTER13_SELECT, 6, 1046},
	{49044, R_036738_SQ_PERFCOUNTER14_SELECT, 6, 1046},
	{49068, R_03673C_SQ_PERFCOUNTER15_SELECT, 6, 1046},
	{49092, R_036780_SQ_PERFCOUNTER_CTRL, 9, 1052},
	{49112, R_036784_SQ_PERFCOUNTER_MASK, 2, 1061},
	{49132, R_036788_SQ_PERFCOUNTER_CTRL2, 1, 1063},
	{49153, R_036900_SX_PERFCOUNTER0_SELECT, 3, 1064},
	{49176, R_036904_SX_PERFCOUNTER1_SELECT, 3, 1064},
	{49199, R_036908_SX_PERFCOUNTER2_SELECT, 3, 1064},
	{49222, R_03690C_SX_PERFCOUNTER3_SELECT, 3, 1064},
	{49245, R_036910_SX_PERFCOUNTER0_SELECT1, 2, 1067},
	{49269, R_036914_SX_PERFCOUNTER1_SELECT1},
	{49293, R_036A00_GDS_PERFCOUNTER0_SELECT, 3, 1069},
	{49317, R_036A04_GDS_PERFCOUNTER1_SELECT, 3, 1069},
	{49341, R_036A08_GDS_PERFCOUNTER2_SELECT, 3, 1069},
	{49365, R_036A0C_GDS_PERFCOUNTER3_SELECT, 3, 1069},
	{49389, R_036A10_GDS_PERFCOUNTER0_SELECT1, 2, 1072},
	{49414, R_036B00_TA_PERFCOUNTER0_SELECT, 5, 1074},
	{49437, R_036B04_TA_PERFCOUNTER0_SELECT1, 4, 1079},
	{49461, R_036B08_TA_PERFCOUNTER1_SELECT, 5, 1074},
	{49484, R_036C00_TD_PERFCOUNTER0_SELECT, 5, 1083},
	{49507, R_036C04_TD_PERFCOUNTER0_SELECT1, 4, 1088},
	{49531, R_036C08_TD_PERFCOUNTER1_SELECT, 5, 1083},
	{49554, R_036D00_TCP_PERFCOUNTER0_SELECT, 5, 1092},
	{49578, R_036D04_TCP_PERFCOUNTER0_SELECT1, 4, 1097},
	{49603, R_036D08_TCP_PERFCOUNTER1_SELECT, 5, 1092},
	{49627, R_036D0C_TCP_PERFCOUNTER1_SELECT1},
	{49652, R_036D10_TCP_PERFCOUNTER2_SELECT, 5, 1092},
	{49676, R_036D14_TCP_PERFCOUNTER3_SELECT, 5, 1092},
	{49700, R_036E00_TCC_PERFCOUNTER0_SELECT, 5, 1101},
	{49724, R_036E04_TCC_PERFCOUNTER0_SELECT1, 4, 1106},
	{49749, R_036E08_TCC_PERFCOUNTER1_SELECT, 5, 1101},
	{49773, R_036E0C_TCC_PERFCOUNTER1_SELECT1},
	{49798, R_036E10_TCC_PERFCOUNTER2_SELECT, 5, 1101},
	{49822, R_036E14_TCC_PERFCOUNTER3_SELECT, 5, 1101},
	{49846, R_036E40_TCA_PERFCOUNTER0_SELECT, 5, 1110},
	{49870, R_036E44_TCA_PERFCOUNTER0_SELECT1, 4, 1115},
	{49895, R_036E48_TCA_PERFCOUNTER1_SELECT, 5, 1110},
	{49919, R_036E4C_TCA_PERFCOUNTER1_SELECT1},
	{49944, R_036E50_TCA_PERFCOUNTER2_SELECT, 5, 1110},
	{49968, R_036E54_TCA_PERFCOUNTER3_SELECT, 5, 1110},
	{49992, R_037000_CB_PERFCOUNTER_FILTER, 12, 1119},
	{50014, R_037004_CB_PERFCOUNTER0_SELECT, 5, 1131},
	{50037, R_037008_CB_PERFCOUNTER0_SELECT1, 4, 1136},
	{50061, R_03700C_CB_PERFCOUNTER1_SELECT, 5, 1131},
	{50084, R_037010_CB_PERFCOUNTER2_SELECT, 5, 1131},
	{50107, R_037014_CB_PERFCOUNTER3_SELECT, 5, 1131},
	{50130, R_037100_DB_PERFCOUNTER0_SELECT, 5, 1140},
	{50153, R_037104_DB_PERFCOUNTER0_SELECT1, 4, 1145},
	{50177, R_037108_DB_PERFCOUNTER1_SELECT, 5, 1140},
	{50200, R_03710C_DB_PERFCOUNTER1_SELECT1},
	{50224, R_037110_DB_PERFCOUNTER2_SELECT, 5, 1140},
	{50247, R_037118_DB_PERFCOUNTER3_SELECT, 5, 1140},
	{50270, R_028000_DB_RENDER_CONTROL, 10, 1149},
	{50288, R_028004_DB_COUNT_CONTROL, 9, 1159},
	{50305, R_028008_DB_DEPTH_VIEW, 4, 1168},
	{50319, R_02800C_DB_RENDER_OVERRIDE, 23, 1172},
	{50338, R_028010_DB_RENDER_OVERRIDE2, 15, 1195},
	{50358, R_028014_DB_HTILE_DATA_BASE},
	{50377, R_028020_DB_DEPTH_BOUNDS_MIN},
	{50397, R_028024_DB_DEPTH_BOUNDS_MAX},
	{50417, R_028028_DB_STENCIL_CLEAR, 1, 1210},
	{50434, R_02802C_DB_DEPTH_CLEAR},
	{50449, R_028030_PA_SC_SCREEN_SCISSOR_TL, 2, 1211},
	{50473, R_028034_PA_SC_SCREEN_SCISSOR_BR, 2, 1213},
	{50497, R_02803C_DB_DEPTH_INFO, 7, 1215},
	{50511, R_028040_DB_Z_INFO, 10, 1222},
	{50521, R_028044_DB_STENCIL_INFO, 6, 1232},
	{50537, R_028048_DB_Z_READ_BASE},
	{50552, R_02804C_DB_STENCIL_READ_BASE},
	{50573, R_028050_DB_Z_WRITE_BASE},
	{50589, R_028054_DB_STENCIL_WRITE_BASE},
	{50611, R_028058_DB_DEPTH_SIZE, 2, 1238},
	{50625, R_02805C_DB_DEPTH_SLICE, 1, 1240},
	{50640, R_028080_TA_BC_BASE_ADDR},
	{50656, R_028084_TA_BC_BASE_ADDR_HI, 1, 1241},
	{50675, R_0281E8_COHER_DEST_BASE_HI_0},
	{50696, R_0281EC_COHER_DEST_BASE_HI_1},
	{50717, R_0281F0_COHER_DEST_BASE_HI_2},
	{50738, R_0281F4_COHER_DEST_BASE_HI_3},
	{50759, R_0281F8_COHER_DEST_BASE_2},
	{50777, R_0281FC_COHER_DEST_BASE_3},
	{50795, R_028200_PA_SC_WINDOW_OFFSET, 2, 1242},
	{50815, R_028204_PA_SC_WINDOW_SCISSOR_TL, 3, 1244},
	{50839, R_028208_PA_SC_WINDOW_SCISSOR_BR, 2, 1247},
	{50863, R_02820C_PA_SC_CLIPRECT_RULE, 1, 1249},
	{50883, R_028210_PA_SC_CLIPRECT_0_TL, 2, 1250},
	{50903, R_028214_PA_SC_CLIPRECT_0_BR, 2, 1252},
	{50923, R_028218_PA_SC_CLIPRECT_1_TL, 2, 1250},
	{50943, R_02821C_PA_SC_CLIPRECT_1_BR, 2, 1252},
	{50963, R_028220_PA_SC_CLIPRECT_2_TL, 2, 1250},
	{50983, R_028224_PA_SC_CLIPRECT_2_BR, 2, 1252},
	{51003, R_028228_PA_SC_CLIPRECT_3_TL, 2, 1250},
	{51023, R_02822C_PA_SC_CLIPRECT_3_BR, 2, 1252},
	{51043, R_028230_PA_SC_EDGERULE, 7, 1254},
	{51058, R_028234_PA_SU_HARDWARE_SCREEN_OFFSET, 2, 1261},
	{51087, R_028238_CB_TARGET_MASK, 8, 1263},
	{51102, R_02823C_CB_SHADER_MASK, 8, 1271},
	{51117, R_028240_PA_SC_GENERIC_SCISSOR_TL, 3, 1279},
	{51142, R_028244_PA_SC_GENERIC_SCISSOR_BR, 2, 1282},
	{51167, R_028248_COHER_DEST_BASE_0},
	{51185, R_02824C_COHER_DEST_BASE_1},
	{51203, R_028250_PA_SC_VPORT_SCISSOR_0_TL, 3, 1284},
	{51228, R_028254_PA_SC_VPORT_SCISSOR_0_BR, 2, 1287},
	{51253, R_028258_PA_SC_VPORT_SCISSOR_1_TL, 3, 1284},
	{51278, R_02825C_PA_SC_VPORT_SCISSOR_1_BR, 2, 1287},
	{51303, R_028260_PA_SC_VPORT_SCISSOR_2_TL, 3, 1284},
	{51328, R_028264_PA_SC_VPORT_SCISSOR_2_BR, 2, 1287},
	{51353, R_028268_PA_SC_VPORT_SCISSOR_3_TL, 3, 1284},
	{51378, R_02826C_PA_SC_VPORT_SCISSOR_3_BR, 2, 1287},
	{51403, R_028270_PA_SC_VPORT_SCISSOR_4_TL, 3, 1284},
	{51428, R_028274_PA_SC_VPORT_SCISSOR_4_BR, 2, 1287},
	{51453, R_028278_PA_SC_VPORT_SCISSOR_5_TL, 3, 1284},
	{51478, R_02827C_PA_SC_VPORT_SCISSOR_5_BR, 2, 1287},
	{51503, R_028280_PA_SC_VPORT_SCISSOR_6_TL, 3, 1284},
	{51528, R_028284_PA_SC_VPORT_SCISSOR_6_BR, 2, 1287},
	{51553, R_028288_PA_SC_VPORT_SCISSOR_7_TL, 3, 1284},
	{51578, R_02828C_PA_SC_VPORT_SCISSOR_7_BR, 2, 1287},
	{51603, R_028290_PA_SC_VPORT_SCISSOR_8_TL, 3, 1284},
	{51628, R_028294_PA_SC_VPORT_SCISSOR_8_BR, 2, 1287},
	{51653, R_028298_PA_SC_VPORT_SCISSOR_9_TL, 3, 1284},
	{51678, R_02829C_PA_SC_VPORT_SCISSOR_9_BR, 2, 1287},
	{51703, R_0282A0_PA_SC_VPORT_SCISSOR_10_TL, 3, 1284},
	{51729, R_0282A4_PA_SC_VPORT_SCISSOR_10_BR, 2, 1287},
	{51755, R_0282A8_PA_SC_VPORT_SCISSOR_11_TL, 3, 1284},
	{51781, R_0282AC_PA_SC_VPORT_SCISSOR_11_BR, 2, 1287},
	{51807, R_0282B0_PA_SC_VPORT_SCISSOR_12_TL, 3, 1284},
	{51833, R_0282B4_PA_SC_VPORT_SCISSOR_12_BR, 2, 1287},
	{51859, R_0282B8_PA_SC_VPORT_SCISSOR_13_TL, 3, 1284},
	{51885, R_0282BC_PA_SC_VPORT_SCISSOR_13_BR, 2, 1287},
	{51911, R_0282C0_PA_SC_VPORT_SCISSOR_14_TL, 3, 1284},
	{51937, R_0282C4_PA_SC_VPORT_SCISSOR_14_BR, 2, 1287},
	{51963, R_0282C8_PA_SC_VPORT_SCISSOR_15_TL, 3, 1284},
	{51989, R_0282CC_PA_SC_VPORT_SCISSOR_15_BR, 2, 1287},
	{52015, R_0282D0_PA_SC_VPORT_ZMIN_0},
	{52034, R_0282D4_PA_SC_VPORT_ZMAX_0},
	{52053, R_0282D8_PA_SC_VPORT_ZMIN_1},
	{52072, R_0282DC_PA_SC_VPORT_ZMAX_1},
	{52091, R_0282E0_PA_SC_VPORT_ZMIN_2},
	{52110, R_0282E4_PA_SC_VPORT_ZMAX_2},
	{52129, R_0282E8_PA_SC_VPORT_ZMIN_3},
	{52148, R_0282EC_PA_SC_VPORT_ZMAX_3},
	{52167, R_0282F0_PA_SC_VPORT_ZMIN_4},
	{52186, R_0282F4_PA_SC_VPORT_ZMAX_4},
	{52205, R_0282F8_PA_SC_VPORT_ZMIN_5},
	{52224, R_0282FC_PA_SC_VPORT_ZMAX_5},
	{52243, R_028300_PA_SC_VPORT_ZMIN_6},
	{52262, R_028304_PA_SC_VPORT_ZMAX_6},
	{52281, R_028308_PA_SC_VPORT_ZMIN_7},
	{52300, R_02830C_PA_SC_VPORT_ZMAX_7},
	{52319, R_028310_PA_SC_VPORT_ZMIN_8},
	{52338, R_028314_PA_SC_VPORT_ZMAX_8},
	{52357, R_028318_PA_SC_VPORT_ZMIN_9},
	{52376, R_02831C_PA_SC_VPORT_ZMAX_9},
	{52395, R_028320_PA_SC_VPORT_ZMIN_10},
	{52415, R_028324_PA_SC_VPORT_ZMAX_10},
	{52435, R_028328_PA_SC_VPORT_ZMIN_11},
	{52455, R_02832C_PA_SC_VPORT_ZMAX_11},
	{52475, R_028330_PA_SC_VPORT_ZMIN_12},
	{52495, R_028334_PA_SC_VPORT_ZMAX_12},
	{52515, R_028338_PA_SC_VPORT_ZMIN_13},
	{52535, R_02833C_PA_SC_VPORT_ZMAX_13},
	{52555, R_028340_PA_SC_VPORT_ZMIN_14},
	{52575, R_028344_PA_SC_VPORT_ZMAX_14},
	{52595, R_028348_PA_SC_VPORT_ZMIN_15},
	{52615, R_02834C_PA_SC_VPORT_ZMAX_15},
	{52635, R_028350_PA_SC_RASTER_CONFIG, 15, 1289},
	{52655, R_028354_PA_SC_RASTER_CONFIG_1, 3, 1304},
	{52677, R_028358_PA_SC_SCREEN_EXTENT_CONTROL, 2, 1307},
	{52705, R_028400_VGT_MAX_VTX_INDX},
	{52722, R_028404_VGT_MIN_VTX_INDX},
	{52739, R_028408_VGT_INDX_OFFSET},
	{52755, R_02840C_VGT_MULTI_PRIM_IB_RESET_INDX},
	{52784, R_028414_CB_BLEND_RED},
	{52797, R_028418_CB_BLEND_GREEN},
	{52812, R_02841C_CB_BLEND_BLUE},
	{52826, R_028420_CB_BLEND_ALPHA},
	{52841, R_028424_CB_DCC_CONTROL, 3, 1309},
	{52856, R_02842C_DB_STENCIL_CONTROL, 6, 1312},
	{52875, R_028430_DB_STENCILREFMASK, 4, 1318},
	{52893, R_028434_DB_STENCILREFMASK_BF, 4, 1322},
	{52914, R_02843C_PA_CL_VPORT_XSCALE},
	{52933, R_028440_PA_CL_VPORT_XOFFSET},
	{52953, R_028444_PA_CL_VPORT_YSCALE},
	{52972, R_028448_PA_CL_VPORT_YOFFSET},
	{52992, R_02844C_PA_CL_VPORT_ZSCALE},
	{53011, R_028450_PA_CL_VPORT_ZOFFSET},
	{53031, R_028454_PA_CL_VPORT_XSCALE_1},
	{53052, R_028458_PA_CL_VPORT_XOFFSET_1},
	{53074, R_02845C_PA_CL_VPORT_YSCALE_1},
	{53095, R_028460_PA_CL_VPORT_YOFFSET_1},
	{53117, R_028464_PA_CL_VPORT_ZSCALE_1},
	{53138, R_028468_PA_CL_VPORT_ZOFFSET_1},
	{53160, R_02846C_PA_CL_VPORT_XSCALE_2},
	{53181, R_028470_PA_CL_VPORT_XOFFSET_2},
	{53203, R_028474_PA_CL_VPORT_YSCALE_2},
	{53224, R_028478_PA_CL_VPORT_YOFFSET_2},
	{53246, R_02847C_PA_CL_VPORT_ZSCALE_2},
	{53267, R_028480_PA_CL_VPORT_ZOFFSET_2},
	{53289, R_028484_PA_CL_VPORT_XSCALE_3},
	{53310, R_028488_PA_CL_VPORT_XOFFSET_3},
	{53332, R_02848C_PA_CL_VPORT_YSCALE_3},
	{53353, R_028490_PA_CL_VPORT_YOFFSET_3},
	{53375, R_028494_PA_CL_VPORT_ZSCALE_3},
	{53396, R_028498_PA_CL_VPORT_ZOFFSET_3},
	{53418, R_02849C_PA_CL_VPORT_XSCALE_4},
	{53439, R_0284A0_PA_CL_VPORT_XOFFSET_4},
	{53461, R_0284A4_PA_CL_VPORT_YSCALE_4},
	{53482, R_0284A8_PA_CL_VPORT_YOFFSET_4},
	{53504, R_0284AC_PA_CL_VPORT_ZSCALE_4},
	{53525, R_0284B0_PA_CL_VPORT_ZOFFSET_4},
	{53547, R_0284B4_PA_CL_VPORT_XSCALE_5},
	{53568, R_0284B8_PA_CL_VPORT_XOFFSET_5},
	{53590, R_0284BC_PA_CL_VPORT_YSCALE_5},
	{53611, R_0284C0_PA_CL_VPORT_YOFFSET_5},
	{53633, R_0284C4_PA_CL_VPORT_ZSCALE_5},
	{53654, R_0284C8_PA_CL_VPORT_ZOFFSET_5},
	{53676, R_0284CC_PA_CL_VPORT_XSCALE_6},
	{53697, R_0284D0_PA_CL_VPORT_XOFFSET_6},
	{53719, R_0284D4_PA_CL_VPORT_YSCALE_6},
	{53740, R_0284D8_PA_CL_VPORT_YOFFSET_6},
	{53762, R_0284DC_PA_CL_VPORT_ZSCALE_6},
	{53783, R_0284E0_PA_CL_VPORT_ZOFFSET_6},
	{53805, R_0284E4_PA_CL_VPORT_XSCALE_7},
	{53826, R_0284E8_PA_CL_VPORT_XOFFSET_7},
	{53848, R_0284EC_PA_CL_VPORT_YSCALE_7},
	{53869, R_0284F0_PA_CL_VPORT_YOFFSET_7},
	{53891, R_0284F4_PA_CL_VPORT_ZSCALE_7},
	{53912, R_0284F8_PA_CL_VPORT_ZOFFSET_7},
	{53934, R_0284FC_PA_CL_VPORT_XSCALE_8},
	{53955, R_028500_PA_CL_VPORT_XOFFSET_8},
	{53977, R_028504_PA_CL_VPORT_YSCALE_8},
	{53998, R_028508_PA_CL_VPORT_YOFFSET_8},
	{54020, R_02850C_PA_CL_VPORT_ZSCALE_8},
	{54041, R_028510_PA_CL_VPORT_ZOFFSET_8},
	{54063, R_028514_PA_CL_VPORT_XSCALE_9},
	{54084, R_028518_PA_CL_VPORT_XOFFSET_9},
	{54106, R_02851C_PA_CL_VPORT_YSCALE_9},
	{54127, R_028520_PA_CL_VPORT_YOFFSET_9},
	{54149, R_028524_PA_CL_VPORT_ZSCALE_9},
	{54170, R_028528_PA_CL_VPORT_ZOFFSET_9},
	{54192, R_02852C_PA_CL_VPORT_XSCALE_10},
	{54214, R_028530_PA_CL_VPORT_XOFFSET_10},
	{54237, R_028534_PA_CL_VPORT_YSCALE_10},
	{54259, R_028538_PA_CL_VPORT_YOFFSET_10},
	{54282, R_02853C_PA_CL_VPORT_ZSCALE_10},
	{54304, R_028540_PA_CL_VPORT_ZOFFSET_10},
	{54327, R_028544_PA_CL_VPORT_XSCALE_11},
	{54349, R_028548_PA_CL_VPORT_XOFFSET_11},
	{54372, R_02854C_PA_CL_VPORT_YSCALE_11},
	{54394, R_028550_PA_CL_VPORT_YOFFSET_11},
	{54417, R_028554_PA_CL_VPORT_ZSCALE_11},
	{54439, R_028558_PA_CL_VPORT_ZOFFSET_11},
	{54462, R_02855C_PA_CL_VPORT_XSCALE_12},
	{54484, R_028560_PA_CL_VPORT_XOFFSET_12},
	{54507, R_028564_PA_CL_VPORT_YSCALE_12},
	{54529, R_028568_PA_CL_VPORT_YOFFSET_12},
	{54552, R_02856C_PA_CL_VPORT_ZSCALE_12},
	{54574, R_028570_PA_CL_VPORT_ZOFFSET_12},
	{54597, R_028574_PA_CL_VPORT_XSCALE_13},
	{54619, R_028578_PA_CL_VPORT_XOFFSET_13},
	{54642, R_02857C_PA_CL_VPORT_YSCALE_13},
	{54664, R_028580_PA_CL_VPORT_YOFFSET_13},
	{54687, R_028584_PA_CL_VPORT_ZSCALE_13},
	{54709, R_028588_PA_CL_VPORT_ZOFFSET_13},
	{54732, R_02858C_PA_CL_VPORT_XSCALE_14},
	{54754, R_028590_PA_CL_VPORT_XOFFSET_14},
	{54777, R_028594_PA_CL_VPORT_YSCALE_14},
	{54799, R_028598_PA_CL_VPORT_YOFFSET_14},
	{54822, R_02859C_PA_CL_VPORT_ZSCALE_14},
	{54844, R_0285A0_PA_CL_VPORT_ZOFFSET_14},
	{54867, R_0285A4_PA_CL_VPORT_XSCALE_15},
	{54889, R_0285A8_PA_CL_VPORT_XOFFSET_15},
	{54912, R_0285AC_PA_CL_VPORT_YSCALE_15},
	{54934, R_0285B0_PA_CL_VPORT_YOFFSET_15},
	{54957, R_0285B4_PA_CL_VPORT_ZSCALE_15},
	{54979, R_0285B8_PA_CL_VPORT_ZOFFSET_15},
	{55002, R_0285BC_PA_CL_UCP_0_X},
	{55016, R_0285C0_PA_CL_UCP_0_Y},
	{55030, R_0285C4_PA_CL_UCP_0_Z},
	{55044, R_0285C8_PA_CL_UCP_0_W},
	{55058, R_0285CC_PA_CL_UCP_1_X},
	{55072, R_0285D0_PA_CL_UCP_1_Y},
	{55086, R_0285D4_PA_CL_UCP_1_Z},
	{55100, R_0285D8_PA_CL_UCP_1_W},
	{55114, R_0285DC_PA_CL_UCP_2_X},
	{55128, R_0285E0_PA_CL_UCP_2_Y},
	{55142, R_0285E4_PA_CL_UCP_2_Z},
	{55156, R_0285E8_PA_CL_UCP_2_W},
	{55170, R_0285EC_PA_CL_UCP_3_X},
	{55184, R_0285F0_PA_CL_UCP_3_Y},
	{55198, R_0285F4_PA_CL_UCP_3_Z},
	{55212, R_0285F8_PA_CL_UCP_3_W},
	{55226, R_0285FC_PA_CL_UCP_4_X},
	{55240, R_028600_PA_CL_UCP_4_Y},
	{55254, R_028604_PA_CL_UCP_4_Z},
	{55268, R_028608_PA_CL_UCP_4_W},
	{55282, R_02860C_PA_CL_UCP_5_X},
	{55296, R_028610_PA_CL_UCP_5_Y},
	{55310, R_028614_PA_CL_UCP_5_Z},
	{55324, R_028618_PA_CL_UCP_5_W},
	{55338, R_028644_SPI_PS_INPUT_CNTL_0, 12, 1326},
	{55358, R_028648_SPI_PS_INPUT_CNTL_1, 12, 1326},
	{55378, R_02864C_SPI_PS_INPUT_CNTL_2, 12, 1326},
	{55398, R_028650_SPI_PS_INPUT_CNTL_3, 12, 1326},
	{55418, R_028654_SPI_PS_INPUT_CNTL_4, 12, 1326},
	{55438, R_028658_SPI_PS_INPUT_CNTL_5, 12, 1326},
	{55458, R_02865C_SPI_PS_INPUT_CNTL_6, 12, 1326},
	{55478, R_028660_SPI_PS_INPUT_CNTL_7, 12, 1326},
	{55498, R_028664_SPI_PS_INPUT_CNTL_8, 12, 1326},
	{55518, R_028668_SPI_PS_INPUT_CNTL_9, 12, 1326},
	{55538, R_02866C_SPI_PS_INPUT_CNTL_10, 12, 1326},
	{55559, R_028670_SPI_PS_INPUT_CNTL_11, 12, 1326},
	{55580, R_028674_SPI_PS_INPUT_CNTL_12, 12, 1326},
	{55601, R_028678_SPI_PS_INPUT_CNTL_13, 12, 1326},
	{55622, R_02867C_SPI_PS_INPUT_CNTL_14, 12, 1326},
	{55643, R_028680_SPI_PS_INPUT_CNTL_15, 12, 1326},
	{55664, R_028684_SPI_PS_INPUT_CNTL_16, 12, 1326},
	{55685, R_028688_SPI_PS_INPUT_CNTL_17, 12, 1326},
	{55706, R_02868C_SPI_PS_INPUT_CNTL_18, 12, 1326},
	{55727, R_028690_SPI_PS_INPUT_CNTL_19, 12, 1326},
	{55748, R_028694_SPI_PS_INPUT_CNTL_20, 12, 1326},
	{55769, R_028698_SPI_PS_INPUT_CNTL_21, 12, 1326},
	{55790, R_02869C_SPI_PS_INPUT_CNTL_22, 12, 1326},
	{55811, R_0286A0_SPI_PS_INPUT_CNTL_23, 12, 1326},
	{55832, R_0286A4_SPI_PS_INPUT_CNTL_24, 12, 1326},
	{55853, R_0286A8_SPI_PS_INPUT_CNTL_25, 12, 1326},
	{55874, R_0286AC_SPI_PS_INPUT_CNTL_26, 12, 1326},
	{55895, R_0286B0_SPI_PS_INPUT_CNTL_27, 12, 1326},
	{55916, R_0286B4_SPI_PS_INPUT_CNTL_28, 12, 1326},
	{55937, R_0286B8_SPI_PS_INPUT_CNTL_29, 12, 1326},
	{55958, R_0286BC_SPI_PS_INPUT_CNTL_30, 12, 1326},
	{55979, R_0286C0_SPI_PS_INPUT_CNTL_31, 12, 1326},
	{56000, R_0286C4_SPI_VS_OUT_CONFIG, 4, 1338},
	{56018, R_0286CC_SPI_PS_INPUT_ENA, 16, 1342},
	{56035, R_0286D0_SPI_PS_INPUT_ADDR, 16, 1358},
	{56053, R_0286D4_SPI_INTERP_CONTROL_0, 7, 1374},
	{56074, R_0286D8_SPI_PS_IN_CONTROL, 5, 1381},
	{56092, R_0286E0_SPI_BARYC_CNTL, 7, 1386},
	{56107, R_0286E8_SPI_TMPRING_SIZE, 2, 1393},
	{56124, R_028704_SPI_WAVE_MGMT_1, 5, 1395},
	{56140, R_028708_SPI_WAVE_MGMT_2, 1, 1400},
	{56156, R_02870C_SPI_SHADER_POS_FORMAT, 4, 1401},
	{56178, R_028710_SPI_SHADER_Z_FORMAT, 1, 1405},
	{56198, R_028714_SPI_SHADER_COL_FORMAT, 8, 1406},
	{56220, R_028754_SX_PS_DOWNCONVERT, 8, 1414},
	{56238, R_028758_SX_BLEND_OPT_EPSILON, 8, 1422},
	{56259, R_02875C_SX_BLEND_OPT_CONTROL, 17, 1430},
	{56280, R_028760_SX_MRT0_BLEND_OPT, 6, 1447},
	{56298, R_028764_SX_MRT1_BLEND_OPT, 6, 1453},
	{56316, R_028768_SX_MRT2_BLEND_OPT, 6, 1459},
	{56334, R_02876C_SX_MRT3_BLEND_OPT, 6, 1465},
	{56352, R_028770_SX_MRT4_BLEND_OPT, 6, 1471},
	{56370, R_028774_SX_MRT5_BLEND_OPT, 6, 1477},
	{56388, R_028778_SX_MRT6_BLEND_OPT, 6, 1483},
	{56406, R_02877C_SX_MRT7_BLEND_OPT, 6, 1489},
	{56424, R_028780_CB_BLEND0_CONTROL, 9, 1495},
	{56442, R_028784_CB_BLEND1_CONTROL, 9, 1495},
	{56460, R_028788_CB_BLEND2_CONTROL, 9, 1495},
	{56478, R_02878C_CB_BLEND3_CONTROL, 9, 1495},
	{56496, R_028790_CB_BLEND4_CONTROL, 9, 1495},
	{56514, R_028794_CB_BLEND5_CONTROL, 9, 1495},
	{56532, R_028798_CB_BLEND6_CONTROL, 9, 1495},
	{56550, R_02879C_CB_BLEND7_CONTROL, 9, 1495},
	{56568, R_0287CC_CS_COPY_STATE, 1, 1504},
	{56582, R_0287D4_PA_CL_POINT_X_RAD},
	{56600, R_0287D8_PA_CL_POINT_Y_RAD},
	{56618, R_0287DC_PA_CL_POINT_SIZE},
	{56635, R_0287E0_PA_CL_POINT_CULL_RAD},
	{56656, R_0287E4_VGT_DMA_BASE_HI, 1, 1505},
	{56672, R_0287E8_VGT_DMA_BASE},
	{56685, R_0287F0_VGT_DRAW_INITIATOR, 4, 1506},
	{56704, R_0287F4_VGT_IMMED_DATA},
	{56719, R_0287F8_VGT_EVENT_ADDRESS_REG, 1, 1510},
	{56741, R_028800_DB_DEPTH_CONTROL, 10, 1511},
	{56758, R_028804_DB_EQAA, 12, 1521},
	{56766, R_028808_CB_COLOR_CONTROL, 4, 1533},
	{56783, R_02880C_DB_SHADER_CONTROL, 13, 1537},
	{56801, R_028810_PA_CL_CLIP_CNTL, 19, 1550},
	{56817, R_028814_PA_SU_SC_MODE_CNTL, 13, 1569},
	{56836, R_028818_PA_CL_VTE_CNTL, 9, 1582},
	{56851, R_02881C_PA_CL_VS_OUT_CNTL, 27, 1591},
	{56869, R_028820_PA_CL_NANINF_CNTL, 16, 1618},
	{56887, R_028824_PA_SU_LINE_STIPPLE_CNTL, 4, 1634},
	{56911, R_028828_PA_SU_LINE_STIPPLE_SCALE},
	{56936, R_02882C_PA_SU_PRIM_FILTER_CNTL, 11, 1638},
	{56959, R_028830_PA_SU_SMALL_PRIM_FILTER_CNTL, 5, 1649},
	{56988, R_028A00_PA_SU_POINT_SIZE, 2, 1654},
	{57005, R_028A04_PA_SU_POINT_MINMAX, 2, 1656},
	{57024, R_028A08_PA_SU_LINE_CNTL, 1, 1658},
	{57040, R_028A0C_PA_SC_LINE_STIPPLE, 4, 1659},
	{57059, R_028A10_VGT_OUTPUT_PATH_CNTL, 1, 1663},
	{57080, R_028A14_VGT_HOS_CNTL, 1, 1664},
	{57093, R_028A18_VGT_HOS_MAX_TESS_LEVEL},
	{57116, R_028A1C_VGT_HOS_MIN_TESS_LEVEL},
	{57139, R_028A20_VGT_HOS_REUSE_DEPTH, 1, 1665},
	{57159, R_028A24_VGT_GROUP_PRIM_TYPE, 4, 1666},
	{57179, R_028A28_VGT_GROUP_FIRST_DECR, 1, 1670},
	{57200, R_028A2C_VGT_GROUP_DECR, 1, 1671},
	{57215, R_028A30_VGT_GROUP_VECT_0_CNTL, 6, 1672},
	{57237, R_028A34_VGT_GROUP_VECT_1_CNTL, 6, 1678},
	{57259, R_028A38_VGT_GROUP_VECT_0_FMT_CNTL, 8, 1684},
	{57285, R_028A3C_VGT_GROUP_VECT_1_FMT_CNTL, 8, 1692},
	{57311, R_028A40_VGT_GS_MODE, 15, 1700},
	{57323, R_028A44_VGT_GS_ONCHIP_CNTL, 2, 1715},
	{57342, R_028A48_PA_SC_MODE_CNTL_0, 4, 1717},
	{57360, R_028A4C_PA_SC_MODE_CNTL_1, 24, 1721},
	{57378, R_028A50_VGT_ENHANCE},
	{57390, R_028A54_VGT_GS_PER_ES, 1, 1745},
	{57404, R_028A58_VGT_ES_PER_GS, 1, 1746},
	{57418, R_028A5C_VGT_GS_PER_VS, 1, 1747},
	{57432, R_028A60_VGT_GSVS_RING_OFFSET_1, 1, 1748},
	{57455, R_028A64_VGT_GSVS_RING_OFFSET_2, 1, 1749},
	{57478, R_028A68_VGT_GSVS_RING_OFFSET_3, 1, 1750},
	{57501, R_028A6C_VGT_GS_OUT_PRIM_TYPE, 5, 1751},
	{57522, R_028A70_IA_ENHANCE},
	{57533, R_028A74_VGT_DMA_SIZE},
	{57546, R_028A78_VGT_DMA_MAX_SIZE},
	{57563, R_028A7C_VGT_DMA_INDEX_TYPE, 9, 1756},
	{57582, R_028A80_WD_ENHANCE},
	{57593, R_028A84_VGT_PRIMITIVEID_EN, 2, 1765},
	{57612, R_028A88_VGT_DMA_NUM_INSTANCES},
	{57634, R_028A8C_VGT_PRIMITIVEID_RESET},
	{57656, R_028A90_VGT_EVENT_INITIATOR, 3, 1767},
	{57676, R_028A94_VGT_MULTI_PRIM_IB_RESET_EN, 1, 1770},
	{57703, R_028AA0_VGT_INSTANCE_STEP_RATE_0},
	{57728, R_028AA4_VGT_INSTANCE_STEP_RATE_1},
	{57753, R_028AA8_IA_MULTI_VGT_PARAM, 7, 1771},
	{57772, R_028AAC_VGT_ESGS_RING_ITEMSIZE, 1, 1778},
	{57795, R_028AB0_VGT_GSVS_RING_ITEMSIZE, 1, 1779},
	{57818, R_028AB4_VGT_REUSE_OFF, 1, 1780},
	{57832, R_028AB8_VGT_VTX_CNT_EN, 1, 1781},
	{57847, R_028ABC_DB_HTILE_SURFACE, 8, 1782},
	{57864, R_028AC0_DB_SRESULTS_COMPARE_STATE0, 4, 1790},
	{57891, R_028AC4_DB_SRESULTS_COMPARE_STATE1, 4, 1794},
	{57918, R_028AC8_DB_PRELOAD_CONTROL, 4, 1798},
	{57937, R_028AD0_VGT_STRMOUT_BUFFER_SIZE_0},
	{57963, R_028AD4_VGT_STRMOUT_VTX_STRIDE_0, 1, 1802},
	{57988, R_028ADC_VGT_STRMOUT_BUFFER_OFFSET_0},
	{58016, R_028AE0_VGT_STRMOUT_BUFFER_SIZE_1},
	{58042, R_028AE4_VGT_STRMOUT_VTX_STRIDE_1, 1, 1803},
	{58067, R_028AEC_VGT_STRMOUT_BUFFER_OFFSET_1},
	{58095, R_028AF0_VGT_STRMOUT_BUFFER_SIZE_2},
	{58121, R_028AF4_VGT_STRMOUT_VTX_STRIDE_2, 1, 1804},
	{58146, R_028AFC_VGT_STRMOUT_BUFFER_OFFSET_2},
	{58174, R_028B00_VGT_STRMOUT_BUFFER_SIZE_3},
	{58200, R_028B04_VGT_STRMOUT_VTX_STRIDE_3, 1, 1805},
	{58225, R_028B0C_VGT_STRMOUT_BUFFER_OFFSET_3},
	{58253, R_028B28_VGT_STRMOUT_DRAW_OPAQUE_OFFSET},
	{58284, R_028B2C_VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE},
	{58327, R_028B30_VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE, 1, 1806},
	{58365, R_028B38_VGT_GS_MAX_VERT_OUT, 1, 1807},
	{58385, R_028B50_VGT_TESS_DISTRIBUTION, 5, 1808},
	{58407, R_028B54_VGT_SHADER_STAGES_EN, 10, 1813},
	{58428, R_028B58_VGT_LS_HS_CONFIG, 3, 1823},
	{58445, R_028B5C_VGT_GS_VERT_ITEMSIZE, 1, 1826},
	{58466, R_028B60_VGT_GS_VERT_ITEMSIZE_1, 1, 1827},
	{58489, R_028B64_VGT_GS_VERT_ITEMSIZE_2, 1, 1828},
	{58512, R_028B68_VGT_GS_VERT_ITEMSIZE_3, 1, 1829},
	{58535, R_028B6C_VGT_TF_PARAM, 11, 1830},
	{58548, R_028B70_DB_ALPHA_TO_MASK, 6, 1841},
	{58565, R_028B74_VGT_DISPATCH_DRAW_INDEX},
	{58589, R_028B78_PA_SU_POLY_OFFSET_DB_FMT_CNTL, 2, 1847},
	{58619, R_028B7C_PA_SU_POLY_OFFSET_CLAMP},
	{58643, R_028B80_PA_SU_POLY_OFFSET_FRONT_SCALE},
	{58673, R_028B84_PA_SU_POLY_OFFSET_FRONT_OFFSET},
	{58704, R_028B88_PA_SU_POLY_OFFSET_BACK_SCALE},
	{58733, R_028B8C_PA_SU_POLY_OFFSET_BACK_OFFSET},
	{58763, R_028B90_VGT_GS_INSTANCE_CNT, 2, 1849},
	{58783, R_028B94_VGT_STRMOUT_CONFIG, 7, 1851},
	{58802, R_028B98_VGT_STRMOUT_BUFFER_CONFIG, 4, 1858},
	{58828, R_028BD4_PA_SC_CENTROID_PRIORITY_0, 8, 1862},
	{58854, R_028BD8_PA_SC_CENTROID_PRIORITY_1, 8, 1870},
	{58880, R_028BDC_PA_SC_LINE_CNTL, 4, 1878},
	{58896, R_028BE0_PA_SC_AA_CONFIG, 5, 1882},
	{58912, R_028BE4_PA_SU_VTX_CNTL, 3, 1887},
	{58927, R_028BE8_PA_CL_GB_VERT_CLIP_ADJ},
	{58950, R_028BEC_PA_CL_GB_VERT_DISC_ADJ},
	{58973, R_028BF0_PA_CL_GB_HORZ_CLIP_ADJ},
	{58996, R_028BF4_PA_CL_GB_HORZ_DISC_ADJ},
	{59019, R_028BF8_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0, 8, 1890},
	{59053, R_028BFC_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1, 8, 1898},
	{59087, R_028C00_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2, 8, 1906},
	{59121, R_028C04_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3, 8, 1914},
	{59155, R_028C08_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0, 8, 1922},
	{59189, R_028C0C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1, 8, 1930},
	{59223, R_028C10_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2, 8, 1938},
	{59257, R_028C14_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3, 8, 1946},
	{59291, R_028C18_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0, 8, 1954},
	{59325, R_028C1C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1, 8, 1962},
	{59359, R_028C20_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2, 8, 1970},
	{59393, R_028C24_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3, 8, 1978},
	{59427, R_028C28_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0, 8, 1986},
	{59461, R_028C2C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1, 8, 1994},
	{59495, R_028C30_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2, 8, 2002},
	{59529, R_028C34_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3, 8, 2010},
	{59563, R_028C38_PA_SC_AA_MASK_X0Y0_X1Y0, 2, 2018},
	{59587, R_028C3C_PA_SC_AA_MASK_X0Y1_X1Y1, 2, 2020},
	{59611, R_028C40_PA_SC_SHADER_CONTROL, 1, 2022},
	{59632, R_028C58_VGT_VERTEX_REUSE_BLOCK_CNTL, 1, 2023},
	{59660, R_028C5C_VGT_OUT_DEALLOC_CNTL, 1, 2024},
	{59681, R_028C60_CB_COLOR0_BASE},
	{59696, R_028C64_CB_COLOR0_PITCH, 2, 2025},
	{59712, R_028C68_CB_COLOR0_SLICE, 1, 2027},
	{59728, R_028C6C_CB_COLOR0_VIEW, 2, 2028},
	{59743, R_028C70_CB_COLOR0_INFO, 18, 2030},
	{59758, R_028C74_CB_COLOR0_ATTRIB, 6, 2048},
	{59775, R_028C78_CB_COLOR0_DCC_CONTROL, 9, 2054},
	{59797, R_028C7C_CB_COLOR0_CMASK},
	{59813, R_028C80_CB_COLOR0_CMASK_SLICE, 1, 2063},
	{59835, R_028C84_CB_COLOR0_FMASK},
	{59851, R_028C88_CB_COLOR0_FMASK_SLICE, 1, 2064},
	{59873, R_028C8C_CB_COLOR0_CLEAR_WORD0},
	{59895, R_028C90_CB_COLOR0_CLEAR_WORD1},
	{59917, R_028C94_CB_COLOR0_DCC_BASE},
	{59936, R_028C9C_CB_COLOR1_BASE},
	{59951, R_028CA0_CB_COLOR1_PITCH, 2, 2025},
	{59967, R_028CA4_CB_COLOR1_SLICE, 1, 2027},
	{59983, R_028CA8_CB_COLOR1_VIEW, 2, 2028},
	{59998, R_028CAC_CB_COLOR1_INFO, 18, 2030},
	{60013, R_028CB0_CB_COLOR1_ATTRIB, 6, 2048},
	{60030, R_028CB4_CB_COLOR1_DCC_CONTROL, 9, 2054},
	{60052, R_028CB8_CB_COLOR1_CMASK},
	{60068, R_028CBC_CB_COLOR1_CMASK_SLICE, 1, 2063},
	{60090, R_028CC0_CB_COLOR1_FMASK},
	{60106, R_028CC4_CB_COLOR1_FMASK_SLICE, 1, 2064},
	{60128, R_028CC8_CB_COLOR1_CLEAR_WORD0},
	{60150, R_028CCC_CB_COLOR1_CLEAR_WORD1},
	{60172, R_028CD0_CB_COLOR1_DCC_BASE},
	{60191, R_028CD8_CB_COLOR2_BASE},
	{60206, R_028CDC_CB_COLOR2_PITCH, 2, 2025},
	{60222, R_028CE0_CB_COLOR2_SLICE, 1, 2027},
	{60238, R_028CE4_CB_COLOR2_VIEW, 2, 2028},
	{60253, R_028CE8_CB_COLOR2_INFO, 18, 2030},
	{60268, R_028CEC_CB_COLOR2_ATTRIB, 6, 2048},
	{60285, R_028CF0_CB_COLOR2_DCC_CONTROL, 9, 2054},
	{60307, R_028CF4_CB_COLOR2_CMASK},
	{60323, R_028CF8_CB_COLOR2_CMASK_SLICE, 1, 2063},
	{60345, R_028CFC_CB_COLOR2_FMASK},
	{60361, R_028D00_CB_COLOR2_FMASK_SLICE, 1, 2064},
	{60383, R_028D04_CB_COLOR2_CLEAR_WORD0},
	{60405, R_028D08_CB_COLOR2_CLEAR_WORD1},
	{60427, R_028D0C_CB_COLOR2_DCC_BASE},
	{60446, R_028D14_CB_COLOR3_BASE},
	{60461, R_028D18_CB_COLOR3_PITCH, 2, 2025},
	{60477, R_028D1C_CB_COLOR3_SLICE, 1, 2027},
	{60493, R_028D20_CB_COLOR3_VIEW, 2, 2028},
	{60508, R_028D24_CB_COLOR3_INFO, 18, 2030},
	{60523, R_028D28_CB_COLOR3_ATTRIB, 6, 2048},
	{60540, R_028D2C_CB_COLOR3_DCC_CONTROL, 9, 2054},
	{60562, R_028D30_CB_COLOR3_CMASK},
	{60578, R_028D34_CB_COLOR3_CMASK_SLICE, 1, 2063},
	{60600, R_028D38_CB_COLOR3_FMASK},
	{60616, R_028D3C_CB_COLOR3_FMASK_SLICE, 1, 2064},
	{60638, R_028D40_CB_COLOR3_CLEAR_WORD0},
	{60660, R_028D44_CB_COLOR3_CLEAR_WORD1},
	{60682, R_028D48_CB_COLOR3_DCC_BASE},
	{60701, R_028D50_CB_COLOR4_BASE},
	{60716, R_028D54_CB_COLOR4_PITCH, 2, 2025},
	{60732, R_028D58_CB_COLOR4_SLICE, 1, 2027},
	{60748, R_028D5C_CB_COLOR4_VIEW, 2, 2028},
	{60763, R_028D60_CB_COLOR4_INFO, 18, 2030},
	{60778, R_028D64_CB_COLOR4_ATTRIB, 6, 2048},
	{60795, R_028D68_CB_COLOR4_DCC_CONTROL, 9, 2054},
	{60817, R_028D6C_CB_COLOR4_CMASK},
	{60833, R_028D70_CB_COLOR4_CMASK_SLICE, 1, 2063},
	{60855, R_028D74_CB_COLOR4_FMASK},
	{60871, R_028D78_CB_COLOR4_FMASK_SLICE, 1, 2064},
	{60893, R_028D7C_CB_COLOR4_CLEAR_WORD0},
	{60915, R_028D80_CB_COLOR4_CLEAR_WORD1},
	{60937, R_028D84_CB_COLOR4_DCC_BASE},
	{60956, R_028D8C_CB_COLOR5_BASE},
	{60971, R_028D90_CB_COLOR5_PITCH, 2, 2025},
	{60987, R_028D94_CB_COLOR5_SLICE, 1, 2027},
	{61003, R_028D98_CB_COLOR5_VIEW, 2, 2028},
	{61018, R_028D9C_CB_COLOR5_INFO, 18, 2030},
	{61033, R_028DA0_CB_COLOR5_ATTRIB, 6, 2048},
	{61050, R_028DA4_CB_COLOR5_DCC_CONTROL, 9, 2054},
	{61072, R_028DA8_CB_COLOR5_CMASK},
	{61088, R_028DAC_CB_COLOR5_CMASK_SLICE, 1, 2063},
	{61110, R_028DB0_CB_COLOR5_FMASK},
	{61126, R_028DB4_CB_COLOR5_FMASK_SLICE, 1, 2064},
	{61148, R_028DB8_CB_COLOR5_CLEAR_WORD0},
	{61170, R_028DBC_CB_COLOR5_CLEAR_WORD1},
	{61192, R_028DC0_CB_COLOR5_DCC_BASE},
	{61211, R_028DC8_CB_COLOR6_BASE},
	{61226, R_028DCC_CB_COLOR6_PITCH, 2, 2025},
	{61242, R_028DD0_CB_COLOR6_SLICE, 1, 2027},
	{61258, R_028DD4_CB_COLOR6_VIEW, 2, 2028},
	{61273, R_028DD8_CB_COLOR6_INFO, 18, 2030},
	{61288, R_028DDC_CB_COLOR6_ATTRIB, 6, 2048},
	{61305, R_028DE0_CB_COLOR6_DCC_CONTROL, 9, 2054},
	{61327, R_028DE4_CB_COLOR6_CMASK},
	{61343, R_028DE8_CB_COLOR6_CMASK_SLICE, 1, 2063},
	{61365, R_028DEC_CB_COLOR6_FMASK},
	{61381, R_028DF0_CB_COLOR6_FMASK_SLICE, 1, 2064},
	{61403, R_028DF4_CB_COLOR6_CLEAR_WORD0},
	{61425, R_028DF8_CB_COLOR6_CLEAR_WORD1},
	{61447, R_028DFC_CB_COLOR6_DCC_BASE},
	{61466, R_028E04_CB_COLOR7_BASE},
	{61481, R_028E08_CB_COLOR7_PITCH, 2, 2025},
	{61497, R_028E0C_CB_COLOR7_SLICE, 1, 2027},
	{61513, R_028E10_CB_COLOR7_VIEW, 2, 2028},
	{61528, R_028E14_CB_COLOR7_INFO, 18, 2030},
	{61543, R_028E18_CB_COLOR7_ATTRIB, 6, 2048},
	{61560, R_028E1C_CB_COLOR7_DCC_CONTROL, 9, 2054},
	{61582, R_028E20_CB_COLOR7_CMASK},
	{61598, R_028E24_CB_COLOR7_CMASK_SLICE, 1, 2063},
	{61620, R_028E28_CB_COLOR7_FMASK},
	{61636, R_028E2C_CB_COLOR7_FMASK_SLICE, 1, 2064},
	{61658, R_028E30_CB_COLOR7_CLEAR_WORD0},
	{61680, R_028E34_CB_COLOR7_CLEAR_WORD1},
	{61702, R_028E38_CB_COLOR7_DCC_BASE},
};

static const char sid_strings[] =
	"NOP\0" /* 0 */
	"SET_BASE\0" /* 4 */
	"CLEAR_STATE\0" /* 13 */
	"INDEX_BUFFER_SIZE\0" /* 25, 38 */
	"DISPATCH_DIRECT\0" /* 43 */
	"DISPATCH_INDIRECT\0" /* 59 */
	"OCCLUSION_QUERY\0" /* 91, 77 */
	"SET_PREDICATION\0" /* 93 */
	"COND_EXEC\0" /* 109 */
	"PRED_EXEC\0" /* 119 */
	"DRAW_INDIRECT\0" /* 129 */
	"DRAW_INDEX_INDIRECT\0" /* 143 */
	"INDEX_BASE\0" /* 163 */
	"DRAW_INDEX_2\0" /* 174 */
	"CONTEXT_CONTROL\0" /* 187, 195 */
	"INDEX_TYPE\0" /* 209, 203 */
	"DRAW_INDIRECT_MULTI\0" /* 214 */
	"DRAW_INDEX_AUTO\0" /* 234 */
	"DRAW_INDEX_IMMD\0" /* 250 */
	"NUM_INSTANCES\0" /* 266 */
	"DRAW_INDEX_MULTI_AUTO\0" /* 280 */
	"INDIRECT_BUFFER_SI\0" /* 302 */
	"INDIRECT_BUFFER_CONST\0" /* 321 */
	"STRMOUT_BUFFER_UPDATE\0" /* 343 */
	"DRAW_INDEX_OFFSET_2\0" /* 365 */
	"WRITE_DATA\0" /* 385, 391 */
	"DRAW_INDEX_INDIRECT_MULTI\0" /* 396 */
	"MEM_SEMAPHORE\0" /* 422 */
	"MPEG_INDEX\0" /* 436, 445 */
	"WAIT_REG_MEM\0" /* 447 */
	"MEM_WRITE\0" /* 460 */
	"INDIRECT_BUFFER_CIK\0" /* 470 */
	"COPY_DATA\0" /* 490 */
	"PFP_SYNC_ME\0" /* 500, 509 */
	"SURFACE_SYNC\0" /* 512 */
	"ME_INITIALIZE\0" /* 525 */
	"COND_WRITE\0" /* 539 */
	"EVENT_WRITE\0" /* 550 */
	"EVENT_WRITE_EOP\0" /* 562 */
	"EVENT_WRITE_EOS\0" /* 578 */
	"ONE_REG_WRITE\0" /* 594 */
	"ACQUIRE_MEM\0" /* 608 */
	"SET_CONFIG_REG\0" /* 620 */
	"SET_CONTEXT_REG\0" /* 635 */
	"SET_SH_REG\0" /* 651 */
	"SET_SH_REG_OFFSET\0" /* 673, 662 */
	"SET_UCONFIG_REG\0" /* 680 */
	"LOAD_CONST_RAM\0" /* 696 */
	"WRITE_CONST_RAM\0" /* 711 */
	"DUMP_CONST_RAM\0" /* 727 */
	"INCREMENT_CE_COUNTER\0" /* 742 */
	"INCREMENT_DE_COUNTER\0" /* 763 */
	"WAIT_ON_CE_COUNTER\0" /* 784 */
	"IT_OPCODE_C\0" /* 803 */
	"CP_DMA\0" /* 815 */
	"DMA_DATA\0" /* 822 */
	"COUNT_INDIRECT_ENABLE\0" /* 846, 831 */
	"DRAW_INDEX_ENABLE\0" /* 853 */
	"PFP\0" /* 871 */
	"CE\0" /* 875 */
	"DE\0" /* 878 */
	"ENGINE_SEL\0" /* 881 */
	"WR_CONFIRM\0" /* 892 */
	"WR_ONE_ADDR\0" /* 910, 903 */
	"MEM_MAPPED_REGISTER\0" /* 915, 926 */
	"MEMORY_SYNC\0" /* 935 */
	"TC_L2\0" /* 947 */
	"GDS\0" /* 953 */
	"RESERVED\0" /* 957 */
	"MEM_ASYNC\0" /* 966 */
	"DST_SEL\0" /* 976 */
	"IB_SIZE\0" /* 984 */
	"CHAIN\0" /* 992 */
	"VALID\0" /* 998 */
	"SRC_ADDR_LO\0" /* 1004 */
	"CP_SYNC\0" /* 1016 */
	"SRC_ADDR\0" /* 1024 */
	"SRC_ADDR_TC_L2\0" /* 1033 */
	"SRC_SEL\0" /* 1048 */
	"ENGINE\0" /* 1056 */
	"DST_ADDR\0" /* 1063 */
	"DST_ADDR_TC_L2\0" /* 1072 */
	"DSL_SEL\0" /* 1087 */
	"SRC_ADDR_HI\0" /* 1095 */
	"DST_ADDR_LO\0" /* 1107 */
	"DST_ADDR_HI\0" /* 1119 */
	"BYTE_COUNT\0" /* 1131 */
	"DISABLE_WR_CONFIRM\0" /* 1142 */
	"NONE\0" /* 1161 */
	"8_IN_16\0" /* 1166 */
	"8_IN_32\0" /* 1174 */
	"8_IN_64\0" /* 1182 */
	"SRC_SWAP\0" /* 1190 */
	"DST_SWAP\0" /* 1199 */
	"MEMORY\0" /* 1208 */
	"SAS\0" /* 1215 */
	"DAS\0" /* 1219 */
	"INCREMENT\0" /* 1223 */
	"NO_INCREMENT\0" /* 1233 */
	"SAIC\0" /* 1246 */
	"DAIC\0" /* 1251 */
	"RAW_WAIT\0" /* 1256 */
	"SDMA_RQ_PENDING\0" /* 1265 */
	"TST_RQ_PENDING\0" /* 1281 */
	"SDMA1_RQ_PENDING\0" /* 1296 */
	"VCE0_RQ_PENDING\0" /* 1313 */
	"VP8_BUSY\0" /* 1329 */
	"SDMA_BUSY\0" /* 1338, 1339 */
	"SDMA1_BUSY\0" /* 1348 */
	"VCE0_BUSY\0" /* 1359 */
	"XDMA_BUSY\0" /* 1369 */
	"CHUB_BUSY\0" /* 1379 */
	"SDMA2_BUSY\0" /* 1389 */
	"SDMA3_BUSY\0" /* 1400 */
	"SAMSCP_BUSY\0" /* 1411, 1415 */
	"ISP_BUSY\0" /* 1423 */
	"VCE1_BUSY\0" /* 1432 */
	"ODE_BUSY\0" /* 1442 */
	"SDMA2_RQ_PENDING\0" /* 1451 */
	"SDMA3_RQ_PENDING\0" /* 1468 */
	"SAMSCP_RQ_PENDING\0" /* 1485 */
	"ISP_RQ_PENDING\0" /* 1503 */
	"VCE1_RQ_PENDING\0" /* 1518 */
	"UVD_RQ_PENDING\0" /* 1534 */
	"SAMMSP_RQ_PENDING\0" /* 1549 */
	"ACP_RQ_PENDING\0" /* 1567 */
	"SMU_RQ_PENDING\0" /* 1582 */
	"GRBM_RQ_PENDING\0" /* 1597 */
	"HI_RQ_PENDING\0" /* 1613 */
	"VMC_BUSY\0" /* 1627 */
	"MCB_BUSY\0" /* 1636, 1637 */
	"MCB_NON_DISPLAY_BUSY\0" /* 1645 */
	"MCC_BUSY\0" /* 1666 */
	"MCD_BUSY\0" /* 1675 */
	"VMC1_BUSY\0" /* 1684 */
	"SEM_BUSY\0" /* 1694 */
	"ACP_BUSY\0" /* 1703 */
	"IH_BUSY\0" /* 1712 */
	"UVD_BUSY\0" /* 1720 */
	"SAMMSP_BUSY\0" /* 1729 */
	"GCATCL2_BUSY\0" /* 1741 */
	"OSATCL2_BUSY\0" /* 1754 */
	"BIF_BUSY\0" /* 1767 */
	"MCC0_BUSY\0" /* 1776 */
	"MCC1_BUSY\0" /* 1786 */
	"MCC2_BUSY\0" /* 1796 */
	"MCC3_BUSY\0" /* 1806 */
	"MCC4_BUSY\0" /* 1816 */
	"MCC5_BUSY\0" /* 1826 */
	"MCC6_BUSY\0" /* 1836 */
	"MCC7_BUSY\0" /* 1846 */
	"MCD0_BUSY\0" /* 1856 */
	"MCD1_BUSY\0" /* 1866 */
	"MCD2_BUSY\0" /* 1876 */
	"MCD3_BUSY\0" /* 1886 */
	"MCD4_BUSY\0" /* 1896 */
	"MCD5_BUSY\0" /* 1906 */
	"MCD6_BUSY\0" /* 1916 */
	"MCD7_BUSY\0" /* 1926 */
	"IDLE\0" /* 1936 */
	"REG_IDLE\0" /* 1941 */
	"RB_EMPTY\0" /* 1950 */
	"RB_FULL\0" /* 1959 */
	"RB_CMD_IDLE\0" /* 1967 */
	"RB_CMD_FULL\0" /* 1979 */
	"IB_CMD_IDLE\0" /* 1991 */
	"IB_CMD_FULL\0" /* 2003 */
	"BLOCK_IDLE\0" /* 2015 */
	"INSIDE_IB\0" /* 2026 */
	"EX_IDLE\0" /* 2036 */
	"EX_IDLE_POLL_TIMER_EXPIRE\0" /* 2044 */
	"PACKET_READY\0" /* 2070 */
	"MC_WR_IDLE\0" /* 2083 */
	"SRBM_IDLE\0" /* 2094 */
	"CONTEXT_EMPTY\0" /* 2104 */
	"DELTA_RPTR_FULL\0" /* 2118 */
	"RB_MC_RREQ_IDLE\0" /* 2134 */
	"IB_MC_RREQ_IDLE\0" /* 2150 */
	"MC_RD_IDLE\0" /* 2166 */
	"DELTA_RPTR_EMPTY\0" /* 2177 */
	"MC_RD_RET_STALL\0" /* 2194 */
	"MC_RD_NO_POLL_IDLE\0" /* 2210 */
	"PREV_CMD_IDLE\0" /* 2229 */
	"SEM_IDLE\0" /* 2243 */
	"SEM_REQ_STALL\0" /* 2252 */
	"SEM_RESP_STATE\0" /* 2266 */
	"INT_IDLE\0" /* 2281 */
	"INT_REQ_STALL\0" /* 2290 */
	"ME0PIPE1_CMDFIFO_AVAIL\0" /* 2304 */
	"ME0PIPE1_CF_RQ_PENDING\0" /* 2327 */
	"ME0PIPE1_PF_RQ_PENDING\0" /* 2350 */
	"ME1PIPE0_RQ_PENDING\0" /* 2373 */
	"ME1PIPE1_RQ_PENDING\0" /* 2393 */
	"ME1PIPE2_RQ_PENDING\0" /* 2413 */
	"ME1PIPE3_RQ_PENDING\0" /* 2433 */
	"ME2PIPE0_RQ_PENDING\0" /* 2453 */
	"ME2PIPE1_RQ_PENDING\0" /* 2473 */
	"ME2PIPE2_RQ_PENDING\0" /* 2493 */
	"ME2PIPE3_RQ_PENDING\0" /* 2513 */
	"RLC_RQ_PENDING\0" /* 2533 */
	"RLC_BUSY\0" /* 2548 */
	"TC_BUSY\0" /* 2557 */
	"TCC_CC_RESIDENT\0" /* 2565 */
	"CPF_BUSY\0" /* 2581 */
	"CPC_BUSY\0" /* 2590 */
	"CPG_BUSY\0" /* 2599 */
	"ME0PIPE0_CMDFIFO_AVAIL\0" /* 2608 */
	"SRBM_RQ_PENDING\0" /* 2631 */
	"ME0PIPE0_CF_RQ_PENDING\0" /* 2647 */
	"ME0PIPE0_PF_RQ_PENDING\0" /* 2670 */
	"GDS_DMA_RQ_PENDING\0" /* 2693 */
	"DB_CLEAN\0" /* 2712 */
	"CB_CLEAN\0" /* 2721 */
	"TA_BUSY\0" /* 2730 */
	"GDS_BUSY\0" /* 2738 */
	"WD_BUSY_NO_DMA\0" /* 2747 */
	"VGT_BUSY\0" /* 2762 */
	"IA_BUSY_NO_DMA\0" /* 2771 */
	"IA_BUSY\0" /* 2786 */
	"SX_BUSY\0" /* 2794 */
	"WD_BUSY\0" /* 2802 */
	"SPI_BUSY\0" /* 2810 */
	"BCI_BUSY\0" /* 2819 */
	"SC_BUSY\0" /* 2828 */
	"PA_BUSY\0" /* 2836 */
	"DB_BUSY\0" /* 2844 */
	"CP_COHERENCY_BUSY\0" /* 2852 */
	"GUI_ACTIVE\0" /* 2870 */
	"OFFSET_UPDATE_DONE\0" /* 2881, 2895 */
	"DEST_BASE_0_ENA\0" /* 2900 */
	"DEST_BASE_1_ENA\0" /* 2916 */
	"CB0_DEST_BASE_ENA\0" /* 2932 */
	"CB1_DEST_BASE_ENA\0" /* 2950 */
	"CB2_DEST_BASE_ENA\0" /* 2968 */
	"CB3_DEST_BASE_ENA\0" /* 2986 */
	"CB4_DEST_BASE_ENA\0" /* 3004 */
	"CB5_DEST_BASE_ENA\0" /* 3022 */
	"CB6_DEST_BASE_ENA\0" /* 3040 */
	"CB7_DEST_BASE_ENA\0" /* 3058 */
	"DB_DEST_BASE_ENA\0" /* 3076 */
	"DEST_BASE_2_ENA\0" /* 3093 */
	"DEST_BASE_3_ENA\0" /* 3109 */
	"TCL1_ACTION_ENA\0" /* 3125 */
	"TC_ACTION_ENA\0" /* 3141 */
	"CB_ACTION_ENA\0" /* 3155 */
	"DB_ACTION_ENA\0" /* 3169 */
	"SH_KCACHE_ACTION_ENA\0" /* 3183 */
	"SH_ICACHE_ACTION_ENA\0" /* 3204 */
	"COHER_BASE_HI_256B\0" /* 3225 */
	"START_DELAY_COUNT\0" /* 3244 */
	"TC_SD_ACTION_ENA\0" /* 3262 */
	"TC_NC_ACTION_ENA\0" /* 3279 */
	"TCL1_VOL_ACTION_ENA\0" /* 3296 */
	"TC_VOL_ACTION_ENA\0" /* 3316 */
	"TC_WB_ACTION_ENA\0" /* 3334 */
	"SH_KCACHE_VOL_ACTION_ENA\0" /* 3351 */
	"SH_KCACHE_WB_ACTION_ENA\0" /* 3376 */
	"SH_SD_ACTION_ENA\0" /* 3400 */
	"MATCHING_GFX_CNTX\0" /* 3417 */
	"MEID\0" /* 3435 */
	"PHASE1_STATUS\0" /* 3440, 3447 */
	"MEC1_BUSY\0" /* 3454 */
	"MEC2_BUSY\0" /* 3464 */
	"DC0_BUSY\0" /* 3474 */
	"DC1_BUSY\0" /* 3483 */
	"RCIU1_BUSY\0" /* 3492 */
	"RCIU2_BUSY\0" /* 3503 */
	"ROQ1_BUSY\0" /* 3514 */
	"ROQ2_BUSY\0" /* 3524 */
	"TCIU_BUSY\0" /* 3534 */
	"SCRATCH_RAM_BUSY\0" /* 3544 */
	"QU_BUSY\0" /* 3561 */
	"ATCL2IU_BUSY\0" /* 3569 */
	"CPG_CPC_BUSY\0" /* 3582 */
	"CPF_CPC_BUSY\0" /* 3595 */
	"MEC1_LOAD_BUSY\0" /* 3608 */
	"MEC1_SEMAPOHRE_BUSY\0" /* 3623 */
	"MEC1_MUTEX_BUSY\0" /* 3643 */
	"MEC1_MESSAGE_BUSY\0" /* 3659 */
	"MEC1_EOP_QUEUE_BUSY\0" /* 3677 */
	"MEC1_IQ_QUEUE_BUSY\0" /* 3697 */
	"MEC1_IB_QUEUE_BUSY\0" /* 3716 */
	"MEC1_TC_BUSY\0" /* 3735 */
	"MEC1_DMA_BUSY\0" /* 3748 */
	"MEC1_PARTIAL_FLUSH_BUSY\0" /* 3762 */
	"MEC1_PIPE0_BUSY\0" /* 3786 */
	"MEC1_PIPE1_BUSY\0" /* 3802 */
	"MEC1_PIPE2_BUSY\0" /* 3818 */
	"MEC1_PIPE3_BUSY\0" /* 3834 */
	"MEC2_LOAD_BUSY\0" /* 3850 */
	"MEC2_SEMAPOHRE_BUSY\0" /* 3865 */
	"MEC2_MUTEX_BUSY\0" /* 3885 */
	"MEC2_MESSAGE_BUSY\0" /* 3901 */
	"MEC2_EOP_QUEUE_BUSY\0" /* 3919 */
	"MEC2_IQ_QUEUE_BUSY\0" /* 3939 */
	"MEC2_IB_QUEUE_BUSY\0" /* 3958 */
	"MEC2_TC_BUSY\0" /* 3977 */
	"MEC2_DMA_BUSY\0" /* 3990 */
	"MEC2_PARTIAL_FLUSH_BUSY\0" /* 4004 */
	"MEC2_PIPE0_BUSY\0" /* 4028 */
	"MEC2_PIPE1_BUSY\0" /* 4044 */
	"MEC2_PIPE2_BUSY\0" /* 4060 */
	"MEC2_PIPE3_BUSY\0" /* 4076 */
	"RCIU_TX_FREE_STALL\0" /* 4092 */
	"RCIU_PRIV_VIOLATION\0" /* 4111 */
	"TCIU_TX_FREE_STALL\0" /* 4131 */
	"MEC1_DECODING_PACKET\0" /* 4150 */
	"MEC1_WAIT_ON_RCIU\0" /* 4171 */
	"MEC1_WAIT_ON_RCIU_READ\0" /* 4189 */
	"MEC1_WAIT_ON_ROQ_DATA\0" /* 4212 */
	"MEC2_DECODING_PACKET\0" /* 4234 */
	"MEC2_WAIT_ON_RCIU\0" /* 4255 */
	"MEC2_WAIT_ON_RCIU_READ\0" /* 4273 */
	"MEC2_WAIT_ON_ROQ_DATA\0" /* 4296 */
	"ATCL2IU_WAITING_ON_FREE\0" /* 4318 */
	"ATCL2IU_WAITING_ON_TAGS\0" /* 4342 */
	"ATCL1_WAITING_ON_TRANS\0" /* 4366 */
	"POST_WPTR_GFX_BUSY\0" /* 4389 */
	"CSF_BUSY\0" /* 4408 */
	"ROQ_ALIGN_BUSY\0" /* 4417 */
	"ROQ_RING_BUSY\0" /* 4432 */
	"ROQ_INDIRECT1_BUSY\0" /* 4446 */
	"ROQ_INDIRECT2_BUSY\0" /* 4465 */
	"ROQ_STATE_BUSY\0" /* 4484 */
	"ROQ_CE_RING_BUSY\0" /* 4499 */
	"ROQ_CE_INDIRECT1_BUSY\0" /* 4516 */
	"ROQ_CE_INDIRECT2_BUSY\0" /* 4538 */
	"SEMAPHORE_BUSY\0" /* 4560 */
	"INTERRUPT_BUSY\0" /* 4575 */
	"HQD_BUSY\0" /* 4590 */
	"PRT_BUSY\0" /* 4599 */
	"CPF_GFX_BUSY\0" /* 4608 */
	"CPF_CMP_BUSY\0" /* 4621 */
	"GRBM_CPF_STAT_BUSY\0" /* 4634 */
	"CPC_CPF_BUSY\0" /* 4653 */
	"REG_BUS_FIFO_BUSY\0" /* 4666 */
	"CSF_RING_BUSY\0" /* 4684 */
	"CSF_INDIRECT1_BUSY\0" /* 4698 */
	"CSF_INDIRECT2_BUSY\0" /* 4717 */
	"CSF_STATE_BUSY\0" /* 4736 */
	"CSF_CE_INDR1_BUSY\0" /* 4751 */
	"CSF_CE_INDR2_BUSY\0" /* 4769 */
	"CSF_ARBITER_BUSY\0" /* 4787 */
	"CSF_INPUT_BUSY\0" /* 4804 */
	"OUTSTANDING_READ_TAGS\0" /* 4819 */
	"HPD_PROCESSING_EOP_BUSY\0" /* 4841 */
	"HQD_DISPATCH_BUSY\0" /* 4865 */
	"HQD_IQ_TIMER_BUSY\0" /* 4883 */
	"HQD_DMA_OFFLOAD_BUSY\0" /* 4901 */
	"HQD_WAIT_SEMAPHORE_BUSY\0" /* 4922 */
	"HQD_SIGNAL_SEMAPHORE_BUSY\0" /* 4946 */
	"HQD_MESSAGE_BUSY\0" /* 4972 */
	"HQD_PQ_FETCHER_BUSY\0" /* 4989 */
	"HQD_IB_FETCHER_BUSY\0" /* 5009 */
	"HQD_IQ_FETCHER_BUSY\0" /* 5029 */
	"HQD_EOP_FETCHER_BUSY\0" /* 5049 */
	"HQD_CONSUMED_RPTR_BUSY\0" /* 5070 */
	"HQD_FETCHER_ARB_BUSY\0" /* 5093 */
	"HQD_ROQ_ALIGN_BUSY\0" /* 5114 */
	"HQD_ROQ_EOP_BUSY\0" /* 5133 */
	"HQD_ROQ_IQ_BUSY\0" /* 5150 */
	"HQD_ROQ_PQ_BUSY\0" /* 5166 */
	"HQD_ROQ_IB_BUSY\0" /* 5182 */
	"HQD_WPTR_POLL_BUSY\0" /* 5198 */
	"HQD_PQ_BUSY\0" /* 5217 */
	"HQD_IB_BUSY\0" /* 5229 */
	"RING_FETCHING_DATA\0" /* 5241 */
	"INDR1_FETCHING_DATA\0" /* 5260 */
	"INDR2_FETCHING_DATA\0" /* 5280 */
	"STATE_FETCHING_DATA\0" /* 5300 */
	"TCIU_WAITING_ON_FREE\0" /* 5320 */
	"TCIU_WAITING_ON_TAGS\0" /* 5341 */
	"COHER_SIZE_HI_256B\0" /* 5362 */
	"PRIM_COUNT\0" /* 5381 */
	"VS_NO_EXTRA_BUFFER\0" /* 5392 */
	"STREAMOUT_FULL_FLUSH\0" /* 5411 */
	"ES_LIMIT\0" /* 5432, 5435 */
	"VERT_REUSE\0" /* 5441 */
	"DI_PT_NONE\0" /* 5452 */
	"DI_PT_POINTLIST\0" /* 5463 */
	"DI_PT_LINELIST\0" /* 5479 */
	"DI_PT_LINESTRIP\0" /* 5494 */
	"DI_PT_TRILIST\0" /* 5510 */
	"DI_PT_TRIFAN\0" /* 5524 */
	"DI_PT_TRISTRIP\0" /* 5537 */
	"DI_PT_UNUSED_0\0" /* 5552 */
	"DI_PT_UNUSED_1\0" /* 5567 */
	"DI_PT_PATCH\0" /* 5582 */
	"DI_PT_LINELIST_ADJ\0" /* 5594 */
	"DI_PT_LINESTRIP_ADJ\0" /* 5613 */
	"DI_PT_TRILIST_ADJ\0" /* 5633 */
	"DI_PT_TRISTRIP_ADJ\0" /* 5651 */
	"DI_PT_UNUSED_3\0" /* 5670 */
	"DI_PT_UNUSED_4\0" /* 5685 */
	"DI_PT_TRI_WITH_WFLAGS\0" /* 5700 */
	"DI_PT_RECTLIST\0" /* 5722 */
	"DI_PT_LINELOOP\0" /* 5737 */
	"DI_PT_QUADLIST\0" /* 5752 */
	"DI_PT_QUADSTRIP\0" /* 5767 */
	"DI_PT_POLYGON\0" /* 5783 */
	"DI_PT_2D_COPY_RECT_LIST_V0\0" /* 5797 */
	"DI_PT_2D_COPY_RECT_LIST_V1\0" /* 5824 */
	"DI_PT_2D_COPY_RECT_LIST_V2\0" /* 5851 */
	"DI_PT_2D_COPY_RECT_LIST_V3\0" /* 5878 */
	"DI_PT_2D_FILL_RECT_LIST\0" /* 5905 */
	"DI_PT_2D_LINE_STRIP\0" /* 5929 */
	"DI_PT_2D_TRI_STRIP\0" /* 5949 */
	"PRIM_TYPE\0" /* 5968 */
	"DI_INDEX_SIZE_16_BIT\0" /* 5978 */
	"DI_INDEX_SIZE_32_BIT\0" /* 5999 */
	"OFFCHIP_BUFFERING\0" /* 6020 */
	"CLIP_VTX_REORDER_ENA\0" /* 6038 */
	"NUM_CLIP_SEQ\0" /* 6059 */
	"CLIPPED_PRIM_SEQ_STALL\0" /* 6072 */
	"VE_NAN_PROC_DISABLE\0" /* 6095 */
	"LINE_STIPPLE_VALUE\0" /* 6115 */
	"CURRENT_PTR\0" /* 6134 */
	"CURRENT_COUNT\0" /* 6146 */
	"CE_TO_CSF_NOT_RDY_TO_RCV\0" /* 6160 */
	"CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV\0" /* 6185 */
	"CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER\0" /* 6223 */
	"CE_TO_RAM_INIT_NOT_RDY\0" /* 6264 */
	"CE_TO_RAM_DUMP_NOT_RDY\0" /* 6287 */
	"CE_TO_RAM_WRITE_NOT_RDY\0" /* 6310 */
	"CE_TO_INC_FIFO_NOT_RDY_TO_RCV\0" /* 6334 */
	"CE_TO_WR_FIFO_NOT_RDY_TO_RCV\0" /* 6364 */
	"CE_WAITING_ON_BUFFER_DATA\0" /* 6393 */
	"CE_WAITING_ON_CE_BUFFER_FLAG\0" /* 6419 */
	"CE_WAITING_ON_DE_COUNTER\0" /* 6448 */
	"CE_WAITING_ON_DE_COUNTER_UNDERFLOW\0" /* 6473 */
	"CE_STALLED_ON_TC_WR_CONFIRM\0" /* 6508 */
	"CE_STALLED_ON_ATOMIC_RTN_DATA\0" /* 6536 */
	"RBIU_TO_DMA_NOT_RDY_TO_RCV\0" /* 6566 */
	"RBIU_TO_SEM_NOT_RDY_TO_RCV\0" /* 6593 */
	"RBIU_TO_MEMWR_NOT_RDY_TO_RCV\0" /* 6620 */
	"ME_HAS_ACTIVE_CE_BUFFER_FLAG\0" /* 6649 */
	"ME_HAS_ACTIVE_DE_BUFFER_FLAG\0" /* 6678 */
	"ME_STALLED_ON_TC_WR_CONFIRM\0" /* 6707 */
	"ME_STALLED_ON_ATOMIC_RTN_DATA\0" /* 6735 */
	"ME_WAITING_ON_TC_READ_DATA\0" /* 6765 */
	"ME_WAITING_ON_REG_READ_DATA\0" /* 6792 */
	"RCIU_WAITING_ON_GDS_FREE\0" /* 6820 */
	"RCIU_WAITING_ON_GRBM_FREE\0" /* 6845 */
	"RCIU_WAITING_ON_VGT_FREE\0" /* 6871 */
	"RCIU_STALLED_ON_ME_READ\0" /* 6896 */
	"RCIU_STALLED_ON_DMA_READ\0" /* 6920 */
	"RCIU_STALLED_ON_APPEND_READ\0" /* 6945 */
	"RCIU_HALTED_BY_REG_VIOLATION\0" /* 6973 */
	"PFP_TO_CSF_NOT_RDY_TO_RCV\0" /* 7002 */
	"PFP_TO_MEQ_NOT_RDY_TO_RCV\0" /* 7028 */
	"PFP_TO_RCIU_NOT_RDY_TO_RCV\0" /* 7054 */
	"PFP_TO_VGT_WRITES_PENDING\0" /* 7081 */
	"PFP_RCIU_READ_PENDING\0" /* 7107 */
	"PFP_WAITING_ON_BUFFER_DATA\0" /* 7129 */
	"ME_WAIT_ON_CE_COUNTER\0" /* 7156 */
	"ME_WAIT_ON_AVAIL_BUFFER\0" /* 7178 */
	"GFX_CNTX_NOT_AVAIL_TO_ME\0" /* 7202 */
	"ME_RCIU_NOT_RDY_TO_RCV\0" /* 7227 */
	"ME_TO_CONST_NOT_RDY_TO_RCV\0" /* 7250 */
	"ME_WAITING_DATA_FROM_PFP\0" /* 7277 */
	"ME_WAITING_ON_PARTIAL_FLUSH\0" /* 7302 */
	"MEQ_TO_ME_NOT_RDY_TO_RCV\0" /* 7330 */
	"STQ_TO_ME_NOT_RDY_TO_RCV\0" /* 7355 */
	"ME_WAITING_DATA_FROM_STQ\0" /* 7380 */
	"PFP_STALLED_ON_TC_WR_CONFIRM\0" /* 7405 */
	"PFP_STALLED_ON_ATOMIC_RTN_DATA\0" /* 7434 */
	"EOPD_FIFO_NEEDS_SC_EOP_DONE\0" /* 7465 */
	"EOPD_FIFO_NEEDS_WR_CONFIRM\0" /* 7493 */
	"STRMO_WR_OF_PRIM_DATA_PENDING\0" /* 7520 */
	"PIPE_STATS_WR_DATA_PENDING\0" /* 7550 */
	"APPEND_RDY_WAIT_ON_CS_DONE\0" /* 7577, 7596 */
	"APPEND_RDY_WAIT_ON_PS_DONE\0" /* 7604, 7623 */
	"APPEND_WAIT_ON_WR_CONFIRM\0" /* 7631 */
	"APPEND_ACTIVE_PARTITION\0" /* 7657 */
	"APPEND_WAITING_TO_SEND_MEMWRITE\0" /* 7681 */
	"SURF_SYNC_NEEDS_IDLE_CNTXS\0" /* 7713 */
	"SURF_SYNC_NEEDS_ALL_CLEAN\0" /* 7740 */
	"DC_BUSY\0" /* 7766 */
	"PFP_BUSY\0" /* 7774 */
	"MEQ_BUSY\0" /* 7783 */
	"ME_BUSY\0" /* 7792 */
	"QUERY_BUSY\0" /* 7800 */
	"SURFACE_SYNC_BUSY\0" /* 7811 */
	"RCIU_BUSY\0" /* 7829 */
	"CPC_CPG_BUSY\0" /* 7839 */
	"CE_BUSY\0" /* 7852 */
	"INSTANCE_INDEX\0" /* 7860 */
	"SH_INDEX\0" /* 7875 */
	"SE_INDEX\0" /* 7884 */
	"SH_BROADCAST_WRITES\0" /* 7893 */
	"INSTANCE_BROADCAST_WRITES\0" /* 7913 */
	"SE_BROADCAST_WRITES\0" /* 7939 */
	"X_8K_DWORDS\0" /* 7959 */
	"X_4K_DWORDS\0" /* 7971 */
	"X_2K_DWORDS\0" /* 7983 */
	"X_1K_DWORDS\0" /* 7995 */
	"OFFCHIP_GRANULARITY\0" /* 8007 */
	"ENABLE_PA_SC_OUT_OF_ORDER\0" /* 8027 */
	"DISABLE_SC_DB_TILE_FIX\0" /* 8053 */
	"DISABLE_AA_MASK_FULL_FIX\0" /* 8076 */
	"ENABLE_1XMSAA_SAMPLE_LOCATIONS\0" /* 8101 */
	"ENABLE_1XMSAA_SAMPLE_LOC_CENTROID\0" /* 8132 */
	"DISABLE_SCISSOR_FIX\0" /* 8166 */
	"DISABLE_PW_BUBBLE_COLLAPSE\0" /* 8186 */
	"SEND_UNLIT_STILES_TO_PACKER\0" /* 8213 */
	"DISABLE_DUALGRAD_PERF_OPTIMIZATION\0" /* 8241 */
	"INST_INVALIDATE\0" /* 8276 */
	"DATA_INVALIDATE\0" /* 8292 */
	"INVALIDATE_VOLATILE\0" /* 8308 */
	"RET\0" /* 8328 */
	"RUI\0" /* 8332 */
	"RNG\0" /* 8336 */
	"EN\0" /* 8340 */
	"SQ_EXP_MRT\0" /* 8343 */
	"SQ_EXP_MRTZ\0" /* 8354 */
	"SQ_EXP_NULL\0" /* 8366 */
	"SQ_EXP_POS\0" /* 8378 */
	"SQ_EXP_PARAM\0" /* 8389 */
	"TGT\0" /* 8402 */
	"COMPR\0" /* 8406 */
	"VM\0" /* 8412 */
	"SQ_ENC_EXP_FIELD\0" /* 8415 */
	"ENCODING\0" /* 8432 */
	"ADDRESS\0" /* 8441 */
	"COUNT_HI\0" /* 8449 */
	"BASE_ADDRESS_HI\0" /* 8458, 8463 */
	"STRIDE\0" /* 8474 */
	"CACHE_SWIZZLE\0" /* 8481 */
	"SWIZZLE_ENABLE\0" /* 8495 */
	"SQ_SEL_0\0" /* 8510 */
	"SQ_SEL_1\0" /* 8519 */
	"SQ_SEL_RESERVED_0\0" /* 8528, 8535 */
	"SQ_SEL_RESERVED_1\0" /* 8553, 8546 */
	"SQ_SEL_X\0" /* 8564 */
	"SQ_SEL_Y\0" /* 8573 */
	"SQ_SEL_Z\0" /* 8582 */
	"SQ_SEL_W\0" /* 8591 */
	"DST_SEL_X\0" /* 8600 */
	"DST_SEL_Y\0" /* 8610 */
	"DST_SEL_Z\0" /* 8620 */
	"DST_SEL_W\0" /* 8630 */
	"BUF_NUM_FORMAT_UNORM\0" /* 8640 */
	"BUF_NUM_FORMAT_SNORM\0" /* 8661 */
	"BUF_NUM_FORMAT_USCALED\0" /* 8682 */
	"BUF_NUM_FORMAT_SSCALED\0" /* 8705 */
	"BUF_NUM_FORMAT_UINT\0" /* 8728 */
	"BUF_NUM_FORMAT_SINT\0" /* 8748 */
	"BUF_NUM_FORMAT_SNORM_OGL\0" /* 8768 */
	"BUF_NUM_FORMAT_FLOAT\0" /* 8793 */
	"NUM_FORMAT\0" /* 8818, 8814 */
	"BUF_DATA_FORMAT_INVALID\0" /* 8825 */
	"BUF_DATA_FORMAT_8\0" /* 8849 */
	"BUF_DATA_FORMAT_16\0" /* 8867 */
	"BUF_DATA_FORMAT_8_8\0" /* 8886 */
	"BUF_DATA_FORMAT_32\0" /* 8906 */
	"BUF_DATA_FORMAT_16_16\0" /* 8925 */
	"BUF_DATA_FORMAT_10_11_11\0" /* 8947 */
	"BUF_DATA_FORMAT_11_11_10\0" /* 8972 */
	"BUF_DATA_FORMAT_10_10_10_2\0" /* 8997 */
	"BUF_DATA_FORMAT_2_10_10_10\0" /* 9024 */
	"BUF_DATA_FORMAT_8_8_8_8\0" /* 9051 */
	"BUF_DATA_FORMAT_32_32\0" /* 9075 */
	"BUF_DATA_FORMAT_16_16_16_16\0" /* 9097 */
	"BUF_DATA_FORMAT_32_32_32\0" /* 9125 */
	"BUF_DATA_FORMAT_32_32_32_32\0" /* 9150 */
	"BUF_DATA_FORMAT_RESERVED_15\0" /* 9178 */
	"DATA_FORMAT\0" /* 9206 */
	"ELEMENT_SIZE\0" /* 9218 */
	"INDEX_STRIDE\0" /* 9231 */
	"ADD_TID_ENABLE\0" /* 9244 */
	"ATC\0" /* 9259 */
	"HASH_ENABLE\0" /* 9263 */
	"HEAP\0" /* 9275 */
	"MTYPE\0" /* 9280 */
	"SQ_RSRC_BUF\0" /* 9286 */
	"SQ_RSRC_BUF_RSVD_1\0" /* 9298 */
	"SQ_RSRC_BUF_RSVD_2\0" /* 9317 */
	"SQ_RSRC_BUF_RSVD_3\0" /* 9336 */
	"MIN_LOD\0" /* 9355 */
	"IMG_DATA_FORMAT_INVALID\0" /* 9363 */
	"IMG_DATA_FORMAT_8\0" /* 9387 */
	"IMG_DATA_FORMAT_16\0" /* 9405 */
	"IMG_DATA_FORMAT_8_8\0" /* 9424 */
	"IMG_DATA_FORMAT_32\0" /* 9444 */
	"IMG_DATA_FORMAT_16_16\0" /* 9463 */
	"IMG_DATA_FORMAT_10_11_11\0" /* 9485 */
	"IMG_DATA_FORMAT_11_11_10\0" /* 9510 */
	"IMG_DATA_FORMAT_10_10_10_2\0" /* 9535 */
	"IMG_DATA_FORMAT_2_10_10_10\0" /* 9562 */
	"IMG_DATA_FORMAT_8_8_8_8\0" /* 9589 */
	"IMG_DATA_FORMAT_32_32\0" /* 9613 */
	"IMG_DATA_FORMAT_16_16_16_16\0" /* 9635 */
	"IMG_DATA_FORMAT_32_32_32\0" /* 9663 */
	"IMG_DATA_FORMAT_32_32_32_32\0" /* 9688 */
	"IMG_DATA_FORMAT_RESERVED_15\0" /* 9716 */
	"IMG_DATA_FORMAT_5_6_5\0" /* 9744 */
	"IMG_DATA_FORMAT_1_5_5_5\0" /* 9766 */
	"IMG_DATA_FORMAT_5_5_5_1\0" /* 9790 */
	"IMG_DATA_FORMAT_4_4_4_4\0" /* 9814 */
	"IMG_DATA_FORMAT_8_24\0" /* 9838 */
	"IMG_DATA_FORMAT_24_8\0" /* 9859 */
	"IMG_DATA_FORMAT_X24_8_32\0" /* 9880 */
	"IMG_DATA_FORMAT_8_AS_8_8_8_8\0" /* 9905 */
	"IMG_DATA_FORMAT_ETC2_RGB\0" /* 9934 */
	"IMG_DATA_FORMAT_ETC2_RGBA\0" /* 9959 */
	"IMG_DATA_FORMAT_ETC2_R\0" /* 9985 */
	"IMG_DATA_FORMAT_ETC2_RG\0" /* 10008 */
	"IMG_DATA_FORMAT_ETC2_RGBA1\0" /* 10032 */
	"IMG_DATA_FORMAT_RESERVED_29\0" /* 10059 */
	"IMG_DATA_FORMAT_RESERVED_30\0" /* 10087 */
	"IMG_DATA_FORMAT_RESERVED_31\0" /* 10115 */
	"IMG_DATA_FORMAT_GB_GR\0" /* 10143 */
	"IMG_DATA_FORMAT_BG_RG\0" /* 10165 */
	"IMG_DATA_FORMAT_5_9_9_9\0" /* 10187 */
	"IMG_DATA_FORMAT_BC1\0" /* 10211 */
	"IMG_DATA_FORMAT_BC2\0" /* 10231 */
	"IMG_DATA_FORMAT_BC3\0" /* 10251 */
	"IMG_DATA_FORMAT_BC4\0" /* 10271 */
	"IMG_DATA_FORMAT_BC5\0" /* 10291 */
	"IMG_DATA_FORMAT_BC6\0" /* 10311 */
	"IMG_DATA_FORMAT_BC7\0" /* 10331 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16\0" /* 10351 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32\0" /* 10385 */
	"IMG_DATA_FORMAT_FMASK8_S2_F1\0" /* 10419 */
	"IMG_DATA_FORMAT_FMASK8_S4_F1\0" /* 10448 */
	"IMG_DATA_FORMAT_FMASK8_S8_F1\0" /* 10477 */
	"IMG_DATA_FORMAT_FMASK8_S2_F2\0" /* 10506 */
	"IMG_DATA_FORMAT_FMASK8_S4_F2\0" /* 10535 */
	"IMG_DATA_FORMAT_FMASK8_S4_F4\0" /* 10564 */
	"IMG_DATA_FORMAT_FMASK16_S16_F1\0" /* 10593 */
	"IMG_DATA_FORMAT_FMASK16_S8_F2\0" /* 10624 */
	"IMG_DATA_FORMAT_FMASK32_S16_F2\0" /* 10654 */
	"IMG_DATA_FORMAT_FMASK32_S8_F4\0" /* 10685 */
	"IMG_DATA_FORMAT_FMASK32_S8_F8\0" /* 10715 */
	"IMG_DATA_FORMAT_FMASK64_S16_F4\0" /* 10745 */
	"IMG_DATA_FORMAT_FMASK64_S16_F8\0" /* 10776 */
	"IMG_DATA_FORMAT_4_4\0" /* 10807 */
	"IMG_DATA_FORMAT_6_5_5\0" /* 10827 */
	"IMG_DATA_FORMAT_1\0" /* 10849 */
	"IMG_DATA_FORMAT_1_REVERSED\0" /* 10867 */
	"IMG_DATA_FORMAT_32_AS_8\0" /* 10894 */
	"IMG_DATA_FORMAT_32_AS_8_8\0" /* 10918 */
	"IMG_DATA_FORMAT_32_AS_32_32_32_32\0" /* 10944 */
	"IMG_NUM_FORMAT_UNORM\0" /* 10978 */
	"IMG_NUM_FORMAT_SNORM\0" /* 10999 */
	"IMG_NUM_FORMAT_USCALED\0" /* 11020 */
	"IMG_NUM_FORMAT_SSCALED\0" /* 11043 */
	"IMG_NUM_FORMAT_UINT\0" /* 11066 */
	"IMG_NUM_FORMAT_SINT\0" /* 11086 */
	"IMG_NUM_FORMAT_SNORM_OGL\0" /* 11106 */
	"IMG_NUM_FORMAT_FLOAT\0" /* 11131 */
	"IMG_NUM_FORMAT_RESERVED_8\0" /* 11152 */
	"IMG_NUM_FORMAT_SRGB\0" /* 11178 */
	"IMG_NUM_FORMAT_UBNORM\0" /* 11198 */
	"IMG_NUM_FORMAT_UBNORM_OGL\0" /* 11220 */
	"IMG_NUM_FORMAT_UBINT\0" /* 11246 */
	"IMG_NUM_FORMAT_UBSCALED\0" /* 11267 */
	"IMG_NUM_FORMAT_RESERVED_14\0" /* 11291 */
	"IMG_NUM_FORMAT_RESERVED_15\0" /* 11318 */
	"WIDTH\0" /* 11345 */
	"HEIGHT\0" /* 11351 */
	"PERF_MOD\0" /* 11358 */
	"INTERLACED\0" /* 11367 */
	"BASE_LEVEL\0" /* 11378 */
	"LAST_LEVEL\0" /* 11389 */
	"TILING_INDEX\0" /* 11400 */
	"POW2_PAD\0" /* 11413 */
	"SQ_RSRC_IMG_RSVD_0\0" /* 11422 */
	"SQ_RSRC_IMG_RSVD_1\0" /* 11441 */
	"SQ_RSRC_IMG_RSVD_2\0" /* 11460 */
	"SQ_RSRC_IMG_RSVD_3\0" /* 11479 */
	"SQ_RSRC_IMG_RSVD_4\0" /* 11498 */
	"SQ_RSRC_IMG_RSVD_5\0" /* 11517 */
	"SQ_RSRC_IMG_RSVD_6\0" /* 11536 */
	"SQ_RSRC_IMG_RSVD_7\0" /* 11555 */
	"SQ_RSRC_IMG_1D\0" /* 11574 */
	"SQ_RSRC_IMG_2D\0" /* 11589 */
	"SQ_RSRC_IMG_3D\0" /* 11604 */
	"SQ_RSRC_IMG_CUBE\0" /* 11619 */
	"SQ_RSRC_IMG_1D_ARRAY\0" /* 11636 */
	"SQ_RSRC_IMG_2D_ARRAY\0" /* 11657 */
	"SQ_RSRC_IMG_2D_MSAA\0" /* 11678 */
	"SQ_RSRC_IMG_2D_MSAA_ARRAY\0" /* 11698 */
	"DEPTH\0" /* 11724 */
	"PITCH\0" /* 11730 */
	"BASE_ARRAY\0" /* 11736 */
	"LAST_ARRAY\0" /* 11747 */
	"MIN_LOD_WARN\0" /* 11758 */
	"COUNTER_BANK_ID\0" /* 11771 */
	"LOD_HDW_CNT_EN\0" /* 11787 */
	"COMPRESSION_EN\0" /* 11802 */
	"ALPHA_IS_ON_MSB\0" /* 11817 */
	"COLOR_TRANSFORM\0" /* 11833 */
	"LOST_ALPHA_BITS\0" /* 11849 */
	"LOST_COLOR_BITS\0" /* 11865 */
	"SQ_TEX_WRAP\0" /* 11881 */
	"SQ_TEX_MIRROR\0" /* 11893 */
	"SQ_TEX_CLAMP_LAST_TEXEL\0" /* 11907 */
	"SQ_TEX_MIRROR_ONCE_LAST_TEXEL\0" /* 11931 */
	"SQ_TEX_CLAMP_HALF_BORDER\0" /* 11961 */
	"SQ_TEX_MIRROR_ONCE_HALF_BORDER\0" /* 11986 */
	"SQ_TEX_CLAMP_BORDER\0" /* 12017 */
	"SQ_TEX_MIRROR_ONCE_BORDER\0" /* 12037 */
	"CLAMP_X\0" /* 12063 */
	"CLAMP_Y\0" /* 12071 */
	"CLAMP_Z\0" /* 12079 */
	"MAX_ANISO_RATIO\0" /* 12087 */
	"SQ_TEX_DEPTH_COMPARE_NEVER\0" /* 12103 */
	"SQ_TEX_DEPTH_COMPARE_LESS\0" /* 12130 */
	"SQ_TEX_DEPTH_COMPARE_EQUAL\0" /* 12156 */
	"SQ_TEX_DEPTH_COMPARE_LESSEQUAL\0" /* 12183 */
	"SQ_TEX_DEPTH_COMPARE_GREATER\0" /* 12214 */
	"SQ_TEX_DEPTH_COMPARE_NOTEQUAL\0" /* 12243 */
	"SQ_TEX_DEPTH_COMPARE_GREATEREQUAL\0" /* 12273 */
	"SQ_TEX_DEPTH_COMPARE_ALWAYS\0" /* 12307 */
	"DEPTH_COMPARE_FUNC\0" /* 12335 */
	"FORCE_UNNORMALIZED\0" /* 12354 */
	"ANISO_THRESHOLD\0" /* 12373 */
	"MC_COORD_TRUNC\0" /* 12389 */
	"FORCE_DEGAMMA\0" /* 12404 */
	"ANISO_BIAS\0" /* 12418 */
	"TRUNC_COORD\0" /* 12429 */
	"DISABLE_CUBE_WRAP\0" /* 12441 */
	"FILTER_MODE\0" /* 12466, 12459 */
	"COMPAT_MODE\0" /* 12471 */
	"MAX_LOD\0" /* 12483 */
	"PERF_MIP\0" /* 12491 */
	"PERF_Z\0" /* 12500 */
	"LOD_BIAS\0" /* 12507 */
	"LOD_BIAS_SEC\0" /* 12516 */
	"SQ_TEX_XY_FILTER_POINT\0" /* 12529, 12543 */
	"SQ_TEX_XY_FILTER_BILINEAR\0" /* 12552, 12571 */
	"XY_MAG_FILTER\0" /* 12578 */
	"SQ_TEX_XY_FILTER_ANISO_POINT\0" /* 12592 */
	"SQ_TEX_XY_FILTER_ANISO_BILINEAR\0" /* 12621 */
	"XY_MIN_FILTER\0" /* 12653 */
	"SQ_TEX_Z_FILTER_NONE\0" /* 12667 */
	"SQ_TEX_Z_FILTER_POINT\0" /* 12688 */
	"SQ_TEX_Z_FILTER_LINEAR\0" /* 12710 */
	"Z_FILTER\0" /* 12733 */
	"MIP_FILTER\0" /* 12742 */
	"MIP_POINT_PRECLAMP\0" /* 12753 */
	"DISABLE_LSB_CEIL\0" /* 12772 */
	"FILTER_PREC_FIX\0" /* 12789 */
	"ANISO_OVERRIDE\0" /* 12805 */
	"BORDER_COLOR_PTR\0" /* 12820 */
	"SQ_TEX_BORDER_COLOR_TRANS_BLACK\0" /* 12837 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_BLACK\0" /* 12869 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_WHITE\0" /* 12902 */
	"SQ_TEX_BORDER_COLOR_REGISTER\0" /* 12935 */
	"BORDER_COLOR_TYPE\0" /* 12964 */
	"VS_LOW_THRESHOLD\0" /* 12982 */
	"GS_LOW_THRESHOLD\0" /* 12999 */
	"ES_LOW_THRESHOLD\0" /* 13016 */
	"HS_LOW_THRESHOLD\0" /* 13033 */
	"LS_LOW_THRESHOLD\0" /* 13050 */
	"PS_CU_EN\0" /* 13067, 13070 */
	"VS_CU_EN\0" /* 13076 */
	"GS_CU_EN\0" /* 13085 */
	"ES_CU_EN\0" /* 13094 */
	"LSHS_CU_EN\0" /* 13103 */
	"MAX_WAVE_ID\0" /* 13114 */
	"X_R0\0" /* 13126 */
	"RING_ORDER_TS0\0" /* 13131 */
	"RING_ORDER_TS1\0" /* 13146 */
	"RING_ORDER_TS2\0" /* 13161 */
	"PIPE_ORDER_TS0\0" /* 13176 */
	"PIPE_ORDER_TS1\0" /* 13191 */
	"PIPE_ORDER_TS2\0" /* 13206 */
	"PIPE_ORDER_TS3\0" /* 13221 */
	"TS0_DUR_MULT\0" /* 13236 */
	"TS1_DUR_MULT\0" /* 13249 */
	"TS2_DUR_MULT\0" /* 13262 */
	"TS3_DUR_MULT\0" /* 13275 */
	"TS0_DURATION\0" /* 13288 */
	"TS1_DURATION\0" /* 13301 */
	"TS2_DURATION\0" /* 13314 */
	"GPR_WRITE_PRIORITY\0" /* 13337, 13327 */
	"EXP_PRIORITY_ORDER\0" /* 13346 */
	"ENABLE_SQG_TOP_EVENTS\0" /* 13365 */
	"ENABLE_SQG_BOP_EVENTS\0" /* 13387 */
	"RSRC_MGMT_RESET\0" /* 13409 */
	"X_DELAY_14_CLKS\0" /* 13425 */
	"X_DELAY_16_CLKS\0" /* 13441 */
	"X_DELAY_18_CLKS\0" /* 13457 */
	"X_DELAY_20_CLKS\0" /* 13473 */
	"X_DELAY_22_CLKS\0" /* 13489 */
	"X_DELAY_24_CLKS\0" /* 13505 */
	"X_DELAY_26_CLKS\0" /* 13521 */
	"X_DELAY_28_CLKS\0" /* 13537 */
	"X_DELAY_30_CLKS\0" /* 13553 */
	"X_DELAY_32_CLKS\0" /* 13569 */
	"X_DELAY_34_CLKS\0" /* 13585 */
	"X_DELAY_4_CLKS\0" /* 13601 */
	"X_DELAY_6_CLKS\0" /* 13616 */
	"X_DELAY_8_CLKS\0" /* 13631 */
	"X_DELAY_10_CLKS\0" /* 13646 */
	"X_DELAY_12_CLKS\0" /* 13662 */
	"VTX_DONE_DELAY\0" /* 13678 */
	"INTERP_ONE_PRIM_PER_ROW\0" /* 13693 */
	"PC_LIMIT_ENABLE\0" /* 13717 */
	"PC_LIMIT_STRICT\0" /* 13733 */
	"PC_LIMIT_SIZE\0" /* 13749 */
	"TYPE_A\0" /* 13763 */
	"VGPR_A\0" /* 13770 */
	"SGPR_A\0" /* 13777 */
	"LDS_A\0" /* 13784 */
	"WAVES_A\0" /* 13790 */
	"EN_A\0" /* 13798 */
	"TYPE_B\0" /* 13803 */
	"VGPR_B\0" /* 13810 */
	"SGPR_B\0" /* 13817 */
	"LDS_B\0" /* 13824 */
	"WAVES_B\0" /* 13830 */
	"EN_B\0" /* 13838 */
	"MSAA1_X\0" /* 13843 */
	"MSAA1_Y\0" /* 13851 */
	"MSAA2_X\0" /* 13859 */
	"MSAA2_Y\0" /* 13867 */
	"MSAA4_X\0" /* 13875 */
	"MSAA4_Y\0" /* 13883 */
	"MSAA8_X\0" /* 13891 */
	"MSAA8_Y\0" /* 13899 */
	"MSAA16_X\0" /* 13907 */
	"MSAA16_Y\0" /* 13916 */
	"NUM_PIPES\0" /* 13925 */
	"PIPE_INTERLEAVE_SIZE\0" /* 13935 */
	"BANK_INTERLEAVE_SIZE\0" /* 13956 */
	"NUM_SHADER_ENGINES\0" /* 13977 */
	"SHADER_ENGINE_TILE_SIZE\0" /* 13996 */
	"NUM_GPUS\0" /* 14020 */
	"MULTI_GPU_TILE_SIZE\0" /* 14029 */
	"ROW_SIZE\0" /* 14049 */
	"NUM_LOWER_PIPES\0" /* 14058 */
	"ADDR_SURF_DISPLAY_MICRO_TILING\0" /* 14074 */
	"ADDR_SURF_THIN_MICRO_TILING\0" /* 14105 */
	"ADDR_SURF_DEPTH_MICRO_TILING\0" /* 14133 */
	"ADDR_SURF_THICK_MICRO_TILING\0" /* 14162 */
	"MICRO_TILE_MODE\0" /* 14191 */
	"ARRAY_LINEAR_GENERAL\0" /* 14213, 14207 */
	"ARRAY_LINEAR_ALIGNED\0" /* 14228 */
	"ARRAY_1D_TILED_THIN1\0" /* 14249 */
	"ARRAY_1D_TILED_THICK\0" /* 14270 */
	"ARRAY_2D_TILED_THIN1\0" /* 14291 */
	"ARRAY_2D_TILED_THICK\0" /* 14312 */
	"ARRAY_2D_TILED_XTHICK\0" /* 14333 */
	"ARRAY_3D_TILED_THIN1\0" /* 14355 */
	"ARRAY_3D_TILED_THICK\0" /* 14376 */
	"ARRAY_3D_TILED_XTHICK\0" /* 14397 */
	"ARRAY_POWER_SAVE\0" /* 14419 */
	"ARRAY_MODE\0" /* 14436 */
	"ADDR_SURF_P2\0" /* 14447 */
	"ADDR_SURF_P2_RESERVED0\0" /* 14460 */
	"ADDR_SURF_P2_RESERVED1\0" /* 14483 */
	"ADDR_SURF_P2_RESERVED2\0" /* 14506, 14519 */
	"X_ADDR_SURF_P4_8X16\0" /* 14529 */
	"X_ADDR_SURF_P4_16X16\0" /* 14549 */
	"X_ADDR_SURF_P4_16X32\0" /* 14570 */
	"X_ADDR_SURF_P4_32X32\0" /* 14591 */
	"X_ADDR_SURF_P8_16X16_8X16\0" /* 14612 */
	"X_ADDR_SURF_P8_16X32_8X16\0" /* 14638 */
	"X_ADDR_SURF_P8_32X32_8X16\0" /* 14664 */
	"X_ADDR_SURF_P8_16X32_16X16\0" /* 14690 */
	"X_ADDR_SURF_P8_32X32_16X16\0" /* 14717 */
	"X_ADDR_SURF_P8_32X32_16X32\0" /* 14744 */
	"X_ADDR_SURF_P8_32X64_32X32\0" /* 14771 */
	"PIPE_CONFIG\0" /* 14798 */
	"ADDR_SURF_TILE_SPLIT_64B\0" /* 14810 */
	"ADDR_SURF_TILE_SPLIT_128B\0" /* 14835 */
	"ADDR_SURF_TILE_SPLIT_256B\0" /* 14861 */
	"ADDR_SURF_TILE_SPLIT_512B\0" /* 14887 */
	"ADDR_SURF_TILE_SPLIT_1KB\0" /* 14913 */
	"ADDR_SURF_TILE_SPLIT_2KB\0" /* 14938 */
	"ADDR_SURF_TILE_SPLIT_4KB\0" /* 14963 */
	"TILE_SPLIT\0" /* 14988 */
	"ADDR_SURF_BANK_WIDTH_1\0" /* 14999 */
	"ADDR_SURF_BANK_WIDTH_2\0" /* 15022 */
	"ADDR_SURF_BANK_WIDTH_4\0" /* 15045 */
	"ADDR_SURF_BANK_WIDTH_8\0" /* 15068 */
	"BANK_WIDTH\0" /* 15091 */
	"ADDR_SURF_BANK_HEIGHT_1\0" /* 15102 */
	"ADDR_SURF_BANK_HEIGHT_2\0" /* 15126 */
	"ADDR_SURF_BANK_HEIGHT_4\0" /* 15150 */
	"ADDR_SURF_BANK_HEIGHT_8\0" /* 15174 */
	"BANK_HEIGHT\0" /* 15198 */
	"ADDR_SURF_MACRO_ASPECT_1\0" /* 15210 */
	"ADDR_SURF_MACRO_ASPECT_2\0" /* 15235 */
	"ADDR_SURF_MACRO_ASPECT_4\0" /* 15260 */
	"ADDR_SURF_MACRO_ASPECT_8\0" /* 15285 */
	"MACRO_TILE_ASPECT\0" /* 15310 */
	"ADDR_SURF_2_BANK\0" /* 15328 */
	"ADDR_SURF_4_BANK\0" /* 15345 */
	"ADDR_SURF_8_BANK\0" /* 15362 */
	"ADDR_SURF_16_BANK\0" /* 15379 */
	"NUM_BANKS\0" /* 15397 */
	"ADDR_SURF_ROTATED_MICRO_TILING\0" /* 15407 */
	"MICRO_TILE_MODE_NEW\0" /* 15438 */
	"SAMPLE_SPLIT\0" /* 15458 */
	"MEM_BASE\0" /* 15471 */
	"WAVE_LIMIT\0" /* 15480 */
	"LOCK_LOW_THRESHOLD\0" /* 15491 */
	"VGPRS\0" /* 15510 */
	"SGPRS\0" /* 15516 */
	"FP_32_DENORMS\0" /* 15522 */
	"FP_64_DENORMS\0" /* 15536 */
	"FP_ALL_DENORMS\0" /* 15550 */
	"FLOAT_MODE\0" /* 15565 */
	"PRIV\0" /* 15576 */
	"DX10_CLAMP\0" /* 15581 */
	"DEBUG_MODE\0" /* 15592 */
	"IEEE_MODE\0" /* 15603 */
	"CU_GROUP_DISABLE\0" /* 15613 */
	"CACHE_CTL\0" /* 15630 */
	"CDBG_USER\0" /* 15640 */
	"SCRATCH_EN\0" /* 15650 */
	"USER_SGPR\0" /* 15661 */
	"TRAP_PRESENT\0" /* 15671 */
	"WAVE_CNT_EN\0" /* 15684 */
	"EXTRA_LDS_SIZE\0" /* 15696, 15702 */
	"EXCP_EN\0" /* 15711 */
	"EXCP_EN_CIK\0" /* 15719 */
	"VGPR_COMP_CNT\0" /* 15731, 15741 */
	"CU_GROUP_ENABLE\0" /* 15745 */
	"OC_LDS_EN\0" /* 15761 */
	"SO_BASE0_EN\0" /* 15771 */
	"SO_BASE1_EN\0" /* 15783 */
	"SO_BASE2_EN\0" /* 15795 */
	"SO_BASE3_EN\0" /* 15807 */
	"SO_EN\0" /* 15819 */
	"DISPATCH_DRAW_EN\0" /* 15825 */
	"GROUP_FIFO_DEPTH\0" /* 15842 */
	"TG_SIZE_EN\0" /* 15859 */
	"COMPUTE_SHADER_EN\0" /* 15870 */
	"PARTIAL_TG_EN\0" /* 15888 */
	"FORCE_START_AT_000\0" /* 15902 */
	"ORDERED_APPEND_ENBL\0" /* 15921 */
	"ORDERED_APPEND_MODE\0" /* 15941 */
	"USE_THREAD_DIMENSIONS\0" /* 15961 */
	"ORDER_MODE\0" /* 15983 */
	"DISPATCH_CACHE_CNTL\0" /* 15994 */
	"SCALAR_L1_INV_VOL\0" /* 16014 */
	"VECTOR_L1_INV_VOL\0" /* 16032 */
	"DATA_ATC\0" /* 16050 */
	"RESTORE\0" /* 16059 */
	"NUM_THREAD_FULL\0" /* 16067 */
	"NUM_THREAD_PARTIAL\0" /* 16083 */
	"PIPELINESTAT_ENABLE\0" /* 16102 */
	"PERFCOUNT_ENABLE\0" /* 16122 */
	"INST_ATC\0" /* 16139 */
	"BULKY\0" /* 16148 */
	"TGID_X_EN\0" /* 16154 */
	"TGID_Y_EN\0" /* 16164 */
	"TGID_Z_EN\0" /* 16174 */
	"TIDIG_COMP_CNT\0" /* 16184 */
	"EXCP_EN_MSB\0" /* 16199 */
	"WAVES_PER_SH\0" /* 16211 */
	"WAVES_PER_SH_CIK\0" /* 16224 */
	"TG_PER_CU\0" /* 16241 */
	"LOCK_THRESHOLD\0" /* 16251 */
	"SIMD_DEST_CNTL\0" /* 16266 */
	"FORCE_SIMD_DIST\0" /* 16281 */
	"CU_GROUP_COUNT\0" /* 16297 */
	"SH0_CU_EN\0" /* 16312 */
	"SH1_CU_EN\0" /* 16322 */
	"WAVES\0" /* 16332 */
	"WAVESIZE\0" /* 16338 */
	"SEND_SEID\0" /* 16347 */
	"RESERVED3\0" /* 16357 */
	"RESERVED4\0" /* 16367 */
	"WAVE_ID_BASE\0" /* 16377 */
	"PAYLOAD\0" /* 16390 */
	"IS_EVENT\0" /* 16398 */
	"IS_STATE\0" /* 16407 */
	"PERFCOUNTER_HI\0" /* 16416 */
	"PERF_SEL2\0" /* 16431 */
	"PERF_SEL3\0" /* 16441 */
	"PERF_SEL\0" /* 16451 */
	"PERF_SEL1\0" /* 16460 */
	"CNTR_MODE\0" /* 16470 */
	"DISABLE_AND_RESET\0" /* 16480 */
	"START_COUNTING\0" /* 16498 */
	"STOP_COUNTING\0" /* 16513 */
	"PERFMON_STATE\0" /* 16527 */
	"SPM_PERFMON_STATE\0" /* 16541 */
	"PERFMON_ENABLE_MODE\0" /* 16559 */
	"PERFMON_SAMPLE_ENABLE\0" /* 16579 */
	"DB_CLEAN_USER_DEFINED_MASK\0" /* 16601 */
	"CB_CLEAN_USER_DEFINED_MASK\0" /* 16628 */
	"VGT_BUSY_USER_DEFINED_MASK\0" /* 16655 */
	"TA_BUSY_USER_DEFINED_MASK\0" /* 16682 */
	"SX_BUSY_USER_DEFINED_MASK\0" /* 16708 */
	"SPI_BUSY_USER_DEFINED_MASK\0" /* 16734 */
	"SC_BUSY_USER_DEFINED_MASK\0" /* 16761 */
	"PA_BUSY_USER_DEFINED_MASK\0" /* 16787 */
	"GRBM_BUSY_USER_DEFINED_MASK\0" /* 16813 */
	"DB_BUSY_USER_DEFINED_MASK\0" /* 16841 */
	"CB_BUSY_USER_DEFINED_MASK\0" /* 16867 */
	"CP_BUSY_USER_DEFINED_MASK\0" /* 16893 */
	"IA_BUSY_USER_DEFINED_MASK\0" /* 16919 */
	"GDS_BUSY_USER_DEFINED_MASK\0" /* 16945 */
	"BCI_BUSY_USER_DEFINED_MASK\0" /* 16972 */
	"RLC_BUSY_USER_DEFINED_MASK\0" /* 16999 */
	"TC_BUSY_USER_DEFINED_MASK\0" /* 17026 */
	"WD_BUSY_USER_DEFINED_MASK\0" /* 17052 */
	"PERF_MODE\0" /* 17078 */
	"PERF_MODE1\0" /* 17088 */
	"PERF_MODE3\0" /* 17099 */
	"PERF_MODE2\0" /* 17110 */
	"PERF_SEID_IGNORE_MASK\0" /* 17121 */
	"BIN0_MIN\0" /* 17143 */
	"BIN0_MAX\0" /* 17152 */
	"BIN1_MIN\0" /* 17161 */
	"BIN1_MAX\0" /* 17170 */
	"BIN2_MIN\0" /* 17179 */
	"BIN2_MAX\0" /* 17188 */
	"BIN3_MIN\0" /* 17197 */
	"BIN3_MAX\0" /* 17206 */
	"SQC_BANK_MASK\0" /* 17215 */
	"SQC_CLIENT_MASK\0" /* 17229 */
	"SPM_MODE\0" /* 17245 */
	"SIMD_MASK\0" /* 17254 */
	"PS_EN\0" /* 17264 */
	"VS_EN\0" /* 17270 */
	"GS_EN\0" /* 17276 */
	"ES_EN\0" /* 17282 */
	"HS_EN\0" /* 17288 */
	"LS_EN\0" /* 17294 */
	"CS_EN\0" /* 17300 */
	"CNTR_RATE\0" /* 17306 */
	"DISABLE_FLUSH\0" /* 17316 */
	"SH0_MASK\0" /* 17330 */
	"SH1_MASK\0" /* 17339 */
	"FORCE_EN\0" /* 17348 */
	"PERFCOUNTER_SELECT\0" /* 17357 */
	"PERFCOUNTER_SELECT1\0" /* 17376 */
	"PERFCOUNTER_SELECT2\0" /* 17396 */
	"PERFCOUNTER_SELECT3\0" /* 17416 */
	"OP_FILTER_ENABLE\0" /* 17436 */
	"OP_FILTER_SEL\0" /* 17453 */
	"FORMAT_FILTER_ENABLE\0" /* 17467 */
	"FORMAT_FILTER_SEL\0" /* 17488 */
	"CLEAR_FILTER_ENABLE\0" /* 17506 */
	"CLEAR_FILTER_SEL\0" /* 17526 */
	"MRT_FILTER_ENABLE\0" /* 17543 */
	"MRT_FILTER_SEL\0" /* 17561 */
	"NUM_SAMPLES_FILTER_ENABLE\0" /* 17576 */
	"NUM_SAMPLES_FILTER_SEL\0" /* 17602 */
	"NUM_FRAGMENTS_FILTER_ENABLE\0" /* 17625 */
	"NUM_FRAGMENTS_FILTER_SEL\0" /* 17653 */
	"DEPTH_CLEAR_ENABLE\0" /* 17678 */
	"STENCIL_CLEAR_ENABLE\0" /* 17697 */
	"DEPTH_COPY\0" /* 17718 */
	"STENCIL_COPY\0" /* 17729 */
	"RESUMMARIZE_ENABLE\0" /* 17742 */
	"STENCIL_COMPRESS_DISABLE\0" /* 17761 */
	"DEPTH_COMPRESS_DISABLE\0" /* 17786 */
	"COPY_CENTROID\0" /* 17809 */
	"COPY_SAMPLE\0" /* 17823 */
	"DECOMPRESS_ENABLE\0" /* 17835 */
	"ZPASS_INCREMENT_DISABLE\0" /* 17853 */
	"PERFECT_ZPASS_COUNTS\0" /* 17877 */
	"SAMPLE_RATE\0" /* 17898 */
	"ZPASS_ENABLE\0" /* 17910 */
	"ZFAIL_ENABLE\0" /* 17923 */
	"SFAIL_ENABLE\0" /* 17936 */
	"DBFAIL_ENABLE\0" /* 17949 */
	"SLICE_EVEN_ENABLE\0" /* 17963 */
	"SLICE_ODD_ENABLE\0" /* 17981 */
	"SLICE_START\0" /* 17998 */
	"SLICE_MAX\0" /* 18010 */
	"Z_READ_ONLY\0" /* 18020 */
	"STENCIL_READ_ONLY\0" /* 18032 */
	"FORCE_OFF\0" /* 18050 */
	"FORCE_ENABLE\0" /* 18060 */
	"FORCE_DISABLE\0" /* 18073 */
	"FORCE_RESERVED\0" /* 18087 */
	"FORCE_HIZ_ENABLE\0" /* 18110, 18102 */
	"FORCE_HIS_ENABLE0\0" /* 18129, 18119 */
	"FORCE_HIS_ENABLE1\0" /* 18137, 18147 */
	"FORCE_SHADER_Z_ORDER\0" /* 18168, 18155 */
	"FAST_Z_DISABLE\0" /* 18176 */
	"FAST_STENCIL_DISABLE\0" /* 18191 */
	"NOOP_CULL_DISABLE\0" /* 18212 */
	"FORCE_COLOR_KILL\0" /* 18230 */
	"FORCE_Z_READ\0" /* 18247 */
	"FORCE_STENCIL_READ\0" /* 18260 */
	"FORCE_FULL_Z_RANGE\0" /* 18279 */
	"FORCE_QC_SMASK_CONFLICT\0" /* 18298 */
	"DISABLE_VIEWPORT_CLAMP\0" /* 18322 */
	"IGNORE_SC_ZRANGE\0" /* 18345 */
	"DISABLE_FULLY_COVERED\0" /* 18362 */
	"FORCE_SUMM_OFF\0" /* 18384 */
	"FORCE_SUMM_MINZ\0" /* 18399 */
	"FORCE_SUMM_MAXZ\0" /* 18415 */
	"FORCE_SUMM_BOTH\0" /* 18431 */
	"FORCE_Z_LIMIT_SUMM\0" /* 18447 */
	"MAX_TILES_IN_DTT\0" /* 18466 */
	"DISABLE_TILE_RATE_TILES\0" /* 18483 */
	"FORCE_Z_DIRTY\0" /* 18507 */
	"FORCE_STENCIL_DIRTY\0" /* 18521 */
	"FORCE_Z_VALID\0" /* 18541 */
	"FORCE_STENCIL_VALID\0" /* 18555 */
	"PRESERVE_COMPRESSION\0" /* 18584, 18575 */
	"PSLC_AUTO\0" /* 18596 */
	"PSLC_ON_HANG_ONLY\0" /* 18606 */
	"PSLC_ASAP\0" /* 18624 */
	"PSLC_COUNTDOWN\0" /* 18634 */
	"PARTIAL_SQUAD_LAUNCH_CONTROL\0" /* 18649 */
	"PARTIAL_SQUAD_LAUNCH_COUNTDOWN\0" /* 18678 */
	"DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION\0" /* 18709 */
	"DISABLE_SMEM_EXPCLEAR_OPTIMIZATION\0" /* 18745 */
	"DISABLE_COLOR_ON_VALIDATION\0" /* 18780 */
	"DECOMPRESS_Z_ON_FLUSH\0" /* 18808 */
	"DISABLE_REG_SNOOP\0" /* 18830 */
	"DEPTH_BOUNDS_HIER_DEPTH_DISABLE\0" /* 18848 */
	"SEPARATE_HIZS_FUNC_ENABLE\0" /* 18880 */
	"HIZ_ZFUNC\0" /* 18906, 18910 */
	"HIS_SFUNC_FF\0" /* 18916 */
	"HIS_SFUNC_BF\0" /* 18929 */
	"PRESERVE_ZRANGE\0" /* 18942 */
	"PRESERVE_SRESULTS\0" /* 18958 */
	"DISABLE_FAST_PASS\0" /* 18976 */
	"CLEAR\0" /* 18994 */
	"TL_X\0" /* 19000 */
	"TL_Y\0" /* 19005 */
	"BR_X\0" /* 19010 */
	"BR_Y\0" /* 19015 */
	"ADDR5_SWIZZLE_MASK\0" /* 19020 */
	"ARRAY_PRT_TILED_THIN1\0" /* 19039 */
	"ARRAY_PRT_2D_TILED_THIN1\0" /* 19061 */
	"X_ADDR_SURF_P16_32X32_8X16\0" /* 19086 */
	"X_ADDR_SURF_P16_32X32_16X16\0" /* 19113 */
	"Z_INVALID\0" /* 19141 */
	"Z_16\0" /* 19151 */
	"Z_24\0" /* 19156 */
	"Z_32_FLOAT\0" /* 19161 */
	"NUM_SAMPLES\0" /* 19172 */
	"TILE_MODE_INDEX\0" /* 19184 */
	"DECOMPRESS_ON_N_ZPLANES\0" /* 19200 */
	"ALLOW_EXPCLEAR\0" /* 19224 */
	"READ_SIZE\0" /* 19239 */
	"TILE_SURFACE_ENABLE\0" /* 19249 */
	"CLEAR_DISALLOWED\0" /* 19269 */
	"ZRANGE_PRECISION\0" /* 19286 */
	"STENCIL_INVALID\0" /* 19303 */
	"STENCIL_8\0" /* 19319 */
	"TILE_STENCIL_DISABLE\0" /* 19329 */
	"PITCH_TILE_MAX\0" /* 19356, 19350 */
	"HEIGHT_TILE_MAX\0" /* 19365 */
	"SLICE_TILE_MAX\0" /* 19381 */
	"WINDOW_X_OFFSET\0" /* 19403, 19396 */
	"WINDOW_Y_OFFSET\0" /* 19419, 19412 */
	"WINDOW_OFFSET_DISABLE\0" /* 19428 */
	"CLIP_RULE\0" /* 19450 */
	"ER_TRI\0" /* 19460 */
	"ER_RECT\0" /* 19467 */
	"ER_LINE_LR\0" /* 19475 */
	"ER_LINE_RL\0" /* 19486 */
	"ER_LINE_TB\0" /* 19497 */
	"ER_LINE_BT\0" /* 19508 */
	"HW_SCREEN_OFFSET_X\0" /* 19519 */
	"HW_SCREEN_OFFSET_Y\0" /* 19538 */
	"TARGET0_ENABLE\0" /* 19557 */
	"TARGET1_ENABLE\0" /* 19572 */
	"TARGET2_ENABLE\0" /* 19587 */
	"TARGET3_ENABLE\0" /* 19602 */
	"TARGET4_ENABLE\0" /* 19617 */
	"TARGET5_ENABLE\0" /* 19632 */
	"TARGET6_ENABLE\0" /* 19647 */
	"TARGET7_ENABLE\0" /* 19662 */
	"OUTPUT0_ENABLE\0" /* 19677 */
	"OUTPUT1_ENABLE\0" /* 19692 */
	"OUTPUT2_ENABLE\0" /* 19707 */
	"OUTPUT3_ENABLE\0" /* 19722 */
	"OUTPUT4_ENABLE\0" /* 19737 */
	"OUTPUT5_ENABLE\0" /* 19752 */
	"OUTPUT6_ENABLE\0" /* 19767 */
	"OUTPUT7_ENABLE\0" /* 19782 */
	"RASTER_CONFIG_RB_MAP_0\0" /* 19797 */
	"RASTER_CONFIG_RB_MAP_1\0" /* 19820 */
	"RASTER_CONFIG_RB_MAP_2\0" /* 19843 */
	"RASTER_CONFIG_RB_MAP_3\0" /* 19866 */
	"RB_MAP_PKR0\0" /* 19889 */
	"RB_MAP_PKR1\0" /* 19901 */
	"RASTER_CONFIG_RB_XSEL2_0\0" /* 19913 */
	"RASTER_CONFIG_RB_XSEL2_1\0" /* 19938 */
	"RASTER_CONFIG_RB_XSEL2_2\0" /* 19963 */
	"RASTER_CONFIG_RB_XSEL2_3\0" /* 19988 */
	"RB_XSEL2\0" /* 20013 */
	"RB_XSEL\0" /* 20022 */
	"RB_YSEL\0" /* 20030 */
	"RASTER_CONFIG_PKR_MAP_0\0" /* 20038 */
	"RASTER_CONFIG_PKR_MAP_1\0" /* 20062 */
	"RASTER_CONFIG_PKR_MAP_2\0" /* 20086 */
	"RASTER_CONFIG_PKR_MAP_3\0" /* 20110 */
	"PKR_MAP\0" /* 20134 */
	"RASTER_CONFIG_PKR_XSEL_0\0" /* 20142 */
	"RASTER_CONFIG_PKR_XSEL_1\0" /* 20167 */
	"RASTER_CONFIG_PKR_XSEL_2\0" /* 20192 */
	"RASTER_CONFIG_PKR_XSEL_3\0" /* 20217 */
	"PKR_XSEL\0" /* 20242 */
	"RASTER_CONFIG_PKR_YSEL_0\0" /* 20251 */
	"RASTER_CONFIG_PKR_YSEL_1\0" /* 20276 */
	"RASTER_CONFIG_PKR_YSEL_2\0" /* 20301 */
	"RASTER_CONFIG_PKR_YSEL_3\0" /* 20326 */
	"PKR_YSEL\0" /* 20351 */
	"RASTER_CONFIG_PKR_XSEL2_0\0" /* 20360 */
	"RASTER_CONFIG_PKR_XSEL2_1\0" /* 20386 */
	"RASTER_CONFIG_PKR_XSEL2_2\0" /* 20412 */
	"RASTER_CONFIG_PKR_XSEL2_3\0" /* 20438 */
	"PKR_XSEL2\0" /* 20464 */
	"RASTER_CONFIG_SC_MAP_0\0" /* 20474 */
	"RASTER_CONFIG_SC_MAP_1\0" /* 20497 */
	"RASTER_CONFIG_SC_MAP_2\0" /* 20520 */
	"RASTER_CONFIG_SC_MAP_3\0" /* 20543 */
	"SC_MAP\0" /* 20566 */
	"RASTER_CONFIG_SC_XSEL_8_WIDE_TILE\0" /* 20573 */
	"RASTER_CONFIG_SC_XSEL_16_WIDE_TILE\0" /* 20607 */
	"RASTER_CONFIG_SC_XSEL_32_WIDE_TILE\0" /* 20642 */
	"RASTER_CONFIG_SC_XSEL_64_WIDE_TILE\0" /* 20677 */
	"SC_XSEL\0" /* 20712 */
	"RASTER_CONFIG_SC_YSEL_8_WIDE_TILE\0" /* 20720 */
	"RASTER_CONFIG_SC_YSEL_16_WIDE_TILE\0" /* 20754 */
	"RASTER_CONFIG_SC_YSEL_32_WIDE_TILE\0" /* 20789 */
	"RASTER_CONFIG_SC_YSEL_64_WIDE_TILE\0" /* 20824 */
	"SC_YSEL\0" /* 20859 */
	"RASTER_CONFIG_SE_MAP_0\0" /* 20867 */
	"RASTER_CONFIG_SE_MAP_1\0" /* 20890 */
	"RASTER_CONFIG_SE_MAP_2\0" /* 20913 */
	"RASTER_CONFIG_SE_MAP_3\0" /* 20936 */
	"SE_MAP\0" /* 20959 */
	"RASTER_CONFIG_SE_XSEL_8_WIDE_TILE\0" /* 20966 */
	"RASTER_CONFIG_SE_XSEL_16_WIDE_TILE\0" /* 21000 */
	"RASTER_CONFIG_SE_XSEL_32_WIDE_TILE\0" /* 21035 */
	"RASTER_CONFIG_SE_XSEL_64_WIDE_TILE\0" /* 21070 */
	"SE_XSEL\0" /* 21105 */
	"RASTER_CONFIG_SE_YSEL_8_WIDE_TILE\0" /* 21113 */
	"RASTER_CONFIG_SE_YSEL_16_WIDE_TILE\0" /* 21147 */
	"RASTER_CONFIG_SE_YSEL_32_WIDE_TILE\0" /* 21182 */
	"RASTER_CONFIG_SE_YSEL_64_WIDE_TILE\0" /* 21217 */
	"SE_YSEL\0" /* 21252 */
	"RASTER_CONFIG_SE_PAIR_MAP_0\0" /* 21260 */
	"RASTER_CONFIG_SE_PAIR_MAP_1\0" /* 21288 */
	"RASTER_CONFIG_SE_PAIR_MAP_2\0" /* 21316 */
	"RASTER_CONFIG_SE_PAIR_MAP_3\0" /* 21344 */
	"SE_PAIR_MAP\0" /* 21372 */
	"RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE\0" /* 21384 */
	"RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE\0" /* 21423 */
	"RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE\0" /* 21463 */
	"RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE\0" /* 21503 */
	"SE_PAIR_XSEL\0" /* 21543 */
	"RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE\0" /* 21556 */
	"RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE\0" /* 21595 */
	"RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE\0" /* 21635 */
	"RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE\0" /* 21675 */
	"SE_PAIR_YSEL\0" /* 21715 */
	"OVERWRITE_COMBINER_DISABLE\0" /* 21728 */
	"OVERWRITE_COMBINER_MRT_SHARING_DISABLE\0" /* 21755 */
	"OVERWRITE_COMBINER_WATERMARK\0" /* 21794 */
	"STENCIL_KEEP\0" /* 21823 */
	"STENCIL_ZERO\0" /* 21836 */
	"STENCIL_ONES\0" /* 21849 */
	"STENCIL_REPLACE_TEST\0" /* 21862 */
	"STENCIL_REPLACE_OP\0" /* 21883 */
	"STENCIL_ADD_CLAMP\0" /* 21902 */
	"STENCIL_SUB_CLAMP\0" /* 21920 */
	"STENCIL_INVERT\0" /* 21938 */
	"STENCIL_ADD_WRAP\0" /* 21953 */
	"STENCIL_SUB_WRAP\0" /* 21970 */
	"STENCIL_AND\0" /* 21987 */
	"STENCIL_OR\0" /* 21999 */
	"STENCIL_XOR\0" /* 22010 */
	"STENCIL_NAND\0" /* 22022 */
	"STENCIL_NOR\0" /* 22035 */
	"STENCIL_XNOR\0" /* 22047 */
	"STENCILFAIL\0" /* 22060 */
	"STENCILZPASS\0" /* 22072 */
	"STENCILZFAIL\0" /* 22085 */
	"STENCILFAIL_BF\0" /* 22098 */
	"STENCILZPASS_BF\0" /* 22113 */
	"STENCILZFAIL_BF\0" /* 22129 */
	"STENCILTESTVAL\0" /* 22145 */
	"STENCILMASK\0" /* 22160 */
	"STENCILWRITEMASK\0" /* 22172 */
	"STENCILOPVAL\0" /* 22189 */
	"STENCILTESTVAL_BF\0" /* 22202 */
	"STENCILMASK_BF\0" /* 22220 */
	"STENCILWRITEMASK_BF\0" /* 22235 */
	"STENCILOPVAL_BF\0" /* 22255 */
	"X_0_0F\0" /* 22271 */
	"DEFAULT_VAL\0" /* 22278 */
	"FLAT_SHADE\0" /* 22290 */
	"CYL_WRAP\0" /* 22301 */
	"PT_SPRITE_TEX\0" /* 22310 */
	"DUP\0" /* 22324 */
	"FP16_INTERP_MODE\0" /* 22328 */
	"USE_DEFAULT_ATTR1\0" /* 22345 */
	"DEFAULT_VAL_ATTR1\0" /* 22363 */
	"PT_SPRITE_TEX_ATTR1\0" /* 22381 */
	"ATTR0_VALID\0" /* 22401 */
	"ATTR1_VALID\0" /* 22413 */
	"VS_EXPORT_COUNT\0" /* 22425 */
	"VS_HALF_PACK\0" /* 22441 */
	"VS_EXPORTS_FOG\0" /* 22454 */
	"VS_OUT_FOG_VEC_ADDR\0" /* 22469 */
	"PERSP_SAMPLE_ENA\0" /* 22489 */
	"PERSP_CENTER_ENA\0" /* 22506 */
	"PERSP_CENTROID_ENA\0" /* 22523 */
	"PERSP_PULL_MODEL_ENA\0" /* 22542 */
	"LINEAR_SAMPLE_ENA\0" /* 22563 */
	"LINEAR_CENTER_ENA\0" /* 22581 */
	"LINEAR_CENTROID_ENA\0" /* 22599 */
	"LINE_STIPPLE_TEX_ENA\0" /* 22619 */
	"POS_X_FLOAT_ENA\0" /* 22640 */
	"POS_Y_FLOAT_ENA\0" /* 22656 */
	"POS_Z_FLOAT_ENA\0" /* 22672 */
	"POS_W_FLOAT_ENA\0" /* 22688 */
	"FRONT_FACE_ENA\0" /* 22704 */
	"ANCILLARY_ENA\0" /* 22719 */
	"SAMPLE_COVERAGE_ENA\0" /* 22733 */
	"POS_FIXED_PT_ENA\0" /* 22753 */
	"FLAT_SHADE_ENA\0" /* 22770 */
	"PNT_SPRITE_ENA\0" /* 22785 */
	"SPI_PNT_SPRITE_SEL_0\0" /* 22800 */
	"SPI_PNT_SPRITE_SEL_1\0" /* 22821 */
	"SPI_PNT_SPRITE_SEL_S\0" /* 22842 */
	"SPI_PNT_SPRITE_SEL_T\0" /* 22863 */
	"SPI_PNT_SPRITE_SEL_NONE\0" /* 22884 */
	"PNT_SPRITE_OVRD_X\0" /* 22908 */
	"PNT_SPRITE_OVRD_Y\0" /* 22926 */
	"PNT_SPRITE_OVRD_Z\0" /* 22944 */
	"PNT_SPRITE_OVRD_W\0" /* 22962 */
	"PNT_SPRITE_TOP_1\0" /* 22980 */
	"NUM_INTERP\0" /* 22997 */
	"PARAM_GEN\0" /* 23008 */
	"FOG_ADDR\0" /* 23018 */
	"BC_OPTIMIZE_DISABLE\0" /* 23027 */
	"PASS_FOG_THROUGH_PS\0" /* 23047 */
	"PERSP_CENTER_CNTL\0" /* 23067 */
	"PERSP_CENTROID_CNTL\0" /* 23085 */
	"LINEAR_CENTER_CNTL\0" /* 23105 */
	"LINEAR_CENTROID_CNTL\0" /* 23124 */
	"X_CALCULATE_PER_PIXEL_FLOATING_POINT_POSITION_AT\0" /* 23145 */
	"POS_FLOAT_LOCATION\0" /* 23194 */
	"POS_FLOAT_ULC\0" /* 23213 */
	"FRONT_FACE_ALL_BITS\0" /* 23227 */
	"NUM_PS_WAVES\0" /* 23247 */
	"NUM_VS_WAVES\0" /* 23260 */
	"NUM_GS_WAVES\0" /* 23273 */
	"NUM_ES_WAVES\0" /* 23286 */
	"NUM_HS_WAVES\0" /* 23299 */
	"NUM_LS_WAVES\0" /* 23312 */
	"SPI_SHADER_NONE\0" /* 23325 */
	"SPI_SHADER_1COMP\0" /* 23341 */
	"SPI_SHADER_2COMP\0" /* 23358 */
	"SPI_SHADER_4COMPRESS\0" /* 23375 */
	"SPI_SHADER_4COMP\0" /* 23396 */
	"POS0_EXPORT_FORMAT\0" /* 23413 */
	"POS1_EXPORT_FORMAT\0" /* 23432 */
	"POS2_EXPORT_FORMAT\0" /* 23451 */
	"POS3_EXPORT_FORMAT\0" /* 23470 */
	"SPI_SHADER_ZERO\0" /* 23489 */
	"SPI_SHADER_32_R\0" /* 23505 */
	"SPI_SHADER_32_GR\0" /* 23521 */
	"SPI_SHADER_32_AR\0" /* 23538 */
	"SPI_SHADER_FP16_ABGR\0" /* 23555 */
	"SPI_SHADER_UNORM16_ABGR\0" /* 23576 */
	"SPI_SHADER_SNORM16_ABGR\0" /* 23600 */
	"SPI_SHADER_UINT16_ABGR\0" /* 23624 */
	"SPI_SHADER_SINT16_ABGR\0" /* 23647 */
	"SPI_SHADER_32_ABGR\0" /* 23670 */
	"Z_EXPORT_FORMAT\0" /* 23689 */
	"COL0_EXPORT_FORMAT\0" /* 23705 */
	"COL1_EXPORT_FORMAT\0" /* 23724 */
	"COL2_EXPORT_FORMAT\0" /* 23743 */
	"COL3_EXPORT_FORMAT\0" /* 23762 */
	"COL4_EXPORT_FORMAT\0" /* 23781 */
	"COL5_EXPORT_FORMAT\0" /* 23800 */
	"COL6_EXPORT_FORMAT\0" /* 23819 */
	"COL7_EXPORT_FORMAT\0" /* 23838 */
	"SX_RT_EXPORT_NO_CONVERSION\0" /* 23857 */
	"SX_RT_EXPORT_32_R\0" /* 23884 */
	"SX_RT_EXPORT_32_A\0" /* 23902 */
	"SX_RT_EXPORT_10_11_11\0" /* 23920 */
	"SX_RT_EXPORT_2_10_10_10\0" /* 23942 */
	"SX_RT_EXPORT_8_8_8_8\0" /* 23966 */
	"SX_RT_EXPORT_5_6_5\0" /* 23987 */
	"SX_RT_EXPORT_1_5_5_5\0" /* 24006 */
	"SX_RT_EXPORT_4_4_4_4\0" /* 24027 */
	"SX_RT_EXPORT_16_16_GR\0" /* 24048 */
	"SX_RT_EXPORT_16_16_AR\0" /* 24070 */
	"MRT0\0" /* 24092 */
	"MRT1\0" /* 24097 */
	"MRT2\0" /* 24102 */
	"MRT3\0" /* 24107 */
	"MRT4\0" /* 24112 */
	"MRT5\0" /* 24117 */
	"MRT6\0" /* 24122 */
	"MRT7\0" /* 24127 */
	"EXACT\0" /* 24132 */
	"11BIT_FORMAT\0" /* 24138 */
	"10BIT_FORMAT\0" /* 24151 */
	"8BIT_FORMAT\0" /* 24164 */
	"6BIT_FORMAT\0" /* 24176 */
	"5BIT_FORMAT\0" /* 24188 */
	"4BIT_FORMAT\0" /* 24200 */
	"MRT0_EPSILON\0" /* 24212 */
	"MRT1_EPSILON\0" /* 24225 */
	"MRT2_EPSILON\0" /* 24238 */
	"MRT3_EPSILON\0" /* 24251 */
	"MRT4_EPSILON\0" /* 24264 */
	"MRT5_EPSILON\0" /* 24277 */
	"MRT6_EPSILON\0" /* 24290 */
	"MRT7_EPSILON\0" /* 24303 */
	"MRT0_COLOR_OPT_DISABLE\0" /* 24316 */
	"MRT0_ALPHA_OPT_DISABLE\0" /* 24339 */
	"MRT1_COLOR_OPT_DISABLE\0" /* 24362 */
	"MRT1_ALPHA_OPT_DISABLE\0" /* 24385 */
	"MRT2_COLOR_OPT_DISABLE\0" /* 24408 */
	"MRT2_ALPHA_OPT_DISABLE\0" /* 24431 */
	"MRT3_COLOR_OPT_DISABLE\0" /* 24454 */
	"MRT3_ALPHA_OPT_DISABLE\0" /* 24477 */
	"MRT4_COLOR_OPT_DISABLE\0" /* 24500 */
	"MRT4_ALPHA_OPT_DISABLE\0" /* 24523 */
	"MRT5_COLOR_OPT_DISABLE\0" /* 24546 */
	"MRT5_ALPHA_OPT_DISABLE\0" /* 24569 */
	"MRT6_COLOR_OPT_DISABLE\0" /* 24592 */
	"MRT6_ALPHA_OPT_DISABLE\0" /* 24615 */
	"MRT7_COLOR_OPT_DISABLE\0" /* 24638 */
	"MRT7_ALPHA_OPT_DISABLE\0" /* 24661 */
	"PIXEN_ZERO_OPT_DISABLE\0" /* 24684 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_ALL\0" /* 24707 */
	"BLEND_OPT_PRESERVE_ALL_IGNORE_NONE\0" /* 24742 */
	"BLEND_OPT_PRESERVE_C1_IGNORE_C0\0" /* 24777 */
	"BLEND_OPT_PRESERVE_C0_IGNORE_C1\0" /* 24809 */
	"BLEND_OPT_PRESERVE_A1_IGNORE_A0\0" /* 24841 */
	"BLEND_OPT_PRESERVE_A0_IGNORE_A1\0" /* 24873 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_A0\0" /* 24905 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_NONE\0" /* 24939 */
	"COLOR_SRC_OPT\0" /* 24975 */
	"COLOR_DST_OPT\0" /* 24989 */
	"OPT_COMB_NONE\0" /* 25003 */
	"OPT_COMB_ADD\0" /* 25017 */
	"OPT_COMB_SUBTRACT\0" /* 25030 */
	"OPT_COMB_MIN\0" /* 25048 */
	"OPT_COMB_MAX\0" /* 25061 */
	"OPT_COMB_REVSUBTRACT\0" /* 25074 */
	"OPT_COMB_BLEND_DISABLED\0" /* 25095 */
	"OPT_COMB_SAFE_ADD\0" /* 25119 */
	"COLOR_COMB_FCN\0" /* 25137 */
	"ALPHA_SRC_OPT\0" /* 25152 */
	"ALPHA_DST_OPT\0" /* 25166 */
	"ALPHA_COMB_FCN\0" /* 25180 */
	"BLEND_ZERO\0" /* 25195 */
	"BLEND_ONE\0" /* 25206 */
	"BLEND_SRC_COLOR\0" /* 25216 */
	"BLEND_ONE_MINUS_SRC_COLOR\0" /* 25232 */
	"BLEND_SRC_ALPHA\0" /* 25258 */
	"BLEND_ONE_MINUS_SRC_ALPHA\0" /* 25274 */
	"BLEND_DST_ALPHA\0" /* 25300 */
	"BLEND_ONE_MINUS_DST_ALPHA\0" /* 25316 */
	"BLEND_DST_COLOR\0" /* 25342 */
	"BLEND_ONE_MINUS_DST_COLOR\0" /* 25358 */
	"BLEND_SRC_ALPHA_SATURATE\0" /* 25384 */
	"BLEND_CONSTANT_COLOR\0" /* 25409 */
	"BLEND_ONE_MINUS_CONSTANT_COLOR\0" /* 25430 */
	"BLEND_SRC1_COLOR\0" /* 25461 */
	"BLEND_INV_SRC1_COLOR\0" /* 25478 */
	"BLEND_SRC1_ALPHA\0" /* 25499 */
	"BLEND_INV_SRC1_ALPHA\0" /* 25516 */
	"BLEND_CONSTANT_ALPHA\0" /* 25537 */
	"BLEND_ONE_MINUS_CONSTANT_ALPHA\0" /* 25558 */
	"COLOR_SRCBLEND\0" /* 25589 */
	"COMB_DST_PLUS_SRC\0" /* 25604 */
	"COMB_SRC_MINUS_DST\0" /* 25622 */
	"COMB_MIN_DST_SRC\0" /* 25641 */
	"COMB_MAX_DST_SRC\0" /* 25658 */
	"COMB_DST_MINUS_SRC\0" /* 25675 */
	"COLOR_DESTBLEND\0" /* 25694 */
	"ALPHA_SRCBLEND\0" /* 25710 */
	"ALPHA_DESTBLEND\0" /* 25725 */
	"SEPARATE_ALPHA_BLEND\0" /* 25741 */
	"DISABLE_ROP3\0" /* 25762, 25770 */
	"SRC_STATE_ID\0" /* 25775 */
	"BASE_ADDR\0" /* 25788 */
	"DI_SRC_SEL_DMA\0" /* 25798 */
	"DI_SRC_SEL_IMMEDIATE\0" /* 25813 */
	"DI_SRC_SEL_AUTO_INDEX\0" /* 25834 */
	"DI_SRC_SEL_RESERVED\0" /* 25856 */
	"SOURCE_SELECT\0" /* 25876 */
	"DI_MAJOR_MODE_0\0" /* 25890 */
	"DI_MAJOR_MODE_1\0" /* 25906 */
	"MAJOR_MODE\0" /* 25922 */
	"NOT_EOP\0" /* 25933 */
	"USE_OPAQUE\0" /* 25941 */
	"ADDRESS_LOW\0" /* 25952 */
	"STENCIL_ENABLE\0" /* 25964 */
	"Z_WRITE_ENABLE\0" /* 25979 */
	"DEPTH_BOUNDS_ENABLE\0" /* 25994 */
	"FRAG_NEVER\0" /* 26014 */
	"FRAG_LESS\0" /* 26025 */
	"FRAG_EQUAL\0" /* 26035 */
	"FRAG_LEQUAL\0" /* 26046 */
	"FRAG_GREATER\0" /* 26058 */
	"FRAG_NOTEQUAL\0" /* 26071 */
	"FRAG_GEQUAL\0" /* 26085 */
	"FRAG_ALWAYS\0" /* 26097 */
	"BACKFACE_ENABLE\0" /* 26109 */
	"REF_NEVER\0" /* 26125 */
	"REF_LESS\0" /* 26135 */
	"REF_EQUAL\0" /* 26144 */
	"REF_LEQUAL\0" /* 26154 */
	"REF_GREATER\0" /* 26165 */
	"REF_NOTEQUAL\0" /* 26177 */
	"REF_GEQUAL\0" /* 26190 */
	"REF_ALWAYS\0" /* 26201 */
	"STENCILFUNC\0" /* 26212 */
	"STENCILFUNC_BF\0" /* 26224 */
	"ENABLE_COLOR_WRITES_ON_DEPTH_FAIL\0" /* 26239 */
	"DISABLE_COLOR_WRITES_ON_DEPTH_PASS\0" /* 26273 */
	"MAX_ANCHOR_SAMPLES\0" /* 26308 */
	"PS_ITER_SAMPLES\0" /* 26327 */
	"MASK_EXPORT_NUM_SAMPLES\0" /* 26343 */
	"ALPHA_TO_MASK_NUM_SAMPLES\0" /* 26367 */
	"HIGH_QUALITY_INTERSECTIONS\0" /* 26393 */
	"INCOHERENT_EQAA_READS\0" /* 26420 */
	"INTERPOLATE_COMP_Z\0" /* 26442 */
	"INTERPOLATE_SRC_Z\0" /* 26461 */
	"STATIC_ANCHOR_ASSOCIATIONS\0" /* 26479 */
	"ALPHA_TO_MASK_EQAA_DISABLE\0" /* 26506 */
	"OVERRASTERIZATION_AMOUNT\0" /* 26533 */
	"ENABLE_POSTZ_OVERRASTERIZATION\0" /* 26558 */
	"DISABLE_DUAL_QUAD\0" /* 26589 */
	"DEGAMMA_ENABLE\0" /* 26607 */
	"CB_DISABLE\0" /* 26622 */
	"CB_NORMAL\0" /* 26633 */
	"CB_ELIMINATE_FAST_CLEAR\0" /* 26656, 26643 */
	"CB_RESOLVE\0" /* 26667 */
	"CB_FMASK_DECOMPRESS\0" /* 26678 */
	"CB_DCC_DECOMPRESS\0" /* 26698 */
	"X_0X00\0" /* 26716 */
	"X_0X05\0" /* 26723 */
	"X_0X0A\0" /* 26730 */
	"X_0X0F\0" /* 26737 */
	"X_0X11\0" /* 26744 */
	"X_0X22\0" /* 26751 */
	"X_0X33\0" /* 26758 */
	"X_0X44\0" /* 26765 */
	"X_0X50\0" /* 26772 */
	"X_0X55\0" /* 26779 */
	"X_0X5A\0" /* 26786 */
	"X_0X5F\0" /* 26793 */
	"X_0X66\0" /* 26800 */
	"X_0X77\0" /* 26807 */
	"X_0X88\0" /* 26814 */
	"X_0X99\0" /* 26821 */
	"X_0XA0\0" /* 26828 */
	"X_0XA5\0" /* 26835 */
	"X_0XAA\0" /* 26842 */
	"X_0XAF\0" /* 26849 */
	"X_0XBB\0" /* 26856 */
	"X_0XCC\0" /* 26863 */
	"X_0XDD\0" /* 26870 */
	"X_0XEE\0" /* 26877 */
	"X_0XF0\0" /* 26884 */
	"X_0XF5\0" /* 26891 */
	"X_0XFA\0" /* 26898 */
	"X_0XFF\0" /* 26905 */
	"Z_EXPORT_ENABLE\0" /* 26912 */
	"STENCIL_TEST_VAL_EXPORT_ENABLE\0" /* 26928 */
	"STENCIL_OP_VAL_EXPORT_ENABLE\0" /* 26959 */
	"LATE_Z\0" /* 26988 */
	"EARLY_Z_THEN_LATE_Z\0" /* 26995 */
	"RE_Z\0" /* 27015 */
	"EARLY_Z_THEN_RE_Z\0" /* 27020 */
	"KILL_ENABLE\0" /* 27038 */
	"COVERAGE_TO_MASK_ENABLE\0" /* 27050 */
	"MASK_EXPORT_ENABLE\0" /* 27074 */
	"EXEC_ON_HIER_FAIL\0" /* 27093 */
	"EXEC_ON_NOOP\0" /* 27111 */
	"ALPHA_TO_MASK_DISABLE\0" /* 27124 */
	"DEPTH_BEFORE_SHADER\0" /* 27146 */
	"EXPORT_ANY_Z\0" /* 27166 */
	"EXPORT_LESS_THAN_Z\0" /* 27179 */
	"EXPORT_GREATER_THAN_Z\0" /* 27198 */
	"EXPORT_RESERVED\0" /* 27220 */
	"CONSERVATIVE_Z_EXPORT\0" /* 27236 */
	"DUAL_QUAD_DISABLE\0" /* 27258 */
	"UCP_ENA_0\0" /* 27276 */
	"UCP_ENA_1\0" /* 27286 */
	"UCP_ENA_2\0" /* 27296 */
	"UCP_ENA_3\0" /* 27306 */
	"UCP_ENA_4\0" /* 27316 */
	"UCP_ENA_5\0" /* 27326 */
	"PS_UCP_Y_SCALE_NEG\0" /* 27336 */
	"PS_UCP_MODE\0" /* 27355 */
	"CLIP_DISABLE\0" /* 27367 */
	"UCP_CULL_ONLY_ENA\0" /* 27380 */
	"BOUNDARY_EDGE_FLAG_ENA\0" /* 27398 */
	"DX_CLIP_SPACE_DEF\0" /* 27421 */
	"DIS_CLIP_ERR_DETECT\0" /* 27439 */
	"VTX_KILL_OR\0" /* 27459 */
	"DX_RASTERIZATION_KILL\0" /* 27471 */
	"DX_LINEAR_ATTR_CLIP_ENA\0" /* 27493 */
	"VTE_VPORT_PROVOKE_DISABLE\0" /* 27517 */
	"ZCLIP_NEAR_DISABLE\0" /* 27543 */
	"ZCLIP_FAR_DISABLE\0" /* 27562 */
	"CULL_FRONT\0" /* 27580 */
	"CULL_BACK\0" /* 27591 */
	"FACE\0" /* 27601 */
	"X_DISABLE_POLY_MODE\0" /* 27616, 27606 */
	"X_DUAL_MODE\0" /* 27626 */
	"X_DRAW_POINTS\0" /* 27638 */
	"X_DRAW_LINES\0" /* 27652 */
	"X_DRAW_TRIANGLES\0" /* 27665 */
	"POLYMODE_FRONT_PTYPE\0" /* 27682 */
	"POLYMODE_BACK_PTYPE\0" /* 27703 */
	"POLY_OFFSET_FRONT_ENABLE\0" /* 27723 */
	"POLY_OFFSET_BACK_ENABLE\0" /* 27748 */
	"POLY_OFFSET_PARA_ENABLE\0" /* 27772 */
	"VTX_WINDOW_OFFSET_ENABLE\0" /* 27796 */
	"PROVOKING_VTX_LAST\0" /* 27821 */
	"PERSP_CORR_DIS\0" /* 27840 */
	"MULTI_PRIM_IB_ENA\0" /* 27855 */
	"VPORT_X_SCALE_ENA\0" /* 27873 */
	"VPORT_X_OFFSET_ENA\0" /* 27891 */
	"VPORT_Y_SCALE_ENA\0" /* 27910 */
	"VPORT_Y_OFFSET_ENA\0" /* 27928 */
	"VPORT_Z_SCALE_ENA\0" /* 27947 */
	"VPORT_Z_OFFSET_ENA\0" /* 27965 */
	"VTX_XY_FMT\0" /* 27984 */
	"VTX_Z_FMT\0" /* 27995 */
	"VTX_W0_FMT\0" /* 28005 */
	"CLIP_DIST_ENA_0\0" /* 28016 */
	"CLIP_DIST_ENA_1\0" /* 28032 */
	"CLIP_DIST_ENA_2\0" /* 28048 */
	"CLIP_DIST_ENA_3\0" /* 28064 */
	"CLIP_DIST_ENA_4\0" /* 28080 */
	"CLIP_DIST_ENA_5\0" /* 28096 */
	"CLIP_DIST_ENA_6\0" /* 28112 */
	"CLIP_DIST_ENA_7\0" /* 28128 */
	"CULL_DIST_ENA_0\0" /* 28144 */
	"CULL_DIST_ENA_1\0" /* 28160 */
	"CULL_DIST_ENA_2\0" /* 28176 */
	"CULL_DIST_ENA_3\0" /* 28192 */
	"CULL_DIST_ENA_4\0" /* 28208 */
	"CULL_DIST_ENA_5\0" /* 28224 */
	"CULL_DIST_ENA_6\0" /* 28240 */
	"CULL_DIST_ENA_7\0" /* 28256 */
	"USE_VTX_POINT_SIZE\0" /* 28272 */
	"USE_VTX_EDGE_FLAG\0" /* 28291 */
	"USE_VTX_RENDER_TARGET_INDX\0" /* 28309 */
	"USE_VTX_VIEWPORT_INDX\0" /* 28336 */
	"USE_VTX_KILL_FLAG\0" /* 28358 */
	"VS_OUT_MISC_VEC_ENA\0" /* 28376 */
	"VS_OUT_CCDIST0_VEC_ENA\0" /* 28396 */
	"VS_OUT_CCDIST1_VEC_ENA\0" /* 28419 */
	"VS_OUT_MISC_SIDE_BUS_ENA\0" /* 28442 */
	"USE_VTX_GS_CUT_FLAG\0" /* 28467 */
	"USE_VTX_LINE_WIDTH\0" /* 28487 */
	"VTE_XY_INF_DISCARD\0" /* 28506 */
	"VTE_Z_INF_DISCARD\0" /* 28525 */
	"VTE_W_INF_DISCARD\0" /* 28543 */
	"VTE_0XNANINF_IS_0\0" /* 28561 */
	"VTE_XY_NAN_RETAIN\0" /* 28579 */
	"VTE_Z_NAN_RETAIN\0" /* 28597 */
	"VTE_W_NAN_RETAIN\0" /* 28614 */
	"VTE_W_RECIP_NAN_IS_0\0" /* 28631 */
	"VS_XY_NAN_TO_INF\0" /* 28652 */
	"VS_XY_INF_RETAIN\0" /* 28669 */
	"VS_Z_NAN_TO_INF\0" /* 28686 */
	"VS_Z_INF_RETAIN\0" /* 28702 */
	"VS_W_NAN_TO_INF\0" /* 28718 */
	"VS_W_INF_RETAIN\0" /* 28734 */
	"VS_CLIP_DIST_INF_DISCARD\0" /* 28750 */
	"VTE_NO_OUTPUT_NEG_0\0" /* 28775 */
	"LINE_STIPPLE_RESET\0" /* 28795 */
	"EXPAND_FULL_LENGTH\0" /* 28814 */
	"FRACTIONAL_ACCUM\0" /* 28833 */
	"DIAMOND_ADJUST\0" /* 28850 */
	"TRIANGLE_FILTER_DISABLE\0" /* 28865 */
	"LINE_FILTER_DISABLE\0" /* 28889 */
	"POINT_FILTER_DISABLE\0" /* 28909 */
	"RECTANGLE_FILTER_DISABLE\0" /* 28930 */
	"TRIANGLE_EXPAND_ENA\0" /* 28955 */
	"LINE_EXPAND_ENA\0" /* 28975 */
	"POINT_EXPAND_ENA\0" /* 28991 */
	"RECTANGLE_EXPAND_ENA\0" /* 29008 */
	"PRIM_EXPAND_CONSTANT\0" /* 29029 */
	"XMAX_RIGHT_EXCLUSION\0" /* 29050 */
	"YMAX_BOTTOM_EXCLUSION\0" /* 29071 */
	"SMALL_PRIM_FILTER_ENABLE\0" /* 29093 */
	"MIN_SIZE\0" /* 29118 */
	"MAX_SIZE\0" /* 29127 */
	"LINE_PATTERN\0" /* 29136 */
	"REPEAT_COUNT\0" /* 29149 */
	"PATTERN_BIT_ORDER\0" /* 29162 */
	"AUTO_RESET_CNTL\0" /* 29180 */
	"VGT_OUTPATH_VTX_REUSE\0" /* 29196 */
	"VGT_OUTPATH_TESS_EN\0" /* 29218 */
	"VGT_OUTPATH_PASSTHRU\0" /* 29238 */
	"VGT_OUTPATH_GS_BLOCK\0" /* 29259 */
	"VGT_OUTPATH_HS_BLOCK\0" /* 29280 */
	"PATH_SELECT\0" /* 29301 */
	"TESS_MODE\0" /* 29313 */
	"REUSE_DEPTH\0" /* 29323 */
	"VGT_GRP_3D_POINT\0" /* 29335 */
	"VGT_GRP_3D_LINE\0" /* 29352 */
	"VGT_GRP_3D_TRI\0" /* 29368 */
	"VGT_GRP_3D_RECT\0" /* 29383 */
	"VGT_GRP_3D_QUAD\0" /* 29399 */
	"VGT_GRP_2D_COPY_RECT_V0\0" /* 29415 */
	"VGT_GRP_2D_COPY_RECT_V1\0" /* 29439 */
	"VGT_GRP_2D_COPY_RECT_V2\0" /* 29463 */
	"VGT_GRP_2D_COPY_RECT_V3\0" /* 29487 */
	"VGT_GRP_2D_FILL_RECT\0" /* 29511 */
	"VGT_GRP_2D_LINE\0" /* 29532 */
	"VGT_GRP_2D_TRI\0" /* 29548 */
	"VGT_GRP_PRIM_INDEX_LINE\0" /* 29563 */
	"VGT_GRP_PRIM_INDEX_TRI\0" /* 29587 */
	"VGT_GRP_PRIM_INDEX_QUAD\0" /* 29610 */
	"VGT_GRP_3D_LINE_ADJ\0" /* 29634 */
	"VGT_GRP_3D_TRI_ADJ\0" /* 29654 */
	"VGT_GRP_3D_PATCH\0" /* 29673 */
	"RETAIN_ORDER\0" /* 29690 */
	"RETAIN_QUADS\0" /* 29703 */
	"VGT_GRP_LIST\0" /* 29716 */
	"VGT_GRP_STRIP\0" /* 29729 */
	"VGT_GRP_FAN\0" /* 29743 */
	"VGT_GRP_LOOP\0" /* 29755 */
	"VGT_GRP_POLYGON\0" /* 29768 */
	"PRIM_ORDER\0" /* 29784 */
	"FIRST_DECR\0" /* 29801, 29795 */
	"COMP_X_EN\0" /* 29806 */
	"COMP_Y_EN\0" /* 29816 */
	"COMP_Z_EN\0" /* 29826 */
	"COMP_W_EN\0" /* 29836 */
	"SHIFT\0" /* 29846 */
	"VGT_GRP_INDEX_16\0" /* 29852 */
	"VGT_GRP_INDEX_32\0" /* 29869 */
	"VGT_GRP_UINT_16\0" /* 29886 */
	"VGT_GRP_UINT_32\0" /* 29902 */
	"VGT_GRP_SINT_16\0" /* 29918 */
	"VGT_GRP_SINT_32\0" /* 29934 */
	"VGT_GRP_FLOAT_32\0" /* 29950 */
	"VGT_GRP_AUTO_PRIM\0" /* 29967 */
	"VGT_GRP_FIX_1_23_TO_FLOAT\0" /* 29985 */
	"X_CONV\0" /* 30011 */
	"Y_CONV\0" /* 30018 */
	"Z_CONV\0" /* 30025 */
	"Z_OFFSET\0" /* 30032 */
	"W_CONV\0" /* 30041 */
	"W_OFFSET\0" /* 30048 */
	"GS_OFF\0" /* 30057 */
	"GS_SCENARIO_A\0" /* 30064 */
	"GS_SCENARIO_B\0" /* 30078 */
	"GS_SCENARIO_G\0" /* 30092 */
	"GS_SCENARIO_C\0" /* 30106 */
	"SPRITE_EN\0" /* 30120 */
	"GS_CUT_1024\0" /* 30130 */
	"GS_CUT_512\0" /* 30142 */
	"GS_CUT_256\0" /* 30153 */
	"GS_CUT_128\0" /* 30164 */
	"CUT_MODE\0" /* 30175 */
	"GS_C_PACK_EN\0" /* 30184 */
	"RESERVED_2\0" /* 30197 */
	"ES_PASSTHRU\0" /* 30208 */
	"COMPUTE_MODE\0" /* 30220 */
	"FAST_COMPUTE_MODE\0" /* 30233 */
	"ELEMENT_INFO_EN\0" /* 30251 */
	"PARTIAL_THD_AT_EOI\0" /* 30267 */
	"SUPPRESS_CUTS\0" /* 30286 */
	"ES_WRITE_OPTIMIZE\0" /* 30300 */
	"GS_WRITE_OPTIMIZE\0" /* 30318 */
	"X_0_OFFCHIP_GS\0" /* 30336 */
	"X_3_ES_AND_GS_ARE_ONCHIP\0" /* 30369, 30351 */
	"ES_VERTS_PER_SUBGRP\0" /* 30376 */
	"GS_PRIMS_PER_SUBGRP\0" /* 30396 */
	"MSAA_ENABLE\0" /* 30416 */
	"VPORT_SCISSOR_ENABLE\0" /* 30428 */
	"LINE_STIPPLE_ENABLE\0" /* 30449 */
	"SEND_UNLIT_STILES_TO_PKR\0" /* 30469 */
	"WALK_SIZE\0" /* 30494 */
	"WALK_ALIGNMENT\0" /* 30504 */
	"WALK_ALIGN8_PRIM_FITS_ST\0" /* 30519 */
	"WALK_FENCE_ENABLE\0" /* 30544 */
	"WALK_FENCE_SIZE\0" /* 30562 */
	"SUPERTILE_WALK_ORDER_ENABLE\0" /* 30578, 30583 */
	"TILE_COVER_DISABLE\0" /* 30606 */
	"TILE_COVER_NO_SCISSOR\0" /* 30625 */
	"ZMM_LINE_EXTENT\0" /* 30647 */
	"ZMM_LINE_OFFSET\0" /* 30663 */
	"ZMM_RECT_EXTENT\0" /* 30679 */
	"KILL_PIX_POST_HI_Z\0" /* 30695 */
	"KILL_PIX_POST_DETAIL_MASK\0" /* 30714 */
	"PS_ITER_SAMPLE\0" /* 30740 */
	"MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE\0" /* 30755 */
	"MULTI_GPU_SUPERTILE_ENABLE\0" /* 30795 */
	"GPU_ID_OVERRIDE_ENABLE\0" /* 30822 */
	"GPU_ID_OVERRIDE\0" /* 30845 */
	"MULTI_GPU_PRIM_DISCARD_ENABLE\0" /* 30861 */
	"FORCE_EOV_CNTDWN_ENABLE\0" /* 30891 */
	"FORCE_EOV_REZ_ENABLE\0" /* 30915 */
	"OUT_OF_ORDER_PRIMITIVE_ENABLE\0" /* 30936 */
	"OUT_OF_ORDER_WATER_MARK\0" /* 30966 */
	"GS_PER_ES\0" /* 30990 */
	"ES_PER_GS\0" /* 31000 */
	"GS_PER_VS\0" /* 31010 */
	"OUTPRIM_TYPE_POINTLIST\0" /* 31020 */
	"OUTPRIM_TYPE_LINESTRIP\0" /* 31043 */
	"OUTPRIM_TYPE_TRISTRIP\0" /* 31066 */
	"OUTPRIM_TYPE\0" /* 31088 */
	"OUTPRIM_TYPE_1\0" /* 31101 */
	"OUTPRIM_TYPE_2\0" /* 31116 */
	"OUTPRIM_TYPE_3\0" /* 31131 */
	"UNIQUE_TYPE_PER_STREAM\0" /* 31146 */
	"VGT_INDEX_16\0" /* 31169 */
	"VGT_INDEX_32\0" /* 31182 */
	"VGT_INDEX_8\0" /* 31195 */
	"VGT_DMA_SWAP_NONE\0" /* 31207 */
	"VGT_DMA_SWAP_16_BIT\0" /* 31225 */
	"VGT_DMA_SWAP_32_BIT\0" /* 31245 */
	"VGT_DMA_SWAP_WORD\0" /* 31265 */
	"SWAP_MODE\0" /* 31283 */
	"VGT_DMA_BUF_MEM\0" /* 31293 */
	"VGT_DMA_BUF_RING\0" /* 31309 */
	"VGT_DMA_BUF_SETUP\0" /* 31326 */
	"BUF_TYPE\0" /* 31344 */
	"VGT_POLICY_LRU\0" /* 31353 */
	"VGT_POLICY_STREAM\0" /* 31368 */
	"RDREQ_POLICY\0" /* 31386 */
	"RDREQ_POLICY_VI\0" /* 31399 */
	"REQ_PATH\0" /* 31415 */
	"PRIMITIVEID_EN\0" /* 31424 */
	"DISABLE_RESET_ON_EOI\0" /* 31439 */
	"SAMPLE_STREAMOUTSTATS1\0" /* 31460 */
	"SAMPLE_STREAMOUTSTATS2\0" /* 31483 */
	"SAMPLE_STREAMOUTSTATS3\0" /* 31506 */
	"CACHE_FLUSH_TS\0" /* 31529 */
	"CONTEXT_DONE\0" /* 31544 */
	"CACHE_FLUSH\0" /* 31557 */
	"CS_PARTIAL_FLUSH\0" /* 31569 */
	"VGT_STREAMOUT_SYNC\0" /* 31586 */
	"VGT_STREAMOUT_RESET\0" /* 31605 */
	"END_OF_PIPE_INCR_DE\0" /* 31625 */
	"END_OF_PIPE_IB_END\0" /* 31645 */
	"RST_PIX_CNT\0" /* 31664 */
	"VS_PARTIAL_FLUSH\0" /* 31676 */
	"PS_PARTIAL_FLUSH\0" /* 31693 */
	"FLUSH_HS_OUTPUT\0" /* 31710 */
	"FLUSH_LS_OUTPUT\0" /* 31726 */
	"CACHE_FLUSH_AND_INV_TS_EVENT\0" /* 31742 */
	"ZPASS_DONE\0" /* 31771 */
	"CACHE_FLUSH_AND_INV_EVENT\0" /* 31782 */
	"PERFCOUNTER_START\0" /* 31808 */
	"PERFCOUNTER_STOP\0" /* 31826 */
	"PIPELINESTAT_START\0" /* 31843 */
	"PIPELINESTAT_STOP\0" /* 31862 */
	"PERFCOUNTER_SAMPLE\0" /* 31880 */
	"FLUSH_ES_OUTPUT\0" /* 31899 */
	"FLUSH_GS_OUTPUT\0" /* 31915 */
	"SAMPLE_PIPELINESTAT\0" /* 31931 */
	"SO_VGTSTREAMOUT_FLUSH\0" /* 31951 */
	"SAMPLE_STREAMOUTSTATS\0" /* 31973 */
	"RESET_VTX_CNT\0" /* 31995 */
	"BLOCK_CONTEXT_DONE\0" /* 32009 */
	"CS_CONTEXT_DONE\0" /* 32028 */
	"VGT_FLUSH\0" /* 32044 */
	"SC_SEND_DB_VPZ\0" /* 32054 */
	"BOTTOM_OF_PIPE_TS\0" /* 32069 */
	"DB_CACHE_FLUSH_AND_INV\0" /* 32087 */
	"FLUSH_AND_INV_DB_DATA_TS\0" /* 32110 */
	"FLUSH_AND_INV_DB_META\0" /* 32135 */
	"FLUSH_AND_INV_CB_DATA_TS\0" /* 32157 */
	"FLUSH_AND_INV_CB_META\0" /* 32182 */
	"FLUSH_AND_INV_CB_PIXEL_DATA\0" /* 32204 */
	"THREAD_TRACE_START\0" /* 32232 */
	"THREAD_TRACE_STOP\0" /* 32251 */
	"THREAD_TRACE_MARKER\0" /* 32269 */
	"THREAD_TRACE_FLUSH\0" /* 32289 */
	"THREAD_TRACE_FINISH\0" /* 32308 */
	"PIXEL_PIPE_STAT_CONTROL\0" /* 32328 */
	"PIXEL_PIPE_STAT_DUMP\0" /* 32352 */
	"PIXEL_PIPE_STAT_RESET\0" /* 32373 */
	"EVENT_TYPE\0" /* 32395 */
	"EXTENDED_EVENT\0" /* 32406 */
	"RESET_EN\0" /* 32421 */
	"PRIMGROUP_SIZE\0" /* 32430 */
	"PARTIAL_VS_WAVE_ON\0" /* 32445 */
	"SWITCH_ON_EOP\0" /* 32464 */
	"PARTIAL_ES_WAVE_ON\0" /* 32478 */
	"SWITCH_ON_EOI\0" /* 32497 */
	"WD_SWITCH_ON_EOP\0" /* 32511 */
	"MAX_PRIMGRP_IN_WAVE\0" /* 32528 */
	"ITEMSIZE\0" /* 32548 */
	"REUSE_OFF\0" /* 32557 */
	"VTX_CNT_EN\0" /* 32567 */
	"FULL_CACHE\0" /* 32578 */
	"HTILE_USES_PRELOAD_WIN\0" /* 32589 */
	"PRELOAD\0" /* 32612 */
	"PREFETCH_WIDTH\0" /* 32620 */
	"PREFETCH_HEIGHT\0" /* 32635 */
	"DST_OUTSIDE_ZERO_TO_ONE\0" /* 32651 */
	"TC_COMPATIBLE\0" /* 32675 */
	"COMPAREFUNC0\0" /* 32689 */
	"COMPAREVALUE0\0" /* 32702 */
	"COMPAREMASK0\0" /* 32716 */
	"COMPAREFUNC1\0" /* 32729 */
	"COMPAREVALUE1\0" /* 32742 */
	"COMPAREMASK1\0" /* 32756 */
	"START_X\0" /* 32769 */
	"START_Y\0" /* 32777 */
	"MAX_X\0" /* 32785 */
	"MAX_Y\0" /* 32791 */
	"VERTEX_STRIDE\0" /* 32797 */
	"MAX_VERT_OUT\0" /* 32811 */
	"ACCUM_ISOLINE\0" /* 32824 */
	"ACCUM_TRI\0" /* 32838 */
	"ACCUM_QUAD\0" /* 32848 */
	"DONUT_SPLIT\0" /* 32859 */
	"TRAP_SPLIT\0" /* 32871 */
	"LS_STAGE_OFF\0" /* 32882 */
	"LS_STAGE_ON\0" /* 32895 */
	"CS_STAGE_ON\0" /* 32907 */
	"ES_STAGE_OFF\0" /* 32919 */
	"ES_STAGE_DS\0" /* 32932 */
	"ES_STAGE_REAL\0" /* 32944 */
	"VS_STAGE_REAL\0" /* 32958 */
	"VS_STAGE_DS\0" /* 32972 */
	"VS_STAGE_COPY_SHADER\0" /* 32984 */
	"DYNAMIC_HS\0" /* 33005 */
	"DIS_DEALLOC_ACCUM_0\0" /* 33016 */
	"DIS_DEALLOC_ACCUM_1\0" /* 33036 */
	"VS_WAVE_ID_EN\0" /* 33056 */
	"NUM_PATCHES\0" /* 33070 */
	"HS_NUM_INPUT_CP\0" /* 33082 */
	"HS_NUM_OUTPUT_CP\0" /* 33098 */
	"TESS_ISOLINE\0" /* 33115 */
	"TESS_TRIANGLE\0" /* 33128 */
	"TESS_QUAD\0" /* 33142 */
	"PART_INTEGER\0" /* 33152 */
	"PART_POW2\0" /* 33165 */
	"PART_FRAC_ODD\0" /* 33175 */
	"PART_FRAC_EVEN\0" /* 33189 */
	"PARTITIONING\0" /* 33204 */
	"OUTPUT_POINT\0" /* 33217 */
	"OUTPUT_LINE\0" /* 33230 */
	"OUTPUT_TRIANGLE_CW\0" /* 33242 */
	"OUTPUT_TRIANGLE_CCW\0" /* 33261 */
	"TOPOLOGY\0" /* 33281 */
	"RESERVED_REDUC_AXIS\0" /* 33290 */
	"DEPRECATED\0" /* 33310 */
	"NUM_DS_WAVES_PER_SIMD\0" /* 33321 */
	"DISABLE_DONUTS\0" /* 33343 */
	"VGT_POLICY_BYPASS\0" /* 33358 */
	"DISTRIBUTION_MODE_NO_DIST\0" /* 33376 */
	"DISTRIBUTION_MODE_PATCHES\0" /* 33402 */
	"DISTRIBUTION_MODE_DONUTS\0" /* 33428 */
	"DISTRIBUTION_MODE_TRAPEZOIDS\0" /* 33453 */
	"DISTRIBUTION_MODE\0" /* 33482 */
	"ALPHA_TO_MASK_ENABLE\0" /* 33500 */
	"ALPHA_TO_MASK_OFFSET0\0" /* 33521 */
	"ALPHA_TO_MASK_OFFSET1\0" /* 33543 */
	"ALPHA_TO_MASK_OFFSET2\0" /* 33565 */
	"ALPHA_TO_MASK_OFFSET3\0" /* 33587 */
	"OFFSET_ROUND\0" /* 33609 */
	"POLY_OFFSET_NEG_NUM_DB_BITS\0" /* 33622 */
	"POLY_OFFSET_DB_IS_FLOAT_FMT\0" /* 33650 */
	"STREAMOUT_0_EN\0" /* 33678 */
	"STREAMOUT_1_EN\0" /* 33693 */
	"STREAMOUT_2_EN\0" /* 33708 */
	"STREAMOUT_3_EN\0" /* 33723 */
	"RAST_STREAM\0" /* 33738 */
	"RAST_STREAM_MASK\0" /* 33750 */
	"USE_RAST_STREAM_MASK\0" /* 33767 */
	"STREAM_0_BUFFER_EN\0" /* 33788 */
	"STREAM_1_BUFFER_EN\0" /* 33807 */
	"STREAM_2_BUFFER_EN\0" /* 33826 */
	"STREAM_3_BUFFER_EN\0" /* 33845 */
	"DISTANCE_0\0" /* 33864 */
	"DISTANCE_1\0" /* 33875 */
	"DISTANCE_2\0" /* 33886 */
	"DISTANCE_3\0" /* 33897 */
	"DISTANCE_4\0" /* 33908 */
	"DISTANCE_5\0" /* 33919 */
	"DISTANCE_6\0" /* 33930 */
	"DISTANCE_7\0" /* 33941 */
	"DISTANCE_8\0" /* 33952 */
	"DISTANCE_9\0" /* 33963 */
	"DISTANCE_10\0" /* 33974 */
	"DISTANCE_11\0" /* 33986 */
	"DISTANCE_12\0" /* 33998 */
	"DISTANCE_13\0" /* 34010 */
	"DISTANCE_14\0" /* 34022 */
	"DISTANCE_15\0" /* 34034 */
	"EXPAND_LINE_WIDTH\0" /* 34046 */
	"LAST_PIXEL\0" /* 34064 */
	"PERPENDICULAR_ENDCAP_ENA\0" /* 34075 */
	"DX10_DIAMOND_TEST_ENA\0" /* 34100 */
	"MSAA_NUM_SAMPLES\0" /* 34122 */
	"AA_MASK_CENTROID_DTMN\0" /* 34139 */
	"MAX_SAMPLE_DIST\0" /* 34161 */
	"MSAA_EXPOSED_SAMPLES\0" /* 34177 */
	"DETAIL_TO_EXPOSED_MODE\0" /* 34198 */
	"PIX_CENTER\0" /* 34221 */
	"X_TRUNCATE\0" /* 34232 */
	"X_ROUND\0" /* 34243 */
	"X_ROUND_TO_EVEN\0" /* 34251 */
	"X_ROUND_TO_ODD\0" /* 34267 */
	"ROUND_MODE\0" /* 34282 */
	"X_16_8_FIXED_POINT_1_16TH\0" /* 34293 */
	"X_16_8_FIXED_POINT_1_8TH\0" /* 34319 */
	"X_16_8_FIXED_POINT_1_4TH\0" /* 34344 */
	"X_16_8_FIXED_POINT_1_2\0" /* 34369 */
	"X_16_8_FIXED_POINT_1\0" /* 34392 */
	"X_16_8_FIXED_POINT_1_256TH\0" /* 34413 */
	"X_14_10_FIXED_POINT_1_1024TH\0" /* 34440 */
	"X_12_12_FIXED_POINT_1_4096TH\0" /* 34469 */
	"QUANT_MODE\0" /* 34498 */
	"S0_X\0" /* 34509 */
	"S0_Y\0" /* 34514 */
	"S1_X\0" /* 34519 */
	"S1_Y\0" /* 34524 */
	"S2_X\0" /* 34529 */
	"S2_Y\0" /* 34534 */
	"S3_X\0" /* 34539 */
	"S3_Y\0" /* 34544 */
	"S4_X\0" /* 34549 */
	"S4_Y\0" /* 34554 */
	"S5_X\0" /* 34559 */
	"S5_Y\0" /* 34564 */
	"S6_X\0" /* 34569 */
	"S6_Y\0" /* 34574 */
	"S7_X\0" /* 34579 */
	"S7_Y\0" /* 34584 */
	"S8_X\0" /* 34589 */
	"S8_Y\0" /* 34594 */
	"S9_X\0" /* 34599 */
	"S9_Y\0" /* 34604 */
	"S10_X\0" /* 34609 */
	"S10_Y\0" /* 34615 */
	"S11_X\0" /* 34621 */
	"S11_Y\0" /* 34627 */
	"S12_X\0" /* 34633 */
	"S12_Y\0" /* 34639 */
	"S13_X\0" /* 34645 */
	"S13_Y\0" /* 34651 */
	"S14_X\0" /* 34657 */
	"S14_Y\0" /* 34663 */
	"S15_X\0" /* 34669 */
	"S15_Y\0" /* 34675 */
	"AA_MASK_X0Y0\0" /* 34681 */
	"AA_MASK_X1Y0\0" /* 34694 */
	"AA_MASK_X0Y1\0" /* 34707 */
	"AA_MASK_X1Y1\0" /* 34720 */
	"REALIGN_DQUADS_AFTER_N_WAVES\0" /* 34733 */
	"VTX_REUSE_DEPTH\0" /* 34762 */
	"DEALLOC_DIST\0" /* 34778 */
	"FMASK_TILE_MAX\0" /* 34791 */
	"ENDIAN_NONE\0" /* 34806 */
	"ENDIAN_8IN16\0" /* 34818 */
	"ENDIAN_8IN32\0" /* 34831 */
	"ENDIAN_8IN64\0" /* 34844 */
	"ENDIAN\0" /* 34857 */
	"COLOR_INVALID\0" /* 34864 */
	"COLOR_8\0" /* 34878 */
	"COLOR_16\0" /* 34886 */
	"COLOR_8_8\0" /* 34895 */
	"COLOR_32\0" /* 34905 */
	"COLOR_16_16\0" /* 34914 */
	"COLOR_10_11_11\0" /* 34926 */
	"COLOR_11_11_10\0" /* 34941 */
	"COLOR_10_10_10_2\0" /* 34956 */
	"COLOR_2_10_10_10\0" /* 34973 */
	"COLOR_8_8_8_8\0" /* 34990 */
	"COLOR_32_32\0" /* 35004 */
	"COLOR_16_16_16_16\0" /* 35016 */
	"COLOR_32_32_32_32\0" /* 35034 */
	"COLOR_5_6_5\0" /* 35052 */
	"COLOR_1_5_5_5\0" /* 35064 */
	"COLOR_5_5_5_1\0" /* 35078 */
	"COLOR_4_4_4_4\0" /* 35092 */
	"COLOR_8_24\0" /* 35106 */
	"COLOR_24_8\0" /* 35117 */
	"COLOR_X24_8_32_FLOAT\0" /* 35128 */
	"NUMBER_UNORM\0" /* 35149 */
	"NUMBER_SNORM\0" /* 35162 */
	"NUMBER_UINT\0" /* 35175 */
	"NUMBER_SINT\0" /* 35187 */
	"NUMBER_SRGB\0" /* 35199 */
	"NUMBER_FLOAT\0" /* 35211 */
	"NUMBER_TYPE\0" /* 35224 */
	"SWAP_STD\0" /* 35236 */
	"SWAP_ALT\0" /* 35245 */
	"SWAP_STD_REV\0" /* 35254 */
	"SWAP_ALT_REV\0" /* 35267 */
	"COMP_SWAP\0" /* 35280 */
	"BLEND_CLAMP\0" /* 35290 */
	"BLEND_BYPASS\0" /* 35302 */
	"SIMPLE_FLOAT\0" /* 35315 */
	"CMASK_IS_LINEAR\0" /* 35328 */
	"FORCE_OPT_AUTO\0" /* 35344 */
	"FORCE_OPT_DISABLE\0" /* 35359 */
	"FORCE_OPT_ENABLE_IF_SRC_A_0\0" /* 35377 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_0\0" /* 35405 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_0\0" /* 35435 */
	"FORCE_OPT_ENABLE_IF_SRC_A_1\0" /* 35466 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_1\0" /* 35494 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_1\0" /* 35524 */
	"BLEND_OPT_DONT_RD_DST\0" /* 35555 */
	"BLEND_OPT_DISCARD_PIXEL\0" /* 35577 */
	"FMASK_COMPRESSION_DISABLE\0" /* 35601 */
	"FMASK_COMPRESS_1FRAG_ONLY\0" /* 35627 */
	"DCC_ENABLE\0" /* 35653 */
	"CMASK_ADDR_TYPE\0" /* 35664 */
	"FMASK_TILE_MODE_INDEX\0" /* 35680 */
	"FMASK_BANK_HEIGHT\0" /* 35702 */
	"NUM_FRAGMENTS\0" /* 35720 */
	"FORCE_DST_ALPHA_1\0" /* 35734 */
	"KEY_CLEAR_ENABLE\0" /* 35752 */
	"MAX_UNCOMPRESSED_BLOCK_SIZE\0" /* 35769 */
	"MIN_COMPRESSED_BLOCK_SIZE\0" /* 35797 */
	"MAX_COMPRESSED_BLOCK_SIZE\0" /* 35823 */
	"INDEPENDENT_64B_BLOCKS\0" /* 35849 */
	"LOSSY_RGB_PRECISION\0" /* 35872 */
	"LOSSY_ALPHA_PRECISION\0" /* 35892 */
	"DRAW_INDEX_LOC\0" /* 35914 */
	"IB_BASE_LO\0" /* 35929 */
	"IB_BASE_HI\0" /* 35940 */
	"CP_DMA_WORD0\0" /* 35951 */
	"CP_DMA_WORD1\0" /* 35964 */
	"CP_DMA_WORD2\0" /* 35977 */
	"CP_DMA_WORD3\0" /* 35990 */
	"COMMAND\0" /* 36003 */
	"DMA_DATA_WORD0\0" /* 36011 */
	"SRBM_STATUS2\0" /* 36026 */
	"SRBM_STATUS\0" /* 36039 */
	"SRBM_STATUS3\0" /* 36051 */
	"SDMA0_STATUS_REG\0" /* 36064 */
	"SDMA1_STATUS_REG\0" /* 36081 */
	"GRBM_STATUS2\0" /* 36098 */
	"GRBM_STATUS\0" /* 36111 */
	"CP_STRMOUT_CNTL\0" /* 36123 */
	"CP_COHER_CNTL\0" /* 36139 */
	"CP_COHER_SIZE\0" /* 36153 */
	"CP_COHER_BASE\0" /* 36167 */
	"GRBM_STATUS_SE0\0" /* 36181 */
	"GRBM_STATUS_SE1\0" /* 36197 */
	"GRBM_STATUS_SE2\0" /* 36213 */
	"GRBM_STATUS_SE3\0" /* 36229 */
	"CP_COHER_BASE_HI\0" /* 36245 */
	"CP_COHER_START_DELAY\0" /* 36262 */
	"CP_COHER_STATUS\0" /* 36283 */
	"CP_CPC_STATUS\0" /* 36299 */
	"CP_CPC_BUSY_STAT\0" /* 36313 */
	"CP_CPC_STALLED_STAT1\0" /* 36330 */
	"CP_CPF_STATUS\0" /* 36351 */
	"CP_CPF_BUSY_STAT\0" /* 36365 */
	"CP_CPF_STALLED_STAT1\0" /* 36382 */
	"CP_COHER_SIZE_HI\0" /* 36403 */
	"VGT_VTX_VECT_EJECT_REG\0" /* 36420 */
	"VGT_CACHE_INVALIDATION\0" /* 36443 */
	"VGT_ESGS_RING_SIZE\0" /* 36466 */
	"VGT_GSVS_RING_SIZE\0" /* 36485 */
	"VGT_GS_VERTEX_REUSE\0" /* 36504 */
	"VGT_PRIMITIVE_TYPE\0" /* 36524 */
	"VGT_INDEX_TYPE\0" /* 36543 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_0\0" /* 36558 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_1\0" /* 36591 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_2\0" /* 36624 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_3\0" /* 36657 */
	"VGT_NUM_INDICES\0" /* 36690 */
	"VGT_NUM_INSTANCES\0" /* 36706 */
	"VGT_TF_RING_SIZE\0" /* 36724 */
	"VGT_HS_OFFCHIP_PARAM\0" /* 36741 */
	"VGT_TF_MEMORY_BASE\0" /* 36762 */
	"PA_CL_ENHANCE\0" /* 36781 */
	"PA_SU_LINE_STIPPLE_VALUE\0" /* 36795 */
	"PA_SC_LINE_STIPPLE_STATE\0" /* 36820 */
	"CP_STALLED_STAT3\0" /* 36845 */
	"CP_STALLED_STAT1\0" /* 36862 */
	"CP_STALLED_STAT2\0" /* 36879 */
	"CP_STAT\0" /* 36896 */
	"GRBM_GFX_INDEX\0" /* 36904 */
	"PA_SC_SCREEN_EXTENT_MIN_0\0" /* 36919 */
	"PA_SC_SCREEN_EXTENT_MAX_0\0" /* 36945 */
	"PA_SC_SCREEN_EXTENT_MIN_1\0" /* 36971 */
	"PA_SC_SCREEN_EXTENT_MAX_1\0" /* 36997 */
	"PA_SC_ENHANCE\0" /* 37023 */
	"SQC_CACHES\0" /* 37037 */
	"SQ_RANDOM_WAVE_PRI\0" /* 37048 */
	"SQ_EXP_0\0" /* 37067 */
	"TA_CS_BC_BASE_ADDR\0" /* 37076 */
	"TA_CS_BC_BASE_ADDR_HI\0" /* 37095 */
	"DB_OCCLUSION_COUNT0_LOW\0" /* 37117 */
	"SQ_BUF_RSRC_WORD0\0" /* 37141 */
	"DB_OCCLUSION_COUNT0_HI\0" /* 37159 */
	"SQ_BUF_RSRC_WORD1\0" /* 37182 */
	"DB_OCCLUSION_COUNT1_LOW\0" /* 37200 */
	"SQ_BUF_RSRC_WORD2\0" /* 37224 */
	"DB_OCCLUSION_COUNT1_HI\0" /* 37242 */
	"SQ_BUF_RSRC_WORD3\0" /* 37265 */
	"DB_OCCLUSION_COUNT2_LOW\0" /* 37283 */
	"SQ_IMG_RSRC_WORD0\0" /* 37307 */
	"DB_OCCLUSION_COUNT2_HI\0" /* 37325 */
	"SQ_IMG_RSRC_WORD1\0" /* 37348 */
	"DB_OCCLUSION_COUNT3_LOW\0" /* 37366 */
	"SQ_IMG_RSRC_WORD2\0" /* 37390 */
	"DB_OCCLUSION_COUNT3_HI\0" /* 37408 */
	"SQ_IMG_RSRC_WORD3\0" /* 37431 */
	"SQ_IMG_RSRC_WORD4\0" /* 37449 */
	"SQ_IMG_RSRC_WORD5\0" /* 37467 */
	"SQ_IMG_RSRC_WORD6\0" /* 37485 */
	"SQ_IMG_RSRC_WORD7\0" /* 37503 */
	"SQ_IMG_SAMP_WORD0\0" /* 37521 */
	"SQ_IMG_SAMP_WORD1\0" /* 37539 */
	"SQ_IMG_SAMP_WORD2\0" /* 37557 */
	"SQ_IMG_SAMP_WORD3\0" /* 37575 */
	"SPI_DYN_GPR_LOCK_EN\0" /* 37593 */
	"SPI_STATIC_THREAD_MGMT_1\0" /* 37613 */
	"SPI_STATIC_THREAD_MGMT_2\0" /* 37638 */
	"SPI_STATIC_THREAD_MGMT_3\0" /* 37663 */
	"SPI_PS_MAX_WAVE_ID\0" /* 37688 */
	"SPI_ARB_PRIORITY\0" /* 37707 */
	"SPI_ARB_CYCLES_0\0" /* 37724 */
	"SPI_ARB_CYCLES_1\0" /* 37741 */
	"SQ_FLAT_SCRATCH_WORD0\0" /* 37758 */
	"SQ_FLAT_SCRATCH_WORD1\0" /* 37780 */
	"DB_ZPASS_COUNT_LOW\0" /* 37802 */
	"DB_ZPASS_COUNT_HI\0" /* 37821 */
	"SPI_CONFIG_CNTL\0" /* 37839 */
	"SPI_CONFIG_CNTL_1\0" /* 37855 */
	"SPI_RESOURCE_RESERVE_CU_AB_0\0" /* 37873 */
	"DB_SUBTILE_CONTROL\0" /* 37902 */
	"GB_ADDR_CONFIG\0" /* 37921 */
	"GB_TILE_MODE0\0" /* 37936 */
	"GB_TILE_MODE1\0" /* 37950 */
	"GB_TILE_MODE2\0" /* 37964 */
	"GB_TILE_MODE3\0" /* 37978 */
	"GB_TILE_MODE4\0" /* 37992 */
	"GB_TILE_MODE5\0" /* 38006 */
	"GB_TILE_MODE6\0" /* 38020 */
	"GB_TILE_MODE7\0" /* 38034 */
	"GB_TILE_MODE8\0" /* 38048 */
	"GB_TILE_MODE9\0" /* 38062 */
	"GB_TILE_MODE10\0" /* 38076 */
	"GB_TILE_MODE11\0" /* 38091 */
	"GB_TILE_MODE12\0" /* 38106 */
	"GB_TILE_MODE13\0" /* 38121 */
	"GB_TILE_MODE14\0" /* 38136 */
	"GB_TILE_MODE15\0" /* 38151 */
	"GB_TILE_MODE16\0" /* 38166 */
	"GB_TILE_MODE17\0" /* 38181 */
	"GB_TILE_MODE18\0" /* 38196 */
	"GB_TILE_MODE19\0" /* 38211 */
	"GB_TILE_MODE20\0" /* 38226 */
	"GB_TILE_MODE21\0" /* 38241 */
	"GB_TILE_MODE22\0" /* 38256 */
	"GB_TILE_MODE23\0" /* 38271 */
	"GB_TILE_MODE24\0" /* 38286 */
	"GB_TILE_MODE25\0" /* 38301 */
	"GB_TILE_MODE26\0" /* 38316 */
	"GB_TILE_MODE27\0" /* 38331 */
	"GB_TILE_MODE28\0" /* 38346 */
	"GB_TILE_MODE29\0" /* 38361 */
	"GB_TILE_MODE30\0" /* 38376 */
	"GB_TILE_MODE31\0" /* 38391 */
	"GB_MACROTILE_MODE0\0" /* 38406 */
	"GB_MACROTILE_MODE1\0" /* 38425 */
	"GB_MACROTILE_MODE2\0" /* 38444 */
	"GB_MACROTILE_MODE3\0" /* 38463 */
	"GB_MACROTILE_MODE4\0" /* 38482 */
	"GB_MACROTILE_MODE5\0" /* 38501 */
	"GB_MACROTILE_MODE6\0" /* 38520 */
	"GB_MACROTILE_MODE7\0" /* 38539 */
	"GB_MACROTILE_MODE8\0" /* 38558 */
	"GB_MACROTILE_MODE9\0" /* 38577 */
	"GB_MACROTILE_MODE10\0" /* 38596 */
	"GB_MACROTILE_MODE11\0" /* 38616 */
	"GB_MACROTILE_MODE12\0" /* 38636 */
	"GB_MACROTILE_MODE13\0" /* 38656 */
	"GB_MACROTILE_MODE14\0" /* 38676 */
	"GB_MACROTILE_MODE15\0" /* 38696 */
	"SPI_SHADER_TBA_LO_PS\0" /* 38716 */
	"SPI_SHADER_TBA_HI_PS\0" /* 38737 */
	"SPI_SHADER_TMA_LO_PS\0" /* 38758 */
	"SPI_SHADER_TMA_HI_PS\0" /* 38779 */
	"SPI_SHADER_PGM_RSRC3_PS\0" /* 38800 */
	"SPI_SHADER_PGM_LO_PS\0" /* 38824 */
	"SPI_SHADER_PGM_HI_PS\0" /* 38845 */
	"SPI_SHADER_PGM_RSRC1_PS\0" /* 38866 */
	"SPI_SHADER_PGM_RSRC2_PS\0" /* 38890 */
	"SPI_SHADER_USER_DATA_PS_0\0" /* 38914 */
	"SPI_SHADER_USER_DATA_PS_1\0" /* 38940 */
	"SPI_SHADER_USER_DATA_PS_2\0" /* 38966 */
	"SPI_SHADER_USER_DATA_PS_3\0" /* 38992 */
	"SPI_SHADER_USER_DATA_PS_4\0" /* 39018 */
	"SPI_SHADER_USER_DATA_PS_5\0" /* 39044 */
	"SPI_SHADER_USER_DATA_PS_6\0" /* 39070 */
	"SPI_SHADER_USER_DATA_PS_7\0" /* 39096 */
	"SPI_SHADER_USER_DATA_PS_8\0" /* 39122 */
	"SPI_SHADER_USER_DATA_PS_9\0" /* 39148 */
	"SPI_SHADER_USER_DATA_PS_10\0" /* 39174 */
	"SPI_SHADER_USER_DATA_PS_11\0" /* 39201 */
	"SPI_SHADER_USER_DATA_PS_12\0" /* 39228 */
	"SPI_SHADER_USER_DATA_PS_13\0" /* 39255 */
	"SPI_SHADER_USER_DATA_PS_14\0" /* 39282 */
	"SPI_SHADER_USER_DATA_PS_15\0" /* 39309 */
	"SPI_SHADER_TBA_LO_VS\0" /* 39336 */
	"SPI_SHADER_TBA_HI_VS\0" /* 39357 */
	"SPI_SHADER_TMA_LO_VS\0" /* 39378 */
	"SPI_SHADER_TMA_HI_VS\0" /* 39399 */
	"SPI_SHADER_PGM_RSRC3_VS\0" /* 39420 */
	"SPI_SHADER_LATE_ALLOC_VS\0" /* 39444 */
	"SPI_SHADER_PGM_LO_VS\0" /* 39469 */
	"SPI_SHADER_PGM_HI_VS\0" /* 39490 */
	"SPI_SHADER_PGM_RSRC1_VS\0" /* 39511 */
	"SPI_SHADER_PGM_RSRC2_VS\0" /* 39535 */
	"SPI_SHADER_USER_DATA_VS_0\0" /* 39559 */
	"SPI_SHADER_USER_DATA_VS_1\0" /* 39585 */
	"SPI_SHADER_USER_DATA_VS_2\0" /* 39611 */
	"SPI_SHADER_USER_DATA_VS_3\0" /* 39637 */
	"SPI_SHADER_USER_DATA_VS_4\0" /* 39663 */
	"SPI_SHADER_USER_DATA_VS_5\0" /* 39689 */
	"SPI_SHADER_USER_DATA_VS_6\0" /* 39715 */
	"SPI_SHADER_USER_DATA_VS_7\0" /* 39741 */
	"SPI_SHADER_USER_DATA_VS_8\0" /* 39767 */
	"SPI_SHADER_USER_DATA_VS_9\0" /* 39793 */
	"SPI_SHADER_USER_DATA_VS_10\0" /* 39819 */
	"SPI_SHADER_USER_DATA_VS_11\0" /* 39846 */
	"SPI_SHADER_USER_DATA_VS_12\0" /* 39873 */
	"SPI_SHADER_USER_DATA_VS_13\0" /* 39900 */
	"SPI_SHADER_USER_DATA_VS_14\0" /* 39927 */
	"SPI_SHADER_USER_DATA_VS_15\0" /* 39954 */
	"SPI_SHADER_TBA_LO_GS\0" /* 39981 */
	"SPI_SHADER_TBA_HI_GS\0" /* 40002 */
	"SPI_SHADER_TMA_LO_GS\0" /* 40023 */
	"SPI_SHADER_TMA_HI_GS\0" /* 40044 */
	"SPI_SHADER_PGM_RSRC3_GS\0" /* 40065 */
	"SPI_SHADER_PGM_LO_GS\0" /* 40089 */
	"SPI_SHADER_PGM_HI_GS\0" /* 40110 */
	"SPI_SHADER_PGM_RSRC1_GS\0" /* 40131 */
	"SPI_SHADER_PGM_RSRC2_GS\0" /* 40155 */
	"SPI_SHADER_USER_DATA_GS_0\0" /* 40179 */
	"SPI_SHADER_USER_DATA_GS_1\0" /* 40205 */
	"SPI_SHADER_USER_DATA_GS_2\0" /* 40231 */
	"SPI_SHADER_USER_DATA_GS_3\0" /* 40257 */
	"SPI_SHADER_USER_DATA_GS_4\0" /* 40283 */
	"SPI_SHADER_USER_DATA_GS_5\0" /* 40309 */
	"SPI_SHADER_USER_DATA_GS_6\0" /* 40335 */
	"SPI_SHADER_USER_DATA_GS_7\0" /* 40361 */
	"SPI_SHADER_USER_DATA_GS_8\0" /* 40387 */
	"SPI_SHADER_USER_DATA_GS_9\0" /* 40413 */
	"SPI_SHADER_USER_DATA_GS_10\0" /* 40439 */
	"SPI_SHADER_USER_DATA_GS_11\0" /* 40466 */
	"SPI_SHADER_USER_DATA_GS_12\0" /* 40493 */
	"SPI_SHADER_USER_DATA_GS_13\0" /* 40520 */
	"SPI_SHADER_USER_DATA_GS_14\0" /* 40547 */
	"SPI_SHADER_USER_DATA_GS_15\0" /* 40574 */
	"SPI_SHADER_TBA_LO_ES\0" /* 40601 */
	"SPI_SHADER_TBA_HI_ES\0" /* 40622 */
	"SPI_SHADER_TMA_LO_ES\0" /* 40643 */
	"SPI_SHADER_TMA_HI_ES\0" /* 40664 */
	"SPI_SHADER_PGM_RSRC3_ES\0" /* 40685 */
	"SPI_SHADER_PGM_LO_ES\0" /* 40709 */
	"SPI_SHADER_PGM_HI_ES\0" /* 40730 */
	"SPI_SHADER_PGM_RSRC1_ES\0" /* 40751 */
	"SPI_SHADER_PGM_RSRC2_ES\0" /* 40775 */
	"SPI_SHADER_USER_DATA_ES_0\0" /* 40799 */
	"SPI_SHADER_USER_DATA_ES_1\0" /* 40825 */
	"SPI_SHADER_USER_DATA_ES_2\0" /* 40851 */
	"SPI_SHADER_USER_DATA_ES_3\0" /* 40877 */
	"SPI_SHADER_USER_DATA_ES_4\0" /* 40903 */
	"SPI_SHADER_USER_DATA_ES_5\0" /* 40929 */
	"SPI_SHADER_USER_DATA_ES_6\0" /* 40955 */
	"SPI_SHADER_USER_DATA_ES_7\0" /* 40981 */
	"SPI_SHADER_USER_DATA_ES_8\0" /* 41007 */
	"SPI_SHADER_USER_DATA_ES_9\0" /* 41033 */
	"SPI_SHADER_USER_DATA_ES_10\0" /* 41059 */
	"SPI_SHADER_USER_DATA_ES_11\0" /* 41086 */
	"SPI_SHADER_USER_DATA_ES_12\0" /* 41113 */
	"SPI_SHADER_USER_DATA_ES_13\0" /* 41140 */
	"SPI_SHADER_USER_DATA_ES_14\0" /* 41167 */
	"SPI_SHADER_USER_DATA_ES_15\0" /* 41194 */
	"SPI_SHADER_TBA_LO_HS\0" /* 41221 */
	"SPI_SHADER_TBA_HI_HS\0" /* 41242 */
	"SPI_SHADER_TMA_LO_HS\0" /* 41263 */
	"SPI_SHADER_TMA_HI_HS\0" /* 41284 */
	"SPI_SHADER_PGM_RSRC3_HS\0" /* 41305 */
	"SPI_SHADER_PGM_LO_HS\0" /* 41329 */
	"SPI_SHADER_PGM_HI_HS\0" /* 41350 */
	"SPI_SHADER_PGM_RSRC1_HS\0" /* 41371 */
	"SPI_SHADER_PGM_RSRC2_HS\0" /* 41395 */
	"SPI_SHADER_USER_DATA_HS_0\0" /* 41419 */
	"SPI_SHADER_USER_DATA_HS_1\0" /* 41445 */
	"SPI_SHADER_USER_DATA_HS_2\0" /* 41471 */
	"SPI_SHADER_USER_DATA_HS_3\0" /* 41497 */
	"SPI_SHADER_USER_DATA_HS_4\0" /* 41523 */
	"SPI_SHADER_USER_DATA_HS_5\0" /* 41549 */
	"SPI_SHADER_USER_DATA_HS_6\0" /* 41575 */
	"SPI_SHADER_USER_DATA_HS_7\0" /* 41601 */
	"SPI_SHADER_USER_DATA_HS_8\0" /* 41627 */
	"SPI_SHADER_USER_DATA_HS_9\0" /* 41653 */
	"SPI_SHADER_USER_DATA_HS_10\0" /* 41679 */
	"SPI_SHADER_USER_DATA_HS_11\0" /* 41706 */
	"SPI_SHADER_USER_DATA_HS_12\0" /* 41733 */
	"SPI_SHADER_USER_DATA_HS_13\0" /* 41760 */
	"SPI_SHADER_USER_DATA_HS_14\0" /* 41787 */
	"SPI_SHADER_USER_DATA_HS_15\0" /* 41814 */
	"SPI_SHADER_TBA_LO_LS\0" /* 41841 */
	"SPI_SHADER_TBA_HI_LS\0" /* 41862 */
	"SPI_SHADER_TMA_LO_LS\0" /* 41883 */
	"SPI_SHADER_TMA_HI_LS\0" /* 41904 */
	"SPI_SHADER_PGM_RSRC3_LS\0" /* 41925 */
	"SPI_SHADER_PGM_LO_LS\0" /* 41949 */
	"SPI_SHADER_PGM_HI_LS\0" /* 41970 */
	"SPI_SHADER_PGM_RSRC1_LS\0" /* 41991 */
	"SPI_SHADER_PGM_RSRC2_LS\0" /* 42015 */
	"SPI_SHADER_USER_DATA_LS_0\0" /* 42039 */
	"SPI_SHADER_USER_DATA_LS_1\0" /* 42065 */
	"SPI_SHADER_USER_DATA_LS_2\0" /* 42091 */
	"SPI_SHADER_USER_DATA_LS_3\0" /* 42117 */
	"SPI_SHADER_USER_DATA_LS_4\0" /* 42143 */
	"SPI_SHADER_USER_DATA_LS_5\0" /* 42169 */
	"SPI_SHADER_USER_DATA_LS_6\0" /* 42195 */
	"SPI_SHADER_USER_DATA_LS_7\0" /* 42221 */
	"SPI_SHADER_USER_DATA_LS_8\0" /* 42247 */
	"SPI_SHADER_USER_DATA_LS_9\0" /* 42273 */
	"SPI_SHADER_USER_DATA_LS_10\0" /* 42299 */
	"SPI_SHADER_USER_DATA_LS_11\0" /* 42326 */
	"SPI_SHADER_USER_DATA_LS_12\0" /* 42353 */
	"SPI_SHADER_USER_DATA_LS_13\0" /* 42380 */
	"SPI_SHADER_USER_DATA_LS_14\0" /* 42407 */
	"SPI_SHADER_USER_DATA_LS_15\0" /* 42434 */
	"COMPUTE_DISPATCH_INITIATOR\0" /* 42461 */
	"COMPUTE_DIM_X\0" /* 42488 */
	"COMPUTE_DIM_Y\0" /* 42502 */
	"COMPUTE_DIM_Z\0" /* 42516 */
	"COMPUTE_START_X\0" /* 42530 */
	"COMPUTE_START_Y\0" /* 42546 */
	"COMPUTE_START_Z\0" /* 42562 */
	"COMPUTE_NUM_THREAD_X\0" /* 42578 */
	"COMPUTE_NUM_THREAD_Y\0" /* 42599 */
	"COMPUTE_NUM_THREAD_Z\0" /* 42620 */
	"COMPUTE_MAX_WAVE_ID\0" /* 42641 */
	"COMPUTE_PIPELINESTAT_ENABLE\0" /* 42661 */
	"COMPUTE_PERFCOUNT_ENABLE\0" /* 42689 */
	"COMPUTE_PGM_LO\0" /* 42714 */
	"COMPUTE_PGM_HI\0" /* 42729 */
	"COMPUTE_TBA_LO\0" /* 42744 */
	"COMPUTE_TBA_HI\0" /* 42759 */
	"COMPUTE_TMA_LO\0" /* 42774 */
	"COMPUTE_TMA_HI\0" /* 42789 */
	"COMPUTE_PGM_RSRC1\0" /* 42804 */
	"COMPUTE_PGM_RSRC2\0" /* 42822 */
	"COMPUTE_VMID\0" /* 42840 */
	"COMPUTE_RESOURCE_LIMITS\0" /* 42853 */
	"COMPUTE_STATIC_THREAD_MGMT_SE0\0" /* 42877 */
	"COMPUTE_STATIC_THREAD_MGMT_SE1\0" /* 42908 */
	"COMPUTE_TMPRING_SIZE\0" /* 42939 */
	"COMPUTE_STATIC_THREAD_MGMT_SE2\0" /* 42960 */
	"COMPUTE_STATIC_THREAD_MGMT_SE3\0" /* 42991 */
	"COMPUTE_RESTART_X\0" /* 43022 */
	"COMPUTE_RESTART_Y\0" /* 43040 */
	"COMPUTE_RESTART_Z\0" /* 43058 */
	"COMPUTE_MISC_RESERVED\0" /* 43076 */
	"COMPUTE_DISPATCH_ID\0" /* 43098 */
	"COMPUTE_THREADGROUP_ID\0" /* 43118 */
	"COMPUTE_RELAUNCH\0" /* 43141 */
	"COMPUTE_WAVE_RESTORE_ADDR_LO\0" /* 43158 */
	"COMPUTE_WAVE_RESTORE_ADDR_HI\0" /* 43187 */
	"COMPUTE_WAVE_RESTORE_CONTROL\0" /* 43216 */
	"COMPUTE_USER_DATA_0\0" /* 43245 */
	"COMPUTE_USER_DATA_1\0" /* 43265 */
	"COMPUTE_USER_DATA_2\0" /* 43285 */
	"COMPUTE_USER_DATA_3\0" /* 43305 */
	"COMPUTE_USER_DATA_4\0" /* 43325 */
	"COMPUTE_USER_DATA_5\0" /* 43345 */
	"COMPUTE_USER_DATA_6\0" /* 43365 */
	"COMPUTE_USER_DATA_7\0" /* 43385 */
	"COMPUTE_USER_DATA_8\0" /* 43405 */
	"COMPUTE_USER_DATA_9\0" /* 43425 */
	"COMPUTE_USER_DATA_10\0" /* 43445 */
	"COMPUTE_USER_DATA_11\0" /* 43466 */
	"COMPUTE_USER_DATA_12\0" /* 43487 */
	"COMPUTE_USER_DATA_13\0" /* 43508 */
	"COMPUTE_USER_DATA_14\0" /* 43529 */
	"COMPUTE_USER_DATA_15\0" /* 43550 */
	"COMPUTE_NOWHERE\0" /* 43571 */
	"CPG_PERFCOUNTER1_LO\0" /* 43587 */
	"CPG_PERFCOUNTER1_HI\0" /* 43607 */
	"CPG_PERFCOUNTER0_LO\0" /* 43627 */
	"CPG_PERFCOUNTER0_HI\0" /* 43647 */
	"CPC_PERFCOUNTER1_LO\0" /* 43667 */
	"CPC_PERFCOUNTER1_HI\0" /* 43687 */
	"CPC_PERFCOUNTER0_LO\0" /* 43707 */
	"CPC_PERFCOUNTER0_HI\0" /* 43727 */
	"CPF_PERFCOUNTER1_LO\0" /* 43747 */
	"CPF_PERFCOUNTER1_HI\0" /* 43767 */
	"CPF_PERFCOUNTER0_LO\0" /* 43787 */
	"CPF_PERFCOUNTER0_HI\0" /* 43807 */
	"GRBM_PERFCOUNTER0_LO\0" /* 43827 */
	"GRBM_PERFCOUNTER0_HI\0" /* 43848 */
	"GRBM_PERFCOUNTER1_LO\0" /* 43869 */
	"GRBM_PERFCOUNTER1_HI\0" /* 43890 */
	"GRBM_SE0_PERFCOUNTER_LO\0" /* 43911 */
	"GRBM_SE0_PERFCOUNTER_HI\0" /* 43935 */
	"GRBM_SE1_PERFCOUNTER_LO\0" /* 43959 */
	"GRBM_SE1_PERFCOUNTER_HI\0" /* 43983 */
	"GRBM_SE2_PERFCOUNTER_LO\0" /* 44007 */
	"GRBM_SE2_PERFCOUNTER_HI\0" /* 44031 */
	"GRBM_SE3_PERFCOUNTER_LO\0" /* 44055 */
	"GRBM_SE3_PERFCOUNTER_HI\0" /* 44079 */
	"WD_PERFCOUNTER0_LO\0" /* 44103 */
	"WD_PERFCOUNTER0_HI\0" /* 44122 */
	"WD_PERFCOUNTER1_LO\0" /* 44141 */
	"WD_PERFCOUNTER1_HI\0" /* 44160 */
	"WD_PERFCOUNTER2_LO\0" /* 44179 */
	"WD_PERFCOUNTER2_HI\0" /* 44198 */
	"WD_PERFCOUNTER3_LO\0" /* 44217 */
	"WD_PERFCOUNTER3_HI\0" /* 44236 */
	"IA_PERFCOUNTER0_LO\0" /* 44255 */
	"IA_PERFCOUNTER0_HI\0" /* 44274 */
	"IA_PERFCOUNTER1_LO\0" /* 44293 */
	"IA_PERFCOUNTER1_HI\0" /* 44312 */
	"IA_PERFCOUNTER2_LO\0" /* 44331 */
	"IA_PERFCOUNTER2_HI\0" /* 44350 */
	"IA_PERFCOUNTER3_LO\0" /* 44369 */
	"IA_PERFCOUNTER3_HI\0" /* 44388 */
	"VGT_PERFCOUNTER0_LO\0" /* 44407 */
	"VGT_PERFCOUNTER0_HI\0" /* 44427 */
	"VGT_PERFCOUNTER1_LO\0" /* 44447 */
	"VGT_PERFCOUNTER1_HI\0" /* 44467 */
	"VGT_PERFCOUNTER2_LO\0" /* 44487 */
	"VGT_PERFCOUNTER2_HI\0" /* 44507 */
	"VGT_PERFCOUNTER3_LO\0" /* 44527 */
	"VGT_PERFCOUNTER3_HI\0" /* 44547 */
	"PA_SU_PERFCOUNTER0_LO\0" /* 44567 */
	"PA_SU_PERFCOUNTER0_HI\0" /* 44589 */
	"PA_SU_PERFCOUNTER1_LO\0" /* 44611 */
	"PA_SU_PERFCOUNTER1_HI\0" /* 44633 */
	"PA_SU_PERFCOUNTER2_LO\0" /* 44655 */
	"PA_SU_PERFCOUNTER2_HI\0" /* 44677 */
	"PA_SU_PERFCOUNTER3_LO\0" /* 44699 */
	"PA_SU_PERFCOUNTER3_HI\0" /* 44721 */
	"PA_SC_PERFCOUNTER0_LO\0" /* 44743 */
	"PA_SC_PERFCOUNTER0_HI\0" /* 44765 */
	"PA_SC_PERFCOUNTER1_LO\0" /* 44787 */
	"PA_SC_PERFCOUNTER1_HI\0" /* 44809 */
	"PA_SC_PERFCOUNTER2_LO\0" /* 44831 */
	"PA_SC_PERFCOUNTER2_HI\0" /* 44853 */
	"PA_SC_PERFCOUNTER3_LO\0" /* 44875 */
	"PA_SC_PERFCOUNTER3_HI\0" /* 44897 */
	"PA_SC_PERFCOUNTER4_LO\0" /* 44919 */
	"PA_SC_PERFCOUNTER4_HI\0" /* 44941 */
	"PA_SC_PERFCOUNTER5_LO\0" /* 44963 */
	"PA_SC_PERFCOUNTER5_HI\0" /* 44985 */
	"PA_SC_PERFCOUNTER6_LO\0" /* 45007 */
	"PA_SC_PERFCOUNTER6_HI\0" /* 45029 */
	"PA_SC_PERFCOUNTER7_LO\0" /* 45051 */
	"PA_SC_PERFCOUNTER7_HI\0" /* 45073 */
	"SPI_PERFCOUNTER0_HI\0" /* 45095 */
	"SPI_PERFCOUNTER0_LO\0" /* 45115 */
	"SPI_PERFCOUNTER1_HI\0" /* 45135 */
	"SPI_PERFCOUNTER1_LO\0" /* 45155 */
	"SPI_PERFCOUNTER2_HI\0" /* 45175 */
	"SPI_PERFCOUNTER2_LO\0" /* 45195 */
	"SPI_PERFCOUNTER3_HI\0" /* 45215 */
	"SPI_PERFCOUNTER3_LO\0" /* 45235 */
	"SPI_PERFCOUNTER4_HI\0" /* 45255 */
	"SPI_PERFCOUNTER4_LO\0" /* 45275 */
	"SPI_PERFCOUNTER5_HI\0" /* 45295 */
	"SPI_PERFCOUNTER5_LO\0" /* 45315 */
	"SQ_PERFCOUNTER0_LO\0" /* 45335 */
	"SQ_PERFCOUNTER0_HI\0" /* 45354 */
	"SQ_PERFCOUNTER1_LO\0" /* 45373 */
	"SQ_PERFCOUNTER1_HI\0" /* 45392 */
	"SQ_PERFCOUNTER2_LO\0" /* 45411 */
	"SQ_PERFCOUNTER2_HI\0" /* 45430 */
	"SQ_PERFCOUNTER3_LO\0" /* 45449 */
	"SQ_PERFCOUNTER3_HI\0" /* 45468 */
	"SQ_PERFCOUNTER4_LO\0" /* 45487 */
	"SQ_PERFCOUNTER4_HI\0" /* 45506 */
	"SQ_PERFCOUNTER5_LO\0" /* 45525 */
	"SQ_PERFCOUNTER5_HI\0" /* 45544 */
	"SQ_PERFCOUNTER6_LO\0" /* 45563 */
	"SQ_PERFCOUNTER6_HI\0" /* 45582 */
	"SQ_PERFCOUNTER7_LO\0" /* 45601 */
	"SQ_PERFCOUNTER7_HI\0" /* 45620 */
	"SQ_PERFCOUNTER8_LO\0" /* 45639 */
	"SQ_PERFCOUNTER8_HI\0" /* 45658 */
	"SQ_PERFCOUNTER9_LO\0" /* 45677 */
	"SQ_PERFCOUNTER9_HI\0" /* 45696 */
	"SQ_PERFCOUNTER10_LO\0" /* 45715 */
	"SQ_PERFCOUNTER10_HI\0" /* 45735 */
	"SQ_PERFCOUNTER11_LO\0" /* 45755 */
	"SQ_PERFCOUNTER11_HI\0" /* 45775 */
	"SQ_PERFCOUNTER12_LO\0" /* 45795 */
	"SQ_PERFCOUNTER12_HI\0" /* 45815 */
	"SQ_PERFCOUNTER13_LO\0" /* 45835 */
	"SQ_PERFCOUNTER13_HI\0" /* 45855 */
	"SQ_PERFCOUNTER14_LO\0" /* 45875 */
	"SQ_PERFCOUNTER14_HI\0" /* 45895 */
	"SQ_PERFCOUNTER15_LO\0" /* 45915 */
	"SQ_PERFCOUNTER15_HI\0" /* 45935 */
	"SX_PERFCOUNTER0_LO\0" /* 45955 */
	"SX_PERFCOUNTER0_HI\0" /* 45974 */
	"SX_PERFCOUNTER1_LO\0" /* 45993 */
	"SX_PERFCOUNTER1_HI\0" /* 46012 */
	"SX_PERFCOUNTER2_LO\0" /* 46031 */
	"SX_PERFCOUNTER2_HI\0" /* 46050 */
	"SX_PERFCOUNTER3_LO\0" /* 46069 */
	"SX_PERFCOUNTER3_HI\0" /* 46088 */
	"GDS_PERFCOUNTER0_LO\0" /* 46107 */
	"GDS_PERFCOUNTER0_HI\0" /* 46127 */
	"GDS_PERFCOUNTER1_LO\0" /* 46147 */
	"GDS_PERFCOUNTER1_HI\0" /* 46167 */
	"GDS_PERFCOUNTER2_LO\0" /* 46187 */
	"GDS_PERFCOUNTER2_HI\0" /* 46207 */
	"GDS_PERFCOUNTER3_LO\0" /* 46227 */
	"GDS_PERFCOUNTER3_HI\0" /* 46247 */
	"TA_PERFCOUNTER0_LO\0" /* 46267 */
	"TA_PERFCOUNTER0_HI\0" /* 46286 */
	"TA_PERFCOUNTER1_LO\0" /* 46305 */
	"TA_PERFCOUNTER1_HI\0" /* 46324 */
	"TD_PERFCOUNTER0_LO\0" /* 46343 */
	"TD_PERFCOUNTER0_HI\0" /* 46362 */
	"TD_PERFCOUNTER1_LO\0" /* 46381 */
	"TD_PERFCOUNTER1_HI\0" /* 46400 */
	"TCP_PERFCOUNTER0_LO\0" /* 46419 */
	"TCP_PERFCOUNTER0_HI\0" /* 46439 */
	"TCP_PERFCOUNTER1_LO\0" /* 46459 */
	"TCP_PERFCOUNTER1_HI\0" /* 46479 */
	"TCP_PERFCOUNTER2_LO\0" /* 46499 */
	"TCP_PERFCOUNTER2_HI\0" /* 46519 */
	"TCP_PERFCOUNTER3_LO\0" /* 46539 */
	"TCP_PERFCOUNTER3_HI\0" /* 46559 */
	"TCC_PERFCOUNTER0_LO\0" /* 46579 */
	"TCC_PERFCOUNTER0_HI\0" /* 46599 */
	"TCC_PERFCOUNTER1_LO\0" /* 46619 */
	"TCC_PERFCOUNTER1_HI\0" /* 46639 */
	"TCC_PERFCOUNTER2_LO\0" /* 46659 */
	"TCC_PERFCOUNTER2_HI\0" /* 46679 */
	"TCC_PERFCOUNTER3_LO\0" /* 46699 */
	"TCC_PERFCOUNTER3_HI\0" /* 46719 */
	"TCA_PERFCOUNTER0_LO\0" /* 46739 */
	"TCA_PERFCOUNTER0_HI\0" /* 46759 */
	"TCA_PERFCOUNTER1_LO\0" /* 46779 */
	"TCA_PERFCOUNTER1_HI\0" /* 46799 */
	"TCA_PERFCOUNTER2_LO\0" /* 46819 */
	"TCA_PERFCOUNTER2_HI\0" /* 46839 */
	"TCA_PERFCOUNTER3_LO\0" /* 46859 */
	"TCA_PERFCOUNTER3_HI\0" /* 46879 */
	"CB_PERFCOUNTER0_LO\0" /* 46899 */
	"CB_PERFCOUNTER0_HI\0" /* 46918 */
	"CB_PERFCOUNTER1_LO\0" /* 46937 */
	"CB_PERFCOUNTER1_HI\0" /* 46956 */
	"CB_PERFCOUNTER2_LO\0" /* 46975 */
	"CB_PERFCOUNTER2_HI\0" /* 46994 */
	"CB_PERFCOUNTER3_LO\0" /* 47013 */
	"CB_PERFCOUNTER3_HI\0" /* 47032 */
	"DB_PERFCOUNTER0_LO\0" /* 47051 */
	"DB_PERFCOUNTER0_HI\0" /* 47070 */
	"DB_PERFCOUNTER1_LO\0" /* 47089 */
	"DB_PERFCOUNTER1_HI\0" /* 47108 */
	"DB_PERFCOUNTER2_LO\0" /* 47127 */
	"DB_PERFCOUNTER2_HI\0" /* 47146 */
	"DB_PERFCOUNTER3_LO\0" /* 47165 */
	"DB_PERFCOUNTER3_HI\0" /* 47184 */
	"RLC_PERFCOUNTER0_LO\0" /* 47203 */
	"RLC_PERFCOUNTER0_HI\0" /* 47223 */
	"RLC_PERFCOUNTER1_LO\0" /* 47243 */
	"RLC_PERFCOUNTER1_HI\0" /* 47263 */
	"CPG_PERFCOUNTER1_SELECT\0" /* 47283 */
	"CPG_PERFCOUNTER0_SELECT1\0" /* 47307 */
	"CPG_PERFCOUNTER0_SELECT\0" /* 47332 */
	"CPC_PERFCOUNTER1_SELECT\0" /* 47356 */
	"CPC_PERFCOUNTER0_SELECT1\0" /* 47380 */
	"CPF_PERFCOUNTER1_SELECT\0" /* 47405 */
	"CPF_PERFCOUNTER0_SELECT1\0" /* 47429 */
	"CPF_PERFCOUNTER0_SELECT\0" /* 47454 */
	"CP_PERFMON_CNTL\0" /* 47478 */
	"CPC_PERFCOUNTER0_SELECT\0" /* 47494 */
	"GRBM_PERFCOUNTER0_SELECT\0" /* 47518 */
	"GRBM_PERFCOUNTER1_SELECT\0" /* 47543 */
	"GRBM_SE0_PERFCOUNTER_SELECT\0" /* 47568 */
	"GRBM_SE1_PERFCOUNTER_SELECT\0" /* 47596 */
	"GRBM_SE2_PERFCOUNTER_SELECT\0" /* 47624 */
	"GRBM_SE3_PERFCOUNTER_SELECT\0" /* 47652 */
	"WD_PERFCOUNTER0_SELECT\0" /* 47680 */
	"WD_PERFCOUNTER1_SELECT\0" /* 47703 */
	"WD_PERFCOUNTER2_SELECT\0" /* 47726 */
	"WD_PERFCOUNTER3_SELECT\0" /* 47749 */
	"IA_PERFCOUNTER0_SELECT\0" /* 47772 */
	"IA_PERFCOUNTER1_SELECT\0" /* 47795 */
	"IA_PERFCOUNTER2_SELECT\0" /* 47818 */
	"IA_PERFCOUNTER3_SELECT\0" /* 47841 */
	"IA_PERFCOUNTER0_SELECT1\0" /* 47864 */
	"VGT_PERFCOUNTER0_SELECT\0" /* 47888 */
	"VGT_PERFCOUNTER1_SELECT\0" /* 47912 */
	"VGT_PERFCOUNTER2_SELECT\0" /* 47936 */
	"VGT_PERFCOUNTER3_SELECT\0" /* 47960 */
	"VGT_PERFCOUNTER0_SELECT1\0" /* 47984 */
	"VGT_PERFCOUNTER1_SELECT1\0" /* 48009 */
	"VGT_PERFCOUNTER_SEID_MASK\0" /* 48034 */
	"PA_SU_PERFCOUNTER0_SELECT\0" /* 48060 */
	"PA_SU_PERFCOUNTER0_SELECT1\0" /* 48086 */
	"PA_SU_PERFCOUNTER1_SELECT\0" /* 48113 */
	"PA_SU_PERFCOUNTER1_SELECT1\0" /* 48139 */
	"PA_SU_PERFCOUNTER2_SELECT\0" /* 48166 */
	"PA_SU_PERFCOUNTER3_SELECT\0" /* 48192 */
	"PA_SC_PERFCOUNTER0_SELECT\0" /* 48218 */
	"PA_SC_PERFCOUNTER0_SELECT1\0" /* 48244 */
	"PA_SC_PERFCOUNTER1_SELECT\0" /* 48271 */
	"PA_SC_PERFCOUNTER2_SELECT\0" /* 48297 */
	"PA_SC_PERFCOUNTER3_SELECT\0" /* 48323 */
	"PA_SC_PERFCOUNTER4_SELECT\0" /* 48349 */
	"PA_SC_PERFCOUNTER5_SELECT\0" /* 48375 */
	"PA_SC_PERFCOUNTER6_SELECT\0" /* 48401 */
	"PA_SC_PERFCOUNTER7_SELECT\0" /* 48427 */
	"SPI_PERFCOUNTER0_SELECT\0" /* 48453 */
	"SPI_PERFCOUNTER1_SELECT\0" /* 48477 */
	"SPI_PERFCOUNTER2_SELECT\0" /* 48501 */
	"SPI_PERFCOUNTER3_SELECT\0" /* 48525 */
	"SPI_PERFCOUNTER0_SELECT1\0" /* 48549 */
	"SPI_PERFCOUNTER1_SELECT1\0" /* 48574 */
	"SPI_PERFCOUNTER2_SELECT1\0" /* 48599 */
	"SPI_PERFCOUNTER3_SELECT1\0" /* 48624 */
	"SPI_PERFCOUNTER4_SELECT\0" /* 48649 */
	"SPI_PERFCOUNTER5_SELECT\0" /* 48673 */
	"SPI_PERFCOUNTER_BINS\0" /* 48697 */
	"SQ_PERFCOUNTER0_SELECT\0" /* 48718 */
	"SQ_PERFCOUNTER1_SELECT\0" /* 48741 */
	"SQ_PERFCOUNTER2_SELECT\0" /* 48764 */
	"SQ_PERFCOUNTER3_SELECT\0" /* 48787 */
	"SQ_PERFCOUNTER4_SELECT\0" /* 48810 */
	"SQ_PERFCOUNTER5_SELECT\0" /* 48833 */
	"SQ_PERFCOUNTER6_SELECT\0" /* 48856 */
	"SQ_PERFCOUNTER7_SELECT\0" /* 48879 */
	"SQ_PERFCOUNTER8_SELECT\0" /* 48902 */
	"SQ_PERFCOUNTER9_SELECT\0" /* 48925 */
	"SQ_PERFCOUNTER10_SELECT\0" /* 48948 */
	"SQ_PERFCOUNTER11_SELECT\0" /* 48972 */
	"SQ_PERFCOUNTER12_SELECT\0" /* 48996 */
	"SQ_PERFCOUNTER13_SELECT\0" /* 49020 */
	"SQ_PERFCOUNTER14_SELECT\0" /* 49044 */
	"SQ_PERFCOUNTER15_SELECT\0" /* 49068 */
	"SQ_PERFCOUNTER_CTRL\0" /* 49092 */
	"SQ_PERFCOUNTER_MASK\0" /* 49112 */
	"SQ_PERFCOUNTER_CTRL2\0" /* 49132 */
	"SX_PERFCOUNTER0_SELECT\0" /* 49153 */
	"SX_PERFCOUNTER1_SELECT\0" /* 49176 */
	"SX_PERFCOUNTER2_SELECT\0" /* 49199 */
	"SX_PERFCOUNTER3_SELECT\0" /* 49222 */
	"SX_PERFCOUNTER0_SELECT1\0" /* 49245 */
	"SX_PERFCOUNTER1_SELECT1\0" /* 49269 */
	"GDS_PERFCOUNTER0_SELECT\0" /* 49293 */
	"GDS_PERFCOUNTER1_SELECT\0" /* 49317 */
	"GDS_PERFCOUNTER2_SELECT\0" /* 49341 */
	"GDS_PERFCOUNTER3_SELECT\0" /* 49365 */
	"GDS_PERFCOUNTER0_SELECT1\0" /* 49389 */
	"TA_PERFCOUNTER0_SELECT\0" /* 49414 */
	"TA_PERFCOUNTER0_SELECT1\0" /* 49437 */
	"TA_PERFCOUNTER1_SELECT\0" /* 49461 */
	"TD_PERFCOUNTER0_SELECT\0" /* 49484 */
	"TD_PERFCOUNTER0_SELECT1\0" /* 49507 */
	"TD_PERFCOUNTER1_SELECT\0" /* 49531 */
	"TCP_PERFCOUNTER0_SELECT\0" /* 49554 */
	"TCP_PERFCOUNTER0_SELECT1\0" /* 49578 */
	"TCP_PERFCOUNTER1_SELECT\0" /* 49603 */
	"TCP_PERFCOUNTER1_SELECT1\0" /* 49627 */
	"TCP_PERFCOUNTER2_SELECT\0" /* 49652 */
	"TCP_PERFCOUNTER3_SELECT\0" /* 49676 */
	"TCC_PERFCOUNTER0_SELECT\0" /* 49700 */
	"TCC_PERFCOUNTER0_SELECT1\0" /* 49724 */
	"TCC_PERFCOUNTER1_SELECT\0" /* 49749 */
	"TCC_PERFCOUNTER1_SELECT1\0" /* 49773 */
	"TCC_PERFCOUNTER2_SELECT\0" /* 49798 */
	"TCC_PERFCOUNTER3_SELECT\0" /* 49822 */
	"TCA_PERFCOUNTER0_SELECT\0" /* 49846 */
	"TCA_PERFCOUNTER0_SELECT1\0" /* 49870 */
	"TCA_PERFCOUNTER1_SELECT\0" /* 49895 */
	"TCA_PERFCOUNTER1_SELECT1\0" /* 49919 */
	"TCA_PERFCOUNTER2_SELECT\0" /* 49944 */
	"TCA_PERFCOUNTER3_SELECT\0" /* 49968 */
	"CB_PERFCOUNTER_FILTER\0" /* 49992 */
	"CB_PERFCOUNTER0_SELECT\0" /* 50014 */
	"CB_PERFCOUNTER0_SELECT1\0" /* 50037 */
	"CB_PERFCOUNTER1_SELECT\0" /* 50061 */
	"CB_PERFCOUNTER2_SELECT\0" /* 50084 */
	"CB_PERFCOUNTER3_SELECT\0" /* 50107 */
	"DB_PERFCOUNTER0_SELECT\0" /* 50130 */
	"DB_PERFCOUNTER0_SELECT1\0" /* 50153 */
	"DB_PERFCOUNTER1_SELECT\0" /* 50177 */
	"DB_PERFCOUNTER1_SELECT1\0" /* 50200 */
	"DB_PERFCOUNTER2_SELECT\0" /* 50224 */
	"DB_PERFCOUNTER3_SELECT\0" /* 50247 */
	"DB_RENDER_CONTROL\0" /* 50270 */
	"DB_COUNT_CONTROL\0" /* 50288 */
	"DB_DEPTH_VIEW\0" /* 50305 */
	"DB_RENDER_OVERRIDE\0" /* 50319 */
	"DB_RENDER_OVERRIDE2\0" /* 50338 */
	"DB_HTILE_DATA_BASE\0" /* 50358 */
	"DB_DEPTH_BOUNDS_MIN\0" /* 50377 */
	"DB_DEPTH_BOUNDS_MAX\0" /* 50397 */
	"DB_STENCIL_CLEAR\0" /* 50417 */
	"DB_DEPTH_CLEAR\0" /* 50434 */
	"PA_SC_SCREEN_SCISSOR_TL\0" /* 50449 */
	"PA_SC_SCREEN_SCISSOR_BR\0" /* 50473 */
	"DB_DEPTH_INFO\0" /* 50497 */
	"DB_Z_INFO\0" /* 50511 */
	"DB_STENCIL_INFO\0" /* 50521 */
	"DB_Z_READ_BASE\0" /* 50537 */
	"DB_STENCIL_READ_BASE\0" /* 50552 */
	"DB_Z_WRITE_BASE\0" /* 50573 */
	"DB_STENCIL_WRITE_BASE\0" /* 50589 */
	"DB_DEPTH_SIZE\0" /* 50611 */
	"DB_DEPTH_SLICE\0" /* 50625 */
	"TA_BC_BASE_ADDR\0" /* 50640 */
	"TA_BC_BASE_ADDR_HI\0" /* 50656 */
	"COHER_DEST_BASE_HI_0\0" /* 50675 */
	"COHER_DEST_BASE_HI_1\0" /* 50696 */
	"COHER_DEST_BASE_HI_2\0" /* 50717 */
	"COHER_DEST_BASE_HI_3\0" /* 50738 */
	"COHER_DEST_BASE_2\0" /* 50759 */
	"COHER_DEST_BASE_3\0" /* 50777 */
	"PA_SC_WINDOW_OFFSET\0" /* 50795 */
	"PA_SC_WINDOW_SCISSOR_TL\0" /* 50815 */
	"PA_SC_WINDOW_SCISSOR_BR\0" /* 50839 */
	"PA_SC_CLIPRECT_RULE\0" /* 50863 */
	"PA_SC_CLIPRECT_0_TL\0" /* 50883 */
	"PA_SC_CLIPRECT_0_BR\0" /* 50903 */
	"PA_SC_CLIPRECT_1_TL\0" /* 50923 */
	"PA_SC_CLIPRECT_1_BR\0" /* 50943 */
	"PA_SC_CLIPRECT_2_TL\0" /* 50963 */
	"PA_SC_CLIPRECT_2_BR\0" /* 50983 */
	"PA_SC_CLIPRECT_3_TL\0" /* 51003 */
	"PA_SC_CLIPRECT_3_BR\0" /* 51023 */
	"PA_SC_EDGERULE\0" /* 51043 */
	"PA_SU_HARDWARE_SCREEN_OFFSET\0" /* 51058 */
	"CB_TARGET_MASK\0" /* 51087 */
	"CB_SHADER_MASK\0" /* 51102 */
	"PA_SC_GENERIC_SCISSOR_TL\0" /* 51117 */
	"PA_SC_GENERIC_SCISSOR_BR\0" /* 51142 */
	"COHER_DEST_BASE_0\0" /* 51167 */
	"COHER_DEST_BASE_1\0" /* 51185 */
	"PA_SC_VPORT_SCISSOR_0_TL\0" /* 51203 */
	"PA_SC_VPORT_SCISSOR_0_BR\0" /* 51228 */
	"PA_SC_VPORT_SCISSOR_1_TL\0" /* 51253 */
	"PA_SC_VPORT_SCISSOR_1_BR\0" /* 51278 */
	"PA_SC_VPORT_SCISSOR_2_TL\0" /* 51303 */
	"PA_SC_VPORT_SCISSOR_2_BR\0" /* 51328 */
	"PA_SC_VPORT_SCISSOR_3_TL\0" /* 51353 */
	"PA_SC_VPORT_SCISSOR_3_BR\0" /* 51378 */
	"PA_SC_VPORT_SCISSOR_4_TL\0" /* 51403 */
	"PA_SC_VPORT_SCISSOR_4_BR\0" /* 51428 */
	"PA_SC_VPORT_SCISSOR_5_TL\0" /* 51453 */
	"PA_SC_VPORT_SCISSOR_5_BR\0" /* 51478 */
	"PA_SC_VPORT_SCISSOR_6_TL\0" /* 51503 */
	"PA_SC_VPORT_SCISSOR_6_BR\0" /* 51528 */
	"PA_SC_VPORT_SCISSOR_7_TL\0" /* 51553 */
	"PA_SC_VPORT_SCISSOR_7_BR\0" /* 51578 */
	"PA_SC_VPORT_SCISSOR_8_TL\0" /* 51603 */
	"PA_SC_VPORT_SCISSOR_8_BR\0" /* 51628 */
	"PA_SC_VPORT_SCISSOR_9_TL\0" /* 51653 */
	"PA_SC_VPORT_SCISSOR_9_BR\0" /* 51678 */
	"PA_SC_VPORT_SCISSOR_10_TL\0" /* 51703 */
	"PA_SC_VPORT_SCISSOR_10_BR\0" /* 51729 */
	"PA_SC_VPORT_SCISSOR_11_TL\0" /* 51755 */
	"PA_SC_VPORT_SCISSOR_11_BR\0" /* 51781 */
	"PA_SC_VPORT_SCISSOR_12_TL\0" /* 51807 */
	"PA_SC_VPORT_SCISSOR_12_BR\0" /* 51833 */
	"PA_SC_VPORT_SCISSOR_13_TL\0" /* 51859 */
	"PA_SC_VPORT_SCISSOR_13_BR\0" /* 51885 */
	"PA_SC_VPORT_SCISSOR_14_TL\0" /* 51911 */
	"PA_SC_VPORT_SCISSOR_14_BR\0" /* 51937 */
	"PA_SC_VPORT_SCISSOR_15_TL\0" /* 51963 */
	"PA_SC_VPORT_SCISSOR_15_BR\0" /* 51989 */
	"PA_SC_VPORT_ZMIN_0\0" /* 52015 */
	"PA_SC_VPORT_ZMAX_0\0" /* 52034 */
	"PA_SC_VPORT_ZMIN_1\0" /* 52053 */
	"PA_SC_VPORT_ZMAX_1\0" /* 52072 */
	"PA_SC_VPORT_ZMIN_2\0" /* 52091 */
	"PA_SC_VPORT_ZMAX_2\0" /* 52110 */
	"PA_SC_VPORT_ZMIN_3\0" /* 52129 */
	"PA_SC_VPORT_ZMAX_3\0" /* 52148 */
	"PA_SC_VPORT_ZMIN_4\0" /* 52167 */
	"PA_SC_VPORT_ZMAX_4\0" /* 52186 */
	"PA_SC_VPORT_ZMIN_5\0" /* 52205 */
	"PA_SC_VPORT_ZMAX_5\0" /* 52224 */
	"PA_SC_VPORT_ZMIN_6\0" /* 52243 */
	"PA_SC_VPORT_ZMAX_6\0" /* 52262 */
	"PA_SC_VPORT_ZMIN_7\0" /* 52281 */
	"PA_SC_VPORT_ZMAX_7\0" /* 52300 */
	"PA_SC_VPORT_ZMIN_8\0" /* 52319 */
	"PA_SC_VPORT_ZMAX_8\0" /* 52338 */
	"PA_SC_VPORT_ZMIN_9\0" /* 52357 */
	"PA_SC_VPORT_ZMAX_9\0" /* 52376 */
	"PA_SC_VPORT_ZMIN_10\0" /* 52395 */
	"PA_SC_VPORT_ZMAX_10\0" /* 52415 */
	"PA_SC_VPORT_ZMIN_11\0" /* 52435 */
	"PA_SC_VPORT_ZMAX_11\0" /* 52455 */
	"PA_SC_VPORT_ZMIN_12\0" /* 52475 */
	"PA_SC_VPORT_ZMAX_12\0" /* 52495 */
	"PA_SC_VPORT_ZMIN_13\0" /* 52515 */
	"PA_SC_VPORT_ZMAX_13\0" /* 52535 */
	"PA_SC_VPORT_ZMIN_14\0" /* 52555 */
	"PA_SC_VPORT_ZMAX_14\0" /* 52575 */
	"PA_SC_VPORT_ZMIN_15\0" /* 52595 */
	"PA_SC_VPORT_ZMAX_15\0" /* 52615 */
	"PA_SC_RASTER_CONFIG\0" /* 52635 */
	"PA_SC_RASTER_CONFIG_1\0" /* 52655 */
	"PA_SC_SCREEN_EXTENT_CONTROL\0" /* 52677 */
	"VGT_MAX_VTX_INDX\0" /* 52705 */
	"VGT_MIN_VTX_INDX\0" /* 52722 */
	"VGT_INDX_OFFSET\0" /* 52739 */
	"VGT_MULTI_PRIM_IB_RESET_INDX\0" /* 52755 */
	"CB_BLEND_RED\0" /* 52784 */
	"CB_BLEND_GREEN\0" /* 52797 */
	"CB_BLEND_BLUE\0" /* 52812 */
	"CB_BLEND_ALPHA\0" /* 52826 */
	"CB_DCC_CONTROL\0" /* 52841 */
	"DB_STENCIL_CONTROL\0" /* 52856 */
	"DB_STENCILREFMASK\0" /* 52875 */
	"DB_STENCILREFMASK_BF\0" /* 52893 */
	"PA_CL_VPORT_XSCALE\0" /* 52914 */
	"PA_CL_VPORT_XOFFSET\0" /* 52933 */
	"PA_CL_VPORT_YSCALE\0" /* 52953 */
	"PA_CL_VPORT_YOFFSET\0" /* 52972 */
	"PA_CL_VPORT_ZSCALE\0" /* 52992 */
	"PA_CL_VPORT_ZOFFSET\0" /* 53011 */
	"PA_CL_VPORT_XSCALE_1\0" /* 53031 */
	"PA_CL_VPORT_XOFFSET_1\0" /* 53052 */
	"PA_CL_VPORT_YSCALE_1\0" /* 53074 */
	"PA_CL_VPORT_YOFFSET_1\0" /* 53095 */
	"PA_CL_VPORT_ZSCALE_1\0" /* 53117 */
	"PA_CL_VPORT_ZOFFSET_1\0" /* 53138 */
	"PA_CL_VPORT_XSCALE_2\0" /* 53160 */
	"PA_CL_VPORT_XOFFSET_2\0" /* 53181 */
	"PA_CL_VPORT_YSCALE_2\0" /* 53203 */
	"PA_CL_VPORT_YOFFSET_2\0" /* 53224 */
	"PA_CL_VPORT_ZSCALE_2\0" /* 53246 */
	"PA_CL_VPORT_ZOFFSET_2\0" /* 53267 */
	"PA_CL_VPORT_XSCALE_3\0" /* 53289 */
	"PA_CL_VPORT_XOFFSET_3\0" /* 53310 */
	"PA_CL_VPORT_YSCALE_3\0" /* 53332 */
	"PA_CL_VPORT_YOFFSET_3\0" /* 53353 */
	"PA_CL_VPORT_ZSCALE_3\0" /* 53375 */
	"PA_CL_VPORT_ZOFFSET_3\0" /* 53396 */
	"PA_CL_VPORT_XSCALE_4\0" /* 53418 */
	"PA_CL_VPORT_XOFFSET_4\0" /* 53439 */
	"PA_CL_VPORT_YSCALE_4\0" /* 53461 */
	"PA_CL_VPORT_YOFFSET_4\0" /* 53482 */
	"PA_CL_VPORT_ZSCALE_4\0" /* 53504 */
	"PA_CL_VPORT_ZOFFSET_4\0" /* 53525 */
	"PA_CL_VPORT_XSCALE_5\0" /* 53547 */
	"PA_CL_VPORT_XOFFSET_5\0" /* 53568 */
	"PA_CL_VPORT_YSCALE_5\0" /* 53590 */
	"PA_CL_VPORT_YOFFSET_5\0" /* 53611 */
	"PA_CL_VPORT_ZSCALE_5\0" /* 53633 */
	"PA_CL_VPORT_ZOFFSET_5\0" /* 53654 */
	"PA_CL_VPORT_XSCALE_6\0" /* 53676 */
	"PA_CL_VPORT_XOFFSET_6\0" /* 53697 */
	"PA_CL_VPORT_YSCALE_6\0" /* 53719 */
	"PA_CL_VPORT_YOFFSET_6\0" /* 53740 */
	"PA_CL_VPORT_ZSCALE_6\0" /* 53762 */
	"PA_CL_VPORT_ZOFFSET_6\0" /* 53783 */
	"PA_CL_VPORT_XSCALE_7\0" /* 53805 */
	"PA_CL_VPORT_XOFFSET_7\0" /* 53826 */
	"PA_CL_VPORT_YSCALE_7\0" /* 53848 */
	"PA_CL_VPORT_YOFFSET_7\0" /* 53869 */
	"PA_CL_VPORT_ZSCALE_7\0" /* 53891 */
	"PA_CL_VPORT_ZOFFSET_7\0" /* 53912 */
	"PA_CL_VPORT_XSCALE_8\0" /* 53934 */
	"PA_CL_VPORT_XOFFSET_8\0" /* 53955 */
	"PA_CL_VPORT_YSCALE_8\0" /* 53977 */
	"PA_CL_VPORT_YOFFSET_8\0" /* 53998 */
	"PA_CL_VPORT_ZSCALE_8\0" /* 54020 */
	"PA_CL_VPORT_ZOFFSET_8\0" /* 54041 */
	"PA_CL_VPORT_XSCALE_9\0" /* 54063 */
	"PA_CL_VPORT_XOFFSET_9\0" /* 54084 */
	"PA_CL_VPORT_YSCALE_9\0" /* 54106 */
	"PA_CL_VPORT_YOFFSET_9\0" /* 54127 */
	"PA_CL_VPORT_ZSCALE_9\0" /* 54149 */
	"PA_CL_VPORT_ZOFFSET_9\0" /* 54170 */
	"PA_CL_VPORT_XSCALE_10\0" /* 54192 */
	"PA_CL_VPORT_XOFFSET_10\0" /* 54214 */
	"PA_CL_VPORT_YSCALE_10\0" /* 54237 */
	"PA_CL_VPORT_YOFFSET_10\0" /* 54259 */
	"PA_CL_VPORT_ZSCALE_10\0" /* 54282 */
	"PA_CL_VPORT_ZOFFSET_10\0" /* 54304 */
	"PA_CL_VPORT_XSCALE_11\0" /* 54327 */
	"PA_CL_VPORT_XOFFSET_11\0" /* 54349 */
	"PA_CL_VPORT_YSCALE_11\0" /* 54372 */
	"PA_CL_VPORT_YOFFSET_11\0" /* 54394 */
	"PA_CL_VPORT_ZSCALE_11\0" /* 54417 */
	"PA_CL_VPORT_ZOFFSET_11\0" /* 54439 */
	"PA_CL_VPORT_XSCALE_12\0" /* 54462 */
	"PA_CL_VPORT_XOFFSET_12\0" /* 54484 */
	"PA_CL_VPORT_YSCALE_12\0" /* 54507 */
	"PA_CL_VPORT_YOFFSET_12\0" /* 54529 */
	"PA_CL_VPORT_ZSCALE_12\0" /* 54552 */
	"PA_CL_VPORT_ZOFFSET_12\0" /* 54574 */
	"PA_CL_VPORT_XSCALE_13\0" /* 54597 */
	"PA_CL_VPORT_XOFFSET_13\0" /* 54619 */
	"PA_CL_VPORT_YSCALE_13\0" /* 54642 */
	"PA_CL_VPORT_YOFFSET_13\0" /* 54664 */
	"PA_CL_VPORT_ZSCALE_13\0" /* 54687 */
	"PA_CL_VPORT_ZOFFSET_13\0" /* 54709 */
	"PA_CL_VPORT_XSCALE_14\0" /* 54732 */
	"PA_CL_VPORT_XOFFSET_14\0" /* 54754 */
	"PA_CL_VPORT_YSCALE_14\0" /* 54777 */
	"PA_CL_VPORT_YOFFSET_14\0" /* 54799 */
	"PA_CL_VPORT_ZSCALE_14\0" /* 54822 */
	"PA_CL_VPORT_ZOFFSET_14\0" /* 54844 */
	"PA_CL_VPORT_XSCALE_15\0" /* 54867 */
	"PA_CL_VPORT_XOFFSET_15\0" /* 54889 */
	"PA_CL_VPORT_YSCALE_15\0" /* 54912 */
	"PA_CL_VPORT_YOFFSET_15\0" /* 54934 */
	"PA_CL_VPORT_ZSCALE_15\0" /* 54957 */
	"PA_CL_VPORT_ZOFFSET_15\0" /* 54979 */
	"PA_CL_UCP_0_X\0" /* 55002 */
	"PA_CL_UCP_0_Y\0" /* 55016 */
	"PA_CL_UCP_0_Z\0" /* 55030 */
	"PA_CL_UCP_0_W\0" /* 55044 */
	"PA_CL_UCP_1_X\0" /* 55058 */
	"PA_CL_UCP_1_Y\0" /* 55072 */
	"PA_CL_UCP_1_Z\0" /* 55086 */
	"PA_CL_UCP_1_W\0" /* 55100 */
	"PA_CL_UCP_2_X\0" /* 55114 */
	"PA_CL_UCP_2_Y\0" /* 55128 */
	"PA_CL_UCP_2_Z\0" /* 55142 */
	"PA_CL_UCP_2_W\0" /* 55156 */
	"PA_CL_UCP_3_X\0" /* 55170 */
	"PA_CL_UCP_3_Y\0" /* 55184 */
	"PA_CL_UCP_3_Z\0" /* 55198 */
	"PA_CL_UCP_3_W\0" /* 55212 */
	"PA_CL_UCP_4_X\0" /* 55226 */
	"PA_CL_UCP_4_Y\0" /* 55240 */
	"PA_CL_UCP_4_Z\0" /* 55254 */
	"PA_CL_UCP_4_W\0" /* 55268 */
	"PA_CL_UCP_5_X\0" /* 55282 */
	"PA_CL_UCP_5_Y\0" /* 55296 */
	"PA_CL_UCP_5_Z\0" /* 55310 */
	"PA_CL_UCP_5_W\0" /* 55324 */
	"SPI_PS_INPUT_CNTL_0\0" /* 55338 */
	"SPI_PS_INPUT_CNTL_1\0" /* 55358 */
	"SPI_PS_INPUT_CNTL_2\0" /* 55378 */
	"SPI_PS_INPUT_CNTL_3\0" /* 55398 */
	"SPI_PS_INPUT_CNTL_4\0" /* 55418 */
	"SPI_PS_INPUT_CNTL_5\0" /* 55438 */
	"SPI_PS_INPUT_CNTL_6\0" /* 55458 */
	"SPI_PS_INPUT_CNTL_7\0" /* 55478 */
	"SPI_PS_INPUT_CNTL_8\0" /* 55498 */
	"SPI_PS_INPUT_CNTL_9\0" /* 55518 */
	"SPI_PS_INPUT_CNTL_10\0" /* 55538 */
	"SPI_PS_INPUT_CNTL_11\0" /* 55559 */
	"SPI_PS_INPUT_CNTL_12\0" /* 55580 */
	"SPI_PS_INPUT_CNTL_13\0" /* 55601 */
	"SPI_PS_INPUT_CNTL_14\0" /* 55622 */
	"SPI_PS_INPUT_CNTL_15\0" /* 55643 */
	"SPI_PS_INPUT_CNTL_16\0" /* 55664 */
	"SPI_PS_INPUT_CNTL_17\0" /* 55685 */
	"SPI_PS_INPUT_CNTL_18\0" /* 55706 */
	"SPI_PS_INPUT_CNTL_19\0" /* 55727 */
	"SPI_PS_INPUT_CNTL_20\0" /* 55748 */
	"SPI_PS_INPUT_CNTL_21\0" /* 55769 */
	"SPI_PS_INPUT_CNTL_22\0" /* 55790 */
	"SPI_PS_INPUT_CNTL_23\0" /* 55811 */
	"SPI_PS_INPUT_CNTL_24\0" /* 55832 */
	"SPI_PS_INPUT_CNTL_25\0" /* 55853 */
	"SPI_PS_INPUT_CNTL_26\0" /* 55874 */
	"SPI_PS_INPUT_CNTL_27\0" /* 55895 */
	"SPI_PS_INPUT_CNTL_28\0" /* 55916 */
	"SPI_PS_INPUT_CNTL_29\0" /* 55937 */
	"SPI_PS_INPUT_CNTL_30\0" /* 55958 */
	"SPI_PS_INPUT_CNTL_31\0" /* 55979 */
	"SPI_VS_OUT_CONFIG\0" /* 56000 */
	"SPI_PS_INPUT_ENA\0" /* 56018 */
	"SPI_PS_INPUT_ADDR\0" /* 56035 */
	"SPI_INTERP_CONTROL_0\0" /* 56053 */
	"SPI_PS_IN_CONTROL\0" /* 56074 */
	"SPI_BARYC_CNTL\0" /* 56092 */
	"SPI_TMPRING_SIZE\0" /* 56107 */
	"SPI_WAVE_MGMT_1\0" /* 56124 */
	"SPI_WAVE_MGMT_2\0" /* 56140 */
	"SPI_SHADER_POS_FORMAT\0" /* 56156 */
	"SPI_SHADER_Z_FORMAT\0" /* 56178 */
	"SPI_SHADER_COL_FORMAT\0" /* 56198 */
	"SX_PS_DOWNCONVERT\0" /* 56220 */
	"SX_BLEND_OPT_EPSILON\0" /* 56238 */
	"SX_BLEND_OPT_CONTROL\0" /* 56259 */
	"SX_MRT0_BLEND_OPT\0" /* 56280 */
	"SX_MRT1_BLEND_OPT\0" /* 56298 */
	"SX_MRT2_BLEND_OPT\0" /* 56316 */
	"SX_MRT3_BLEND_OPT\0" /* 56334 */
	"SX_MRT4_BLEND_OPT\0" /* 56352 */
	"SX_MRT5_BLEND_OPT\0" /* 56370 */
	"SX_MRT6_BLEND_OPT\0" /* 56388 */
	"SX_MRT7_BLEND_OPT\0" /* 56406 */
	"CB_BLEND0_CONTROL\0" /* 56424 */
	"CB_BLEND1_CONTROL\0" /* 56442 */
	"CB_BLEND2_CONTROL\0" /* 56460 */
	"CB_BLEND3_CONTROL\0" /* 56478 */
	"CB_BLEND4_CONTROL\0" /* 56496 */
	"CB_BLEND5_CONTROL\0" /* 56514 */
	"CB_BLEND6_CONTROL\0" /* 56532 */
	"CB_BLEND7_CONTROL\0" /* 56550 */
	"CS_COPY_STATE\0" /* 56568 */
	"PA_CL_POINT_X_RAD\0" /* 56582 */
	"PA_CL_POINT_Y_RAD\0" /* 56600 */
	"PA_CL_POINT_SIZE\0" /* 56618 */
	"PA_CL_POINT_CULL_RAD\0" /* 56635 */
	"VGT_DMA_BASE_HI\0" /* 56656 */
	"VGT_DMA_BASE\0" /* 56672 */
	"VGT_DRAW_INITIATOR\0" /* 56685 */
	"VGT_IMMED_DATA\0" /* 56704 */
	"VGT_EVENT_ADDRESS_REG\0" /* 56719 */
	"DB_DEPTH_CONTROL\0" /* 56741 */
	"DB_EQAA\0" /* 56758 */
	"CB_COLOR_CONTROL\0" /* 56766 */
	"DB_SHADER_CONTROL\0" /* 56783 */
	"PA_CL_CLIP_CNTL\0" /* 56801 */
	"PA_SU_SC_MODE_CNTL\0" /* 56817 */
	"PA_CL_VTE_CNTL\0" /* 56836 */
	"PA_CL_VS_OUT_CNTL\0" /* 56851 */
	"PA_CL_NANINF_CNTL\0" /* 56869 */
	"PA_SU_LINE_STIPPLE_CNTL\0" /* 56887 */
	"PA_SU_LINE_STIPPLE_SCALE\0" /* 56911 */
	"PA_SU_PRIM_FILTER_CNTL\0" /* 56936 */
	"PA_SU_SMALL_PRIM_FILTER_CNTL\0" /* 56959 */
	"PA_SU_POINT_SIZE\0" /* 56988 */
	"PA_SU_POINT_MINMAX\0" /* 57005 */
	"PA_SU_LINE_CNTL\0" /* 57024 */
	"PA_SC_LINE_STIPPLE\0" /* 57040 */
	"VGT_OUTPUT_PATH_CNTL\0" /* 57059 */
	"VGT_HOS_CNTL\0" /* 57080 */
	"VGT_HOS_MAX_TESS_LEVEL\0" /* 57093 */
	"VGT_HOS_MIN_TESS_LEVEL\0" /* 57116 */
	"VGT_HOS_REUSE_DEPTH\0" /* 57139 */
	"VGT_GROUP_PRIM_TYPE\0" /* 57159 */
	"VGT_GROUP_FIRST_DECR\0" /* 57179 */
	"VGT_GROUP_DECR\0" /* 57200 */
	"VGT_GROUP_VECT_0_CNTL\0" /* 57215 */
	"VGT_GROUP_VECT_1_CNTL\0" /* 57237 */
	"VGT_GROUP_VECT_0_FMT_CNTL\0" /* 57259 */
	"VGT_GROUP_VECT_1_FMT_CNTL\0" /* 57285 */
	"VGT_GS_MODE\0" /* 57311 */
	"VGT_GS_ONCHIP_CNTL\0" /* 57323 */
	"PA_SC_MODE_CNTL_0\0" /* 57342 */
	"PA_SC_MODE_CNTL_1\0" /* 57360 */
	"VGT_ENHANCE\0" /* 57378 */
	"VGT_GS_PER_ES\0" /* 57390 */
	"VGT_ES_PER_GS\0" /* 57404 */
	"VGT_GS_PER_VS\0" /* 57418 */
	"VGT_GSVS_RING_OFFSET_1\0" /* 57432 */
	"VGT_GSVS_RING_OFFSET_2\0" /* 57455 */
	"VGT_GSVS_RING_OFFSET_3\0" /* 57478 */
	"VGT_GS_OUT_PRIM_TYPE\0" /* 57501 */
	"IA_ENHANCE\0" /* 57522 */
	"VGT_DMA_SIZE\0" /* 57533 */
	"VGT_DMA_MAX_SIZE\0" /* 57546 */
	"VGT_DMA_INDEX_TYPE\0" /* 57563 */
	"WD_ENHANCE\0" /* 57582 */
	"VGT_PRIMITIVEID_EN\0" /* 57593 */
	"VGT_DMA_NUM_INSTANCES\0" /* 57612 */
	"VGT_PRIMITIVEID_RESET\0" /* 57634 */
	"VGT_EVENT_INITIATOR\0" /* 57656 */
	"VGT_MULTI_PRIM_IB_RESET_EN\0" /* 57676 */
	"VGT_INSTANCE_STEP_RATE_0\0" /* 57703 */
	"VGT_INSTANCE_STEP_RATE_1\0" /* 57728 */
	"IA_MULTI_VGT_PARAM\0" /* 57753 */
	"VGT_ESGS_RING_ITEMSIZE\0" /* 57772 */
	"VGT_GSVS_RING_ITEMSIZE\0" /* 57795 */
	"VGT_REUSE_OFF\0" /* 57818 */
	"VGT_VTX_CNT_EN\0" /* 57832 */
	"DB_HTILE_SURFACE\0" /* 57847 */
	"DB_SRESULTS_COMPARE_STATE0\0" /* 57864 */
	"DB_SRESULTS_COMPARE_STATE1\0" /* 57891 */
	"DB_PRELOAD_CONTROL\0" /* 57918 */
	"VGT_STRMOUT_BUFFER_SIZE_0\0" /* 57937 */
	"VGT_STRMOUT_VTX_STRIDE_0\0" /* 57963 */
	"VGT_STRMOUT_BUFFER_OFFSET_0\0" /* 57988 */
	"VGT_STRMOUT_BUFFER_SIZE_1\0" /* 58016 */
	"VGT_STRMOUT_VTX_STRIDE_1\0" /* 58042 */
	"VGT_STRMOUT_BUFFER_OFFSET_1\0" /* 58067 */
	"VGT_STRMOUT_BUFFER_SIZE_2\0" /* 58095 */
	"VGT_STRMOUT_VTX_STRIDE_2\0" /* 58121 */
	"VGT_STRMOUT_BUFFER_OFFSET_2\0" /* 58146 */
	"VGT_STRMOUT_BUFFER_SIZE_3\0" /* 58174 */
	"VGT_STRMOUT_VTX_STRIDE_3\0" /* 58200 */
	"VGT_STRMOUT_BUFFER_OFFSET_3\0" /* 58225 */
	"VGT_STRMOUT_DRAW_OPAQUE_OFFSET\0" /* 58253 */
	"VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE\0" /* 58284 */
	"VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE\0" /* 58327 */
	"VGT_GS_MAX_VERT_OUT\0" /* 58365 */
	"VGT_TESS_DISTRIBUTION\0" /* 58385 */
	"VGT_SHADER_STAGES_EN\0" /* 58407 */
	"VGT_LS_HS_CONFIG\0" /* 58428 */
	"VGT_GS_VERT_ITEMSIZE\0" /* 58445 */
	"VGT_GS_VERT_ITEMSIZE_1\0" /* 58466 */
	"VGT_GS_VERT_ITEMSIZE_2\0" /* 58489 */
	"VGT_GS_VERT_ITEMSIZE_3\0" /* 58512 */
	"VGT_TF_PARAM\0" /* 58535 */
	"DB_ALPHA_TO_MASK\0" /* 58548 */
	"VGT_DISPATCH_DRAW_INDEX\0" /* 58565 */
	"PA_SU_POLY_OFFSET_DB_FMT_CNTL\0" /* 58589 */
	"PA_SU_POLY_OFFSET_CLAMP\0" /* 58619 */
	"PA_SU_POLY_OFFSET_FRONT_SCALE\0" /* 58643 */
	"PA_SU_POLY_OFFSET_FRONT_OFFSET\0" /* 58673 */
	"PA_SU_POLY_OFFSET_BACK_SCALE\0" /* 58704 */
	"PA_SU_POLY_OFFSET_BACK_OFFSET\0" /* 58733 */
	"VGT_GS_INSTANCE_CNT\0" /* 58763 */
	"VGT_STRMOUT_CONFIG\0" /* 58783 */
	"VGT_STRMOUT_BUFFER_CONFIG\0" /* 58802 */
	"PA_SC_CENTROID_PRIORITY_0\0" /* 58828 */
	"PA_SC_CENTROID_PRIORITY_1\0" /* 58854 */
	"PA_SC_LINE_CNTL\0" /* 58880 */
	"PA_SC_AA_CONFIG\0" /* 58896 */
	"PA_SU_VTX_CNTL\0" /* 58912 */
	"PA_CL_GB_VERT_CLIP_ADJ\0" /* 58927 */
	"PA_CL_GB_VERT_DISC_ADJ\0" /* 58950 */
	"PA_CL_GB_HORZ_CLIP_ADJ\0" /* 58973 */
	"PA_CL_GB_HORZ_DISC_ADJ\0" /* 58996 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0\0" /* 59019 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1\0" /* 59053 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2\0" /* 59087 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3\0" /* 59121 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0\0" /* 59155 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1\0" /* 59189 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2\0" /* 59223 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3\0" /* 59257 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0\0" /* 59291 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1\0" /* 59325 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2\0" /* 59359 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3\0" /* 59393 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0\0" /* 59427 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1\0" /* 59461 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2\0" /* 59495 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3\0" /* 59529 */
	"PA_SC_AA_MASK_X0Y0_X1Y0\0" /* 59563 */
	"PA_SC_AA_MASK_X0Y1_X1Y1\0" /* 59587 */
	"PA_SC_SHADER_CONTROL\0" /* 59611 */
	"VGT_VERTEX_REUSE_BLOCK_CNTL\0" /* 59632 */
	"VGT_OUT_DEALLOC_CNTL\0" /* 59660 */
	"CB_COLOR0_BASE\0" /* 59681 */
	"CB_COLOR0_PITCH\0" /* 59696 */
	"CB_COLOR0_SLICE\0" /* 59712 */
	"CB_COLOR0_VIEW\0" /* 59728 */
	"CB_COLOR0_INFO\0" /* 59743 */
	"CB_COLOR0_ATTRIB\0" /* 59758 */
	"CB_COLOR0_DCC_CONTROL\0" /* 59775 */
	"CB_COLOR0_CMASK\0" /* 59797 */
	"CB_COLOR0_CMASK_SLICE\0" /* 59813 */
	"CB_COLOR0_FMASK\0" /* 59835 */
	"CB_COLOR0_FMASK_SLICE\0" /* 59851 */
	"CB_COLOR0_CLEAR_WORD0\0" /* 59873 */
	"CB_COLOR0_CLEAR_WORD1\0" /* 59895 */
	"CB_COLOR0_DCC_BASE\0" /* 59917 */
	"CB_COLOR1_BASE\0" /* 59936 */
	"CB_COLOR1_PITCH\0" /* 59951 */
	"CB_COLOR1_SLICE\0" /* 59967 */
	"CB_COLOR1_VIEW\0" /* 59983 */
	"CB_COLOR1_INFO\0" /* 59998 */
	"CB_COLOR1_ATTRIB\0" /* 60013 */
	"CB_COLOR1_DCC_CONTROL\0" /* 60030 */
	"CB_COLOR1_CMASK\0" /* 60052 */
	"CB_COLOR1_CMASK_SLICE\0" /* 60068 */
	"CB_COLOR1_FMASK\0" /* 60090 */
	"CB_COLOR1_FMASK_SLICE\0" /* 60106 */
	"CB_COLOR1_CLEAR_WORD0\0" /* 60128 */
	"CB_COLOR1_CLEAR_WORD1\0" /* 60150 */
	"CB_COLOR1_DCC_BASE\0" /* 60172 */
	"CB_COLOR2_BASE\0" /* 60191 */
	"CB_COLOR2_PITCH\0" /* 60206 */
	"CB_COLOR2_SLICE\0" /* 60222 */
	"CB_COLOR2_VIEW\0" /* 60238 */
	"CB_COLOR2_INFO\0" /* 60253 */
	"CB_COLOR2_ATTRIB\0" /* 60268 */
	"CB_COLOR2_DCC_CONTROL\0" /* 60285 */
	"CB_COLOR2_CMASK\0" /* 60307 */
	"CB_COLOR2_CMASK_SLICE\0" /* 60323 */
	"CB_COLOR2_FMASK\0" /* 60345 */
	"CB_COLOR2_FMASK_SLICE\0" /* 60361 */
	"CB_COLOR2_CLEAR_WORD0\0" /* 60383 */
	"CB_COLOR2_CLEAR_WORD1\0" /* 60405 */
	"CB_COLOR2_DCC_BASE\0" /* 60427 */
	"CB_COLOR3_BASE\0" /* 60446 */
	"CB_COLOR3_PITCH\0" /* 60461 */
	"CB_COLOR3_SLICE\0" /* 60477 */
	"CB_COLOR3_VIEW\0" /* 60493 */
	"CB_COLOR3_INFO\0" /* 60508 */
	"CB_COLOR3_ATTRIB\0" /* 60523 */
	"CB_COLOR3_DCC_CONTROL\0" /* 60540 */
	"CB_COLOR3_CMASK\0" /* 60562 */
	"CB_COLOR3_CMASK_SLICE\0" /* 60578 */
	"CB_COLOR3_FMASK\0" /* 60600 */
	"CB_COLOR3_FMASK_SLICE\0" /* 60616 */
	"CB_COLOR3_CLEAR_WORD0\0" /* 60638 */
	"CB_COLOR3_CLEAR_WORD1\0" /* 60660 */
	"CB_COLOR3_DCC_BASE\0" /* 60682 */
	"CB_COLOR4_BASE\0" /* 60701 */
	"CB_COLOR4_PITCH\0" /* 60716 */
	"CB_COLOR4_SLICE\0" /* 60732 */
	"CB_COLOR4_VIEW\0" /* 60748 */
	"CB_COLOR4_INFO\0" /* 60763 */
	"CB_COLOR4_ATTRIB\0" /* 60778 */
	"CB_COLOR4_DCC_CONTROL\0" /* 60795 */
	"CB_COLOR4_CMASK\0" /* 60817 */
	"CB_COLOR4_CMASK_SLICE\0" /* 60833 */
	"CB_COLOR4_FMASK\0" /* 60855 */
	"CB_COLOR4_FMASK_SLICE\0" /* 60871 */
	"CB_COLOR4_CLEAR_WORD0\0" /* 60893 */
	"CB_COLOR4_CLEAR_WORD1\0" /* 60915 */
	"CB_COLOR4_DCC_BASE\0" /* 60937 */
	"CB_COLOR5_BASE\0" /* 60956 */
	"CB_COLOR5_PITCH\0" /* 60971 */
	"CB_COLOR5_SLICE\0" /* 60987 */
	"CB_COLOR5_VIEW\0" /* 61003 */
	"CB_COLOR5_INFO\0" /* 61018 */
	"CB_COLOR5_ATTRIB\0" /* 61033 */
	"CB_COLOR5_DCC_CONTROL\0" /* 61050 */
	"CB_COLOR5_CMASK\0" /* 61072 */
	"CB_COLOR5_CMASK_SLICE\0" /* 61088 */
	"CB_COLOR5_FMASK\0" /* 61110 */
	"CB_COLOR5_FMASK_SLICE\0" /* 61126 */
	"CB_COLOR5_CLEAR_WORD0\0" /* 61148 */
	"CB_COLOR5_CLEAR_WORD1\0" /* 61170 */
	"CB_COLOR5_DCC_BASE\0" /* 61192 */
	"CB_COLOR6_BASE\0" /* 61211 */
	"CB_COLOR6_PITCH\0" /* 61226 */
	"CB_COLOR6_SLICE\0" /* 61242 */
	"CB_COLOR6_VIEW\0" /* 61258 */
	"CB_COLOR6_INFO\0" /* 61273 */
	"CB_COLOR6_ATTRIB\0" /* 61288 */
	"CB_COLOR6_DCC_CONTROL\0" /* 61305 */
	"CB_COLOR6_CMASK\0" /* 61327 */
	"CB_COLOR6_CMASK_SLICE\0" /* 61343 */
	"CB_COLOR6_FMASK\0" /* 61365 */
	"CB_COLOR6_FMASK_SLICE\0" /* 61381 */
	"CB_COLOR6_CLEAR_WORD0\0" /* 61403 */
	"CB_COLOR6_CLEAR_WORD1\0" /* 61425 */
	"CB_COLOR6_DCC_BASE\0" /* 61447 */
	"CB_COLOR7_BASE\0" /* 61466 */
	"CB_COLOR7_PITCH\0" /* 61481 */
	"CB_COLOR7_SLICE\0" /* 61497 */
	"CB_COLOR7_VIEW\0" /* 61513 */
	"CB_COLOR7_INFO\0" /* 61528 */
	"CB_COLOR7_ATTRIB\0" /* 61543 */
	"CB_COLOR7_DCC_CONTROL\0" /* 61560 */
	"CB_COLOR7_CMASK\0" /* 61582 */
	"CB_COLOR7_CMASK_SLICE\0" /* 61598 */
	"CB_COLOR7_FMASK\0" /* 61620 */
	"CB_COLOR7_FMASK_SLICE\0" /* 61636 */
	"CB_COLOR7_CLEAR_WORD0\0" /* 61658 */
	"CB_COLOR7_CLEAR_WORD1\0" /* 61680 */
	"CB_COLOR7_DCC_BASE\0" /* 61702 */;

static const int sid_strings_offsets[] = {
	/* 0 */ 509, 871, 875, 878,
	/* 4 */ 915, 935, 947, 953, 957, 966,
	/* 10 */ 1024, 953, 391, 1033,
	/* 14 */ 1063, 953, -1, 1072,
	/* 18 */ 1161, 1166, 1174, 1182,
	/* 22 */ 1208, 926,
	/* 24 */ 1223, 1233,
	/* 26 */ 5452, 5463, 5479, 5494, 5510, 5524, 5537, 5552, 5567, 5582, 5594, 5613, 5633, 5651, 5670, 5685, 5700, 5722, 5737, 5752, 5767, 5783, 5797, 5824, 5851, 5878, 5905, 5929, 5949,
	/* 55 */ 5978, 5999,
	/* 57 */ 5452, 5463, 5479, 5494, 5510, 5524, 5537, -1, -1, 5582, 5594, 5613, 5633, 5651, -1, -1, 5700, 5722, 5737, 5752, 5767, 5783, 5797, 5824, 5851, 5878, 5905, 5929, 5949,
	/* 86 */ 7959, 7971, 7983, 7995,
	/* 90 */ 8343, -1, -1, -1, -1, -1, -1, -1, 8354, 8366, -1, -1, 8378, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8389,
	/* 123 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8415,
	/* 186 */ 8510, 8519, 8528, 8546, 8564, 8573, 8582, 8591,
	/* 194 */ 8640, 8661, 8682, 8705, 8728, 8748, 8768, 8793,
	/* 202 */ 8825, 8849, 8867, 8886, 8906, 8925, 8947, 8972, 8997, 9024, 9051, 9075, 9097, 9125, 9150, 9178,
	/* 218 */ 9286, 9298, 9317, 9336,
	/* 222 */ 9363, 9387, 9405, 9424, 9444, 9463, 9485, 9510, 9535, 9562, 9589, 9613, 9635, 9663, 9688, 9716, 9744, 9766, 9790, 9814, 9838, 9859, 9880, 9905, 9934, 9959, 9985, 10008, 10032, 10059, 10087, 10115, 10143, 10165, 10187, 10211, 10231, 10251, 10271, 10291, 10311, 10331, 10351, 10385, 10419, 10448, 10477, 10506, 10535, 10564, 10593, 10624, 10654, 10685, 10715, 10745, 10776, 10807, 10827, 10849, 10867, 10894, 10918, 10944,
	/* 286 */ 10978, 10999, 11020, 11043, 11066, 11086, 11106, 11131, 11152, 11178, 11198, 11220, 11246, 11267, 11291, 11318,
	/* 302 */ 11422, 11441, 11460, 11479, 11498, 11517, 11536, 11555, 11574, 11589, 11604, 11619, 11636, 11657, 11678, 11698,
	/* 318 */ 11881, 11893, 11907, 11931, 11961, 11986, 12017, 12037,
	/* 326 */ 12103, 12130, 12156, 12183, 12214, 12243, 12273, 12307,
	/* 334 */ 12529, 12552,
	/* 336 */ 12529, 12552, 12592, 12621,
	/* 340 */ 12667, 12688, 12710,
	/* 343 */ 12837, 12869, 12902, 12935,
	/* 347 */ 13126,
	/* 348 */ 13425, 13441, 13457, 13473, 13489, 13505, 13521, 13537, 13553, 13569, 13585, 13601, 13616, 13631, 13646, 13662,
	/* 364 */ 14074, 14105, 14133, 14162,
	/* 368 */ 14207, 14228, 14249, 14270, 14291, -1, -1, 14312, 14333, -1, -1, -1, 14355, 14376, 14397, 14419,
	/* 384 */ 14447, 14460, 14483, 14506, 14529, 14549, 14570, 14591, 14612, 14638, 14664, 14690, 14717, 14744, 14771,
	/* 399 */ 14810, 14835, 14861, 14887, 14913, 14938, 14963,
	/* 406 */ 14999, 15022, 15045, 15068,
	/* 410 */ 15102, 15126, 15150, 15174,
	/* 414 */ 15210, 15235, 15260, 15285,
	/* 418 */ 15328, 15345, 15362, 15379,
	/* 422 */ 14074, 14105, 14133, 15407,
	/* 426 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15522, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15536, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15550,
	/* 667 */ 16480, 16498, 16513,
	/* 670 */ 18050, 18060, 18073, 18087,
	/* 674 */ 18384, 18399, 18415, 18431,
	/* 678 */ 18596, 18606, 18624, 18634,
	/* 682 */ 14207, 14228, 14249, -1, 14291, 19039, 19061,
	/* 689 */ 14447, -1, -1, -1, 14529, 14549, 14570, 14591, 14612, 14638, 14664, 14690, 14717, 14744, 14771, -1, 19086, 19113,
	/* 707 */ 19141, 19151, 19156, 19161,
	/* 711 */ 19303, 19319,
	/* 713 */ 19797, 19820, 19843, 19866,
	/* 717 */ 19913, 19938, 19963, 19988,
	/* 721 */ 20038, 20062, 20086, 20110,
	/* 725 */ 20142, 20167, 20192, 20217,
	/* 729 */ 20251, 20276, 20301, 20326,
	/* 733 */ 20360, 20386, 20412, 20438,
	/* 737 */ 20474, 20497, 20520, 20543,
	/* 741 */ 20573, 20607, 20642, 20677,
	/* 745 */ 20720, 20754, 20789, 20824,
	/* 749 */ 20867, 20890, 20913, 20936,
	/* 753 */ 20966, 21000, 21035, 21070,
	/* 757 */ 21113, 21147, 21182, 21217,
	/* 761 */ 21260, 21288, 21316, 21344,
	/* 765 */ 21384, 21423, 21463, 21503,
	/* 769 */ 21556, 21595, 21635, 21675,
	/* 773 */ 21823, 21836, 21849, 21862, 21883, 21902, 21920, 21938, 21953, 21970, 21987, 21999, 22010, 22022, 22035, 22047,
	/* 789 */ 22271,
	/* 790 */ 22800, 22821, 22842, 22863, 22884,
	/* 795 */ 23145,
	/* 796 */ 23325, 23341, 23358, 23375, 23396,
	/* 801 */ 23489, 23505, 23521, 23538, 23555, 23576, 23600, 23624, 23647, 23670,
	/* 811 */ 23857, 23884, 23902, 23920, 23942, 23966, 23987, 24006, 24027, 24048, 24070,
	/* 822 */ 24132, 24138, -1, 24151, -1, -1, -1, 24164, -1, -1, -1, 24176, -1, 24188, -1, 24200,
	/* 838 */ 24707, 24742, 24777, 24809, 24841, 24873, 24905, 24939,
	/* 846 */ 25003, 25017, 25030, 25048, 25061, 25074, 25095, 25119,
	/* 854 */ 25195, 25206, 25216, 25232, 25258, 25274, 25300, 25316, 25342, 25358, 25384, -1, -1, 25409, 25430, 25461, 25478, 25499, 25516, 25537, 25558,
	/* 875 */ 25604, 25622, 25641, 25658, 25675,
	/* 880 */ 25798, 25813, 25834, 25856,
	/* 884 */ 25890, 25906,
	/* 886 */ 26014, 26025, 26035, 26046, 26058, 26071, 26085, 26097,
	/* 894 */ 26125, 26135, 26144, 26154, 26165, 26177, 26190, 26201,
	/* 902 */ 26622, 26633, 26643, 26667, -1, 26678, 26698,
	/* 909 */ 26716, -1, -1, -1, -1, 26723, -1, -1, -1, -1, 26730, -1, -1, -1, -1, 26737, -1, 26744, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26751, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26758, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26765, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26772, -1, -1, -1, -1, 26779, -1, -1, -1, -1, 26786, -1, -1, -1, -1, 26793, -1, -1, -1, -1, -1, -1, 26800, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26807, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26814, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26821, -1, -1, -1, -1, -1, -1, 26828, -1, -1, -1, -1, 26835, -1, -1, -1, -1, 26842, -1, -1, -1, -1, 26849, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26856, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26863, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26870, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26877, -1, 26884, -1, -1, -1, -1, 26891, -1, -1, -1, -1, 26898, -1, -1, -1, -1, 26905,
	/* 1165 */ 26988, 26995, 27015, 27020,
	/* 1169 */ 27166, 27179, 27198, 27220,
	/* 1173 */ 27606, 27626,
	/* 1175 */ 27638, 27652, 27665,
	/* 1178 */ 29196, 29218, 29238, 29259, 29280,
	/* 1183 */ 29335, 29352, 29368, 29383, 29399, 29415, 29439, 29463, 29487, 29511, 29532, 29548, 29563, 29587, 29610, 29634, 29654, 29673,
	/* 1201 */ 29716, 29729, 29743, 29755, 29768,
	/* 1206 */ 29852, 29869, 29886, 29902, 29918, 29934, 29950, 29967, 29985,
	/* 1215 */ 30057, 30064, 30078, 30092, 30106, 30120,
	/* 1221 */ 30130, 30142, 30153, 30164,
	/* 1225 */ 30336, -1, -1, 30351,
	/* 1229 */ 31020, 31043, 31066,
	/* 1232 */ 31169, 31182, 31195,
	/* 1235 */ 31207, 31225, 31245, 31265,
	/* 1239 */ 31293, 31309, 31326,
	/* 1242 */ 31353, 31368,
	/* 1244 */ -1, 31460, 31483, 31506, 31529, 31544, 31557, 31569, 31586, -1, 31605, 31625, 31645, 31664, -1, 31676, 31693, 31710, 31726, -1, 31742, 31771, 31782, 31808, 31826, 31843, 31862, 31880, 31899, 31915, 31931, 31951, 31973, 31995, 32009, 32028, 32044, -1, -1, 32054, 32069, -1, 32087, 32110, 32135, 32157, 32182, 7596, 7623, 32204, -1, 32232, 32251, 32269, 32289, 32308, 32328, 32352, -1, -1, -1, -1, -1, -1, 32373,
	/* 1309 */ 32882, 32895, 32907,
	/* 1312 */ 32919, 32932, 32944,
	/* 1315 */ 32958, 32972, 32984,
	/* 1318 */ 33115, 33128, 33142,
	/* 1321 */ 33152, 33165, 33175, 33189,
	/* 1325 */ 33217, 33230, 33242, 33261,
	/* 1329 */ 31353, 31368, 33358,
	/* 1332 */ 33376, 33402, 33428, 33453,
	/* 1336 */ 34232, 34243, 34251, 34267,
	/* 1340 */ 34293, 34319, 34344, 34369, 34392, 34413, 34440, 34469,
	/* 1348 */ 34806, 34818, 34831, 34844,
	/* 1352 */ 34864, 34878, 34886, 34895, 34905, 34914, 34926, 34941, 34956, 34973, 34990, 35004, 35016, -1, 35034, -1, 35052, 35064, 35078, 35092, 35106, 35117, 35128,
	/* 1375 */ 35149, 35162, -1, -1, 35175, 35187, 35199, 35211,
	/* 1383 */ 35236, 35245, 35254, 35267,
	/* 1387 */ 35344, 35359, 35377, 35405, 35435, 35466, 35494,
};

#endif
