#include <stdio.h>

static int was_space = 0;
static int first_char = 1;

static void put_char (int c)
{
   if (c == '\n') {
      if (!first_char) {
         fputs ("\\n\"\n\"", stdout);
         first_char = 1;
      }
   }
   else {
      first_char = 0;
      if (c == '\\')
         fputs ("\\\\", stdout);
      else if (c == '\"')
         fputs ("\\\"", stdout);
      else if (!was_space || !(c == ' ' || c == '\t'))
         fputc (c, stdout);
      was_space = (c == ' ' || c == '\t');
   }
}

int main (int argc, char *argv[])
{
   int c;
   FILE *f;

   if (argc == 1)
      return 1;
   f = fopen (argv[1], "r");
   if (f == NULL)
      return 1;

   fputs ("\n", stdout);
   fputs ("/* DO NOT EDIT - THIS FILE IS AUTOMATICALLY GENERATED FROM THE .syn FILE */\n", stdout);
   fputs ("\n", stdout);
   fputs ("\"", stdout);
   c = getc (f);
   while (c != EOF) {
      if (c == '/') {
         int c2 = getc (f);
         if (c2 == '*') {
            was_space = 0;
            c = getc (f);
            for (;;) {
               if (c == '*') {
                  c2 = getc (f);
                  if (c2 == '/')
                     break;
               }
               c = getc (f);
            }
         }
         else {
            put_char (c);
            put_char (c2);
         }
      }
      else {
         put_char (c);
      }
      c = getc (f);
   }
   fputs ("\"\n", stdout);

   fclose (f);
   return 0;
}

