/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <nsCOMArray.h>
#include <libintl.h>
#include "mwb-gettext.h"

NS_INTERFACE_MAP_BEGIN(MwbGettext)
  NS_INTERFACE_MAP_ENTRY_AMBIGUOUS(nsISupports, MwbIGettext)
  NS_INTERFACE_MAP_ENTRY(MwbIGettext)
NS_INTERFACE_MAP_END

MwbGettext *MwbGettext::gettext_instance = nsnull;

MwbGettext *
MwbGettext::GetSingleton (void)
{
  if (!gettext_instance)
    gettext_instance = new MwbGettext ();

  return gettext_instance;
}

MwbGettext::MwbGettext ()
{
  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
}

MwbGettext::~MwbGettext ()
{
}

NS_IMETHODIMP_(nsrefcnt)
MwbGettext::AddRef ()
{
  return 1;
}

NS_IMETHODIMP_(nsrefcnt)
MwbGettext::Release ()
{
  return 1;
}

/* AUTF8String gettext (in AUTF8String str); */
NS_IMETHODIMP
MwbGettext::Gettext (const nsACString &str, nsACString &retval NS_OUTPARAM)
{
  const char *c_str = str.BeginReading ();
  retval.Assign (nsDependentCString (dgettext (GETTEXT_PACKAGE, c_str)));
  str.EndReading ();

  return NS_OK;
}

/* AUTF8String ngettext (in AUTF8String singular,
                         in AUTF8String plural,
                         in unsigned long count); */
NS_IMETHODIMP
MwbGettext::Ngettext (const nsACString &singular,
                      const nsACString &plural,
                      PRUint32 count,
                      nsACString & retval NS_OUTPARAM)
{
  const char *singular_c_str = singular.BeginReading ();
  const char *plural_c_str = plural.BeginReading ();
  retval.Assign (nsDependentCString (dngettext (GETTEXT_PACKAGE,
                                                singular_c_str,
                                                plural_c_str,
                                                count)));
  plural.EndReading ();
  singular.EndReading ();

  return NS_OK;
}
