/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <nsIGenericFactory.h>
#include <nsIModule.h>
#include "mwb-pages-service.h"
#include "mwb-favicon-loader.h"

NS_GENERIC_FACTORY_SINGLETON_CONSTRUCTOR (MwbPagesService,
                                          MwbPagesService::GetSingleton)
NS_GENERIC_FACTORY_SINGLETON_CONSTRUCTOR (MwbFaviconLoader,
                                          MwbFaviconLoader::GetSingleton)

static const nsModuleComponentInfo
components[] =
{

  {
    "MWB Pages service",
    MWB_PAGES_SERVICE_CID,
    "@moblin.org/mwb-pages-service;1",
    MwbPagesServiceConstructor
  },

  {
    "MWB Favicon Loader",
    MWB_FAVICON_LOADER_CID,
    NS_NETWORK_PROTOCOL_CONTRACTID_PREFIX "mwb-favicon",
    MwbFaviconLoaderConstructor
  }
};

NS_IMPL_NSGETMODULE (MwbPagesModule, components)
