/* mozhelper: A GObject wrapper for the Mozilla Mozhelper API
 *
 * Copyright (C) 2009  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MOZHELPER_ERROR_H__
#define __MOZHELPER_ERROR_H__

#include <glib.h>

G_BEGIN_DECLS

#define MOZHELPER_ERROR (mozhelper_error_quark ())

#define MOZHELPER_ERROR_QUARK_STRING "mozhelper-error-quark"

typedef enum
{
  /* D-BUS glib appears to have an bug which means that these all need
     to be a single word :-/ */
  MOZHELPER_ERROR_XUL,
  MOZHELPER_ERROR_PROXY,
  MOZHELPER_ERROR_NOTAVAILABLE
} MozhelperError;

GQuark mozhelper_error_quark (void);

guint mozhelper_error_to_nsresult (GError *error);

G_END_DECLS

#endif /* __MOZHELPER_ERROR_H__ */
