/*
* libmux - GTK+ Moblin User Experience widgets
 * Copyright (C) 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <gtk/gtk.h>
#include <mux/mux-expander.h>

int
main (int argc, char **argv)
{
  GtkWidget *window, *box, *e;

  gtk_init (&argc, &argv);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_resizable (GTK_WINDOW (window), FALSE);
  g_signal_connect (window,
                    "delete-event",
                    (GCallback)gtk_main_quit,
                    NULL);

  box = gtk_hbox_new (FALSE, 8);
  gtk_container_add (GTK_CONTAINER (window), box);

  e = mux_expander_new ();
  mux_expander_set_state (MUX_EXPANDER (e), GTK_EXPANDER_COLLAPSED);
  gtk_container_add (GTK_CONTAINER (box), e);

  e = mux_expander_new ();
  mux_expander_set_state (MUX_EXPANDER (e), GTK_EXPANDER_SEMI_COLLAPSED);
  gtk_container_add (GTK_CONTAINER (box), e);

  e = mux_expander_new ();
  mux_expander_set_state (MUX_EXPANDER (e), GTK_EXPANDER_SEMI_EXPANDED);
  gtk_container_add (GTK_CONTAINER (box), e);

  e = mux_expander_new ();
  mux_expander_set_state (MUX_EXPANDER (e), GTK_EXPANDER_EXPANDED);
  gtk_container_add (GTK_CONTAINER (box), e);

  gtk_widget_show_all (window);

  gtk_main ();
}
