# Config file for NeTAMS build system.
#
# I have to ship it preconfigured because upstream configuration script doesn't
# allow me to override it's knowledge of file system hierarchy on different
# systems.
#
# So I put common part to debian/Rules.make and kernel-specific things to debian/rules.


PROG += netamsctl ascii2netflow
CONFIG_FILE_NAME = netams.conf
DEFINE += -D_BSD_SOURCE -I/usr/include/pcap -I/usr/libipq -I../lib/libipulog/include
LIB += -pthread -lpcap
INSTALL = /usr/bin/install
STARTUP_SCRIPT=netams.init.d
PATH_TO_ETC=/etc
PATH_TO_WWW=/var/www/netams
PATH_TO_CONFIG=/var/lib/netams
PATH_TO_LOG=/var/log/netams.log
PATH_TO_SCRIPTS=/etc/init.d
DAEMONDIR=/usr/sbin
SBINDIR=/usr/sbin
MANDIR=/usr/share/man
PROG += flowprobe
#Optional params - uncomment if needed
#DEFINE += -DUSE_CLI_ENABLE
DEFINE += -DHAVE_BW
DEFINE += -DFAST_FW_CHECK
DEFINE += -DLAYER7_FILTER
#DEFINE += -DUSE_HASH
DEFINE += -DUSE_MYSQL -I/usr/include/mysql
LIB += -lmysqlclient -L/usr/lib -L/usr/lib/`dpkg-architecture -qDEB_HOST_MULTIARCH`
DEFINE += -DWIPE_OPENSSL -I/usr/include/glib-2.0 -I/usr/lib/`dpkg-architecture -qDEB_HOST_MULTIARCH`/glib-2.0/include
LIB += -lglib-2.0 -L/usr/lib -L/usr/lib/`dpkg-architecture -qDEB_HOST_MULTIARCH`
DEFINE += -DHAVE_BILLING
SRC += billing.c s_billing.c
HEADERFILES += billing.h
DEFINE += -DDEBUG
FLAGS += -g -Wall

DEB_BUILD_ARCH_OS = $(shell dpkg-architecture -qDEB_BUILD_ARCH_OS)

ifeq ($(DEB_BUILD_ARCH_OS),linux)
DEFINE += -DLINUX -I/usr/include/pcap -I/usr/libipq -I../lib/libipulog/include
LIB += -lnetfilter_queue_libipq -L/usr/lib -lipulog -lcrypt
DEFINE += -I/usr/include/libnetfilter_queue
NLIB += libipulog
PROG += ulog2netflow
endif

ifeq ($(DEB_BUILD_ARCH_OS),kfreebsd)
DEFINE += -DFREEBSD
LIB += -lnetgraph
PROG += ipfw2netflow
endif
