#!/usr/bin/perl -w
#
# $Id: cardtool.cgi,v 1.8 2008-01-02 13:29:36 anton Exp $

use DBI;

$url="cardtool.cgi";
$ratefile="ratefile.txt";

require "netams.cgi";
sub CardSummary(); 
sub CardActivate();
sub CardActivate_confirm();
sub CardOperations_confirm();
sub CardDisplayseries_confirm();
sub CardOperations();
sub CardDisplay();
sub CardCheck;
sub CardExport;
sub CardNewSeries();
sub CardSetRate();

$access=CheckAccess("CARD");
if($access<1 or
  ($access<2 and ($action ne "list" and $action ne ""))) {
        NoAccess();
}

$dbh = DBI->connect("DBI:$sql_type:database=$sql_dbname;host=$sql_host", $sql_login, $sql_password);
if ($dbh eq "") { $p1.="<b>Unable to connect to SQL database!</b><hr>"; }


	$toppane = "<b>$L_card_title</b>";

	if ($action eq "activate") {
		CardActivate;
	} elsif ($action eq "operations") {
		CardOperations;
	} elsif ($action eq "displayseries") {
		CardDisplay;
	} elsif ($action eq "export") {
		CardExport;
	} else {
		
		if ($action eq "setrate") { CardSetRate; }

		$i = open(ratefilehandle, $ratefile);
		if ($i == 0) {
			$rate=0;
			$p0 = "<b>$L_card_rate_createfilerequest</b><br><br>";
		} else {
			$rate = <ratefilehandle>;
			close(ratefilehandle);
		}
		
		$sth = $dbh->prepare("SELECT count(1) FROM cards;");
		$sth->execute();
		$retcode=$dbh->err;
		if ($retcode != 0) {
			$p0 .= "<b>$L_card_createtablerequest</b><br><br>";
		}
		
		if ($action eq "activate_confirm") { CardActivate_confirm; }
		if ($action eq "operations_confirm") { CardOperations_confirm; }
		if ($action eq "displayseries_confirm") { CardDisplayseries_confirm; }
		if ($action eq "newseries") { CardNewSeries; }
		

		# default operations selector
		
		$p1 =  "<table border=1 cellpadding=3 cellspacing=0 width=100%><tr bgcolor=#e0e0e0><td colspan=9><b>$L_card_activate</b></td></tr>\n";
		$p1 .="<tr bgcolor=#d0d0d0 align=left><td>
			<b>$L_card_number:</b> <input type=text size=12 name=number>&nbsp;&nbsp;&nbsp;
			<b>$L_card_pin:</b> <input type=text size=25 name=pin>&nbsp;&nbsp;&nbsp;
			<b>$L_card_account:</b> <input type=text size=25 name=account>&nbsp;&nbsp;&nbsp;
			<input type=hidden name=action value=activate>
			<input type=submit value=\"$L_Btn_apply\">
			</td></tr></table></form>\n";
			
		$p2 =  "<form name=admintool action=$url method=post>\n";
		$p2 .= "<table border=1 cellpadding=3 cellspacing=0 width=100%><tr bgcolor=#e0e0e0><td colspan=9><b>$L_card_oper</b></td></tr>\n";
		$p2 .="<tr bgcolor=#d0d0d0 align=left><td>
			<b>$L_card_number:</b> <input type=text size=12 name=number>&nbsp;&nbsp;&nbsp;
			<input type=hidden name=action value=operations>
			<input type=submit value=\"$L_Btn_apply\">
			</td></tr></table></form>\n";
	
		if ($retcode == 0) { $card_summary = CardSummary; }
		$p3 =  "<table border=1 cellpadding=3 cellspacing=0 width=100%><tr bgcolor=#e0e0e0><td colspan=9><b>$L_card_summary_s</b></td></tr>\n";
		$p3 .="<tr bgcolor=#d0d0d0 align=center>
		<td><b>$L_card_series</b></td>
		<td><b>$L_card_date</b></td>
		<td><b>$L_card_nominal</b></td>
		<td><b>$L_card_total</b></td>
		<td><b>$L_card_activ</b></td>
		<td><b>$L_card_block</b></td>
		<td><b>$L_card_nonactiv</b></td>
		<td><b>$L_card_balance</b></td></tr>$card_summary</table><br>\n";
	
		$p4 = "<form name=admintool action=$url method=post>\n";
		$p4 .="<table border=1 cellpadding=3 cellspacing=0 width=100%><tr bgcolor=#e0e0e0><td colspan=9><b>$L_card_new_s</b></td></tr>\n";
		$p4 .="<tr bgcolor=#d0d0d0 align=left><td><b>$L_card_series:</b> ".($last_series_number+1)." &nbsp;&nbsp;&nbsp;
			<b>$L_card_nominal: (1-10000)</b> <input type=text size=12 name=nominal>&nbsp;&nbsp;&nbsp;
			<b>$L_card_total: (10-1000)</b> <input type=text size=12 name=total>&nbsp;&nbsp;&nbsp;
			<input type=hidden name=action value=newseries>
			<input type=hidden name=lastseries value=$last_series_number>
			<input type=submit value=\"$L_Btn_apply\">
			</td></tr></table></form>\n";
			
		$p5  ="<form name=admintool action=$url method=post>\n";
		$p5 .="<table border=1 cellpadding=3 cellspacing=0 width=100%><tr bgcolor=#e0e0e0><td colspan=9><b>$L_card_rate</b></td></tr>\n";
		$p5 .="<tr bgcolor=#d0d0d0 align=left><td><b>$L_card_rate_current:</b>
			<input type=text size=5 name=newrate value='$rate'><b>$L_card_rate_current_desc</b> &nbsp;&nbsp;&nbsp;
			<input type=hidden name=action value=setrate>
			<input type=submit value=\"$L_card_rate_new\">
			</td></tr></table>\n";
	}

	$rightdata = "$p0 $p1 $p2 $p3 $p4 $p5"; 

netams_print();
################################################
sub CardSummary() {

	$sth = $dbh->prepare("SELECT series,nominal,time_c FROM cards GROUP BY series;");
	$sth->execute();
	while ( ($series,$nominal,$time_c) = $sth->fetchrow_array) {
		$s_nominal{$series}=$nominal;
		$s_time_c{$series}=$time_c;
	}

	$last_series_number=0;

	foreach $k (sort { $a <=> $b; } keys %s_nominal) {
		$sth = $dbh->prepare("SELECT count(status), status FROM cards WHERE series=$k GROUP BY status;");
		$sth->execute();
		$values_ok{$k}=$values_block{$k}=$values_active{$k}=0;
		while ( ($v,$status) = $sth->fetchrow_array) {
			if ($status eq "OK") { $values_ok{$k} = $v }
			elsif ($status eq "BLOCKED") { $values_block{$k} = $v }
			elsif ($status eq "ACTIVE") { $values_active{$k} = $v }
			$values{$k}+=$v;
		}
	}
	$res='';
	foreach $k (sort { $a <=> $b; } keys %s_nominal) {
		$balance = $s_nominal{$k}*$values_active{$k}."/".$s_nominal{$k}*$values{$k};
		$res .= "<tr align=left>";
		$res .="<td><a href=\"$url?action=displayseries&series=$k\">$k</a></td><td>".mlocaltime($s_time_c{$k})."</td><td>$s_nominal{$k}</td><td>$values{$k}</td><td>$values_active{$k}</td>";
		$res .="<td>$values_block{$k}</td><td>$values_ok{$k}</td>";
		$res .="<td>$balance</td></tr>\n";
		$last_series_number=$k;
	}
	
	return $res;
}

################################################
sub CardActivate() {
	$number=$cgi->param('number');
	#$number=~s/-//g;
	$pin=$cgi->param('pin'); if ($pin eq '') { $pin='-'; }
	#$pin=~s/-//g;
	$account=$cgi->param('account');
	CardCheck($number, $pin);
	if ($status == 1) {	$status_c="green"; } else { $status_c="red"; }
	$card_date=mlocaltime($time_c);
	$card_date2=mlocaltime($time_a);
	
	getAccounts();
	$aid = $account{$account};
	$balance=$balance{$aid};
	
	$p1 =  "<table border=1 cellpadding=3 cellspacing=0 width=100%><tr bgcolor=#e0e0e0><td colspan=2><b>$L_card_activate</b></td></tr>\n";
	$p1 .= "<tr align=left><td bgcolor=#d0d0d0><b>$L_card_number:</b></td><td width=1000>$number</td></tr>";
	$p1 .= "<tr align=left><td bgcolor=#d0d0d0><b>$L_card_pin:</b></td><td>$pin</td></tr>";
	if ($aid ne '') {
		$p1 .= "<tr align=left><td bgcolor=#d0d0d0><b>$L_card_account:</b></td><td>$account ($L_card_accountbalance=$balance)</td></tr>";
	} else {
		$p1 .= "<tr align=left><td bgcolor=#d0d0d0><b>$L_card_account:</b></td><td>$account ($L_card_account_notfound)</td></tr>";
	}
	$p1 .= "<tr align=left><td bgcolor=#d0d0d0><b>$L_card_status:</b></td><td><font color=$status_c><b>$status_s</b></font></td></tr>";
	if ($status >= 1) {
		$p1 .= "<tr align=left><td bgcolor=#d0d0d0><b>$L_card_nominal:</b></td><td>$nominal</td></tr>";
		$p1 .= "<input type=hidden name=nominal value=\"$nominal\">";
		$p1 .= "<tr align=left><td bgcolor=#d0d0d0><b>$L_card_date:</b></td><td>$card_date</td></tr>";
		if ($status == 2) { $p1 .= "<tr align=left><td bgcolor=#d0d0d0><b>$L_card_activ:</b></td><td>$card_date2</td></tr>"; }
		if ($status == 3) { $p1 .= "<tr align=left><td bgcolor=#d0d0d0><b>$L_card_blocked:</b></td><td>$card_date2</td></tr>"; }
	}
	$p1 .= "<tr bgcolor=#e0e0e0 align=left><td colspan=2><input type=hidden name=action value=activate_confirm> 
		<input type=hidden name=number value=\"$number\">
		<input type=hidden name=pin value=\"$pin\">
		<input type=hidden name=account value=\"$account\">
		<input type=hidden name=status value=\"$status\">
		<input type=submit name=btn_rollback value=\"$L_card_rollback\">&nbsp;&nbsp;&nbsp;";
	if ($status == 1 and $aid ne '') {
		$p1.=" <input type=submit name=btn_apply value=\"$L_Btn_apply\">";
		}
		$p1.="</td></tr></table>\n";
}
################################################
sub CardActivate_confirm() {
	if ($cgi->param('btn_apply') ne '') {
		$number=$cgi->param('number');
		$pin=$cgi->param('pin');
		$account=$cgi->param('account');
		$nominal=$cgi->param('nominal');

		$nominal_u = ($nominal+0)/($rate+0);

		netams_cmds(("enable", "configure terminal", "service billing", "account ".$account." balance add $nominal_u", "exit", "exit", "disable"));

		$author_x="[".$ENV{"REMOTE_USER"}."] for $account (".$ENV{"REMOTE_ADDR"}.")";

		$rows_affected = $dbh->do("UPDATE cards SET status='ACTIVE', time_a=UNIX_TIMESTAMP(), author=\"$author_x\" WHERE number='$number' and pin='$pin';");
		if ($rows_affected == 1) {
			$p0 = "<b>$L_card_activate:</b> $L_card_activ<br><br>";
			LOG("card $number (value=$nominal) activated for $account");
		} else {
			$p0 = "<b>$L_card_activate:</b> $L_card_internalerror<br><br>";
		}
	}
}
################################################
sub CardOperations() {
	$number=$cgi->param('number');
	CardCheck($number, '');
	if ($status == 1) {	$status_c="green"; } else { $status_c="red"; }
	$card_date=mlocaltime($time_c);
	$card_date2=mlocaltime($time_a);
	
	$p1 =  "<table border=1 cellpadding=3 cellspacing=0 width=100%><tr bgcolor=#e0e0e0><td colspan=2><b>$L_card_oper</b></td></tr>\n";
	$p1 .= "<tr align=left><td bgcolor=#d0d0d0><b>$L_card_number:</b></td><td width=1000>$number</td></tr>";
	$p1 .= "<tr align=left><td bgcolor=#d0d0d0><b>$L_card_status:</b></td><td><font color=$status_c><b>$status_s</b></font></td></tr>";
	if ($status >= 1) {
		$p1 .= "<tr align=left><td bgcolor=#d0d0d0><b>$L_card_nominal:</b></td><td>$nominal</td></tr>";
		$p1 .= "<input type=hidden name=nominal value=\"$nominal\">";
		$p1 .= "<tr align=left><td bgcolor=#d0d0d0><b>$L_card_date:</b></td><td>$card_date</td></tr>";
		$p1 .= "<tr align=left><td bgcolor=#d0d0d0><b>$L_card_lastoperator:</b></td><td>$author</td></tr>";
		if ($status == 2) { $p1 .= "<tr align=left><td bgcolor=#d0d0d0><b>$L_card_activ:</b></td><td>$card_date2</td></tr>"; }
		if ($status == 3) { $p1 .= "<tr align=left><td bgcolor=#d0d0d0><b>$L_card_blocked:</b></td><td>$card_date2</td></tr>"; }
	}
	$p1 .= "<tr bgcolor=#e0e0e0 align=left><td colspan=2><input type=hidden name=action value=operations_confirm> 
		<input type=hidden name=number value=\"$number\">
		<input type=hidden name=status value=\"$status\">
		<input type=submit name=btn_rollback value=\"$L_card_rollback\">&nbsp;&nbsp;&nbsp;";
	if ($status == 3) {
		$p1.=" <input type=submit name=btn_unblock value=\"$L_card_do_unblock\">";
	} elsif ($status == 1) {
		$p1.=" <input type=submit name=btn_block value=\"$L_card_do_block\">";
	} 
		$p1.="</td></tr></table>\n";

}
################################################
sub CardOperations_confirm() {
	$s_set='';
	if ($cgi->param('btn_unblock') ne '') { $s_set='OK'; }
	elsif ($cgi->param('btn_block') ne '') { $s_set='BLOCKED'; } 
	if ($s_set ne '') {
		$number=$cgi->param('number');
		$author_x="[".$ENV{"REMOTE_USER"}."] (".$ENV{"REMOTE_ADDR"}.")";
		$rows_affected = $dbh->do("UPDATE cards SET status='$s_set', time_a=UNIX_TIMESTAMP(), author=\"$author_x\" WHERE number='$number';");
		if ($rows_affected == 1) {
			$p0 = "<b>$L_card_oper:</b> $L_card_ok<br><br>";
			LOG("card $number operation $s_set");
		} else {
			$p0 = "<b>$L_card_oper:</b> $L_card_internalerror<br><br>";
		}
	}
}
################################################
sub CardDisplay() {
	CardSummary;
	$series=$cgi->param('series');
	$balance = $s_nominal{$series}*$values_active{$series}."/".$s_nominal{$series}*$values{$series};
	$p3 =  "<table border=1 cellpadding=3 cellspacing=0 width=100%><tr bgcolor=#e0e0e0><td colspan=2><b>$L_card_summary_s</b></td></tr>\n";
	$p3 .="<tr><td bgcolor=#d0d0d0><b>$L_card_series</b></td><td width=1000>$series</td></tr>";
	$p3 .="<tr><td bgcolor=#d0d0d0><b>$L_card_date</b></td><td>".mlocaltime($s_time_c{$series})."</td></tr>";
	$p3 .="<tr><td bgcolor=#d0d0d0><b>$L_card_nominal</b></td><td>$s_nominal{$series}</td></tr>";
	$p3 .="<tr><td bgcolor=#d0d0d0><b>$L_card_total</b></td><td>$values{$series}</td></tr>";
	$p3 .="<tr><td bgcolor=#d0d0d0><b>$L_card_activ</b></td><td>$values_active{$series}</td></tr>";
	$p3 .="<tr><td bgcolor=#d0d0d0><b>$L_card_block</b></td><td>$values_block{$series}</td></tr>";
	$p3 .="<tr><td bgcolor=#d0d0d0><b>$L_card_nonactiv</b></td><td>$values_ok{$series}</td></tr>";
	$p3 .="<tr><td bgcolor=#d0d0d0><b>$L_card_balance</b></td><td>$balance</td></tr>";
	$p3 .="<tr bgcolor=#e0e0e0><td colspan=2><input type=submit name=btn_rollback value=\"$L_card_rollback\">&nbsp;&nbsp;&nbsp;";
	$p3 .="<input type=submit name=btn_blockall value=\"$L_card_do_block $L_card_allseries\">&nbsp;&nbsp;&nbsp;\n";
	$p3 .="<input type=submit name=btn_unlblockall value=\"$L_card_do_unblock $L_card_allseries\">&nbsp;&nbsp;&nbsp;\n";
	$p3 .="<input type=submit name=btn_deleteall value=\"$L_card_do_delete $L_card_allseries\">\n";
	$p3 .="<input type=hidden name=action value=displayseries_confirm><input type=hidden name=series value='$series'></td></tr>";
	$p3 .="<tr bgcolor=#e0e0e0><td colspan=2><input type=button value=\"$L_card_do_export\" onclick=\"window.open('$url?action=export&series=$series');\"></td></tr></table><br>";
	
	$p4 =  "<table border=1 cellpadding=3 cellspacing=0 width=100%><tr bgcolor=#e0e0e0><td><b>$L_card_number</b></td><td><b>$L_card_status</b></td><td><b>$L_card_lastaction</b></td><td><b>$L_card_lastoperator</b></td></tr>\n";
	$sth = $dbh->prepare("SELECT number,status,time_a,author FROM cards WHERE series='$series';");
	$sth->execute();
	while ( ($number,$status,$time_a,$author) = $sth->fetchrow_array) {
		$t='&nbsp;'; $x=''; $y='';
		if ($author eq '') { $author='&nbsp;'; }
		if ($status eq "OK") { $status_s =$L_card_confirm;  }
		elsif ($status eq "BLOCKED") { $status_s = $L_card_blocked; $t=mlocaltime($time_a); }
		elsif ($status eq "ACTIVE") { $status_s = $L_card_alreadyactive; $t=mlocaltime($time_a); }
		if ($status eq "OK" or $status eq "BLOCKED") { $x="<a href=\"$url?action=operations&number=$number\">"; $y='</a>'; }
		$p4.="<tr><td>$x$number$y</td><td>$status_s</td><td>$t</td><td>$author</td></tr>\n";
	}
	$p4 .="</table>\n";	
	
}
################################################
sub CardDisplayseries_confirm() {
	$series=$cgi->param('series');
	if ($cgi->param('btn_blockall') ne '') { 
		$rows_affected = $dbh->do("UPDATE cards SET status='BLOCKED', time_a=UNIX_TIMESTAMP() WHERE series='$series' AND status='OK';");
		$p0 = "<b>$L_card_do_block $L_card_allseries </b>: $rows_affected $L_card_ok<br><br>";
	}
	if ($cgi->param('btn_unlblockall') ne '') { 
		$rows_affected = $dbh->do("UPDATE cards SET status='OK', time_a=UNIX_TIMESTAMP() WHERE series='$series' AND status='BLOCKED';");
		$p0 = "<b>$L_card_do_unblock $L_card_allseries </b>: $rows_affected $L_card_ok<br><br>";
	} 
	if ($cgi->param('btn_deleteall') ne '') { 
		$rows_affected = $dbh->do("DELETE FROM cards WHERE series='$series';");
		$p0 = "<b>$L_card_do_delete $L_card_allseries </b>: $rows_affected $L_card_ok<br><br>";
	}
}
################################################
sub CardNewSeries() {
	$nominal=0+$cgi->param('nominal');
	$total=0+$cgi->param('total');
	$lastseries=1+$cgi->param('lastseries');
	$author_x="[".$ENV{"REMOTE_USER"}."] (".$ENV{"REMOTE_ADDR"}.")";
	$p0 = "<b>$L_card_new_s:</b> ";
	if ( ($nominal<1 or $nominal>10000) or ($total<10 or $total>1000) or ($lastseries<0) ) {
		$p0.= "$L_card_wrongparameters: $nominal, $total, $lastseries <br>\n";
	} else {
		open($randomfile, '/dev/random');
		for ($i=1; $i<=$total; $i++) {
			srand((ord getc $randomfile)*(ord getc $randomfile)*(ord getc $randomfile));
			$number=sprintf "%03u%07u", $lastseries, rand(10000000);
			for ($k=0; $k<4; $k++) { $pin[$k]=rand(100000); }
			$pin=sprintf "%05d-%05d-%05d-%05d", @pin;
			#$p0.="$i $lastseries $number $pin $seed <br>";	
			$rows_affected = $dbh->do("INSERT INTO cards VALUES ($lastseries, ".($number+0).", $nominal, \"$pin\", 'OK', UNIX_TIMESTAMP(), 0, \"$author_x\");");
			if ($rows_affected ==0) { $total++; } else { $total_ok++; }
		}
		close($randomfile);
		$p0.="$total_ok $L_card_cardscreated $lastseries<br>\n";
	}
	$p0.="<br>";
}
################################################
sub CardCheck() {
	$number=shift;
	$pin=shift;
	#$nominal=''; $time_c=''; $time_a='';
	# 0=notfound, 1=ok, 2=activated, 3=blocked, -1=error
	if ($pin ne '') { 
		$sth = $dbh->prepare("SELECT nominal,status,time_c,time_a,author FROM cards WHERE number='$number' and pin='$pin';");
	} else {
		$sth = $dbh->prepare("SELECT nominal,status,time_c,time_a,author FROM cards WHERE number='$number';");
	}
	$sth->execute();
	@result=$sth->fetchrow_array;
	if ( $sth->rows == 0 ) {
		$status_s = "$L_card_notfound"; 
		$status=0;
	} elsif ($sth->rows > 1 ) {
		$status_s = "$L_card_internalerror"; 
		#print STDERR "result=@result \n";
		$status=-1;
	} else {
		($nominal,$status_o,$time_c,$time_a,$author) = @result;
		#print STDERR "$nominal,$status_o,$time_c,$time_a\n";
		if ($status_o eq 'OK') { $status=1; $status_s=$L_card_confirm; }
		elsif ($status_o eq 'ACTIVE') { $status=2; $status_s=$L_card_alreadyactive; }
		elsif ($status_o eq 'BLOCKED') { $status=3; $status_s=$L_card_blocked; }
		if ($author eq '') { $author='&nbsp;'; }
	}		
	
}
################################################
sub CardExport(){
	$series=$cgi->param('series');
	$sth = $dbh->prepare("SELECT number,pin,nominal,time_a FROM cards WHERE series='$series';");
	$sth->execute();
	# print $cgi->header(-nph=>1, -type=>'text/plain', -attachment=>"prepaid_series_$series.txt");
	while ( ($number,$pin,$nominal) = $sth->fetchrow_array) {
		$number=sprintf "%010u",$number;
		print "$number,$pin,$nominal<br>\n";
	}
	exit(0);
}
################################################
sub CardSetRate(){
	$newrate=$cgi->param('newrate');
	if ($newrate ne '' and $newrate>0 and $newrate<10000) {
		
	open(ratefilehandle, ">$ratefile") or die();
	print ratefilehandle "$newrate\n" ;
	close(ratefilehandle);
	LOG("exchange rate is set to $newrate from ".$cgi->remote_host());

	$p0="<b>$L_card_rate:</b> $L_card_ok ($newrate)<br><br>";
	}
	
}
################################################


