/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: bw.h,v 1.17 2008-02-23 08:35:03 anton Exp $ */

#ifdef HAVE_BW

struct entry;
typedef struct BWdata BWdata;
typedef struct bwUlist bwUlist;

//this is per ds
#define BW_HASH_SIZE   0x4000
#define BW_HASH_MASK   (BW_HASH_SIZE-1)
#define BW_HASH(ptr)   ((unsigned long)ptr>>4)&BW_HASH_MASK

class BWEngine {
	public:

		//BWData
		unsigned bwd_used;
		unsigned bwd_total;
		BWdata *bwdReady;	
		
		//bwUlist 
		unsigned bwu_used;
		unsigned bwu_total;
		bwUlist *bwuReady;

		BWdata **table;
		
		BWEngine();
		~BWEngine();

		void AddBW2entry(BWinfo *bwi, entry *e, match mf, void *key);
		void FreeBWentry(entry *e);
};

typedef struct BWdata {
	void *key;
	
	unsigned long limit_in;
	unsigned long limit_out;

	unsigned num_flows;
		
	unsigned long end_t[2];
	unsigned long total_bytes[2];
	
	BWdata* next;

	//probably need to add reference to object from where we get *BWinfo
} __attribute__((packed)) BWdata;

typedef struct bwUlist {
	match mf; //this necessary do detect flow derection for connected unit
	bwUlist *next;
	BWdata *bwd;
} __attribute__((packed)) bwUlist;

u_char BWCheck(entry *e, u_long size, struct timeval *tv);

#endif
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
