/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: ds_any.h,v 1.7 2009-08-01 09:23:55 anton Exp $ */

#include "iptree.h"
#include "bw.h"
#include "flowengine.h"
#include "netflow.h"

/////////////////////////////////////////////////////////////////////////
#define LAYER7_DETECT_NONE	0
#define LAYER7_DETECT_URLS	1

// data-source service functions
#define  MAX_PKT_SIZE    0xffff

//we need this for netflow time syncronization
enum ds_flag 	{ DS_NONE=0, DS_CLOCK_REMOTE, DS_DIVERT, DS_TEE, DS_PROMISC, DS_IPQ, DS_ULOG, DS_NETGRAPH, DS_RAW };

/////////////////////////////////////////////////////////////////////////
typedef struct ds_rule {
	u_short number;
	char *rule_str;
	ds_rule *next;
} ds_rule;

typedef struct NFSource {
	in_addr_t 			src_addr;
	u_int32_t			engine_id;
	u_int32_t 			seq_id;
	u_int64_t			flows;
	u_int64_t			packets;
	u_int16_t			errors;
	u_int32_t			timestamp;
	struct NetFlowV9Template	**nfTemplate;
	u_short				nfTemplate_num;
	NFSource			*next;
} NFSource;

#define LOAD_INTERVAL		1	//in seconds for avg calculating
//////////////////////////////////////////////////////////////////////////////////////////
// maximum length of stored URL (layer7 filter) 
#define LAYER7_MAX_URL 80
void layer7_addinfo(u_int16_t port, entry *flow_entry); 
void layer7_checkinfo(u_int16_t port, entry *flow_entry, struct ip *ip);
void layer7_freeinfo(Flow *flow);
/////////////////////////////////////////////////////////////////////////
class Service_DS: public Service_Datasource_Interface {
	public:
		ds_flag ds_flags;

		policy_target_type pt_type;
		unsigned long long total_flows;
		unsigned long long total_packets;
		unsigned total_errors;
		long timestamp;

		char *src_cmd;
		ds_rule *root;

		u_char max_flow_slots;

		unsigned long delay; //cumulative delay in microseconds accumulated for all packets
		unsigned skewdelay; // measured in microseconds and based on previous value

		//pXX (previous) used to store previous counters and actually shown
		unsigned        ppc, pc;
		u_long          pbc, bc;
		time_t          ptc, tc;
		
		void *pcap_data;                //for libpcap

#ifndef WIPE_OPENSSL
		LHASH *ds_raw_hash;
#else
		GHashTable *ds_raw_hash;
#endif
		
		struct in_addr l_addr;          //address from we listen for netflow packets

		//shouldn't be in union because it's beginning of list
		NFSource *nfroot; // netflow: list of netflow sources we are serving

		union {
			unsigned nlmask; //for ulog
			unsigned port;
		};

		class IPTree            *IPtree;
		class FlowEngine        *FE;
		EngineMsg               *msg;
		Flow                    *ds_flow;       //for childs(if necessary)
		class DS_FIFO           *ds_fifo;
		
		u_char *packet;
		unsigned layer7_detect;
		
		void	(*ds_func)(Service_DS*);
		Service *child;
		
		Service_DS();
		~Service_DS();
		
		void ShowCfg(struct cli_def *cli, u_char flags);
		int ProcessCfg(struct cli_def *cli, char **argv, int argc, u_char no_flag);
		void ShowInfo(struct cli_def *cli);
		void ShowPerf(struct cli_def *cli, u_char isheader);
		void Worker();
		void Cancel();
		
		void AcctFlows();	
		unsigned Measure(struct timeval *start, unsigned len);

		//interface calls
		int unit2ds(unsigned addr,u_char mask,NetUnit *u,u_char flag);
};
/////////////////////////////////////////////////////////////////////////
