/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: ng_netams.h,v 1.17 2008-02-23 08:35:02 anton Exp $ */

// netgraph kernel module-related stuff
#define NG_NETAMS_NODE_TYPE	"netams"
#define NG_NETAMS_COOKIE	1105380011
#define NG_NETAMS_HOOK_IF_IN	"if_in"
#define NG_NETAMS_HOOK_IF_OUT	"if_out"

#define NG_NETAMS_MODE_TEE	1
#define NG_NETAMS_MODE_DIVERT	2

#define NG_NETAMS_DEFAULT_DROP	1
#define NG_NETAMS_DEFAULT_PASS	2
#define NG_NETAMS_DEFAULT_PASS_SSH_LOCAL	3
#define NG_NETAMS_DEFAULT_TIMEOUT	2 /*in seconds*/

#define	NG_NETAMS_INFO_TYPE	{ \
	{ "packets/in",	&ng_parse_uint32_type },\
	{ "packets/out",	&ng_parse_uint32_type },\
	{ "mode",		&ng_parse_uint32_type },\
	{ "debug",		&ng_parse_uint32_type },\
	{ "active_flows",		&ng_parse_uint32_type },\
	{ "total_flows",		&ng_parse_uint32_type },\
	{ "queued_flows",		&ng_parse_uint32_type },\
	{ "queued_bytes",		&ng_parse_uint32_type },\
	{ "queued_packets",		&ng_parse_uint32_type },\
	{ "blocked_flows",		&ng_parse_uint32_type },\
	{ "default_policy",		&ng_parse_uint32_type },\
	{ NULL }					\
}

enum {
    NG_NETAMS_INFO = 1,
    NG_NETAMS_SETMODE = 2,
    NG_NETAMS_REGISTER = 3,
    NG_NETAMS_DATA = 4,
    NG_NETAMS_FWREQUEST = 5,
    NG_NETAMS_FWREPLY = 6,
    NG_NETAMS_DEBUG = 7,
    NG_NETAMS_SETDEFAULT = 8,
};

struct ng_netams_info {
	u_int32_t	packets_in;
	u_int32_t	packets_out;
	u_int32_t	mode;
	u_int32_t	debug;
	u_int32_t	active_flows;
	u_int32_t	total_flows;
	u_int32_t	queued_flows;
	u_int32_t	queued_bytes;
	u_int32_t	queued_packets;
	u_int32_t	blocked_flows;
	u_int32_t	default_policy;
};

enum fwdecision {
	NG_NETAMS_FW_DROP=0,
	NG_NETAMS_FW_PASS,
	NG_NETAMS_FW_QUEUE,
};

/* Make sure packet large enough to contain len bytes */
#define	CHECK_MLEN(m, length)	((m)->m_pkthdr.len < (length))
#define CHECK_PULLUP(m, length)	((m)->m_len < (length) && \
				(((m) = m_pullup((m),(length))) == NULL))

/////////////////////////////////////////////////////////////////////////////////////
// flow management

#define NG_ACTIVE_TIMEOUT 		60 
#define NG_INACTIVE_TIMEOUT	60 

//protection against DoS
#define NG_MAX_CHUNK				64 
#define NG_MAX_QUEUE_BYTES			8*1024 
#define NG_MAX_QUEUE_PACKETS		128
#define NG_MAX_TOTAL_QUEUED_PACKETS		1024 
#define NG_MAX_TOTAL_QUEUED_BYTES		64*1024 
#define NG_MAX_TOTAL_QUEUED_FLOWS	128

#define NG_IPV4_HASH_SIZE  0x400
#define NG_IPV4_HASH_MASK 	(NG_IPV4_HASH_SIZE-1)

//old - symmetric
#define NG_IPV4_HASH(addr1, addr2, port1, port2, proto) ((((addr1) + (addr2)) + (port1) + (port2)+ (proto))& NG_IPV4_HASH_MASK)
//new - assymentric
#define NG_IPV4_ADDR_HASH(addr1,addr2)	(((addr1 >> 16) ^ (addr2 & 0xFFFF) ) & NG_IPV4_HASH_MASK)
#define NG_IPV4_FULL_HASH(addr1, addr2, port1, port2) 	(((addr1 >> 16) ^ (addr2 & 0xFFFF) ^ ((port1 ^ port2)) )& NG_IPV4_HASH_MASK)

typedef struct ng_queue_item {
	void *i; // this is item_p
	struct ng_queue_item *next;
} ng_queue_item;

typedef struct ng_entry {
	struct in_addr srcaddr;    /* Source IP Address */
	struct in_addr dstaddr;    /* Destination IP Address */
	struct in_addr nexthop;    /* Next hop router's IP Address */
	u_short input;          /* Input interface index */
	u_short output;         /* Output interface index */

	unsigned long dPkts;           /* Packets sent in Duration */
	unsigned long dOctets;         /* Octets sent in Duration. */
	unsigned long First;           /* SysUptime at start of flow */
	unsigned long Last;            /* and of last packet of flow */

	unsigned short srcport;        /* TCP/UDP source port number or equivalent */
	unsigned short dstport;        /* TCP/UDP destination port number or equivalent */
//	unsigned char pad;
//	unsigned char tcp_flags;      /* Cumulative OR of tcp flags */
	unsigned char prot;           /* IP protocol, e.g., 6=TCP, 17=UDP, ... */
	unsigned char tos;            /* IP Type-of-Service */

	unsigned id;
	unsigned hash;
	u_char flags;   //EXPIRED,BLOCKED etc in userspace, "fwdecision" in kernel
	struct ng_entry *next;
	struct ng_entry *next_active;
	ng_queue_item *queue;
	ng_queue_item *queue_last;
	unsigned queue_bytes;
	unsigned queue_packets;
	void *sendhook; // we have no hook_p at userspace;
	
} ng_entry;
