/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.qa.form;

import javax.swing.JDialog;
import org.netbeans.jemmy.operators.*;

/**
 * Class implementing all necessary methods for handling "Border Custom Editor" NbDialog.
 * Most parts of code are generated by jelly tools.
 *
 * @author Jiri Vagner
 */
public class BorderCustomEditorOperator extends JDialogOperator {

    /**
     * Creates new instance using dialog name
     */
    public BorderCustomEditorOperator(String title) {
        super(title);
    }

    /**
     * Creates new instance using existing JDialog operator
     */
    public BorderCustomEditorOperator(JDialogOperator wrapper) {
        super((JDialog)wrapper.getSource());
    }

    public static final String ITEM_BORDEREDITOR = "Border Editor"; // NOI18N
    public static final String ITEM_FORMCONNECTION = "Form Connection"; // NOI18N
    public static final String ITEM_NOBORDER = "(No Border)"; // NOI18N
    public static final String ITEM_BEVELBORDER = "BevelBorder"; // NOI18N
    public static final String ITEM_COMPOUNDBORDER = "CompoundBorder"; // NOI18N
    public static final String ITEM_EMPTYBORDER = "EmptyBorder"; // NOI18N
    public static final String ITEM_ETCHEDBORDER = "EtchedBorder"; // NOI18N
    public static final String ITEM_LINEBORDER = "LineBorder"; // NOI18N
    public static final String ITEM_MATTEBORDER = "MatteBorder"; // NOI18N
    public static final String ITEM_SOFTBEVELBORDER = "SoftBevelBorder"; // NOI18N
    public static final String ITEM_TITLEDBORDER = "TitledBorder"; // NOI18N
    public static final String ITEM_UNKNOWNBORDERBORDERUIRESOURCE$COMPOUNDBORDERUIRESOURCE =
            "Unknown Border (BorderUIResource$CompoundBorderUIResource)";  // NOI18N

    private JComboBoxOperator _cboSelectMode;
    private JLabelOperator _lblSelectMode;
    private JSplitPaneOperator _sppJSplitPane;
    private JLabelOperator _lblAvailableBorders;
    private JListOperator _lstAvailableBorders;
    private JSplitPaneOperator _sppJSplitPane2;
    private JTextAreaOperator _txtDescription;
    private JLabelOperator _lblUnknownBorderBorderUIResource$CompoundBorderUIResource;
    private JButtonOperator _btJButton;
    private JButtonOperator _btAdvanced;
    private JButtonOperator _btOK;
    private JButtonOperator _btCancel;

    //******************************
    // Subcomponents definition part
    //******************************

    /** Tries to find null JComboBox in this dialog.
     * @return JComboBoxOperator
     */
    public JComboBoxOperator cboSelectMode() {
        if (_cboSelectMode==null) {
            _cboSelectMode = new JComboBoxOperator(this);
        }
        return _cboSelectMode;
    }

    /** Tries to find "Select Mode:" JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblSelectMode() {
        if (_lblSelectMode==null) {
            _lblSelectMode = new JLabelOperator(this, "Select Mode:"); // NOI18N
        }
        return _lblSelectMode;
    }

    /** Tries to find null JSplitPane in this dialog.
     * @return JSplitPaneOperator
     */
    public JSplitPaneOperator sppJSplitPane() {
        if (_sppJSplitPane==null) {
            _sppJSplitPane = new JSplitPaneOperator(this);
        }
        return _sppJSplitPane;
    }

    /** Tries to find "Available Borders" JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblAvailableBorders() {
        if (_lblAvailableBorders==null) {
            _lblAvailableBorders = new JLabelOperator(sppJSplitPane(), "Available Borders"); // NOI18N
        }
        return _lblAvailableBorders;
    }

    /** Tries to find null ListView$NbList in this dialog.
     * @return JListOperator
     */
    public JListOperator lstAvailableBorders() {
        if (_lstAvailableBorders==null) {
            _lstAvailableBorders = new JListOperator(sppJSplitPane());
        }
        return _lstAvailableBorders;
    }

    /** Tries to find null JSplitPane in this dialog.
     * @return JSplitPaneOperator
     */
    public JSplitPaneOperator sppJSplitPane2() {
        if (_sppJSplitPane2==null) {
            _sppJSplitPane2 = new JSplitPaneOperator(sppJSplitPane());
        }
        return _sppJSplitPane2;
    }

    /** Tries to find null JTextArea in this dialog.
     * @return JTextAreaOperator
     */
    public JTextAreaOperator txtDescription() {
        if (_txtDescription==null) {
            _txtDescription = new JTextAreaOperator(sppJSplitPane2());
        }
        return _txtDescription;
    }

    /** Tries to find "Unknown Border (BorderUIResource$CompoundBorderUIResource)" JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblUnknownBorderBorderUIResource$CompoundBorderUIResource() {
        if (_lblUnknownBorderBorderUIResource$CompoundBorderUIResource==null) {
            _lblUnknownBorderBorderUIResource$CompoundBorderUIResource = new JLabelOperator(sppJSplitPane2(),
                    "Unknown Border (BorderUIResource$CompoundBorderUIResource)");  // NOI18N
        }
        return _lblUnknownBorderBorderUIResource$CompoundBorderUIResource;
    }

    /** Tries to find null JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btJButton() {
        if (_btJButton==null) {
            _btJButton = new JButtonOperator(sppJSplitPane2());
        }
        return _btJButton;
    }

    /** Tries to find "Advanced..." JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btAdvanced() {
        if (_btAdvanced==null) {
            _btAdvanced = new JButtonOperator(this, "Advanced..."); // NOI18N
        }
        return _btAdvanced;
    }

    /** Tries to find "OK" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btOK() {
        if (_btOK==null) {
            _btOK = new JButtonOperator(this, "OK"); // NOI18N
        }
        return _btOK;
    }

    /** Tries to find "Cancel" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btCancel() {
        if (_btCancel==null) {
            _btCancel = new JButtonOperator(this, "Cancel"); // NOI18N
        }
        return _btCancel;
    }


    //****************************************
    // Low-level functionality definition part
    //****************************************

    /** returns selected item for cboSelectMode
     * @return String item
     */
    public String getSelectedSelectMode() {
        return cboSelectMode().getSelectedItem().toString();
    }

    /** selects item for cboSelectMode
     * @param item String item
     */
    public void selectSelectMode(String item) {
        cboSelectMode().selectItem(item);
    }

    /** gets text for txtDescription
     * @return String text
     */
    public String getDescription() {
        return txtDescription().getText();
    }

    /** sets text for txtDescription
     * @param text String text
     */
    public void setDescription(String text) {
        txtDescription().setText(text);
    }

    /** types text for txtDescription
     * @param text String text
     */
    public void typeDescription(String text) {
        txtDescription().typeText(text);
    }

    /** clicks on null JButton
     */
    public void jButton() {
        btJButton().push();
    }

    /** clicks on "Advanced..." JButton
     */
    public void advanced() {
        btAdvanced().push();
    }

    /** clicks on "OK" JButton
     */
    public void ok() {
        btOK().push();
    }

    /** clicks on "Cancel" JButton
     */
    public void cancel() {
        btCancel().push();
    }

    //*****************************************
    // High-level functionality definition part
    //*****************************************

    /** Performs verification of MyBorderCustomEditorOperator by accessing all its components.
     */
    public void verify() {
        cboSelectMode();
        lblSelectMode();
        sppJSplitPane();
        lblAvailableBorders();
        lstAvailableBorders();
        sppJSplitPane2();
        txtDescription();
        lblUnknownBorderBorderUIResource$CompoundBorderUIResource();
        btJButton();
        btAdvanced();
        btOK();
        btCancel();
    }

}

