/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _HAVE_LAUNCHER_UTIL_H
#define _HAVE_LAUNCHER_UTIL_H

#include <glib.h>
#include <gtk/gtk.h>
#include <clutter/clutter.h>

#include "launcher-menu.h"

gchar** launcher_util_exec_to_argv (const gchar *exec);

GdkPixbuf * get_icon (const gchar *name, guint size);

ClutterActor * launcher_util_texture_new_from_file (const gchar *filename);

ClutterActor * launcher_util_texture_new_from_named_icon (const gchar *name);

void           launcher_util_create_favorite (LauncherMenuApplication *app);
void           launcher_util_remove_favorite (LauncherMenuApplication *app);
void           launcher_util_add_favorite    (const gchar *name,
                                              const gchar *category,
                                              const gchar *exec,
                                              const gchar *icon);

void           launcher_util_present_window (GtkWindow *window);
guint32        launcher_util_present_time   (gulong xid);

void           launcher_util_texture_set_from_pixbuf (ClutterTexture *texture,
                                                      GdkPixbuf      *pixbuf);
ClutterActor * launcher_util_texture_new_from_pixbuf (GdkPixbuf *pixbuf);

gchar        * launcher_util_get_desktop_dir ();


#endif /* _HAVE_LAUNCHER_UTIL_H */
