/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_SIDEBAR_H_
#define _LAUNCHER_SIDEBAR_H_

#include <glib-object.h>
#include <gio/gio.h>
#include <clutter/clutter.h>

#include "launcher-menu.h"

#define LAUNCHER_TYPE_SIDEBAR (launcher_sidebar_get_type ())

#define LAUNCHER_SIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	LAUNCHER_TYPE_SIDEBAR, LauncherSidebar))

#define LAUNCHER_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	LAUNCHER_TYPE_SIDEBAR, LauncherSidebarClass))

#define LAUNCHER_IS_SIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	LAUNCHER_TYPE_SIDEBAR))

#define LAUNCHER_IS_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	LAUNCHER_TYPE_SIDEBAR))

#define LAUNCHER_SIDEBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	LAUNCHER_TYPE_SIDEBAR, LauncherSidebarClass))

typedef struct _LauncherSidebar        LauncherSidebar;
typedef struct _LauncherSidebarClass   LauncherSidebarClass;
typedef struct _LauncherSidebarPrivate LauncherSidebarPrivate;
 
struct _LauncherSidebar
{
  ClutterGroup        parent;	

  LauncherSidebarPrivate *priv;
};

struct _LauncherSidebarClass
{
  ClutterGroupClass   parent_class;

  /*< signals />*/
  void (*category_selected) (LauncherSidebar       *sidebar, 
                             LauncherMenuCategory *category);
  void (*shortcuts_changed) (LauncherSidebar       *sidebar);
};

GType launcher_sidebar_get_type (void) G_GNUC_CONST;

ClutterActor * launcher_sidebar_get_default (void);

void           launcher_sidebar_show_trash (LauncherSidebar *sidebar,
                                            gboolean         show);

GList        * launcher_sidebar_get_places (LauncherSidebar *sidebar);

void           launcher_sidebar_launch_volume (LauncherSidebar *sidebar,
                                               GVolume         *volume);

#endif /* _LAUNCHER_SIDEBAR_H_ */

