#include <ntrack-glib.h>
#include <unistd.h>

static char **args;

static void
try_exec()
{
    if (ntrack_glib_get_state() == NTRACK_GLIB_STATE_ONLINE) 
        execvp(args[0], args);
}


static gboolean
network_event_cb(NTrackGlibEvent event, gpointer user_data)
{
    try_exec();
    return TRUE;
}


int
main(int argc, char **argv)
{
    GMainLoop *main_loop;
    gint i, n_args;
  
    if (argc < 2) {
        g_print("Usage: netlaunch [program] [arg]...\n");
        return 0;
    }

    n_args = argc - 1;
    args = g_malloc(sizeof(char *) * argc);
    for (i = 0; i < n_args; i++)
        args[i] = g_strdup(argv[i+1]);
    args[i] = NULL;

    try_exec();

    ntrack_g_source_add(network_event_cb, NULL);

    main_loop = g_main_loop_new(NULL, FALSE);
    g_main_loop_run(main_loop);
  
    return 1;
}
