#ifndef EDITPROFILEDIALOG_H
#define EDITPROFILEDIALOG_H

#include <wx/notebook.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/checkbox.h>
#include <wx/statbox.h>
#include <wx/panel.h>
#include <wx/button.h>
#include <wx/dialog.h>
#include <wx/combobox.h>
#include <wx/bmpcbox.h>
#include "Profile.h"
#include "net.h"

class EditProfileDialog: public wxDialog
{
	public:

		EditProfileDialog(wxWindow* parent, const ProfileList_t& profile, bool create = false);
		virtual ~EditProfileDialog();

		ProfileList_t GetProfile() const;

    private:
		//(*Declarations(EditProfileDialog)
		wxCheckBox* m_cbNetworkSecrity;
		wxPanel* m_editPanel;
		wxNotebook* m_nbEdit;
		wxButton* m_buttonScan;
		wxStaticText* m_labelWirelessName;
		wxComboBox* m_cbbWirelessType;
//		wxTextCtrl* m_textAuthenType;
		wxCheckBox* m_cbHomepage;
		wxButton* m_buttonApp;
		wxCheckBox* m_cbApp;
		wxButton* m_buttonOK;
		wxComboBox* m_cbbSecType;
		wxStaticText* m_labelConType;
		wxButton* m_buttonDefault;
		wxButton* m_buttonNs;
		wxButton* m_buttonCancel;
		wxStaticBox* m_buttonBrowser;
		wxTextCtrl* m_textSSID;
//		wxCheckBox* m_checkboxAuthen;
		wxPanel* m_generalPanel;
		wxButton* m_buttonSTSettings;
		wxTextCtrl* m_textName;
		wxCheckBox* m_cbDefault;
		wxStaticText* m_textWirelessType;
		wxTextCtrl* m_textHomepage;
//		wxCheckBox* m_checkboxDisable;
		wxPanel* m_othersPanel;
		wxButton* m_buttonProxy;
		wxStaticText* m_labelName;
		wxComboBox* m_cbConType;
		wxStaticText* m_textSecType;
		wxCheckBox* m_cbProxy;
		wxPanel* m_wirelessPanel;
		//*)
		wxBitmap *m_bmpPrfl;
		wxBitmapComboBox* m_cbName;
		ProfileList_t m_profile;
        wxString m_sWepKey;
        wxString m_sWpaKey;
        vector<string> AutoRunApp;

        string m_strForbidShareFileAndPrint;
        string m_strForbidShareInternet;
        string m_strStartWindowFirewall;

        wxString m_strIP;
        wxString m_strSubMask;
        wxString m_strGateWayAddr;
        wxString m_strDNS;

        wxString m_strProxy;
        wxString m_strUserName;
        wxString m_strPassword;
        wxString m_strPort;

        wxStaticText* m_textKey;
        wxStaticText* m_textTip;
        wxTextCtrl* m_tcKey;
        wxStaticText* m_textKeyIdx;
        wxComboBox* m_cbbIndex;

		//(*Identifiers(EditProfileDialog)
		static const long ID_OKBUTTON;
		static const long ID_CANCLEBUTTON;
		static const long ID_NAMESTATICTEXT;
		static const long ID_CONTYPESTATICTEXT;
		static const long ID_NAMETEXTCTRL;
		static const long ID_NAMECOMBOBOX;
		static const long ID_CONTYPECOMBOBOX;
		static const long ID_AUTHCHECKBOX;
		static const long ID_DISABLECHECKBOX;
		static const long ID_AUTHENTYPETEXTCTRL;
		static const long ID_GENERALPANEL;
		static const long ID_WIRELESSNAMESTATICTEXT;
		static const long ID_WIRELESSTYPESTATICTEXT;
		static const long ID_SECTYPESTATICTEXT;
		static const long ID_SSIDTEXTCTRL;
		static const long ID_SCANBUTTON;
		static const long ID_WIRELESSTYPECOMBOBOX;
		static const long ID_SECRITYTYPECOMBOBOX;
		static const long ID_WIRELESSPANEL;
		static const long ID_NETWORKSECRITYCHECKBOX;
		static const long ID_APPCHECKBOX;
		static const long ID_DEFAULTCHECKBOX;
		static const long ID_NSBUTTON;
		static const long ID_APPBUTTON;
		static const long ID_DEFAULTBUTTON;
		static const long ID_PROXYBUTTON;
		static const long ID_BROWSERSTATICBOX;
		static const long ID_HOMEPAGECHECKBOX;
		static const long ID_PROXYCHECKBOX;
		static const long ID_HOMEPAGETEXTCTRL;
		static const long ID_OTHERSPANEL;
		static const long ID_EDITNOTEBOOK;
		static const long ID_EDITPANEL;
		static const long ID_KEYSTATICTEXT;
        static const long ID_TIPSTATICTEXT;
        static const long ID_KEYTEXTCTRL;
		//*)
		static const long ID_HELP;

        wxString m_strOldName;
        bool m_isForCreate;

		void Onm_buttonOKClick(wxCommandEvent& event);
		void Onm_checkboxAuthen1Click(wxCommandEvent& event);
		void Onm_buttonCancelClick(wxCommandEvent& event);
		void Onm_cbbSecTypeSelect(wxCommandEvent& event);
		void Onm_cbNetworkSecrityClick(wxCommandEvent& event);
		void Onm_cbAppClick(wxCommandEvent& event);
		void Onm_cbDefaultClick(wxCommandEvent& event);
		void Onm_cbHomePageClick(wxCommandEvent& event);
		void Onm_cbProxyClick(wxCommandEvent& event);
        void Onm_buttonNsClick(wxCommandEvent& event);
        void Onm_buttonAppClick(wxCommandEvent& event);
        void Onm_buttonDefaultClick(wxCommandEvent& event);
        void Onm_buttonProxyClick(wxCommandEvent& event);
        void Onm_buttonSnClick(wxCommandEvent& event);
        void OnInit(wxInitDialogEvent& event);
        void OnF1Press(wxCommandEvent& event);

        void SetIPAddress(ADAPTER_TYPE adapterType);

		DECLARE_EVENT_TABLE()
};

#endif
