
#ifndef _PROFILE_EDITOR_H_
#define _PROFILE_EDITOR_H_

#include "xmlparser/tinyxml.h"
#include "Profile.h"

const string ROOT( "profile" );
const string VALUE("value");

const string PERMISSION( "permission" );
const string PRIORITY( "priority" );
const string ICON( "icon" );
const string SHOW( "show" );

const string GENERNALSETTINGS( "GenernalSettings" );

const string CONNECTTYPE( "ConnectType" );
const string AUTHENTICATION( "Authentication" );
const string DAUTHENTICATION( "detailvalue" );
const string ISDISCONNECT( "DisconnectNet" );

const string WIRELESSSETTINGS( "WirelessSettings" );

const string SSID( "SSID" );
const string WIRELESSTYPE( "WirlessType" );
const string WLANSECURITY( "WlanSecurity" );
const string WEPSETTINGS( "WEPSettings" );
const string KEY_INDEX( "KeyIndex" );
const string WPASETTINGS( "WPASettings" );

const string OTHERSETTINGS( "OtherSettings" );

const string NETSECURITY( "NetworkSecurity" );
const string FORBIDFILE( "ForbidShareFileAndPrint" );
const string FORBIDINTERNET( "ForbidShareInternet" );
const string STARTFIREWALL( "StartWindowFirewall" );
const string AUTORUNAPPFLAG( "AutoRunAppFlag" );
const string AUTORUNAPP( "AutoRun" );
const string IPDNS( "IPDNS" );
const string IPVALUE( "IPvalue" );
const string SUBNET( "SubnetAddress" );
const string NETGATE( "NetGateway" );
const string DNSVALUE( "DNSvalue" );
const string HOMEPAGEFLAG( "HomepageFlag" );
const string HOMEPAGE( "Homepage" );
const string PROXYFLAG( "ProxyFlag" );
const string PROXY( "Proxy" );
const string PORT( "Port" );
const string USER( "User" );
const string PASSWORD( "Password" );

class ProfileEditor
{
public:
    ProfileEditor();
    ~ProfileEditor();

    int ReadProfile( ProfileList_t &tagProfile, const char *pcFileName );
    int WriteProfile( ProfileList_t &tagProfile, const char *pcFileName, const char * pcPriority = NULL );
    int DeleteProfile( const char * pcFileName );
    int EditProfile( ProfileList_t &tagprofile, const char *pcFileName, const char * pcPriority = NULL );
    int GetGeneralSettings( GenernalSettings_t &stGeneral, const char *pcFileName );
    int GetWirelessSettings( WirelessSettings_t &stWireless, const char *pcFileName );
    int GetOtherSettings( OtherSettings_t &stOther, const char *pcFileName );

private:
    string EncryptPassword(const string& orpassword);
    string DecryptPassword(const string& enpassword);
};

#endif // _PROFILE_EDITOR_H_
