#ifndef VIEWAPNEIGHBORSDLG_H
#define VIEWAPNEIGHBORSDLG_H

//(*Headers(ViewAPNeighborsDlg)
#include <wx/listctrl.h>
#include <wx/stattext.h>
#include <wx/statline.h>
#include <wx/statbmp.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)

#include <wx/event.h>
#include <wx/timer.h>

#if defined(__WXMSW__)
#include <windows.h>
#include "Winnetwk.h"
//#include <wx/socket.h>
#endif

#if defined(__UNIX__)
#include "ScanEvent.h"
#endif

#include "GaugeDialog.h"

#define MAX_HOST_NAME_LEN 200
#define MAX_IPADDR_LEN 15
#define MAX_IPADDR_NUM 255

/** Definition of AP Neighbors Information. */
typedef struct AP_NEIGHBORS_INFO_S
{
	wchar_t HostName[MAX_HOST_NAME_LEN];		/**< The neighbors host name. */
	wxString IPAddress;	    /**< The neighbors IP Address. */
} AP_NEIGHBORS_INFO, *PAP_NEIGHBORS_INFO;


class ViewAPNeighborsDlg: public wxDialog
{
public:
    ViewAPNeighborsDlg(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
    virtual ~ViewAPNeighborsDlg();

    AP_NEIGHBORS_INFO* m_pNeighborsInfo;
    int m_count;
    virtual bool Show(bool show = true);
    void UpdateApNeighborsInfo(PAP_NEIGHBORS_INFO ap_NeighborsInfo, int iCount, int searchIndex);
#if defined(__UNIX__)
    void ScanOver(ScanEvent& event);
#endif

protected:
    //(*Identifiers(ViewAPNeighborsDlg)
    static const long ID_STATICBITMAP_VIEWAPNEIGHBORS;
    static const long ID_BUTTON_OKVIEWAPNEIGHBORS;
    static const long ID_STATICTEXT_VIEWAPNEIGHBORSTIP;
    static const long ID_LISTCTRL_VIEWAPNEIGHBORS;
    static const long ID_BUTTON_REFRESHVIEWAPNEIGHBORS;
    static const long ID_BUTTON_CANCELVIEWAPNEIGHBORS;
    static const long ID_STATICLINE1;
    //*)
    static const long ID_STATICTEXT_VIEWAPNEIGHBORSFIREWALLTIP;

    //(*Declarations(ViewAPNeighborsDlg)
    wxStaticBitmap* StaticBitmap_ViewApNeighbors;
    wxButton* Button_OKViewAPNeighbors;
    wxStaticText* StaticText_ViewApNieghborsTip;
    wxButton* Button_CancelViewApNeighbors;
    wxButton* Button_RefreshViewApNeighbors;
    wxStaticLine* StaticLine1;
    wxListCtrl* ListCtrl_ViewApNeighbors;
    //*)
    wxStaticText* StaticText_ViewApNieghborsFireWallTip;

    static const long ID_TIMER_VIEWNEIGHBOR;
    static const long ID_HELP;

private:
    class ScanThread : public wxThread
    {
        public:
            ScanThread();
            ScanThread(ViewAPNeighborsDlg* pViewAPNeighborsDlg, int searchIndex = 0);
            virtual ~ScanThread();
            virtual void* Entry();
            virtual void OnExit();
        private:
            const int m_iSearchIndex;
            ViewAPNeighborsDlg* m_pViewAPNeighborsDlg;
    };

    bool m_isSearching;
    int m_iSearchCount;
    AP_NEIGHBORS_INFO* m_apNeighborsInfo;
    ScanThread* m_pScanThread;
    GaugeDialog* m_pGaugeDialog;

    //(*Handlers(ViewAPNeighborsDlg)
    void OnInit(wxInitDialogEvent& event);
    void OnButton_CancelViewApNeighborsClick(wxCommandEvent& event);
    void OnButton_RefreshViewApNeighborsClick(wxCommandEvent& event);
    void OnButton_OKViewAPNeighborsClick(wxCommandEvent& event);
    void OnButton_RefreshViewApNeighborsClick1(wxCommandEvent& event);
    //*)

    void OnClose(wxCloseEvent& event);

#if defined(__UNIX__)
    wxString ParseIPAddFile(void);
#endif
    bool BeginSearchAPNeighbors();
    void OnF1Press(wxCommandEvent& event);
    DECLARE_EVENT_TABLE()
};

#endif
