
#ifndef _CHECKED_LISTCTRL_H_
#define _CHECKED_LISTCTRL_H_

#include <wx/listctrl.h>
#include <wx/imaglist.h>

#define CHECKED_LIST_CONTROL_UNCHECKED_IMAGE_INDEX				0		// unchecked & enabled
#define CHECKED_LIST_CONTROL_CHECKED_IMAGE_INDEX				1		// checked & enabled
#define CHECKED_LIST_CONTROL_DISABLED_UNCHECKED_IMAGE_INDEX		2		// unchecked & disabled
#define CHECKED_LIST_CONTROL_DISABLED_CHECKED_IMAGE_INDEX		3		// checked & disabled

#define wxLIST_STATE_CHECKED			0x010000
#define wxLIST_STATE_ENABLED			0x100000

#define wxCLC_CHECK_WHEN_SELECTING		0x10000

//DECLARE_EXPORTED_EVENT_TYPE(WXDLLIMPEXP_WEBUPDATE, wxEVT_COMMAND_LIST_ITEM_CHECKED, -1);
//DECLARE_EXPORTED_EVENT_TYPE(WXDLLIMPEXP_WEBUPDATE, wxEVT_COMMAND_LIST_ITEM_UNCHECKED, -1);

#define EVT_LIST_ITEM_CHECKED(id, fn) \
        DECLARE_EVENT_TABLE_ENTRY( wxEVT_COMMAND_LIST_ITEM_CHECKED, id, -1, \
        (wxObjectEventFunction)(wxEventFunction)(wxListEventFunction)&fn, (wxObject*)NULL ),

#define EVT_LIST_ITEM_UNCHECKED(id, fn) \
        DECLARE_EVENT_TABLE_ENTRY( wxEVT_COMMAND_LIST_ITEM_UNCHECKED, id, -1, \
        (wxObjectEventFunction)(wxEventFunction)(wxListEventFunction)&fn, (wxObject*)NULL ),

// class wxCheckedListCtrl
class wxCheckedListCtrl : public wxListCtrl
{

public:
	wxCheckedListCtrl();

	wxCheckedListCtrl(wxWindow *parent, wxWindowID id = -1, const wxPoint& pt = wxDefaultPosition,
            const wxSize& sz = wxDefaultSize, long style = wxCLC_CHECK_WHEN_SELECTING,
            const wxValidator& validator = wxDefaultValidator, const wxString& name = wxListCtrlNameStr);

	bool Create(wxWindow *parent, wxWindowID id = -1, const wxPoint& pos = wxDefaultPosition,
            const wxSize& size = wxDefaultSize, long style = wxCLC_CHECK_WHEN_SELECTING,
            const wxValidator& validator = wxDefaultValidator, const wxString& name = wxListCtrlNameStr);

	virtual ~wxCheckedListCtrl();

    wxImageList m_lstImageList;
    void EnableCheck(int itemIndex);

	bool GetItem(wxListItem& item) const;
	bool SetItem(wxListItem& item);
	bool DeleteItem(long itemIndex);
    long InsertItem(wxListItem& item);
	bool DeleteAllItems();

	bool SortItems(wxListCtrlCompare func, long data);

	void Enable(long itemIndex, bool bEnable);
	void EnableAll(bool bEnable = true);
	void Check(long itemIndex, bool bChecked);
	void CheckAll(bool bChecked = true);

	virtual bool Enable(bool isEnable = true);

	bool IsEnabled(long itemIndex) const;
	bool IsChecked(long itemIndex) const;
	bool IsEnabled() const;
	int GetCheckedItemCount() const;

	int GetItemState(long itemIndex, long lStateMask) const;
	bool SetItemState(long itemIndex, long lState, long lStateMask);
	long SetItem(long itemIndex, int column, const wxString& label, int imageId = -1);
    long InsertItem( long itemIndex, const wxString& label, int imageIndex = -1);
    bool SetItemStateOri(long itemIndex, long lState, long lStateMask);

protected:
	wxArrayInt m_lstStateList;
    int  m_iEnableCheckRow;

	void OnMouseEvent(wxMouseEvent& event);

	static int GetExStateItemImage(int iAddState);
	static int GetAndRemoveAdditionalState(long* plState, int iStateMask);
	wxColour GetExStateBackgroundColour(int iExState);

private:
	DECLARE_CLASS(wxCheckedListCtrl)
	DECLARE_EVENT_TABLE()
};

#endif	// _CHECKED_LISTCTRL_H_

